/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.F32;
import ca.jamdat.flight.FrameworkGlobals;

public class FlMath {
    public static final int maxInt8Value = 127;
    public static final int minInt8Value = -128;
    public static final int maxInt16Value = Short.MAX_VALUE;
    public static final int minInt16Value = Short.MIN_VALUE;
    public static final int maxInt32Value = Integer.MAX_VALUE;
    public static final int minInt32Value = -2147483647;
    public static float epsilon;
    public static float twoPi;
    public static float Pi;
    public static int[] SIN_TABLE;

    public static int IntegerSqrt(int n) {
        return 0;
    }

    public static short Random(short s, short s2) {
        if (s2 == s) {
            return s;
        }
        return (short)(s + FlMath.Rand(true) % (s2 - s + 1));
    }

    public static int Random(int n, int n2) {
        if (n2 == n) {
            return n;
        }
        return n + FlMath.Rand() % (n2 - n + 1);
    }

    public static int Rand(boolean bl) {
        int n;
        int n2 = n = FrameworkGlobals.GetInstance().randomState;
        if (!bl) {
            long l = n;
            l = (long)n * 214013L + 2531011L;
            n2 = (int)(l >> 32) & Integer.MAX_VALUE;
            FrameworkGlobals.GetInstance().randomState = (int)l;
        } else {
            n = n * 214013 + 2531011;
            n2 = n >> 16 & Short.MAX_VALUE;
            FrameworkGlobals.GetInstance().randomState = n;
        }
        return n2;
    }

    public static void Seed(int n) {
        FrameworkGlobals.GetInstance().randomState = n;
    }

    public static int Modulo(int n, int n2) {
        if ((n %= n2) < 0) {
            n += n2;
        }
        return n;
    }

    public static int Sin1024(int n) {
        while (n > 360) {
            n -= 360;
        }
        while (n < 0) {
            n += 360;
        }
        if (n >= 0 && n <= 90) {
            return SIN_TABLE[n];
        }
        if (n > 90 && n <= 180) {
            return SIN_TABLE[180 - n];
        }
        if (n > 180 && n <= 270) {
            return -SIN_TABLE[n - 180];
        }
        return -SIN_TABLE[360 - n];
    }

    public static int Cos1024(int n) {
        while (n > 360) {
            n -= 360;
        }
        while (n < 0) {
            n += 360;
        }
        if (n >= 0 && n <= 90) {
            return SIN_TABLE[90 - n];
        }
        if (n > 90 && n <= 180) {
            return -SIN_TABLE[n - 90];
        }
        if (n > 180 && n <= 270) {
            return -SIN_TABLE[270 - n];
        }
        return SIN_TABLE[n - 270];
    }

    public static byte Absolute(byte by) {
        if (by < 0) {
            by = -by;
        }
        return by;
    }

    public static short Absolute(short s) {
        if (s < 0) {
            s = -s;
        }
        return s;
    }

    public static int Absolute(int n) {
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    public static long Absolute(long l) {
        if (l < 0L) {
            l = -l;
        }
        return l;
    }

    public static F32 Absolute(F32 f32) {
        return f32.Abs();
    }

    public static byte Minimum(byte by, byte by2) {
        if (by < by2) {
            by2 = by;
        }
        return by2;
    }

    public static short Minimum(short s, short s2) {
        if (s < s2) {
            s2 = s;
        }
        return s2;
    }

    public static int Minimum(int n, int n2) {
        if (n < n2) {
            n2 = n;
        }
        return n2;
    }

    public static long Minimum(long l, long l2) {
        if (l < l2) {
            l2 = l;
        }
        return l2;
    }

    public static F32 Minimum(F32 f32, F32 f322) {
        return f32.LessThan(f322) ? f32 : f322;
    }

    public static byte Maximum(byte by, byte by2) {
        if (by > by2) {
            by2 = by;
        }
        return by2;
    }

    public static short Maximum(short s, short s2) {
        if (s > s2) {
            s2 = s;
        }
        return s2;
    }

    public static int Maximum(int n, int n2) {
        if (n > n2) {
            n2 = n;
        }
        return n2;
    }

    public static long Maximum(long l, long l2) {
        if (l > l2) {
            l2 = l;
        }
        return l2;
    }

    public static F32 Maximum(F32 f32, F32 f322) {
        return f32.GreaterThan(f322) ? f32 : f322;
    }

    public static boolean IsOdd(int n) {
        return (n & 1) == 1;
    }

    public static boolean IsEven(int n) {
        return (n & 1) == 0;
    }

    public static boolean IsPowerOf2(int n) {
        return (n & n - 1) == 0;
    }

    public static int GetPowerOf2(int n) {
        if (!FlMath.IsPowerOf2(n)) {
            return -1;
        }
        int n2 = 0;
        while (n >> n2 != 0) {
            ++n2;
        }
        return n2 - 1;
    }

    public static int GetNextPowerOf2(int n) {
        if (FlMath.IsPowerOf2(n)) {
            return n;
        }
        int n2 = 0;
        while (n >> n2 != 0) {
            ++n2;
        }
        return 1 << n2;
    }

    public static int Pow(int n, int n2) {
        if (n == 0 || n2 < 0) {
            return 0;
        }
        if (n2 == 0) {
            return 1;
        }
        int n3 = 1;
        while (n2 != 0) {
            if ((n2 & 1) == 1) {
                n3 *= n;
            }
            n *= n;
            n2 >>= 1;
        }
        return n3;
    }

    public static float Sqrt(float f) {
        return 0.0f;
    }

    public static float ArcTan(float f, float f2) {
        return 0.0f;
    }

    public static float Absolute(float f) {
        return f < 0.0f ? -f : f;
    }

    public static float Minimum(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public static float Maximum(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static int Round(float f) {
        return 0;
    }

    public static int Floor(float f) {
        return 0;
    }

    public static int Ceiling(float f) {
        return 0;
    }

    public static float SubtractFloor(float f) {
        return f - (float)FlMath.Floor(f);
    }

    public static boolean AbnormalValue(double d) {
        return false;
    }

    public static void CheckForAbnormalValue(double d) {
    }

    public static float NearExponentialDecay(float f) {
        return 0.0f;
    }

    public static float GetUniformRandom(float f, float f2) {
        return 0.0f;
    }

    public static float GetGaussianRandom(float f, float f2) {
        return 0.0f;
    }

    public static int Rand() {
        return FlMath.Rand(false);
    }

    public static float GetUniformRandom() {
        return FlMath.GetUniformRandom(0.0f);
    }

    public static float GetUniformRandom(float f) {
        return FlMath.GetUniformRandom(f, 1.0f);
    }

    public static float GetGaussianRandom() {
        return FlMath.GetGaussianRandom(0.0f);
    }

    public static float GetGaussianRandom(float f) {
        return FlMath.GetGaussianRandom(f, 1.0f);
    }

    public static FlMath[] InstArrayFlMath(int n) {
        FlMath[] flMathArray = new FlMath[n];
        for (int i = 0; i < n; ++i) {
            flMathArray[i] = new FlMath();
        }
        return flMathArray;
    }

    public static FlMath[][] InstArrayFlMath(int n, int n2) {
        FlMath[][] flMathArray = new FlMath[n][];
        for (int i = 0; i < n; ++i) {
            flMathArray[i] = new FlMath[n2];
            for (int j = 0; j < n2; ++j) {
                flMathArray[i][j] = new FlMath();
            }
        }
        return flMathArray;
    }

    public static FlMath[][][] InstArrayFlMath(int n, int n2, int n3) {
        FlMath[][][] flMathArray = new FlMath[n][][];
        for (int i = 0; i < n; ++i) {
            flMathArray[i] = new FlMath[n2][];
            for (int j = 0; j < n2; ++j) {
                flMathArray[i][j] = new FlMath[n3];
                for (int k = 0; k < n3; ++k) {
                    flMathArray[i][j][k] = new FlMath();
                }
            }
        }
        return flMathArray;
    }

    static {
        SIN_TABLE = new int[]{0, 18, 36, 54, 71, 89, 107, 125, 143, 160, 178, 195, 213, 230, 248, 265, 282, 299, 316, 333, 350, 367, 384, 400, 416, 433, 449, 465, 481, 496, 512, 527, 543, 558, 573, 587, 602, 616, 630, 644, 658, 672, 685, 698, 711, 724, 737, 749, 761, 773, 784, 796, 807, 818, 828, 839, 849, 859, 868, 878, 887, 896, 904, 912, 920, 928, 935, 943, 949, 956, 962, 968, 974, 979, 984, 989, 994, 998, 1002, 1005, 1008, 1011, 1014, 1016, 1018, 1020, 1022, 1023, 1023, 1024, 1024};
    }
}

