/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlBufferChunkInfo;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.Memory;

public class FlByteBuffer {
    public int mCapacity;
    public int mLimit;
    public int mPosition;
    public int mMark;
    public FlBufferChunkInfo mStartChunk;
    public FlBufferChunkInfo mPositionChunk;

    public static FlByteBuffer Allocate(int n) {
        return new FlByteBuffer(n);
    }

    public void destruct() {
        FlBufferChunkInfo flBufferChunkInfo = this.mStartChunk;
        while (flBufferChunkInfo != null) {
            FlBufferChunkInfo flBufferChunkInfo2 = flBufferChunkInfo;
            flBufferChunkInfo = flBufferChunkInfo2.mNextPtr;
            flBufferChunkInfo2.mData = null;
            flBufferChunkInfo2 = null;
        }
    }

    public int GetCapacity() {
        return this.mCapacity;
    }

    public int GetLimit() {
        return this.mLimit;
    }

    public void SetLimit(int n) {
        if (this.mPosition > n) {
            this.mPositionChunk = this.FindChunk(n, this.mPositionChunk);
            this.mPosition = n;
        }
        if (this.mMark != -1 && this.mMark > n) {
            this.mMark = -1;
        }
        this.mLimit = n;
    }

    public int GetPosition() {
        return this.mPosition;
    }

    public void SetPosition(int n) {
        if (this.mMark != -1 && this.mMark > n) {
            this.mMark = -1;
        }
        this.mPositionChunk = this.FindChunk(n, this.mPositionChunk);
        this.mPosition = n;
    }

    public boolean HasRemaining() {
        return this.GetRemaining() > 0;
    }

    public int GetRemaining() {
        return this.mLimit - this.mPosition;
    }

    public void Mark() {
        this.mMark = this.mPosition;
    }

    public void Reset() {
        this.mPositionChunk = this.FindChunk(this.mMark, this.mPositionChunk);
        this.mPosition = this.mMark;
    }

    public void Clear() {
        this.mPosition = 0;
        this.mPositionChunk = this.mStartChunk;
        this.mLimit = this.mCapacity;
        this.mMark = -1;
    }

    public void Flip() {
        this.mLimit = this.mPosition;
        this.mPosition = 0;
        this.mPositionChunk = this.mStartChunk;
        this.mMark = -1;
    }

    public void Rewind() {
        this.mPosition = 0;
        this.mPositionChunk = this.mStartChunk;
        this.mMark = -1;
    }

    public void Put(byte by) {
        this.mPositionChunk.mData[this.mPosition - this.mPositionChunk.mStartOffset] = by;
        ++this.mPosition;
        this.mPositionChunk = this.FindChunk(this.mPosition, this.mPositionChunk);
    }

    public void Put(byte by, int n) {
        FlBufferChunkInfo flBufferChunkInfo = this.FindChunk(n, this.mStartChunk);
        flBufferChunkInfo.mData[n - flBufferChunkInfo.mStartOffset] = by;
    }

    public void Put(byte[] byArray, int n, int n2) {
        this.BulkCopy(byArray, n, n2, -1, true);
    }

    public void Put(byte[] byArray, int n, int n2, int n3) {
        this.BulkCopy(byArray, n, n2, n3, true);
    }

    public byte Get() {
        byte by = this.mPositionChunk.mData[this.mPosition - this.mPositionChunk.mStartOffset];
        ++this.mPosition;
        this.mPositionChunk = this.FindChunk(this.mPosition, this.mPositionChunk);
        return by;
    }

    public byte Get(int n) {
        FlBufferChunkInfo flBufferChunkInfo = this.FindChunk(n, this.mStartChunk);
        byte by = flBufferChunkInfo.mData[n - flBufferChunkInfo.mStartOffset];
        return by;
    }

    public void Get(byte[] byArray, int n, int n2) {
        this.BulkCopy(byArray, n, n2, -1, false);
    }

    public void Get(byte[] byArray, int n, int n2, int n3) {
        this.BulkCopy(byArray, n, n2, n3, false);
    }

    public void Compact() {
        for (int i = 0; i < this.GetRemaining(); ++i) {
            this.Put(this.Get(this.mPosition + i), i);
        }
        this.mPosition = this.GetRemaining();
        this.mPositionChunk = this.FindChunk(this.mPosition, this.mPositionChunk);
        this.mLimit = this.mCapacity;
        this.mMark = -1;
    }

    public FlByteBuffer(int n) {
        int n2 = 0;
        int n3 = n;
        FlBufferChunkInfo flBufferChunkInfo = null;
        FlBufferChunkInfo flBufferChunkInfo2 = null;
        while (n2 < n) {
            flBufferChunkInfo2 = this.AllocChunk(n3, n2);
            n2 += flBufferChunkInfo2.mSize;
            if (flBufferChunkInfo == null) {
                this.mStartChunk = flBufferChunkInfo2;
            } else {
                flBufferChunkInfo.mNextPtr = flBufferChunkInfo2;
                flBufferChunkInfo2.mPrevPtr = flBufferChunkInfo;
            }
            n3 = FlMath.Minimum(flBufferChunkInfo2.mSize, n - n2);
            flBufferChunkInfo = flBufferChunkInfo2;
        }
        this.mPosition = 0;
        this.mLimit = n;
        this.mCapacity = n;
        this.mMark = -1;
        this.mPositionChunk = this.mStartChunk;
    }

    public FlBufferChunkInfo AllocChunk(int n, int n2) {
        byte[] byArray = new byte[n];
        while (byArray == null) {
            byArray = new byte[n >>= 1];
        }
        FlBufferChunkInfo flBufferChunkInfo = new FlBufferChunkInfo();
        flBufferChunkInfo.mStartOffset = n2;
        flBufferChunkInfo.mSize = n;
        flBufferChunkInfo.mData = byArray;
        flBufferChunkInfo.mNextPtr = null;
        flBufferChunkInfo.mPrevPtr = null;
        return flBufferChunkInfo;
    }

    public FlBufferChunkInfo FindChunk(int n, FlBufferChunkInfo flBufferChunkInfo) {
        if (n == this.mLimit) {
            --n;
        }
        if (n < flBufferChunkInfo.mStartOffset) {
            return this.FindChunk(n, flBufferChunkInfo.mPrevPtr);
        }
        if (n >= flBufferChunkInfo.mStartOffset + flBufferChunkInfo.mSize) {
            return this.FindChunk(n, flBufferChunkInfo.mNextPtr);
        }
        return flBufferChunkInfo;
    }

    public void BulkCopy(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4;
        FlBufferChunkInfo flBufferChunkInfo;
        int n5 = n3 == -1 ? this.mPosition : n3;
        FlBufferChunkInfo flBufferChunkInfo2 = flBufferChunkInfo = n3 == -1 ? this.mPositionChunk : this.FindChunk(n3, this.mStartChunk);
        for (int i = 0; i < n2; i += n4) {
            int n6 = n5 - flBufferChunkInfo.mStartOffset;
            int n7 = flBufferChunkInfo.mSize - n6;
            n4 = FlMath.Minimum(n7, n2 - i);
            if (bl) {
                Memory.Copy(flBufferChunkInfo.mData, n6, byArray, n + i, n4);
            } else {
                Memory.Copy(byArray, n + i, flBufferChunkInfo.mData, n6, n4);
            }
            flBufferChunkInfo = this.FindChunk(n5 += n4, flBufferChunkInfo);
        }
        if (n3 == -1) {
            this.mPosition = n5;
            this.mPositionChunk = flBufferChunkInfo;
        }
    }
}

