/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BlArray;
import ca.jamdat.flight.BlString;
import ca.jamdat.flight.BlStringBuffer;

public class BlStringBufferUtf16
extends BlStringBuffer {
    public char[] mCharacters = null;

    public BlStringBufferUtf16(int n) {
        super(BlString.ENC_UTF16BE);
        this.mCharacters = new char[n];
        this.mCapacity = n;
    }

    public BlStringBufferUtf16(byte[] byArray, int n, int n2) {
        super(BlString.ENC_UTF16BE);
        int n3 = n2 >> 1;
        this.mCharacters = new char[n3];
        this.mCapacity = n3;
        this.mLength = n3;
        for (int i = 0; i < n3; ++i) {
            int n4 = n + i;
            int n5 = byArray[n4] & 0xFF;
            int n6 = byArray[n4 + 1] & 0xFF;
            this.mCharacters[i] = (char)(n5 << 8 | n6);
        }
    }

    public BlStringBufferUtf16(char[] cArray, int n, int n2, int n3) {
        super(BlString.ENC_UTF16BE);
        if (n3 == 0) {
            this.mCharacters = new char[n2];
            this.mCapacity = n2;
            this.mLength = n2;
            BlArray.Copy(cArray, n, this.mCharacters, 0, n2);
        } else {
            this.mCharacters = cArray;
            this.mOffset = n;
            this.mLength = n2;
            this.mCapacity = BlStringBuffer.IMMUTABLE_CAPACITY;
        }
    }

    public void destruct() {
        if (this.IsMutable()) {
            this.mCharacters = null;
        }
    }

    public char GetCharAt(int n) {
        return this.mCharacters[this.mOffset + n];
    }

    public void SetCharAt(int n, char c) {
        this.mCharacters[n] = c;
    }

    public void AppendChar(char c) {
        this.mCharacters[this.mLength++] = c;
    }

    public void SetLength(int n) {
        if (n <= 0) {
            this.mLength = 0;
        } else if (n <= this.mLength) {
            this.mLength = n;
        } else {
            this.EnsureCapacity(n);
            for (int i = this.mLength; i < n; ++i) {
                this.mCharacters[i] = 32;
            }
            this.mLength = n;
        }
    }

    public void EnsureCapacity(int n) {
        if (n > this.mCapacity) {
            char[] cArray = this.mCharacters;
            this.mCharacters = new char[n];
            BlArray.Copy(cArray, this.mOffset, this.mCharacters, 0, this.mLength);
            cArray = null;
            this.mCapacity = n;
            this.mOffset = 0;
        }
    }

    public BlStringBufferUtf16(BlStringBufferUtf16 blStringBufferUtf16) {
    }
}

