/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class SOUND
implements PlayerListener {
    static SOUND sound = null;
    static final int MAX_MIDI = 8;
    Player[] player = new Player[8];
    String[] szFileName = new String[]{"title.mid", "field.mid", "attack.mid", "skill1.mid", "skill2.mid", "menumove.mid", "levelup.mid", "miss.mid"};
    int[] bytesFileName = new int[]{2790, 3221, 110, 1764, 397, 116, 318, 906};
    byte[][] midData = new byte[8][];
    InputStream[] midStream = new InputStream[8];
    int nowPlaying = -1;
    int nextPlaying = -1;
    boolean isPlay = false;

    void loadMid() {
        try {
            for (int i = 0; i < 8; ++i) {
                InputStream inputStream = Runtime.getRuntime().getClass().getResourceAsStream("/" + this.szFileName[i]);
                this.midData[i] = new byte[this.bytesFileName[i]];
                inputStream.read(this.midData[i]);
                inputStream.close();
                this.midStream[i] = new ByteArrayInputStream(this.midData[i]);
                this.player[i] = Manager.createPlayer((InputStream)this.midStream[i], (String)"audio/midi");
                this.player[i].addPlayerListener((PlayerListener)this);
                this.player[i].realize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    SOUND() {
        this.loadMid();
    }

    static SOUND getInstance() {
        if (sound == null) {
            sound = new SOUND();
        }
        return sound;
    }

    void play(int n) {
        if (!RagMerchant.gc.isSound) {
            return;
        }
        if (this.isPlay && n != 0 && n != 1 && n != 6) {
            return;
        }
        if (this.isPlay && n == 6) {
            this.nextPlaying = 6;
            return;
        }
        this.stop();
        if (this.isPlay) {
            if (n == 0 || n == 1 || n == 6) {
                this.rePlay(n);
            }
            return;
        }
        try {
            this.isPlay = true;
            this.player[n].start();
            this.nowPlaying = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void rePlay(int n) {
        this.nextPlaying = n;
    }

    void stop() {
        if (!RagMerchant.gc.isSound || this.nowPlaying == -1) {
            return;
        }
        try {
            if (this.player[this.nowPlaying].getState() == 400) {
                this.player[this.nowPlaying].setMediaTime(0L);
                this.player[this.nowPlaying].stop();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string.equals("stopped") || string.equals("endOfMedia")) {
            this.isPlay = false;
            this.nowPlaying = -1;
            if (this.nextPlaying != -1) {
                this.play(this.nextPlaying);
                this.nextPlaying = -1;
            }
        } else if (string.equals("started")) {
            this.isPlay = true;
        }
    }
}

