/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class HighScores
extends SceneImpl
implements IMG_DATA {
    private static int MAX_POSITIONS = 10;
    private static String[] _names = new String[MAX_POSITIONS];
    private static int[] _scores = new int[MAX_POSITIONS];
    private int _iActiveIndex = -1;
    private int _iActiveScores = 0;
    private final String STORE_NAME;
    private final int FH = DATA.fntSmallBold.getHeight();
    private static HighScores _instance = null;

    public static HighScores getInstance() {
        if (_instance == null) {
            _instance = new HighScores();
        }
        return _instance;
    }

    private HighScores() {
        this.STORE_NAME = "HighScores";
        _instance = this;
        for (int i = 0; i < MAX_POSITIONS; ++i) {
            HighScores._names[i] = "";
            HighScores._scores[i] = 0;
        }
        this.load();
    }

    public int getFX() {
        return 2;
    }

    public IImg getFXImage() {
        return ImgPanel.getInstance();
    }

    public void load() {
        try {
            if (Utils.hasRS("HighScores")) {
                RecordStore recordStore = RecordStore.openRecordStore((String)"HighScores", (boolean)false);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(1));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                for (int i = 0; i < MAX_POSITIONS; ++i) {
                    HighScores._names[i] = dataInputStream.readUTF();
                    HighScores._scores[i] = dataInputStream.readInt();
                }
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save() {
        try {
            try {
                if (Utils.hasRS("HighScores")) {
                    RecordStore.deleteRecordStore((String)"HighScores");
                }
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)"HighScores", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(200);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            for (int i = 0; i < MAX_POSITIONS; ++i) {
                dataOutputStream.writeUTF(_names[i]);
                dataOutputStream.writeInt(_scores[i]);
            }
            recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean tryAddPlayer(int n) {
        boolean bl = false;
        this._iActiveIndex = -1;
        if (n > _scores[MAX_POSITIONS - 1]) {
            this._iActiveScores = n;
            InputName.getInstance()._message = "your score is " + n;
            GameManager.getInstance().setScene(InputName.getInstance());
            bl = true;
        }
        return bl;
    }

    public void addPlayer(String string) {
        int n;
        for (n = 0; n < MAX_POSITIONS; ++n) {
            if (this._iActiveScores <= _scores[n]) continue;
            this._iActiveIndex = n;
            break;
        }
        for (n = MAX_POSITIONS - 1; n > this._iActiveIndex; --n) {
            HighScores._names[n] = _names[n - 1];
            HighScores._scores[n] = _scores[n - 1];
        }
        HighScores._names[this._iActiveIndex] = string;
        HighScores._scores[this._iActiveIndex] = this._iActiveScores;
        this.save();
        GameManager.getInstance().setScene(HighScores.getInstance());
    }

    public void onDeactivation() {
        this._iActiveScores = 0;
        this._iActiveIndex = -1;
    }

    public void onPressedCmd1() {
        MainMenu mainMenu = MainMenu.getInstance();
        mainMenu.setStartMenuIndex(3);
        GameManager.getInstance().setScene(mainMenu);
    }

    public void render(Graphics graphics, Rect rect) {
        try {
            int n;
            for (n = 0; n < DATA.SCR_BOTTOM; n += IMG_DATA.IMG_PANEL_BODY.getHeight()) {
                IMG_DATA.IMG_PANEL_BODY.draw(graphics, 0, n, 0, 0, rect);
            }
            IMG_DATA.IMG_PANEL_BORDER.draw(graphics, 0, 162, 0, 0, rect);
            IMG_DATA.IMG_TEXT_HIGHSCORES.draw(graphics, DATA.SCR_W2, 5, 1, 0, rect);
            IMG_DATA.IMG_TEXT_MENU.draw(graphics, 3, DATA.SCR_BOTTOM - 2, 8, 0, rect);
            graphics.setFont(DATA.fntSmallBold);
            for (n = 0; n < MAX_POSITIONS; ++n) {
                int n2 = 15 + n * this.FH;
                String string = "" + _scores[n];
                String string2 = _names[n];
                int n3 = DATA.SCR_RIGHT - 6;
                int n4 = n == this._iActiveIndex ? 0xFFFF00 : 0xD0D0D0;
                Utils.resetClip(graphics);
                Utils.drawText("" + (n + 1), graphics, 20, n2, 2, n4);
                Utils.drawText(string2, graphics, 25, n2, 0, n4);
                Utils.drawText(string, graphics, n3, n2, 2, n4);
                IMG_DATA.IMG_LINE.draw(graphics, DATA.SCR_W2, n2 + this.FH - 2, 9, 0, rect);
            }
            Utils.drawCmdL("MENU", graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

