/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Graphics;

class GameManager
extends FullCanvas
implements DATA,
Runnable {
    private boolean bError = false;
    private static GameManager _instance = null;
    private SceneImpl _scene = null;
    private boolean _bPaused = true;
    private boolean _bFullRepaint = true;
    private boolean _bVisible = false;
    private boolean _bPainted = false;
    private int _iFX;
    private boolean _bFXCompleted;
    private int _iFXFrame;
    private Rect _rcClip = new Rect();
    private IImg _imgFXBuffer = null;
    private int _FX_STEP;
    private int _FX_SUB_STEP;
    private int _iLockerOffset = 0;
    private IImg _imgBuffer = null;
    private long _lSoundInfo = Long.MIN_VALUE;
    private long _lHeapInfo = Long.MIN_VALUE;

    public GameManager() {
        this._reset_fx();
        Thread.currentThread().setPriority(10);
        Thread thread = new Thread(this);
        thread.start();
        thread.setPriority(1);
    }

    public static GameManager getInstance() {
        if (_instance == null) {
            _instance = new GameManager();
        }
        return _instance;
    }

    public void onChangedSoundState() {
        this._lSoundInfo = System.currentTimeMillis();
        this._bFullRepaint = true;
    }

    private void _reset_fx() {
        this._iFX = 0;
        this._bFXCompleted = true;
        this._iFXFrame = 0;
        this._FX_STEP = 100;
        this._imgFXBuffer = null;
        System.gc();
    }

    public boolean isPaused() {
        return this._bPaused;
    }

    public boolean isFullRepaint() {
        return this._bFullRepaint;
    }

    public boolean isVisible() {
        return this._bVisible;
    }

    public boolean isPainted() {
        return this._bPainted;
    }

    public SceneImpl getScene() {
        return this._scene;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScene(SceneImpl sceneImpl) {
        block12: {
            Runtime.getRuntime().gc();
            if (this._scene != null) {
                try {
                    this._scene.onDeactivation();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this._imgBuffer = null;
                if (this._scene.getFX() == 2) {
                    try {
                        this._imgBuffer = this._scene.getFXImage();
                    }
                    catch (Exception exception) {
                        this._imgBuffer = null;
                        exception.printStackTrace();
                    }
                }
            }
            this._scene = sceneImpl;
            this._bVisible = false;
            this._bPainted = false;
            this._reset_fx();
            this._bFullRepaint = true;
            Runtime.getRuntime().gc();
            if (this._scene == null) break block12;
            try {
                this._iFX = this._scene.getFX();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this._iFXFrame = 0;
            this._bFXCompleted = false;
            try {
                this._scene.onActivation();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private int _getGameAction(int n) {
        int n2 = n == DATA.KEY_LEFT ? 2 : (n == DATA.KEY_RIGHT ? 5 : (n == DATA.KEY_UP ? 1 : (n == DATA.KEY_DOWN ? 6 : (n == DATA.KEY_FIRE ? 8 : (n == 42 ? 0 : this.getGameAction(n))))));
        return n2;
    }

    protected void showNotify() {
        this._bPaused = true;
    }

    protected void hideNotify() {
        this._bPaused = false;
    }

    protected void keyPressed(int n) {
        if (n == -8) {
            // empty if block
        }
        if (!this._bVisible) {
            return;
        }
        try {
            int n2 = this._getGameAction(n);
            this._scene.onPressedKey(n, n2);
            if (this._bVisible) {
                switch (n2) {
                    case 1: {
                        this._scene.onPressedUp();
                        break;
                    }
                    case 6: {
                        this._scene.onPressedDown();
                        break;
                    }
                    case 2: {
                        this._scene.onPressedLeft();
                        break;
                    }
                    case 5: {
                        this._scene.onPressedRight();
                        break;
                    }
                    case 8: {
                        this._scene.onPressedFire();
                    }
                }
            }
            if (this._bVisible) {
                switch (n) {
                    case -6: {
                        this._scene.onPressedCmd1();
                        break;
                    }
                    case -7: {
                        this._scene.onPressedCmd2();
                        break;
                    }
                    case 42: {
                        Snd.reverseEnabled();
                        Snd_nok.reverseEnabled();
                    }
                }
            }
            if (this._bVisible) {
                this._scene.onPressedAnyKey();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void keyReleased(int n) {
        if (!this._bVisible) {
            return;
        }
        try {
            int n2 = this._getGameAction(n);
            this._scene.onReleasedKey(n, n2);
            if (this._bVisible) {
                switch (n2) {
                    case 1: {
                        this._scene.onUnpressedUp();
                        break;
                    }
                    case 6: {
                        this._scene.onUnpressedDown();
                        break;
                    }
                    case 2: {
                        this._scene.onUnpressedLeft();
                        break;
                    }
                    case 5: {
                        this._scene.onUnpressedRight();
                        break;
                    }
                    case 8: {
                        this._scene.onUnpressedFire();
                    }
                }
            }
            if (this._bVisible) {
                switch (n) {
                    case -6: {
                        this._scene.onUnpressedCmd1();
                        break;
                    }
                    case -7: {
                        this._scene.onUnpressedCmd2();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void keyRepeated(int n) {
        if (!this._bVisible) {
            return;
        }
        try {
            int n2 = this._getGameAction(n);
            this._scene.onRepeatedKey(n, n2);
            if (this._bVisible) {
                this.keyPressed(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void render_fx(Graphics graphics) {
        int n;
        int n2;
        if (this._imgFXBuffer == null) {
            this._imgFXBuffer = this._scene.getFXImage();
        }
        if (this._imgBuffer != null && this._imgFXBuffer != null) {
            if (this._iLockerOffset > 0) {
                --this._iLockerOffset;
                this._imgBuffer.draw(graphics, 0, 0, 0, 0, DATA._rcScreen);
                this.render_lockers(graphics);
                this._iFXFrame = 0;
                this._bFXCompleted = false;
                return;
            }
            n2 = DATA.PANEL_BOTTOM_HEIGHT;
            if (this._iFXFrame == 0) {
                this._FX_STEP = 1;
                this._FX_SUB_STEP = 1;
            }
            n = (DATA.SCR_HEIGHT - this._iFXFrame) * 174 / DATA.SCR_HEIGHT;
            int n3 = (DATA.SCR_HEIGHT - this._iFXFrame) * n2 / DATA.SCR_HEIGHT;
            this._rcClip.setBounds(0, n, DATA.SCR_WIDTH, DATA.SCR_HEIGHT - (n + n3));
            this._imgFXBuffer.draw(graphics, 0, 0, 0, 0, this._rcClip);
            this._rcClip.setBounds(0, 0, DATA.SCR_WIDTH, n);
            this._imgBuffer.draw(graphics, 0, -DATA.SCR_HEIGHT + n2 + n, 0, 0, this._rcClip);
            this._rcClip.setBounds(0, DATA.SCR_BOTTOM - n3, DATA.SCR_WIDTH, n3);
            this._imgBuffer.draw(graphics, 0, DATA.SCR_HEIGHT - 174 - n3, 0, 0, this._rcClip);
            this._iFXFrame = Math.min(DATA.SCR_HEIGHT, this._iFXFrame + this._FX_STEP);
            this._FX_STEP += this._FX_SUB_STEP;
            boolean bl = this._bFXCompleted = this._iFXFrame == DATA.SCR_HEIGHT;
            if (this._bFXCompleted) {
                this._bFXCompleted = false;
                this._iFXFrame = 0;
                this._imgBuffer = null;
                this._imgFXBuffer = null;
            } else {
                return;
            }
        }
        if (this._imgFXBuffer != null) {
            switch (this._iFX) {
                case 2: {
                    if (!this._bFXCompleted) {
                        n2 = DATA.PANEL_BOTTOM_HEIGHT;
                        if (this._iFXFrame == 0) {
                            this._FX_STEP = 1;
                            this._FX_SUB_STEP = 1;
                        }
                        n = this._iFXFrame * 174 / DATA.SCR_HEIGHT;
                        this._rcClip.setBounds(0, 0, DATA.SCR_WIDTH, n);
                        this._imgFXBuffer.draw(graphics, 0, -DATA.SCR_HEIGHT + n2 + n, 0, 0, this._rcClip);
                        n = this._iFXFrame * n2 / DATA.SCR_HEIGHT;
                        this._rcClip.setBounds(0, DATA.SCR_BOTTOM - n, DATA.SCR_WIDTH, n);
                        this._imgFXBuffer.draw(graphics, 0, DATA.SCR_HEIGHT - 174 - n, 0, 0, this._rcClip);
                        this._iFXFrame = Math.min(DATA.SCR_HEIGHT, this._iFXFrame + this._FX_STEP);
                        this._FX_STEP += this._FX_SUB_STEP;
                    }
                    this._bFXCompleted = this._iFXFrame == DATA.SCR_HEIGHT;
                    break;
                }
                case 1: {
                    int n4;
                    if (this._iFXFrame == 0) {
                        this._FX_STEP = 80;
                        this._FX_SUB_STEP = 20;
                    }
                    for (n4 = 0; n4 < DATA.SCR_HEIGHT && (n2 = this._iFXFrame - n4) >= 0; n4 += 2) {
                        if (n2 > DATA.SCR_WIDTH + this._FX_STEP + this._FX_SUB_STEP) continue;
                        if (n2 > DATA.SCR_WIDTH) {
                            n2 = DATA.SCR_WIDTH;
                        }
                        n = -DATA.SCR_WIDTH + n2;
                        this._rcClip.setBounds(n, n4, DATA.SCR_WIDTH, 1);
                        this._imgFXBuffer.draw(graphics, n, 0, 0, 0, this._rcClip);
                    }
                    for (n4 = 1; n4 < DATA.SCR_HEIGHT && (n2 = this._iFXFrame - n4) >= 0; n4 += 2) {
                        if (n2 > DATA.SCR_WIDTH - 1 + this._FX_STEP + this._FX_SUB_STEP) continue;
                        if (n2 > DATA.SCR_WIDTH) {
                            n2 = DATA.SCR_WIDTH;
                        }
                        n = DATA.SCR_WIDTH - n2;
                        this._rcClip.setBounds(n, n4, DATA.SCR_WIDTH, 1);
                        this._imgFXBuffer.draw(graphics, n, 0, 0, 0, this._rcClip);
                    }
                    this._iFXFrame = Math.min(DATA.SCR_WIDTH + DATA.SCR_HEIGHT, this._iFXFrame + this._FX_STEP);
                    this._FX_STEP = Math.max(25, this._FX_STEP - this._FX_SUB_STEP);
                    this._bFXCompleted = this._iFXFrame == DATA.SCR_WIDTH + DATA.SCR_HEIGHT;
                    break;
                }
                default: {
                    this._bFXCompleted = true;
                }
            }
        }
    }

    protected void render_lockers(Graphics graphics) {
        int n = IMG_DATA.IMG_LOCKERS[0].getWidth();
        int n2 = n - this._iLockerOffset;
        IMG_DATA.IMG_LOCKERS[0].draw(graphics, -n2, 159, 0, 0, DATA._rcScreen);
        IMG_DATA.IMG_LOCKERS[1].draw(graphics, DATA.SCR_WIDTH + n2, 159, 2, 0, DATA._rcScreen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics graphics) {
        block30: {
            if (this.bError) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    this.bError = false;
                }
            }
            try {
                if (this._scene == null) {
                    return;
                }
                try {
                    this.update_info();
                }
                catch (Exception exception) {
                    this.bError = true;
                    exception.printStackTrace();
                    Utils.resetClip(graphics);
                    graphics.setColor(0);
                    graphics.fillRect(0, 0, DATA.SCR_WIDTH, DATA.SCR_HEIGHT);
                    Utils.drawInfoText(">paint" + exception.toString(), graphics, DATA._rcScreen);
                    this.repaint();
                    Thread.yield();
                    return;
                }
                if (!(this._imgBuffer == null && this._iFX == 0 || this._bFXCompleted)) {
                    try {
                        this.render_fx(graphics);
                        this.render_info(graphics);
                    }
                    catch (Exception exception) {
                        this.bError = true;
                        exception.printStackTrace();
                        Utils.resetClip(graphics);
                        graphics.setColor(0);
                        graphics.fillRect(0, 0, DATA.SCR_WIDTH, DATA.SCR_HEIGHT);
                        Utils.drawInfoText(">paint" + exception.toString(), graphics, DATA._rcScreen);
                        this.repaint();
                        Thread.yield();
                        return;
                    }
                    if (this._bFXCompleted) {
                        this._reset_fx();
                    }
                    break block30;
                }
                try {
                    if (!this._bVisible) {
                        this._bVisible = true;
                        this._scene.onShow();
                    } else if (!this._bPainted) {
                        this._iLockerOffset = 0;
                        this._bPainted = true;
                        SceneImpl sceneImpl = this._scene;
                        this._scene.onPainted();
                        if (this._scene != sceneImpl) {
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    this._scene.render(graphics, DATA._rcScreen);
                    this.render_info(graphics);
                    if (this._scene != null && this._bPainted && this._scene.getFX() == 2) {
                        this.render_lockers(graphics);
                        int n = IMG_DATA.IMG_LOCKERS[0].getWidth();
                        if (this._iLockerOffset < IMG_DATA.IMG_LOCKERS[0].getWidth()) {
                            this._iLockerOffset = (this._iLockerOffset + n + 1) / 2;
                        }
                    }
                }
                catch (Exception exception) {
                    this.bError = true;
                    exception.printStackTrace();
                    Utils.resetClip(graphics);
                    graphics.setColor(0);
                    graphics.fillRect(0, 0, DATA.SCR_WIDTH, DATA.SCR_HEIGHT);
                    Utils.drawInfoText(">paint" + exception.toString(), graphics, DATA._rcScreen);
                    this.repaint();
                    Thread.yield();
                    return;
                }
                if (this._bVisible) {
                    this._bFullRepaint = false;
                }
            }
            finally {
                this.repaint();
                Thread.yield();
            }
        }
    }

    private void render_info(Graphics graphics) throws Exception {
        this.render_sound_info(graphics);
        this.render_heap_info(graphics);
    }

    private void update_info() throws Exception {
        if (this._lSoundInfo != Long.MIN_VALUE && System.currentTimeMillis() - this._lSoundInfo > 500L) {
            this._lSoundInfo = Long.MIN_VALUE;
            this._bFullRepaint = true;
            this.repaint();
        }
    }

    private void render_sound_info(Graphics graphics) throws Exception {
        try {
            if (this._lSoundInfo == Long.MIN_VALUE || System.currentTimeMillis() - this._lSoundInfo > 500L) {
                this._lSoundInfo = Long.MIN_VALUE;
                return;
            }
            int n = Snd.isEnabled() ? 0 : 1;
            DATA.IMG_SND_STATE[n].draw(graphics, DATA.SCR_RIGHT, 1, 2, 0, DATA._rcScreen);
        }
        catch (Exception exception) {
            throw new Exception(">render_sound_info " + exception.toString());
        }
    }

    private void render_heap_info(Graphics graphics) throws Exception {
        try {
            if (this._lHeapInfo == Long.MIN_VALUE || System.currentTimeMillis() - this._lHeapInfo > 1000L) {
                this._lHeapInfo = Long.MIN_VALUE;
                this._bFullRepaint = true;
                this.repaint();
                return;
            }
            Utils.resetClip(graphics);
            graphics.setFont(DATA.fntSmall);
            graphics.setColor(0);
            graphics.fillRect(DATA.SCR_RIGHT - 73, 0, 55, 15);
            graphics.setColor(0xFFFFFF);
            Utils.drawText((Runtime.getRuntime().totalMemory() + 1023L) / 1024L + "K/" + (Runtime.getRuntime().freeMemory() + 1023L) / 1024L + "K    ", graphics, DATA.SCR_RIGHT - 70, 0, 0, 0xFFFFFF);
        }
        catch (Exception exception) {
            throw new Exception(">render_heap_info " + exception.toString());
        }
    }

    public void run() {
        while (!Midlet._bTerminated) {
            this.repaint();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }
}

