/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Game
extends SceneImpl
implements SUPER_DATA {
    private static Game _instance = null;
    public static final String STORE_NAME = "GAME";
    public static final int MAX_LIFES = 3;
    public static final int STATE_LEVEL_BEGIN = 1;
    public static final int STATE_LEVEL_END = 2;
    public static final int STATE_GET_READY = 3;
    public static final int STATE_PLAYING = 4;
    public static final int STATE_FUCKED = 5;
    public static final int STATE_GAME_OVER = 6;
    public static final int STATE_YOU_WIN = 7;
    public static final int GAME_PART_START = 0;
    public static final int GAME_PART_ACC0 = 1;
    public static final int GAME_PART_GROUND = 2;
    public static final int GAME_PART_ACC1 = 3;
    public static final int GAME_PART_FLY = 4;
    public static final int GAME_PART_ACC2 = 5;
    public static final int GAME_PART_GROUND_FLY = 6;
    public static final int GAME_PART_ACC3 = 7;
    public static final int GAME_PART_GROUND_AND_FLY = 8;
    public static final int GAME_PART_SUPER_ACC = 9;
    public static final int GAME_PART_SMALL_GROUND_BOSSES = 10;
    public static final int GAME_PART_SMALL_FLY_BOSSES = 11;
    public static final int GAME_PART_SMALL_GROUND_AND_FLY_BOSSES = 12;
    public static final int GAME_PART_SUPER_ACC2 = 13;
    public static final int GAME_PART_BIG_BOSS = 14;
    public static final int GAME_PART_FINAL = 15;
    public static final int TIMEOUT_LEVEL_BEGIN = 1000;
    public static final int TIMEOUT_LEVEL_END = 2000;
    public static final int TIMEOUT_GET_READY = 1000;
    public static final int TIMEOUT_FUCKED = 2000;
    public static final int TIMEOUT_GAME_OVER = 3000;
    public static final int TIMEOUT_YOU_WIN = 3000;
    public static final int SHADOW_MIN = 10;
    public static final int SHADOW_MAX = 20;
    public static final int ENEMY_PLANE_TYPE_OFFSET = 100;
    public static final int ENEMY_TANK_TYPE_OFFSET = 100;
    public static int BONUS_AMMO2_COUNT = 15;
    public static int BONUS_AMMO3_COUNT = 3;
    public static final int TIME_PER_BONUS = 1;
    public static final int BOSS_APPEREANCE_TIME = 3000;
    public static final int MIN_LEVEL_DISTANCE = DATA.SCR_HEIGHT * 5;
    public static final int __GROUND_ENEMY_BASE_ID = 0;
    public static final int __FLY_ENEMY_BASE_ID = 1000;
    public static final int __LEFT_CANON_ENEMY_BASE_ID = 2000;
    public static final int __RIGHT_CANON_ENEMY_BASE_ID = 3000;
    public static final int BOSS_BASE_ID = 5000;
    private int _iPlayerAlpha = 0;
    private int _iCurScores = 0;
    private long _lStateTime = Long.MIN_VALUE;
    private boolean _bStatePressedAnyKey = false;
    private boolean _bStateDissactivated = false;
    private long _lGameStart = Long.MIN_VALUE;
    private long _lGameEnd = Long.MIN_VALUE;
    private boolean _bInteraction = false;
    public static long[] _SHIELDS_MAX_TIME = new long[]{30000L};
    public static int _iPlayer = 0;
    private GameData _data = new GameData();
    public static final int V_BORDER = 10;
    OBJ __tmpObj = new OBJ();
    Rect __tmpRC = new Rect();
    Rect __tmpRC0 = new Rect();
    final int SIDE_BORDER;
    final int ROAD_BORDER;
    final int THING_BORDER;
    private long _lSndExplosion = System.currentTimeMillis();
    private long _lSndBonus = System.currentTimeMillis();

    public Game() {
        this.SIDE_BORDER = 1;
        this.ROAD_BORDER = 25;
        this.THING_BORDER = 10;
    }

    public int getFX() {
        return 0;
    }

    public IImg getFXImage() {
        return ImgGround1.getInstance();
    }

    public static Game getInstance() {
        if (_instance == null) {
            _instance = new Game();
        }
        return _instance;
    }

    public static boolean hasSavedGame() {
        return Utils.hasRS(STORE_NAME);
    }

    public static void delSaveGame() {
        Utils.deleteRS(STORE_NAME);
    }

    public void continueGame() {
        Utils.Trace("continueGame()");
        this.load_game();
        this.continueGameTime();
        this._iCurScores = this._data._iScores;
        GameManager.getInstance().setScene(this);
    }

    public void startNewGame() {
        Utils.Trace("startNewGame()");
        this._data.reset();
        this.setState(1);
        this.startGameTime();
        this._data._iDifficulty = Settings.getInstance().getDifficulty();
        this._data.player.id = _iPlayer;
        this._data.player.iEnergy = this._data.player.iMaxEnergy = SUPER_DATA.PLAYER_ENERGY[this._data.player.id];
        this._iCurScores = this._data._iScores;
        GameManager.getInstance().setScene(this);
    }

    private void addLife() {
        if (this._data._iLifes < 3) {
            ++this._data._iLifes;
        } else {
            this._data.player.iEnergy = SUPER_DATA.PLAYER_ENERGY[this._data.player.id];
        }
    }

    private final void startGameTime() {
        this._data._lGameTime = 0L;
        this._lGameStart = System.currentTimeMillis();
        this._lGameEnd = Long.MIN_VALUE;
    }

    private final void continueGameTime() {
        this._lGameStart = System.currentTimeMillis();
        this._lGameEnd = Long.MIN_VALUE;
    }

    private final void pauseGameTime() {
        this._data._lGameTime = this.getGameTime();
        this._lGameStart = Long.MIN_VALUE;
        this._lGameEnd = Long.MIN_VALUE;
    }

    private final long getGameTime() {
        if (this._lGameStart == Long.MIN_VALUE) {
            return this._data._lGameTime;
        }
        if (this._lGameEnd == Long.MIN_VALUE) {
            return System.currentTimeMillis() - this._lGameStart + this._data._lGameTime;
        }
        return this._lGameEnd - this._lGameStart + this._data._lGameTime;
    }

    private final void setState(int n) {
        Utils.Trace("Game.setState(" + n + ")");
        this._data._iState = n;
        this._lStateTime = System.currentTimeMillis();
        this._bStatePressedAnyKey = false;
        this._bStateDissactivated = false;
        this._bInteraction = false;
        switch (this._data._iState) {
            case 1: {
                this._data.reset_level_data();
                this._data._bGamePaused = false;
                SND_DATA.SND_GAME_LEVEL_BEGIN.play();
                break;
            }
            case 2: {
                this._data.reset_level_data();
                SND_DATA.SND_GAME_LEVEL_END.play();
                break;
            }
            case 3: {
                this._bInteraction = true;
                for (int i = 0; i < this._data._iPlayerAmmoCount.length; ++i) {
                    this._data._iPlayerAmmoCount[i] = 0;
                }
                this._data.player.iEnergy = this._data.player.iMaxEnergy = SUPER_DATA.PLAYER_ENERGY[this._data.player.id];
                this._data.player.iGunType = 0;
                this._data.player.iGunMultiplier = 1;
                this._data.player.iGunFires = -10;
                SND_DATA.SND_GAME_GET_READY.play();
                break;
            }
            case 4: {
                this._bInteraction = true;
                SND_DATA.SND_GAME_PLAYING.play();
                break;
            }
            case 5: {
                this._bInteraction = true;
                SND_DATA.SND_GAME_FUCKED.play();
                break;
            }
            case 6: {
                Game.delSaveGame();
                SND_DATA.SND_GAME_OVER.play();
                break;
            }
            case 7: {
                Game.delSaveGame();
                SND_DATA.SND_GAME_YOU_WIN.play();
            }
        }
        GameManager.getInstance().setScene(this);
    }

    private final long getStateTimeout() {
        return System.currentTimeMillis() - this._lStateTime;
    }

    private final void StateKeyPressed() {
        if (this.getStateTimeout() > 750L) {
            this._bStatePressedAnyKey = true;
        }
    }

    private final boolean isPressedAnyKey() {
        return this._bStatePressedAnyKey;
    }

    private final boolean isDissactivated() {
        return this._bStateDissactivated;
    }

    private final void setStateDissactivated() {
        this._bStateDissactivated = true;
    }

    private void load_game() {
        if (!Game.hasSavedGame()) {
            this.startNewGame();
            return;
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
            this._data.fromBytes(recordStore.getRecord(1));
            recordStore.closeRecordStore();
            this._bInteraction = this._data._iState == 3 || this._data._iState == 4 || this._data._iState == 5;
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    private void save_game() {
        this.pauseGameTime();
        Game.delSaveGame();
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            byte[] byArray = this._data.toBytes();
            recordStore.addRecord(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void onActivation() {
    }

    public void onDeactivation() {
    }

    public void onPressedCmd1() {
        if (this._data._iState < 6) {
            this.save_game();
        } else {
            Game.delSaveGame();
        }
        MainMenu mainMenu = MainMenu.getInstance();
        mainMenu.setStartMenuIndex(1);
        GameManager.getInstance().setScene(mainMenu);
    }

    public void onPressedCmd2() {
        boolean bl = this._data._bGamePaused = !this._data._bGamePaused;
        if (this._data._bGamePaused) {
            this.pauseGameTime();
        } else {
            this.continueGameTime();
        }
    }

    public void onPressedAnyKey() {
        this.StateKeyPressed();
    }

    public void onPressedKey(int n, int n2) {
    }

    public void onPressedLeft() {
        if (this._data._bGamePaused) {
            return;
        }
        if (!this._bInteraction) {
            return;
        }
        this._data.player.iAX = -SUPER_DATA.PLAYER_ACC_X[this._data.player.id];
    }

    public void onPressedRight() {
        if (this._data._bGamePaused) {
            return;
        }
        if (!this._bInteraction) {
            return;
        }
        this._data.player.iAX = SUPER_DATA.PLAYER_ACC_X[this._data.player.id];
    }

    public void onPressedUp() {
        if (this._data._bGamePaused) {
            return;
        }
        if (!this._bInteraction) {
            return;
        }
        this._data._iGroundAcc = 1;
    }

    public void onPressedDown() {
        if (this._data._bGamePaused) {
            return;
        }
        if (!this._bInteraction) {
            return;
        }
        this._data._iGroundAcc = -1;
    }

    public void onPressedFire() throws Exception {
        if (this._data._iState != 4) {
            return;
        }
        if (this._data._bGamePaused) {
            return;
        }
        if (!this._bInteraction) {
            return;
        }
        try {
            this.doPlayerFire();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(">onPressedFire " + exception.toString());
        }
    }

    public void onUnpressedLeft() {
        if (this._data._bGamePaused) {
            return;
        }
        if (!this._bInteraction) {
            return;
        }
        if (this._data.player.iAX < 0) {
            this._data.player.iAX = 0;
        }
    }

    public void onUnpressedRight() {
        if (this._data._bGamePaused) {
            return;
        }
        if (!this._bInteraction) {
            return;
        }
        if (this._data.player.iAX > 0) {
            this._data.player.iAX = 0;
        }
    }

    public void onUnpressedUp() {
        if (this._data._bGamePaused) {
            return;
        }
        if (!this._bInteraction) {
            return;
        }
        if (this._data._iGroundAcc > 0) {
            this._data._iGroundAcc = 0;
        }
    }

    public void onUnpressedDown() {
        if (this._data._bGamePaused) {
            return;
        }
        if (!this._bInteraction) {
            return;
        }
        if (this._data._iGroundAcc < 0) {
            this._data._iGroundAcc = 0;
        }
    }

    public void onUnpressedFire() {
        if (!this._bInteraction) {
            return;
        }
    }

    public void render(Graphics graphics, Rect rect) throws Exception {
        int n = -1;
        try {
            switch (this._data._iState) {
                case 1: {
                    this.render_LevelBegin(graphics, rect);
                    if (this.getStateTimeout() <= 1000L && !this.isPressedAnyKey()) break;
                    this.setState(3);
                    break;
                }
                case 2: {
                    this.render_LevelEnd(graphics, rect);
                    if (this.getStateTimeout() <= 2000L && !this.isPressedAnyKey()) break;
                    ++this._data._iLevel;
                    this.addLife();
                    this.setState(1);
                    break;
                }
                case 3: {
                    this._data.bonus.iY = Integer.MAX_VALUE;
                    this.render_GetReady(graphics, rect);
                    if (!this._data._bGamePaused) {
                        this.generate_enemies();
                        this.update_background();
                        this.update_all_things();
                        this.update_player();
                        this.update_shield();
                        this.update_PlayerAmmo();
                        this.update_EnemyAmmo();
                        this.update_ground_enemies();
                        this.update_fly_enemies();
                        this.update_super_boss();
                        this.update_effects();
                        this.doWordlInteraction(false);
                    }
                    if (this.getStateTimeout() <= 1000L) break;
                    this.setState(4);
                    break;
                }
                case 4: {
                    n = 0;
                    this.render_Playing(graphics, rect);
                    n = 1;
                    if (this._data._bGamePaused) break;
                    n = 2;
                    this.generate_enemies();
                    n = 3;
                    this.update_background();
                    n = 4;
                    this.update_all_things();
                    n = 5;
                    this.update_player();
                    n = 6;
                    this.update_shield();
                    n = 7;
                    this.update_PlayerAmmo();
                    n = 8;
                    this.update_bonus();
                    n = 9;
                    this.update_EnemyAmmo();
                    n = 10;
                    this.update_effects();
                    n = 11;
                    this.update_ground_enemies();
                    n = 12;
                    this.update_fly_enemies();
                    n = 13;
                    this.update_super_boss();
                    n = 14;
                    this.doWordlInteraction(true);
                    n = 15;
                    break;
                }
                case 5: {
                    this.render_Fucking(graphics, rect);
                    if (!this._data._bGamePaused) {
                        this.generate_enemies();
                        this.update_background();
                        this.update_all_things();
                        this.update_player();
                        this.update_shield();
                        this.update_PlayerAmmo();
                        this.update_bonus();
                        this.update_EnemyAmmo();
                        this.update_effects();
                        this.update_ground_enemies();
                        this.update_fly_enemies();
                        this.update_super_boss();
                        this.doWordlInteraction(false);
                    }
                    if (this._data._iLifes > 0) {
                        if (this.getStateTimeout() <= 2000L) break;
                        --this._data._iLifes;
                        this.setState(3);
                        break;
                    }
                    --this._data._iLifes;
                    this.setState(6);
                    break;
                }
                case 6: {
                    this.render_GameOver(graphics, rect);
                    if (!this._data._bGamePaused) {
                        this.update_background();
                        this.update_all_things();
                        this.update_player();
                        this.update_shield();
                        this.update_PlayerAmmo();
                        this.update_bonus();
                        this.update_EnemyAmmo();
                        this.update_ground_enemies();
                        this.update_fly_enemies();
                        this.update_super_boss();
                        this.update_effects();
                    }
                    if (this.isDissactivated() || this.getStateTimeout() < 3000L) break;
                    if (HighScores.getInstance().tryAddPlayer(this._data._iScores)) {
                        return;
                    }
                    this.setStateDissactivated();
                    break;
                }
                case 7: {
                    this.render_YouWin(graphics, rect);
                    if (!this._data._bGamePaused) {
                        this.update_background();
                        this.update_all_things();
                        this.update_player();
                        this.update_shield();
                        this.update_PlayerAmmo();
                        this.update_bonus();
                        this.update_EnemyAmmo();
                        this.update_ground_enemies();
                        this.update_fly_enemies();
                        this.update_super_boss();
                        this.update_effects();
                    }
                    if (this.isDissactivated() || this.getStateTimeout() < 3000L) break;
                    if (HighScores.getInstance().tryAddPlayer(this._data._iScores)) {
                        return;
                    }
                    this.setStateDissactivated();
                }
            }
        }
        catch (Exception exception) {
            throw new Exception(">Game.render s=" + n + " iState=" + this._data._iState + " iPart=" + this._data._iGamePart + " " + exception.toString());
        }
    }

    private void render_ground(Graphics graphics, Rect rect) throws Exception {
        try {
            for (int i = 0; i < this._data._arr_iGrounds.length; ++i) {
                long[] lArray = this._data._arr_iGrounds[i];
                Img img = IMG_DATA.IMG_GROUND[(int)lArray[0]];
                int n = (int)((long)DATA.SCR_HEIGHT - lArray[1] + this._data._lGroundOffset);
                if (n < 0 || n - img.getHeight() > DATA.SCR_HEIGHT) continue;
                img.draw(graphics, 0, n, 8, 0, DATA._rcScreen);
            }
        }
        catch (Exception exception) {
            throw new Exception(">render_ground " + exception.toString());
        }
    }

    private void update_background() {
        if (this._data._iState == 4) {
            if (this._data._iGroundAcc != 0) {
                if (this._data._iGroundAcc > 0) {
                    this._data.setGroundVelocity(Math.min(SUPER_DATA.PLAYER_VELOCITY_Y[this._data.player.id], this._data.getGroundVelocity() + this._data._iGroundAcc));
                } else {
                    this._data.setGroundVelocity(Math.max(0, this._data.getGroundVelocity() + this._data._iGroundAcc));
                }
            }
            if (!this.isEnemyTime()) {
                this._data._lGroundOffset += (long)this._data.getGroundVelocity();
            }
        }
        for (int i = 0; i < this._data._arr_iGrounds.length; ++i) {
            long[] lArray = this._data._arr_iGrounds[i];
            Img img = IMG_DATA.IMG_GROUND[(int)lArray[0]];
            int n = (int)((long)DATA.SCR_HEIGHT - lArray[1] + this._data._lGroundOffset);
            if (lArray[1] != Long.MIN_VALUE && n - img.getHeight() <= DATA.SCR_HEIGHT) continue;
            lArray[0] = Utils.rndInt(8) < 8 ? 0 : Utils.rndInt(IMG_DATA.IMG_GROUND.length - 2) + 1;
            lArray[1] = this._data._iNextGroundY;
            this._data._iNextGroundY += (long)IMG_DATA.IMG_GROUND[(int)lArray[0]].getHeight();
        }
    }

    private void render_LevelBegin(Graphics graphics, Rect rect) {
        try {
            this.render_ground(graphics, rect);
            Utils.setClip(graphics, rect);
            Utils.drawMessage("Level " + (this._data._iLevel + 1), graphics);
            Utils.drawCmdL("MENU", graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void render_LevelEnd(Graphics graphics, Rect rect) {
        try {
            this.render_ground(graphics, rect);
            Utils.setClip(graphics, rect);
            Utils.drawMessage("Level " + (this._data._iLevel + 1) + " completed", graphics);
            Utils.drawCmdL("MENU", graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void render_GetReady(Graphics graphics, Rect rect) {
        try {
            this.render_ground(graphics, rect);
            this.render_side_ground_things(graphics, rect);
            this.render_ground_enemies(graphics, rect);
            this.render_side_back_things(graphics, rect);
            this.render_fly_enemies(graphics, rect);
            this.render_super_boss(graphics, rect);
            this.render_enemy_ammo(graphics, rect);
            this.render_ammo(graphics, rect);
            this.render_player(graphics, rect);
            this.render_shield(graphics, rect);
            this.render_effects(graphics, rect);
            this.render_side_front_things(graphics, rect);
            this.render_bonus_info(graphics, rect);
            this.render_lifes(graphics, rect);
            this.render_scores(graphics, rect);
            this.render_time(graphics, rect);
            Utils.setClip(graphics, rect);
            Utils.drawMessage("GET READY", graphics);
            Utils.setClip(graphics, rect);
            Utils.drawCmdL("MENU", graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void render_Playing(Graphics graphics, Rect rect) throws Exception {
        try {
            this.render_ground(graphics, rect);
            this.render_side_ground_things(graphics, rect);
            this.render_ground_enemies(graphics, rect);
            this.render_side_back_things(graphics, rect);
            this.render_fly_enemies(graphics, rect);
            this.render_super_boss(graphics, rect);
            this.render_enemy_ammo(graphics, rect);
            this.render_ammo(graphics, rect);
            this.render_player(graphics, rect);
            this.render_shield(graphics, rect);
            this.render_effects(graphics, rect);
            this.render_bonus(graphics, rect);
            this.render_side_front_things(graphics, rect);
            this.render_bonus_info(graphics, rect);
            this.render_lifes(graphics, rect);
            this.render_scores(graphics, rect);
            this.render_time(graphics, rect);
            if (this._data._bGamePaused) {
                Utils.drawMessage("PAUSED", graphics);
            }
            Utils.setClip(graphics, rect);
            Utils.drawCmdL("MENU", graphics);
            Utils.drawCmdR("PAUSE", graphics);
        }
        catch (Exception exception) {
            throw new Exception(">render_Playing " + exception.toString());
        }
    }

    private void render_Fucking(Graphics graphics, Rect rect) {
        try {
            this.render_ground(graphics, rect);
            this.render_side_ground_things(graphics, rect);
            this.render_ground_enemies(graphics, rect);
            this.render_side_back_things(graphics, rect);
            this.render_fly_enemies(graphics, rect);
            this.render_super_boss(graphics, rect);
            this.render_enemy_ammo(graphics, rect);
            this.render_ammo(graphics, rect);
            this._iPlayerAlpha = this._iPlayerAlpha + 1 & 1;
            if (this._iPlayerAlpha == 0) {
                this.addSuperExplosion(this._data.player);
            }
            this.render_effects(graphics, rect);
            this.render_bonus(graphics, rect);
            this.render_side_front_things(graphics, rect);
            this.render_bonus_info(graphics, rect);
            this.render_lifes(graphics, rect);
            this.render_scores(graphics, rect);
            this.render_time(graphics, rect);
            Utils.setClip(graphics, rect);
            Utils.drawMessage("Ouch!", graphics);
            Utils.drawCmdL("MENU", graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void render_GameOver(Graphics graphics, Rect rect) {
        try {
            this.render_ground(graphics, rect);
            this.render_side_ground_things(graphics, rect);
            this.render_ground_enemies(graphics, rect);
            this.render_side_back_things(graphics, rect);
            this.render_fly_enemies(graphics, rect);
            this.render_super_boss(graphics, rect);
            this.render_enemy_ammo(graphics, rect);
            this.render_ammo(graphics, rect);
            this.render_player(graphics, rect);
            this.render_shield(graphics, rect);
            this.render_effects(graphics, rect);
            this.render_bonus(graphics, rect);
            this.render_side_front_things(graphics, rect);
            this.render_bonus_info(graphics, rect);
            this.render_lifes(graphics, rect);
            this.render_scores(graphics, rect);
            this.render_time(graphics, rect);
            Utils.setClip(graphics, rect);
            Utils.drawMessage("Game Over", graphics);
            Utils.drawCmdL("MENU", graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void render_YouWin(Graphics graphics, Rect rect) {
        try {
            this.render_ground(graphics, rect);
            this.render_side_ground_things(graphics, rect);
            this.render_ground_enemies(graphics, rect);
            this.render_side_back_things(graphics, rect);
            this.render_fly_enemies(graphics, rect);
            this.render_fly_enemies(graphics, rect);
            this.render_enemy_ammo(graphics, rect);
            this.render_ammo(graphics, rect);
            this.render_player(graphics, rect);
            this.render_shield(graphics, rect);
            this.render_effects(graphics, rect);
            this.render_bonus(graphics, rect);
            this.render_side_front_things(graphics, rect);
            this.render_bonus_info(graphics, rect);
            this.render_lifes(graphics, rect);
            this.render_scores(graphics, rect);
            this.render_time(graphics, rect);
            Utils.setClip(graphics, rect);
            Utils.drawMessage("YOU WIN", graphics);
            Utils.drawCmdL("MENU", graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void render_time(Graphics graphics, Rect rect) {
        Utils.setClip(graphics, rect);
        graphics.setFont(DATA.fntSmall);
        Utils.drawText(Utils.getTimeStr(this.getGameTime()), graphics, DATA.SCR_RIGHT, 0, 2, 0xFFFFFF);
    }

    private void render_lifes(Graphics graphics, Rect rect) throws Exception {
        try {
            if (this._data._iLifes <= 3) {
                int n = this._data._iLifes;
                if (this._data._iState == 5 && this._iPlayerAlpha != 0) {
                    --n;
                }
                for (int i = 0; i < n; ++i) {
                    IMG_DATA.AIMG_HEART.draw(graphics, 1 + i * 20, 0, 0, 0, DATA._rcScreen);
                }
            } else {
                boolean bl = true;
                if (this._data._iState == 5) {
                    boolean bl2 = bl = this._iPlayerAlpha == 0;
                }
                if (bl) {
                    IMG_DATA.AIMG_HEART.draw(graphics, 1, 0, 0, 0, DATA._rcScreen);
                    int n = this._data._iLifes;
                    Utils.setClip(graphics, rect);
                    graphics.setFont(DATA.fntSmallBold);
                    Utils.drawText("" + n, graphics, 25, 2, 0, 0xFFA0A0);
                }
            }
            IMG_DATA.AIMG_HEART.update();
        }
        catch (Exception exception) {
            throw new Exception(">render_lifes " + exception.toString());
        }
    }

    private void addScores(int n) {
        this._data._iScores += (n + 9) / 10;
    }

    private void render_scores(Graphics graphics, Rect rect) throws Exception {
        try {
            this._iCurScores = this._iCurScores * 3 / 4 + this._data._iScores * 1 / 4;
            Utils.setClip(graphics, rect);
            String string = "" + this._iCurScores;
            graphics.setFont(DATA.fntMediumBold);
            Utils.drawText(string, graphics, DATA.SCR_W2 + 10, 1, 1, 0xFFFFFF);
        }
        catch (Exception exception) {
            throw new Exception(">render_scores " + exception.toString());
        }
    }

    private void render_energy(Graphics graphics, Rect rect, int n, int n2, int n3, int n4, int n5) {
        if (n <= 0) {
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n6 = n5;
        int n7 = n6 / 2;
        Utils.setClip(graphics, rect);
        if (n2 < n) {
            graphics.setColor(0);
            graphics.fillRect(n3 - n7, n4, n6, 2);
        }
        if (n2 > 0) {
            int n8 = n2 > n * 3 / 4 ? 65280 : (n2 > n / 2 ? 0xFFFF00 : (n2 > n / 4 ? 0xFF8000 : 0xFF0000));
            graphics.setColor(n8);
            graphics.fillRect(n3 - n7, n4, n2 * n6 / n, 1);
        }
    }

    private void render_player(Graphics graphics, Rect rect) throws Exception {
        try {
            int n = this._data.player.iX;
            int n2 = this._data.player.iY;
            AnimImg animImg = IMG_DATA.AIMG_PLAYER[this._data.player.id][this._data.player.iType];
            animImg.draw(graphics, n, n2, 5, 0, DATA._rcScreen);
            this.render_energy(graphics, rect, this._data.player.iMaxEnergy, this._data.player.iEnergy, n, n2 - animImg.getHeight() / 2 - 3, 20);
        }
        catch (Exception exception) {
            throw new Exception(">render_player " + exception.toString());
        }
    }

    private final int sgn(int n) {
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    private void update_player() throws Exception {
        int n = -1;
        try {
            n = 0;
            AnimImg animImg = IMG_DATA.AIMG_PLAYER[this._data.player.id][this._data.player.iType];
            n = 1;
            animImg.update();
            n = 2;
            int n2 = animImg.getHeight();
            n = 3;
            int n3 = animImg.getWidth() / 2 + 25;
            n = 4;
            int n4 = n2 / 2 + 10;
            if (this._data.player.iX > DATA.SCR_RIGHT - n3) {
                this._data.player.iX = DATA.SCR_RIGHT - n3;
                this._data.player.iAX = 0;
            } else if (this._data.player.iX < n3) {
                this._data.player.iX = n3;
                this._data.player.iAX = 0;
            }
            if (this._data.player.iAX == 0) {
                if (this._data.player.iVX < 0) {
                    this._data.player.iVX = Math.max(0, this._data.player.iVX + 1);
                } else if (this._data.player.iVX > 0) {
                    this._data.player.iVX = Math.min(0, this._data.player.iVX - 1);
                }
            } else {
                this._data.player.iVX = Math.max(-SUPER_DATA.PLAYER_VELOCITY_X[this._data.player.id], Math.min(SUPER_DATA.PLAYER_VELOCITY_X[this._data.player.id], this._data.player.iVX + this._data.player.iAX));
            }
            this._data.player.iX += this._data.player.iVX;
            int n5 = this._data._iGamePart >= 13 ? DATA.SCR_H2 : 25 + n4;
            int n6 = DATA.SCR_BOTTOM - n4;
            if (this._data.player.iY > n6) {
                this._data.player.iY = n6;
                this._data.player.iVY = 0;
            } else if (this._data.player.iY < n5) {
                this._data.player.iY = n5;
                this._data.player.iVY = 0;
            }
            this._data.player.iType = 1 + this.sgn(this._data.player.iVX);
            if (Utils.rndInt(3) == 3) {
                this._data.player.iShadowOffset = Math.max(10, Math.min(20, this._data.player.iShadowOffset + Utils.rndInt(2) - 1));
            }
            n = 27;
            if (Settings.getInstance().getAutofire()) {
                n = 28;
                this.doPlayerFire();
                n = 29;
            }
            n = 30;
            this.generateDiim(this._data.player);
            n = 31;
        }
        catch (Exception exception) {
            throw new Exception(">update_player s=" + n + " " + exception.toString());
        }
    }

    private int getActiveShieldIndex() {
        int n = this._data._iState == 3 ? 0 : this._data._iShieldType;
        return n;
    }

    private void render_shield(Graphics graphics, Rect rect) throws Exception {
        try {
            int n = this.getActiveShieldIndex();
            if (n != -1) {
                int n2 = this._data.player.iX;
                int n3 = this._data.player.iY;
                IMG_DATA.AIMG_SHIELDS[n].draw(graphics, n2, n3, 5, 0, rect);
            }
        }
        catch (Exception exception) {
            throw new Exception(">render_shield " + exception.toString());
        }
    }

    private void update_shield() throws Exception {
        try {
            int n;
            long l;
            if (this._data._iShieldType != -1 && (l = this.getGameTime() - this._data._lShieldTimeStart) > _SHIELDS_MAX_TIME[this._data._iShieldType]) {
                this._data._iShieldType = -1;
            }
            if ((n = this.getActiveShieldIndex()) != -1) {
                IMG_DATA.AIMG_SHIELDS[n].update();
            }
        }
        catch (Exception exception) {
            throw new Exception(">update_shield " + exception.toString());
        }
    }

    private void render_ammo(Graphics graphics, Rect rect) throws Exception {
        OBJ oBJ = null;
        int n = -1;
        try {
            n = 0;
            for (int i = 0; i < this._data._ammos.size(); ++i) {
                n = 2;
                oBJ = (OBJ)this._data._ammos.elementAt(i);
                n = 3;
                int n2 = oBJ.iX;
                int n3 = oBJ.iY;
                n = 4;
                AnimImg animImg = SUPER_DATA.AIMG_AMMO[oBJ.iType];
                n = 5;
                animImg.draw(graphics, n2, n3, 5, 0, rect);
                n = 6;
            }
            n = 7;
        }
        catch (Exception exception) {
            throw new Exception(">render_ammo " + exception.toString() + " o.iType=" + oBJ.iType + " s=" + n);
        }
    }

    private void update_PlayerAmmo() throws Exception {
        try {
            for (int i = this._data._ammos.size() - 1; i >= 0; --i) {
                OBJ oBJ = (OBJ)this._data._ammos.elementAt(i);
                AnimImg animImg = SUPER_DATA.AIMG_AMMO[oBJ.iType];
                animImg.update();
                oBJ.iX += oBJ.iVX;
                oBJ.iY += oBJ.iVY;
                Img img = animImg.getActiveFrameImg();
                int n = (img.getWidth() + 1) / 2;
                int n2 = (img.getHeight() + 1) / 2;
                if (oBJ.iX >= -n && oBJ.iX <= DATA.SCR_WIDTH + n && oBJ.iY >= -n2 + 25 && oBJ.iY <= DATA.SCR_HEIGHT - 25 + n2) continue;
                this.destroyPlayerAmmo(i);
                break;
            }
        }
        catch (Exception exception) {
            throw new Exception(">update_PlayerAmmo " + exception.toString());
        }
    }

    private OBJ __player_fire() throws Exception {
        int n = -1;
        OBJ oBJ = null;
        OBJ oBJ2 = null;
        try {
            n = 0;
            oBJ2 = this._data.player;
            n = 1;
            if (oBJ2.iGunFires > 0) {
                return null;
            }
            if (oBJ2.lFireTimeStart != Long.MIN_VALUE && this.getGameTime() - oBJ2.lFireTimeStart < 1000L) {
                return null;
            }
            oBJ2.lFireTimeStart = this.getGameTime();
            n = 2;
            for (int i = this._data._iPlayerAmmoCount.length - 1; i >= 1; --i) {
                if (oBJ2.iGunType != i) continue;
                if (this._data._iPlayerAmmoCount[i] > 0) {
                    int n2 = i;
                    this._data._iPlayerAmmoCount[n2] = this._data._iPlayerAmmoCount[n2] - 1;
                    break;
                }
                oBJ2.iGunType = i - 1;
            }
            n = 17;
            AnimImg animImg = IMG_DATA.AIMG_PLAYER[oBJ2.id][oBJ2.iType];
            n = 18;
            oBJ = new OBJ();
            n = 19;
            oBJ.iType = oBJ2.iGunType;
            n = 20;
            oBJ.iCategory = 1;
            n = 21;
            oBJ.iX = oBJ2.iX;
            n = 22;
            oBJ.iY = oBJ2.iY - animImg.getHeight() / 2 - 5;
            n = 23;
            oBJ.iVX = 0;
            n = 24;
            oBJ.iVY = -SUPER_DATA.AMMO_VELOCITY[oBJ2.iGunType];
            n = 25;
            oBJ.iShadowOffset = this._data.player.iShadowOffset;
            n = 26;
            oBJ.lTimeStart = this.getGameTime();
            n = 27;
            oBJ.iEnergy = SUPER_DATA.AMMO_ENERGY[this._data.player.id][oBJ.iType];
            n = 28;
            this._data._ammos.addElement(oBJ);
            n = 29;
            ++oBJ2.iGunFires;
            n = 30;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(">__player_fire s=" + n + " " + exception.toString());
        }
        return oBJ;
    }

    private boolean doPlayerFire() throws Exception {
        int n = -1;
        OBJ oBJ = null;
        try {
            n = 0;
            oBJ = this._data.player;
            n = 1;
            if (oBJ.iEnergy <= 0) {
                return false;
            }
            n = 2;
            switch (this._data._iGamePart) {
                case 0: 
                case 15: {
                    n = 3;
                    return false;
                }
            }
            n = 4;
            OBJ oBJ2 = this.__player_fire();
            n = 5;
            if (oBJ2 == null) {
                return false;
            }
            oBJ2.iVX = oBJ.iVX;
            n = 6;
            if (System.currentTimeMillis() - this._lSndExplosion > 750L && System.currentTimeMillis() - this._lSndBonus > 750L) {
                n = 7;
                SND_DATA.SND_PLAYER_AMMOS[oBJ2.iType].play();
                n = 8;
            }
            if (oBJ.iGunMultiplier <= 1) {
                return true;
            }
            n = 22;
            int n2 = oBJ.iGunMultiplier - 1;
            n = 23;
            switch (oBJ.iGunType) {
                case 0: 
                case 3: 
                case 4: {
                    n = 24;
                    for (int i = 0; i < n2; ++i) {
                        n = 25;
                        OBJ oBJ3 = new OBJ();
                        oBJ2.copyTo(oBJ3);
                        oBJ3.iVX = (n2 & 1) == 1 ? (i < n2 / 2 ? (i - n2 / 2) * 1 : (i - n2 / 2 + 1) * 1) : (i < n2 / 2 ? (i - n2 / 2) * 1 : (i - n2 / 2 + 1) * 1);
                        oBJ3.iX = (n2 & 1) == 1 ? (i < n2 / 2 ? oBJ2.iX + (i - n2 / 2) * 15 : oBJ2.iX + (i - n2 / 2 + 1) * 15) : (i < n2 / 2 ? oBJ2.iX + (i - n2 / 2) * 15 : oBJ2.iX + (i - n2 / 2 + 1) * 15);
                        oBJ3.iY = oBJ2.iY + 10;
                        this._data._ammos.addElement(oBJ3);
                        ++oBJ.iGunFires;
                    }
                    n = 26;
                    if ((n2 & 1) == 1) {
                        n = 27;
                        oBJ2.iX += (-1 - n2 / 2) * 15;
                        oBJ2.iY += 10;
                        n = 28;
                    }
                    n = 29;
                    if ((n2 & 1) == 1) {
                        n = 31;
                        oBJ2.iVX = (-1 - n2 / 2) * 1;
                        n = 32;
                    }
                    n = 33;
                    n = 34;
                    break;
                }
                case 1: 
                case 2: {
                    n = 35;
                    n = 36;
                    for (int i = 0; i < n2; ++i) {
                        n = 37;
                        OBJ oBJ4 = new OBJ();
                        oBJ2.copyTo(oBJ4);
                        n = 38;
                        oBJ4.iX = (n2 & 1) == 1 ? (i < n2 / 2 ? oBJ2.iX + (i - n2 / 2) * 15 : oBJ2.iX + (i - n2 / 2 + 1) * 15) : (i < n2 / 2 ? oBJ2.iX + (i - n2 / 2) * 15 : oBJ2.iX + (i - n2 / 2 + 1) * 15);
                        oBJ4.iY = oBJ2.iY + 10;
                        n = 39;
                        this._data._ammos.addElement(oBJ4);
                        ++oBJ.iGunFires;
                        n = 40;
                    }
                    n = 41;
                    if ((n2 & 1) == 1) {
                        n = 42;
                        oBJ2.iX += (-1 - n2 / 2) * 15;
                        oBJ2.iY += 10;
                        n = 43;
                    }
                    n = 44;
                    n = 45;
                }
            }
            n = 46;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(">doPlayerFire s=" + n + " " + exception.toString());
        }
        return true;
    }

    private void render_side_ground_things(Graphics graphics, Rect rect) throws Exception {
        try {
            if (IMG_DATA.AIMG_BESIDE_THINGS.length > 0) {
                this.render_a_things(graphics, this._data._beside_things, IMG_DATA.AIMG_BESIDE_THINGS[this._data._iLevel % IMG_DATA.AIMG_BESIDE_THINGS.length], rect, 1);
            }
            this.render_things(graphics, this._data._ground_things, IMG_DATA.IMG_GROUND_THINGS, rect, 2);
        }
        catch (Exception exception) {
            throw new Exception(">render_side_back_things " + exception.toString());
        }
    }

    private void render_side_back_things(Graphics graphics, Rect rect) throws Exception {
        int n = -1;
    }

    private void render_side_front_things(Graphics graphics, Rect rect) throws Exception {
        int n = -1;
        try {
            if (IMG_DATA.IMG_WIDE_THINGS.length > 0) {
                this.render_things(graphics, this._data._wide_things, IMG_DATA.IMG_WIDE_THINGS[this._data._iLevel % IMG_DATA.IMG_WIDE_THINGS.length], rect, 0);
            }
            ++n;
            this.render_a_things(graphics, this._data._top_things, IMG_DATA.AIMG_TOP_THINGS, rect, 3);
            ++n;
        }
        catch (Exception exception) {
            throw new Exception(">render_side_front_things iStep=" + n + " " + exception.toString());
        }
    }

    private void update_all_things() throws Exception {
        int n = -1;
        try {
            ++n;
            if (IMG_DATA.AIMG_BESIDE_THINGS.length > 0) {
                this.update_a_things(this._data._beside_things, IMG_DATA.AIMG_BESIDE_THINGS[this._data._iLevel % IMG_DATA.AIMG_BESIDE_THINGS.length], 1);
            }
            ++n;
            if (IMG_DATA.IMG_WIDE_THINGS.length > 0) {
                this.update_things(this._data._wide_things, IMG_DATA.IMG_WIDE_THINGS[this._data._iLevel % IMG_DATA.IMG_WIDE_THINGS.length], 0);
            }
            ++n;
            this.update_things(this._data._ground_things, IMG_DATA.IMG_GROUND_THINGS, 2);
            ++n;
            this.update_a_things(this._data._top_things, IMG_DATA.AIMG_TOP_THINGS, 3);
            ++n;
        }
        catch (Exception exception) {
            throw new Exception(">update_all_things iStep=" + n + " " + exception.toString());
        }
    }

    private void render_things(Graphics graphics, OBJ[] oBJArray, Img[] imgArray, Rect rect, int n) throws Exception {
        int n2 = -1;
        OBJ oBJ = null;
        String string = "1";
        try {
            if (imgArray.length == 0) {
                return;
            }
            string = "2";
            for (n2 = 0; n2 < oBJArray.length; ++n2) {
                string = "3";
                oBJ = oBJArray[n2];
                string = "4";
                Img img = imgArray[oBJ.iType];
                string = "5";
                int n3 = img.getHeight();
                string = "6";
                if (n == 1 && (oBJ.iY < 0 || oBJ.iY - n3 >= DATA.SCR_HEIGHT) || n != 1 && (oBJ.iY < -n3 || oBJ.iY >= DATA.SCR_HEIGHT)) continue;
                string = "7";
                if (n == 1) {
                    if ((oBJ.iShadowOffset & 2) != 0) {
                        img.draw(graphics, DATA.SCR_RIGHT - oBJ.iX, oBJ.iY, 10, 0, rect);
                    }
                    if ((oBJ.iShadowOffset & 1) != 0) {
                        img.draw(graphics, oBJ.iX, oBJ.iY, 8, 0, rect);
                    }
                } else if (n == 2) {
                    img.draw(graphics, oBJ.iX, oBJ.iY, 0, 0, rect);
                    if (oBJ.iMaxEnergy > 0) {
                        this.render_energy(graphics, rect, oBJ.iMaxEnergy, oBJ.iEnergy, oBJ.iX + img.getWidth() / 2, oBJ.iY + img.getHeight() + 3, 30);
                        Utils.resetClip(graphics);
                        graphics.setFont(DATA.fntSmall);
                        Utils.drawText("" + oBJ.iEnergy + "/" + oBJ.iMaxEnergy, graphics, oBJ.iX, oBJ.iY - 10, 0, 0xFFFFFF);
                    }
                } else {
                    img.draw(graphics, oBJ.iX, oBJ.iY, 0, 0, rect);
                }
                string = "8";
            }
            string = "9";
        }
        catch (Exception exception) {
            throw new Exception(">render_things [i=" + n2 + " msg=" + string + " o.iType" + oBJ.iType + "]" + exception.toString());
        }
    }

    private void render_a_things(Graphics graphics, OBJ[] oBJArray, AnimImg[] animImgArray, Rect rect, int n) throws Exception {
        int n2 = -1;
        OBJ oBJ = null;
        String string = "1";
        try {
            if (animImgArray.length == 0) {
                return;
            }
            string = "2";
            for (n2 = 0; n2 < oBJArray.length; ++n2) {
                string = "3";
                oBJ = oBJArray[n2];
                string = "4";
                AnimImg animImg = animImgArray[oBJ.iType];
                string = "5";
                int n3 = animImg.getHeight();
                string = "6";
                if (n == 1 && (oBJ.iY < 0 || oBJ.iY - n3 >= DATA.SCR_HEIGHT) || n != 1 && (oBJ.iY < -n3 || oBJ.iY >= DATA.SCR_HEIGHT)) continue;
                string = "7";
                if (n == 1) {
                    animImg.draw(graphics, oBJ.iX, oBJ.iY, 8, oBJ.iManipulation, rect);
                } else if (n == 2) {
                    animImg.draw(graphics, oBJ.iX, oBJ.iY, 0, oBJ.iManipulation, rect);
                    if (oBJ.iMaxEnergy > 0) {
                        this.render_energy(graphics, rect, oBJ.iMaxEnergy, oBJ.iEnergy, oBJ.iX + animImg.getWidth() / 2, oBJ.iY + animImg.getHeight() / 2, 30);
                    }
                } else {
                    animImg.draw(graphics, oBJ.iX, oBJ.iY, 0, oBJ.iManipulation, rect);
                }
                string = "8";
            }
            string = "9";
        }
        catch (Exception exception) {
            throw new Exception(">render_a_things [i=" + n2 + " msg=" + string + " o.iType" + oBJ.iType + "]" + exception.toString());
        }
    }

    private void update_things(OBJ[] oBJArray, Img[] imgArray, int n) throws Exception {
        try {
            if (imgArray.length == 0) {
                return;
            }
            for (int i = 0; i < oBJArray.length; ++i) {
                OBJ oBJ = oBJArray[i];
                Img img = imgArray[oBJ.iType];
                int n2 = img.getWidth();
                int n3 = img.getHeight();
                if (oBJ.iY < DATA.SCR_HEIGHT || n == 1 && oBJ.iY - n3 < DATA.SCR_HEIGHT) {
                    if (!this.isEnemyTime()) {
                        oBJ.iY += this._data.getGroundVelocity() + oBJ.iVY;
                    }
                    oBJ.iX += oBJ.iVX;
                    if (oBJ.iX < 10) {
                        oBJ.iVX = Math.abs(oBJ.iVX);
                        continue;
                    }
                    if (oBJ.iX <= DATA.SCR_RIGHT - img.getWidth() - 10) continue;
                    oBJ.iVX = -Math.abs(oBJ.iVX);
                    continue;
                }
                if (n == 0) {
                    oBJ.iType = Utils.rndInt(imgArray.length - 1);
                    oBJ.iX = (DATA.SCR_WIDTH - n2) / 2;
                    oBJ.iY = Math.min((int)(this._data._lGroundOffset - this._data._lGroundOffsetLastFree), -n3 - 20) - Utils.rndInt(DATA.SCR_HEIGHT);
                    this._data._lGroundOffsetLastFree = this._data._lGroundOffset - (long)oBJ.iY;
                    continue;
                }
                if (n == 1) {
                    oBJ.iType = (oBJ.iType + 1) % imgArray.length;
                    oBJ.iEnergy = oBJ.iMaxEnergy = n2 * n3 * this._data._iDifficulty;
                    oBJ.iShadowOffset = 3;
                    oBJ.iX = 1;
                    if (oBJ.iY == Integer.MAX_VALUE) {
                        oBJ.iY = -n3 + -oBJ.id * (2 * DATA.SCR_HEIGHT - n3) / 3;
                        continue;
                    }
                    oBJ.iY -= 2 * DATA.SCR_HEIGHT;
                    continue;
                }
                if (this._data._iState != 4) continue;
                int n4 = this._data._iLevel % IMG_DATA.LEV_IMG_GROUND_THINGS.length;
                oBJ.iType = IMG_DATA.LEV_IMG_GROUND_THINGS[n4][Utils.rndInt(IMG_DATA.LEV_IMG_GROUND_THINGS[n4].length - 1)];
                if (n == 2) {
                    if (!this.isAcceptedGroundThings()) continue;
                    oBJ.iEnergy = oBJ.iMaxEnergy = 20 + n2 * n3 / 50 * (this._data._iDifficulty + 1);
                    oBJ.iX = 25 + Utils.rndInt(DATA.SCR_WIDTH - 50 - img.getWidth());
                    oBJ.iY = Math.min((int)(this._data._lGroundOffset - this._data._lGroundOffsetLastFree), -n3 - 50 - (2 - this._data._iDifficulty) * DATA.SCR_H2) - Utils.rndInt(DATA.SCR_HEIGHT);
                    this._data._lGroundOffsetLastFree = this._data._lGroundOffset - (long)oBJ.iY;
                    continue;
                }
                oBJ.iX = 25 + Utils.rndInt(DATA.SCR_WIDTH - 50 - img.getWidth());
                oBJ.iY = -n3 - Utils.rndInt(20);
            }
        }
        catch (Exception exception) {
            throw new Exception(">update_wide_things " + exception.toString());
        }
    }

    private void update_a_things(OBJ[] oBJArray, AnimImg[] animImgArray, int n) throws Exception {
        try {
            if (animImgArray.length == 0) {
                return;
            }
            block5: for (int i = 0; i < oBJArray.length; ++i) {
                OBJ oBJ = oBJArray[i];
                AnimImg animImg = animImgArray[oBJ.iType];
                animImg.update();
                int n2 = animImg.getWidth();
                int n3 = animImg.getHeight();
                if (oBJ.iY < DATA.SCR_HEIGHT || n == 1 && oBJ.iY - n3 < DATA.SCR_HEIGHT) {
                    if (!this.isEnemyTime()) {
                        oBJ.iY += this._data.getGroundVelocity() + oBJ.iVY;
                    }
                    oBJ.iX += oBJ.iVX;
                    if (oBJ.iX < 10) {
                        oBJ.iVX = Math.abs(oBJ.iVX);
                        continue;
                    }
                    if (oBJ.iX <= DATA.SCR_RIGHT - animImg.getWidth() - 10) continue;
                    oBJ.iVX = -Math.abs(oBJ.iVX);
                    continue;
                }
                if (n == 0) {
                    oBJ.iType = Utils.rndInt(animImgArray.length - 1);
                    oBJ.iX = (DATA.SCR_WIDTH - n2) / 2;
                    oBJ.iY = Math.min((int)(this._data._lGroundOffset - this._data._lGroundOffsetLastFree), -n3 - 20) - Utils.rndInt(DATA.SCR_HEIGHT);
                    this._data._lGroundOffsetLastFree = this._data._lGroundOffset - (long)oBJ.iY;
                    continue;
                }
                if (n == 1) {
                    if (Utils.rndInt(2) != 2) continue;
                    oBJ.iType = (oBJ.iType + 1) % animImgArray.length;
                    oBJ.iEnergy = oBJ.iMaxEnergy = n2 * n3 * this._data._iDifficulty;
                    if (Utils.rndInt(1) == 1) {
                        oBJ.iX = 1;
                        oBJ.iManipulation = 0;
                    } else {
                        oBJ.iX = DATA.SCR_RIGHT - 1 - animImgArray[oBJ.iType].getWidth();
                        oBJ.iManipulation = 0;
                    }
                    if (oBJ.iY == Integer.MAX_VALUE) {
                        oBJ.iY = -n3 + -oBJ.id * (2 * DATA.SCR_HEIGHT - n3) / 3;
                        continue;
                    }
                    oBJ.iY -= 2 * DATA.SCR_HEIGHT;
                    continue;
                }
                if (this._data._iState != 4) continue;
                switch (this._data._iGamePart) {
                    case 0: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: 
                    case 15: {
                        continue block5;
                    }
                    default: {
                        oBJ.iType = Utils.rndInt(animImgArray.length - 1);
                        if (n == 2) {
                            oBJ.iEnergy = oBJ.iMaxEnergy = 20 + n2 * n3 / 50 * (this._data._iDifficulty + 1);
                            oBJ.iX = 25 + Utils.rndInt(DATA.SCR_WIDTH - 50 - animImg.getWidth());
                            oBJ.iY = Math.min((int)(this._data._lGroundOffset - this._data._lGroundOffsetLastFree), -n3 - 50 - (2 - this._data._iDifficulty) * DATA.SCR_H2) - Utils.rndInt(DATA.SCR_HEIGHT);
                            continue block5;
                        }
                        oBJ.iX = 25 + Utils.rndInt(DATA.SCR_WIDTH - 50 - animImg.getWidth());
                        oBJ.iY = -n3 - Utils.rndInt(20);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception(">update_wide_things " + exception.toString());
        }
    }

    private void render_bonus_info(Graphics graphics, Rect rect) throws Exception {
        try {
            Img img;
            int n = 1;
            int n2 = 18;
            if (this._data._iShieldType != -1) {
                img = IMG_DATA.IMG_BONUSES[5];
                img.draw(graphics, n, n2, 0, 0, DATA._rcScreen);
                Utils.setClip(graphics, rect);
                graphics.setFont(DATA.fntSmall);
                long l = (_SHIELDS_MAX_TIME[this._data._iShieldType] - (this.getGameTime() - this._data._lShieldTimeStart) + 999L) / 1000L;
                Utils.drawText("" + l, graphics, n + 5 + img.getWidth(), n2 + 2, 0, 0xFFFFFF);
                n2 += img.getHeight() + 2;
            }
            if (this._data.player.iGunMultiplier > 1) {
                img = IMG_DATA.IMG_BONUSES[6 + this._data.player.iGunMultiplier - 2];
                img.draw(graphics, n, n2, 0, 0, DATA._rcScreen);
                n2 += img.getHeight() + 2;
            }
            for (int i = this._data._iPlayerAmmoCount.length - 1; i > 0; --i) {
                if (this._data._iPlayerAmmoCount[i] <= 0) continue;
                Img img2 = IMG_DATA.IMG_BONUSES[i - 1];
                img2.draw(graphics, n, n2, 0, 0, DATA._rcScreen);
                Utils.setClip(graphics, rect);
                graphics.setFont(DATA.fntSmall);
                Utils.drawText("" + this._data._iPlayerAmmoCount[i], graphics, n + 5 + img2.getWidth(), n2 + 2, 0, 0xFFFFFF);
                n2 += img2.getHeight() + 2;
            }
        }
        catch (Exception exception) {
            throw new Exception(">render_bonus_info " + exception.toString());
        }
    }

    private void render_bonus(Graphics graphics, Rect rect) throws Exception {
        OBJ oBJ = null;
        try {
            oBJ = this._data.bonus;
            if (oBJ.iType < 0 || oBJ.iType >= IMG_DATA.IMG_BONUSES.length) {
                return;
            }
            Img img = IMG_DATA.IMG_BONUSES[oBJ.iType];
            int n = img.getHeight();
            if (oBJ.iY < -n / 2 || oBJ.iY >= DATA.SCR_HEIGHT + n / 2) {
                return;
            }
            img.draw(graphics, oBJ.iX, oBJ.iY, 5, 0, rect);
        }
        catch (Exception exception) {
            throw new Exception(">render_bonus o.iType=" + oBJ.iType + " " + exception.toString());
        }
    }

    private void update_bonus() throws Exception {
        try {
            OBJ oBJ = this._data.bonus;
            Img img = IMG_DATA.IMG_BONUSES[oBJ.iType];
            int n = img.getHeight();
            int n2 = img.getWidth();
            if (oBJ.iY < DATA.SCR_HEIGHT) {
                oBJ.iY += this._data.getGroundVelocity();
                oBJ.iX += Utils.rndInt(2) - 1;
            } else {
                oBJ.iType = Utils.rndInt(IMG_DATA.IMG_BONUSES.length - 1);
                img = IMG_DATA.IMG_BONUSES[oBJ.iType];
                n2 = img.getWidth();
                n = img.getHeight();
                oBJ.iX = Utils.rndInt(DATA.SCR_WIDTH - n2 - 50) + n2 / 2 + 25;
                oBJ.iY = -n / 2 - Utils.rndInt(DATA.SCR_HEIGHT);
                oBJ.iVY = 1 + Utils.rndInt(2);
            }
        }
        catch (Exception exception) {
            throw new Exception(">update_bonus " + exception.toString());
        }
    }

    void bonus_catched(int n) throws Exception {
        try {
            if (n >= 0 && n <= 3) {
                int n2 = n + 1;
                if (this._data.player.iGunType < n2) {
                    this._data.player.iGunMultiplier = 1;
                    this._data.player.iGunType = n2;
                }
                int n3 = n2;
                this._data._iPlayerAmmoCount[n3] = this._data._iPlayerAmmoCount[n3] + SUPER_DATA.BONUS_AMMO_COUNT[n2];
            } else if (n >= 6 && n <= 9) {
                this._data.player.iGunMultiplier = n - 6 + 2;
            } else {
                switch (n) {
                    case 4: {
                        this.addLife();
                        break;
                    }
                    case 5: {
                        this._data._iShieldType = 0;
                        this._data._lShieldTimeStart = this.getGameTime();
                    }
                }
            }
            if (System.currentTimeMillis() - this._lSndExplosion > 750L) {
                Utils.Trace("bonus catched");
                this._lSndBonus = System.currentTimeMillis();
                SND_DATA.SND_BONUS.play();
            }
        }
        catch (Exception exception) {
            throw new Exception(">bonus_catched " + exception.toString());
        }
    }

    private boolean hasIntersection(int n, int n2, Img img, int n3, int n4, Img img2) {
        boolean bl = false;
        int n5 = img.getWidth();
        int n6 = img.getHeight();
        int n7 = img2.getWidth();
        int n8 = img2.getHeight();
        int n9 = Math.abs(n - n3);
        int n10 = Math.abs(n2 - n4);
        int n11 = (n5 + n7) / 2;
        int n12 = (n6 + n8) / 2;
        if (n9 < n11 && n10 < n12) {
            bl = true;
        }
        return bl;
    }

    private void destroyEffect(int n) {
        this._data._effects.removeElementAt(n);
    }

    private void destroyPlayerAmmo(int n) {
        --this._data.player.iGunFires;
        this._data._ammos.removeElementAt(n);
    }

    private void destroyEnemyAmmo(int n) {
        OBJ oBJ;
        int n2;
        OBJ oBJ2 = (OBJ)this._data._enemy_ammos.elementAt(n);
        for (n2 = 0; n2 < this._data._ground_enemies.size(); ++n2) {
            oBJ = (OBJ)this._data._ground_enemies.elementAt(n2);
            if (oBJ.id != oBJ2.idMaster) continue;
            --oBJ.iGunFires;
            break;
        }
        for (n2 = 0; n2 < this._data._fly_enemies.size(); ++n2) {
            oBJ = (OBJ)this._data._fly_enemies.elementAt(n2);
            if (oBJ.id != oBJ2.idMaster) continue;
            --oBJ.iGunFires;
            break;
        }
        for (n2 = 0; n2 < this._data._boss_parts.size(); ++n2) {
            oBJ = (OBJ)this._data._boss_parts.elementAt(n2);
            if (oBJ.id != oBJ2.idMaster) continue;
            --oBJ.iGunFires;
            break;
        }
        this._data._enemy_ammos.removeElementAt(n);
    }

    private void unauthorizeEnemyAmmos(int n) {
        for (int i = 0; i < this._data._enemy_ammos.size(); ++i) {
            OBJ oBJ = (OBJ)this._data._enemy_ammos.elementAt(i);
            if (oBJ.idMaster != n) continue;
            oBJ.idMaster = Integer.MIN_VALUE;
        }
    }

    private void destroyGroundEnemy(int n) {
        OBJ oBJ = (OBJ)this._data._ground_enemies.elementAt(n);
        this.unauthorizeEnemyAmmos(oBJ.id);
        this._data._ground_enemies.removeElementAt(n);
        this.addScores(oBJ.iMaxEnergy * 5);
    }

    private void destroyFlyEnemy(int n) {
        OBJ oBJ = (OBJ)this._data._fly_enemies.elementAt(n);
        this.unauthorizeEnemyAmmos(oBJ.id);
        this._data._fly_enemies.removeElementAt(n);
        this.addScores(oBJ.iMaxEnergy * 5);
    }

    private void addSuperExplosion(OBJ oBJ) {
        for (int i = 0; i < 3; ++i) {
            this.addExplosion(2, oBJ, oBJ, Utils.rndInt(80) - 40, Utils.rndInt(80) - 40);
        }
        this.addExplosion(0, oBJ, oBJ, 0, 0);
    }

    private boolean firedPlayer(OBJ oBJ) {
        boolean bl;
        OBJ oBJ2 = this._data.player;
        switch (this._data._iGamePart) {
            case 0: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 15: {
                break;
            }
            default: {
                oBJ2.iEnergy -= oBJ.iEnergy;
            }
        }
        if (oBJ2.iEnergy > 0) {
            bl = false;
            this.addBlast(0, oBJ2, oBJ, 0, 0);
            if (System.currentTimeMillis() - this._lSndExplosion > 750L && System.currentTimeMillis() - this._lSndBonus > 750L) {
                SND_DATA.SND_AMMO_BOOM.play();
            }
        } else {
            oBJ2.iVX = 0;
            oBJ2.iVY = 0;
            this.addSuperExplosion(oBJ2);
            this._lSndExplosion = System.currentTimeMillis();
            SND_DATA.SND_PLAYER_BOOM.play();
            bl = true;
        }
        return bl;
    }

    private boolean firedGroundEnemy(int n, OBJ oBJ) {
        boolean bl;
        OBJ oBJ2 = (OBJ)this._data._ground_enemies.elementAt(n);
        oBJ2.iEnergy -= oBJ.iEnergy;
        if (oBJ2.iEnergy > 0) {
            bl = false;
            this.addScores(oBJ.iEnergy);
            if (this._data._iGamePart > 9) {
                for (int i = 0; i < 3; ++i) {
                    this.addBlast(2, oBJ2, oBJ, Utils.rndInt(20), Utils.rndInt(20));
                }
            }
            this.addBlast(0, oBJ2, oBJ, 0, 0);
            if (System.currentTimeMillis() - this._lSndExplosion > 750L && System.currentTimeMillis() - this._lSndBonus > 750L) {
                SND_DATA.SND_AMMO_BOOM.play();
            }
        } else {
            this.destroyGroundEnemy(n);
            if (this._data._iGamePart > 9) {
                for (int i = 0; i < 3; ++i) {
                    this.addExplosion(2, oBJ2, oBJ, Utils.rndInt(20), Utils.rndInt(20));
                }
            } else {
                this.addExplosion(2, oBJ2, oBJ, 0, 0);
            }
            this.addBlast(0, oBJ2, oBJ, 0, 0);
            this._lSndExplosion = System.currentTimeMillis();
            SND_DATA.SND_GROUND_ENEMY_BOOM.play();
            bl = true;
        }
        return bl;
    }

    private OBJ addBlast(int n, OBJ oBJ, OBJ oBJ2, int n2, int n3) {
        OBJ oBJ3 = new OBJ();
        oBJ3.idMaster = oBJ.id;
        oBJ3.iType = n;
        oBJ3.iX = oBJ2.iX + n2;
        oBJ3.iY = oBJ2.iY + n3;
        oBJ3.lTimeStart = this.getGameTime();
        this._data._effects.addElement(oBJ3);
        return oBJ3;
    }

    private int addExplosion(int n, OBJ oBJ, OBJ oBJ2, int n2, int n3) {
        int n4 = 8;
        for (int i = 0; i < n4; ++i) {
            this.addBlast(n, oBJ, oBJ2, n2 + Utils.rndInt(30) - 15, n3 + Utils.rndInt(30) - 15);
        }
        return n4;
    }

    private boolean firedFlyEnemy(int n, OBJ oBJ) {
        boolean bl;
        OBJ oBJ2 = (OBJ)this._data._fly_enemies.elementAt(n);
        oBJ2.iEnergy -= oBJ.iEnergy;
        if (oBJ2.iEnergy > 0) {
            bl = false;
            this.addScores(oBJ.iEnergy);
            if (this._data._iGamePart > 9) {
                for (int i = 0; i < 3; ++i) {
                    this.addBlast(2, oBJ2, oBJ, Utils.rndInt(20), Utils.rndInt(20));
                }
            }
            this.addBlast(0, oBJ2, oBJ, 0, 0);
            if (System.currentTimeMillis() - this._lSndExplosion > 750L && System.currentTimeMillis() - this._lSndBonus > 750L) {
                SND_DATA.SND_AMMO_BOOM.play();
            }
        } else {
            this.destroyFlyEnemy(n);
            if (this._data._iGamePart > 9) {
                for (int i = 0; i < 3; ++i) {
                    this.addExplosion(2, oBJ2, oBJ, Utils.rndInt(20), Utils.rndInt(20));
                }
            } else {
                this.addExplosion(2, oBJ2, oBJ, 0, 0);
            }
            this.addBlast(0, oBJ2, oBJ, 0, 0);
            this._lSndExplosion = System.currentTimeMillis();
            SND_DATA.SND_FLY_ENEMY_BOOM.play();
            bl = true;
        }
        return bl;
    }

    private void destroyBoss() {
        this._data._boss_parts.removeAllElements();
    }

    private void destroyBesideThing(int n) {
        this._data._beside_things[n].iY = Integer.MAX_VALUE;
    }

    private void destroyGroundThing(int n) {
        this._data._ground_things[n].iY = Integer.MAX_VALUE;
    }

    private boolean firedBossPart(int n, OBJ oBJ) {
        boolean bl;
        OBJ oBJ2 = this._data.boss;
        oBJ2.iEnergy -= oBJ.iEnergy;
        if (oBJ2.iEnergy > 0) {
            bl = false;
            this.addScores(oBJ.iEnergy);
            if (this._data._iGamePart > 9) {
                for (int i = 0; i < 3; ++i) {
                    this.addBlast(2, oBJ2, oBJ, Utils.rndInt(20), Utils.rndInt(20));
                }
            } else {
                this.addBlast(2, oBJ2, oBJ, 0, 0);
            }
            this.addBlast(0, oBJ2, oBJ, 0, 0);
            if (System.currentTimeMillis() - this._lSndExplosion > 750L && System.currentTimeMillis() - this._lSndBonus > 750L) {
                SND_DATA.SND_AMMO_BOOM.play();
            }
        } else {
            int n2;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            int n5 = Integer.MAX_VALUE;
            int n6 = Integer.MIN_VALUE;
            int n7 = this._data._boss_parts.size();
            for (n2 = 0; n2 < n7; ++n2) {
                oBJ2 = (OBJ)this._data._boss_parts.elementAt(n2);
                AnimImg animImg = IMG_DATA.AIMG_BOSS_PARTS[oBJ2.iType];
                int n8 = animImg.getWidth();
                int n9 = animImg.getHeight();
                if (oBJ2.iX + n8 > n4) {
                    n4 = oBJ2.iX + n8;
                }
                if (oBJ2.iX < n3) {
                    n3 = oBJ2.iX;
                }
                if (oBJ2.iY + n9 > n6) {
                    n6 = oBJ2.iY + n9;
                }
                if (oBJ2.iY >= n5) continue;
                n5 = oBJ2.iY;
            }
            oBJ2 = this._data.boss;
            oBJ2.iX = (n3 + n4) / 2;
            oBJ2.iY = (n5 + n6) / 2;
            if (this._data._iGamePart > 9) {
                for (n2 = 0; n2 < 10; ++n2) {
                    this.addExplosion(2, oBJ2, oBJ, Utils.rndInt(50), Utils.rndInt(50));
                }
            } else {
                this.addExplosion(2, oBJ2, oBJ, 0, 0);
            }
            this.destroyBoss();
            this._lSndExplosion = System.currentTimeMillis();
            SND_DATA.SND_FLY_ENEMY_BOOM.play();
            bl = true;
        }
        return bl;
    }

    private boolean firedGroundThing(int n, int n2) {
        boolean bl;
        OBJ oBJ = this._data._ground_things[n];
        oBJ.iEnergy -= n2;
        if (oBJ.iEnergy > 0) {
            bl = false;
            this.addScores(n2);
            this.addBlast(2, oBJ, oBJ, 0, 0);
            if (System.currentTimeMillis() - this._lSndExplosion > 750L && System.currentTimeMillis() - this._lSndBonus > 750L) {
                SND_DATA.SND_AMMO_BOOM.play();
            }
        } else {
            this.destroyGroundThing(n);
            this.addExplosion(2, oBJ, oBJ, 0, 0);
            this.addBlast(0, oBJ, oBJ, 0, 10);
            this._lSndExplosion = System.currentTimeMillis();
            SND_DATA.SND_FLY_ENEMY_BOOM.play();
            bl = true;
        }
        return bl;
    }

    private void doWordlInteraction(boolean bl) throws Exception {
        block20: {
            try {
                Img img;
                OBJ oBJ;
                int n;
                boolean bl2;
                Object object;
                OBJ oBJ2;
                int n2;
                Img img2 = IMG_DATA.AIMG_PLAYER[this._data.player.id][this._data.player.iType].getActiveFrameImg();
                int n3 = this._data.player.iX;
                int n4 = this._data.player.iY;
                for (n2 = this._data._ammos.size() - 1; n2 >= 0; --n2) {
                    oBJ2 = (OBJ)this._data._ammos.elementAt(n2);
                    object = SUPER_DATA.AIMG_AMMO[oBJ2.iType].getActiveFrameImg();
                    bl2 = false;
                    for (n = this._data._ground_enemies.size() - 1; n >= 0; --n) {
                        oBJ = (OBJ)this._data._ground_enemies.elementAt(n);
                        img = SUPER_DATA.AIMG_GRP1_ENEMY[oBJ.iType].getActiveFrameImg();
                        if (!this.hasIntersection(oBJ.iX, oBJ.iY, img, oBJ2.iX, oBJ2.iY, (Img)object)) continue;
                        bl2 = true;
                        this.firedGroundEnemy(n, oBJ2);
                    }
                    for (n = this._data._fly_enemies.size() - 1; n >= 0; --n) {
                        oBJ = (OBJ)this._data._fly_enemies.elementAt(n);
                        img = SUPER_DATA.AIMG_GRP2_ENEMY[oBJ.iType].getActiveFrameImg();
                        if (!this.hasIntersection(oBJ.iX, oBJ.iY, img, oBJ2.iX, oBJ2.iY, (Img)object)) continue;
                        bl2 = true;
                        this.firedFlyEnemy(n, oBJ2);
                    }
                    if (!bl2 || oBJ2.iType == this._data._iPlayerAmmoCount.length - 1) continue;
                    this.destroyPlayerAmmo(n2);
                    this.addBlast(0, oBJ2, oBJ2, 0, 0);
                }
                if (this._data._iGamePart == 14) {
                    for (n2 = this._data._ammos.size() - 1; n2 >= 0; --n2) {
                        oBJ2 = (OBJ)this._data._ammos.elementAt(n2);
                        object = SUPER_DATA.AIMG_AMMO[oBJ2.iType].getActiveFrameImg();
                        bl2 = false;
                        for (n = this._data._boss_parts.size() - 1; n >= 0; --n) {
                            oBJ = (OBJ)this._data._boss_parts.elementAt(n);
                            img = IMG_DATA.AIMG_BOSS_PARTS[oBJ.iType].getActiveFrameImg();
                            if (!this.hasIntersection(oBJ.iX, oBJ.iY, img, oBJ2.iX, oBJ2.iY, (Img)object)) continue;
                            bl2 = true;
                            if (this.firedBossPart(n, oBJ2)) break;
                        }
                        if (!bl2 || oBJ2.iType == this._data._iPlayerAmmoCount.length) continue;
                        this.destroyPlayerAmmo(n2);
                        this.addBlast(0, oBJ2, oBJ2, 0, 0);
                    }
                }
                for (n2 = this._data._enemy_ammos.size() - 1; n2 >= 0; --n2) {
                    oBJ2 = (OBJ)this._data._enemy_ammos.elementAt(n2);
                    object = SUPER_DATA.AIMG_ENEMY_AMMO[oBJ2.iType].getActiveFrameImg();
                    bl2 = false;
                    for (n = this._data._ammos.size() - 1; n >= 0; --n) {
                        oBJ = (OBJ)this._data._ammos.elementAt(n);
                        img = SUPER_DATA.AIMG_AMMO[oBJ.iType].getActiveFrameImg();
                        if (!this.hasIntersection(oBJ2.iX, oBJ2.iY, (Img)object, oBJ.iX, oBJ.iY, img)) continue;
                        if (oBJ.iType != this._data._iPlayerAmmoCount.length) {
                            this.destroyPlayerAmmo(n);
                            this.addBlast(0, oBJ, oBJ2, 0, 0);
                        }
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    this.destroyEnemyAmmo(n2);
                    this.addBlast(0, oBJ2, oBJ2, 0, 0);
                    this.addScores(oBJ2.iEnergy);
                    if (System.currentTimeMillis() - this._lSndExplosion <= 750L || System.currentTimeMillis() - this._lSndBonus <= 750L) continue;
                    SND_DATA.SND_AMMO_BOOM.play();
                }
                for (n2 = this._data._ground_things.length - 1; n2 >= 0; --n2) {
                    int n5 = 0;
                    object = this._data._ground_things[n2];
                    ((OBJ)object).copyTo(this.__tmpObj);
                    Img img3 = IMG_DATA.IMG_GROUND_THINGS[this.__tmpObj.iType];
                    n = img3.getWidth();
                    int n6 = img3.getHeight();
                    this.__tmpObj.iX += n / 2;
                    this.__tmpObj.iY += n6 / 2;
                    boolean bl3 = false;
                    for (int i = this._data._ammos.size() - 1; i >= 0; --i) {
                        OBJ oBJ3 = (OBJ)this._data._ammos.elementAt(i);
                        Img img4 = SUPER_DATA.AIMG_AMMO[oBJ3.iType].getActiveFrameImg();
                        if (!this.hasIntersection(this.__tmpObj.iX, this.__tmpObj.iY, img3, oBJ3.iX, oBJ3.iY, img4)) continue;
                        n5 += oBJ3.iEnergy;
                        if (oBJ3.iType != this._data._iPlayerAmmoCount.length) {
                            this.destroyPlayerAmmo(i);
                            this.addBlast(0, oBJ3, oBJ3, 0, 0);
                        }
                        bl3 = true;
                    }
                    if (!bl3) continue;
                    this.addScores(this.__tmpObj.iEnergy);
                    this.firedGroundThing(n2, n5);
                }
                if (!bl) break block20;
                if (this._data.bonus.iY >= DATA.SCR_HEIGHT) {
                    return;
                }
                if (this.hasIntersection(n3, n4, img2, this._data.bonus.iX, this._data.bonus.iY, IMG_DATA.IMG_BONUSES[this._data.bonus.iType])) {
                    this._data.bonus.iY = DATA.SCR_HEIGHT;
                    this.bonus_catched(this._data.bonus.iType);
                }
                for (n2 = this._data._enemy_ammos.size() - 1; n2 >= 0; --n2) {
                    OBJ oBJ4 = (OBJ)this._data._enemy_ammos.elementAt(n2);
                    object = SUPER_DATA.AIMG_ENEMY_AMMO[oBJ4.iType];
                    Img img5 = ((AnimImg)object).getActiveFrameImg();
                    if (!this.hasIntersection(n3, n4, img2, oBJ4.iX, oBJ4.iY, img5)) continue;
                    this.destroyEnemyAmmo(n2);
                    if (this._data._iShieldType == -1) {
                        if (!this.firedPlayer(oBJ4)) continue;
                        this.setState(5);
                        break;
                    }
                    this.addBlast(1, this._data.player, oBJ4, 0, 0);
                    if (System.currentTimeMillis() - this._lSndExplosion <= 750L || System.currentTimeMillis() - this._lSndBonus <= 750L) continue;
                    SND_DATA.SND_ANTI_BOOM.play();
                }
                for (n2 = this._data._ground_things.length - 1; n2 >= 0; --n2) {
                    OBJ oBJ5 = this._data._ground_things[n2];
                    object = IMG_DATA.IMG_GROUND_THINGS[oBJ5.iType];
                    int n7 = ((Img)object).getWidth();
                    n = ((Img)object).getHeight();
                    if (oBJ5.iY < 0 || oBJ5.iY - n >= DATA.SCR_HEIGHT) continue;
                    oBJ5.copyTo(this.__tmpObj);
                    this.__tmpObj.iX += n7 / 2;
                    this.__tmpObj.iY += n / 2;
                    if (!this.hasIntersection(n3, n4, img2, this.__tmpObj.iX, this.__tmpObj.iY, (Img)object)) continue;
                    this.destroyGroundThing(n2);
                    this.addBlast(2, this.__tmpObj, this.__tmpObj, 0, 0);
                    if (this._data._iShieldType == -1) {
                        if (!this.firedPlayer(this.__tmpObj)) continue;
                        this.setState(5);
                        break;
                    }
                    this.addBlast(1, this._data.player, this._data.player, 0, 0);
                    if (System.currentTimeMillis() - this._lSndExplosion <= 750L || System.currentTimeMillis() - this._lSndBonus <= 750L) continue;
                    SND_DATA.SND_ANTI_BOOM.play();
                }
            }
            catch (Exception exception) {
                throw new Exception(">doWordlInteraction " + exception.toString());
            }
        }
    }

    private void render_enemy_ammo(Graphics graphics, Rect rect) throws Exception {
        try {
            for (int i = 0; i < this._data._enemy_ammos.size(); ++i) {
                OBJ oBJ = (OBJ)this._data._enemy_ammos.elementAt(i);
                int n = oBJ.iX;
                int n2 = oBJ.iY;
                int n3 = oBJ.iVY > 0 ? 0 : 16384;
                AnimImg animImg = SUPER_DATA.AIMG_ENEMY_AMMO[oBJ.iType];
                animImg.draw(graphics, n, n2, 5, n3, rect);
            }
        }
        catch (Exception exception) {
            throw new Exception(">render_enemy_ammo " + exception.toString());
        }
    }

    private void update_EnemyAmmo() throws Exception {
        try {
            block8: for (int i = this._data._enemy_ammos.size() - 1; i >= 0; --i) {
                OBJ oBJ = (OBJ)this._data._enemy_ammos.elementAt(i);
                AnimImg animImg = SUPER_DATA.AIMG_ENEMY_AMMO[oBJ.iType];
                animImg.update();
                oBJ.iX += oBJ.iVX;
                oBJ.iY += oBJ.iVY + this._data.getGroundVelocity();
                if (oBJ.iVY > 0) {
                    ++oBJ.iY;
                } else if (oBJ.iVY < 0) {
                    --oBJ.iY;
                }
                Img img = animImg.getActiveFrameImg();
                int n = (img.getWidth() + 1) / 2;
                int n2 = (img.getHeight() + 1) / 2;
                if (oBJ.iX < -n || oBJ.iX > DATA.SCR_WIDTH + n || oBJ.iY < -n2 + 25 || oBJ.iY > DATA.SCR_HEIGHT - 25 + n2) {
                    this.destroyEnemyAmmo(i);
                }
                switch (oBJ.iType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (Utils.rndInt(3) != 3) continue block8;
                        oBJ.iShadowOffset = Math.max(10, Math.min(20, oBJ.iShadowOffset + Utils.rndInt(2) - 1));
                        continue block8;
                    }
                    case -100: {
                        if (this._data.player.iX < oBJ.iX) {
                            oBJ.iVX = -1;
                        } else if (this._data.player.iX > oBJ.iX) {
                            oBJ.iVX = 1;
                        } else if (this._data.player.iX > oBJ.iX) {
                            oBJ.iVX = 0;
                        }
                        if (Utils.rndInt(3) != 3) continue block8;
                        oBJ.iShadowOffset = Math.max(10, Math.min(20, oBJ.iShadowOffset + Utils.rndInt(2) - 1));
                        continue block8;
                    }
                    case -200: {
                        oBJ.iShadowOffset = Math.max(1, oBJ.iShadowOffset - 2);
                        if (oBJ.iShadowOffset != 1) continue block8;
                        oBJ.iType = -201;
                        oBJ.iVY = oBJ.iVY >= 0 ? SUPER_DATA.ENEMY_AMMO_VELOCITY[oBJ.iType] : -SUPER_DATA.ENEMY_AMMO_VELOCITY[oBJ.iType];
                        continue block8;
                    }
                    case -300: {
                        oBJ.iShadowOffset = Math.max(1, oBJ.iShadowOffset - 2);
                        if (oBJ.iShadowOffset != 1) continue block8;
                        oBJ.iType = -301;
                        oBJ.iVY = oBJ.iVY >= 0 ? SUPER_DATA.ENEMY_AMMO_VELOCITY[oBJ.iType] : -SUPER_DATA.ENEMY_AMMO_VELOCITY[oBJ.iType];
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception(">update_EnemyAmmo " + exception.toString());
        }
    }

    private OBJ doEnemyFire(OBJ oBJ) {
        int n;
        OBJ oBJ2 = oBJ;
        if (oBJ2.iGunType == -1) {
            return null;
        }
        if (oBJ2.iGunFires > 0) {
            return null;
        }
        if (oBJ2.lFireTimeStart != Long.MIN_VALUE && this.getGameTime() - oBJ2.lFireTimeStart < (long)(2000 - this._data._iDifficulty * 100)) {
            return null;
        }
        oBJ2.lFireTimeStart = this.getGameTime();
        OBJ oBJ3 = new OBJ();
        oBJ3.idMaster = oBJ2.id;
        oBJ3.iType = oBJ2.iGunType;
        oBJ3.iCategory = 14;
        oBJ3.iX = oBJ2.iX;
        switch (oBJ2.iCategory) {
            case 12: {
                AnimImg animImg = SUPER_DATA.AIMG_GRP1_ENEMY[oBJ2.iType];
                int n2 = animImg.getWidth();
                n = animImg.getHeight();
                oBJ3.iEnergy = SUPER_DATA.ENEMY_AMMO_ENERGY[oBJ3.iType] + 1 * this._data._iDifficulty;
                break;
            }
            case 11: {
                AnimImg animImg = SUPER_DATA.AIMG_GRP2_ENEMY[oBJ2.iType];
                int n3 = animImg.getWidth();
                n = animImg.getHeight();
                oBJ3.iEnergy = SUPER_DATA.ENEMY_AMMO_ENERGY[oBJ3.iType] + 2 * this._data._iDifficulty;
                break;
            }
            case 100: {
                AnimImg animImg = IMG_DATA.AIMG_BOSS_PARTS[oBJ2.iType];
                int n4 = animImg.getWidth();
                n = animImg.getHeight();
                oBJ3.iEnergy = SUPER_DATA.ENEMY_AMMO_ENERGY[oBJ3.iType] + 5 * this._data._iDifficulty;
                break;
            }
            default: {
                return null;
            }
        }
        int n5 = this._data.player.iX - oBJ2.iX;
        int n6 = this._data.player.iY - oBJ2.iY;
        if (n6 > 0) {
            oBJ3.iVY = SUPER_DATA.ENEMY_AMMO_VELOCITY[oBJ2.iGunType];
            oBJ3.iVX = n5 * oBJ3.iVY / n6;
            oBJ3.iY = oBJ2.iY + n / 2 - 10;
        } else if (n6 < 0) {
            oBJ3.iVY = -SUPER_DATA.ENEMY_AMMO_VELOCITY[oBJ2.iGunType];
            oBJ3.iVX = n5 * oBJ3.iVY / n6;
            oBJ3.iY = oBJ2.iY - n / 2 - 10;
        } else if (n5 > 0) {
            oBJ3.iVX = (SUPER_DATA.ENEMY_AMMO_VELOCITY[oBJ2.iGunType] + 3) / 4;
            oBJ3.iVY = n6 * oBJ3.iVX / n5;
            oBJ3.iY = oBJ2.iY;
        } else if (n5 < 0) {
            oBJ3.iVX = -(SUPER_DATA.ENEMY_AMMO_VELOCITY[oBJ2.iGunType] + 3) / 4;
            oBJ3.iVY = n6 * oBJ3.iVX / n5;
            oBJ3.iY = oBJ2.iY;
        } else {
            oBJ3.iVY = SUPER_DATA.ENEMY_AMMO_VELOCITY[oBJ2.iGunType];
            oBJ3.iVX = 0;
            oBJ3.iY = oBJ2.iY;
        }
        oBJ3.iShadowOffset = oBJ2.iShadowOffset;
        oBJ3.lTimeStart = this.getGameTime();
        this._data._enemy_ammos.addElement(oBJ3);
        ++oBJ2.iGunFires;
        return oBJ3;
    }

    private void render_ground_enemies(Graphics graphics, Rect rect) throws Exception {
        int n = this._data._ground_enemies.size();
        for (int i = 0; i < n; ++i) {
            OBJ oBJ = (OBJ)this._data._ground_enemies.elementAt(i);
            AnimImg animImg = SUPER_DATA.AIMG_GRP1_ENEMY[oBJ.iType];
            animImg.update();
            int n2 = animImg.getHeight();
            if (oBJ.iY < -n2 / 2 || oBJ.iY > DATA.SCR_BOTTOM + n2 / 2) continue;
            int n3 = this._data.player.iY - oBJ.iY;
            int n4 = n3 > 0 ? 0 : 16384;
            animImg.draw(graphics, oBJ.iX, oBJ.iY, 5, n4, DATA._rcScreen);
            int n5 = this._data._iGamePart == 14 ? 100 : (this._data._iGamePart >= 10 ? 50 : 20);
            this.render_energy(graphics, rect, oBJ.iMaxEnergy, oBJ.iEnergy, oBJ.iX, oBJ.iY - animImg.getHeight() / 2 - 3, n5);
        }
    }

    private void update_ground_enemies() throws Exception {
        try {
            if (SUPER_DATA.AIMG_GRP1_ENEMY.length == 0) {
                return;
            }
            int n = this._data._ground_enemies.size();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                AnimImg animImg;
                OBJ oBJ;
                int n4;
                OBJ oBJ2 = (OBJ)this._data._ground_enemies.elementAt(i);
                if (oBJ2.iEnergy <= 0) continue;
                AnimImg animImg2 = SUPER_DATA.AIMG_GRP1_ENEMY[oBJ2.iType];
                int n5 = animImg2.getWidth();
                int n6 = animImg2.getHeight();
                int n7 = this._data.player.iY - oBJ2.iY;
                int n8 = this._data.getGroundVelocity() + 1;
                if (!bl && this.doEnemyFire(oBJ2) != null) {
                    oBJ2.iVY = n7 > 0 ? -5 : 5;
                    bl = true;
                }
                if (oBJ2.iY > DATA.SCR_H2 && this._data.player.iY > DATA.SCR_H2) {
                    oBJ2.iVY = -7;
                } else if (oBJ2.iY < DATA.SCR_H2 && this._data.player.iY < DATA.SCR_H2) {
                    oBJ2.iVY = 7;
                } else if (oBJ2.iY < -n6 / 2) {
                    oBJ2.iVY = n8;
                    oBJ2.iY = -n6 / 2;
                } else if (oBJ2.iY > DATA.SCR_BOTTOM + n6 / 2) {
                    oBJ2.iVY = -n8;
                    oBJ2.iY = DATA.SCR_BOTTOM + n6 / 2;
                } else if (oBJ2.iY < n6 / 2) {
                    oBJ2.iVY = n8;
                } else if (oBJ2.iY > DATA.SCR_BOTTOM - n6 / 2) {
                    oBJ2.iVY = -n8;
                } else if (Utils.rndInt(30) == 30) {
                    oBJ2.iVY = Utils.rndInt(2) - 1;
                }
                oBJ2.iX += oBJ2.iVX;
                oBJ2.iY += oBJ2.iVY;
                if (i == 0) {
                    n4 = n5 / 2 + 25 + oBJ2.iVX;
                } else {
                    oBJ = (OBJ)this._data._ground_enemies.elementAt(i - 1);
                    animImg = SUPER_DATA.AIMG_GRP1_ENEMY[oBJ2.iType];
                    n3 = animImg.getWidth();
                    n4 = oBJ.iX + n3 / 2 + 15;
                }
                if (i == n - 1) {
                    n2 = DATA.SCR_RIGHT - n5 / 2 - 25 - oBJ2.iVX;
                } else {
                    oBJ = (OBJ)this._data._ground_enemies.elementAt(i + 1);
                    animImg = SUPER_DATA.AIMG_GRP1_ENEMY[oBJ2.iType];
                    n3 = animImg.getWidth();
                    n2 = oBJ.iX - n3 / 2 - 15;
                }
                if (oBJ2.iX < 25) {
                    oBJ2.iVX = Math.min(2, oBJ2.iVX + 1);
                } else if (oBJ2.iX > DATA.SCR_RIGHT - 25) {
                    oBJ2.iVX = Math.min(2, oBJ2.iVX - 1);
                } else if (oBJ2.iX < n4) {
                    oBJ2.iVX = Math.min(2, oBJ2.iVX + 1);
                } else if (oBJ2.iX > n2) {
                    oBJ2.iVX = Math.max(-2, oBJ2.iVX - 1);
                } else if (Utils.rndInt(32) == 32) {
                    oBJ2.iVX = oBJ2.iVX + Utils.rndInt(2) - 1;
                }
                animImg2.update();
                this.generateDiim(oBJ2);
            }
        }
        catch (Exception exception) {
            throw new Exception(">update_ground_enemies " + exception.toString());
        }
    }

    private void render_fly_enemies(Graphics graphics, Rect rect) throws Exception {
        try {
            int n = this._data._fly_enemies.size();
            for (int i = 0; i < n; ++i) {
                OBJ oBJ = (OBJ)this._data._fly_enemies.elementAt(i);
                AnimImg animImg = SUPER_DATA.AIMG_GRP2_ENEMY[oBJ.iType];
                animImg.update();
                int n2 = animImg.getHeight();
                if (oBJ.iY < -n2 / 2 || oBJ.iY > DATA.SCR_BOTTOM + n2 / 2) continue;
                int n3 = this._data.player.iY - oBJ.iY;
                int n4 = n3 > 0 ? 0 : 16384;
                animImg.draw(graphics, oBJ.iX, oBJ.iY, 5, n4, DATA._rcScreen);
                int n5 = this._data._iGamePart == 14 ? 100 : (this._data._iGamePart >= 10 ? 50 : 20);
                this.render_energy(graphics, rect, oBJ.iMaxEnergy, oBJ.iEnergy, oBJ.iX, oBJ.iY - animImg.getHeight() / 2 - 3, n5);
            }
        }
        catch (Exception exception) {
            throw new Exception(">render_fly_enemies " + exception.toString());
        }
    }

    private boolean isCompletedGroundSet() {
        return this._data._iGroundEnemyGroup > this._data._iLevel % SUPER_DATA.AIMG_GRP1_ENEMY.length;
    }

    private boolean isCompletedFlySet() {
        return this._data._iFlyEnemyGroup > this._data._iLevel % SUPER_DATA.AIMG_GRP2_ENEMY.length;
    }

    public boolean isCompletedEnemySet() {
        boolean bl = this.isCompletedGroundSet() && this.isCompletedFlySet();
        return bl;
    }

    public boolean isFinalWorldLevel() {
        int n = Math.max(SUPER_DATA.AIMG_GRP1_ENEMY.length, SUPER_DATA.AIMG_GRP2_ENEMY.length);
        return this._data._iLevel % n == n - 1;
    }

    private void genGroundEnemyGroup(int n, boolean bl) {
        int n2 = this._data._iLevel % SUPER_DATA.AIMG_GRP1_ENEMY.length;
        int n3 = this._data._iGamePart == 2 ? (this._data._iGroundEnemyGroup <= n2 ? this._data._iGroundEnemyGroup : Utils.rndInt(n2)) : (this._data._iGamePart == 6 ? Utils.rndInt(this._data._iGroundEnemyGroup) % SUPER_DATA.AIMG_GRP1_ENEMY.length : (this._data._iGamePart == 8 ? (this._data._iGroundEnemyGroup <= n2 ? this._data._iGroundEnemyGroup : Utils.rndInt(n2)) : (n2 + 1) % SUPER_DATA.AIMG_GRP1_ENEMY.length));
        AnimImg animImg = SUPER_DATA.AIMG_GRP1_ENEMY[n3];
        int n4 = animImg.getHeight();
        for (int i = 0; i < n; ++i) {
            OBJ oBJ = new OBJ();
            oBJ.id = 0 + i;
            oBJ.iCategory = 12;
            oBJ.iType = this._data._iGamePart == 6 ? Utils.rndInt(n3) : n3;
            oBJ.iX = (DATA.SCR_WIDTH - 10) * (i + 1) / (n + 1) + 5;
            oBJ.iY = -n4 / 2 - Utils.rndInt(DATA.SCR_H2);
            oBJ.iVX = 0;
            oBJ.iVY = 1;
            oBJ.iShadowOffset = 1;
            oBJ.iGunFires = 0;
            oBJ.iGunType = SUPER_DATA.GRP1_ENEMY_AMMO[oBJ.iType];
            oBJ.iEnergy = oBJ.iMaxEnergy = (SUPER_DATA.GRP1_ENEMY_ENERGY[oBJ.iType] + 100 * this._data._iDifficulty) * (bl ? 20 : 1);
            oBJ.lTimeStart = this.getGameTime();
            this._data._ground_enemies.addElement(oBJ);
        }
        ++this._data._iGroundEnemyGroup;
    }

    private void genFlyEnemyGroup(int n, boolean bl) {
        int n2 = this._data._iLevel % SUPER_DATA.AIMG_GRP1_ENEMY.length;
        int n3 = this._data._iGamePart == 4 ? (this._data._iFlyEnemyGroup <= n2 ? this._data._iFlyEnemyGroup : Utils.rndInt(n2)) : (this._data._iGamePart == 6 ? Utils.rndInt(this._data._iFlyEnemyGroup) % SUPER_DATA.AIMG_GRP1_ENEMY.length : (this._data._iGamePart == 8 ? (this._data._iFlyEnemyGroup <= n2 ? this._data._iFlyEnemyGroup : Utils.rndInt(n2)) : (n2 + 1) % SUPER_DATA.AIMG_GRP1_ENEMY.length));
        AnimImg animImg = SUPER_DATA.AIMG_GRP2_ENEMY[n3];
        int n4 = animImg.getHeight();
        for (int i = 0; i < n; ++i) {
            OBJ oBJ = new OBJ();
            oBJ.id = 1000 + i;
            oBJ.iCategory = 11;
            oBJ.iType = this._data._iGamePart == 6 ? Utils.rndInt(n3) : n3;
            oBJ.iX = (DATA.SCR_WIDTH - 10) * (i + 1) / (n + 1) + 5;
            oBJ.iY = -n4 / 2 - Utils.rndInt(DATA.SCR_H2);
            oBJ.iVX = SUPER_DATA.GRP2_ENEMY_VELOCITY_X[oBJ.iType];
            oBJ.iVY = 1;
            oBJ.iShadowOffset = 10 + Utils.rndInt(10);
            oBJ.iGunFires = 0;
            oBJ.iGunType = SUPER_DATA.GRP2_ENEMY_AMMO[oBJ.iType];
            oBJ.iEnergy = oBJ.iMaxEnergy = (SUPER_DATA.GRP2_ENEMY_ENERGY[oBJ.iType] + 100 * this._data._iDifficulty) * (bl ? 25 : 1);
            oBJ.lTimeStart = this.getGameTime();
            this._data._fly_enemies.addElement(oBJ);
        }
        ++this._data._iFlyEnemyGroup;
    }

    private void render_super_boss(Graphics graphics, Rect rect) throws Exception {
        if (this._data._iGamePart != 14) {
            return;
        }
        try {
            int n = this._data._boss_parts.size();
            for (int i = 0; i < n; ++i) {
                OBJ oBJ = (OBJ)this._data._boss_parts.elementAt(i);
                AnimImg animImg = IMG_DATA.AIMG_BOSS_PARTS[oBJ.iType];
                int n2 = oBJ.iX;
                int n3 = oBJ.iY;
                animImg.draw(graphics, n2, n3, oBJ.iAlign, oBJ.iManipulation, rect);
            }
            this.calc_boss_parts_bounds(this.__tmpRC);
            this.render_energy(graphics, rect, this._data.boss.iMaxEnergy, this._data.boss.iEnergy, this.__tmpRC.getCenterX(), this.__tmpRC.top + 3, this.__tmpRC.getWidth());
        }
        catch (Exception exception) {
            throw new Exception(">render_super_boss " + exception.toString());
        }
    }

    private void calc_boss_parts_bounds(Rect rect) {
        rect.reset();
        this.__tmpRC0.reset();
        int n = this._data._boss_parts.size();
        for (int i = 0; i < n; ++i) {
            OBJ oBJ = (OBJ)this._data._boss_parts.elementAt(i);
            AnimImg animImg = IMG_DATA.AIMG_BOSS_PARTS[oBJ.iType];
            animImg.getActiveFrameImg().getAlignedBounds(oBJ.iX, oBJ.iY, oBJ.iAlign, oBJ.iManipulation, this.__tmpRC0);
            Rect.union_box(this.__tmpRC0, rect, rect);
        }
    }

    private void update_super_boss() throws Exception {
        if (this._data._iGamePart != 14) {
            return;
        }
        int n = -1;
        int n2 = -10000000;
        try {
            OBJ oBJ;
            int n3;
            int n4;
            n = 0;
            for (n4 = 0; n4 < IMG_DATA.AIMG_BOSS_PARTS.length; ++n4) {
                n = 1;
                IMG_DATA.AIMG_BOSS_PARTS[n4].update();
            }
            n = 2;
            n4 = this._data._iLevel % IMG_DATA.INFO_BOSS_PARTS.length;
            n = 3;
            int n5 = IMG_DATA.INFO_BOSS_PARTS[n4].length;
            n = 4;
            if (this._data.boss.iMaxEnergy == 0) {
                return;
            }
            int n6 = n5 * this._data.boss.iEnergy / this._data.boss.iMaxEnergy;
            n = 5;
            int n7 = this._data._boss_parts.size();
            int n8 = n7 - 2;
            n = 6;
            for (n3 = n7 - 1; n3 >= 0; --n3) {
                n = 7;
                oBJ = (OBJ)this._data._boss_parts.elementAt(n3);
                n = 8;
                oBJ.iX += oBJ.iVX;
                oBJ.iY += oBJ.iVY;
                n = 9;
                if (oBJ.idMaster > n6) {
                    this.addExplosion(0, oBJ, oBJ, 0, 0);
                    this._data._boss_parts.removeElementAt(n3);
                    continue;
                }
                if (n3 >= SUPER_DATA.COUNT_BOSS_ROCKET[this._data._iLevel]) continue;
                this.doEnemyFire(oBJ);
            }
            n = 10;
            this.calc_boss_parts_bounds(this.__tmpRC);
            n7 = this._data._boss_parts.size();
            if (this.__tmpRC.left < 0) {
                for (n3 = 0; n3 < n7; ++n3) {
                    oBJ = (OBJ)this._data._boss_parts.elementAt(n3);
                    oBJ.iVX = Math.min(2, oBJ.iVX + 1);
                }
            } else if (this.__tmpRC.right > DATA.SCR_RIGHT) {
                for (n3 = 0; n3 < n7; ++n3) {
                    oBJ = (OBJ)this._data._boss_parts.elementAt(n3);
                    oBJ.iVX = Math.max(-2, oBJ.iVX - 1);
                }
            }
            n = 19;
            if (this.__tmpRC.top < 0) {
                for (n3 = 0; n3 < n7; ++n3) {
                    oBJ = (OBJ)this._data._boss_parts.elementAt(n3);
                    oBJ.iVY = Math.min(1, oBJ.iVY + 1);
                }
            } else if (this.__tmpRC.bottom > DATA.SCR_HEIGHT / 3) {
                for (n3 = 0; n3 < n7; ++n3) {
                    oBJ = (OBJ)this._data._boss_parts.elementAt(n3);
                    oBJ.iVY = Math.max(-1, oBJ.iVY - 1);
                }
            }
            n = 20;
        }
        catch (Exception exception) {
            throw new Exception(">update_super_boss s=" + n + " iType=" + n2 + " " + exception.toString());
        }
    }

    private void genSuperBoss() throws Exception {
        int n = -1;
        int n2 = -1;
        try {
            OBJ oBJ;
            n = 1;
            int n3 = this._data._iLevel % IMG_DATA.INFO_BOSS_PARTS.length;
            n = 2;
            int n4 = IMG_DATA.INFO_BOSS_PARTS[n3].length;
            n = 3;
            int[][] nArray = IMG_DATA.INFO_BOSS_PARTS[n3];
            n = 4;
            for (n2 = 0; n2 < n4; ++n2) {
                n = 5;
                oBJ = new OBJ();
                n = 6;
                oBJ.idMaster = n2;
                oBJ.id = 5000 + n2;
                n = 7;
                oBJ.iType = nArray[n2][0];
                n = 8;
                oBJ.iCategory = 100;
                n = 9;
                oBJ.iManipulation = 0;
                n = 10;
                oBJ.iAlign = 0;
                n = 11;
                oBJ.iX = 15 + nArray[n2][1];
                n = 12;
                oBJ.iY = 0 + nArray[n2][2];
                n = 13;
                oBJ.iVX = 3;
                oBJ.iVY = 2;
                oBJ.iShadowOffset = 10;
                oBJ.iGunFires = 0;
                n = 14;
                oBJ.iGunType = 11;
                n = 15;
                oBJ.iGunMultiplier = 1;
                oBJ.iEnergy = oBJ.iMaxEnergy = 1;
                oBJ.lTimeStart = this.getGameTime();
                n = 16;
                this._data._boss_parts.addElement(oBJ);
            }
            n = 20;
            this.calc_boss_parts_bounds(this.__tmpRC);
            for (n2 = 0; n2 < n4; ++n2) {
                int n5;
                n = 5;
                oBJ = new OBJ();
                n = 6;
                oBJ.idMaster = n2;
                oBJ.id = 5000 + n2;
                n = 7;
                oBJ.iType = nArray[n2][4];
                n = 8;
                oBJ.iCategory = 100;
                n = 9;
                oBJ.iManipulation = 0;
                n = 10;
                AnimImg animImg = IMG_DATA.AIMG_BOSS_PARTS[oBJ.iType];
                oBJ.iX = 15 + nArray[n2][1];
                oBJ.iX = n5 = this.__tmpRC.right - (oBJ.iX + animImg.getWidth() - (this.__tmpRC.left - this.__tmpRC.getHeight() / 2));
                oBJ.iY = 0 + nArray[n2][2];
                oBJ.iAlign = 0;
                n = 11;
                n = 13;
                oBJ.iVX = 3;
                oBJ.iVY = 2;
                oBJ.iShadowOffset = 10;
                oBJ.iGunFires = 0;
                n = 14;
                oBJ.iGunType = 11;
                n = 15;
                oBJ.iGunMultiplier = 1;
                oBJ.iEnergy = oBJ.iMaxEnergy = 1;
                oBJ.lTimeStart = this.getGameTime();
                n = 16;
                this._data._boss_parts.addElement(oBJ);
            }
            n = 20;
            this._data.boss.iEnergy = this._data.boss.iMaxEnergy = 10000 + this._data._iLevel * 5000;
            ++this._data._iEnemyGroup;
        }
        catch (Exception exception) {
            throw new Exception("genSuperBoss() s=" + n + " iPart=" + n2 + " " + exception.toString());
        }
    }

    private void next_game_part() {
        ++this._data._iGamePart;
        this._data._iEnemyGroup = 0;
        this._data._iGroundEnemyGroup = 0;
        this._data._iFlyEnemyGroup = 0;
        this.unsetGroundMark();
    }

    private void setGroundMark(long l) {
        this._data._lGroundMark = this._data._lGroundOffset + l;
    }

    private void unsetGroundMark() {
        this._data._lGroundMark = Long.MIN_VALUE;
    }

    private boolean noGroundMark() {
        return this._data._lGroundMark == Long.MIN_VALUE;
    }

    private boolean isArrivedGroundMark() {
        return this._data._lGroundOffset >= this._data._lGroundMark;
    }

    private boolean noGroundThing() {
        boolean bl = true;
        OBJ[] oBJArray = this._data._ground_things;
        Img[] imgArray = IMG_DATA.IMG_GROUND_THINGS;
        for (int i = 0; i < oBJArray.length; ++i) {
            OBJ oBJ = oBJArray[i];
            Img img = imgArray[oBJ.iType];
            int n = img.getHeight();
            if (oBJ.iY < -n || oBJ.iY >= DATA.SCR_HEIGHT) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private void killGroundThings() {
        OBJ[] oBJArray = this._data._ground_things;
        Img[] imgArray = IMG_DATA.IMG_GROUND_THINGS;
        for (int i = 0; i < oBJArray.length; ++i) {
            OBJ oBJ = oBJArray[i];
            oBJ.iY = Integer.MAX_VALUE;
        }
    }

    private boolean isAcceptedGroundThings() {
        return this.isBarrierTime();
    }

    private boolean isEnemyTime() {
        return this._data._bEnemyTime;
    }

    private boolean isBarrierTime() {
        return this._data._bBarrierTime;
    }

    private void generate_enemies() throws Exception {
        try {
            this._data._bEnemyTime = false;
            this._data._bBarrierTime = false;
            switch (this._data._iGamePart) {
                case 0: {
                    if (this._data._iState != 4) break;
                    if (this.noGroundMark()) {
                        this.setGroundMark(10 * DATA.SCR_HEIGHT);
                    }
                    if (this.isArrivedGroundMark()) {
                        this.next_game_part();
                    }
                    break;
                }
                case 1: {
                    this._data._bBarrierTime = true;
                    if (this._data._iState != 4) break;
                    if (this.noGroundMark()) {
                        this.setGroundMark(5 * DATA.SCR_HEIGHT);
                    }
                    if (this.isArrivedGroundMark() && this.noGroundThing()) {
                        this.killGroundThings();
                        this.next_game_part();
                    }
                    break;
                }
                case 2: {
                    this._data._bEnemyTime = true;
                    if (this._data._iState != 4 || this._data._ground_enemies.size() > 0 || this._data._enemy_ammos.size() > 0) break;
                    if (this.isCompletedGroundSet()) {
                        this.next_game_part();
                        break;
                    }
                    this.genGroundEnemyGroup(2 + this._data._iDifficulty, false);
                    break;
                }
                case 3: {
                    this._data._bBarrierTime = true;
                    if (this._data._iState != 4) break;
                    if (this.noGroundMark()) {
                        this.setGroundMark(5 * DATA.SCR_HEIGHT);
                    }
                    if (this.isArrivedGroundMark() && this.noGroundThing()) {
                        this.killGroundThings();
                        this.next_game_part();
                    }
                    break;
                }
                case 4: {
                    this._data._bEnemyTime = true;
                    if (this._data._iState != 4 || this._data._fly_enemies.size() > 0 || this._data._enemy_ammos.size() > 0) break;
                    if (this.isCompletedFlySet()) {
                        this.next_game_part();
                        break;
                    }
                    this.genFlyEnemyGroup(2 + this._data._iDifficulty, false);
                    break;
                }
                case 5: {
                    this._data._bBarrierTime = true;
                    if (this._data._iState != 4) break;
                    if (this.noGroundMark()) {
                        this.setGroundMark(5 * DATA.SCR_HEIGHT);
                    }
                    if (this.isArrivedGroundMark() && this.noGroundThing()) {
                        this.killGroundThings();
                        this.next_game_part();
                    }
                    break;
                }
                case 6: {
                    this._data._bEnemyTime = true;
                    if (this._data._iState != 4 || this._data._enemy_ammos.size() > 0 || this._data._ground_enemies.size() > 0 || this._data._fly_enemies.size() > 0) break;
                    if (this.isCompletedEnemySet()) {
                        this.next_game_part();
                        break;
                    }
                    if (this._data._iGroundEnemyGroup <= this._data._iFlyEnemyGroup) {
                        this.genGroundEnemyGroup(2 + this._data._iDifficulty, false);
                        break;
                    }
                    this.genFlyEnemyGroup(2 + this._data._iDifficulty, false);
                    break;
                }
                case 7: {
                    this._data._bBarrierTime = true;
                    if (this._data._iState != 4) break;
                    if (this.noGroundMark()) {
                        this.setGroundMark(5 * DATA.SCR_HEIGHT);
                    }
                    if (this.isArrivedGroundMark() && this.noGroundThing()) {
                        this.killGroundThings();
                        this.next_game_part();
                    }
                    break;
                }
                case 8: {
                    this._data._bEnemyTime = true;
                    if (this._data._iState != 4 || this._data._enemy_ammos.size() > 0 || this._data._ground_enemies.size() > 0 || this._data._fly_enemies.size() > 0) break;
                    if (this.isCompletedEnemySet()) {
                        this.next_game_part();
                        SND_DATA.SND_GAME_GET_TO_BOSS.play();
                        break;
                    }
                    if (Utils.rndInt(1) == 1) {
                        this.genGroundEnemyGroup(2 + this._data._iDifficulty, false);
                        break;
                    }
                    this.genFlyEnemyGroup(2 + this._data._iDifficulty, false);
                    break;
                }
                case 9: {
                    if (this._data._iState != 4) break;
                    if (this.noGroundMark()) {
                        this.setGroundMark(10 * DATA.SCR_HEIGHT);
                    }
                    if (this.isArrivedGroundMark() && this.noGroundThing()) {
                        this.killGroundThings();
                        SND_DATA.SND_GAME_GET_TO_BOSS.play();
                        this.next_game_part();
                        if (this._data._iLevel == 4 || this._data._iLevel == 9) {
                            this._data._iGamePart = 12;
                            break;
                        }
                        if (this._data._iLevel < 4) {
                            this._data._iGamePart = 10;
                            break;
                        }
                        this._data._iGamePart = 11;
                    }
                    break;
                }
                case 10: {
                    if (this._data._iState != 4 || this._data._enemy_ammos.size() > 0 || this._data._ground_enemies.size() > 0) break;
                    if (this._data._iGroundEnemyGroup == 0) {
                        this.genGroundEnemyGroup(2 + this._data._iDifficulty, true);
                        break;
                    }
                    this.next_game_part();
                    this._data._iGamePart = 13;
                    SND_DATA.SND_GAME_GET_TO_BOSS.play();
                    break;
                }
                case 11: {
                    if (this._data._iState != 4 || this._data._enemy_ammos.size() > 0 || this._data._fly_enemies.size() > 0) break;
                    if (this._data._iFlyEnemyGroup == 0) {
                        this.genFlyEnemyGroup(2 + this._data._iDifficulty, true);
                        break;
                    }
                    this.next_game_part();
                    this._data._iGamePart = 13;
                    SND_DATA.SND_GAME_GET_TO_BOSS.play();
                    break;
                }
                case 12: {
                    if (this._data._iState != 4 || this._data._enemy_ammos.size() > 0 || this._data._ground_enemies.size() > 0 || this._data._fly_enemies.size() > 0) break;
                    if (this._data._iFlyEnemyGroup == 0) {
                        this.genGroundEnemyGroup(2 + this._data._iDifficulty, true);
                        this.genFlyEnemyGroup(2 + this._data._iDifficulty, true);
                        break;
                    }
                    this.next_game_part();
                    this._data._iGamePart = 13;
                    SND_DATA.SND_GAME_GET_TO_BOSS.play();
                    break;
                }
                case 13: {
                    if (this._data._iState != 4) break;
                    if (this.noGroundMark()) {
                        this.setGroundMark(10 * DATA.SCR_HEIGHT);
                    }
                    if (this.isArrivedGroundMark() && this.noGroundThing()) {
                        this.killGroundThings();
                        SND_DATA.SND_GAME_GET_TO_BOSS.play();
                        this.next_game_part();
                        this._data._iGamePart = 14;
                    }
                    break;
                }
                case 14: {
                    if (this._data._iState != 4 || this._data._enemy_ammos.size() > 0 || this._data._boss_parts.size() > 0) break;
                    if (this._data._iEnemyGroup == 0) {
                        this.genSuperBoss();
                        break;
                    }
                    this.next_game_part();
                    this._data._iGamePart = 15;
                    break;
                }
                case 15: {
                    if (this._data._iState != 4) {
                        return;
                    }
                    this.next_game_part();
                    break;
                }
                default: {
                    if (this._data._iLevel >= 9) {
                        this.setState(7);
                        break;
                    }
                    this.setState(2);
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("generate_enemies iPart=" + this._data._iGamePart + " " + exception.toString());
        }
    }

    private void update_fly_enemies() throws Exception {
        try {
            if (SUPER_DATA.AIMG_GRP2_ENEMY.length == 0) {
                return;
            }
            int n = this._data._fly_enemies.size();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                AnimImg animImg;
                OBJ oBJ;
                int n4;
                OBJ oBJ2 = (OBJ)this._data._fly_enemies.elementAt(i);
                if (oBJ2.iEnergy <= 0) continue;
                AnimImg animImg2 = SUPER_DATA.AIMG_GRP2_ENEMY[oBJ2.iType];
                int n5 = animImg2.getWidth();
                int n6 = animImg2.getHeight();
                int n7 = this._data.player.iY - oBJ2.iY;
                int n8 = this._data.getGroundVelocity() + 1;
                if (!bl && this.doEnemyFire(oBJ2) != null) {
                    oBJ2.iVY = n7 > 0 ? -5 : 5;
                    bl = true;
                }
                if (oBJ2.iY > DATA.SCR_H2 && this._data.player.iY > DATA.SCR_H2) {
                    oBJ2.iVY = -7;
                } else if (oBJ2.iY < DATA.SCR_H2 && this._data.player.iY < DATA.SCR_H2) {
                    oBJ2.iVY = 7;
                } else if (oBJ2.iY < -n6 / 2) {
                    oBJ2.iVY = n8;
                    oBJ2.iY = -n6 / 2;
                } else if (oBJ2.iY > DATA.SCR_BOTTOM + n6 / 2) {
                    oBJ2.iVY = -n8;
                    oBJ2.iY = DATA.SCR_BOTTOM + n6 / 2;
                } else if (oBJ2.iY < n6 / 2) {
                    oBJ2.iVY = n8;
                } else if (oBJ2.iY > DATA.SCR_BOTTOM - n6 / 2) {
                    oBJ2.iVY = -n8;
                } else if (Utils.rndInt(30) == 30) {
                    oBJ2.iVY = Utils.rndInt(2) - 1;
                }
                oBJ2.iX += oBJ2.iVX;
                oBJ2.iY += oBJ2.iVY;
                if (i == 0) {
                    n4 = n5 / 2 + 25 + oBJ2.iVX;
                } else {
                    oBJ = (OBJ)this._data._fly_enemies.elementAt(i - 1);
                    animImg = SUPER_DATA.AIMG_GRP2_ENEMY[oBJ2.iType];
                    n3 = animImg.getWidth();
                    n4 = oBJ.iX + n3 / 2 + 10;
                }
                if (i == n - 1) {
                    n2 = DATA.SCR_RIGHT - n5 / 2 - 25 - oBJ2.iVX;
                } else {
                    oBJ = (OBJ)this._data._fly_enemies.elementAt(i + 1);
                    animImg = SUPER_DATA.AIMG_GRP2_ENEMY[oBJ2.iType];
                    n3 = animImg.getWidth();
                    n2 = oBJ.iX - n3 / 2 - 10;
                }
                if (oBJ2.iX < 25) {
                    oBJ2.iVX = Math.min(2, oBJ2.iVX + 1);
                } else if (oBJ2.iX > DATA.SCR_RIGHT - 25) {
                    oBJ2.iVX = Math.min(2, oBJ2.iVX - 1);
                } else if (oBJ2.iX < n4) {
                    oBJ2.iVX = Math.min(2, oBJ2.iVX + 1);
                } else if (oBJ2.iX > n2) {
                    oBJ2.iVX = Math.max(-2, oBJ2.iVX - 1);
                } else if (Utils.rndInt(32) == 32) {
                    oBJ2.iVX = oBJ2.iVX + Utils.rndInt(2) - 1;
                }
                animImg2.update();
                this.generateDiim(oBJ2);
            }
        }
        catch (Exception exception) {
            throw new Exception(">update_fly_enemies " + exception.toString());
        }
    }

    private void generateDiim(OBJ oBJ) throws Exception {
        int n = -1;
        try {
            n = 0;
            if (oBJ.iEnergy > oBJ.iMaxEnergy * 3 / 4) {
                n = 1;
            } else if (oBJ.iEnergy > oBJ.iMaxEnergy / 2) {
                n = 2;
                if (oBJ.lEffectTimeStart == Long.MIN_VALUE || this.getGameTime() - oBJ.lEffectTimeStart > 500L) {
                    n = 3;
                    OBJ oBJ2 = this.addBlast(2, oBJ, oBJ, Utils.rndInt(20) - 10, Utils.rndInt(10) - 5);
                    n = 4;
                    oBJ2.iVY = this._data.getGroundVelocity() + 1;
                    n = 5;
                    oBJ.lEffectTimeStart = this.getGameTime();
                    n = 6;
                }
                n = 7;
            } else if (oBJ.iEnergy > oBJ.iMaxEnergy / 4) {
                n = 8;
                if (oBJ.lEffectTimeStart == Long.MIN_VALUE || this.getGameTime() - oBJ.lEffectTimeStart > 250L) {
                    n = 9;
                    OBJ oBJ3 = this.addBlast(2, oBJ, oBJ, Utils.rndInt(20) - 10, Utils.rndInt(10) - 5);
                    n = 10;
                    oBJ3.iVY = this._data.getGroundVelocity() + 1;
                    n = 11;
                    oBJ.lEffectTimeStart = this.getGameTime();
                    n = 12;
                }
                n = 13;
            } else {
                n = 14;
                if (oBJ.lEffectTimeStart == Long.MIN_VALUE || this.getGameTime() - oBJ.lEffectTimeStart > 125L) {
                    n = 15;
                    OBJ oBJ4 = this.addBlast(2, oBJ, oBJ, Utils.rndInt(20) - 10, Utils.rndInt(10) - 5);
                    n = 16;
                    oBJ4.iVY = this._data.getGroundVelocity() + 1;
                    n = 17;
                    oBJ.lEffectTimeStart = this.getGameTime();
                    n = 18;
                }
                n = 19;
            }
            n = 20;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception(">generateDiim s=" + n + " " + exception.toString());
        }
    }

    private void render_effects(Graphics graphics, Rect rect) throws Exception {
        try {
            for (int i = 0; i < this._data._effects.size(); ++i) {
                OBJ oBJ = (OBJ)this._data._effects.elementAt(i);
                int n = oBJ.iX;
                int n2 = oBJ.iY;
                AnimImg animImg = SUPER_DATA.AIMG_EFFECTS[oBJ.iType];
                animImg.draw(graphics, n, n2, 5, 0, rect);
            }
        }
        catch (Exception exception) {
            throw new Exception(">render_effects " + exception.toString());
        }
    }

    private void update_effects() throws Exception {
        try {
            Object object;
            int n;
            for (n = 0; n < SUPER_DATA.AIMG_EFFECTS.length; ++n) {
                object = SUPER_DATA.AIMG_EFFECTS[n];
                ((AnimImg)object).update();
            }
            for (n = this._data._effects.size() - 1; n >= 0; --n) {
                object = (OBJ)this._data._effects.elementAt(n);
                if (this.getGameTime() - ((OBJ)object).lTimeStart > 500L) {
                    this.destroyEffect(n);
                    continue;
                }
                AnimImg animImg = SUPER_DATA.AIMG_EFFECTS[((OBJ)object).iType];
                ((OBJ)object).iX += ((OBJ)object).iVX;
                ((OBJ)object).iY += ((OBJ)object).iVY;
                Img img = animImg.getActiveFrameImg();
                int n2 = (img.getWidth() + 1) / 2;
                int n3 = (img.getHeight() + 1) / 2;
                if (((OBJ)object).iX >= -n2 && ((OBJ)object).iX <= DATA.SCR_WIDTH + n2 && ((OBJ)object).iY >= -n3 + 25 && ((OBJ)object).iY <= DATA.SCR_HEIGHT - 25 + n3) continue;
                this.destroyEffect(n);
                break;
            }
        }
        catch (Exception exception) {
            throw new Exception(">update_PlayerAmmo " + exception.toString());
        }
    }
}

