/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Settings
extends SceneImpl
implements IMG_DATA,
SND_DATA {
    private static Settings _instance = null;
    private static String STORE_NAME = "SETTINGS";
    private int _iDifficulty = 1;
    private boolean _bAutofire = false;
    private int _iSelected = 0;
    private int _iY = -1;
    private int _iMaxH = -1;
    private boolean _readSndInf = true;

    public static Settings getInstance() {
        if (_instance == null) {
            _instance = new Settings();
        }
        return _instance;
    }

    private Settings() {
        _instance = this;
        this._readSndInf = true;
    }

    public void reverseSound() {
        Snd.reverseEnabled();
        Snd_nok.reverseEnabled();
        this.save();
    }

    public int getDifficulty() {
        return this._iDifficulty;
    }

    public boolean getAutofire() {
        return this._bAutofire;
    }

    public int getFX() {
        return 2;
    }

    public IImg getFXImage() {
        return ImgPanel.getInstance();
    }

    public void onPressedUp() {
        this._iSelected = this._iSelected <= 0 ? 4 : --this._iSelected;
    }

    public void onPressedDown() {
        this._iSelected = this._iSelected == 4 ? 0 : ++this._iSelected;
    }

    public void onPressedLeft() throws Exception {
        this.onPressedFire();
    }

    public void onPressedRight() throws Exception {
        this.onPressedFire();
    }

    public void onPressedFire() {
        if (this._iSelected < 3) {
            this._iDifficulty = this._iSelected;
        } else if (this._iSelected == 3) {
            this.reverseSound();
        } else if (this._iSelected == 4) {
            this._bAutofire = !this._bAutofire;
        }
        SND_DATA.SND_CLCIK.play();
    }

    public void onPressedCmd1() {
        MainMenu mainMenu = MainMenu.getInstance();
        mainMenu.setStartMenuIndex(2);
        GameManager.getInstance().setScene(mainMenu);
    }

    public void onActivation() {
        this._iY = -1;
        this._iMaxH = -1;
        this._readSndInf = false;
        this.load();
    }

    public void onDeactivation() {
        this.save();
    }

    public void load() {
        RecordStore recordStore = null;
        try {
            if (Utils.hasRS(STORE_NAME)) {
                recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(1));
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                if (this._readSndInf) {
                    Snd.setEnabled(dataInputStream.readBoolean());
                    Snd_nok.setEnabled(Snd.isEnabled());
                }
                this._iDifficulty = dataInputStream.readInt();
                this._bAutofire = dataInputStream.readBoolean();
                recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
            Utils.deleteRS(STORE_NAME);
            exception.printStackTrace();
        }
    }

    public void save() {
        try {
            try {
                if (Utils.hasRS(STORE_NAME)) {
                    RecordStore.deleteRecordStore((String)STORE_NAME);
                }
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(20);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(Snd.isEnabled());
            dataOutputStream.writeInt(this._iDifficulty);
            dataOutputStream.writeBoolean(this._bAutofire);
            recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void drawCursor(Graphics graphics, int n, int n2) {
        if (this._iY == -1) {
            this._iY = n;
            this._iMaxH = n2;
        } else {
            this._iY = (this._iY + n) / 2;
            this._iMaxH = (this._iMaxH + n2) / 2;
        }
        Utils.setClip(graphics, DATA._rcScreen);
        graphics.setColor(0xFF8080);
        graphics.drawLine(21, this._iY - 3, DATA.SCR_RIGHT - 21, this._iY - 3);
        graphics.drawLine(20, this._iY - 2, DATA.SCR_RIGHT - 20, this._iY - 2);
        graphics.drawLine(20, this._iY + this._iMaxH + 2, DATA.SCR_RIGHT - 20, this._iY + this._iMaxH + 2);
        graphics.drawLine(21, this._iY + this._iMaxH + 3, DATA.SCR_RIGHT - 21, this._iY + this._iMaxH + 3);
        graphics.drawLine(19, this._iY, 19, this._iY + this._iMaxH);
        graphics.drawLine(18, this._iY + 1, 18, this._iY + this._iMaxH - 1);
        graphics.drawLine(DATA.SCR_RIGHT - 19, this._iY, DATA.SCR_RIGHT - 19, this._iY + this._iMaxH);
        graphics.drawLine(DATA.SCR_RIGHT - 18, this._iY + 1, DATA.SCR_RIGHT - 18, this._iY + this._iMaxH - 1);
        graphics.drawRect(0, this._iY + this._iMaxH / 2 - 1, 17, 2);
        graphics.drawRect(DATA.SCR_RIGHT - 17, this._iY + this._iMaxH / 2 - 1, 17, 2);
    }

    public void render(Graphics graphics, Rect rect) {
        try {
            int n;
            int n2;
            for (int i = 0; i < DATA.SCR_BOTTOM; i += IMG_DATA.IMG_PANEL_BODY.getHeight()) {
                IMG_DATA.IMG_PANEL_BODY.draw(graphics, 0, i, 0, 0, rect);
            }
            IMG_DATA.IMG_PANEL_BORDER.draw(graphics, 0, 162, 0, 0, rect);
            IMG_DATA.IMG_TEXT_SETTINGS.draw(graphics, DATA.SCR_W2, 5, 1, 0, rect);
            IMG_DATA.IMG_TEXT_MENU.draw(graphics, 3, DATA.SCR_BOTTOM - 2, 8, 0, rect);
            graphics.setFont(DATA.fntSmallBold);
            int n3 = 20;
            for (int i = 0; i < 3; ++i) {
                n2 = Math.max(IMG_DATA.IMG_SETTINGS_LED[i][0].getHeight(), IMG_DATA.IMG_SETTINGS_TEXT[i].getHeight());
                IMG_DATA.IMG_SETTINGS_TEXT[i].draw(graphics, 85, n3 + (n2 - IMG_DATA.IMG_SETTINGS_TEXT[i].getHeight()) / 2, 2, 0, rect);
                n = i == this._iDifficulty ? 0 : 1;
                IMG_DATA.IMG_SETTINGS_LED[i][n].draw(graphics, 120, n3, 1, 0, rect);
                if (this._iSelected == i) {
                    this.drawCursor(graphics, n3, n2);
                }
                n3 += n2 + 6;
            }
            n2 = Math.max(IMG_DATA.IMG_SETTINGS_LED[3][0].getHeight(), IMG_DATA.IMG_SETTINGS_TEXT[3].getHeight());
            IMG_DATA.IMG_SETTINGS_TEXT[3].draw(graphics, 85, n3 + (n2 - IMG_DATA.IMG_SETTINGS_TEXT[3].getHeight()) / 2, 2, 0, rect);
            n = Snd.isEnabled() && Snd_nok.isEnabled() ? 0 : 1;
            IMG_DATA.IMG_SETTINGS_LED[3][n].draw(graphics, 120, n3, 1, 0, rect);
            if (this._iSelected == 3) {
                this.drawCursor(graphics, n3, n2);
            }
            n3 += n2 + 6;
            n2 = Math.max(IMG_DATA.IMG_SETTINGS_LED[4][0].getHeight(), IMG_DATA.IMG_SETTINGS_TEXT[4].getHeight());
            IMG_DATA.IMG_SETTINGS_TEXT[4].draw(graphics, 85, n3 + (n2 - IMG_DATA.IMG_SETTINGS_TEXT[4].getHeight()) / 2, 2, 0, rect);
            n = this._bAutofire ? 0 : 1;
            IMG_DATA.IMG_SETTINGS_LED[4][n].draw(graphics, 120, n3, 1, 0, rect);
            if (this._iSelected == 4) {
                this.drawCursor(graphics, n3, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

