/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDletStateChangeException;

public class MainMenu
extends SceneImpl
implements IMG_DATA,
SND_DATA {
    public static final int MI_NEW_GAME = 0;
    public static final int MI_CONTINUE_GAME = 1;
    public static final int MI_SETTING = 2;
    public static final int MI_HIGHSCORES = 3;
    public static final int MI_HELP = 4;
    public static final int MI_ABOUT = 5;
    public static final int MI_EXIT = 6;
    public static final int _MI_FIRST = 1;
    public static final int _MI_LAST = 6;
    public static final int _MI_COUNT = 7;
    public static final int ARROW_L_X = 23;
    public static final int ARROW_L_Y = 180;
    public static final int ARROW_R_X = 141;
    public static final int ARROW_R_Y = 180;
    public static final int ANIMATON_FRAMES = 27;
    private int _iFrame = 0;
    private int _iFrames = 0;
    private int _iItemEnabledCount = 7;
    private boolean[] _bEnabledItems = new boolean[7];
    private Rect _rcArrowL = new Rect();
    private Rect _rcArrowR = new Rect();
    private Rect _rcItem = new Rect();
    private Rect _rcClippedArrowL = new Rect();
    private Rect _rcClippedArrowR = new Rect();
    private Rect _rcClippedItem = new Rect();
    public boolean _bShowArrowL = false;
    public boolean _bShowArrowR = false;
    private int _iActiveItemIndex = 0;
    private int _iOldItemIndex = 0;
    private int _iDirection = 0;
    private static MainMenu _instance = null;

    public static MainMenu getInstance() {
        if (_instance == null) {
            _instance = new MainMenu();
        }
        return _instance;
    }

    private MainMenu() {
        _instance = this;
        try {
            int n;
            for (n = 0; n < 7; ++n) {
                this._bEnabledItems[n] = true;
            }
            this._rcArrowL.setBounds(23, 180, IMG_DATA.IMG_MENU_ARROW_L.getWidth(), IMG_DATA.IMG_MENU_ARROW_L.getHeight());
            this._rcArrowR.setBounds(141, 180, IMG_DATA.IMG_MENU_ARROW_R.getWidth(), IMG_DATA.IMG_MENU_ARROW_R.getHeight());
            n = IMG_DATA.__ARR_MENU_ITEMS[0].getWidth();
            int n2 = IMG_DATA.__ARR_MENU_ITEMS[0].getHeight();
            this._rcItem.setBounds(this._rcArrowL.right + (this._rcArrowR.left - this._rcArrowL.right - n) / 2, 180 + (IMG_DATA.IMG_MENU_ARROW_L.getHeight() - n2) / 2, n, n2);
            this.setStartMenuIndex(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getFX() {
        return 0;
    }

    public IImg getFXImage() {
        return DATA.IMG_MENU_BACKGROUND;
    }

    public void onActivation() {
        DATA.SND_MENU_START.play();
        this.setStartMenuIndex(this._iActiveItemIndex);
    }

    public void onDeactivation() {
        this._iFrame = 0;
        this._iFrames = 0;
    }

    public void onShow() {
    }

    public void setStartMenuIndex(int n) {
        if (n == 1) {
            boolean bl = Game.hasSavedGame();
            this.setItemEnabled(1, bl);
            if (bl) {
                this._iActiveItemIndex = 1;
                this._iOldItemIndex = 1;
            } else {
                this._iActiveItemIndex = 0;
                this._iOldItemIndex = 0;
            }
        } else {
            this._iActiveItemIndex = n;
            this._iOldItemIndex = n;
        }
    }

    public void setActiveItemIndex(int n) {
        int n2 = this._iActiveItemIndex;
        if (this._bEnabledItems[n2]) {
            this._iOldItemIndex = n2;
        }
        this._iActiveItemIndex = n;
        this._iDirection = 0;
    }

    public void setItemEnabled(int n, boolean bl) {
        boolean bl2 = this._bEnabledItems[n];
        if (bl2 != bl) {
            this._iItemEnabledCount = bl ? ++this._iItemEnabledCount : --this._iItemEnabledCount;
            this._bEnabledItems[n] = bl;
        }
    }

    public void setPrevItemIndex() {
        this._iDirection = 0;
        int n = this._iActiveItemIndex;
        int n2 = this._iItemEnabledCount;
        if (n2 <= 0) {
            return;
        }
        if (n2 == 1 && this._bEnabledItems[n]) {
            return;
        }
        do {
            if (n > 0) {
                this.setActiveItemIndex(n - 1);
                continue;
            }
            this.setActiveItemIndex(6);
        } while (!this._bEnabledItems[n = this._iActiveItemIndex]);
        this._iDirection = -1;
    }

    public void setNextItemIndex() {
        this._iDirection = 0;
        int n = this._iActiveItemIndex;
        int n2 = this._iItemEnabledCount;
        if (n2 <= 0) {
            return;
        }
        if (n2 == 1 && this._bEnabledItems[n]) {
            return;
        }
        do {
            if (n < 6) {
                this.setActiveItemIndex(n + 1);
                continue;
            }
            this.setActiveItemIndex(0);
        } while (!this._bEnabledItems[n = this._iActiveItemIndex]);
        this._iDirection = 1;
    }

    public void onPressedLeft() {
        this.press_prev();
    }

    public void onPressedCmd1() {
        this.press_prev();
    }

    public void onPressedRight() {
        this.press_next();
    }

    public void onPressedCmd2() {
        this.press_next();
    }

    public void onUnpressedLeft() {
        this.unpress_prev();
    }

    public void onUnpressedCmd1() {
        this.unpress_prev();
    }

    public void onUnpressedRight() {
        this.unpress_next();
    }

    public void onUnpressedCmd2() {
        this.unpress_next();
    }

    private void unpress_prev() {
        this._bShowArrowL = false;
    }

    private void unpress_next() {
        this._bShowArrowR = false;
    }

    public void onPressedFire() {
        SND_DATA.SND_MENU_FIRE.play();
        switch (this._iActiveItemIndex) {
            case 1: {
                Game.getInstance().continueGame();
                break;
            }
            case 0: {
                GameManager.getInstance().setScene(SelectPlayer.getInstance());
                break;
            }
            case 3: {
                GameManager.getInstance().setScene(HighScores.getInstance());
                break;
            }
            case 2: {
                GameManager.getInstance().setScene(Settings.getInstance());
                break;
            }
            case 4: {
                GameManager.getInstance().setScene(Help.getInstance());
                break;
            }
            case 5: {
                GameManager.getInstance().setScene(About.getInstance());
                break;
            }
            case 6: {
                try {
                    Midlet.getInstance().destroyApp(true);
                    break;
                }
                catch (MIDletStateChangeException mIDletStateChangeException) {
                    mIDletStateChangeException.printStackTrace();
                }
            }
        }
    }

    private void press_prev() {
        SND_DATA.SND_MENU_CHANGE.play();
        this._bShowArrowL = true;
        this._bShowArrowR = false;
        this.setPrevItemIndex();
        this.run_animation();
    }

    private void press_next() {
        SND_DATA.SND_MENU_CHANGE.play();
        this._bShowArrowL = false;
        this._bShowArrowR = true;
        this.setNextItemIndex();
        this.run_animation();
    }

    private void run_animation() {
        this._iFrames = 27;
        this._iFrame = 0;
    }

    public void render(Graphics graphics, Rect rect) {
        Rect.intersection(rect, this._rcArrowL, this._rcClippedArrowL);
        Rect.intersection(rect, this._rcArrowR, this._rcClippedArrowR);
        Rect.intersection(rect, this._rcItem, this._rcClippedItem);
        if (this.isFullRepaint()) {
            DATA.IMG_MENU_BACKGROUND.draw(graphics, 0, 0, 0, 0, rect);
        }
        if (this._bShowArrowL) {
            IMG_DATA.IMG_MENU_ARROW_L.draw(graphics, this._rcArrowL.left, this._rcArrowL.top, 0, 0, this._rcClippedArrowL);
        } else if (!this.isFullRepaint()) {
            DATA.IMG_MENU_BACKGROUND.draw(graphics, 0, 0, 0, 0, this._rcClippedArrowL);
        }
        if (this._bShowArrowR) {
            IMG_DATA.IMG_MENU_ARROW_R.draw(graphics, this._rcArrowR.left, this._rcArrowR.top, 0, 0, this._rcClippedArrowR);
        } else if (!this.isFullRepaint()) {
            DATA.IMG_MENU_BACKGROUND.draw(graphics, 0, 0, 0, 0, this._rcClippedArrowR);
        }
        if (this._iFrame < this._iFrames) {
            Img img = IMG_DATA.__ARR_MENU_ITEMS[this._iOldItemIndex];
            Img img2 = IMG_DATA.__ARR_MENU_ITEMS[this._iActiveItemIndex];
            int n = img2.getWidth();
            int n2 = n * this._iFrame / this._iFrames;
            if (this._iDirection < 0) {
                img.draw(graphics, this._rcItem.left + n2, this._rcItem.top, 0, 0, this._rcClippedItem);
                img2.draw(graphics, this._rcItem.left - n + n2, this._rcItem.top, 0, 0, this._rcClippedItem);
            } else if (this._iDirection > 0) {
                img.draw(graphics, this._rcItem.left - n2, this._rcItem.top, 0, 0, this._rcClippedItem);
                img2.draw(graphics, this._rcItem.left + n - n2, this._rcItem.top, 0, 0, this._rcClippedItem);
            }
            ++this._iFrame;
        } else {
            Img img = IMG_DATA.__ARR_MENU_ITEMS[this._iActiveItemIndex];
            img.draw(graphics, this._rcItem.left, this._rcItem.top, 0, 0, this._rcClippedItem);
        }
    }
}

