/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class AnimImg {
    public static final int SEQUNCE_EOF = -1;
    public final Img[] _img;
    public final int[] _frames;
    public final long[] _delays;
    public final int[] _manipulations;
    public final Rect _rcBounds = new Rect(0, 0, 0, 0);
    private long _lLastTimeChanged = Long.MIN_VALUE;
    private int _iActiveFrame = 0;
    private static final int FLAG_ROTATE_MASK = 510;

    public AnimImg(Img[] imgArray, int[] nArray, long[] lArray) {
        this(imgArray, nArray, lArray, null);
    }

    public AnimImg(Img[] imgArray, int[] nArray, long[] lArray, int[] nArray2) {
        this._img = imgArray;
        this._frames = nArray;
        this._delays = lArray;
        this._manipulations = nArray2;
        this._rcBounds.reset();
        for (int i = 0; i < imgArray.length; ++i) {
            Rect rect = imgArray[i]._rcBounds;
            if (rect.getWidth() > this._rcBounds.right) {
                this._rcBounds.right = rect.getWidth();
            }
            if (rect.getHeight() <= this._rcBounds.bottom) continue;
            this._rcBounds.bottom = rect.getHeight();
        }
    }

    public int getFrameCount() {
        return this._frames.length;
    }

    public int getActiveFrameIndex() {
        return this._iActiveFrame;
    }

    public Img getActiveFrameImg() {
        return this.getFrameImg(this._iActiveFrame);
    }

    public Img getFrameImg(int n) {
        Img img = null;
        try {
            img = this._img[this._frames[this._iActiveFrame]];
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return img;
    }

    public int getWidth() {
        int n = 0;
        try {
            n = this.getFrameImg(this._iActiveFrame).getWidth();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public int getWidth(int n) {
        int n2 = 0;
        try {
            n2 = this.getFrameImg(n).getWidth();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    public int getHeight() {
        int n = 0;
        try {
            n = this.getFrameImg(this._iActiveFrame).getHeight();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public int getHeight(int n) {
        int n2 = 0;
        try {
            n2 = this.getFrameImg(n).getHeight();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, Rect rect) {
        this.DrawEx(this._iActiveFrame, graphics, n, n2, n3, n4, rect);
    }

    public void DrawEx(int n, Graphics graphics, int n2, int n3, int n4, int n5, Rect rect) {
        try {
            int n6 = this._manipulations == null ? n5 : Utils.getCombinedManipulations(n5, this._manipulations[n]);
            this._img[this._frames[n]].draw(graphics, n2, n3, n4, n6, rect);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void nextFrame() {
        this._iActiveFrame = this._iActiveFrame < this._frames.length - 1 ? ++this._iActiveFrame : 0;
    }

    public boolean isSequnceEOF() {
        return this._delays[this._iActiveFrame] == -1L;
    }

    public boolean update() {
        boolean bl = false;
        try {
            if (this._delays[this._iActiveFrame] != -1L) {
                long l = System.currentTimeMillis();
                if (this._lLastTimeChanged == Long.MIN_VALUE || l - this._lLastTimeChanged >= this._delays[this._iActiveFrame]) {
                    this._lLastTimeChanged = l;
                    this.nextFrame();
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }
}

