/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Rect {
    public int left;
    public int top;
    public int right;
    public int bottom;

    public Rect() {
        this.left = 0;
        this.top = 0;
        this.right = 0;
        this.bottom = 0;
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public final void reset() {
        this.left = 0;
        this.top = 0;
        this.right = 0;
        this.bottom = 0;
    }

    public final void assign(Rect rect) {
        this.left = rect.left;
        this.top = rect.top;
        this.right = rect.right;
        this.bottom = rect.bottom;
    }

    public final void setRect(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.right = n3;
        this.bottom = n4;
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.right = n + n3;
        this.bottom = n2 + n4;
    }

    public final void offset(int n, int n2) {
        this.left += n;
        this.right += n;
        this.top += n2;
        this.bottom += n2;
    }

    public final void inflate(int n, int n2) {
        this.left -= n;
        this.right += n;
        this.top -= n2;
        this.bottom += n2;
    }

    public final int getWidth() {
        return this.right - this.left;
    }

    public final int getHeight() {
        return this.bottom - this.top;
    }

    public final int getCenterX() {
        return (this.left + this.right) / 2;
    }

    public final int getCenterY() {
        return (this.top + this.bottom) / 2;
    }

    public final boolean isEmpty() {
        return this.left >= this.right || this.top >= this.bottom;
    }

    public final boolean hasIntersection(Rect rect) {
        if (this.top >= rect.bottom) {
            return false;
        }
        if (this.left >= rect.right) {
            return false;
        }
        if (this.right <= rect.left) {
            return false;
        }
        return this.bottom > rect.top;
    }

    public static boolean intersection(Rect rect, Rect rect2, Rect rect3) {
        rect3.setRect(Math.max(rect.left, rect2.left), Math.max(rect.top, rect2.top), Math.min(rect.right, rect2.right), Math.min(rect.bottom, rect2.bottom));
        return !rect3.isEmpty();
    }

    public void read(DataInputStream dataInputStream) {
        try {
            this.left = dataInputStream.readInt();
            this.top = dataInputStream.readInt();
            this.right = dataInputStream.readInt();
            this.bottom = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void write(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(this.left);
            dataOutputStream.writeInt(this.top);
            dataOutputStream.writeInt(this.right);
            dataOutputStream.writeInt(this.bottom);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean union_box(Rect rect, Rect rect2, Rect rect3) {
        if (rect.isEmpty()) {
            if (rect2.isEmpty()) {
                rect3.reset();
            } else {
                rect3.assign(rect2);
            }
        } else if (rect2.isEmpty()) {
            rect3.assign(rect);
        } else {
            rect3.setRect(Math.min(rect.left, rect2.left), Math.min(rect.top, rect2.top), Math.max(rect.right, rect2.right), Math.max(rect.bottom, rect2.bottom));
        }
        return !rect3.isEmpty();
    }
}

