/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class InputName
extends SceneImpl
implements SUPER_DATA {
    private static InputName _instance = null;
    public String _message = "";
    private static final String STORE_NAME = "InputName";
    private static final String _SYMBOLS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ <";
    private int _iCurX = 0;
    private int _iCurY = 0;
    private final int _DISPLAY_LEFT;
    private final int _DISPLAY_TOP;
    private final int _KEYB_LEFT;
    private final int _KEYB_TOP;
    private final StringBuffer _value = new StringBuffer("");
    private final int _max_value_length;
    private static final String[] _key_chars = new String[]{" ", "", "ABC", "DEF", "GHI", "JKL", "MNO", "PQRS", "TUV", "WXYZ"};
    private int _iKeyIndex = -1;
    private int _iKeyOffset = -1;
    private long _lLastKeyPressed = Long.MIN_VALUE;
    final StringBuffer value = new StringBuffer();

    public static InputName getInstance() {
        if (_instance == null) {
            _instance = new InputName();
        }
        return _instance;
    }

    private InputName() {
        this._DISPLAY_LEFT = 20;
        this._DISPLAY_TOP = 62;
        this._KEYB_LEFT = 27;
        this._KEYB_TOP = 91;
        this._max_value_length = 8;
    }

    public int getFX() {
        return 2;
    }

    public IImg getFXImage() {
        return ImgPanel.getInstance();
    }

    public void onActivation() {
        this.load_data();
    }

    public void onDeactivation() {
        this.save_data();
    }

    private void load_data() {
        this._value.setLength(0);
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)false);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(recordStore.getRecord(1));
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this._value.append(dataInputStream.readUTF());
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void save_data() {
        try {
            try {
                RecordStore.deleteRecordStore((String)STORE_NAME);
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
            RecordStore recordStore = RecordStore.openRecordStore((String)STORE_NAME, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(20);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(this._value.toString());
            recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size());
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onPressedKey(int n, int n2) {
        switch (n) {
            case -3: {
                if (this._iCurX <= 0) {
                    this._iCurX = 6;
                    break;
                }
                --this._iCurX;
                break;
            }
            case -4: {
                if (this._iCurX == 6) {
                    this._iCurX = 0;
                    break;
                }
                ++this._iCurX;
                break;
            }
            case -1: {
                if (this._iCurY <= 0) {
                    this._iCurY = 3;
                    break;
                }
                --this._iCurY;
                break;
            }
            case -2: {
                if (this._iCurY == 3) {
                    this._iCurY = 0;
                    break;
                }
                ++this._iCurY;
                break;
            }
            case -5: {
                this.doFire();
                break;
            }
            case -8: {
                if (this._value.length() <= 0) break;
                this._value.deleteCharAt(this._value.length() - 1);
            }
        }
        if (this._value.length() < 8 && n >= 49 && n <= 57) {
            if (this._iKeyIndex == -1) {
                int n3 = n - 48;
                int n4 = _key_chars[n3].length();
                if (n4 > 0) {
                    this._iKeyIndex = n3;
                    this._iKeyOffset = 0;
                    if (n4 == 1) {
                        this.doKeyAccept();
                    }
                } else {
                    this.doKeyAccept();
                }
            } else {
                int n5 = n - 48;
                int n6 = _key_chars[n5].length();
                if (n6 > 0) {
                    this._iKeyOffset = this._iKeyOffset == n6 - 1 ? 0 : ++this._iKeyOffset;
                }
            }
            this._lLastKeyPressed = System.currentTimeMillis();
        }
    }

    private void doKeyAccept() {
        if (this._iKeyIndex != -1) {
            if (this._value.length() < 8) {
                this._value.append(_key_chars[this._iKeyIndex].charAt(this._iKeyOffset));
            }
            this._iKeyIndex = -1;
        }
    }

    public void onPressedCmd1() {
        this.doComplete();
    }

    public void onPressedCmd2() {
    }

    private void doFire() {
        SND_DATA.SND_CLCIK.play();
        if (this._iCurX == 6 && this._iCurY == 3) {
            if (this._value.length() > 0) {
                this._value.deleteCharAt(this._value.length() - 1);
            }
        } else if (this._value.length() < 8) {
            this._value.append(_SYMBOLS.charAt(this._iCurX + this._iCurY * 7));
        }
    }

    private void doClear() {
        this._value.setLength(0);
    }

    private void doComplete() {
        SND_DATA.SND_CLCIK.play();
        HighScores.getInstance().addPlayer(this._value.toString());
        _instance = null;
    }

    public final void render(Graphics graphics, Rect rect) {
        for (int i = 0; i < DATA.SCR_BOTTOM; i += IMG_DATA.IMG_PANEL_BODY.getHeight()) {
            IMG_DATA.IMG_PANEL_BODY.draw(graphics, 0, i, 0, 0, rect);
        }
        IMG_DATA.IMG_PANEL_BORDER.draw(graphics, 0, 162, 0, 0, rect);
        IMG_DATA.IMG_INPUT_BOARD.draw(graphics, DATA.SCR_W2, 159, 9, 0, rect);
        IMG_DATA.IMG_TEXT_HELP.draw(graphics, DATA.SCR_W2, 5, 1, 0, rect);
        IMG_DATA.IMG_TEXT_OK.draw(graphics, 3, DATA.SCR_BOTTOM - 2, 8, 0, rect);
        Utils.setClip(graphics, rect);
        if (this._message != null) {
            graphics.setFont(DATA.fntSmall);
            Utils.drawText(this._message, graphics, DATA.SCR_W2, 29, 1, 0xFFFFFF);
        }
        graphics.setFont(DATA.fntSmallBold);
        if (this._iKeyIndex != -1 && System.currentTimeMillis() - this._lLastKeyPressed > 500L) {
            this.doKeyAccept();
        }
        this.value.setLength(0);
        this.value.append((Object)this._value);
        if (this._iKeyIndex != -1) {
            this.value.append(_key_chars[this._iKeyIndex].charAt(this._iKeyOffset));
        }
        Utils.drawText(this.value.toString(), graphics, 20, 62, 0, 0xFFFFFF);
        int n = 27 + this._iCurX * 20;
        int n2 = 91 + this._iCurY * 15 - 2;
        graphics.setColor(0);
        graphics.drawRoundRect(n + 1 - 7, n2 + 1 - 6, 13, 14, 4, 4);
        graphics.setColor(0xFFFFFF);
        graphics.drawRoundRect(n - 7, n2 - 6, 13, 14, 4, 4);
    }
}

