/*
 * Decompiled with CFR 0.152.
 */
package sprites;

import javax.microedition.lcdui.Image;
import sprites.Broker;
import sprites.ConcreteGameCanvas;
import sprites.MoveableSprite;
import sprites.Solid;

public class UserSprite
extends MoveableSprite
implements Solid {
    private int step;
    private int keyState;

    public UserSprite(Image image, int step) {
        super(image);
        this.step = step;
    }

    public UserSprite(Image image, int frameWidth, int frameHeight, int step) {
        super(image, frameWidth, frameHeight);
        this.step = step;
    }

    public UserSprite(UserSprite u) {
        super(u);
        this.step = u.step;
        this.keyState = u.keyState;
    }

    public void move() {
        ConcreteGameCanvas concreteGameCanvas = (ConcreteGameCanvas)Broker.instance().get("canvas");
        this.keyState |= concreteGameCanvas.getKeyStates();
        if ((this.keyState & 4) != 0) {
            this.leftMove();
        }
        if ((this.keyState & 0x20) != 0) {
            this.rightMove();
        }
        if ((this.keyState & 2) != 0) {
            this.upMove();
        }
        if ((this.keyState & 0x40) != 0) {
            this.downMove();
        }
        if ((this.keyState & 0x100) != 0) {
            this.fire();
        }
        this.keyState = 0;
    }

    public boolean isMoving() {
        ConcreteGameCanvas concreteGameCanvas = (ConcreteGameCanvas)Broker.instance().get("canvas");
        this.keyState = concreteGameCanvas.getKeyStates();
        return this.keyState != 0;
    }

    public void collidesWith(Solid anObstacle) {
    }

    public void collisionEnds() {
        this.paint();
    }

    public void leftMove() {
        this.move(-this.step, 0);
    }

    public void rightMove() {
        this.move(this.step, 0);
    }

    public void upMove() {
        this.move(0, -this.step);
    }

    public void downMove() {
        this.move(0, this.step);
    }

    public void fire() {
    }
}

