/*
 * Decompiled with CFR 0.152.
 */
package sprites;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.TiledLayer;
import sprites.Broker;
import sprites.MoveableLayerManager;

public class ConcreteGameCanvas
extends GameCanvas
implements Runnable {
    private Graphics offScreen;
    private int refreshRate;
    private Thread thread;
    private boolean visible;
    private Image motif;
    private int xPart;
    private int yPart;
    private TiledLayer backGround;
    private TiledLayer backGroundBuffer;

    public ConcreteGameCanvas(boolean suppressKeyEvents, int refreshRate) {
        super(suppressKeyEvents);
        this.refreshRate = refreshRate;
        this.offScreen = this.getGraphics();
    }

    protected void showNotify() {
        if (!this.visible) {
            this.visible = true;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    protected void hideNotify() {
        if (this.visible) {
            this.visible = false;
            try {
                this.thread.join();
            }
            catch (InterruptedException ie) {
                System.out.println(ie);
            }
            this.thread = null;
        }
    }

    public void run() {
        while (this.isRunning()) {
            MoveableLayerManager layers = (MoveableLayerManager)Broker.instance().get("layers");
            layers.move();
            this.flushGraphics();
            try {
                Thread.sleep(this.refreshRate);
            }
            catch (InterruptedException ie) {
                System.out.println(ie);
            }
        }
    }

    public void erase(int left, int top, int width, int height) {
        if (this.backGround != null) {
            int clipX = this.offScreen.getClipX();
            int clipY = this.offScreen.getClipY();
            int clipWidth = this.offScreen.getClipWidth();
            int clipHeight = this.offScreen.getClipHeight();
            this.backGround.fillCells(0, 0, this.backGround.getColumns(), this.backGround.getRows(), 0);
            try {
                int col = left - left % this.backGround.getCellWidth();
                while (col < left + width) {
                    int row = top - top % this.backGround.getCellHeight();
                    while (row < top + height) {
                        int destCol = col / this.backGround.getCellWidth();
                        int destRow = row / this.backGround.getCellHeight();
                        this.backGround.setCell(destCol, destRow, this.backGroundBuffer.getCell(destCol, destRow));
                        row += this.backGround.getCellHeight();
                    }
                    col += this.backGround.getCellWidth();
                }
            }
            catch (IndexOutOfBoundsException ioobe) {
                System.out.println(ioobe);
            }
            this.offScreen.clipRect(left, top, width, height);
            this.backGround.paint(this.offScreen);
            this.offScreen.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    public Graphics getOffscreen() {
        return this.offScreen;
    }

    public boolean isRunning() {
        return this.visible;
    }

    public void paintBackGround(Image motif, int xPart, int yPart) {
        this.motif = motif;
        this.xPart = xPart;
        this.yPart = yPart;
        int cols = 0;
        while (cols * motif.getWidth() / xPart < this.getWidth()) {
            ++cols;
        }
        int rows = 0;
        while (rows * motif.getHeight() / yPart < this.getHeight()) {
            ++rows;
        }
        this.backGround = new TiledLayer(cols, rows, motif, motif.getWidth() / xPart, motif.getHeight() / yPart);
        this.backGroundBuffer = new TiledLayer(cols, rows, motif, motif.getWidth() / xPart, motif.getHeight() / yPart);
        try {
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    this.backGroundBuffer.setCell(col, row, 1 + row % yPart * xPart + col % xPart);
                    ++col;
                }
                ++row;
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            System.out.println(ioobe);
        }
        this.erase(0, 0, this.getWidth(), this.getHeight());
    }
}

