/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import sprites.Broker;
import sprites.UserSprite;

public class Paddle
extends UserSprite {
    private int xMin;
    private int xMax;
    private int ballCount;
    private static Image ballImage;

    public Paddle(Image image, int step) {
        super(image, step);
    }

    public Paddle(Image image, int frameWidth, int frameHeight, int step, int xMin, int xMax) {
        super(image, frameWidth, frameHeight, step);
    }

    public Paddle(Paddle p) {
        super(p);
        this.xMin = p.xMin;
        this.xMax = p.xMax;
        this.ballCount = p.ballCount;
    }

    public void setBounds(int xMin, int xMax) {
        this.xMin = xMin;
        this.xMax = xMax;
    }

    public void leftMove() {
        super.leftMove();
        if (this.getX() < this.xMin) {
            this.setPosition(this.xMin, this.getY());
        }
    }

    public void rightMove() {
        super.rightMove();
        if (this.getX() + this.getWidth() > this.xMax) {
            this.setPosition(this.xMax - this.getWidth(), this.getY());
        }
    }

    public void upMove() {
    }

    public void downMove() {
    }

    public void fire() {
        ArkanoidLayerManager layers;
        if (this.ballCount > 0 && (layers = (ArkanoidLayerManager)Broker.instance().get("layers")).getBallCount() == 0) {
            try {
                if (ballImage == null) {
                    ballImage = Image.createImage((String)"/BALL.png");
                }
                Ball ball = new Ball(ballImage, 2, -2);
                ball.setPosition(this.getX() + this.getWidth() / 2, this.getY() - ball.getHeight());
                layers.append((Layer)ball);
                layers.eraseLives();
                --this.ballCount;
                layers.drawLives();
            }
            catch (IOException ioe) {
                System.out.println(ioe);
            }
        }
    }

    public int getBallCount() {
        return this.ballCount;
    }

    public void addBalls(int ballCount) {
        ArkanoidLayerManager layers = (ArkanoidLayerManager)Broker.instance().get("layers");
        layers.eraseLives();
        this.ballCount += ballCount;
        layers.drawLives();
    }
}

