/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;
import sprites.Solid;

public class HeavyBrick
extends Brick {
    private int maxHits;
    private int hits;

    public HeavyBrick(Image image) {
        super(image);
    }

    public HeavyBrick(Image image, int maxHits) {
        super(image);
        this.maxHits = maxHits;
    }

    public HeavyBrick(Image image, int frameWidth, int frameHeight, int maxHits) {
        super(image, frameWidth, frameHeight);
        this.maxHits = maxHits;
    }

    public HeavyBrick(HeavyBrick h) {
        super(h);
        this.maxHits = h.maxHits;
        this.hits = h.hits;
    }

    public void collidesWith(Solid anObstacle) {
        ++this.hits;
        if (this.maxHits > 0 && this.hits >= this.maxHits) {
            super.collidesWith(anObstacle);
        } else {
            this.nextFrame();
            this.paint();
        }
    }

    public void collisionEnds() {
        if (this.maxHits > 0 && this.hits >= this.maxHits) {
            super.collisionEnds();
        } else {
            this.nextFrame();
            this.paint();
        }
    }

    public int points() {
        return super.points() * this.hits;
    }
}

