/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;
import sprites.ActiveSprite;
import sprites.Solid;

public class SpeedBrick
extends Brick {
    private int increment;

    public SpeedBrick(Image image, int increment) {
        super(image);
        this.increment = increment;
    }

    public SpeedBrick(Image image, int frameWidth, int frameHeight, int increment) {
        super(image, frameWidth, frameHeight);
        this.increment = increment;
    }

    public SpeedBrick(SpeedBrick s) {
        super(s);
        this.increment = s.increment;
    }

    public void collidesWith(Solid anObstacle) {
        super.collidesWith(anObstacle);
        if (anObstacle instanceof ActiveSprite) {
            ActiveSprite activeSprite = (ActiveSprite)((Object)anObstacle);
            int xIncrement = this.increment;
            int yIncrement = this.increment;
            if (activeSprite.getSpeedX() < 0) {
                xIncrement = -Math.abs(this.increment);
            }
            if (activeSprite.getSpeedY() < 0) {
                yIncrement = -Math.abs(this.increment);
            }
            activeSprite.setSpeed(activeSprite.getSpeedX() + xIncrement, activeSprite.getSpeedY() + yIncrement);
        }
    }
}

