/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import sprites.Broker;
import sprites.ConcreteGameCanvas;
import sprites.ConcreteMIDlet;

public class ArkanoidGameCanvas
extends ConcreteGameCanvas {
    private boolean gameOver = true;

    public ArkanoidGameCanvas(boolean suppressKeyEvents, int refreshRate) {
        super(suppressKeyEvents, refreshRate);
        this.setFullScreenMode(true);
    }

    public boolean isRunning() {
        boolean running = super.isRunning();
        if (running) {
            Paddle paddle;
            ArkanoidLayerManager layers = (ArkanoidLayerManager)Broker.instance().get("layers");
            if (this.gameOver || layers.getBrickCount() == 0) {
                this.nextLevel();
                layers.nextLevel();
                layers.paint(this.getOffscreen(), 0, 0);
                layers.drawScore();
                layers.drawLives();
                this.flushGraphics();
                this.gameOver = false;
            }
            if (layers.getBallCount() == 0 && (paddle = (Paddle)Broker.instance().get("player")).getBallCount() == 0) {
                this.gameOver = true;
                layers.gameOver();
                running = false;
            }
        }
        return running;
    }

    public void nextLevel() {
        this.getOffscreen().setFont(Font.getFont((int)64, (int)1, (int)0));
        this.getOffscreen().setColor(255, 255, 255);
        this.paintBackGround(WallFactory.createBackGround(), 2, 2);
    }

    public void run() {
        super.run();
        if (this.gameOver) {
            ConcreteMIDlet concreteMIDlet = (ConcreteMIDlet)((Object)Broker.instance().get("midlet"));
            ConcreteGameCanvas concreteGameCanvas = (ConcreteGameCanvas)Broker.instance().get("intro");
            concreteMIDlet.getDisplay().setCurrent((Displayable)concreteGameCanvas);
        }
    }
}

