/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public class SoundPlayer {
    private static Player mp;
    static Sound bgSound;
    static Sound fire;
    static Sound gameOver;
    static Sound gameWin;
    static Sound collapse;
    static Sound remove;
    static Sound levelOver;
    static Sound hiScore;

    public SoundPlayer(MIDlet mIDlet) {
        try {
            byte[] byArray = new byte[22];
            fire = SoundPlayer.GameSound(mIDlet, "/snds/fire.ott", byArray, 1);
            byArray = new byte[75];
            gameOver = SoundPlayer.GameSound(mIDlet, "/snds/gameOver.ott", byArray, 1);
            byArray = new byte[40];
            collapse = SoundPlayer.GameSound(mIDlet, "/snds/collapse.ott", byArray, 1);
            byArray = new byte[33];
            levelOver = SoundPlayer.GameSound(mIDlet, "/snds/levelOver.ott", byArray, 1);
            byArray = new byte[57];
            hiScore = SoundPlayer.GameSound(mIDlet, "/snds/hiscore.ott", byArray, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Sound GameSound(MIDlet mIDlet, String string, byte[] byArray, int n) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(mIDlet.getClass().getResourceAsStream(string));
        int n2 = dataInputStream.read(byArray);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        Sound sound = new Sound(byArray2, n);
        dataInputStream.close();
        return sound;
    }

    public static void stopSounds() {
        if (mp != null) {
            mp.close();
            mp = null;
        }
        fire.stop();
        gameOver.stop();
        collapse.stop();
        levelOver.stop();
        hiScore.stop();
    }

    public void playTitle() {
        this.play("/snds/bg", "audio/amr", 2);
    }

    public static void playFire() {
        SoundPlayer.play(fire, 1);
    }

    public static void playGameOver() {
        SoundPlayer.play(gameOver, 1);
    }

    public void playGameWin() {
        this.play("/snds/gameWin", "audio/amr", 1);
    }

    public static void playCollapse() {
        SoundPlayer.play(collapse, 1);
    }

    public void playRemove() {
        this.play("/snds/remove", "audio/amr", 1);
    }

    public static void playLevelOver() {
        SoundPlayer.play(levelOver, 1);
    }

    public static void playHiScore() {
        SoundPlayer.play(hiScore, 1);
    }

    public static void play(Sound sound, int n) {
        if (n == 0) {
            n = 1;
        }
        if (sound.getState() != 0 && GameCanvas.soundOn == 0) {
            sound.play(n);
        }
    }

    private void play(String string, String string2, int n) {
        if (GameCanvas.soundOn == 0) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(string);
                mp = Manager.createPlayer((InputStream)inputStream, (String)string2);
                mp.setLoopCount(n);
                mp.prefetch();
                mp.start();
            }
            catch (Exception exception) {
                System.out.println("exception2" + exception);
            }
        }
    }
}

