/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends FullCanvas
implements Runnable {
    static int startHelp = 0;
    ResLoader resLoader;
    GameMidlet midlet;
    GameDataManager gdm;
    SoundPlayer soundPlayer;
    DCubeMain cubeMain;
    Thread gameThread;
    static final byte totalMedia = 20;
    static byte progressMedia = 0;
    public static final Font gameFont = Font.getFont((int)32, (int)1, (int)8);
    public static final int ANCHOR_LEFT = 20;
    public static final int ANCHOR_CENTER = 17;
    public static final int stringColor = 0xFFFFFF;
    public static final int ingameBgColor = 0;
    public static final int menuBgColor = 255;
    protected int fireKey;
    protected int leftKey;
    protected int rightKey;
    protected int upKey;
    protected int downKey;
    static int WIDTH;
    static int HEIGHT;
    int keyTemp = 0;
    int page = 0;
    static final byte Max_HelpPage = 3;
    static byte helpPage;
    boolean continueMenu = false;
    static int soundOn;
    byte selRectPos = 0;
    private static String[] textArr;
    Image offscreen;
    Image menuText;
    Image settingsMenu;
    Image sndOn;
    Image sndOff;
    Image patch;
    static Image scroller;
    static Image logo;
    static Image title;
    static Image gridBg;
    static Image redTile;
    static Image whiteTile;
    static Image redCube;
    static Image blueCube;
    static Image cyanCube;
    static Image yellowCube;
    static Image pinkCube;
    static Image doubler;
    static Image converter;
    static Image bomb;
    static Image cubesIcon;
    static Image gridBorder;
    static Image anyKey;
    static Image menuBg;
    static Image bomb1;
    static Image convertor;
    static final byte MAX_GAME_RECORDS = 5;
    static String[] rmsNames;
    static int[] rmsScores;
    static int[] rmsLevels;
    int titleSnd;
    byte a = 0;
    byte animArr = 0;
    byte helpScroll = 0;
    int action;

    public GameCanvas(GameMidlet gameMidlet) {
        this.midlet = gameMidlet;
        WIDTH = this.getWidth();
        HEIGHT = this.getHeight();
        this.fireKey = this.getKeyCode(8);
        this.leftKey = this.getKeyCode(2);
        this.rightKey = this.getKeyCode(5);
        this.upKey = this.getKeyCode(1);
        this.downKey = this.getKeyCode(6);
        this.resLoader = new ResLoader(this);
        DeviceControl.setLights((int)0, (int)100);
        if (this.isDoubleBuffered()) {
            this.offscreen = Image.createImage((int)WIDTH, (int)HEIGHT);
        }
        this.titleSnd = 0;
    }

    public void run() {
        while (true) {
            int n;
            long l = System.currentTimeMillis();
            try {
                this.repaint(0, 0, WIDTH, HEIGHT);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((n = (int)(System.currentTimeMillis() - l)) >= 3) continue;
            try {
                Thread.sleep(3 - n);
            }
            catch (Exception exception) {
            }
        }
    }

    public void loadImages() {
        try {
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            scroller = Image.createImage((String)"/scrollcursor.png");
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            title = Image.createImage((String)"/title.png");
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            anyKey = Image.createImage((String)"/anykey");
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            menuBg = Image.createImage((String)"/menu_bg.png");
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            this.menuText = Image.createImage((String)"/menu_txt.png");
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            this.settingsMenu = Image.createImage((String)"/resetrecord_menu.png");
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            this.sndOff = Image.createImage((String)"/sound_off.png");
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            this.sndOn = Image.createImage((String)"/sound_on.png");
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            this.patch = Image.createImage((String)"/patch.png");
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
            progressMedia = (byte)(progressMedia + 1);
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void loadIngame() {
        try {
            whiteTile = Image.createImage((String)"/white-block.png");
            redTile = Image.createImage((String)"/red-block.png");
            System.gc();
            Runtime.getRuntime().gc();
            redCube = Image.createImage((String)"/cubes/red.png");
            blueCube = Image.createImage((String)"/cubes/blue.png");
            cyanCube = Image.createImage((String)"/cubes/cyan.png");
            yellowCube = Image.createImage((String)"/cubes/yellow.png");
            pinkCube = Image.createImage((String)"/cubes/pink.png");
            doubler = Image.createImage((String)"/cubes/doubler.png");
            bomb = Image.createImage((String)"/cubes/bomb.png");
            convertor = Image.createImage((String)"/cubes/converter.png");
            bomb1 = Image.createImage((String)"/cubes/bomb1.png");
            gridBorder = Image.createImage((String)"/border.png");
            cubesIcon = Image.createImage((String)"/cIcons/cubesIcon.png");
            gridBg = Image.createImage((String)"/bg.png");
            System.gc();
            Runtime.getRuntime().gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void hideNotify() {
        if (this.page == 3) {
            this.continueMenu = true;
            this.page = 9;
        }
        this.repaint();
    }

    protected void paint(Graphics graphics) {
        Graphics graphics2 = graphics;
        graphics.setFont(gameFont);
        graphics.setColor(128, 128, 64);
        graphics.fillRect(0, 0, WIDTH, HEIGHT);
        if (this.page == 0) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, WIDTH, HEIGHT);
            graphics.drawImage(logo, WIDTH / 2, HEIGHT / 2 - logo.getHeight() / 2, 1 | 0x10);
            graphics.setColor(3966142);
            graphics.fillRect(13, 170, 150 * progressMedia / 20, 6);
            graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
            graphics.setColor(0);
            graphics.drawString("www.mauj.com", WIDTH / 2, 185, 1 | 0x10);
            graphics.setColor(0xFF9900);
            graphics.drawRect(13, 170, 150, 6);
        } else if (this.page == 1) {
            graphics.drawImage(title, 0, 0, 20);
            if (this.titleSnd == 0) {
                this.soundPlayer.playTitle();
                this.titleSnd = 1;
            }
            graphics.drawImage(anyKey, WIDTH / 2, HEIGHT - 10, 17);
        } else if (this.page == 2 || this.page == 9) {
            this.drawMenu(graphics);
        } else if (this.page == 3) {
            this.cubeMain.renderMain(graphics);
        } else if (this.page == 4) {
            this.drawHighScore(graphics);
        } else if (this.page == 5) {
            this.drawSettings(graphics);
        } else if (this.page == 6) {
            this.drawHelp(graphics);
        } else if (this.page == 66) {
            this.drawHelpSynopsis(graphics);
        } else if (this.page == 7) {
            this.drawCredits(graphics);
        }
    }

    public void drawBackGround(Graphics graphics, int n) {
        if (n == 0) {
            graphics.drawImage(gridBg, 0, 0, 20);
        } else {
            graphics.drawImage(menuBg, 0, 0, 20);
        }
    }

    private void drawMenu(Graphics graphics) {
        this.drawBackGround(graphics, 1);
        int n = 31;
        int n2 = 56;
        int n3 = this.continueMenu ? 35 : 55;
        graphics.setColor(0);
        this.drawArrow(graphics, 10, n3, this.selRectPos);
        graphics.drawImage(this.menuText, n, n2, 20);
        if (!this.continueMenu) {
            graphics.drawImage(this.patch, 31, 56, 20);
        }
    }

    private void drawArrow(Graphics graphics, int n, int n2, int n3) {
        graphics.setClip(n, n2 + 20 * n3, 20, 21);
        graphics.drawImage(cubesIcon, -this.animArr * 20 + n, n2 + 20 * n3, 20);
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        this.animArr = (byte)(this.animArr + 1);
        if (this.animArr >= 4) {
            this.animArr = 0;
        }
    }

    private void drawHighScore(Graphics graphics) {
        this.drawBackGround(graphics, 0);
        graphics.setColor(0, 0, 0);
        graphics.drawString(GameText.menus[2], WIDTH / 2, 1, 17);
        graphics.drawString("Name", 10, 35, 20);
        graphics.drawString("Level", 10 + gameFont.stringWidth("Name") + 30, 35, 20);
        graphics.drawString("Score", 10 + gameFont.stringWidth("NameLevel") + 60, 35, 20);
        for (int i = 0; i < 5; ++i) {
            graphics.drawString("" + rmsNames[i], 15, 60 + i * 20, 0x10 | 4);
            graphics.drawString("" + rmsLevels[i], 15 + gameFont.stringWidth("Name") + 30, 60 + i * 20, 0x10 | 4);
            graphics.drawString("" + rmsScores[i], 15 + gameFont.stringWidth("NameLevel") + 60, 60 + i * 20, 0x10 | 4);
        }
        graphics.drawString("Press Joystick", WIDTH / 2, HEIGHT - 12, 17);
    }

    private void drawHelpSynopsis(Graphics graphics) {
        this.drawBackGround(graphics, 0);
        graphics.setColor(0);
        graphics.drawString("Synopsis", WIDTH / 2, 2, 17);
        int n = 1;
        int n2 = 24;
        int n3 = 15;
        for (int i = 0; i < textArr.length; ++i) {
            if (textArr[i] == null) continue;
            graphics.drawString(textArr[i], n, n2, 20);
            n2 += n3;
        }
        graphics.drawImage(anyKey, WIDTH / 2, HEIGHT - 10, 17);
    }

    private void drawHelp(Graphics graphics) {
        this.drawBackGround(graphics, 0);
        graphics.setColor(0);
        graphics.drawString(GameText.menus[4], WIDTH / 2, 1, 17);
        int n = 5;
        int n2 = 14;
        int n3 = 13;
        graphics.setClip(0, 12, WIDTH, HEIGHT - 40);
        for (int i = 0; i < textArr.length; ++i) {
            if (textArr[i] == null) continue;
            if (!(textArr[i].equals("@ ") || textArr[i].equals("# ") || textArr[i].equals("% "))) {
                graphics.drawString(textArr[i], n, n2 + this.helpScroll * 8, 20);
                n2 += n3;
            }
            if (textArr[i].equals("@ ")) {
                graphics.drawImage(doubler, WIDTH - 30, n2 + this.helpScroll * 8 - 30, 20);
            }
            if (textArr[i].equals("# ")) {
                graphics.drawImage(convertor, WIDTH - 30, n2 + this.helpScroll * 8 - 30, 20);
            }
            if (!textArr[i].equals("% ")) continue;
            graphics.drawImage(bomb1, WIDTH - 30, n2 + this.helpScroll * 8 - 30, 20);
        }
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        graphics.drawImage(scroller, WIDTH / 2 - scroller.getWidth() / 2, HEIGHT - scroller.getHeight() - 15, 20);
        graphics.drawString("Press Joystick", WIDTH / 2, HEIGHT - 13, 17);
    }

    private void drawCredits(Graphics graphics) {
        this.drawBackGround(graphics, 0);
        graphics.setColor(0);
        graphics.drawString(GameText.menus[5], WIDTH / 2, 1, 17);
        graphics.drawString("Press Joystick", WIDTH / 2, HEIGHT - 12, 17);
        int n = 5;
        int n2 = 25;
        int n3 = 15;
        graphics.setClip(0, 12, WIDTH, HEIGHT - 20);
        for (int i = 0; i < textArr.length; ++i) {
            if (textArr[i] == null) continue;
            graphics.drawString(textArr[i], n, n2, 20);
            n2 += n3;
        }
        graphics.setClip(0, 0, WIDTH, HEIGHT);
    }

    private void drawSettings(Graphics graphics) {
        this.drawBackGround(graphics, 1);
        int n = 31;
        int n2 = 96;
        this.drawArrow(graphics, 10, 75, this.selRectPos);
        if (soundOn == 0) {
            graphics.drawImage(this.sndOn, n, n2, 20);
        } else {
            graphics.drawImage(this.sndOff, n, n2, 20);
        }
        graphics.drawImage(this.settingsMenu, n, 116, 20);
    }

    protected void keyPressed(int n) {
        this.action = this.getGameAction(n);
        if (this.keyTemp == 0) {
            this.keyTemp = 1;
            if (this.page == 0 || this.page == -1) {
                return;
            }
            switch (this.page) {
                case 1: {
                    GameCanvas gameCanvas = this;
                    gameCanvas.soundPlayer.stopSounds();
                    title = null;
                    System.gc();
                    Runtime.getRuntime().gc();
                    this.loadIngame();
                    if (startHelp > 0) {
                        if (textArr != null) {
                            textArr = null;
                        }
                        System.gc();
                        Runtime.getRuntime().gc();
                        textArr = GameText.createTextArr("Get inside a three dimensional world and play 3D Cube Deck. Play it once and you will get addicted for sure! Use Keys 2 and 8 or Up/ down keys to move the blocks across the board. Use Key 5 or Joystick to  shoot the blocks.  ");
                        --startHelp;
                        this.gdm.updateSettings();
                        this.page = 66;
                    } else {
                        this.page = 2;
                    }
                    return;
                }
                case 2: {
                    if (n == this.upKey || n == -1) {
                        this.selRectPos = this.selRectPos <= 0 ? (byte)(GameText.menus.length - 2) : (byte)(this.selRectPos - 1);
                    } else if (n == this.downKey || n == -2) {
                        this.selRectPos = this.selRectPos >= GameText.menus.length - 2 ? (byte)0 : (byte)(this.selRectPos + 1);
                    } else if (n == this.fireKey || n == 53 || n == -6 || this.action == 8) {
                        switch (this.selRectPos) {
                            case 0: {
                                this.cubeMain.newGame();
                                this.page = 3;
                                return;
                            }
                            case 1: {
                                SoundPlayer.playHiScore();
                                this.page = 4;
                                return;
                            }
                            case 2: {
                                this.page = 5;
                                this.selRectPos = 0;
                                return;
                            }
                            case 3: {
                                if (textArr != null) {
                                    textArr = null;
                                }
                                System.gc();
                                Runtime.getRuntime().gc();
                                textArr = GameText.createTextArr("Stack 3 or more blocks of the same color adjacent to each other in quick time to clean off the board and the level. Be careful not to allow 5 or more blocks pile up one over the other, else its game over. There are green coloured * 'Doubler' blocks *@ *which double up into 2 blocks of the same color as the one adjacent to which it is placed. There are silver colored *'Neutral' blocks *# *which take the color of the  adjacent block. And there are *Bombs *% *which blow up the blocks in the immediate vicinity. The blocks appear alternatively on the  either side of the board. Use Keys 2 and 8 or Up/ down keys to move the blocks across the board. Use Key5 or Joystick to  shoot the blocks. ");
                                this.page = 6;
                                return;
                            }
                            case 4: {
                                if (textArr != null) {
                                    textArr = null;
                                }
                                System.gc();
                                Runtime.getRuntime().gc();
                                textArr = GameText.createTextArr("3D Cube Deck v1.1.1     English Nokia6600. For more information, feedback please email support@mauj.com.   Copyright Mauj 2004. All Rights Reserved. ");
                                this.page = 7;
                                return;
                            }
                            case 5: {
                                this.midlet.exitMIDlet();
                                return;
                            }
                        }
                    }
                    return;
                }
                case 3: {
                    this.cubeMain.handleKeyInput(n);
                    return;
                }
                case 4: {
                    if (n == this.fireKey || n == 53 || n == -6 || this.action == 8) {
                        this.midlet.hiscoreEntered = false;
                        this.page = this.continueMenu ? 9 : 2;
                        this.selRectPos = (byte)(this.continueMenu ? 2 : 1);
                    }
                    return;
                }
                case 5: {
                    if (n == this.upKey || n == -1) {
                        this.selRectPos = this.selRectPos <= 0 ? (byte)(GameText.options.length - 1) : (byte)(this.selRectPos - 1);
                    } else if (n == this.downKey || n == -2) {
                        this.selRectPos = this.selRectPos >= GameText.options.length - 1 ? (byte)0 : (byte)(this.selRectPos + 1);
                    } else if (n == this.fireKey || n == 53 || n == -6 || this.action == 8) {
                        switch (this.selRectPos) {
                            case 0: {
                                soundOn = soundOn == 0 ? 1 : 0;
                                this.gdm.updateSettings();
                                return;
                            }
                            case 1: {
                                this.gdm.resetRecords();
                                this.page = 4;
                                return;
                            }
                            case 2: {
                                this.page = this.continueMenu ? 9 : 2;
                                this.selRectPos = (byte)(this.continueMenu ? 3 : 2);
                                return;
                            }
                        }
                    }
                    return;
                }
                case 6: {
                    if (n == this.upKey || n == -1) {
                        if (this.helpScroll < 0) {
                            this.helpScroll = (byte)(this.helpScroll + 1);
                        }
                    } else if (n == this.downKey || n == -2) {
                        if (this.helpScroll * 8 > -(textArr.length - 5) * 8) {
                            this.helpScroll = (byte)(this.helpScroll - 1);
                        }
                    } else if (n == this.fireKey || n == -6 || this.action == 8) {
                        this.helpScroll = 0;
                        textArr = null;
                        System.gc();
                        Runtime.getRuntime().gc();
                        this.page = this.continueMenu ? 9 : 2;
                        this.selRectPos = (byte)(this.continueMenu ? 4 : 3);
                    }
                    return;
                }
                case 66: {
                    textArr = null;
                    System.gc();
                    Runtime.getRuntime().gc();
                    this.page = 2;
                    return;
                }
                case 7: {
                    if (n == this.fireKey || n == -6 || this.action == 8) {
                        textArr = null;
                        System.gc();
                        Runtime.getRuntime().gc();
                        this.page = this.continueMenu ? 9 : 2;
                        this.selRectPos = (byte)(this.continueMenu ? 5 : 4);
                    }
                    return;
                }
                case 9: {
                    if (n == this.upKey || n == -1) {
                        this.selRectPos = this.selRectPos <= 0 ? (byte)(GameText.menus.length - 1) : (byte)(this.selRectPos - 1);
                    } else if (n == this.downKey || n == -2) {
                        this.selRectPos = this.selRectPos >= GameText.menus.length - 1 ? (byte)0 : (byte)(this.selRectPos + 1);
                    } else if (n == this.fireKey || n == 53 || n == -6 || this.action == 8) {
                        switch (this.selRectPos) {
                            case 0: {
                                this.continueMenu = false;
                                this.page = 3;
                                break;
                            }
                            case 1: {
                                this.cubeMain.newGame();
                                this.page = 3;
                                return;
                            }
                            case 2: {
                                SoundPlayer.playHiScore();
                                this.page = 4;
                                return;
                            }
                            case 3: {
                                this.page = 5;
                                this.selRectPos = 0;
                                return;
                            }
                            case 4: {
                                if (textArr != null) {
                                    textArr = null;
                                }
                                System.gc();
                                Runtime.getRuntime().gc();
                                textArr = GameText.createTextArr("Stack 3 or more blocks of the same color adjacent to each other in quick time to clean off the board and the level. Be careful not to allow 5 or more blocks pile up one over the other, else its game over. There are green coloured * 'Doubler' blocks *@ *which double up into 2 blocks of the same color as the one adjacent to which it is placed. There are silver colored *'Neutral' blocks *# *which take the color of the  adjacent block. And there are *Bombs *% *which blow up the blocks in the immediate vicinity. The blocks appear alternatively on the  either side of the board. Use Keys 2 and 8 or Up/ down keys to move the blocks across the board. Use Key5 or Joystick to  shoot the blocks. ");
                                this.page = 6;
                                return;
                            }
                            case 5: {
                                if (textArr != null) {
                                    textArr = null;
                                }
                                System.gc();
                                Runtime.getRuntime().gc();
                                textArr = GameText.createTextArr("3D Cube Deck v1.1.1     English Nokia6600. For more information, feedback please email support@mauj.com.   Copyright Mauj 2004. All Rights Reserved. ");
                                this.page = 7;
                                return;
                            }
                            case 6: {
                                this.midlet.exitMIDlet();
                                return;
                            }
                        }
                    }
                    return;
                }
            }
        }
    }

    protected void keyRepeated(int n) {
        if (this.page == 0 || this.page == -1) {
            return;
        }
        this.keyPressed(n);
    }

    protected void keyReleased(int n) {
        if (this.page == 0 || this.page == -1) {
            return;
        }
        if (this.keyTemp == 1) {
            this.keyTemp = 0;
        }
    }

    static {
        helpPage = 0;
        soundOn = 0;
        rmsNames = new String[5];
        rmsScores = new int[5];
        rmsLevels = new int[5];
    }

    class ResLoader
    implements Runnable {
        GameCanvas GC;
        Thread resThread;

        public ResLoader(GameCanvas gameCanvas2) {
            this.GC = gameCanvas2;
            try {
                logo = Image.createImage((String)"/logo");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resThread = new Thread(this);
            this.resThread.start();
        }

        public void run() {
            try {
                GameCanvas.this.page = 0;
                GameCanvas.this.loadImages();
                GameCanvas.this.cubeMain = new DCubeMain(this.GC);
                GameCanvas.this.soundPlayer = new SoundPlayer(GameCanvas.this.midlet);
                GameCanvas.this.gdm = new GameDataManager(this.GC);
                GameCanvas.this.gdm.getRecords();
                GameCanvas.this.gdm.storeSettings();
                GameCanvas.this.gdm.loadSettings();
                GameCanvas.this.page = 1;
                GameCanvas.this.gameThread = new Thread(this.GC);
                GameCanvas.this.gameThread.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

