/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.DataInputStream;

class SoundPlayer {
    static Sound bgSound;
    static Sound hiscoreSound;
    static Sound levelover;
    static Sound gameOver;
    static int volume;

    public SoundPlayer() {
        this.loadSounds();
    }

    public void loadSounds() {
        try {
            byte[] byArray = new byte[100];
            bgSound = this.GameSound("/snds/bg.ott", byArray, 1);
            byArray = new byte[100];
            gameOver = this.GameSound("/snds/lose.ott", byArray, 1);
            byArray = new byte[100];
            hiscoreSound = this.GameSound("/snds/hiscore.ott", byArray, 1);
        }
        catch (Exception exception) {
            System.out.println("Exception in Loading Sounds" + exception);
        }
    }

    public Sound GameSound(String string, byte[] byArray, int n) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(this.getClass().getResourceAsStream(string));
        int n2 = dataInputStream.read(byArray);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        Sound sound = new Sound(byArray2, n);
        sound.setGain(200);
        dataInputStream.close();
        return sound;
    }

    static void stopSounds() {
        bgSound.stop();
        hiscoreSound.stop();
        gameOver.stop();
    }

    static void playTitle() {
        SoundPlayer.play(bgSound, 10);
    }

    static void playHiScore() {
        SoundPlayer.play(hiscoreSound, 1);
    }

    static void playFire() {
    }

    static void playGameOver() {
        SoundPlayer.play(gameOver, 1);
    }

    static void playGameWin() {
        SoundPlayer.play(gameOver, 1);
    }

    static void play(Sound sound, int n) {
        if (GameCanvas.SOUND == 0) {
            if (n == 0) {
                n = 1;
            }
            if (sound.getState() != 0) {
                sound.play(n);
            }
        } else {
            return;
        }
    }

    static {
        volume = 100;
    }
}

