/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class GameCanvas
extends Canvas
implements Runnable {
    static final byte HISCORE_ENTRY = 10;
    final byte LOADER;
    final byte TITLE;
    final byte SYNOPSIS = (byte)11;
    static final byte MAIN_MENU = 2;
    final byte CONT_MENU = (byte)3;
    final byte SETTINGS = (byte)4;
    final byte HISCORES = (byte)5;
    final byte HELP = (byte)6;
    final byte ABOUT = (byte)7;
    final byte GAME = (byte)8;
    final byte EXIT_P = (byte)9;
    static final byte ASKRESET = 12;
    final byte INGAMEHELP = (byte)13;
    static final byte EXIT = 14;
    static final byte LIFELOST = 15;
    static final byte ASKHISCORE = 16;
    final byte JVPLOGO = (byte)17;
    static byte SOUND = 0;
    static byte VIBRA = 0;
    static byte SYNOPCNT = 0;
    byte TOTALRES = (byte)10;
    byte bResourceLoaded;
    static byte bPage;
    static byte selRectPos;
    static int iWidth;
    static int iHeight;
    static int WIDTH;
    static int HEIGHT;
    Thread canvasThread;
    Font fNormal = Font.getFont((int)0, (int)0, (int)8);
    Font fBold = Font.getFont((int)0, (int)1, (int)8);
    GameMidlet midlet;
    public Image[] menuPointer = new Image[2];
    static Image levelUp;
    static Image win;
    static Image exit;
    static Image helpBg;
    static Image menuarrow;
    static Image offscreen;
    static Image menuText;
    static Image settingsMenu;
    static Image sndOn;
    static Image sndOff;
    static Image patch;
    static Image scroller;
    static Image logo;
    static Image title;
    static Image gridBg;
    static Image redTile;
    static Image whiteTile;
    static Image redCube;
    static Image blueCube;
    static Image cyanCube;
    static Image yellowCube;
    static Image pinkCube;
    static Image doubler;
    static Image converter;
    static Image bomb;
    static Image cubesIcon;
    static Image gridBorder;
    static Image anyKey;
    static Image menuBg;
    static Image bomb1;
    static Image convertor;
    MainGame mainGame;
    static SoundPlayer soundPlayer;
    public static final int stringColor = 0xFFFFFF;
    String[] sHiscore = new String[]{"Save High Score?", "Yes", "No"};
    String[] cMenu = new String[]{"Continue", "Sound", "Main Menu"};
    String[] sMenu = new String[]{"Continue", "New Game", "High Scores", "Settings", "Help", "About", "Exit"};
    String[] sSelectText = new String[]{"Press Key 5", "Press Any Key", "Select", "Back", "Menu", "Reset"};
    String[] sCredits = new String[]{"3D Cube Deck V1.1.1", "For more information", "and feedback, email at", "support@mauj.com", "\u00a9 Mauj 2005.", "All Rights Reserved."};
    String[] sHelp = new String[]{"Stack 3 or more blocks of", "the same color adjacent ", "to each other in quick ", "time to clean off the ", "board and the level.", "Be careful not to allow ", "5 or more blocks pile up ", "one over the other, else ", "its game over. There are", "green coloured 'Doubler'", "blocks", "@ ", " ", "which double up into 2 ", "blocks of the same color", "as the one adjacent to", "which it is placed.", "There are silver colored", "'Neutral' blocks", "# ", "which take the color of", "the adjacent block. And ", "there are Bombs", "% ", " ", "which blow up the blocks", "in the immediate vicinity.", "The blocks appear ", "alternatively on the ", "either side of the board.", " ", "     ---*  Controls  *--- ", " ", "Key 2 - To move up.", "Key 8 - To move down.", "Key 5 - To shoot the blocks.", "Right Soft Key - To Pause", "                              the Game."};
    String[] sSynopsis = new String[]{"Get inside three ", "dimensional world and", "play. Play it once and ", "you will get addicted ", "for sure! Use Keys 2", "and 8 or Up / down keys", "to move the blocks ", "across the board. ", "Use Key 5 or Joystick", "to shoot the blocks."};
    String[] sResetscore = new String[]{"Reset Scores?", "Yes", "No"};
    static String[] options;
    int menuBgColor = 0;
    int menuTextColor = 0xFFFFFF;
    int menuHltColor = 0xFFFFFF;
    static byte leftSoftKey;
    static byte rightSoftKey;
    protected static int fireKey;
    protected static int leftKey;
    protected static int rightKey;
    protected static int upKey;
    protected static int downKey;
    static boolean continueMenu;
    public static final Font gameFont;
    public static final int ANCHOR_LEFT = 20;
    public static final int ANCHOR_CENTER = 17;
    static boolean hiScorePlayed;
    boolean showreset = false;
    int exitctr;
    int delayCtr = 0;
    boolean playTitle = false;
    int blinkCtr = 0;
    int inc = 33;
    int[] snowY = new int[]{-70, -15, -50, -10, -150};
    int[] snowX = new int[]{4, 120, 30, 60, 34};
    byte a = 0;
    byte animArr = 0;
    int helpPage = 0;
    int help_lines = 8;
    int moveY = 0;
    byte blinkCntr;
    static int marker;
    int blinkX;
    int strX;
    static String userId;
    static long timeLastInput;
    static int lastKeyPressed;
    static int keyCntr;
    static String str;
    static int action;
    long cycleStartTime;
    long msSinceLastCycle;
    long lastCycleTime;
    long timeSinceStart;
    static byte MAX_RECORDS;
    String[] sNames = new String[5];
    String[] sLevels = new String[5];
    static String[] sScores;
    String[] sNames1 = new String[]{"-----", "-----", "-----", "-----", "-----"};
    String[] sLevels1 = new String[]{"0", "0", "0", "0", "0"};
    String[] sScores1 = new String[]{"0", "0", "0", "0", "0"};
    String sRecordstorename = "rRecords1110";
    private RecordStore rRecords;
    String sSettingstorename = "rSetng12148";
    private RecordStore rSettings;

    public GameCanvas(GameMidlet gameMidlet) {
        this.LOADER = 0;
        this.TITLE = 1;
        this.midlet = gameMidlet;
        iWidth = 208;
        iHeight = 208;
        WIDTH = iWidth;
        HEIGHT = iHeight;
        fireKey = this.getKeyCode(8);
        leftKey = this.getKeyCode(2);
        rightKey = this.getKeyCode(5);
        upKey = this.getKeyCode(1);
        downKey = this.getKeyCode(6);
        try {
            logo = Image.createImage((String)"/logo");
            title = Image.createImage((String)"/title.png");
            soundPlayer = new SoundPlayer();
            this.mainGame = new MainGame();
        }
        catch (Exception exception) {
            System.out.println("eror in loading images 11" + exception);
        }
        this.canvasThread = new Thread(this);
        this.canvasThread.start();
        bPage = 0;
        this.setFullScreenMode(true);
    }

    public void hideNotify() {
        soundPlayer.stopSounds();
        if (bPage == 8) {
            if (!MainGame.levelOver) {
                if (!MainGame.isGameWin) {
                    if (!MainGame.isGameOver) {
                        bPage = (byte)3;
                    }
                }
            }
        }
    }

    void loadResources() {
        try {
            Thread.sleep(20L);
            if (this.bResourceLoaded == 0) {
                this.setDatabase(this.midlet.getAppProperty("MIDlet-Name") + "da812", this.midlet.getAppProperty("MIDlet-Name") + "set812");
                this.bResourceLoaded = (byte)(this.bResourceLoaded + 1);
                return;
            }
            if (this.bResourceLoaded == 1) {
                this.bResourceLoaded = (byte)(this.bResourceLoaded + 1);
                return;
            }
            if (this.bResourceLoaded == 2) {
                scroller = Image.createImage((String)"/scrollcursor.png");
                anyKey = Image.createImage((String)"/anykey");
                menuBg = Image.createImage((String)"/menu_bg.png");
                gridBg = Image.createImage((String)"/grid_bg.png");
                menuText = Image.createImage((String)"/menu_txt.png");
                settingsMenu = Image.createImage((String)"/resetrecord_menu.png");
                sndOff = Image.createImage((String)"/sound_off.png");
                sndOn = Image.createImage((String)"/sound_on.png");
                patch = Image.createImage((String)"/patch.png");
                this.bResourceLoaded = (byte)(this.bResourceLoaded + 1);
                return;
            }
            if (this.bResourceLoaded == 3) {
                this.bResourceLoaded = (byte)(this.bResourceLoaded + 1);
                return;
            }
            if (this.bResourceLoaded == 4) {
                this.bResourceLoaded = (byte)(this.bResourceLoaded + 1);
                return;
            }
            if (this.bResourceLoaded == 5) {
                this.bResourceLoaded = (byte)(this.bResourceLoaded + 1);
                return;
            }
            if (this.bResourceLoaded == 6) {
                this.bResourceLoaded = (byte)(this.bResourceLoaded + 1);
                return;
            }
            if (this.bResourceLoaded == 7) {
                this.bResourceLoaded = (byte)(this.bResourceLoaded + 1);
                return;
            }
            if (this.bResourceLoaded == 8) {
                this.bResourceLoaded = (byte)(this.bResourceLoaded + 1);
                return;
            }
            if (this.bResourceLoaded == 9) {
                this.bResourceLoaded = (byte)(this.bResourceLoaded + 1);
                return;
            }
            if (this.bResourceLoaded == 10) {
                bPage = 1;
            }
        }
        catch (Exception exception) {
            System.out.println("error loading resource at " + this.bResourceLoaded + "\n" + exception);
        }
    }

    static void loadIngameImages() {
        try {
            whiteTile = Image.createImage((String)"/white-block.png");
            redTile = Image.createImage((String)"/red-block.png");
            System.gc();
            Runtime.getRuntime().gc();
            redCube = Image.createImage((String)"/cubes/red.png");
            blueCube = Image.createImage((String)"/cubes/blue.png");
            cyanCube = Image.createImage((String)"/cubes/cyan.png");
            yellowCube = Image.createImage((String)"/cubes/yellow.png");
            pinkCube = Image.createImage((String)"/cubes/pink.png");
            doubler = Image.createImage((String)"/cubes/doubler.png");
            bomb = Image.createImage((String)"/cubes/bomb.png");
            convertor = Image.createImage((String)"/cubes/converter.png");
            bomb1 = Image.createImage((String)"/cubes/bomb1.png");
            gridBorder = Image.createImage((String)"/border.png");
            cubesIcon = Image.createImage((String)"/cIcons/cubesIcon.png");
            System.gc();
            Runtime.getRuntime().gc();
        }
        catch (Exception exception) {
            System.out.println(" error in loading Ingame Images " + exception);
        }
    }

    public void paint(Graphics graphics) {
        try {
            switch (bPage) {
                case 0: {
                    this.draw_Loader(graphics);
                    break;
                }
                case 11: {
                    try {
                        this.drawHelpSynopsis(graphics);
                    }
                    catch (Exception exception) {
                        System.out.println(" here error while calling drawHelp Synopsis    " + exception);
                    }
                    break;
                }
                case 1: {
                    try {
                        this.draw_Title(graphics);
                    }
                    catch (Exception exception) {
                        System.out.println(" Here error calling title     " + exception);
                    }
                    break;
                }
                case 2: {
                    this.drawMenu(graphics);
                    break;
                }
                case 3: {
                    this.draw_ContinueMenu(graphics);
                    break;
                }
                case 8: {
                    this.mainGame.renderMain(graphics);
                    break;
                }
                case 4: {
                    this.drawSettings(graphics);
                    break;
                }
                case 5: {
                    if (!hiScorePlayed) {
                        soundPlayer.playHiScore();
                        hiScorePlayed = true;
                    }
                    this.drawHighScore(graphics);
                    break;
                }
                case 6: {
                    this.drawHelp(graphics);
                    break;
                }
                case 7: {
                    this.draw_About(graphics);
                    break;
                }
                case 10: {
                    this.drawHiscoreEntry(graphics);
                    break;
                }
                case 12: {
                    this.drawAskReset(graphics);
                    break;
                }
                case 15: {
                    break;
                }
                case 14: {
                    break;
                }
                case 16: {
                    this.drawIsHiscore(graphics);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void drawIsHiscore(Graphics graphics) {
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        GameCanvas.drawBackGround(graphics, 0);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.setColor(0, 0, 0);
        graphics.drawString(this.sHiscore[0], WIDTH / 2, 36, 17);
        for (int i = 1; i < this.sHiscore.length; ++i) {
            graphics.setColor(0);
            if (i - 1 == selRectPos) {
                graphics.setColor(255, 255, 255);
            }
            graphics.drawString(this.sHiscore[i], WIDTH / 2, 52 + i * 20, 17);
        }
        graphics.setColor(255, 255, 255);
        graphics.setFont(Font.getFont((int)32, (int)1, (int)8));
        graphics.drawString("Select", 4, iHeight - 20, 20);
        graphics.setClip(0, 0, WIDTH, HEIGHT);
    }

    void drawExit(Graphics graphics) {
        ++this.exitctr;
        graphics.drawImage(helpBg, 0, 0, 20);
        graphics.setClip(0, 0, 176, 81);
        graphics.drawImage(exit, 0, 0, 20);
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        graphics.setClip(43, 44, 93, 98);
        graphics.drawImage(exit, -133, 44, 20);
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        if (this.exitctr >= 55) {
            this.midlet.exitMIDlet();
        }
    }

    void drawAskReset(Graphics graphics) {
        GameCanvas.drawBackGround(graphics, 0);
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        graphics.setColor(0, 0, 0);
        graphics.setFont(Font.getFont((int)32, (int)1, (int)8));
        graphics.drawString(this.sResetscore[0], 88, 36, 17);
        for (int i = 1; i < this.sResetscore.length; ++i) {
            if (i - 1 == selRectPos) {
                graphics.setColor(255, 255, 255);
            } else {
                graphics.setColor(0);
            }
            graphics.drawString(this.sResetscore[i], 88, 52 + i * 20, 17);
        }
        graphics.setColor(0, 0, 0);
        graphics.setFont(Font.getFont((int)32, (int)1, (int)8));
        graphics.drawString("Select", 4, iHeight - 20, 20);
        graphics.setClip(0, 0, iWidth, iHeight);
    }

    void draw_Loader(Graphics graphics) {
        int n;
        graphics.setColor(-1);
        graphics.fillRect(0, 0, iWidth, iHeight);
        graphics.drawImage(logo, iWidth / 2, iHeight / 2 - logo.getHeight() / 2, 1 | 0x10);
        graphics.setColor(3966142);
        for (n = 0; n < 136; n += 12) {
            graphics.drawRect(28 + n, iHeight - 36, 10, 8);
        }
        for (n = 0; n < this.bResourceLoaded * 12 + 18; n += 12) {
            graphics.fillRect(28 + n, iHeight - 36, 10, 8);
        }
        graphics.setFont(this.fBold);
        graphics.setColor(0);
        graphics.drawString("www.mauj.com", iWidth / 2, iHeight - 22, 1 | 0x10);
        graphics.setColor(-26368);
        graphics.drawRect(25, iHeight - 38, 148, 12);
    }

    void draw_Title(Graphics graphics) {
        graphics.drawImage(title, 0, 0, 20);
        if (!this.playTitle) {
            soundPlayer.playTitle();
            this.playTitle = true;
        }
        graphics.setColor(255, 255, 255);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        if (this.blinkCtr >= 0 && this.blinkCtr < 20) {
            graphics.drawString("Press JoyStick", WIDTH / 2, HEIGHT - 20, 17);
        }
        if (this.blinkCtr > 40) {
            this.blinkCtr = 0;
        }
        ++this.blinkCtr;
    }

    private void drawMenu(Graphics graphics) {
        GameCanvas.drawBackGround(graphics, 1);
        int n = 31;
        int n2 = 49;
        graphics.setColor(0);
        this.drawArrow(graphics, 10, 48, selRectPos);
        graphics.drawImage(menuText, n, n2, 20);
        graphics.drawImage(patch, 31, 49, 20);
        graphics.drawImage(patch, 31, 109, 20);
        if (SOUND == 0) {
            graphics.drawImage(sndOn, n, 109, 20);
        } else {
            graphics.drawImage(sndOff, n, 109, 20);
        }
        graphics.setColor(255, 255, 255);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.drawString("Press Joystick", WIDTH / 2, HEIGHT - 20, 17);
    }

    private void drawSettings(Graphics graphics) {
        GameCanvas.drawBackGround(graphics, 1);
        int n = 31;
        int n2 = 96;
        this.drawArrow(graphics, 10, 75, selRectPos);
        if (SOUND == 0) {
            graphics.drawImage(sndOn, n, n2, 20);
        } else {
            graphics.drawImage(sndOff, n, n2, 20);
        }
        graphics.drawImage(settingsMenu, n, 116, 20);
    }

    void draw_ContinueMenu(Graphics graphics) {
        GameCanvas.drawBackGround(graphics, 1);
        int n = 31;
        int n2 = 76;
        graphics.setColor(0);
        this.drawArrow(graphics, 10, 55, selRectPos);
        graphics.setClip(n, n2, 150, 50);
        graphics.drawImage(menuText, n, n2, 20);
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        graphics.drawImage(patch, 31, 116, 20);
        graphics.drawImage(patch, 31, 95, 20);
        graphics.drawImage(settingsMenu, n, 95, 20);
        graphics.drawImage(patch, 31, 95, 20);
        graphics.drawImage(patch, 81, 120, 20);
        if (SOUND == 0) {
            graphics.drawImage(sndOn, n, 95, 20);
        } else {
            graphics.drawImage(sndOff, n, 95, 20);
        }
        graphics.setColor(255, 255, 255);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.drawString("Press Joystick", WIDTH / 2, HEIGHT - 20, 17);
    }

    public static void drawBackGround(Graphics graphics, int n) {
        if (n == 0) {
            graphics.drawImage(gridBg, 0, 0, 20);
        } else {
            graphics.drawImage(menuBg, 0, 0, 20);
        }
    }

    private void drawArrow(Graphics graphics, int n, int n2, int n3) {
        graphics.setClip(n, n2 + 20 * n3, 20, 21);
        graphics.drawImage(cubesIcon, -this.animArr * 20 + n, n2 + 20 * n3, 20);
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        this.animArr = (byte)(this.animArr + 1);
        if (this.animArr >= 4) {
            this.animArr = 0;
        }
    }

    void drawHelp(Graphics graphics) {
        GameCanvas.drawBackGround(graphics, 0);
        graphics.setClip(WIDTH / 2 - 15, 1, 30, 20);
        graphics.setFont(this.fBold);
        graphics.drawString("Help", WIDTH / 2, 3, 17);
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        int n = 8;
        int n2 = 24;
        int n3 = 16;
        graphics.setColor(255, 255, 255);
        graphics.setFont(this.fBold);
        int n4 = this.helpPage * this.help_lines + this.help_lines < this.sHelp.length ? this.help_lines * this.helpPage + this.help_lines : this.sHelp.length;
        int n5 = 0;
        for (int i = this.helpPage * this.help_lines; i < n4; ++i) {
            if (this.sHelp[i] != null) {
                if (!(this.sHelp[i].equals("@ ") || this.sHelp[i].equals("# ") || this.sHelp[i].equals("% "))) {
                    graphics.drawString(this.sHelp[i], n, n2 + n5 * n3, 20);
                }
                if (this.sHelp[i].equals("@ ")) {
                    graphics.drawImage(doubler, WIDTH - 30, n2 + --n5 * n3, 20);
                }
                if (this.sHelp[i].equals("# ")) {
                    graphics.drawImage(convertor, WIDTH - 30, n2 + --n5 * n3, 20);
                }
                if (this.sHelp[i].equals("% ")) {
                    graphics.drawImage(bomb1, WIDTH - 30, n2 + --n5 * n3, 20);
                }
            }
            ++n5;
        }
        if (this.helpPage == 0) {
            graphics.setClip(WIDTH / 2 - scroller.getWidth() / 4, HEIGHT - 18 - scroller.getHeight(), scroller.getWidth() / 2, scroller.getHeight());
            graphics.drawImage(scroller, WIDTH / 2 - scroller.getWidth() * 3 / 4, HEIGHT - 18 - scroller.getHeight(), 20);
            graphics.setClip(0, 0, WIDTH, HEIGHT);
        } else if (this.helpPage * this.help_lines + this.help_lines >= this.sHelp.length) {
            graphics.setClip(WIDTH / 2 - scroller.getWidth() / 4, HEIGHT - 18 - scroller.getHeight(), scroller.getWidth() / 2, scroller.getHeight());
            graphics.drawImage(scroller, WIDTH / 2 - scroller.getWidth() / 4, HEIGHT - 18 - scroller.getHeight(), 20);
            graphics.setClip(0, 0, WIDTH, HEIGHT);
        } else {
            graphics.drawImage(scroller, WIDTH / 2 - scroller.getWidth() / 2, HEIGHT - 18 - scroller.getHeight(), 20);
        }
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        graphics.drawString("Press Joystick", WIDTH / 2, HEIGHT - 20, 17);
        graphics.drawString("" + (this.helpPage + 1) + "/" + (this.sHelp.length / 10 + 2), WIDTH - 22, HEIGHT - 17, 20);
    }

    private void drawHelpSynopsis(Graphics graphics) {
        GameCanvas.drawBackGround(graphics, 0);
        graphics.setColor(0);
        graphics.setFont(this.fBold);
        graphics.drawString("Synopsis", WIDTH / 2, 2, 17);
        int n = 8;
        int n2 = 20;
        int n3 = 16;
        graphics.setColor(255, 255, 255);
        graphics.setFont(this.fBold);
        int n4 = this.helpPage * 11 + 11 < this.sSynopsis.length ? this.helpPage * 11 + 11 : this.sSynopsis.length;
        int n5 = 0;
        for (int i = this.helpPage * 11; i < n4; ++i) {
            graphics.drawString(this.sSynopsis[i], 88, 28 + n5 * n3, 17);
            ++n5;
        }
        graphics.drawString("Press Joystick", WIDTH / 2, HEIGHT - 20, 17);
    }

    private void draw_About(Graphics graphics) {
        GameCanvas.drawBackGround(graphics, 0);
        graphics.setFont(this.fBold);
        graphics.setColor(0);
        graphics.drawString("About", WIDTH / 2, 3, 17);
        int n = 20;
        int n2 = 20;
        int n3 = 16;
        graphics.setColor(255, 255, 255);
        graphics.setClip(14, 20, 150, 123);
        graphics.setFont(this.fBold);
        for (int i = 0; i < this.sCredits.length; ++i) {
            graphics.drawString(this.sCredits[i], 88, 30 + i * n3, 17);
        }
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
        graphics.drawString("Press Joystick", WIDTH / 2, HEIGHT - 20, 17);
    }

    private void drawHighScore(Graphics graphics) {
        int n = 12;
        GameCanvas.drawBackGround(graphics, 0);
        int n2 = WIDTH / 2 - 20;
        graphics.setFont(this.fBold);
        graphics.drawString("High Scores", WIDTH / 2, 3, 17);
        graphics.setFont(gameFont);
        graphics.setColor(255, 255, 255);
        graphics.drawString("Name", n, 27, 20);
        graphics.drawString("Level", n + gameFont.stringWidth("Name") + 25, 27, 20);
        graphics.drawString("Score", n + gameFont.stringWidth("NameLevel") + 50, 27, 20);
        graphics.setFont(this.fBold);
        n += 4;
        graphics.setColor(255, 255, 255);
        for (int i = 0; i < this.sNames.length; ++i) {
            graphics.drawString("" + this.sNames[i], n, 55 + i * 20, 20);
            graphics.drawString("" + this.sLevels[i], n + gameFont.stringWidth("Name") + 30, 55 + i * 20, 0x10 | 4);
            graphics.drawString("" + sScores[i], n + gameFont.stringWidth("NameLevel") + 50, 55 + i * 20, 20);
        }
        graphics.setFont(Font.getFont((int)32, (int)1, (int)8));
        graphics.setColor(255, 255, 255);
        graphics.drawString("Menu", 4, iHeight - 20, 20);
        if (sScores[0].equals("0")) {
            this.showreset = false;
        } else {
            graphics.drawString("Reset", WIDTH - 40, iHeight - 20, 20);
            this.showreset = true;
        }
    }

    public void drawHiscoreEntry(Graphics graphics) {
        GameCanvas.drawBackGround(graphics, 0);
        graphics.setClip(0, 0, WIDTH, HEIGHT);
        graphics.setFont(this.fBold);
        graphics.setColor(0, 0, 0);
        graphics.drawString("Enter Your Name", 40, 30, 20);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(40, 50, 98, 22);
        graphics.setColor(0);
        graphics.drawRect(40, 50, 98, 22);
        graphics.setColor(100, 100, 100);
        graphics.drawString(userId, 42, 52, 20);
        if (this.blinkCntr < 15 && userId.length() < 5) {
            graphics.drawString(" |", 42 + this.fBold.stringWidth(userId) - 1, 52, 20);
        } else if (this.blinkCntr >= 30) {
            this.blinkCntr = 0;
        }
        this.blinkCntr = (byte)(this.blinkCntr + 1);
        graphics.setColor(0, 0, 0);
        graphics.drawString("Clear", 2, HEIGHT - 20, 20);
        graphics.drawString("Submit", WIDTH - 50, HEIGHT - 20, 20);
        graphics.setClip(0, 0, WIDTH, HEIGHT);
    }

    void submitScore() {
        if (userId.length() >= 1) {
            boolean bl = false;
            this.saveRecords(userId, MainGame.Level, MainGame.Score);
            bPage = (byte)5;
        }
    }

    public void getPossibleChar(int n) {
        str = null;
        switch (n) {
            case -7: {
                this.submitScore();
                break;
            }
            case -6: {
                userId = "";
                break;
            }
            case 50: {
                str = "abc2";
                this.updateKeyPressed(n, 2);
                break;
            }
            case 51: {
                str = "def3";
                this.updateKeyPressed(n, 2);
                break;
            }
            case 52: {
                str = "ghi4";
                this.updateKeyPressed(n, 2);
                break;
            }
            case 53: {
                str = "jkl5";
                this.updateKeyPressed(n, 2);
                break;
            }
            case 54: {
                str = "mno6";
                this.updateKeyPressed(n, 2);
                break;
            }
            case 55: {
                str = "pqrs7";
                this.updateKeyPressed(n, 3);
                break;
            }
            case 56: {
                str = "tuv8";
                this.updateKeyPressed(n, 2);
                break;
            }
            case 57: {
                str = "wxyz9";
                this.updateKeyPressed(n, 3);
            }
        }
    }

    public void updateKeyPressed(int n, int n2) {
        if (userId.length() > 5) {
            return;
        }
        long l = System.currentTimeMillis() - timeLastInput;
        timeLastInput = System.currentTimeMillis();
        if (lastKeyPressed == n) {
            if (l <= 1000L) {
                keyCntr = keyCntr < n2 ? ++keyCntr : 0;
                userId = userId.substring(0, userId.length() - 1) + str.charAt(keyCntr);
            } else if (userId.length() < 5) {
                keyCntr = 0;
                userId = userId + str.charAt(keyCntr);
            }
        } else if (userId.length() < 5) {
            keyCntr = 0;
            userId = userId + str.charAt(keyCntr);
        }
        lastKeyPressed = n;
        userId = userId.toUpperCase();
    }

    void exit() {
        this.midlet.exitMIDlet();
    }

    protected void keyPressed(int n) {
        action = this.getGameAction(n);
        switch (bPage) {
            case 0: {
                return;
            }
            case 10: {
                this.getPossibleChar(n);
                break;
            }
            case 1: {
                if (n != -6 && n != -5 && n != 53) break;
                logo = null;
                title = null;
                GameCanvas.loadIngameImages();
                soundPlayer.stopSounds();
                Runtime.getRuntime().gc();
                System.gc();
                if (SYNOPCNT < 0) {
                    selRectPos = 0;
                    bPage = (byte)2;
                    break;
                }
                bPage = (byte)11;
                break;
            }
            case 11: {
                if (n != -6 && n != -5 && n != 53) break;
                this.storeSettings(SOUND, VIBRA, (byte)(SYNOPCNT - 1));
                selRectPos = 0;
                bPage = (byte)2;
                break;
            }
            case 2: {
                if (n == -1 || n == 50) {
                    if (selRectPos <= 0) {
                        selRectPos = (byte)(this.sMenu.length - 2);
                        break;
                    }
                    selRectPos = (byte)(selRectPos - 1);
                    break;
                }
                if (n == -2 || n == 56) {
                    if (selRectPos >= this.sMenu.length - 2) {
                        selRectPos = 0;
                        break;
                    }
                    selRectPos = (byte)(selRectPos + 1);
                    break;
                }
                if (n != -6 && n != -5 && n != 53) break;
                switch (selRectPos) {
                    case 0: {
                        this.mainGame.newGame();
                        bPage = (byte)8;
                        break;
                    }
                    case 1: {
                        bPage = (byte)5;
                        break;
                    }
                    case 2: {
                        SOUND = SOUND == 0 ? (byte)1 : 0;
                        this.storeSettings(SOUND, VIBRA, (byte)(SYNOPCNT - 1));
                        break;
                    }
                    case 3: {
                        this.helpPage = 0;
                        bPage = (byte)6;
                        break;
                    }
                    case 4: {
                        bPage = (byte)7;
                        break;
                    }
                    case 5: {
                        this.storeSettings(SOUND, VIBRA, (byte)(SYNOPCNT - 1));
                        this.exit();
                    }
                }
                break;
            }
            case 3: {
                if (n == -1 || n == 50) {
                    if (selRectPos <= 0) {
                        selRectPos = (byte)(this.cMenu.length - 1);
                        break;
                    }
                    selRectPos = (byte)(selRectPos - 1);
                    break;
                }
                if (n == -2 || n == 56) {
                    if (selRectPos >= this.cMenu.length - 1) {
                        selRectPos = 0;
                        break;
                    }
                    selRectPos = (byte)(selRectPos + 1);
                    break;
                }
                if (n != -6 && n != -5 && n != 53) break;
                switch (selRectPos) {
                    case 0: {
                        bPage = (byte)8;
                        continueMenu = false;
                        break;
                    }
                    case 1: {
                        SOUND = SOUND == 0 ? (byte)1 : 0;
                        this.storeSettings(SOUND, VIBRA, (byte)(SYNOPCNT - 1));
                        break;
                    }
                    case 2: {
                        selRectPos = 0;
                        bPage = (byte)2;
                    }
                }
                break;
            }
            case 8: {
                if (n == -7) {
                    if (!MainGame.levelOver) {
                        if (!MainGame.isGameOver) {
                            if (!MainGame.isGameWin) {
                                selRectPos = 0;
                                continueMenu = true;
                                bPage = (byte)3;
                                break;
                            }
                        }
                    }
                }
                this.mainGame.handleKeyInput(n);
                break;
            }
            case 5: {
                if (n == -6 || n == -5 || n == 53) {
                    bPage = (byte)2;
                    selRectPos = 1;
                    soundPlayer.stopSounds();
                    hiScorePlayed = false;
                    break;
                }
                if (n != -7 || !this.showreset) break;
                soundPlayer.stopSounds();
                hiScorePlayed = false;
                selRectPos = 0;
                bPage = (byte)12;
                break;
            }
            case 4: {
                if (n == -1 || n == 50) {
                    if (selRectPos <= 0) {
                        selRectPos = (byte)(options.length - 1);
                        break;
                    }
                    selRectPos = (byte)(selRectPos - 1);
                    break;
                }
                if (n == -2 || n == 56) {
                    if (selRectPos >= options.length - 1) {
                        selRectPos = 0;
                        break;
                    }
                    selRectPos = (byte)(selRectPos + 1);
                    break;
                }
                if (n != -6 && n != -5 && n != 53) break;
                switch (selRectPos) {
                    case 0: {
                        SOUND = SOUND == 0 ? (byte)1 : 0;
                        this.storeSettings(SOUND, VIBRA, (byte)(SYNOPCNT - 1));
                        return;
                    }
                    case 1: {
                        bPage = (byte)12;
                        selRectPos = 0;
                        return;
                    }
                    case 2: {
                        bPage = (byte)2;
                        selRectPos = (byte)2;
                        return;
                    }
                }
                break;
            }
            case 12: {
                if (n == -6 || n == -5 || n == 53) {
                    switch (selRectPos) {
                        case 0: {
                            this.reset();
                            bPage = (byte)5;
                            break;
                        }
                        case 1: {
                            bPage = (byte)5;
                        }
                    }
                    break;
                }
                if (n == -1 || n == 50) {
                    if (selRectPos > 0) {
                        selRectPos = (byte)(selRectPos - 1);
                        break;
                    }
                    selRectPos = 1;
                    break;
                }
                if (n != -2 && n != 56) break;
                if (selRectPos < 1) {
                    selRectPos = (byte)(selRectPos + 1);
                    break;
                }
                selRectPos = 0;
                break;
            }
            case 6: {
                if (n == -1 || n == 50) {
                    if (this.helpPage <= 0) break;
                    --this.helpPage;
                    break;
                }
                if (n == -2 || n == 56) {
                    if (this.helpPage >= this.sHelp.length / (this.help_lines + 1)) break;
                    ++this.helpPage;
                    break;
                }
                if (n != -6 && n != -5 && n != 53) break;
                this.helpPage = 0;
                bPage = (byte)2;
                selRectPos = (byte)3;
                break;
            }
            case 7: {
                if (n != -6 && n != -5 && n != 53) break;
                bPage = (byte)2;
                selRectPos = (byte)4;
                break;
            }
            case 15: {
                if (n != -6 && n != -5 && n != 53) break;
                bPage = (byte)8;
                break;
            }
            case 16: {
                if (n == -6 || n == -5 || n == 53) {
                    switch (selRectPos) {
                        case 0: {
                            selRectPos = 0;
                            userId = "";
                            bPage = (byte)10;
                            break;
                        }
                        case 1: {
                            selRectPos = 0;
                            bPage = (byte)2;
                        }
                    }
                    break;
                }
                if (n == -1 || n == 50) {
                    if (selRectPos > 0) {
                        selRectPos = (byte)(selRectPos - 1);
                        break;
                    }
                    selRectPos = 1;
                    break;
                }
                if (n != -2 && n != 56) break;
                selRectPos = selRectPos < 1 ? (byte)(selRectPos + 1) : (byte)0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (true) {
                if (bPage == 0) {
                    this.loadResources();
                }
                this.cycleStartTime = System.currentTimeMillis();
                this.msSinceLastCycle = System.currentTimeMillis() - this.lastCycleTime;
                this.lastCycleTime = System.currentTimeMillis();
                this.repaint();
                this.serviceRepaints();
                this.timeSinceStart = this.lastCycleTime - this.cycleStartTime;
                if (this.timeSinceStart < 1L) {
                    GameCanvas gameCanvas = this;
                    synchronized (gameCanvas) {
                        this.wait(1L - this.timeSinceStart);
                    }
                }
                Thread.yield();
            }
        }
        catch (Exception exception) {
            System.out.println("App exception: " + exception);
            exception.printStackTrace();
            return;
        }
    }

    void setDatabase(String string, String string2) {
        this.sRecordstorename = string;
        this.sSettingstorename = string2;
        this.loadRecords();
        this.loadSettings();
        this.getSettings();
    }

    public void reset() {
        try {
            RecordStore.deleteRecordStore((String)this.sRecordstorename);
            this.loadRecords();
        }
        catch (Exception exception) {
            System.out.println("error in reset" + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRecords() {
        try {
            this.rRecords = RecordStore.openRecordStore((String)this.sRecordstorename, (boolean)true);
            if (this.rRecords.getNumRecords() < MAX_RECORDS) {
                for (int i = 0; i < MAX_RECORDS; ++i) {
                    this.rRecords.addRecord((this.sNames1[i] + ";" + this.sLevels1[i] + ";" + this.sScores1[i]).getBytes(), 0, (this.sNames1[i] + ";" + this.sLevels1[i] + ";" + this.sScores1[i]).getBytes().length);
                }
            }
            this.rRecords.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("error in load records" + exception);
        }
        finally {
            this.getRecords();
        }
    }

    public void getRecords() {
        String[] stringArray = new String[MAX_RECORDS];
        try {
            this.rRecords = RecordStore.openRecordStore((String)this.sRecordstorename, (boolean)true);
            for (int i = 0; i < MAX_RECORDS; ++i) {
                stringArray[i] = new String(this.rRecords.getRecord(i + 1));
                int n = stringArray[i].indexOf(";");
                this.sNames[i] = stringArray[i].substring(0, n);
                stringArray[i] = stringArray[i].substring(n + 1, stringArray[i].length());
                n = stringArray[i].indexOf(";");
                this.sLevels[i] = stringArray[i].substring(0, n);
                stringArray[i] = stringArray[i].substring(n + 1, stringArray[i].length());
                GameCanvas.sScores[i] = stringArray[i];
            }
            this.rRecords.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("error in database opening");
        }
    }

    public void loadSettings() {
        try {
            this.rSettings = RecordStore.openRecordStore((String)this.sSettingstorename, (boolean)true);
            if (this.rSettings.getNumRecords() < 1) {
                this.rSettings.addRecord("0:0:3".getBytes(), 0, "0:0:3".getBytes().length);
            }
            this.rSettings.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("error in load settings");
        }
    }

    public void getSettings() {
        try {
            int n;
            this.rSettings = RecordStore.openRecordStore((String)this.sSettingstorename, (boolean)true);
            String string = new String(this.rSettings.getRecord(1));
            for (n = 0; n < string.indexOf(":"); ++n) {
                SOUND = (byte)Integer.parseInt(string.substring(0, 1));
                string = string.substring(n + 2, string.length());
            }
            for (n = 0; n < string.indexOf(":"); ++n) {
                VIBRA = (byte)Integer.parseInt(string.substring(0, 1));
                SYNOPCNT = (byte)Integer.parseInt(string.substring(n + 2, string.length()));
            }
            this.rSettings.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("error in load settings");
        }
    }

    public void storeSettings(byte by, byte by2, byte by3) {
        try {
            this.rSettings = RecordStore.openRecordStore((String)this.sSettingstorename, (boolean)true);
            this.rSettings.setRecord(1, (Integer.toString(by) + ":" + Integer.toString(by2) + ":" + Integer.toString(by3)).getBytes(), 0, (Integer.toString(by) + ":" + Integer.toString(by2) + ":" + Integer.toString(by3)).getBytes().length);
            this.rSettings.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("error in load settings");
        }
        this.getSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRecords(String string, int n, int n2) {
        for (int i = string.length(); i < 5; ++i) {
            string = string + " ";
        }
        String[] stringArray = new String[MAX_RECORDS];
        this.getRecords();
        try {
            this.rRecords = RecordStore.openRecordStore((String)this.sRecordstorename, (boolean)true);
            for (int i = 0; i < MAX_RECORDS; ++i) {
                if (n2 < Integer.valueOf(sScores[i])) continue;
                for (int j = i + 1; j < MAX_RECORDS; ++j) {
                    this.rRecords.setRecord(j + 1, (this.sNames[j - 1] + ";" + this.sLevels[j - 1] + ";" + sScores[j - 1]).getBytes(), 0, (this.sNames[j - 1] + ";" + this.sLevels[j - 1] + ";" + sScores[j - 1]).getBytes().length);
                }
                this.rRecords.setRecord(i + 1, (string + ";" + new Integer(n).toString() + ";" + new Integer(n2).toString()).getBytes(), 0, (string + ";" + new Integer(n).toString() + ";" + new Integer(n2).toString()).getBytes().length);
                break;
            }
            this.rRecords.closeRecordStore();
            this.getRecords();
        }
        catch (Exception exception) {
            System.out.println("Errror in save records" + exception);
        }
        finally {
            this.getRecords();
        }
    }

    static {
        options = new String[]{"Sound", "Reset record", "Menu"};
        leftSoftKey = (byte)-6;
        rightSoftKey = (byte)-7;
        continueMenu = false;
        gameFont = Font.getFont((int)32, (int)0, (int)8);
        hiScorePlayed = false;
        userId = "";
        timeLastInput = 0L;
        lastKeyPressed = 0;
        str = "";
        MAX_RECORDS = (byte)5;
        sScores = new String[5];
    }
}

