/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class BitmapFont {
    public int m_iFontID = -2;
    public int m_iFontHeight;
    public int m_iFontColor;
    public int m_iBorderColor;
    public int m_iSpaceCharWidth;
    public boolean m_hasBorder;
    private String m_sEnumChars;
    private int[] m_aiFontImageData;
    private byte[] m_bFontWidth;
    private byte[] m_abFontPackData;
    private int[] m_aiFontPackDataOffset;
    private int m_iBitToShift;
    private int m_iBitAND;
    private int m_iBitToCheckBorder;
    private int m_iScale;
    private boolean m_isLoadDataBitmapFont = false;

    public void SetColor(int n) {
        this.m_iFontColor = n | 0xFF000000;
    }

    public void SetBorderColor(int n) {
        this.m_hasBorder = true;
        this.m_iBorderColor = n | 0xFF000000;
    }

    public int DrawChar(Graphics graphics, char c, int n, int n2) {
        if (c == ' ') {
            return this.m_iSpaceCharWidth;
        }
        if (c == '|') {
            return 0;
        }
        if (GLLibConfig.sprite_drawRGBTransparencyBug) {
            return this.DrawCharPixel(graphics, c, n, n2);
        }
        return this.DrawCharImage(graphics, c, n, n2);
    }

    public int DrawCharImage(Graphics graphics, char c, int n, int n2) {
        if (!this.m_isLoadDataBitmapFont) {
            if (GLLibConfig.sprite_debugErrors) {
                System.out.println("ERROR: Not load data bitmap font yet");
            }
            return 0;
        }
        int n3 = this.MapChar(c);
        if (n3 == -1) {
            return 0;
        }
        this.DecodeFont(n3, this.m_aiFontImageData);
        byte by = this.m_bFontWidth[n3];
        GLLib.DrawRGB(graphics, this.m_aiFontImageData, 0, by, n, n2, by, this.m_iFontHeight, true);
        return by;
    }

    public int DrawCharPixel(Graphics graphics, char c, int n, int n2) {
        if (!this.m_isLoadDataBitmapFont) {
            if (GLLibConfig.sprite_debugErrors) {
                System.out.println("ERROR: Not load data bitmap font yet");
            }
            return 0;
        }
        int n3 = this.MapChar(c);
        if (n3 == -1) {
            return 0;
        }
        byte by = this.m_bFontWidth[n3];
        int n4 = this.m_iFontHeight * by;
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        int n8 = graphics.getColor();
        graphics.setColor(this.m_iFontColor);
        for (int i = 0; i < n4; ++i) {
            n5 = i >> this.m_iBitToShift;
            n6 = (i & this.m_iBitAND) << this.m_iScale;
            int n9 = this.m_abFontPackData[this.m_aiFontPackDataOffset[n3] + n5] >> n6 & this.m_iBitToCheckBorder;
            if (--n9 == 0) {
                graphics.drawLine(n7, n2, n7, n2);
            } else if (this.m_hasBorder && n9 > 0) {
                graphics.setColor(this.m_iBorderColor);
                graphics.drawLine(n7, n2, n7, n2);
                graphics.setColor(this.m_iFontColor);
            }
            if (++n7 - n < by) continue;
            n7 = n;
            ++n2;
        }
        graphics.setColor(n8);
        return by;
    }

    public int GetCharWidth(char c) {
        if (c == ' ') {
            return this.m_iSpaceCharWidth;
        }
        if (c == '|') {
            return 0;
        }
        int n = this.MapChar(c);
        if (n == -1) {
            return 0;
        }
        return this.m_bFontWidth[n];
    }

    private int MapChar(char c) {
        return this.m_sEnumChars.indexOf(c);
    }

    private void DecodeFont(int n, int[] nArray) {
        int n2 = this.m_iFontHeight * this.m_bFontWidth[n];
        int n3 = 0;
        int n4 = 0;
        if (nArray == null) {
            nArray = new int[n2];
        }
        int n5 = n2;
        while (--n5 >= 0) {
            n3 = n5 >> this.m_iBitToShift;
            n4 = (n5 & this.m_iBitAND) << this.m_iScale;
            int n6 = this.m_abFontPackData[this.m_aiFontPackDataOffset[n] + n3] >> n4 & this.m_iBitToCheckBorder;
            if (--n6 == 0) {
                nArray[n5] = this.m_iFontColor | 0xF000000;
                continue;
            }
            if (this.m_hasBorder && n6 > 0) {
                nArray[n5] = this.m_iBorderColor | 0xF000000;
                continue;
            }
            nArray[n5] = 0;
        }
    }
}

