/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class Fonts {
    static final String STANDARD_FONTS_FILE = "/f";
    static final int TOP_LEFT = 20;
    static final int[] SYSTEM_FONT_SIZE = new int[]{8, 0, 16};
    static final int[] SYSTEM_FONT_STYLE = new int[]{0, 1, 2, 4};
    static final int[] SYSTEM_FONT_FACE = new int[]{0, 32, 64};
    static final int FONT_DATA_SIZE = 3;
    static final int OFFSET_DATA_X = 0;
    static final int OFFSET_DATA_Y = 1;
    static final int OFFSET_DATA_WIDTH = 2;
    static Font DEFAULT_SYSTEM_FONT = Font.getDefaultFont();
    static Font[] m_SystemFonts;
    static String[] m_BitmapFonts;
    static String[] m_BitmapFontHashing;
    static int[] m_BitmapFontImages;
    static int[] m_BitmapFontHeights;
    static int[] m_SystemFontColors;
    static boolean[] m_BitmapFontUpperCase;
    static int m_nBitmapFontsCount;
    static int m_nSystemFontsCount;
    static final int SPACE_WIDTH = 3;

    static void Init() {
        try {
            int n;
            int n2;
            Runtime.getRuntime().gc();
            InputStream inputStream = STANDARD_FONTS_FILE.getClass().getResourceAsStream(STANDARD_FONTS_FILE);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            m_nBitmapFontsCount = n2 = dataInputStream.readByte() & 0xFF;
            if (n2 > 0) {
                m_BitmapFonts = new String[n2];
                m_BitmapFontHashing = new String[n2];
                m_BitmapFontHeights = new int[n2];
                m_BitmapFontUpperCase = new boolean[n2];
                m_BitmapFontImages = new int[n2];
                for (n = 0; n < n2; ++n) {
                    Fonts.m_BitmapFontImages[n] = 0xFFFF & dataInputStream.readShort();
                    Fonts.m_BitmapFontHeights[n] = 0xFF & dataInputStream.readByte();
                    Fonts.m_BitmapFontUpperCase[n] = (0xFF & dataInputStream.readByte()) != 0;
                    Fonts.m_BitmapFonts[n] = dataInputStream.readUTF();
                    Fonts.m_BitmapFontHashing[n] = dataInputStream.readUTF();
                }
            }
            m_nSystemFontsCount = n2 = dataInputStream.readByte() & 0xFF;
            if (n2 > 0) {
                m_SystemFonts = new Font[n2];
                m_SystemFontColors = new int[m_nSystemFontsCount];
                for (int i = 0; i < n2; ++i) {
                    int n3;
                    n = dataInputStream.readByte();
                    int n4 = 0;
                    for (n3 = 0; n3 < SYSTEM_FONT_SIZE.length; ++n3) {
                        if ((n & 1 << n3) == 0) continue;
                        n4 = SYSTEM_FONT_SIZE[n3];
                        break;
                    }
                    int n5 = 0;
                    n = dataInputStream.readByte();
                    for (n3 = 0; n3 < SYSTEM_FONT_STYLE.length; ++n3) {
                        if ((n & 1 << n3) == 0) continue;
                        n5 |= SYSTEM_FONT_STYLE[n3];
                    }
                    int n6 = 0;
                    n = dataInputStream.readByte();
                    for (n3 = 0; n3 < SYSTEM_FONT_FACE.length; ++n3) {
                        if ((n & 1 << n3) == 0) continue;
                        n6 = SYSTEM_FONT_FACE[n3];
                        break;
                    }
                    Fonts.m_SystemFontColors[i] = dataInputStream.readInt();
                    Fonts.m_SystemFonts[i] = Font.getFont((int)n6, (int)n5, (int)n4);
                }
            }
            dataInputStream.close();
            dataInputStream = null;
            inputStream = null;
            Runtime.getRuntime().gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int charHash(char c, int n) {
        if (m_BitmapFontUpperCase[n] && c != '\u00df') {
            c = Character.toUpperCase(c);
        }
        String string = m_BitmapFontHashing[n];
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; i += 2) {
            char c2 = string.charAt(i);
            char c3 = string.charAt(i + 1);
            if (c >= c2 && c <= c3) {
                return (n3 + c - c2) * 3;
            }
            n3 += c3 - c2 + 1;
        }
        return -1;
    }

    static int getFontHeight(int n) {
        if (n < m_nBitmapFontsCount) {
            return m_BitmapFontHeights[n];
        }
        return m_SystemFonts[n - m_nBitmapFontsCount].getHeight();
    }

    static int charWidth(char c, int n, boolean bl) {
        int n2;
        int n3 = 0;
        if (c == ' ') {
            n3 = 3;
            return n3;
        }
        n3 = n < m_nBitmapFontsCount ? ((n2 = Fonts.charHash(c, n)) >= 0 ? (int)m_BitmapFonts[n].charAt(n2 + 2) : DEFAULT_SYSTEM_FONT.charWidth(c)) : m_SystemFonts[n - m_nBitmapFontsCount].charWidth(c);
        if (bl && Character.toLowerCase(c) == 'q') {
            n3 += Fonts.charWidth('u', n, bl);
        }
        return n3;
    }

    static int charWidth(char c, int n) {
        return Fonts.charWidth(c, n, false);
    }

    static int charsWidth(char[] cArray, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            n4 += Fonts.charWidth(cArray[i], n3, bl);
        }
        return n4;
    }

    static int charsWidth(char[] cArray, int n, int n2, int n3) {
        return Fonts.charsWidth(cArray, n, n2, n3, false);
    }

    static int stringWidth(String string, int n, boolean bl) {
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n2 += Fonts.charWidth(string.charAt(i), n, bl);
        }
        return n2;
    }

    static int stringWidth(String string, int n) {
        return Fonts.stringWidth(string, n, false);
    }

    static int stringWidth(StringBuffer stringBuffer, int n, boolean bl) {
        int n2 = 0;
        int n3 = stringBuffer.length();
        for (int i = 0; i < n3; ++i) {
            n2 += Fonts.charWidth(stringBuffer.charAt(i), n, bl);
        }
        return n2;
    }

    static int stringWidth(StringBuffer stringBuffer, int n) {
        return Fonts.stringWidth(stringBuffer, n, false);
    }

    static int substringWidth(String string, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            n4 += Fonts.charWidth(string.charAt(i), n3, bl);
        }
        return n4;
    }

    static int substringWidth(String string, int n, int n2, int n3) {
        return Fonts.substringWidth(string, n, n2, n3, false);
    }

    static int substringWidth(StringBuffer stringBuffer, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = n + n2;
        for (int i = n; i < n5; ++i) {
            n4 += Fonts.charWidth(stringBuffer.charAt(i), n3, bl);
        }
        return n4;
    }

    static int substringWidth(StringBuffer stringBuffer, int n, int n2, int n3) {
        return Fonts.substringWidth(stringBuffer, n, n2, n3, false);
    }

    static int drawChar(Graphics graphics, char c, int n, int n2, int n3, boolean bl) {
        int n4;
        if (c == ' ') {
            int n5 = 3;
            return n5;
        }
        if (n3 < m_nBitmapFontsCount) {
            int n6 = Fonts.charHash(c, n3);
            if (n6 >= 0) {
                n4 = m_BitmapFonts[n3].charAt(n6 + 2);
                int n7 = graphics.getClipX();
                int n8 = graphics.getClipY();
                int n9 = graphics.getClipWidth();
                int n10 = graphics.getClipHeight();
                graphics.clipRect(n, n2, n4, m_BitmapFontHeights[n3]);
                Graphic.DrawImage(graphics, m_BitmapFontImages[n3], n - m_BitmapFonts[n3].charAt(n6 + 0), n2 - m_BitmapFonts[n3].charAt(n6 + 1), 20);
                graphics.setClip(n7, n8, n9, n10);
            } else {
                graphics.setFont(DEFAULT_SYSTEM_FONT);
                graphics.drawChar(c, n, n2, 20);
                n4 = DEFAULT_SYSTEM_FONT.charWidth(c);
            }
        } else {
            int n11 = n3 - m_nBitmapFontsCount;
            Font font = m_SystemFonts[n11];
            graphics.setFont(font);
            if (m_SystemFontColors[n11] >= 0) {
                graphics.setColor(m_SystemFontColors[n11]);
            }
            graphics.drawChar(c, n, n2, 20);
            n4 = font.charWidth(c);
        }
        if (bl && Character.toLowerCase(c) == 'q') {
            n4 += Fonts.drawChar(graphics, 'u', n + n4, n2, n3, false);
        }
        return n4;
    }

    static int drawChar(Graphics graphics, char c, int n, int n2, int n3) {
        return Fonts.drawChar(graphics, c, n, n2, n3, false);
    }

    static int drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = 0;
        int n7 = n + n2;
        for (int i = n; i < n7; ++i) {
            n6 += Fonts.drawChar(graphics, cArray[i], n3 + n6, n4, n5, bl);
        }
        return n6;
    }

    static int drawString(Graphics graphics, String string, int n, int n2, int n3, boolean bl) {
        return Fonts.drawSubstring(graphics, string, 0, string.length(), n, n2, n3, bl);
    }

    static int drawString(Graphics graphics, String string, int n, int n2, int n3) {
        return Fonts.drawString(graphics, string, n, n2, n3, false);
    }

    static int drawSubstring(Graphics graphics, String string, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = 0;
        int n7 = n + n2;
        for (int i = n; i < n7; ++i) {
            n6 += Fonts.drawChar(graphics, string.charAt(i), n3 + n6, n4, n5, bl);
        }
        return n6;
    }

    static int drawSubstring(Graphics graphics, StringBuffer stringBuffer, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = 0;
        int n7 = n + n2;
        for (int i = n; i < n7; ++i) {
            n6 += Fonts.drawChar(graphics, stringBuffer.charAt(i), n3 + n6, n4, n5, bl);
        }
        return n6;
    }
}

