/*
 * Decompiled with CFR 0.152.
 */
public class Particles
implements GameConstants,
Constants {
    static int FP1 = 1024;
    static int FP2 = FP1 * 2;
    static int FP_SLOPE_PRECISION;
    static int FP_RADIAN_TO_DEGREE;
    static final int FP_ONE_DEGREE = 17;
    static final int FP_FIFTH = 204;
    static final int FP_THIRD = 341;
    static final int FP_QUARTER_DEGREE = 4;
    static int m_nHomingStars;
    static int m_nHomingWisps;
    static final int[] PARTICLES;
    static int m_nParticles;
    private static int FP_120_PERCENT;
    private static int FP_110_PERCENT;
    private static int FP_95_PERCENT;
    private static int FP_90_PERCENT;
    private static int FP_80_PERCENT;
    private static int FP_GRAVITY_VERY_LOW;
    private static int FP_GRAVITY_LOW;
    private static int FP_GRAVITY_MID;
    private static int FP_GRAVITY_HIGH;
    private static int FP_HOMING_FRUIT_DIST_THRESHOLD;
    static final int NUM_PARTICLE_DIRECTIONS = 8;
    static int m_nRectX;
    static int m_nRectY;
    static int m_nRectX2;
    static int m_nRectY2;
    static long lPlasmaParticleGems;
    static int vrx;
    static int vry;

    static void init() {
        FP_120_PERCENT = FP.fpDiv(120 * FP1, 100 * FP1);
        FP_110_PERCENT = FP.fpDiv(110 * FP1, 100 * FP1);
        FP_95_PERCENT = FP.fpDiv(19 * FP1, 20 * FP1);
        FP_90_PERCENT = FP.fpDiv(18 * FP1, 20 * FP1);
        FP_80_PERCENT = FP.fpDiv(16 * FP1, 20 * FP1);
        FP_RADIAN_TO_DEGREE = FP.fpDiv(FP1 * 5729, 102400);
        FP_GRAVITY_LOW = FP.fpDiv(5 * FP1, 5 * FP1);
        FP_GRAVITY_MID = FP.fpMul(FP_GRAVITY_LOW, FP2);
        FP_GRAVITY_HIGH = FP.fpMul(FP_GRAVITY_LOW, FP1 * 3);
        FP_GRAVITY_VERY_LOW = FP.fpDiv(FP_GRAVITY_LOW, FP1 * 4);
        FP_HOMING_FRUIT_DIST_THRESHOLD = FP1 * (GCanvas.GEM_WIDTH * GCanvas.GEM_WIDTH + GCanvas.GEM_WIDTH * GCanvas.GEM_WIDTH);
    }

    public static void setupParticles(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = m_nParticles * 9;
        int n8 = (PARTICLES.length - n7) / 9;
        if (n8 >= 1) {
            if (n2 == 17 && n > n8) {
                for (int i = 0; i < n - n8; ++i) {
                    HUDController.incHudChainLight();
                }
            }
            n = Math.min(n, n8);
            m_nParticles += n;
            Particles.createParticles(n7, n, n2, n3, n4, n5, n6);
            return;
        }
    }

    public static void createParticles(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        if (n5 != -1 && n6 != -1 || n4 == -1) {
            n10 = n5 * FP1;
            n11 = n6 * FP1;
        } else if (n4 != -1) {
            if (n7 == 2 || n3 == 23) {
                GCanvasController.getGemPosition(n4, true, false);
            } else {
                GCanvasController.getGemPosition(n4, false, true);
            }
            n10 = GCanvasController.m_nGetGemPosX * FP1;
            n11 = GCanvasController.m_nGetGemPosY * FP1;
            if (n3 == 23 || n3 == 24) {
                n10 += FP1 * 22;
                n11 += FP1 * 22;
            }
        }
        if (n3 == 5) {
            n11 += GCanvas.GEM_WIDTH / 2 * FP1;
        }
        for (n9 = 0; n9 < n2; ++n9) {
            if (n3 == 12 || n3 == 6 || n3 == 7 || n3 == 8 || n3 == 15) {
                Particles.createParticleSparkle(n8, n10, n11, n3, n4, -1, n7);
            } else if (n3 == 23) {
                Particles.createParticleSparkle(n8, n10, n11, n3, n4, n9, n7);
            }
            n8 += 9;
        }
    }

    static final void checkParticleRect(int n, int n2) {
        int n3 = FP.toIntRound(PARTICLES[n + 2 - 1]);
        int n4 = FP.toIntRound(PARTICLES[n + 3 - 1]);
        int n5 = n3;
        int n6 = n4;
        int n7 = PARTICLES[n + 7 - 1];
        int n8 = -1;
        int n9 = -1;
        if (!Particles.isFlagSet(3, n)) {
            if (n2 == 6 || n2 == 7 || n2 == 8 || n2 == 12 || n2 == 15 || n2 == 16 || n2 == 19 || n2 == 23) {
                int n10 = Graphic.GetImageWidth(162) / 6;
                n5 += n10;
                n6 += n10;
            }
            if (n3 < m_nRectX || m_nRectX == -1) {
                m_nRectX = Math.max(n3, 0);
            }
            if (n4 < m_nRectY || m_nRectY == -1) {
                m_nRectY = Math.max(n4, 0);
            }
            if (n5 > m_nRectX2 || m_nRectX2 == -1) {
                m_nRectX2 = Math.min(n5, GCanvas.WORLD_WIDTH);
            }
            if (n6 > m_nRectY2 || m_nRectY2 == -1) {
                m_nRectY2 = Math.min(n6, GCanvas.WORLD_HEIGHT);
            }
        }
    }

    public static void handleParticles() {
        if (m_nParticles > 0) {
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < m_nParticles; ++i) {
                n = n2 * 9;
                if (n2 >= m_nParticles) break;
                if (PARTICLES[n] != -1) {
                    int n3 = PARTICLES[n + 6 - 1];
                    if (n3 == 0) {
                        Particles.killParticleType(0, -1, false);
                    }
                    Particles.checkParticleRect(n, n3);
                    if (n3 == 6 || n3 == 7 || n3 == 8 || n3 == 12 || n3 == 15 || n3 == 16 || n3 == 19 || n3 == 23) {
                        Particles.handleParticleSparkle(n);
                    }
                    Particles.checkParticleRect(n, n3);
                }
                ++n2;
            }
            if (m_nRectX != -1) {
                DirtyRect.addDirty(m_nRectX, m_nRectY, m_nRectX2 - m_nRectX, m_nRectY2 - m_nRectY);
                m_nRectY2 = -1;
                m_nRectY = -1;
                m_nRectX = -1;
                m_nRectX2 = -1;
            }
        } else {
            m_nRectY2 = -1;
            m_nRectY = -1;
            m_nRectX = -1;
            m_nRectX2 = -1;
        }
    }

    public static void recycleParticles(boolean bl) {
        int n = 0;
        int n2 = 0;
        if (m_nParticles > 0) {
            for (int i = 0; i < m_nParticles; ++i) {
                n2 = n * 9;
                if (++n > m_nParticles) {
                    return;
                }
                if (!bl && PARTICLES[n2 + 1 - 1] != -1 || !bl && PARTICLES[n2] != -1) continue;
                if (m_nParticles == 1 || bl) {
                    Particles.PARTICLES[0] = -1;
                    m_nParticles = 0;
                    m_nHomingStars = 0;
                    m_nHomingWisps = 0;
                    return;
                }
                for (int j = n2 + 9; j < PARTICLES.length && j < m_nParticles * 9; ++j) {
                    Particles.PARTICLES[j - 9] = PARTICLES[j];
                    Particles.PARTICLES[j] = -1;
                }
                --m_nParticles;
            }
        }
    }

    static boolean isFlagSet(int n, int n2) {
        return (PARTICLES[n2 + 7 - 1] & 1 << n) != 0;
    }

    static void setFlag(int n, int n2) {
        int n3 = n2 + 7 - 1;
        PARTICLES[n3] = PARTICLES[n3] | 1 << n;
    }

    static void unSetFlag(int n, int n2) {
        int n3 = n2 + 7 - 1;
        PARTICLES[n3] = PARTICLES[n3] & ~(1 << n);
    }

    private static final void createParticleSparkle(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9 = 0;
        int n10 = 0;
        if (n4 == 23) {
            n8 = 13 * n6 % 360;
            n10 = FP.fpMul(FP1 * (n7 + n8), 17);
        } else {
            n10 = FP.fpMul(FP1 * Math.max(1, Util.GetRandom(360)), 17);
        }
        n8 = FP.fpCos(n10);
        int n11 = FP.fpSin(n10);
        int n12 = 0;
        n12 = n4 == 8 ? (GameController.m_nCurrentState == 2 && GameController.m_nLevelUpState == 9 ? Particles.randIntValueAsFP(4, 6) : Particles.randIntValueAsFP(8, 12)) : (n4 == 12 ? Particles.randIntValueAsFP(2, 4) : (n4 == 23 ? 44 * FP1 : Particles.randIntValueAsFP(3, 5)));
        int n13 = Graphic.GetImageWidth(162) / 12;
        int n14 = 0;
        if (n4 != 12) {
            n14 = FP1 * (GCanvas.GEM_WIDTH / 2 - n13);
        }
        int n15 = 0;
        if (n4 == 6) {
            n15 = Util.GetRandom(6);
        } else if (n4 == 12) {
            n15 = Util.GetRandom(18);
        } else if (n4 == 23) {
            n15 = n6 + Util.GetRandom(3);
        }
        for (int i = n; i < n + 9; ++i) {
            int n16;
            n9 = i - n;
            if (n9 == 0) {
                Particles.PARTICLES[i] = 10 + n15;
                continue;
            }
            if (n9 == 1) {
                n16 = 0;
                n16 = n4 == 12 ? FP1 * Util.GetRandom(GCanvas.GEM_WIDTH / 2) : (n4 == 15 ? 0 : (n4 == 23 ? FP.fpMul(n8, n12) : FP.fpMul(n8, FP1 * n13)));
                Particles.PARTICLES[i] = n2 + n14 + n16;
                continue;
            }
            if (n9 == 2) {
                n16 = 0;
                n16 = n4 == 12 ? FP1 * Util.GetRandom(GCanvas.GEM_WIDTH / 2) : (n4 == 15 ? 0 : (n4 == 23 ? FP.fpMul(n11, n12) : FP.fpMul(n11, FP1 * n13)));
                Particles.PARTICLES[i] = n3 + n14 + n16;
                continue;
            }
            if (n9 == 3) {
                if (n4 == 12 || n4 == 23) {
                    Particles.PARTICLES[i] = 0;
                    continue;
                }
                Particles.PARTICLES[i] = FP.fpMul(n8, n12);
                continue;
            }
            if (n9 == 4) {
                if (n4 == 12) {
                    Particles.PARTICLES[i] = FP.fpMul(-FP1, n12);
                    continue;
                }
                if (n4 == 23) {
                    Particles.PARTICLES[i] = 0;
                    continue;
                }
                Particles.PARTICLES[i] = FP.fpMul(n11, n12);
                continue;
            }
            if (n9 == 8) {
                if (n4 != 12 || n5 == -1) continue;
                Particles.PARTICLES[i] = n5;
                continue;
            }
            if (n9 == 6) {
                Particles.PARTICLES[i] = 0;
                if (n15 <= 0) continue;
                int n17 = i;
                PARTICLES[n17] = PARTICLES[n17] | 8;
                continue;
            }
            if (n9 == 7) {
                Particles.PARTICLES[i] = n15;
                continue;
            }
            if (n9 != 5) continue;
            Particles.PARTICLES[i] = n4;
        }
    }

    private static final void createParticleFruitSuck(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = FP.fpMul(FP1 * Math.max(1, Util.GetRandom(360)), 17);
        m_nHomingStars = Math.max(1, m_nHomingStars + 1);
        int n8 = FP.fpCos(n7);
        int n9 = FP.fpSin(n7);
        int n10 = 1 * FP1;
        int n11 = Graphic.GetImageWidth(162) / 12;
        int n12 = FP1 * (GCanvas.GEM_WIDTH / 2 - n11);
        int n13 = 0;
        for (int i = n; i < n + 9; ++i) {
            int n14;
            n6 = i - n;
            if (n6 == 0) {
                Particles.PARTICLES[i] = 10 + n13;
                continue;
            }
            if (n6 == 1) {
                n14 = Particles.randFPValueAsFP(FP1 * 60, FP1 * 75);
                n14 = FP.fpMul(n8, n14);
                Particles.PARTICLES[i] = n2 + n12 + n14;
                continue;
            }
            if (n6 == 2) {
                n14 = Particles.randFPValueAsFP(FP1 * 60, FP1 * 75);
                n14 = FP.fpMul(n9, n14);
                Particles.PARTICLES[i] = n3 + n12 + n14;
                continue;
            }
            if (n6 == 3) {
                Particles.PARTICLES[i] = -FP.fpMul(n8, n10);
                continue;
            }
            if (n6 == 4) {
                Particles.PARTICLES[i] = -FP.fpMul(n9, n10);
                continue;
            }
            if (n6 == 8) {
                if (n5 == -1) continue;
                Particles.PARTICLES[i] = n5;
                continue;
            }
            if (n6 == 6) {
                Particles.PARTICLES[i] = 0;
                continue;
            }
            if (n6 == 7) {
                Particles.PARTICLES[i] = 0;
                continue;
            }
            if (n6 != 5) continue;
            Particles.PARTICLES[i] = n4;
        }
    }

    private static final void createParticleRainDrop(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = FP.fpAtan2(FP1 * Graphic.m_nYCenter - n3, FP1 * Graphic.m_nXCenter - n2);
        int n7 = FP.fpDiv(FP1 * 10, FP1 * 21);
        int n8 = FP.fpMul(FP.fpCos(n6), n7);
        int n9 = FP.fpMul(FP.fpSin(n6), n7);
        if (n2 >= FP1 * (Graphic.m_nXCenter / 2)) {
            n8 = -Math.abs(n8);
            n9 = n3 <= FP1 * (Graphic.m_nYCenter / 2) ? Math.abs(n9) : -Math.abs(n9);
        }
        for (int i = n; i < n + 9; ++i) {
            n5 = i - n;
            if (n5 == 0) {
                Particles.PARTICLES[i] = 21;
                continue;
            }
            if (n5 == 1) {
                Particles.PARTICLES[i] = n2;
                continue;
            }
            if (n5 == 2) {
                Particles.PARTICLES[i] = n3;
                continue;
            }
            if (n5 == 3) {
                Particles.PARTICLES[i] = n8;
                continue;
            }
            if (n5 == 4) {
                Particles.PARTICLES[i] = n9;
                continue;
            }
            if (n5 == 8) continue;
            if (n5 == 6) {
                Particles.PARTICLES[i] = 0x400000;
                continue;
            }
            if (n5 == 7) {
                Particles.PARTICLES[i] = 0;
                continue;
            }
            if (n5 != 5) continue;
            Particles.PARTICLES[i] = n4;
        }
    }

    private static final void handleParticleSparkle(int n) {
        int n2 = n + 1 - 1;
        int n3 = PARTICLES[n2];
        PARTICLES[n2] = n3 - 1;
        int n4 = n3;
        int n5 = 10;
        if (n4 <= n5 && Particles.isFlagSet(3, n)) {
            Particles.unSetFlag(3, n);
        } else if (!Particles.isFlagSet(3, n)) {
            int n6 = PARTICLES[n + 4 - 1];
            int n7 = PARTICLES[n + 5 - 1];
            int n8 = n + 2 - 1;
            PARTICLES[n8] = PARTICLES[n8] + n6;
            int n9 = n + 3 - 1;
            PARTICLES[n9] = PARTICLES[n9] + n7;
            Particles.PARTICLES[n + 4 - 1] = FP.fpMul(n6, FP_95_PERCENT);
            Particles.PARTICLES[n + 5 - 1] = FP.fpMul(n7, FP_95_PERCENT);
            int n10 = n + 8 - 1;
            PARTICLES[n10] = PARTICLES[n10] + 1;
            if (PARTICLES[n10] >= n5) {
                Particles.PARTICLES[n + 8 - 1] = 0;
            }
            int n11 = FP.toIntRound(PARTICLES[n + 2 - 1]);
            int n12 = FP.toIntRound(PARTICLES[n + 3 - 1]);
            if (n4 <= 0 || n11 < 0 || n11 > GCanvas.WORLD_WIDTH || n12 > GCanvas.WORLD_HEIGHT || n12 < 0) {
                Particles.PARTICLES[n + 1 - 1] = -1;
            }
        }
    }

    private static final void handleParticleFruitSuck(int n) {
        int n2 = 10;
        int n3 = PARTICLES[n + 4 - 1];
        int n4 = PARTICLES[n + 5 - 1];
        int n5 = n + 2 - 1;
        int n6 = PARTICLES[n5] + n3;
        PARTICLES[n5] = n6;
        int n7 = n6;
        int n8 = n + 3 - 1;
        int n9 = PARTICLES[n8] + n4;
        PARTICLES[n8] = n9;
        int n10 = n9;
        Particles.PARTICLES[n + 4 - 1] = FP.fpMul(n3, FP_120_PERCENT);
        Particles.PARTICLES[n + 5 - 1] = FP.fpMul(n4, FP_120_PERCENT);
        int n11 = n + 8 - 1;
        PARTICLES[n11] = PARTICLES[n11] + 1;
        if (PARTICLES[n11] >= n2) {
            Particles.PARTICLES[n + 8 - 1] = 0;
        }
        int n12 = GCanvas.GEM_WIDTH / 2;
        GCanvasController.getGemPosition(PARTICLES[n + 9 - 1], true, false);
        int n13 = Graphic.GetImageHeight(162) / 2;
        int n14 = (GCanvasController.m_nGetGemPosX + n12 - n13) * FP1;
        int n15 = (GCanvasController.m_nGetGemPosY + n12 - n13) * FP1;
        int n16 = FP.toInt(n7);
        int n17 = FP.toInt(n10);
        if (Particles.rectPointInside(FP.toInt(n14) - n12 / 2, FP.toInt(n15) - n12 / 2, n12, n12, n16, n17) || FP.toInt(n3) > 0 && n16 > FP.toInt(n14) || FP.toInt(n3) < 0 && n16 < FP.toInt(n14) || FP.toInt(n4) > 0 && n17 > FP.toInt(n15) || FP.toInt(n4) > 0 && n17 > FP.toInt(n15)) {
            Particles.PARTICLES[n + 1 - 1] = -1;
            m_nHomingStars = Math.max(0, m_nHomingStars - 1);
            GModel.m_bShakeFruitGem = true;
            return;
        }
    }

    private static final void handleParticleRainDrop(int n) {
        int n2 = n + 1 - 1;
        int n3 = PARTICLES[n2] - 1;
        PARTICLES[n2] = n3;
        int n4 = n3;
        if (!Particles.isFlagSet(0, n)) {
            if (n4 % 3 == 0) {
                int n5 = n + 8 - 1;
                PARTICLES[n5] = PARTICLES[n5] + 1;
            }
            int n6 = PARTICLES[n + 4 - 1];
            int n7 = PARTICLES[n + 5 - 1];
            if (n4 > 1) {
                int n8 = n + 2 - 1;
                PARTICLES[n8] = PARTICLES[n8] + n6;
                int n9 = n + 3 - 1;
                PARTICLES[n9] = PARTICLES[n9] + n7;
            }
            if (n4 <= 0) {
                Particles.setFlag(0, n);
                int n10 = (Graphic.GetImageHeight(33) - Graphic.GetImageHeight(154)) / 2 * FP1;
                int n11 = n + 2 - 1;
                PARTICLES[n11] = PARTICLES[n11] + n10;
                int n12 = n + 3 - 1;
                PARTICLES[n12] = PARTICLES[n12] + n10;
                Particles.PARTICLES[n + 8 - 1] = 0;
                Particles.PARTICLES[n + 1 - 1] = 7;
            }
        } else {
            int n13 = n + 8 - 1;
            PARTICLES[n13] = PARTICLES[n13] + 1;
            if (n4 <= 0) {
                Particles.PARTICLES[n + 1 - 1] = -1;
            }
        }
    }

    private static final int getRandDirectionalAngle(int n, int n2) {
        int n3 = 0;
        n3 = n2 == -1 ? Util.GetRandom(45) : Util.GetRandom(n2);
        n3 = (n -= 8) == 8 ? (n3 -= 22) : (n3 += n * 45);
        return n3;
    }

    static final void killPlasmaParticles(int n) {
        if (m_nParticles > 0 && (lPlasmaParticleGems & 1L << n) != 0L) {
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < m_nParticles; ++i) {
                n2 = n3 * 9;
                if (n3 >= m_nParticles) break;
                if (PARTICLES[n2] != -1 && PARTICLES[n2 + 6 - 1] == 13 && PARTICLES[n2 + 9 - 1] == n) {
                    Particles.PARTICLES[n2 + 1 - 1] = -1;
                    lPlasmaParticleGems &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
                    Particles.setFlag(3, n2);
                }
                ++n3;
            }
        }
    }

    static final void killParticleType(int n, int n2, boolean bl) {
        if (m_nParticles > 0) {
            int n3 = 0;
            for (int i = 0; i < m_nParticles; ++i) {
                n3 = i * 9;
                if (i >= m_nParticles) break;
                if (PARTICLES[n3] == -1 || PARTICLES[n3 + 6 - 1] != n || (!bl || !Particles.isFlagSet(3, n3)) && bl || (n2 == -1 || PARTICLES[n3 + 9 - 1] != n2) && n2 != -1) continue;
                Particles.PARTICLES[n3 + 1 - 1] = -1;
            }
        }
        if (n == 12) {
            GCanvasController.m_nFruitIdleSparkleFrame = 0;
        }
    }

    static final void switchPlasmaParticles(int n, int n2) {
        if (m_nParticles > 0 && (lPlasmaParticleGems & 1L << n) != 0L) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < m_nParticles; ++i) {
                n4 = n5 * 9;
                if (n5 >= m_nParticles) break;
                if (PARTICLES[n4] != -1 && PARTICLES[n4 + 6 - 1] == 13 && PARTICLES[n4 + 9 - 1] == n) {
                    lPlasmaParticleGems &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
                    lPlasmaParticleGems |= 1L << n2;
                    Particles.PARTICLES[n4 + 9 - 1] = n2;
                    if (++n3 == 2) {
                        return;
                    }
                }
                ++n5;
            }
        }
    }

    static final void resetPlasmaParticles(long l) {
        int n = Util.findNextSetBit(l, 0);
        while (n != -1) {
            Particles.setupParticles(2, 13, n, -1, -1, -1);
            n = Util.findNextSetBit(l, n + 1);
        }
    }

    static final void highlightMultiplerInc() {
        Particles.setupParticles(15, 15, -1, HUD.HUD_MULTIPLIER_POD_LEFT_X, HUD.HUD_MULTIPLIER_CENTRE_Y, -1);
    }

    static final void startRaindrops() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < Util.GetRandom(3); ++i) {
            int n3 = Util.GetRandom(30) - 15;
            n2 = 0;
            n = 0;
            if (Util.GetRandom(2) == 0) {
                n = Util.GetRandom(Graphic.m_nWidth);
                n2 = Util.GetRandom(2) == 0 ? Graphic.m_nHeight + n3 : (n2 += n3);
            } else {
                n2 = Util.GetRandom(GCanvas.BOARD_POSITION_Y);
                if (Util.GetRandom(2) == 0) {
                    n2 = Graphic.m_nHeight - n2;
                }
                if (Util.GetRandom(2) == 0) {
                    n = Graphic.m_nWidth + n3;
                } else {
                    n2 += n3;
                }
            }
            Particles.setupParticles(1, 21, -1, n, n2, -1);
        }
    }

    static final int lengthSquared(int n, int n2) {
        int n3 = FP.fpMul(n, n) + FP.fpMul(n2, n2);
        if (n3 < 0) {
            return -1;
        }
        return n3;
    }

    static final int length(int n, int n2) {
        int n3 = FP.fpMul(n, n) + FP.fpMul(n2, n2);
        if (n3 < 0) {
            return -1;
        }
        return FP.fpSqrt(n3);
    }

    static final void normalise(int n, int n2) {
        int n3 = Particles.length(n, n2);
        if (n3 == 0) {
            return;
        }
        int n4 = FP.fpDiv(FP1, n3);
        vrx = FP.fpMul(n, n4);
        vry = FP.fpMul(n2, n4);
    }

    static boolean rectPointInside(int n, int n2, int n3, int n4, int n5, int n6) {
        return n5 >= n && n5 < n + n3 && n6 >= n2 && n6 < n2 + n4;
    }

    static int randIntValueAsFP(int n, int n2) {
        int n3 = Math.max(Util.GetRandom(100), 1) * FP1;
        int n4 = FP.fpMul(n2 * FP1, n3);
        n4 = FP.fpDiv(n4, 102400);
        return Math.max(n4, n * FP1);
    }

    static int randFPValueAsFP(int n, int n2) {
        int n3 = Math.max(Util.GetRandom(100), 1) * FP1;
        int n4 = FP.fpMul(n2, n3);
        n4 = FP.fpDiv(n4, 102400);
        return Math.max(n4, n);
    }

    static {
        m_nHomingStars = 0;
        m_nHomingWisps = 0;
        PARTICLES = new int[2251];
        m_nParticles = 0;
        m_nRectX = 0;
        m_nRectY = 0;
        m_nRectX2 = 0;
        m_nRectY2 = 0;
    }
}

