/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class Input
implements InputConstants,
Constants {
    private static int m_nPressedKeyFlags = 0;
    private static int m_nReleasedKeyFlags = 0;
    private static int m_nUnhandledKeyFlags = 0;
    private static int m_nHeldKeyFlags = 0;
    private static boolean m_bSuppressNumberKeyMapping = false;
    private static int m_nPressedKeyASCII = 0;
    private static int m_nSoftKeyPaddingX = 0;
    private static int m_nSoftKeyPaddingY = 0;
    static String[] m_strCommandNames;
    static int[] m_commandPositions;
    static int[] m_ActiveCommands;
    static final int[] COMMAND_TYPES;
    static int m_nSoftKeysFontHeight;
    static int m_nSKframeFlashCount;
    static boolean m_nSKFlashOn;

    Input() {
    }

    static void InitInput() {
        m_nSoftKeysFontHeight = Fonts.getFontHeight(8);
    }

    static void SuppressNumberKeyMapping(boolean bl) {
        m_bSuppressNumberKeyMapping = bl;
    }

    private static int ParseKey(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < "".length(); ++n2) {
            if ((char)n != "".charAt(n2)) continue;
            return n3;
        }
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n3 |= 1 << n - 48;
                break;
            }
            case 35: {
                n3 |= 0x800;
                break;
            }
            case 42: {
                n3 |= 0x400;
            }
        }
        if (!m_bSuppressNumberKeyMapping || n < 48 || n > 57) {
            int n4;
            int n5;
            n2 = 0;
            for (n5 = 0; n5 < "\ufffa\ufff9123456789".length(); ++n5) {
                if (n != (short)"\ufffa\ufff9123456789".charAt(n5)) continue;
                n3 |= '\u0001' << "\u0016\u0017\u0012\u000e\u0013\f\u0010\r\u0014\u000f\u0015".charAt(n5);
                n2 = 1;
            }
            n5 = 0;
            for (n4 = 0; n4 < "".length(); ++n4) {
                if (n != "".charAt(n4)) continue;
                n5 = 1;
                break;
            }
            n4 = 0;
            if (Graphic.me != null) {
                try {
                    n4 = Graphic.me.getGameAction(n);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (n2 == 0 && n5 == 0) {
                switch (n4) {
                    case 1: {
                        n3 |= 0x4000;
                        break;
                    }
                    case 6: {
                        n3 |= 0x8000;
                        break;
                    }
                    case 2: {
                        n3 |= 0x1000;
                        break;
                    }
                    case 5: {
                        n3 |= 0x2000;
                        break;
                    }
                    case 8: {
                        n3 |= 0x10000;
                    }
                }
            }
        }
        if ((n3 & 0x400000) != 0 && m_ActiveCommands[0] < 0) {
            n3 &= 0xFFBFFFFF;
        }
        if ((n3 & 0x800000) != 0 && m_ActiveCommands[1] < 0) {
            n3 &= 0xFF7FFFFF;
        }
        return n3;
    }

    static void HandleKeyPress(int n) {
        int n2 = Input.ParseKey(n);
        m_nUnhandledKeyFlags |= n2;
        m_nPressedKeyFlags |= n2;
        m_nPressedKeyASCII = n;
        m_nHeldKeyFlags |= n2;
    }

    static void HandleKeyRepeat(int n) {
    }

    static int GetLastPressedKeys() {
        int n = m_nUnhandledKeyFlags;
        m_nUnhandledKeyFlags = 0;
        return n;
    }

    static int GetLastPressedKeyASCII() {
        int n = m_nPressedKeyASCII;
        m_nPressedKeyASCII = 0;
        return n;
    }

    static int GetHeldKeys() {
        return m_nHeldKeyFlags;
    }

    static int GetLastReleasedKey() {
        int n = m_nReleasedKeyFlags;
        m_nReleasedKeyFlags = 0;
        return n;
    }

    static void HandleKeyRelease(int n) {
        m_nReleasedKeyFlags = m_nPressedKeyFlags;
        m_nPressedKeyFlags &= ~Input.ParseKey(n);
        m_nHeldKeyFlags &= ~Input.ParseKey(n);
    }

    static void initCommands(int[] nArray, int[] nArray2) {
        if (m_strCommandNames == null || m_strCommandNames.length != nArray.length) {
            m_strCommandNames = new String[nArray.length];
        }
        m_commandPositions = nArray2;
        for (int i = 0; i < nArray.length; ++i) {
            Input.m_strCommandNames[i] = Text.GAME_STRINGS[nArray[i]];
        }
        System.arraycopy(nArray2, 0, m_commandPositions, 0, m_commandPositions.length);
    }

    static void initCommands(String string, String string2) {
        int n;
        if (m_strCommandNames == null || m_strCommandNames.length != string.length()) {
            m_strCommandNames = new String[string.length()];
        }
        m_commandPositions = new int[string2.length()];
        for (n = 0; n < m_commandPositions.length; ++n) {
            Input.m_commandPositions[n] = string2.charAt(n);
        }
        for (n = 0; n < m_strCommandNames.length; ++n) {
            Input.m_strCommandNames[n] = string.charAt(n) == '\uffff' ? "" : Text.GAME_STRINGS[string.charAt(n)];
        }
    }

    static void resetCommands() {
        for (int i = 0; i < 2; ++i) {
            Input.m_ActiveCommands[i] = -1;
        }
    }

    static void resetCommand(int n) {
        Input.m_ActiveCommands[n] = -1;
    }

    static void addCommand(int n) {
        Input.m_ActiveCommands[Input.m_commandPositions[n]] = n;
    }

    static void isFlashConfirm(int n, int n2) {
    }

    static void drawSoftKeys(Graphics graphics, int n, int n2, int n3) {
        int n4 = m_ActiveCommands[0];
        int n5 = m_ActiveCommands[1];
        Input.isFlashConfirm(n4, n5);
        UIView.drawSoftkeys(graphics, n4, n5);
    }

    static void drawSoftKeysLandscape(Graphics graphics, int n, int n2) {
    }

    static int getNumericDigit(int n) {
        for (int i = 0; i <= 9; ++i) {
            if ((n & 1 << 0 + i) == 0) continue;
            return i;
        }
        return -1;
    }

    static int getActionDigit(int n) {
        if (m_bSuppressNumberKeyMapping) {
            return -1;
        }
        int n2 = -1;
        for (int i = 0; i < "\ufffa\ufff9123456789".length(); ++i) {
            if ("\u0016\u0017\u0012\u000e\u0013\f\u0010\r\u0014\u000f\u0015".charAt(i) != n) continue;
            if (n2 != -1) {
                return -1;
            }
            n2 = "\ufffa\ufff9123456789".charAt(i) - 48;
            if (n2 >= 0 && n2 <= 9) continue;
            n2 = -1;
        }
        return n2;
    }

    static void setSoftKeyPadding(int n, int n2) {
        m_nSoftKeyPaddingX = n;
        m_nSoftKeyPaddingY = n2;
    }

    static int getSoftKeyHeight() {
        if (Graphic.m_bDrawSoftkeys) {
            return m_nSoftKeysFontHeight + m_nSoftKeyPaddingY * 2;
        }
        return 0;
    }

    static void releaseAllKeys() {
        m_nHeldKeyFlags = 0;
        m_nPressedKeyFlags = 0;
        m_nUnhandledKeyFlags = 0;
    }

    static int RotateKeys(int n) {
        int n2 = n & 0xFFC30FFF;
        for (int i = 0; i < "\f\r\u000e\u000f\u0012\u0013\u0014\u0015".length(); ++i) {
            if ((n & '\u0001' << "\f\r\u000e\u000f\u0012\u0013\u0014\u0015".charAt(i)) == 0) continue;
            n2 |= '\u0001' << "\u000e\u000f\r\f\u0013\u0015\u0012\u0014".charAt(i);
        }
        return n2;
    }

    static boolean compareCommands(int n, int n2) {
        return m_ActiveCommands[n] == n2;
    }

    static {
        m_ActiveCommands = new int[2];
        COMMAND_TYPES = new int[]{2, 4};
        m_nSKframeFlashCount = 0;
        m_nSKFlashOn = true;
    }
}

