/*
 * Decompiled with CFR 0.152.
 */
public class GameController
implements GameConstants,
Constants,
SoundManagerConstants {
    static boolean m_bAlwaysAskToReplay = false;
    static int m_nLevelUpStateFrame;
    static boolean m_bGameOver;
    static boolean m_bChallengeFailed;
    static int m_nCurrentLevel;
    static int m_nCurrentState;
    static int m_nLevelUpState;
    static int m_nBoardStateFrame;
    static int m_nGameMode;
    static boolean m_bLevelUp;
    static int m_nBadGemAmnestyEvents;
    static boolean m_nIncreaseChain;
    static int m_nGemsDestroyedPerMove;
    static int m_nTurnScoreTotal;
    static boolean m_bPlayedClick;
    static boolean[] m_SaveGameExists;
    static boolean[] m_GameModeUnlocked;
    static long m_lCurrentSeed;
    static int m_nCursorX;
    static int m_nCursorY;
    static boolean m_bAnimatingPlayersMove;
    static boolean m_bOneGameOfClassicCompleted;
    static boolean m_bReplaying;
    static byte[] REPLAY_SAVE_DATA;
    static boolean m_bReplayExists;
    static long m_lUnHighlightedGems;
    static boolean m_bAllowSpecialGems;
    static boolean m_bFinishedFruitSuck;
    static int m_nCountdownsInc;
    static boolean m_bBlitzGameOverViaCountdown;
    static final String[] BONUS_TEXT_STRINGS;
    public static final int MAX_CHAIN_MULT;
    public static final int MAX_CHAIN_MULT_TEXT;
    static int m_nNebulaOffset;
    static int m_nBlitzFrameCounterBeforeReplayStarted;

    static void destroyApp() {
    }

    static void init() {
        GModel.init();
        ScoreController.init();
        BoardTexts.init();
        Particles.init();
        HUDController.init();
        Challenge.init();
        Hint.init();
        GCanvas.init();
        Background.init();
        GCanvasController.init();
        DirtyRect.init();
        HUD.init();
        ParticleCanvas.init();
        for (int i = 0; i < 64; ++i) {
            GCanvasController.FADE_TILES[i] = -1;
        }
        GameController.m_GameModeUnlocked[0] = true;
        GameController.m_GameModeUnlocked[1] = true;
        GameController.m_GameModeUnlocked[3] = false;
        GameController.m_GameModeUnlocked[2] = false;
        m_bAllowSpecialGems = false;
        m_bOneGameOfClassicCompleted = false;
        GameController.resetAllGameVariables();
    }

    static void resetAllGameVariables() {
        GameController.resetVars();
        GModel.resetVars();
        Challenge.resetVars();
        GCanvasController.resetVars();
        DirtyRect.resetVars();
        BoardTexts.resetVars();
        Hint.resetVars();
        UIController.resetVars();
        ScoreController.resetVars();
        HUDController.resetVars();
        SoundManager.resetVars();
        Background.resetVars();
    }

    static void resetVars() {
        m_nLevelUpStateFrame = 0;
        m_nLevelUpState = -1;
        m_nBoardStateFrame = 0;
        m_nGameMode = -1;
        m_bLevelUp = false;
        m_bChallengeFailed = false;
        m_nBadGemAmnestyEvents = 0;
        m_nIncreaseChain = true;
        m_nGemsDestroyedPerMove = 0;
        m_bPlayedClick = false;
        m_lCurrentSeed = System.currentTimeMillis();
        GModel.TWIST_LOGIC_RANDOMER.setSeed(m_lCurrentSeed);
        m_bAnimatingPlayersMove = false;
        m_nTurnScoreTotal = 0;
        m_bReplaying = false;
        m_bReplayExists = false;
        m_bGameOver = false;
        Text.resetMarquee();
        Util.resetArray(REPLAY_SAVE_DATA, (byte)0);
        m_bFinishedFruitSuck = false;
        m_nCountdownsInc = 0;
        RankUpdateScreen.m_nRankUpdateXPToUpdate = 0;
        m_bBlitzGameOverViaCountdown = false;
    }

    static void resetTurnVars() {
        m_nTurnScoreTotal = 0;
        m_nBadGemAmnestyEvents = 0;
        m_bAnimatingPlayersMove = false;
        m_nGemsDestroyedPerMove = 0;
        GModel.m_nCascades = 1;
        GModel.m_nMatchesCountSaved = 0;
        ScoreController.m_lScoredGems = 0L;
    }

    static void updateGame() {
        if (Hint.showHints(true, false)) {
            return;
        }
        GCanvasController.updateBoard();
        GameController.updateFrameCounters();
        GCanvasController.updateAnims();
        GModel.updateGemsNextState();
        if (m_nCurrentState == 3) {
            GameController.updateGemsDestroyed();
            if (GModel.m_nMatchesCount == 0 && m_bLevelUp) {
                GameController.changeState(2);
            } else {
                Hint.updateHintTimer();
            }
        } else if (m_nCurrentState == 4) {
            if (GModel.m_nMoveOffset != -1) {
                GModel.m_nMoveOffset = GModel.m_nTutorialSlowRotates >= 0 || m_bReplaying ? (GModel.m_nMoveOffset += GCanvas.GEM_TWIST_SPEED / 2) : (GModel.m_nMoveOffset += GCanvas.GEM_TWIST_SPEED);
            }
            if (Math.abs(GModel.m_nMoveOffset) > GCanvas.GEM_WIDTH) {
                GameController.finishedTwisting();
                GameController.checkForMatches(true);
            }
            long l = GModel.BOARD[17] | GModel.BOARD[18] | GModel.BOARD[19] | GModel.BOARD[20];
            int n = Util.findNextSetBit(l, 0);
            while (n != -1) {
                GCanvasController.addDirtyGem(n);
                n = Util.findNextSetBit(l, n + 1);
            }
        } else if (m_nCurrentState == 14) {
            int n;
            int n2 = Util.findNextSetBit(GModel.m_lCurrentFruitExploding, 0);
            if (m_nBoardStateFrame == 0) {
                GCanvasController.setGemAnimation(n2, 59, 0);
                m_nCountdownsInc = 0;
            } else if (m_nBoardStateFrame % 4 == 0) {
                n = m_nBoardStateFrame / 4 + 1;
                int n3 = 1024 * Math.min(5, n);
                long l = GModel.BOARD[GModel.getGemColour(1L << n2)] & ((GModel.m_lSpecialGemsNewlyCreated | GModel.BOARD[14]) ^ 0xFFFFFFFFFFFFFFFFL);
                int n4 = Util.findNextSetBit(l, 0);
                while (n4 != -1) {
                    long l2 = 1L << n4;
                    if ((GModel.m_lSpecialGemsNewlyCreated & l2) == 0L && (GModel.BOARD[21] & l2) == 0L && GModel.GEMS_NEXT_STATE[n4] == -1) {
                        GCanvasController.pushGemOut(n4, 0, 0, n3, 4, 16L, true, n3);
                    }
                    n4 = Util.findNextSetBit(l, n4 + 1);
                }
            }
            if (m_nBoardStateFrame < 24 && n2 != -1) {
                n = Util.GetRandom(5) + 1;
                Particles.setupParticles(n, 19, n2, -1, -1, -1);
            }
            GameController.fruitExplodeIncCountdowns();
            if (!m_bFinishedFruitSuck && GModel.BOARD[59] == 0L) {
                GModel.resolveFruitGems(GModel.m_lCurrentFruitExploding, false);
                m_bFinishedFruitSuck = true;
            }
            if (GCanvasController.bFruitExplosionAnimFinsihed()) {
                GModel.m_lCurrentFruitExploding = -1L;
                m_bFinishedFruitSuck = false;
                GameController.changeState(7);
            }
            if (GModel.m_lUnhandledSpecialGems != 0L) {
                GameController.resolveSpecialGems();
            }
        } else if (m_nCurrentState == 7) {
            if (GModel.m_lUnhandledSpecialGems != 0L) {
                GameController.resolveSpecialGems();
            }
            if (GCanvasController.bAllGemExplodeAnimsFinished() && GCanvasController.bAllGemsFinsihedPushedOut() && GModel.m_lGemsDelayedState == 0L && m_nCurrentState == 7) {
                GameController.updateExplodingCountdownStats(Util.bitsSetLong(GModel.BOARD[21] & GModel.BOARD[13]));
                GModel.calculateGemFallDis(GModel.BOARD[21]);
                GModel.moveGemProperties();
                GameController.generateNewGems();
                GModel.findMatches(GModel.BOARD, true);
                if (GModel.m_nMatchesCount == 0) {
                    if (GModel.m_bCreateCountdownAtEndOfMove) {
                        GModel.addQueuedGem(13);
                    }
                    if (GModel.m_bCreateCoalAtEndOfMove) {
                        GModel.addQueuedGem(7);
                    }
                }
                GameController.changeState(6);
            }
        } else if (m_nCurrentState == 6) {
            if (GCanvasController.m_bAnimationResolved) {
                for (int i = 63; i >= 0; --i) {
                    GCanvasController.GEMS_FP_FALL_OFFSET[i] = 0;
                    GCanvasController.GEMS_FP_FALL_SPEED[i] = 0;
                    GCanvasController.GEMS_FP_OFFSET_X[i] = 0;
                    GCanvasController.GEMS_FP_OFFSET_Y[i] = 0;
                    GCanvasController.GEMS_OFFSET_DELAY[i] = 0;
                    GCanvasController.GEMS_FP_OFFSET_TOTAL[i] = 0;
                    GModel.BOARD_RESOLUTION_MOVES[i] = 0;
                }
                if (GModel.m_nMatchesCount == 0) {
                    GModel.BOARD[21] = 0L;
                } else {
                    ++GModel.m_nCascades;
                }
                SoundManager.handleSoundEvent(9);
                GameController.updatePostMove();
            }
        } else if (m_nCurrentState == 2) {
            GameController.updateLevelUp();
        } else if (m_nCurrentState == 8) {
            GameController.updateGameOver();
        } else if (m_nCurrentState == 9) {
            if (m_nBoardStateFrame >= 15) {
                LuckySpinScreen.startLuckySpin(LuckySpinScreen.m_nLuckySpinGem);
            } else {
                Particles.setupParticles(4, 14, LuckySpinScreen.m_nLuckySpinGem, -1, -1, -1);
                if (m_nBoardStateFrame % 5 == 0) {
                    int n = (m_nBoardStateFrame / 5 + 1) * 2;
                    int n5 = 1024 * Math.min(10, n);
                    GCanvasController.pushGemOut(LuckySpinScreen.m_nLuckySpinGem, 0, 0, n5, 5, 16L, true, n5);
                }
            }
        } else if (m_nCurrentState == 11) {
            if (m_nBoardStateFrame == 0) {
                int n = m_nCursorY * 8 + m_nCursorX;
                Particles.setupParticles(22, 23, n, -1, -1, 220);
                Particles.setupParticles(22, 23, n, -1, -1, 40);
            }
            if (m_nBoardStateFrame >= 15) {
                if (m_bAnimatingPlayersMove) {
                    GameController.twistGems(m_nCursorY * 8 + m_nCursorX, true);
                } else {
                    GameController.changeState(3);
                }
            }
        } else if (m_nCurrentState == 12) {
            if (m_nBoardStateFrame == 1) {
                Text.m_nMarqueeIterations = 1;
                Text.m_nMarqueeGap = 0;
            }
            if (m_nBoardStateFrame >= 15 && Text.m_strMarqueeText.length() == 0) {
                Challenge.endChallenge();
            }
        } else if (m_nCurrentState == 13) {
            int n;
            if (m_nBoardStateFrame == 7) {
                SoundManager.handleSoundEvent(53);
            }
            if (m_nBoardStateFrame < 15) {
                n = 0;
                n = m_nBoardStateFrame == 0 ? 40 : Util.GetRandom(2) + 1;
                if (GModel.m_nAwardedFruitGem != -1) {
                    Particles.setupParticles(n, 16, GModel.m_nAwardedFruitGem, HUD.HUD_MULTIPLIER_POD_LEFT_X, HUD.HUD_MULTIPLIER_CENTRE_Y, -1);
                }
            } else if (Particles.m_nHomingStars <= 0 && GModel.m_bAwardFruitGem) {
                if (GModel.m_nAwardedFruitGem != -1) {
                    GModel.addSpecialGem(1L << GModel.m_nAwardedFruitGem, 12, 54, true, true);
                    GModel.m_nAwardedFruitGem = -1;
                }
                GModel.m_bShakeFruitGem = false;
                GModel.m_bAwardFruitGem = false;
                Hint.flagHint(26);
                GModel.m_nChainMultiplier -= 2;
                GModel.m_nChains = 1;
                HUDController.setHudDrawVarsToGameVars();
                GameController.endTurnBackToNormal();
            }
            if (GModel.m_bShakeFruitGem && m_nBoardStateFrame % 4 == 0) {
                n = m_nBoardStateFrame / 4 + 1;
                int n6 = 1024 * Math.min(5, n);
                GCanvasController.pushGemOut(GModel.m_nAwardedFruitGem, 0, 0, n6, 4, 16L, true, n6);
            }
        } else if (m_nCurrentState == 15) {
            boolean bl = false;
            if (m_nCountdownsInc < 6 && m_nBoardStateFrame % 6 == 0) {
                bl = true;
                ++m_nCountdownsInc;
                int n = Util.findNextSetBit(GModel.BOARD[13], 0);
                while (n != -1) {
                    if (n != LuckySpinScreen.m_nLuckySpinGem) {
                        if (GModel.GEM_COUNTDOWN_MOVES[n] < 19 && (GModel.BOARD[21] & 1L << n) == 0L) {
                            int n7 = n;
                            GModel.GEM_COUNTDOWN_MOVES[n7] = GModel.GEM_COUNTDOWN_MOVES[n7] + 1;
                            GCanvasController.setCountdownVectorPulse(n, 1, true, GraphicsUtil.getPingPongPeakFrame("\u0150\u0151\u0153\u0154\u0155".length()));
                            if (m_nCountdownsInc == 6) {
                                GCanvasController.setGemAnimation(n, 34, 0);
                            }
                            bl = false;
                        }
                    } else {
                        GModel.BOARD[21] = GModel.BOARD[21] | 1L << n;
                        GCanvasController.setGemAnimation(n, 28, 0);
                    }
                    n = Util.findNextSetBit(GModel.BOARD[13], n + 1);
                }
                n = Util.findNextSetBit(GModel.BOARD[14], 0);
                while (n != -1) {
                    if (GModel.GEM_COUNTDOWN_MOVES[n] < 19 && (GModel.BOARD[21] & 1L << n) == 0L) {
                        int n8 = n;
                        GModel.GEM_COUNTDOWN_MOVES[n8] = GModel.GEM_COUNTDOWN_MOVES[n8] + 1;
                    }
                    GCanvasController.setCountdownVectorPulse(n, 0, true, GraphicsUtil.getPingPongPeakFrame("\u0150\u0151\u0153\u0154\u0155".length()));
                    n = Util.findNextSetBit(GModel.BOARD[14], n + 1);
                    bl = false;
                }
                if (bl) {
                    GameController.changeState(7);
                }
            }
            if (m_nCountdownsInc >= 6 || bl) {
                GameController.changeState(7);
                GModel.m_bSkipCountdownThisFrame = true;
                ++m_nBadGemAmnestyEvents;
            }
        }
        if (m_nGameMode != 2) {
            ScoreController.updateScore();
        }
        GCanvasController.updateDirtyGems();
        if (m_nGameMode == 3) {
            GameController.updateBlitzMode();
        }
        ++m_nBoardStateFrame;
    }

    static boolean updateLevelUp() {
        ++m_nLevelUpStateFrame;
        if (m_nBoardStateFrame % 2 == 0) {
            HUDController.m_nDisplayChainsCurrent = Math.max(HUDController.m_nDisplayChainsCurrent - 1, 0);
        }
        if (m_nLevelUpState == 7) {
            if (m_nGameMode == 2) {
                GameController.changeLevelUpState(4);
                SoundManager.handleSoundEvent(44);
            } else if (Text.m_strMarqueeText.length() == 0) {
                GameController.changeLevelUpState(8);
            }
        } else if (m_nLevelUpState == 8) {
            boolean bl = true;
            if (m_nGameMode != 3 && !m_bGameOver || m_nGameMode == 3 && m_bGameOver && !m_bBlitzGameOverViaCountdown) {
                GCanvasController.fadeGameBoard();
            }
            boolean bl2 = bl = GCanvasController.m_nBoardFadeFrame <= 0 && Util.bitsSetLong(GCanvasController.lBoardFadedRows) == 8 && (GModel.BOARD[40] | GModel.BOARD[53]) == 0L || m_bGameOver;
            if (HUDController.m_nHudMultiplierAnim == 12 && bl) {
                GameController.changeLevelUpState(4);
                SoundManager.handleSoundEvent(44);
            }
        } else if (m_nLevelUpState == 4) {
            GCanvasController.redrawEverything();
            if (m_nLevelUpStateFrame == 16) {
                GameController.changeLevelUpState(6);
                UIController.conditionStartRankScreen(3L);
            } else if (m_nGameMode != 3 && !m_bGameOver || m_nGameMode == 3 && m_bGameOver && !m_bBlitzGameOverViaCountdown) {
                GCanvasController.closeGameBoardPortrait();
            }
        } else if (m_nLevelUpState == 6) {
            if (m_nLevelUpStateFrame == 30) {
                GameController.changeLevelUpState(5);
            }
        } else if (m_nLevelUpState == 5) {
            if (m_nLevelUpStateFrame == "EBA@=<".length()) {
                GameController.updateLevelUpNextStateAfterHudIsClosed();
            }
        } else if (m_nLevelUpState == 0) {
            if (m_nLevelUpStateFrame == 0) {
                GCanvasController.m_nColourModifier = 0;
            }
            GCanvasController.m_nColourModifier += 3;
            if (Starfield.STAR_SPEED < Starfield.STAR_MAX_SPEED) {
                Starfield.STAR_SPEED += Starfield.STAR_ACC;
            } else if (GCanvasController.m_nColourModifier >= 100 && RankUpdateScreen.m_nRankUpdateXPToUpdate == 0 && RankUpdateScreen.m_nRankUpdateAnimStage != 3) {
                if (GModel.m_StartingNewGameFromOldOne || (m_nGameMode != 2 || UIView.m_bDoStarFieldLoading) && (m_nGameMode != 3 || UIView.m_bDoStarFieldLoading)) {
                    GameController.changeLevelUpState(1);
                }
                if (UIView.m_bDoStarFieldLoading) {
                    MainUIController.loadGameSet(false);
                    if (m_nGameMode == 2) {
                        Util.resetArray(GModel.BOARD, 0L);
                        GModel.generateBoard(GModel.BOARD, -1L, false);
                        Challenge.setChallengeSpecifics(Challenge.getLevel(), false);
                    }
                    UIView.m_bDoStarFieldLoading = false;
                } else {
                    Background.loadBackgroundImageSet();
                }
            }
        } else if (m_nLevelUpState == 1) {
            GCanvasController.m_nColourModifier += 2;
            if (Starfield.STAR_SPEED > Starfield.STAR_MIN_SPEED) {
                if ((Starfield.STAR_SPEED -= Starfield.STAR_DEC) < Starfield.STAR_MIN_SPEED) {
                    Starfield.STAR_SPEED = Starfield.STAR_MIN_SPEED;
                }
            } else {
                GameController.changeLevelUpState(2);
            }
        } else if (m_nLevelUpState == 2) {
            if (m_nLevelUpStateFrame == "EBA@=<".length()) {
                GameController.changeLevelUpState(3);
                SoundManager.handleSoundEvent(43);
            }
        } else if (m_nLevelUpState == 3) {
            HUDController.m_nDisplayChainsCurrent = Math.min(HUDController.m_nDisplayChainsCurrent + 1, GModel.m_nChains);
            GCanvasController.redrawEverything();
            if (m_nLevelUpStateFrame == 16) {
                GameController.changeLevelUpState(9);
            }
        } else if (m_nLevelUpState == 9) {
            boolean bl = false;
            if (GModel.BOARD[12] != 0L && m_lUnHighlightedGems != 0L) {
                if (m_nLevelUpStateFrame % 5 == 0 || GModel.BOARD[12] == m_lUnHighlightedGems) {
                    int n = Util.findRandSetBit(m_lUnHighlightedGems);
                    m_lUnHighlightedGems &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
                    Particles.setupParticles(20, 8, n, -1, -1, -1);
                }
            } else {
                bl = true;
            }
            if (bl) {
                GameController.endLevelUp();
                GameController.changeState(3);
                if (m_nGameMode == 2) {
                    MainUIController.changeState(44, false);
                }
                GCanvasController.m_nColourModifier = 0;
                SoundManager.handleSoundEvent(6);
            }
        }
        if (m_nLevelUpStateFrame == -1) {
            m_nLevelUpStateFrame = 0;
        }
        return true;
    }

    static void updateLevelUpNextStateAfterHudIsClosed() {
        GameController.changeLevelUpState(0);
        if (m_bGameOver) {
            m_bGameOver = false;
            UIController.doGameOver(m_nGameMode, m_bChallengeFailed);
        }
    }

    static void checkForMatches(boolean bl) {
        if (GCanvasController.m_bFinishTransition) {
            GCanvasController.m_bFinishTransition = false;
            GModel.findMatches(GModel.BOARD, true);
        }
        GameController.resolveMatches(bl);
        if (GModel.m_nMatchesCount == 0) {
            GameController.updatePostMove();
        } else {
            GCanvasController.setCursorAnim(1, 0, -1);
            if (GModel.m_lCurrentFruitExploding == -1L) {
                GameController.changeState(7);
            } else {
                GameController.changeState(14);
            }
        }
    }

    static void updatePostMove() {
        if (GModel.m_nMatchesCount == 0) {
            GModel.setLockedGems();
            GModel.setDoomGems();
            if (m_bLevelUp) {
                GModel.m_bCreatePreLockAtEndOfMove = false;
                GModel.m_bCreatePreDoomAtEndOfMove = false;
            }
            if (GModel.m_bCreatePreLockAtEndOfMove) {
                GModel.addPreLockedGem(GModel.PRELOCK_VALID_MASK);
                GModel.m_bCreatePreLockAtEndOfMove = false;
            }
            if (GModel.m_bCreatePreDoomAtEndOfMove && GModel.addSpecialGem(GModel.PRELOCK_VALID_MASK, 15, 56, false, true) != -1) {
                ++GModel.m_nDoomGemsCreatedThisLevel;
                GModel.m_bCreatePreDoomAtEndOfMove = false;
                SoundManager.handleSoundEvent(33);
            }
            if (GModel.m_bBadMove) {
                GameController.spawnBadGems(GModel.BOARD_MASK, true, false, false);
            }
            GModel.updateCountdownMoves(GModel.m_bBadMove);
            if (GModel.m_bAwardFruitGem) {
                GameController.changeState(13);
            } else {
                GameController.endTurnBackToNormal();
                GModel.checkIfMoveAvailable(false);
            }
        } else {
            GameController.checkForMatches(false);
        }
    }

    static void changeState(int n) {
        if (m_nCurrentState == 2) {
            m_bLevelUp = false;
        }
        switch (n) {
            case 3: {
                Hint.showHints(false, false);
                break;
            }
            case 2: {
                GModel.m_nResetGemCountFlame = Util.bitsSetLong(GModel.BOARD[8]);
                GModel.m_nResetGemCountLightning = Util.bitsSetLong(GModel.BOARD[9]);
                GModel.m_nResetGemCountFruit = Util.bitsSetLong(GModel.BOARD[12]);
                GModel.m_nResetGemCountSuper = Util.bitsSetLong(GModel.BOARD[16]);
                GameController.changeLevelUpState(7);
                break;
            }
            case 7: {
                if (GModel.m_nMatchesCount == 0 || m_nCurrentState == 14) break;
                GameController.queueNextCascadeSound();
                break;
            }
            case 6: {
                m_bPlayedClick = false;
                GCanvasController.m_bAnimationResolved = false;
                break;
            }
            case 4: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                GModel.awardFruitGem();
                break;
            }
            case 14: {
                m_bFinishedFruitSuck = false;
                break;
            }
            case 15: {
                m_nCountdownsInc = 0;
                break;
            }
            case 12: {
                if (HUDController.m_nHudFadeAlpha == 1) break;
                HUDController.m_nHudFadeAlpha = 1;
                HUDController.m_nHudFadeAlphaFrame = 0;
            }
        }
        m_nCurrentState = n;
        m_nBoardStateFrame = -1;
    }

    static void changeLevelUpState(int n) {
        m_nLevelUpState = n;
        m_nLevelUpStateFrame = -1;
        if (m_nLevelUpState == 7) {
            if (m_nGameMode == 3 && !m_bBlitzGameOverViaCountdown) {
                HUDController.setHUDText(151, -1, true, false);
            } else if (m_bGameOver) {
                HUDController.setHUDText(141, -1, true, false);
            } else {
                HUDController.setHUDText(143, -1, true, true);
                SoundManager.handleSoundEvent(41);
                HUDController.m_nHudGlowCycles = 3;
                HUDController.m_nHudGlowFrame = -1;
            }
            if (HUDController.m_nHudFadeAlpha != 1) {
                HUDController.m_nHudFadeAlpha = 1;
                HUDController.m_nHudFadeAlphaFrame = 0;
            }
        } else if (m_nLevelUpState == 8) {
            HUDController.m_nHudChainMultTextAnimation = 8;
            GCanvasController.lBoardFadedRows = 0L;
            GCanvasController.m_nBoardFadeFrame = -1;
        } else if (m_nLevelUpState == 4) {
            GCanvasController.lBoardFadedRows = 0L;
            GCanvasController.m_nBoardFadeFrame = -1;
            GCanvasController.redrawEverything();
        } else if (m_nLevelUpState == 0) {
            if (GModel.m_StartingNewGameFromOldOne) {
                SoundManager.handleSoundEvent(47);
            }
            Background.incBackground(m_nGameMode);
        } else if (m_nLevelUpState == 3) {
            if (!GModel.m_bLevelUpNewGame || GModel.m_StartingNewGameFromOldOne) {
                GameController.setNewBoardVars();
            }
        } else if (m_nLevelUpState == 9) {
            m_lUnHighlightedGems = GModel.BOARD[12];
        } else if (m_nLevelUpState == 5) {
            GModel.m_nCurrentGemFill = 0;
            GModel.m_nStaggerGemFill = 0;
        }
    }

    static boolean okToTwist() {
        return m_nCurrentState == 3;
    }

    static boolean handleCursor(boolean bl) {
        int n = m_nCursorX;
        int n2 = m_nCursorY;
        if ((MainUIController.m_nLastPressed & 0x4000) != 0 || MainUIController.isHeldForFrame(16384, 5)) {
            if (m_nCursorY > 0) {
                --m_nCursorY;
                bl = true;
            } else {
                m_nCursorY = 6;
                bl = true;
            }
        } else if ((MainUIController.m_nLastPressed & 0x8000) != 0 || MainUIController.isHeldForFrame(32768, 5)) {
            if (m_nCursorY < 6) {
                ++m_nCursorY;
                bl = true;
            } else {
                m_nCursorY = 0;
                bl = true;
            }
        }
        if ((MainUIController.m_nLastPressed & 0x1000) != 0 || MainUIController.isHeldForFrame(4096, 5)) {
            if (m_nCursorX > 0) {
                --m_nCursorX;
                bl = true;
            } else {
                m_nCursorX = 6;
                bl = true;
            }
        } else if ((MainUIController.m_nLastPressed & 0x2000) != 0 || MainUIController.isHeldForFrame(8192, 5)) {
            if (m_nCursorX < 6) {
                ++m_nCursorX;
                bl = true;
            } else {
                m_nCursorX = 0;
                bl = true;
            }
        }
        if ((MainUIController.m_nLastPressed & 0x10000) != 0 && GameController.okToTwist()) {
            GameController.twistGems(m_nCursorY * 8 + m_nCursorX, false);
        }
        GCanvasController.addDirtyCursor(n, n2);
        return bl;
    }

    static boolean bTouchedCursor(int n) {
        return n - 5 == m_nCursorX + m_nCursorY * 7;
    }

    static void handleTouchInput() {
        if (Touch.zoneCollided >= 5 && Touch.zoneCollided < 54) {
            if (Touch.pressType != -1) {
                int n = (Touch.zoneCollided - 5) % 7;
                int n2 = (Touch.zoneCollided - 5) / 7;
                if (m_nCursorX != n || m_nCursorY != n2) {
                    GCanvasController.addDirtyCursor(m_nCursorX, m_nCursorY);
                    m_nCursorX = n;
                    m_nCursorY = n2;
                    GCanvasController.addDirtyCursor(m_nCursorX, m_nCursorY);
                }
            }
            if (Touch.pressType == 3 && GameController.bTouchedCursor(Touch.zoneCollided) && GameController.okToTwist()) {
                GameController.twistGems(m_nCursorY * 8 + m_nCursorX, false);
            }
        }
    }

    static void handleInput() {
        if (Graphic.m_bLandscape) {
            return;
        }
        if (m_bReplaying || m_nCurrentState == 2 || m_nCurrentState == 8 || m_nCurrentState == 9 || GameController.handleCursor(false)) {
            // empty if block
        }
        if ((MainUIController.m_nLastPressed & 0x800000) != 0) {
            GameController.handleSoftkeyPress(1);
        }
        if ((MainUIController.m_nLastPressed & 0x400000) != 0) {
            GameController.handleSoftkeyPress(0);
        }
        GameController.handleTouchInput();
    }

    static void handleSoftkeyPress(int n) {
        for (int i = 0; i < 2; ++i) {
            int n2 = Input.m_ActiveCommands[i];
            if (n2 == -1 || "\u0001\u0001\u0001\u0000".charAt(n2) != n) continue;
            if (n2 == 3) {
                if (!m_bReplayExists) continue;
                GameController.startReplay();
                continue;
            }
            if (n2 != 2) continue;
            if (m_nCurrentState == 2) {
                SoundManager.handleSoundEvent(1, true);
                MainUIController.changeState(14, false);
                continue;
            }
            UIController.gotoPauseMenu(m_nGameMode);
        }
    }

    static void twistGems(int n, boolean bl) {
        if (bl || GModel.rotate(n, true, GModel.BOARD, true)) {
            m_bAnimatingPlayersMove = true;
            Particles.killParticleType(23, -1, true);
            if (!bl) {
                if (++GModel.m_nMovesMadePerLev >= 2) {
                    Hint.flagHint(9);
                }
                m_lCurrentSeed = System.currentTimeMillis();
                RMS.softSave(m_nGameMode, false, false);
                GameController.clearReplay();
            }
            GModel.TWIST_LOGIC_RANDOMER.setSeed(m_lCurrentSeed);
            GameController.changeState(4);
            GModel.m_nMoveOffset = 0;
            GModel.m_nTutorialSlowRotates = GModel.m_nMatchesMadePerLev > 0 ? -1 : Math.max(-1, GModel.m_nTutorialSlowRotates - 1);
        }
    }

    static void resolveMatches(boolean bl) {
        int n;
        int n2;
        BoardTexts.removeLinkedMatches();
        long l = 0L;
        boolean bl2 = m_bAllowSpecialGems || m_nGameMode == 3 || m_nGameMode == 2;
        GModel.m_lSpecialGemsNewlyCreated = 0L;
        Util.resetArray(ScoreController.SCORED_GEM_LINKED_MATCH, -1);
        for (n2 = 0; n2 < GModel.m_nMatchesCount; ++n2) {
            GModel.BOARD[21] = GModel.BOARD[21] | GModel.MATCHES[n2];
            GModel.MATCHES_TEMP[n2] = GModel.MATCHES[n2];
        }
        if (GModel.m_nMatchesCount > 0) {
            long l2 = GModel.BOARD[21] & GModel.BOARD[13];
            n = Util.findNextSetBit(l2, 0);
            while (n != -1) {
                GModel.startWisps(13, n);
                n = Util.findNextSetBit(l2, n + 1);
            }
        }
        if (m_nGameMode == 2) {
            Challenge.checkChallengeMatchConditions();
        }
        n2 = 0;
        boolean bl3 = false;
        for (n = 0; n < GModel.m_nMatchesCount; ++n) {
            l = GModel.MATCHES_TEMP[n];
            long l3 = GModel.MATCHES[n] & GModel.BOARD[10];
            if (n2 == 0 && (GModel.MATCHES[n] & GModel.BOARD[13]) != 0L) {
                SoundManager.handleSoundEvent(39);
                n2 = 1;
            }
            if (!bl3 && (GModel.MATCHES[n] & GModel.BOARD[10]) != 0L) {
                SoundManager.handleSoundEvent(40);
                bl3 = true;
            }
            if (l3 != 0L || (GModel.MATCHES[n] & GModel.BOARD[13]) != 0L || (GModel.MATCHES[n] & GModel.BOARD[7]) != 0L || (GModel.MATCHES[n] & GModel.BOARD[15]) != 0L || (GModel.MATCHES[n] & GModel.BOARD[14]) != 0L || (GModel.MATCHES[n] & GModel.BOARD[11]) != 0L) {
                // empty if block
            }
            int n3 = Util.bitsSetLong(GModel.MATCHES_TEMP[n]);
            ScoreController.scoreMatch(n, l, l3, -1);
            if (n3 > 3 && bl2) {
                long l4 = GModel.getInLineMatches(GModel.MATCHES_TEMP[n]);
                int n4 = Util.bitsSetLong(l4);
                if (n4 > 3) {
                    if (n4 >= 6) {
                        if (GModel.createSpecialGemFromMatch(n, -1, 16, 32)) {
                            Hint.flagHint(3);
                        }
                    } else if (n4 >= 5) {
                        if (GModel.createSpecialGemFromMatch(n, -1, 9, 24)) {
                            Hint.flagHint(2);
                            ++Challenge.m_nLightningCreatedThisTurn;
                        }
                    } else if (n4 >= 4 && GModel.createSpecialGemFromMatch(n, -1, 8, 31)) {
                        Hint.flagHint(1);
                        ++Challenge.m_nFlameCreatedThisTurn;
                    }
                } else if (n3 == 5) {
                    GModel.findSpecialShapedMatches(n, true);
                }
            } else {
                GCanvasController.setExplodeGemsBitfieldAnim(GModel.MATCHES[n] & GModel.BOARD[21] & (GModel.BOARD[12] ^ 0xFFFFFFFFFFFFFFFFL), 0);
            }
            ScoreController.linkDestroyedGemsToMatch(n);
        }
        if (bl) {
            GModel.handleChains(bl);
        }
        GModel.checkForSpecialExplodingGems(true);
        if (GModel.m_lCurrentFruitExploding == -1L && GModel.m_lUnhandledSpecialGems != 0L) {
            GameController.resolveSpecialGems();
        }
        if (m_nGameMode == 2) {
            Challenge.setChallengeSpecifics(Challenge.getLevel(), true);
        }
        if (GModel.m_nCascades >= 2) {
            GCanvasController.pushSurroundingGemsOut(Math.min(GModel.m_nCascades - 1, 4));
        }
    }

    static void resolveSpecialGems() {
        int n;
        if (GCanvasController.m_lAnimatedLightningsExploded == -1L && (GModel.BOARD[9] & GModel.m_lUnhandledSpecialGems) != 0L) {
            n = Util.findNextSetBit(GModel.BOARD[9] & GModel.m_lUnhandledSpecialGems, 0);
            GModel.resolveLightningGems(1L << n, true);
        }
        GModel.resolveFlameGems(GModel.BOARD[8] & GModel.m_lUnhandledSpecialGems, true);
        if (GCanvasController.m_lAnimatedLightningsExploded == -1L && (GModel.BOARD[16] & GModel.m_lUnhandledSpecialGems) != 0L) {
            n = Util.findNextSetBit(GModel.BOARD[16] & GModel.m_lUnhandledSpecialGems, 0);
            GModel.resolveSuperGems(1L << n);
        }
        if (GCanvasController.m_lAnimatedLightningsExploded == -1L && (GModel.BOARD[12] & GModel.m_lUnhandledSpecialGems) != 0L) {
            if (m_nCurrentState == 14) {
                n = GModel.getGemColour(1L << Util.findNextSetBit(GModel.m_lCurrentFruitExploding, 0));
                long l = GModel.BOARD[12] & GModel.BOARD[n] & GModel.m_lUnhandledSpecialGems & (GModel.m_lCurrentFruitExploding ^ 0xFFFFFFFFFFFFFFFFL);
                if (l != 0L) {
                    GModel.resolveFlameGems(l, true);
                }
            } else if (GModel.m_lCurrentFruitExploding == -1L) {
                GModel.m_lCurrentFruitExploding = 1L << Util.findNextSetBit(GModel.BOARD[12] & GModel.m_lUnhandledSpecialGems, 0);
                GameController.changeState(14);
            }
        }
    }

    static void generateNewGems() {
        GameController.updateExplodingGemStats(GModel.BOARD[21]);
        for (int i = 0; i < 64; ++i) {
            if ((m_nGameMode == 0 || m_nGameMode == 1) && (GModel.BOARD[21] & 1L << i) != 0L && ++GModel.m_nCurrentGemFill >= GModel.m_nLevelCompleteFill) {
                m_bLevelUp = true;
                ++m_nBadGemAmnestyEvents;
                GModel.m_nCurrentGemFill = GModel.m_nLevelCompleteFill;
            }
            for (int j = 0; j < GModel.GEM_BITFIELD_SIZE; ++j) {
                if (j == 21) continue;
                int n = j;
                GModel.BOARD[n] = GModel.BOARD[n] & (GModel.BOARD[21] ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        long l = GModel.BOARD[21];
        GModel.generateBoard(GModel.BOARD, l, false);
        if (l > 0L) {
            boolean bl;
            GameController.spawnBadGems(l, false, false, false);
            boolean bl2 = bl = GModel.m_bCreatePreDoomAtEndOfMove || GModel.m_bCreatePreLockAtEndOfMove || GModel.m_bCreateCountdownAtEndOfMove || GModel.m_bCreateCoalAtEndOfMove;
            if (m_nGameMode == 3 && !bl) {
                GameController.spawnBadGems(l, false, false, true);
            }
        }
        GModel.BOARD[22] = GModel.BOARD[21];
        GModel.BOARD[21] = 0L;
        if (m_nGameMode == 2) {
            Challenge.setChallengeSpecifics(Challenge.getLevel(), true);
        }
    }

    static final void updateExplodingGemStats(long l) {
        int n = Util.bitsSetLong(l);
        m_nGemsDestroyedPerMove += n;
        Challenge.m_nGemsDestroyedThisLevel += n;
        Challenge.m_nGemsDestroyedThisTurn += n;
        int n2 = Util.bitsSetLong(GModel.BOARD[7] & l);
        Challenge.m_nCoalsDestroyedThisLevel += n2;
        Challenge.m_nCoalsDestroyedThisTurn += n2;
    }

    static final void updateExplodingFlameStats(long l) {
        int n = Util.bitsSetLong(l);
        Challenge.m_nFlameDestroyedThisLevel += n;
        Challenge.m_nFlameDestroyedThisTurn += n;
        GModel.m_nFlamesDestroyed += n;
    }

    static final void updateExplodingLightningStats(long l) {
        int n = Util.bitsSetLong(l);
        Challenge.m_nLightningDestroyedThisLevel += n;
        Challenge.m_nLightningDestroyedThisTurn += n;
    }

    static final void updateExplodingCountdownStats(long l) {
        GModel.m_nCountdownsDestroyed += Util.bitsSetLong(l);
    }

    static void queueNextCascadeSound() {
    }

    static void queueChainSound(int[] nArray, int n) {
        n = Math.min(nArray.length - 1, n);
        SoundManager.handleSoundEvent(nArray[n]);
    }

    static int spawnBadGems(long l, boolean bl, boolean bl2, boolean bl3) {
        int n;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7 = bl6 = GModel.m_bCreatePreDoomAtEndOfMove || GModel.m_bCreatePreLockAtEndOfMove || GModel.m_bCreateCountdownAtEndOfMove || GModel.m_bCreateCoalAtEndOfMove;
        if (m_nGameMode == 1 || m_nGameMode == 0 && m_nCurrentLevel <= 0) {
            return -1;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = Util.bitsSetLong(GModel.BOARD[10] | GModel.BOARD[11] | GModel.BOARD[15] | GModel.BOARD[14]);
        boolean bl8 = bl5 = n4 < 15 && GModel.m_nCountdownsDestroyed >= 1;
        if (bl5 && m_nGameMode == 0 && m_nCurrentLevel < 3) {
            bl5 = false;
        }
        boolean bl9 = bl4 = !bl;
        if (bl4 && m_nGameMode == 0 && m_nCurrentLevel < 1) {
            bl4 = false;
        }
        boolean bl10 = !bl && GModel.m_nFlamesDestroyed >= 1;
        boolean bl11 = true;
        int n5 = 90;
        if (m_nGameMode == 0) {
            n = 0;
            if (bl) {
                n = n4 + Util.bitsSetLong(GModel.BOARD[13]);
                n2 = Math.max((m_nCurrentLevel - 2 - n) * 1, 0);
                n2 = Math.min(n2, 50);
            } else {
                n = Util.bitsSetLong(GModel.BOARD[7]) + Util.bitsSetLong(GModel.BOARD[13]) + Util.bitsSetLong(GModel.BOARD[14]);
                n2 = Math.max((m_nCurrentLevel - n) * 10, 0);
            }
            n2 = GModel.getDifficultyMod(n2);
            n3 = Math.max(GModel.m_nMatchesCountSaved - 1, 0) + (GModel.m_nCascades - 1) + m_nBadGemAmnestyEvents;
            if (n3 > 0) {
                n2 /= 2 * n3;
            }
        } else if (m_nGameMode == 3) {
            if (bl) {
                return -1;
            }
            if (bl3) {
                n2 = 20 - Util.bitsSetLong(GModel.BOARD[7]) * 2;
                bl4 = false;
            } else {
                n2 = 20;
            }
            n3 = Math.max(GModel.m_nMatchesCountSaved - 1, 0) + (GModel.m_nCascades - 1) + m_nBadGemAmnestyEvents;
            if (n3 > 0) {
                n2 /= 2 * n3;
            }
            bl5 = false;
        } else if (m_nGameMode == 2) {
            if (Challenge.m_nCoalSpawningChance > 0) {
                if (bl || Util.bitsSetLong(GModel.BOARD[7]) >= 30) {
                    return -1;
                }
                n2 = Challenge.m_nCoalSpawningChance;
                bl4 = false;
                bl5 = false;
                bl11 = false;
            } else if (Challenge.m_nBadGemSpawningChance > 0) {
                if (Challenge.m_nSurvivorLevel > 0) {
                    n5 = 80;
                }
                n2 = Challenge.m_nBadGemSpawningChance;
                bl10 = false;
                n3 = Math.max(GModel.m_nMatchesCountSaved - 1, 0) + (GModel.m_nCascades - 1) + m_nBadGemAmnestyEvents;
                if (n3 > 0) {
                    n2 /= 2 * n3;
                }
                if (bl) {
                    bl5 = true;
                    if (Challenge.m_nSurvivorLevel > 0) {
                        n2 = Challenge.m_nSurvivorLevel * 3;
                    }
                } else if (Util.bitsSetLong(GModel.BOARD[13]) == 0 || Util.bitsSetLong(GModel.BOARD[15]) == 0 && Util.bitsSetLong(GModel.BOARD[14]) == 0) {
                    bl4 = true;
                    bl5 = false;
                    n2 = 100;
                    bl11 = false;
                    m_nBadGemAmnestyEvents = 0;
                } else {
                    if (Util.bitsSetLong(GModel.BOARD[13]) >= 15) {
                        bl4 = false;
                    }
                    boolean bl12 = bl5 = n4 < 15;
                }
            }
        }
        if (m_bLevelUp) {
            return -1;
        }
        if (n2 > 0) {
            n = Util.GetRandom(100, GModel.TWIST_LOGIC_RANDOMER);
            if (n < n2) {
                boolean bl13;
                if (bl6) {
                    return -1;
                }
                boolean bl14 = bl13 = GModel.bSpawnPreDoomGem() && Util.bitsSetLong(l) > 0;
                if (bl13) {
                    if (bl2) {
                        if (GModel.addSpecialGem(GModel.PRELOCK_VALID_MASK, 15, 56, false, true) != -1) {
                            ++GModel.m_nDoomGemsCreatedThisLevel;
                            SoundManager.handleSoundEvent(33);
                        }
                    } else {
                        GModel.m_bCreatePreDoomAtEndOfMove = true;
                    }
                    return 3;
                }
                if (bl5 && bl4) {
                    n = Util.GetRandom(100, GModel.TWIST_LOGIC_RANDOMER);
                    if (n < n5) {
                        bl5 = false;
                    } else {
                        bl4 = false;
                    }
                }
                if (!bl5) {
                    boolean bl15;
                    int n6 = Util.bitsSetLong(GModel.BOARD[7]);
                    int n7 = Util.bitsSetLong(GModel.BOARD[13]);
                    boolean bl16 = bl15 = bl4 && (n7 <= n6 || !bl10) && Util.bitsSetLong(l) > 0;
                    if (bl15 && bl10 && n7 == n6) {
                        boolean bl17 = bl15 = Util.GetRandom(2, GModel.TWIST_LOGIC_RANDOMER) == 0;
                    }
                    if (bl15) {
                        if (bl2) {
                            GModel.addSpecialGem(l, 13, 34, false, true);
                        } else {
                            GModel.m_bCreateCountdownAtEndOfMove = true;
                        }
                        return 2;
                    }
                    if (bl10) {
                        if (bl2) {
                            if (GModel.addSpecialGem(l, 7, -1, false, true) != -1) {
                                return 3;
                            }
                        } else {
                            GModel.m_bCreateCoalAtEndOfMove = true;
                        }
                    }
                } else if (bl5) {
                    if (bl2) {
                        return GModel.addPreLockedGem(GModel.PRELOCK_VALID_MASK);
                    }
                    GModel.m_bCreatePreLockAtEndOfMove = true;
                }
            } else {
                GModel.m_bCreateCoalAtEndOfMove = false;
                GModel.m_bCreateCountdownAtEndOfMove = false;
                GModel.m_bCreatePreLockAtEndOfMove = false;
                GModel.m_bCreatePreDoomAtEndOfMove = false;
            }
        }
        return -1;
    }

    static void updateFrameCounters() {
        if (m_nGameMode == 2) {
            Challenge.updateChallengeTimer();
        }
    }

    static void updateGemsDestroyed() {
        if (m_nGemsDestroyedPerMove > 0 && m_nGemsDestroyedPerMove >= 10) {
            GCanvasController.m_nDisplayNumGemsDestroyed = m_nGemsDestroyedPerMove;
            GCanvasController.m_nGemsDestroyedFrame = 0;
        }
    }

    static void updateLevelbar() {
        if (m_nGameMode == 0 || m_nGameMode == 1) {
            if (GModel.m_nStaggerGemFill >= GModel.m_nLevelCompleteFill) {
                m_bLevelUp = true;
                ++m_nBadGemAmnestyEvents;
                GModel.m_nCurrentGemFill = GModel.m_nStaggerGemFill = GModel.m_nLevelCompleteFill;
            } else if (GModel.m_nCurrentGemFill > 0 && GModel.m_nStaggerGemFill < GModel.m_nCurrentGemFill) {
                ++GModel.m_nStaggerGemFill;
            }
        }
    }

    static void finishedTwisting() {
        GModel.m_bIncrementChain = true;
        GModel.m_nMoveOffset = -1;
        GCanvasController.addDirtyGem(Util.findNextSetBit(GModel.BOARD[17], 0));
        GCanvasController.addDirtyGem(Util.findNextSetBit(GModel.BOARD[18], 0));
        GCanvasController.addDirtyGem(Util.findNextSetBit(GModel.BOARD[19], 0));
        GCanvasController.addDirtyGem(Util.findNextSetBit(GModel.BOARD[20], 0));
        GModel.BOARD[17] = 0L;
        GModel.BOARD[18] = 0L;
        GModel.BOARD[19] = 0L;
        GModel.BOARD[20] = 0L;
        GCanvasController.m_bFinishTransition = true;
        GModel.m_bBadMove = true;
    }

    static final void updateBlitzMode() {
        if (m_bReplaying) {
            GModel.m_nBlitzFrameCounter = m_nBlitzFrameCounterBeforeReplayStarted;
        }
        if (m_nCurrentState != 2 && m_nCurrentState != 8) {
            int n;
            boolean bl = false;
            if (GModel.m_nBlitzFrameCounter % 15 == 0 || m_bReplaying) {
                bl = true;
            }
            if ((GModel.m_nBlitzFrameCounter = Math.max(GModel.m_nBlitzFrameCounter - 1, 0)) % 15 == 0 || m_bReplaying) {
                GModel.m_nHudTimer = Math.max(GModel.m_nBlitzFrameCounter / 15, 0);
            }
            GModel.m_nCurrentGemFill = GModel.m_nStaggerGemFill = GModel.m_nBlitzFrameCounter;
            if (GModel.m_nBlitzFrameCounter == 0 && m_nCurrentState == 3) {
                Hint.flagHint(17);
                GameController.changeLevelUpState(8);
                m_bGameOver = true;
                GameController.changeState(2);
                SoundManager.handleSoundEvent(41);
            } else if (bl && GModel.m_nHudTimer % 60 == 0 && (n = GModel.m_nHudTimer / 60) > 0) {
                int n2 = 149;
                if (n > 1) {
                    n2 = 150;
                }
                HUDController.setHUDText(n2, n, false, false);
                if (n != 5) {
                    Audio.HandleVibration((5 - n) * 100);
                    SoundManager.handleSoundEvent(33);
                }
            }
        }
    }

    static void startReplay() {
        GameController.loadReplayIntoRMS();
        long l = Hint.m_lHintsDisplayed;
        m_nBlitzFrameCounterBeforeReplayStarted = GModel.m_nBlitzFrameCounter;
        GModel.resumeGame(m_nGameMode, true);
        Hint.m_lHintsDisplayed = l;
        m_bReplaying = true;
        HUDController.fadeHudTop(true);
        HUDController.m_nHudReplayFrame = 0;
        HUDController.m_nHudFadeAlpha = 1;
        HUDController.m_nHudFadeAlphaFrame = 0;
    }

    static final void endReplayGraphic() {
        HUDController.m_nHudFadeAlphaFrame = 20;
        HUDController.m_nHudFadeAlpha = 0;
        HUDController.m_nHudReplayFrame = -1;
        HUDController.fadeHudTop(false);
        GCanvasController.addDirtyCursor(m_nCursorX, m_nCursorX);
    }

    static final void endTurnBackToNormal() {
        boolean bl = false;
        boolean bl2 = false;
        int n = GModel.checkForZeroCountGem(13);
        int n2 = GModel.checkForZeroCountGem(14);
        if (!(m_bLevelUp || n2 == -1 && n == -1)) {
            if (n2 != -1) {
                LuckySpinScreen.m_nLuckySpinGem = n2;
                bl = true;
                if (m_nGameMode == 2) {
                    m_bChallengeFailed = true;
                }
            } else if (n != -1) {
                if (m_nGameMode == 0) {
                    GameController.pauseBeforeLuckySpin(n);
                    return;
                }
                bl = true;
                LuckySpinScreen.m_nLuckySpinGem = n;
                if (m_nGameMode == 2) {
                    m_bChallengeFailed = true;
                }
            }
        } else {
            GameController.handleReplayAndEncouragment();
            if (m_nGameMode == 2) {
                bl2 = Challenge.updateChallngeEndTurn();
            }
            Challenge.resetTurnVars();
            int n3 = Math.max(0, GModel.m_nCascades);
            ScoreController.updateAllTimeStats(m_nTurnScoreTotal, m_nGemsDestroyedPerMove, n3, GModel.m_nChainsConsecutive);
            ScoreController.updateGameStats(m_nTurnScoreTotal, m_nGemsDestroyedPerMove, n3, GModel.m_nChainsConsecutive);
            GameController.resetTurnVars();
            if (!m_bLevelUp && m_nGameMode != 2 && m_nGameMode != 3 && (m_bAlwaysAskToReplay || GModel.m_nReplayPoints >= 30)) {
                GameController.saveReplay();
            } else {
                m_bReplaying = false;
            }
            GModel.m_nReplayPoints = 0;
            Hint.showHints(false, false);
            RMS.softSave(m_nGameMode, false, false);
        }
        if (!GModel.m_bBadMove) {
            ++GModel.m_nMatchesMadePerLev;
        }
        if (GModel.m_nMatchesMadePerLev >= 1) {
            Hint.flagHint(9);
        }
        if (GModel.m_nMatchesMadePerLev >= 5) {
            Hint.flagHint(10);
        }
        if (bl) {
            GameController.changeState(8);
        } else if (!bl2) {
            GameController.changeState(3);
        }
    }

    static void doEndLuckySpin() {
        if (GModel.m_nLives == 0) {
            GameController.changeState(8);
        } else if (Util.bitsSetLong(GModel.BOARD[13]) == 1 && GModel.BOARD[14] == 0L) {
            GModel.BOARD[21] = GModel.BOARD[21] | 1L << LuckySpinScreen.m_nLuckySpinGem;
            GCanvasController.setGemAnimation(LuckySpinScreen.m_nLuckySpinGem, 28, 0);
            GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[LuckySpinScreen.m_nLuckySpinGem] = -1;
            GameController.changeState(7);
        } else {
            GCanvasController.setGemAnimation(LuckySpinScreen.m_nLuckySpinGem, 28, 0);
            GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[LuckySpinScreen.m_nLuckySpinGem] = -1;
            GameController.changeState(15);
        }
    }

    static final void endLevelUp() {
        if (m_nGameMode == 0 || m_nGameMode == 1) {
            if (!GModel.m_bLevelUpNewGame) {
                ScoreController.updateRank(m_nCurrentLevel);
                m_nCurrentLevel = Math.min(m_nCurrentLevel + 1, 99);
                m_bAllowSpecialGems = true;
                GModel.setLevelVariables(m_nGameMode, m_nCurrentLevel, false);
            }
            ScoreController.m_nDisplayScore = ScoreController.m_nCurrentScore;
            GModel.m_bLevelUpNewGame = false;
            if (m_nCurrentLevel < 99) {
                HUDController.setHUDText(144, Math.min(m_nCurrentLevel + 1, 99), true, false);
            }
            m_nBadGemAmnestyEvents = 0;
            Util.resetArray(GCanvasController.GEMS_FP_FALL_SPEED, 0);
            Util.resetArray(GCanvasController.GEMS_FP_FALL_OFFSET, 0);
        }
        m_nCursorY = 3;
        m_nCursorX = 3;
        GCanvasController.addDirtyCursor(m_nCursorX, m_nCursorY);
        Background.nextBackground();
        if (m_nGameMode != 2) {
            HUDController.setHudDrawVarsToGameVars();
            HUDController.setHudMultiplierPodAnim(13);
        } else if (m_nGameMode == 2) {
            Challenge.setChallengeSpecifics(Challenge.getLevel(), true);
        }
        GModel.m_StartingNewGameFromOldOne = false;
        RMS.softSave(m_nGameMode, false, false);
    }

    static void initGameOver() {
        GameController.setupGameOverExplosion(LuckySpinScreen.m_nLuckySpinGem);
    }

    static void setupGameOverExplosion(int n) {
        m_bBlitzGameOverViaCountdown = true;
        long l = -1L;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = FP.fpMul(GCanvasController.CASCADE_FP_PUSH, 4096);
        GCanvasController.setGemsBitfieldAnimation(GModel.BOARD[13], 27, 0);
        if ((GModel.BOARD[14] & 1L << n) == 0L) {
            GCanvasController.setGemAnimation(n, 52, 0);
        } else {
            GCanvasController.setGemAnimation(n, 58, 0);
        }
        long l2 = GModel.BOARD_MASK & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
        int n8 = Util.findNextSetBit(l, 0);
        while (n8 != -1) {
            n5 = n / 8;
            n6 = n % 8;
            n3 = n8 / 8;
            n4 = n8 % 8;
            n2 = -(Math.abs(n5 - n3) + Math.abs(n6 - n4));
            if (Math.abs(n6 - n4) < Math.abs(n5 - n3)) {
                if (n3 < n5) {
                    GCanvasController.pushGemOut(n8, 0, -n7, -n7, n2, 0L, false, 0);
                } else {
                    GCanvasController.pushGemOut(n8, 0, n7, n7, n2, 0L, false, 0);
                }
            } else if (n4 < n6) {
                GCanvasController.pushGemOut(n8, -n7, 0, -n7, n2, 0L, false, 0);
            } else {
                GCanvasController.pushGemOut(n8, n7, 0, n7, n2, 0L, false, 0);
            }
            if ((GModel.BOARD[7] & 1L << n8) != 0L) {
                GCanvasController.setGemAnimation(n8, 23, 0);
            }
            GCanvasController.setExplodeGemAnim(n8, -5 + n2 * 3, -1);
            n8 = Util.findNextSetBit(l2, n8 + 1);
        }
    }

    static void updateGameOver() {
        if (m_nBoardStateFrame == 0) {
            GameController.initGameOver();
        }
        if (m_nBoardStateFrame == 0 && (GModel.BOARD[14] & 1L << LuckySpinScreen.m_nLuckySpinGem) != 0L) {
            SoundManager.handleSoundEvent(42);
        } else if (m_nBoardStateFrame == GemAnimation.GEM_NUM_FRAMES[29]) {
            SoundManager.handleSoundEvent(42);
        }
        if (m_nBoardStateFrame >= 60 && GCanvasController.bAllGemExplodeAnimsFinished()) {
            GameController.changeLevelUpState(8);
            m_bGameOver = true;
            GameController.changeState(2);
        }
    }

    static void setGameSoftkeys() {
        GCanvasController.clearSoftkeyAreas(true, true);
        Input.resetCommands();
        Input.addCommand(2);
    }

    static void doEndGameLevelUp() {
        GCanvasController.redrawEverything();
        GameController.changeLevelUpState(8);
        m_bGameOver = true;
        GameController.changeState(2);
    }

    static void saveReplay() {
        int n = RMS.START_OF_SAVE_GAMES_OFFSET + m_nGameMode * RMS.GAME_DATA_NUM_BYTES;
        for (int i = 0; i < RMS.GAME_DATA_NUM_BYTES; ++i) {
            GameController.REPLAY_SAVE_DATA[i] = RMS.SOFT_SAVE_DATA_BUFFER[n + i];
        }
        if (m_bReplaying) {
            GameController.endReplayGraphic();
        }
        m_bReplaying = false;
        m_bReplayExists = true;
        Input.addCommand(3);
        Hint.flagHint(21);
    }

    static void loadReplayIntoRMS() {
        int n = RMS.START_OF_SAVE_GAMES_OFFSET + m_nGameMode * RMS.GAME_DATA_NUM_BYTES;
        for (int i = 0; i < RMS.GAME_DATA_NUM_BYTES; ++i) {
            RMS.SOFT_SAVE_DATA_BUFFER[n + i] = REPLAY_SAVE_DATA[i];
        }
    }

    static void clearReplay() {
        GameController.setGameSoftkeys();
        m_bReplayExists = false;
    }

    static final void pauseBeforeLuckySpin(int n) {
        LuckySpinScreen.m_nLuckySpinGem = n;
        GCanvasController.setGemAnimation(LuckySpinScreen.m_nLuckySpinGem, 35, 0);
        GCanvasController.setCountdownVectorPulse(LuckySpinScreen.m_nLuckySpinGem, 3, false, -1);
        GameController.changeState(9);
    }

    static final void fruitExplodeIncCountdowns() {
        if (m_nCountdownsInc < 10 && m_nBoardStateFrame % 8 == 0) {
            m_nCountdownsInc = Math.min(19, m_nCountdownsInc + 2);
            int n = Util.findNextSetBit(GModel.BOARD[13], 0);
            while (n != -1) {
                if (GModel.GEM_COUNTDOWN_MOVES[n] < 19 && (GModel.BOARD[21] & 1L << n) == 0L) {
                    GModel.GEM_COUNTDOWN_MOVES[n] = Math.min(19, GModel.GEM_COUNTDOWN_MOVES[n] + 2);
                    GCanvasController.setCountdownVectorPulse(n, 1, true, GraphicsUtil.getPingPongPeakFrame("\u0150\u0151\u0153\u0154\u0155".length()));
                    if (m_nCountdownsInc == 10) {
                        GCanvasController.setGemAnimation(n, 34, 0);
                    }
                }
                n = Util.findNextSetBit(GModel.BOARD[13], n + 1);
            }
            n = Util.findNextSetBit(GModel.BOARD[14], 0);
            while (n != -1) {
                if (GModel.GEM_COUNTDOWN_MOVES[n] < 19 && (GModel.BOARD[21] & 1L << n) == 0L) {
                    GModel.GEM_COUNTDOWN_MOVES[n] = Math.min(19, GModel.GEM_COUNTDOWN_MOVES[n] + 2);
                    GCanvasController.setCountdownVectorPulse(n, 0, true, GraphicsUtil.getPingPongPeakFrame("\u0150\u0151\u0153\u0154\u0155".length()));
                }
                n = Util.findNextSetBit(GModel.BOARD[14], n + 1);
            }
        }
    }

    static final void setNewBoardVars() {
        Util.resetArray(GModel.BOARD, 0L);
        GModel.generateBoard(GModel.BOARD, -1L, false);
        if (GModel.m_StartingNewGameFromOldOne) {
            GModel.setLevelVariables(m_nGameMode, Challenge.m_nChallengeStage, true);
        }
        if (m_nGameMode == 0 && m_nCurrentLevel >= 3) {
            GModel.addSpecialGem(GModel.BOARD_MASK, 7, -1, false, true);
            if (Util.GetRandom(100) < 30) {
                GModel.addSpecialGem(GModel.BOARD_MASK, 7, -1, false, true);
            }
        }
        Particles.recycleParticles(true);
        GModel.resetNewBoardSpecialGems(8, GModel.m_nResetGemCountFlame, 31);
        GModel.resetNewBoardSpecialGems(9, GModel.m_nResetGemCountLightning, 24);
        GModel.resetNewBoardSpecialGems(12, GModel.m_nResetGemCountFruit, 26);
        GModel.resetNewBoardSpecialGems(16, GModel.m_nResetGemCountSuper, 32);
        GCanvasController.m_lFruitIdleToSparkle = 0L;
        HUDController.m_nDisplayChainsCurrent = 0;
    }

    static final void handleReplayAndEncouragment() {
        if (m_nGameMode != 2 && (GModel.m_nReplayPoints += Math.max(GModel.m_nCascades - 1, 0) * 5) >= (short)"\u0014(<".charAt(0) && !m_bLevelUp) {
            int n = 0;
            int n2 = 0;
            while (n2 < "\u0014(<".length() && GModel.m_nReplayPoints > (short)"\u0014(<".charAt(n2)) {
                n = n2++;
            }
            n2 = BONUS_TEXT_STRINGS[n].length();
            char c = BONUS_TEXT_STRINGS[n].charAt(0);
            if (n2 > 1) {
                c = BONUS_TEXT_STRINGS[n].charAt(Util.GetRandom(n2));
            }
            HUDController.setHUDText(c, -1, false, true);
        }
    }

    static {
        m_nCurrentState = -1;
        m_nGameMode = -1;
        m_bLevelUp = false;
        m_nIncreaseChain = true;
        m_nGemsDestroyedPerMove = 0;
        m_nTurnScoreTotal = 0;
        m_SaveGameExists = new boolean[4];
        m_GameModeUnlocked = new boolean[4];
        REPLAY_SAVE_DATA = new byte[1024];
        BONUS_TEXT_STRINGS = new String[]{"\u0098", "\u0099", "\u009a"};
        MAX_CHAIN_MULT = "\u0004\b\f\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0010".length();
        MAX_CHAIN_MULT_TEXT = MAX_CHAIN_MULT - 1;
    }
}

