/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class GCanvas
implements GameConstants,
Constants,
ConstantsTFC {
    static boolean m_bGCanvasInit = true;
    static Graphics m_gGraphics;
    static final int TOP_LEFT = 20;
    static final int TOP_RIGHT = 24;
    static final int BOTTOM_LEFT = 36;
    static final int BOTTOM_RIGHT = 40;
    static final int TOP_CENTER = 17;
    static final int LEFT_CENTER = 6;
    static final int RIGHT_CENTER = 10;
    static final int COLOR_BG = 0;
    static final int COLOR_GRID = 0x202020;
    static int BOARD_POSITION_X;
    static int BOARD_POSITION_Y;
    static int SCORE_POSITION_X;
    static int SCORE_POSITION_Y;
    static int GRID_GEM_WIDTHDIFF;
    static int GEM_WIDTH;
    static int GEM_TWIST_SPEED;
    static int GEM_FP_MAX_GEM_FALL_SPEED;
    static int GEM_FALL_GAP;
    static int WORLD_Y2;
    static int WORLD_X2;
    static int WORLD_WIDTH;
    static int WORLD_HEIGHT;
    static int BG_GRID_BLEND_COL;
    static int cursorBGFrame;
    static final String[] CURSOR_SEQUENCES_PULSE;
    static final String[] CURSOR_SEQUENCES_BAD_MOVE;
    static final String[] CURSOR_SEQUENCES_CYCLE;
    static int[] COUNTDOWN_PULSE_COLS;
    static final String[] BOMB_FONT_CLIPS;
    static final String[] ELECTRIC_END_ANIM_SEQUENCES;
    static final String[] ELECTRIC_START_ANIM_SEQUENCES;
    static StringBuffer m_sDisplayStr;
    static int CURSOR_W;
    static int CURSOR_QUAD_W;
    static int cursorBgRotation;

    static void init() {
        BG_GRID_BLEND_COL = Math.abs(0x191900);
        WORLD_HEIGHT = Graphic.m_nHeight;
        WORLD_WIDTH = Graphic.m_nWidth;
        WORLD_Y2 = 0 + WORLD_HEIGHT;
        WORLD_X2 = 0 + WORLD_WIDTH;
        m_sDisplayStr = new StringBuffer(128);
    }

    static void onImagesReload() {
        GEM_WIDTH = Graphic.GetImageWidth(265);
        GEM_TWIST_SPEED = GEM_WIDTH / 3;
        GEM_FP_MAX_GEM_FALL_SPEED = GEM_WIDTH * 2 * 1024;
        GEM_FALL_GAP = GEM_WIDTH / 3;
        HUD.init();
        SCORE_POSITION_X = 125;
        SCORE_POSITION_Y = 10;
        BOARD_POSITION_X = Graphic.m_nXCenter - 176 - 0;
        BOARD_POSITION_Y = Graphic.m_nYCenter - 176 - 14;
        GRID_GEM_WIDTHDIFF = Math.abs(44 - GEM_WIDTH);
        if (GRID_GEM_WIDTHDIFF != 0) {
            GRID_GEM_WIDTHDIFF /= 2;
        }
        int n = 3;
        CURSOR_W = Math.abs((short)"\ufff9\r\u0005\ufffa,\ufffaH\rH-,M\u0005M\ufff9-".charAt(0)) + (short)"\ufff9\r\u0005\ufffa,\ufffaH\rH-,M\u0005M\ufff9-".charAt(n * 2) + Graphic.GetImageWidth(CURSOR_SEQUENCES_PULSE[n].charAt(0));
        CURSOR_QUAD_W = CURSOR_W / 2;
    }

    static void drawGame(Graphics graphics) {
        DirtyRect.clearDirty(graphics);
        if (GameController.m_nCurrentState == 2) {
            GCanvas.drawLevelUpPortrait(graphics);
        } else {
            Background.drawHudBackground(graphics);
            ParticleCanvas.drawParticles(graphics, true, false);
            GCanvas.renderBoard(graphics, BOARD_POSITION_X, BOARD_POSITION_Y, 352, 352);
            GCanvas.drawLightning(graphics);
            HUD.drawHUD(graphics);
            ParticleCanvas.drawParticles(graphics, false, false);
            BoardTexts.drawBoardText(graphics);
        }
    }

    static void drawLevelUpPortrait(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = Math.max(0, GameController.m_nLevelUpStateFrame);
        int n6 = 100;
        if (!GModel.m_bLevelUpNewGame) {
            n6 = GameController.m_nCurrentLevel % 3;
        }
        if ((0x7FL & 1L << GameController.m_nLevelUpState) != 0L) {
            if (GameController.m_nLevelUpState == 4 || GameController.m_nLevelUpState == 3) {
                n4 = 352;
                n3 = 352;
                n2 = n3 / 16 * n5;
                n = BOARD_POSITION_Y + (n3 - n2) / 2;
                if (GameController.m_nLevelUpState == 4) {
                    if (GameController.m_nLevelUpState == 6) {
                        n5 = 15;
                    }
                    int n7 = 16 - n5 - 1;
                    n3 = 352;
                    n2 = n3 / 16 * n7;
                    n = BOARD_POSITION_Y + (352 - n2) / 2;
                }
                Starfield.drawStars(graphics, 0, 100, BOARD_POSITION_X, n, n4, n2, n6);
            } else {
                Starfield.drawStars(graphics, n6);
            }
        }
        if ((0x380L & 1L << GameController.m_nLevelUpState) != 0L) {
            if (GameController.m_nLevelUpState == 7 || GameController.m_nLevelUpState == 8) {
                Background.drawHudBackground(graphics);
            }
            GCanvas.renderBoard(graphics, BOARD_POSITION_X, BOARD_POSITION_Y, 352, 352);
            HUD.drawHUD(graphics);
            ParticleCanvas.drawParticles(graphics, false, false);
            BoardTexts.drawBoardText(graphics);
        } else if (GameController.m_nLevelUpState == 5) {
            HUD.drawHUDZoom(graphics, n5, false);
        } else if (GameController.m_nLevelUpState == 4 || GameController.m_nLevelUpState == 6) {
            if (GameController.m_nLevelUpState == 6) {
                n5 = 15;
            }
            n4 = 16 - n5 - 1;
            n3 = 352;
            n2 = n3 / 16 * n4;
            n = BOARD_POSITION_Y + (352 - n2) / 2;
            GCanvas.renderBoard(graphics, BOARD_POSITION_X, n, 352, n2);
            HUD.drawHUDTop(graphics, HUD.HUD_X, n);
            HUD.drawBoardEdges(graphics, HUD.HUD_X, n, n2);
            HUD.drawHUDBot(graphics, HUD.HUD_X, n + n2);
        } else if (GameController.m_nLevelUpState == 2) {
            HUD.drawHUDZoom(graphics, n5, true);
        } else if (GameController.m_nLevelUpState == 3) {
            n4 = 352;
            n3 = n4 / 16 * n5;
            n2 = BOARD_POSITION_Y + (n4 - n3) / 2;
            GCanvas.renderBoard(graphics, BOARD_POSITION_X, n2, 352, n3);
            HUD.drawHUDTop(graphics, HUD.HUD_X, n2);
            HUD.drawBoardEdges(graphics, HUD.HUD_X, n2, n3);
            HUD.drawHUDBot(graphics, HUD.HUD_X, n2 + n3);
        }
        ParticleCanvas.drawParticles(graphics, false, false);
    }

    static void renderBoard(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        graphics.setClip(n5, n6, n7, n8);
        GCanvas.drawGemRectGroups(graphics, GemAnimation.TILE_SEQUENCES, GemAnimation.TILE_FRAME_WIDTHS, GemAnimation.TILE_FRAME_HEIGHTS, GemAnimation.TILE_NUM_FRAMES, GCanvasController.TILES_CURRENT_FRAME, GemAnimation.TILE_ANIMATION_TYPE, 3, DirtyRect.DIRTY_RECT_GRID_LIST);
        GCanvas.drawFadeTiles(graphics, n, n2, n3, n4);
        if (MainUIController.m_nUIState != 56) {
            GCanvas.drawCountdownVectorPulses(graphics);
        }
        graphics.setClip(n5, n6, n7, n8);
        GCanvas.drawGemRectGroups(graphics, GemAnimation.TILE_SEQUENCES, GemAnimation.TILE_FRAME_WIDTHS, GemAnimation.TILE_FRAME_HEIGHTS, GemAnimation.TILE_NUM_FRAMES, GCanvasController.TILES_CURRENT_FRAME, GemAnimation.TILE_ANIMATION_TYPE, 1, DirtyRect.DIRTY_RECT_GEM_LIST);
        if (GCanvasController.bDrawCursor()) {
            GCanvas.drawCursor(graphics, GameController.m_nCursorX, GameController.m_nCursorY, true);
        }
        graphics.setClip(n5, n6, n7, n8);
        GCanvas.drawGemRectGroups(graphics, GemAnimation.GEM_SEQUENCES, GemAnimation.GEM_FRAME_WIDTHS, GemAnimation.GEM_FRAME_HEIGHTS, GemAnimation.GEM_NUM_FRAMES, GCanvasController.GEMS_CURRENT_FRAME, GemAnimation.GEM_ANIMATION_TYPES, 0, DirtyRect.DIRTY_RECT_GEM_LIST);
        graphics.setClip(n5, n6, n7, n8);
        GCanvas.drawGemRectGroups(graphics, GemAnimation.OVERLAY_SEQUENCES, GemAnimation.OVERLAY_FRAME_WIDTHS, GemAnimation.OVERLAY_FRAME_HEIGHTS, GemAnimation.OVERLAY_NUM_FRAMES, GCanvasController.OVERLAYS_CURRENT_FRAME, GemAnimation.OVERLAY_ANIMATION_TYPE, 2, DirtyRect.DIRTY_RECT_GEM_LIST);
        DirtyRect.cleanRectList();
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
    }

    static void drawGemLayer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, String[] stringArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long[] lArray, int n8) {
        long l = 1L << n;
        int n9 = GCanvasController.getAnimationArrayOffsetState(n);
        long l2 = lArray[n9];
        int n10 = nArray3[n9];
        int n11 = GModel.getGemColour(l);
        if (n9 != -1 && n11 >= 0 && n11 < stringArray[n9].length() && nArray2[n9] != -1) {
            int n12;
            int n13;
            int n14 = Math.max(0, nArray4[n]);
            if ((l2 & 2L) != 0L && n14 >= (n13 = (n12 = n10 * 2 - 2) / 2)) {
                n14 = n12 - n14;
            }
            n12 = nArray2[n9];
            n13 = nArray[n9];
            int n15 = n14 * n13;
            short s = (short)stringArray[n9].charAt(n11);
            if ((l2 & 0x80L) != 0L) {
                n2 -= (n13 - 44) / 2;
                n3 -= (n12 - 44) / 2;
            }
            if (s == -2) {
                graphics.clipRect(n4, n5, n6, n7);
                GCanvas.drawBackgroundGridColour(graphics, n);
            } else if (n14 < nArray3[n9] && s != -1) {
                graphics.clipRect(n2, n3, n13, n12);
                Graphic.DrawImage(graphics, s, n2 - n15, n3, 20);
            }
        }
        if (n8 == 2 && (n == LuckySpinScreen.m_nLuckySpinGem && GameController.m_nCurrentState == 9 || (GModel.getGemProperty(l, 13) || GModel.getGemProperty(l, 14)) && GCanvasController.COUNTDOWN_FONT_FRAME[n] >= 0 && GModel.GEM_COUNTDOWN_MOVES[n] >= 0)) {
            GCanvas.drawCountdownMoves(graphics, n, n2 + 22, n3 + 22, n11);
        }
    }

    static void drawCountdownMoves(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        int n9 = GCanvasController.COUNTDOWN_FONT_FRAME[n];
        if (n9 >= 0) {
            m_sDisplayStr.setLength(0);
            m_sDisplayStr.append(Math.max(GModel.GEM_COUNTDOWN_MOVES[n], 0));
            graphics.setClip(BOARD_POSITION_X, BOARD_POSITION_Y, 352, 352);
            int n10 = "\u0150\u0151\u0153\u0154\u0155".length();
            n9 = GraphicsUtil.getPingPongDrawFrame(n10, n9);
            if (GModel.GEM_COUNTDOWN_MOVES[n] > 5) {
                n9 = Math.min(n9, GraphicsUtil.getPingPongPeakFrame(n10) - 1);
            }
            Text.drawNumberStrip(graphics, m_sDisplayStr, BOMB_FONT_CLIPS[n9], "\u0150\u0151\u0153\u0154\u0155".charAt(n9), false, n2, n3 -= Graphic.GetImageHeight("\u0150\u0151\u0153\u0154\u0155".charAt(n9)) / 2, 1, 0, 2);
        }
        graphics.setClip(n5, n6, n7, n8);
    }

    static void drawCursor(Graphics graphics, int n, int n2, boolean bl) {
        graphics.setClip(BOARD_POSITION_X, BOARD_POSITION_Y, 352, 352);
        int n3 = GCanvasController.m_nCursorFrame;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = BOARD_POSITION_X + n * 44;
        int n6 = BOARD_POSITION_Y + n2 * 44;
        int n7 = "\u013a\u013f\u0143\u0147".length() - 1;
        if (GCanvasController.m_nCursorAnim == 1) {
            n7 = "\u0143\u013f\u013a".length();
            bl2 = true;
        } else if (GCanvasController.m_nCursorAnim == 2) {
            n7 = "\u0147\u00b3\u00af\u00a9".length();
            bl3 = true;
        }
        short s = 0;
        short s2 = 0;
        if (bl) {
            GCanvas.drawCursorBackground(graphics, n5 + 44, n6 + 44);
        }
        for (int i = 0; i < CURSOR_SEQUENCES_PULSE.length; ++i) {
            if (GCanvasController.m_nCursorAnim == 0) {
                n4 = n3 == -1 ? n7 : (n3 >= i && n3 <= i + n7 ? n3 - i : n7);
            } else if (GCanvasController.m_nCursorAnim == 1) {
                n4 = GraphicsUtil.getPingPongDrawFrame(n7, n3);
                bl2 = true;
            } else if (GCanvasController.m_nCursorAnim == 2) {
                n4 = GraphicsUtil.getPingPongDrawFrame(n7, n3);
                bl3 = true;
            }
            s = (short)"\ufff9\r\u0005\ufffa,\ufffaH\rH-,M\u0005M\ufff9-".charAt(i * 2);
            s2 = (short)"\ufff9\r\u0005\ufffa,\ufffaH\rH-,M\u0005M\ufff9-".charAt(i * 2 + 1);
            if (bl2) {
                Graphic.DrawImage(graphics, CURSOR_SEQUENCES_PULSE[i].charAt(n4), n5 + s, n6 + s2, 20);
                continue;
            }
            if (bl3) {
                Graphic.DrawImage(graphics, CURSOR_SEQUENCES_BAD_MOVE[i].charAt(n4), n5 + s, n6 + s2, 20);
                continue;
            }
            Graphic.DrawImage(graphics, CURSOR_SEQUENCES_CYCLE[i].charAt(n4), n5 + s, n6 + s2, 20);
        }
        graphics.setClip(0, WORLD_X2, WORLD_WIDTH, WORLD_HEIGHT);
    }

    static final void drawCursorBackground(Graphics graphics, int n, int n2) {
        Graphic.DrawImage(graphics, 103, n, n2, 3);
        graphics.setClip(BOARD_POSITION_X, BOARD_POSITION_Y, 352, 352);
    }

    static void drawFadeTiles(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        graphics.setClip(n, n2, n3, n4);
        for (int i = 0; i < 64; ++i) {
            n5 = GCanvasController.FADE_TILES[i];
            if (n5 == -1000 || n5 <= -1) continue;
            n10 = i / 8;
            n11 = i % 8;
            n9 = n10 % 2 == 0 && n11 % 2 == 1 || n10 % 2 == 1 && n11 % 2 == 0 ? 0x19191E : 30;
            n6 = n5 * 4;
            if (GameController.m_nCurrentState == 2) {
                n6 *= 2;
            }
            n7 = GraphicsUtil.blendColours(GCanvasController.FADE_TILES[i + 64], n9, n6);
            GCanvasController.getGemPosition(i, true, false);
            int n12 = GCanvasController.m_nGetGemPosX + 5;
            int n13 = GCanvasController.m_nGetGemPosY + 5;
            if (n13 + 44 < n2 || n13 > n2 + n4) continue;
            graphics.setColor(n7);
            graphics.fillRect(n12, n13, 34, 34);
            n6 = Math.max(n6, 10);
            for (int j = 1; j <= 5; ++j) {
                graphics.setColor(GraphicsUtil.blendColours(n7, n9, n6 * j));
                n8 = 34 + 2 * j - 1;
                graphics.drawRect(n12 - j, n13 - j, n8, n8);
            }
        }
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
    }

    static void drawGemRectGroups(Graphics graphics, String[] stringArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long[] lArray, int n, long[] lArray2) {
        int n2 = DirtyRect.m_nDirtyGemIndex;
        int n3 = 0;
        int n4 = graphics.getClipX();
        int n5 = graphics.getClipY();
        int n6 = graphics.getClipWidth();
        int n7 = graphics.getClipHeight();
        graphics.setColor(30);
        while (n2 >= 0) {
            if (lArray2[n3] != 0L) {
                int n8 = DirtyRect.DIRTY_GEM_DATA[n2 + 0];
                int n9 = DirtyRect.DIRTY_GEM_DATA[n2 + 1];
                int n10 = DirtyRect.DIRTY_GEM_DATA[n2 + 2];
                int n11 = DirtyRect.DIRTY_GEM_DATA[n2 + 3];
                int n12 = Util.findNextSetBit(lArray2[n3], 0);
                while (n12 != -1) {
                    graphics.setClip(n4, n5, n6, n7);
                    graphics.clipRect(n8, n9, n10, n11);
                    if (n == 3) {
                        GCanvas.drawBackgroundGridColour(graphics, n12);
                    } else if (n12 != LuckySpinScreen.m_nLuckySpinGem || MainUIController.m_nUIState != 56) {
                        GCanvasController.getGemPosition(n12, false, true);
                        GCanvas.drawGemLayer(graphics, n12, GCanvasController.m_nGetGemPosX, GCanvasController.m_nGetGemPosY, n8, n9, n10, n11, stringArray, nArray, nArray2, nArray3, nArray4, lArray, n);
                    }
                    n12 = Util.findNextSetBit(lArray2[n3], n12 + 1);
                }
            }
            n2 -= 4;
            ++n3;
        }
    }

    static final void drawLightning(Graphics graphics) {
        if (GCanvasController.m_lAnimatedLightningsExploded != -1L) {
            int n = Graphic.GetImageWidth(113) / 3;
            int n2 = GCanvasController.m_nAnimatedLightningFrame++;
            int n3 = 0;
            long l = GCanvasController.m_lAnimatedLightningsExploded;
            long l2 = 0L;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = Util.findNextSetBit(GCanvasController.m_lAnimatedLightningsExploded, 0);
            while (n11 != -1) {
                int n12;
                n6 = n11 % 8;
                n7 = n11 / 8;
                n8 = n7 * 8;
                GCanvasController.getGemPosition(n8, true, false);
                DirtyRect.addDirty(GCanvasController.m_nGetGemPosX, GCanvasController.m_nGetGemPosY, 352, n);
                GCanvasController.getGemPosition(n11, true, false);
                n4 = GCanvasController.m_nGetGemPosX + 44;
                n5 = GCanvasController.m_nGetGemPosY;
                GCanvas.drawLightningMiddleOverlay(graphics, GCanvasController.m_nGetGemPosX, GCanvasController.m_nGetGemPosY, n6, n7);
                if (n6 < 7 && (GCanvasController.m_lSuperLightningRight & 1L << n11) != 0L) {
                    n10 = "\u0136q5".charAt(Util.GetRandom("\u0136q5".length() - 1));
                    n3 = Math.min(8, n6 + 1 + n2);
                    for (n12 = n6 + 1; n12 < n3; ++n12) {
                        l2 = 1L << n7 * 8 + n12;
                        if ((l & l2) == 0L) {
                            n9 = Util.GetRandom(3) * n;
                            graphics.setClip(n4, n5, n, n);
                            Graphic.DrawImage(graphics, n10, n4 - n9, n5, 20);
                            l |= l2;
                        }
                        n4 += 44;
                        n10 = GCanvas.getLightningConnectorImage(n10, ELECTRIC_START_ANIM_SEQUENCES, ELECTRIC_END_ANIM_SEQUENCES);
                    }
                }
                n4 = GCanvasController.m_nGetGemPosX - 44;
                n5 = GCanvasController.m_nGetGemPosY;
                if (n6 > 0 && (GCanvasController.m_lSuperLightningLeft & 1L << n11) != 0L) {
                    n10 = "\u001dq,".charAt(Util.GetRandom("\u001dq,".length() - 1));
                    n3 = Math.max(0, n6 - 1 - (n2 - 1));
                    for (n12 = n6 - 1; n12 >= n3; --n12) {
                        l2 = 1L << n7 * 8 + n12;
                        if ((l & l2) == 0L) {
                            n9 = Util.GetRandom(3) * n;
                            graphics.setClip(n4, n5, n, n);
                            Graphic.DrawImage(graphics, n10, n4 - n9, n5, 20);
                            l |= l2;
                        }
                        n4 -= 44;
                        n10 = GCanvas.getLightningConnectorImage(n10, ELECTRIC_END_ANIM_SEQUENCES, ELECTRIC_START_ANIM_SEQUENCES);
                    }
                }
                n8 = n6;
                GCanvasController.getGemPosition(n8, true, false);
                DirtyRect.addDirty(GCanvasController.m_nGetGemPosX, GCanvasController.m_nGetGemPosY, n, 352);
                GCanvasController.getGemPosition(n11, true, false);
                n4 = GCanvasController.m_nGetGemPosX;
                n5 = GCanvasController.m_nGetGemPosY + 44;
                if (n7 < 7 && (GCanvasController.m_lSuperLightningDown & 1L << n11) != 0L) {
                    n10 = "\u00a7\u01061".charAt(Util.GetRandom("\u00a7\u01061".length() - 1));
                    n3 = Math.min(8, n7 + 1 + n2);
                    for (n12 = n7 + 1; n12 < n3; ++n12) {
                        l2 = 1L << n12 * 8 + n6;
                        if ((l & l2) == 0L) {
                            n9 = Util.GetRandom(3) * n;
                            graphics.setClip(n4, n5, n, n);
                            Graphic.DrawImage(graphics, n10, n4 - n9, n5, 20);
                            l |= l2;
                        }
                        n5 += 44;
                        n10 = GCanvas.getLightningConnectorImage(n10, ELECTRIC_START_ANIM_SEQUENCES, ELECTRIC_END_ANIM_SEQUENCES);
                    }
                }
                n4 = GCanvasController.m_nGetGemPosX;
                n5 = GCanvasController.m_nGetGemPosY - 44;
                if (n7 > 0 && (GCanvasController.m_lSuperLightningUp & 1L << n11) != 0L) {
                    n10 = "\u0110\u0106\u0107".charAt(Util.GetRandom("\u0110\u0106\u0107".length() - 1));
                    n3 = Math.max(0, n7 - 1 - (n2 - 1));
                    for (n12 = n7 - 1; n12 >= n3; --n12) {
                        l2 = 1L << n12 * 8 + n6;
                        if ((l & l2) == 0L) {
                            n9 = Util.GetRandom(3) * n;
                            graphics.setClip(n4, n5, n, n);
                            Graphic.DrawImage(graphics, n10, n4 - n9, n5, 20);
                            l |= l2;
                        }
                        n5 -= 44;
                        n10 = GCanvas.getLightningConnectorImage(n10, ELECTRIC_END_ANIM_SEQUENCES, ELECTRIC_START_ANIM_SEQUENCES);
                    }
                }
                n11 = Util.findNextSetBit(GCanvasController.m_lAnimatedLightningsExploded, n11 + 1);
            }
        }
    }

    static int getLightningConnectorImage(int n, String[] stringArray, String[] stringArray2) {
        int n2 = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            for (int j = 0; j < stringArray2[i].length(); ++j) {
                ++n2;
                if (n != stringArray2[i].charAt(j)) continue;
                int n3 = stringArray[i].length();
                return stringArray[i].charAt(Util.GetRandom(n3));
            }
        }
        return -1;
    }

    static void drawLightningMiddleOverlay(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, 44, 44);
        int n5 = Graphic.GetImageWidth(331) / Graphic.GetImageHeight(331);
        int n6 = GCanvasController.m_nAnimatedLightningFrame % n5;
        int n7 = n6 * Graphic.GetImageHeight(331);
        Graphic.DrawImage(graphics, 331, n - n7, n2, 20);
        if (n3 > 0) {
            Graphic.DrawImage(graphics, 67, n, n2, 20);
        }
        if (n3 < 7) {
            Graphic.DrawImage(graphics, 68, n + 44, n2, 24);
        }
        if (n4 > 0) {
            Graphic.DrawImage(graphics, 57, n, n2, 20);
        }
        if (n4 < 7) {
            Graphic.DrawImage(graphics, 58, n, n2 + 44, 36);
        }
    }

    static final void drawCountdownVectorPulses(Graphics graphics) {
        int n = 11;
        graphics.setClip(BOARD_POSITION_X, BOARD_POSITION_Y, 352, 352);
        for (int i = 0; i < GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES.length; ++i) {
            if (GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[i] < 0) continue;
            int n2 = 29 + 5 * GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[i];
            GCanvasController.getGemPosition(i, false, true);
            int n3 = COUNTDOWN_PULSE_COLS[GCanvasController.VECTOR_COUNTDOWN_PULSE_COL[i]];
            n3 = GraphicsUtil.blendColours(n3, BG_GRID_BLEND_COL, GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[i] * n);
            int n4 = GModel.getGemColour(1L << i);
            int n5 = GCanvasController.m_nGetGemPosX + GEM_WIDTH / 2 - n2 / 2;
            int n6 = GCanvasController.m_nGetGemPosY + GEM_WIDTH / 2 - n2 / 2;
            if (n4 == 5) {
                n6 = GCanvasController.m_nGetGemPosY + GEM_WIDTH / 2 - n2 / 8 - n2 / 2;
                GCanvas.drawGemPulseTriangle(graphics, n5, n6, n2, n3);
                continue;
            }
            if (n4 == 3) {
                n6 = GCanvasController.m_nGetGemPosY + GEM_WIDTH / 2 + n2 / 8 - n2 / 2;
                GCanvas.drawBlueGemPulseTriangle(graphics, n5, n6, n2, n3);
                continue;
            }
            if (n4 == 4) {
                GCanvas.drawGemPulseDiamond(graphics, n5, n6, n2, n3);
                continue;
            }
            GCanvas.drawGemPulseSquare(graphics, n5, n6, n2, n3);
        }
    }

    static void drawGemPulseSquare(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(n4);
        graphics.fillRect(n, n2, n3, n3);
        graphics.setColor(BG_GRID_BLEND_COL);
        graphics.fillRect(n + 5, n2 + 5, n3 - 10, n3 - 10);
    }

    static void drawGemPulseDiamond(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = (n -= 3) + 50 * (n3 += 6) / 100;
        int n6 = (n2 -= 3) + 0 * n3 / 100;
        int n7 = n + 100 * n3 / 100;
        int n8 = n2 + 50 * n3 / 100;
        int n9 = n + 50 * n3 / 100;
        int n10 = n2 + 100 * n3 / 100;
        int n11 = n + 0 * n3 / 100;
        int n12 = n2 + 50 * n3 / 100;
        graphics.setColor(n4);
        graphics.fillTriangle(n5, n6, n7, n8, n11, n12);
        graphics.fillTriangle(n7, n8, n9, n10, n11, n12);
        int n13 = 7;
        graphics.setColor(BG_GRID_BLEND_COL);
        graphics.fillTriangle(n5, n6 += n13, n7 -= n13, n8, n11 += n13, n12);
        graphics.fillTriangle(n7, n8, n9, n10 += -n13, n11, n12);
    }

    static void drawGemPulseTriangle(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = (n -= 3) + 50 * (n3 += 6) / 100;
        int n6 = (n2 -= 3) + 0 * n3 / 100;
        int n7 = n + 100 * n3 / 100;
        int n8 = n2 + 100 * n3 / 100;
        int n9 = n + 0 * n3 / 100;
        int n10 = n2 + 100 * n3 / 100;
        graphics.setColor(n4);
        graphics.fillTriangle(n5, n6, n7, n8, n9, n10);
        int n11 = 7;
        graphics.setColor(BG_GRID_BLEND_COL);
        graphics.fillTriangle(n5, n6 += n11 + 2, n7 -= n11, n8 += -n11 + 2, n9 += n11, n10 += -n11 + 2);
    }

    static void drawBlueGemPulseTriangle(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = (n -= 3) + 0 * (n3 += 6) / 100;
        int n6 = (n2 -= 3) + 0 * n3 / 100;
        int n7 = n + 100 * n3 / 100;
        int n8 = n2 + 0 * n3 / 100;
        int n9 = n + 50 * n3 / 100;
        int n10 = n2 + 100 * n3 / 100;
        graphics.setColor(n4);
        graphics.fillTriangle(n5, n6, n7, n8, n9, n10);
        int n11 = 7;
        graphics.setColor(BG_GRID_BLEND_COL);
        graphics.fillTriangle(n5 += n11, n6 += n11 - 2, n7 -= n11, n8 += n11 - 2, n9, n10 += -n11 - 2);
    }

    static final void drawBackgroundGridColour(Graphics graphics, int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        int n4 = graphics.getColor();
        if (n2 % 2 == 0 && n3 % 2 == 1 || n2 % 2 == 1 && n3 % 2 == 0) {
            graphics.setColor(0x19191E);
        } else {
            graphics.setColor(30);
        }
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        GCanvasController.getGemPosition(n, true, false);
        if ((GCanvasController.m_nGetGemPosX >= n5 && GCanvasController.m_nGetGemPosX <= n5 + n7 || n5 >= GCanvasController.m_nGetGemPosX && n5 <= GCanvasController.m_nGetGemPosX + 44) && (GCanvasController.m_nGetGemPosY >= n6 && GCanvasController.m_nGetGemPosY <= n6 + n8 || n6 >= GCanvasController.m_nGetGemPosY && n6 <= GCanvasController.m_nGetGemPosY + 44)) {
            int n9 = Math.max(GCanvasController.m_nGetGemPosX, n5);
            int n10 = Math.max(GCanvasController.m_nGetGemPosY, n6);
            int n11 = Math.min(GCanvasController.m_nGetGemPosX + 44, n5 + n7) - n9;
            int n12 = Math.min(GCanvasController.m_nGetGemPosY + 44, n6 + n8) - n10;
            graphics.fillRect(n9, n10, n11, n12);
        }
        graphics.setColor(n4);
    }

    static boolean rectIntersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return (n5 >= n && n5 <= n + n3 || n >= n5 && n <= n5 + n7) && (n6 >= n2 && n6 <= n2 + n4 || n2 >= n6 && n2 <= n6 + n8);
    }

    static {
        BOARD_POSITION_X = 0;
        BOARD_POSITION_Y = 0;
        SCORE_POSITION_X = 0;
        SCORE_POSITION_Y = 0;
        cursorBGFrame = 0;
        CURSOR_SEQUENCES_PULSE = new String[]{"\u0143\u013f\u013a", "\u011e\u0119\u0115", "\u011f\u011a\u0116", "\u0144\u0140\u013b", "\u0145\u0141\u013c", "\u0120\u011b\u0117", "\u0121\u011c\u0118", "\u0146\u0142\u013d"};
        CURSOR_SEQUENCES_BAD_MOVE = new String[]{"\u0147\u00b3\u00af\u00a9", "\u0122\u00bf\u00bb\u00b7", "\u0123\u00c0\u00bc\u00b8", "\u0148\u00b4\u00b0\u00aa", "\u0149\u00b6\u00b2\u00ac", "\u0124\u00c2\u00be\u00ba", "\u0125\u00c1\u00bd\u00b9", "\u014a\u00b5\u00b1\u00ab"};
        CURSOR_SEQUENCES_CYCLE = new String[]{"\u013a\u013f\u0143\u0147", "\u0115\u0119\u011e\u0122", "\u0116\u011a\u011f\u0123", "\u013b\u0140\u0144\u0148", "\u013c\u0141\u0145\u0149", "\u0117\u011b\u0120\u0124", "\u0118\u011c\u0121\u0125", "\u013d\u0142\u0146\u014a"};
        COUNTDOWN_PULSE_COLS = new int[]{0xFFFFFF, 65280, 0xFF2020, 822012, 0xFFFF00, 16519932, 16744480};
        BOMB_FONT_CLIPS = new String[]{"\u0000\u0010\u0010\u000e\u001e\u0010.\u000f=\u0010M\u000f\\\u0010l\u000f{\u0010\u008b\u0010", "\u0000\u0010\u0010\u000e\u001e\u0011/\u0010?\u0011P\u000f_\u0011p\u0010\u0080\u0010\u0090\u0010", "\u0000\u0014\u0014\u0011%\u00138\u0013K\u0014_\u0012q\u0014\u0085\u0013\u0098\u0013\u00ab\u0014", "\u0000\u0016\u0016\u0012(\u0015=\u0016S\u0016i\u0015~\u0015\u0093\u0016\u00a9\u0015\u00be\u0015", "\u0000\u001a\u001a\u0014.\u001aH\u0019a\u001a{\u0018\u0093\u001a\u00ad\u0019\u00c6\u001a\u00e0\u0019"};
        ELECTRIC_END_ANIM_SEQUENCES = new String[]{"\u00d5\u0136", "\u001dq,", "5\u013e", "\u001a\u00a7", "\u0110\u0106\u0107", "f1"};
        ELECTRIC_START_ANIM_SEQUENCES = new String[]{"\u001d\u013e", "\u0136q5", "\u00d5,", "\u0110f", "\u00a7\u01061", "\u001a\u0107"};
        cursorBgRotation = 0;
    }
}

