/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class BoardTexts
implements Constants,
GameConstants {
    static int[] m_nTextX = new int[20];
    static int[] m_nTextY = new int[20];
    static int[] m_nTextDrawFrame = new int[20];
    static int[] m_nTextDisplayFrames = new int[20];
    static int[] m_nScoreToDraw = new int[20];
    static int[] m_nMatchIndex = new int[20];
    static int[] m_nTextPingPongMaxFrame = new int[20];
    static int[] m_nTextPulses = new int[20];
    static long[] m_lTextFlags = new long[20];
    static long m_lOnScreenScoreMatches;
    static String[] SCORE_FONT_VECTOR_CLIPS;
    static String[] SCORE_FONT_IMGS;
    static String[] SCORE_FONT_FADE_IMGS;

    static void init() {
    }

    static void resetVars() {
        Util.resetArray(m_nTextX, -1);
        Util.resetArray(m_nTextY, -1);
        Util.resetArray(m_nTextDrawFrame, -1);
        Util.resetArray(m_nTextDisplayFrames, 0);
        Util.resetArray(m_nMatchIndex, -1);
        Util.resetArray(m_nScoreToDraw, 0);
        Util.resetArray(m_nTextPingPongMaxFrame, 0);
        Util.resetArray(m_lTextFlags, 0L);
        Util.resetArray(m_nTextPulses, 0);
        m_lOnScreenScoreMatches = 0L;
    }

    static void updateScoreTexts() {
        int n = -1;
        for (int i = 0; i < m_nTextX.length; ++i) {
            if (m_nTextX[i] == -1) continue;
            int n2 = i;
            m_nTextY[n2] = m_nTextY[n2] - 1;
            int n3 = i;
            m_nTextDisplayFrames[n3] = m_nTextDisplayFrames[n3] - 1;
            if ((m_lTextFlags[i] & 0x80L) != 0L) {
                BoardTexts.m_nTextDrawFrame[i] = m_nTextDisplayFrames[i];
                continue;
            }
            n = (m_nTextPingPongMaxFrame[i] - 2) / 2 + 1;
            if (m_nTextPulses[i] > 0) {
                int n4 = i;
                m_nTextDrawFrame[n4] = m_nTextDrawFrame[n4] + 1;
                if (m_nTextDrawFrame[n4] >= m_nTextPingPongMaxFrame[i]) {
                    BoardTexts.m_nTextDrawFrame[i] = 0;
                }
                if (m_nTextDrawFrame[i] == n) {
                    int n5 = i;
                    m_nTextPulses[n5] = m_nTextPulses[n5] - 1;
                }
            }
            if (m_nTextDisplayFrames[i] >= n) continue;
            BoardTexts.m_nTextDrawFrame[i] = m_nTextDisplayFrames[i];
            int n6 = i;
            m_lTextFlags[n6] = m_lTextFlags[n6] | 0x80L;
        }
    }

    static void addText(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = m_nTextX.length - 1;
        if (n4 != -1) {
            if (n4 >= m_nTextX.length) {
                return;
            }
            n6 = n7 = n4;
        }
        for (int i = n6; i <= n7; ++i) {
            int n8;
            if ((m_nTextX[i] != -1 || n4 != -1) && n4 == -1) continue;
            if (n4 == -1) {
                BoardTexts.m_nTextX[i] = n;
                BoardTexts.m_nTextY[i] = n2;
            }
            if (n5 == -1) {
                n5 = ScoreController.MATCH_SCORE[n3];
            }
            BoardTexts.m_nScoreToDraw[i] = n5;
            n5 /= Math.min(GModel.m_nChainMultiplier + 1, GameController.MAX_CHAIN_MULT_TEXT);
            for (n8 = 0; n8 < "\u00fa\u01f4\u02ee\u03e8".length(); ++n8) {
                if (n5 >= "\u00fa\u01f4\u02ee\u03e8".charAt(n8) && n8 != "\u00fa\u01f4\u02ee\u03e8".length() - 1) continue;
                char c = "\u0002\u0003\u0004\u0005".charAt(n8);
                BoardTexts.m_nTextDrawFrame[i] = c;
                BoardTexts.m_nTextPulses[i] = n8 + 1;
                BoardTexts.m_nTextPingPongMaxFrame[i] = (c + '\u0001') * 2 - 2;
                break;
            }
            BoardTexts.m_nTextDisplayFrames[i] = Math.max((m_nTextPulses[i] + 1) * m_nTextPingPongMaxFrame[i], 15);
            BoardTexts.m_nMatchIndex[i] = n3;
            m_lOnScreenScoreMatches |= 1L << n3;
            if (n3 != -1) {
                n8 = GModel.MATCH_COLOUR[n3];
                BoardTexts.m_lTextFlags[i] = 1L << n8;
            } else {
                BoardTexts.m_lTextFlags[i] = 1L;
            }
            GCanvas.m_sDisplayStr.setLength(0);
            GCanvas.m_sDisplayStr.append(m_nScoreToDraw[i]);
            n8 = Text.getNumberStripW(GCanvas.m_sDisplayStr, SCORE_FONT_VECTOR_CLIPS[m_nTextDrawFrame[i]], false);
            BoardTexts.m_nTextX[i] = Math.max(n8 / 2, m_nTextX[i]);
            BoardTexts.m_nTextX[i] = Math.min(Graphic.m_nWidth - n8 / 2, m_nTextX[i]);
            return;
        }
    }

    static void IncreaseScore(int n) {
        for (int i = 0; i < m_nTextX.length; ++i) {
            if (m_nMatchIndex[i] != n) continue;
            BoardTexts.addText(-1, -1, n, i, -1);
            return;
        }
    }

    static void setupScores(int n) {
        GCanvasController.getGemPosition(Util.findNextSetBit(GModel.MATCHES[n], 0), true, false);
        int n2 = GCanvasController.m_nGetGemPosX;
        int n3 = GCanvasController.m_nGetGemPosY;
        GCanvasController.getGemPosition(Util.findLastSetBit(GModel.MATCHES[n]), true, false);
        int n4 = GCanvasController.m_nGetGemPosX + 44;
        int n5 = GCanvasController.m_nGetGemPosY + 44;
        int n6 = n2 + (n4 - n2) / 2;
        int n7 = n3 + (n5 - n3) / 2;
        BoardTexts.addText(n6, n7, n, -1, -1);
    }

    static void recycleScoreTexts() {
        for (int i = 0; i < m_nTextX.length; ++i) {
            if (m_nTextX[i] == -1 || m_nTextDisplayFrames[i] >= 0 && m_nTextY[i] >= 0) continue;
            m_lOnScreenScoreMatches &= 1L << m_nMatchIndex[i] ^ 0xFFFFFFFFFFFFFFFFL;
            BoardTexts.m_nTextX[i] = -1;
            BoardTexts.m_nMatchIndex[i] = -1;
            BoardTexts.m_lTextFlags[i] = 0L;
        }
    }

    static void drawBoardText(Graphics graphics) {
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
        if (GameController.m_nCurrentState != 2) {
            for (int i = 0; i < m_nTextX.length; ++i) {
                if (m_nTextX[i] == -1 || m_nTextDisplayFrames[i] < 0) continue;
                BoardTexts.drawScorePulse(graphics, m_nScoreToDraw[i], m_nTextX[i], m_nTextY[i], m_nTextDrawFrame[i], m_nTextPingPongMaxFrame[i], m_lTextFlags[i]);
            }
        }
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
    }

    static void drawScorePulse(Graphics graphics, int n, int n2, int n3, int n4, int n5, long l) {
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
        if (n4 >= n5 / 2) {
            n4 = n5 - n4;
        }
        if (n4 < 0) {
            return;
        }
        int n6 = Util.findNextSetBit(l, 0);
        if (n6 < 0 || n6 >= GModel.GEM_COLOUR_COUNT) {
            n6 = 0;
        }
        int n7 = n4;
        GCanvas.m_sDisplayStr.setLength(0);
        GCanvas.m_sDisplayStr.append(n);
        char c = SCORE_FONT_IMGS[n6].charAt(n4);
        if ((l & 0x80L) != 0L && n4 < SCORE_FONT_FADE_IMGS[n6].length()) {
            c = SCORE_FONT_FADE_IMGS[n6].charAt(n4);
            n7 = n4 + 1;
        }
        int n8 = Graphic.GetImageHeight(c);
        Text.drawNumberStrip(graphics, GCanvas.m_sDisplayStr, SCORE_FONT_VECTOR_CLIPS[n7], c, false, n2, n3 -= n8 / 2, 1, 0, 2);
        int n9 = Text.getNumberStripW(GCanvas.m_sDisplayStr, SCORE_FONT_VECTOR_CLIPS[n7], false);
        int n10 = n2 - n9 / 2;
        DirtyRect.addDirty(n10, n3, n9, n8);
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
    }

    static final void removeLinkedMatches() {
        for (int i = 0; i < m_nTextX.length; ++i) {
            if (m_nTextX[i] == -1) continue;
            m_lOnScreenScoreMatches &= 1L << m_nMatchIndex[i] ^ 0xFFFFFFFFFFFFFFFFL;
            BoardTexts.m_nMatchIndex[i] = -1;
        }
    }

    static {
        SCORE_FONT_VECTOR_CLIPS = new String[]{"\u0000\n\n\u0006\u0010\t\u0019\n#\n-\t6\u000bA\tJ\tS\n", "\u0000\u000e\u000e\b\u0016\r#\f/\r<\rI\u000eW\rd\rq\r", "\u0000\u0012\u0012\f\u001e\u00131\u0013D\u0012V\u0012h\u0014|\u0012\u008e\u0013\u00a1\u0013", "\u0000\u001c\u001c\u0010,\u001cH\u001cd\u001c\u0080\u001c\u009c\u001d\u00b9\u001c\u00d5\u001c\u00f1\u001b", "\u0000\"\"\u00135\"W!x\"\u009a#\u00bd\"\u00df \u00ff \u011f\"", "\u0000&&\u0017=&c&\u0089&\u00af'\u00d6'\u00fd%\u0122&\u0148%"};
        SCORE_FONT_IMGS = new String[]{"\u008bjt\u007fU_", "\u008cku\u0080V`", "\u008dlv\u0081Wa", "\u008emw\u0082Xb", "\u008fnx\u0083Yc", "\u0090oy\u0084Zd", "\u0091pz\u0085[e"};
        SCORE_FONT_FADE_IMGS = new String[]{"\u00e3\u00f4\u00ca", "\u00e4\u00f5\u00cb", "\u00e5\u00f6\u00cc", "\u00e6\u00f7\u00cd", "\u00e7\u00f8\u00ce", "\u00e8\u00f9\u00cf", "\u00e9\u00fa\u00d0"};
    }
}

