/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class HUD
implements GameConstants,
Constants {
    static final int HUD_TYPE_LANDSCAPE = 1;
    static final int HUD_TYPE_POTRAIT = 2;
    static final int HUD_TYPE_LOWEND = 3;
    static final int HUD_TYPE = 2;
    static int HUD_X;
    static int HUD_WIDTH;
    static int HUD_FILL_WIDTH;
    static int HUD_MULTIPLIER_POD_LEFT_X;
    static int HUD_MULTIPLIER_CENTRE_Y;
    static Image m_imgLevelFillBG;
    static Image m_imgLevelFill;
    static Image m_imgLevelFillBlitz;

    static final void init() {
        HUD_WIDTH = Graphic.GetImageWidth(268) * 2;
        HUD_X = (GCanvas.WORLD_WIDTH - HUD_WIDTH) / 2;
        HUD_FILL_WIDTH = HUD_WIDTH - 44;
        HUD_MULTIPLIER_POD_LEFT_X = HUD_X + Graphic.GetImageWidth(268) - Graphic.GetImageWidth(197) / 2;
        int n = Graphic.GetImageHeight(334) / 12;
        HUD_MULTIPLIER_CENTRE_Y = GCanvas.BOARD_POSITION_Y + 352 + 46 - n;
    }

    static final void createHUDImages() {
        int n = HUD_FILL_WIDTH;
        m_imgLevelFill = GraphicsUtil.createTiledImage(GCanvas.m_gGraphics, n, Graphic.GetImageHeight(212), 212, true);
        m_imgLevelFillBlitz = GraphicsUtil.createTiledImage(GCanvas.m_gGraphics, n, Graphic.GetImageHeight(37), 37, true);
        m_imgLevelFillBG = GraphicsUtil.createTiledImage(GCanvas.m_gGraphics, n -= Graphic.GetImageWidth(304) * 2, Graphic.GetImageHeight(36), 36, true);
    }

    static final void drawHUD(Graphics graphics) {
        HUD.drawHUDTop(graphics, HUD_X, GCanvas.BOARD_POSITION_Y);
        HUD.drawBoardEdges(graphics, HUD_X, GCanvas.BOARD_POSITION_Y, 352);
        HUD.drawHUDBot(graphics, HUD_X, GCanvas.BOARD_POSITION_Y + 352);
    }

    static final void drawBoardEdges(Graphics graphics, int n, int n2, int n3) {
        if (n3 > 0) {
            int n4;
            int n5 = n;
            int n6 = n2;
            int n7 = Graphic.GetImageHeight(125);
            int n8 = Graphic.GetImageHeight(164);
            int n9 = Graphic.GetImageWidth(164);
            graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
            Graphic.DrawImage(graphics, 125, n, n2, 20);
            int n10 = n3 - 2 * n7;
            int n11 = n10 / n8;
            if (n10 % n8 > 0) {
                ++n11;
            }
            if (n3 > 2 * n7) {
                graphics.setClip(n, n2 += n7, n9, n10);
                for (n4 = 0; n4 < n11; ++n4) {
                    Graphic.DrawImage(graphics, 164, n, n2, 20);
                    n2 += n8;
                }
            }
            graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
            n2 = n6;
            Graphic.DrawImage(graphics, 126, n += Graphic.GetImageWidth(268) + Graphic.GetImageWidth(269) - 0, n2, 24);
            if (n3 > 2 * n7) {
                n2 = n6 + n7;
                graphics.setClip(n - n9, n2, n9, n10);
                for (n4 = 0; n4 < n11; ++n4) {
                    Graphic.DrawImage(graphics, 165, n, n2, 24);
                    n2 += n8;
                }
            }
            graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
            n2 = n6 + n10 + n7;
            n = n5;
            Graphic.DrawImage(graphics, 124, n, n2, 20);
            Graphic.DrawImage(graphics, 123, n += Graphic.GetImageWidth(268) + Graphic.GetImageWidth(269) - 0, n2, 24);
        }
    }

    static final void drawHUDTop(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
        int n9 = n;
        int n10 = n2;
        int n11 = HUDController.m_nHudGlowFrame;
        int n12 = 0;
        Graphic.DrawImage(graphics, 40, n, n2 -= Graphic.GetImageHeight(40), 20);
        Graphic.DrawImage(graphics, 41, n += Graphic.GetImageWidth(40), n2, 20);
        if (n11 >= 0) {
            n2 += 2;
            n = n9 + 7;
            if (n11 >= 3) {
                n11 = 6 - n11;
            }
            n4 = Graphic.GetImageHeight(71) / 4;
            n3 = Graphic.GetImageWidth(71);
            n12 = n11 * n4;
            graphics.setClip(n, n2, n3, n4);
            Graphic.DrawImage(graphics, 71, n, n2 - n12, 20);
            graphics.setClip(n += Graphic.GetImageWidth(40) + (Graphic.GetImageWidth(41) - (n3 + 14)), n2, n3, n4);
            Graphic.DrawImage(graphics, 72, n, n2 - n12, 20);
            n2 -= 2;
            graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
        }
        if (GameController.m_nGameMode == 2) {
            if (GameController.m_nCurrentState != 2) {
                if (MainUIController.m_nUIState != 21 && MainUIController.m_nUIState != 17) {
                    if (Text.m_strMarqueeText.length() > 0) {
                        HUD.drawBonusText(graphics);
                    } else if (Challenge.m_sChallengeReq.length() > 0 && GameController.m_nCurrentState != 12) {
                        HUD.drawChallengeRequirementsStatic(graphics, n9 + Graphic.GetImageWidth(40), HUD.getHUDScrollTextY());
                    }
                }
                if (GModel.m_nHudTimer != -1) {
                    n4 = Challenge.m_nChallengeFrameCounter > 0 ? 1 : 0;
                    n = n9 + 31;
                    HUD.drawLevelNum(graphics, n, n2 + 38, 1, Math.max(GModel.m_nHudTimer, 0), n4 != 0);
                }
            }
        } else if (GameController.m_bReplaying && HUDController.m_nHudTopFading == 10) {
            if (++HUDController.m_nHudReplayFrame % 8 >= 4) {
                HUD.drawFlashText(graphics, null, 13, n9, n10);
            }
        } else if (HUDController.m_nTextAnimFrame != -1 && HUDController.m_sHUDDisplayStr.length() > 0 && HUDController.m_nHudTopFading == 10) {
            HUD.drawFlashText(graphics, HUDController.m_sHUDDisplayStr, -1, n9, n10);
        } else if (Text.m_strMarqueeText.length() > 0 && HUDController.m_nHudTopFading == 10) {
            HUD.drawBonusText(graphics);
        } else if (GameController.m_nCurrentState != 2 || (0x80L & 1L << GameController.m_nLevelUpState) != 0L) {
            HUD.drawHUDScore(graphics, n9 + Graphic.GetImageWidth(40), n2 + 27);
            if (GameController.m_nCurrentState != 2) {
                n4 = GameController.m_nCurrentLevel + 1;
                n3 = 0;
                if (GModel.m_nHudTimer != -1 && !GameController.m_bReplaying) {
                    n4 = GModel.m_nHudTimer;
                    n3 = 1;
                }
                if (GModel.m_nHudTimer == -1 || !GameController.m_bReplaying) {
                    n = n9 + 31;
                    HUD.drawLevelNum(graphics, n, n2 + 38, 1, n4, n3 != 0);
                }
            }
        }
        graphics.setClip(n5, n6, n7, n8);
    }

    static final void drawLevelNum(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        char c = '\u0000';
        char c2 = '\u0000';
        int n10 = Graphic.GetImageHeight(152);
        GCanvas.m_sDisplayStr.setLength(0);
        if (bl) {
            GCanvas.m_sDisplayStr.append(n4 / 60);
            GCanvas.m_sDisplayStr.append(',');
            n5 = n4 % 60;
            if (n5 < 10) {
                GCanvas.m_sDisplayStr.append(0);
            }
            GCanvas.m_sDisplayStr.append(n5);
        } else {
            GCanvas.m_sDisplayStr.append(n4);
        }
        if (!bl && GameController.m_nGameMode != 2) {
            block0: for (n5 = 0; n5 < Text.GAME_STRINGS[147].length(); ++n5) {
                for (int i = 0; i < "LIVN~.".length(); ++i) {
                    if ("LIVN~.".charAt(i) != Text.GAME_STRINGS[147].charAt(n5)) continue;
                    c = "\u0000\u0007\u0007\u0003\n\t\u0013\t\u001c\u000b".charAt(i * 2);
                    c2 = "\u0000\u0007\u0007\u0003\n\t\u0013\t\u001c\u000b".charAt(i * 2 + 1);
                    graphics.setClip(n, n2, (int)c2, n10);
                    Graphic.DrawImage(graphics, 152, n - c, n2, 20);
                    n += c2;
                    continue block0;
                }
            }
            n += 2;
        }
        if (n4 > 99 && (GameController.m_nGameMode == 0 || GameController.m_nGameMode == 1)) {
            c = "\u0000\u0007\u0007\u0003\n\t\u0013\t\u001c\u000b".charAt("\u0000\u0007\u0007\u0003\n\t\u0013\t\u001c\u000b".length() - 2);
            c2 = "\u0000\u0007\u0007\u0003\n\t\u0013\t\u001c\u000b".charAt("\u0000\u0007\u0007\u0003\n\t\u0013\t\u001c\u000b".length() - 1);
            graphics.setClip(n, n2, (int)c2, n10);
            Graphic.DrawImage(graphics, 152, n - c, n2, 20);
            n += c2;
        } else {
            graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
            Text.drawNumberStrip(graphics, GCanvas.m_sDisplayStr, "\u0000\b\b\u0004\f\u0007\u0013\u0007\u001a\b\"\b*\t3\b;\bC\bK\u0004", 276, false, n, n2, 1, 0, n3);
        }
        graphics.setClip(n6, n7, n8, n9);
    }

    static final void drawHUDBot(Graphics graphics, int n, int n2) {
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        int n7 = n;
        int n8 = HUDController.m_nHudGlowFrame;
        int n9 = 0;
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
        HUD.drawLevelProgressMeter(graphics, n7 + 22, n2 + 2);
        Graphic.DrawImage(graphics, 268, n, n2, 20);
        n = n7 + Graphic.GetImageWidth(268);
        Graphic.DrawImage(graphics, 269, n, n2, 20);
        if (n8 >= 0) {
            n2 += 30;
            n = n7 + 12;
            if (n8 >= 3) {
                n8 = 6 - n8;
            }
            int n10 = Graphic.GetImageHeight(307) / 4;
            int n11 = Graphic.GetImageWidth(307);
            n9 = n8 * n10;
            graphics.setClip(n, n2, n11, n10);
            Graphic.DrawImage(graphics, 307, n, n2 - n9, 20);
            graphics.setClip(n += Graphic.GetImageWidth(268) + Graphic.GetImageWidth(269) - (n11 + 24), n2, n11, n10);
            Graphic.DrawImage(graphics, 308, n, n2 - n9, 20);
            n2 -= 30;
            graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
        }
        HUD.drawChainMultiplierText(graphics, n7 + Graphic.GetImageWidth(268), n2 + 46);
        HUD.drawMultiplierPod(graphics, n7 + Graphic.GetImageWidth(268), n2 + 42);
        HUD.drawHudChainLights(graphics, n7, n2);
        graphics.setClip(n3, n4, n5, n6);
    }

    static final void drawHUDZoom(Graphics graphics, int n, boolean bl) {
        if (n < 0) {
            n = 0;
        }
        if (bl) {
            n = "EBA@=<".length() - n - 1;
        }
        char c = "EBA@=<".charAt(n);
        int n2 = Graphic.GetImageWidth(c);
        int n3 = Graphic.GetImageHeight(c);
        int n4 = Graphic.m_nXCenter - n2 / 2;
        int n5 = Graphic.m_nYCenter - n3 / 2;
        graphics.clipRect(n4, n5, n2, n3);
        Graphic.DrawImage(graphics, c, n4, n5, 20);
    }

    static final void drawHUDScore(Graphics graphics, int n, int n2) {
        int n3 = GraphicsUtil.getPingPongDrawFrame(5, HUDController.m_nHudScoreFrame);
        GCanvas.m_sDisplayStr.setLength(0);
        if (ScoreController.m_nDisplayScore < 9999999) {
            graphics.setClip(0, n2, Graphic.m_nWidth, Graphic.GetImageHeight(275) / 5);
            GCanvas.m_sDisplayStr.append((Object)Text.insertNumberCommas(ScoreController.m_nDisplayScore));
            Text.drawNumberStrip(graphics, GCanvas.m_sDisplayStr, "\u0000\u000f\u000f\b\u0017\u000f&\u000e4\u000fC\u000eQ\u000f`\rm\u0010}\u000f\u008c\b", 275, true, n, n2, 5, n3, 2);
        } else {
            n2 = HUD.getHUDScrollTextY();
            graphics.setClip(0, n2, Graphic.m_nWidth, Fonts.getFontHeight(2));
            GCanvas.m_sDisplayStr.append(Text.GAME_STRINGS[148]);
            Text.DrawAlignedText(graphics, GCanvas.m_sDisplayStr, 0, GCanvas.m_sDisplayStr.length(), n, n2, 2, 2, false);
        }
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
    }

    static final void drawLevelProgressMeter(Graphics graphics, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Graphic.DrawImage(graphics, 304, n, n2 + 1, 20);
        Graphic.DrawImage(graphics, m_imgLevelFillBG, n += Graphic.GetImageWidth(304), n2, 20);
        Graphic.DrawImage(graphics, 305, n += m_imgLevelFillBG.getWidth(), n2 + 1, 20);
        n += Graphic.GetImageWidth(305);
        int n5 = 0;
        int n6 = 0;
        if (GModel.m_nStaggerGemFill > 0 && GModel.m_nLevelCompleteFill > 0) {
            n5 = GModel.m_nStaggerGemFill * 100 / GModel.m_nLevelCompleteFill;
            n6 = HUD_FILL_WIDTH * n5 / 100;
        }
        if (GModel.m_nLevelCompleteFill > 0) {
            n6 += 5;
        }
        if (n6 > 0) {
            boolean bl = GameController.m_nGameMode == 3 || GameController.m_nGameMode == 2 && Challenge.m_nChallengeFrameCounter > 0;
            int n7 = m_imgLevelFill.getHeight();
            int n8 = Graphic.GetImageWidth(160);
            int n9 = Graphic.GetImageHeight(160) / 11;
            if (n6 > n8) {
                graphics.setClip(n3, n2, n6 - n8, n7);
                if (bl) {
                    Graphic.DrawImage(graphics, m_imgLevelFillBlitz, n3, n2, 20);
                } else {
                    Graphic.DrawImage(graphics, m_imgLevelFill, n3, n2, 20);
                }
            }
            n = n3 + (n6 - n8);
            graphics.setClip(n3, n2, n6, n7);
            if (bl) {
                Graphic.DrawImage(graphics, 74, n, n2 - n9 * GCanvasController.m_nLevelFillPulseFrame, 20);
            } else {
                Graphic.DrawImage(graphics, 160, n, n2 - n9 * GCanvasController.m_nLevelFillPulseFrame, 20);
            }
        }
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
    }

    static final void drawChainMultiplierText(Graphics graphics, int n, int n2) {
        GCanvas.m_sDisplayStr.setLength(0);
        GCanvas.m_sDisplayStr.append(',').append(Math.min(HUDController.m_nHudDisplayChainMultiplierText + 1, GameController.MAX_CHAIN_MULT_TEXT));
        int n3 = Graphic.GetImageHeight(334) / 6;
        int n4 = Text.getNumberStripW(GCanvas.m_sDisplayStr, "\u0000\u0013\u0013\t\u001c\u0013/\u0013B\u0015W\u0013j\u0013}\u0013\u0090\u0014\u00a4\u0014\u00b8\u000b", true);
        int n5 = HUDController.m_nHudChainMultTextFrame;
        if (HUDController.m_nHudChainMultTextAnimation == 3 || HUDController.m_nHudChainMultTextAnimation == 9 || HUDController.m_nHudChainMultTextAnimation == 15) {
            if (n5 >= 5) {
                n5 = 10 - n5;
            }
        } else if (HUDController.m_nHudChainMultTextAnimation == 2 && n5 <= -2) {
            n5 = Math.abs(-4) - Math.abs(n5);
        }
        if (n5 >= 0) {
            graphics.setClip(n - n4 / 2, n2, n4, n3);
            Text.drawNumberStrip(graphics, GCanvas.m_sDisplayStr, "\u0000\u0013\u0013\t\u001c\u0013/\u0013B\u0015W\u0013j\u0013}\u0013\u0090\u0014\u00a4\u0014\u00b8\u000b", 334, true, n, n2, 6, n5, 2);
        }
    }

    static final void drawBonusText(Graphics graphics) {
        int n;
        graphics.setClip(Text.m_nMarqueeBorderLeft, Text.m_nMarqueeY, Text.m_nMarqueeBorderRight - Text.m_nMarqueeBorderLeft, Fonts.getFontHeight(2));
        if (MainUIController.m_nUIState != 19) {
            Text.DrawMarqeeText(graphics, -1);
        }
        int n2 = Graphic.GetImageWidth(70) / 4;
        int n3 = Graphic.GetImageHeight(70);
        int n4 = Text.m_nMarqueeY + (Fonts.getFontHeight(2) - n3) + 0;
        if (Text.m_nMarqueeX <= Text.m_nMarqueeBorderRight && Text.m_nMarqueeX + Text.m_nMarqueeW >= Text.m_nMarqueeBorderRight) {
            n = Util.GetRandom(4) * n2;
            graphics.setClip(Text.m_nMarqueeBorderRight, n4, n2, n3);
            Graphic.DrawImage(graphics, 70, Text.m_nMarqueeBorderRight - n, n4, 20);
        }
        if (Text.m_nMarqueeX <= Text.m_nMarqueeBorderLeft && Text.m_nMarqueeX + Text.m_nMarqueeW >= Text.m_nMarqueeBorderLeft) {
            n = Util.GetRandom(4) * n2;
            graphics.setClip(Text.m_nMarqueeBorderLeft - n2, n4, n2, n3);
            Graphic.DrawImage(graphics, 70, Text.m_nMarqueeBorderLeft - n2 - n, n4, 20);
        }
    }

    static final void drawFlashText(Graphics graphics, StringBuffer stringBuffer, int n, int n2, int n3) {
        int n4 = 0;
        n4 = n != -1 ? Fonts.stringWidth(Text.GAME_STRINGS[n], 2) : Fonts.stringWidth(stringBuffer, 2);
        graphics.setClip(n2 += Graphic.GetImageWidth(40) - n4 / 2, n3 -= 31, n4, Fonts.getFontHeight(2));
        if (n != -1) {
            Text.DrawAlignedText(graphics, n, n2, n3, 2, 1);
        } else {
            Text.DrawAlignedText(graphics, stringBuffer, 0, stringBuffer.length(), n2, n3, 2, 1);
        }
    }

    static final void drawChallengeRequirementsStatic(Graphics graphics, int n, int n2) {
        graphics.setClip(0, 0, Graphic.m_nDeviceWidth, Graphic.m_nDeviceHeight);
        Text.DrawAlignedText(graphics, Challenge.m_sChallengeReq, 0, Challenge.m_sChallengeReq.length(), n, n2, 2, 2);
    }

    static final void drawMultiplierPod(Graphics graphics, int n, int n2) {
        int n3 = HUDController.m_nHudMultiplierFrame;
        if (HUDController.m_nHudMultiplierAnim == 11) {
            return;
        }
        if (HUDController.m_nHudMultiplierAnim == 12) {
            n3 = 0;
        }
        int n4 = Graphic.GetImageHeight(197) / 5;
        int n5 = n3 * n4;
        int n6 = Graphic.GetImageWidth(197);
        graphics.setClip(n - n6, n2, n6 * 2, n4);
        Graphic.DrawImage(graphics, 197, n, n2 - n5, 24);
        Graphic.DrawImage(graphics, 198, n, n2 - n5, 20);
    }

    static final void drawHudChainLights(Graphics graphics, int n, int n2) {
        int n3;
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
        int n4 = 0;
        HUDController.getHudChainLightPos(0);
        HUDController.m_nNextChainLightX += n - HUD_X;
        HUDController.m_nNextChainLightY += n2 - (GCanvas.BOARD_POSITION_Y + 352);
        char c = "\u0001\u0002\u0003\u0004".charAt(Math.min("\u0001\u0002\u0003\u0004".length() - 1, HUDController.m_nDisplayChainMultiplier));
        char c2 = "\u0001\u0002\u0003\u0002".charAt(Math.min("\u0001\u0002\u0003\u0002".length() - 1, HUDController.m_nDisplayChainMultiplier));
        char c3 = "\u0004\u0002\u0004\u0004".charAt(Math.min("\u0004\u0002\u0004\u0004".length() - 1, HUDController.m_nDisplayChainMultiplier));
        char c4 = '\u0000';
        if (HUDController.m_nHudDisplayChainMultiplierText < GameController.MAX_CHAIN_MULT_TEXT) {
            c4 = "\u0112\u0111'#".charAt(Math.min("\u0112\u0111'#".length() - 1, HUDController.m_nDisplayChainMultiplier));
        } else {
            n3 = GraphicsUtil.getPingPongDrawFrame("\u0096\u0095#\u0094\u0093\u0092".length(), HUDController.m_nHudChainMultTextFrame);
            c4 = "\u0096\u0095#\u0094\u0093\u0092".charAt(n3);
        }
        n3 = Graphic.GetImageWidth(c4);
        for (int i = 0; i < HUDController.m_nDisplayChainsCurrent; ++i) {
            if (i != 0 && i % c == 0) {
                n4 += c3;
            }
            Graphic.DrawImage(graphics, c4, HUDController.m_nNextChainLightX + n4, HUDController.m_nNextChainLightY, 20);
            n4 += n3 + c2;
        }
    }

    static final int getHUDScrollTextY() {
        return GCanvas.BOARD_POSITION_Y - 31;
    }

    static {
        m_imgLevelFillBG = null;
        m_imgLevelFill = null;
        m_imgLevelFillBlitz = null;
    }
}

