/*
 * Decompiled with CFR 0.152.
 */
public class FP {
    public static final int FP_PRECISION = 10;
    public static final int FP_MAX = Integer.MAX_VALUE;
    public static final int FP_ONE = 1024;
    public static final int FP_HALF = 512;
    public static final int FP_DECIMAL_MASK = 1023;
    public static final int FP_INTEGER_MASK = -1024;
    public static final int FP_ONEHUNDRED = 102400;
    public static final int FP_PI = 3216;
    public static final int FP_PI_HALF = 1608;
    public static final int FP_TWO_PI = 6432;
    public static final int FP_PI_DEGREES = 184320;
    public static final int FP_SIN_COS_45 = 724;
    public static final int FP_SIN_15 = 265;
    public static final int FP_COS_15 = 989;
    public static final int FP_SQRT_2 = 1448;
    static final int FP_SINE_TBL_1 = 7;
    static final int FP_SINE_TBL_2 = 170;
    static final int FP_ARCSINE_TBL_1 = -20;
    static final int FP_ARCSINE_TBL_2 = 76;
    static final int FP_ARCSINE_TBL_3 = 217;
    static final int FP_ARCSINE_TBL_4 = 1608;
    static boolean OVERFLOW = false;

    static final int toFP(int n) {
        return n * 1024;
    }

    static final int toIntRound(int n) {
        int n2 = n & 0x3FF;
        if (n > 0) {
            if (n2 >= 512) {
                return (n >> 10) + 1;
            }
            return n >> 10;
        }
        if (n2 > 0) {
            n2 = 1024 - n2;
        }
        if (n2 >= 512) {
            return -(-n >> 10) - 1;
        }
        return -(-n >> 10);
    }

    static final int toInt(int n) {
        if (n >= 0) {
            return n >> 10;
        }
        return -(-n >> 10);
    }

    static final int fpMul(int n, int n2) {
        int n3 = (int)((long)n * (long)n2 >> 10);
        if (Math.abs(n3) > Integer.MAX_VALUE) {
            OVERFLOW = true;
            if (n3 >= 0) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        return n3;
    }

    static final int fpDiv(int n, int n2) {
        OVERFLOW = false;
        long l = ((long)n << 20) / (long)n2 >> 10;
        if (Math.abs(l) > Integer.MAX_VALUE) {
            OVERFLOW = true;
            if (l >= 0L) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    static final int fpSqrt(int n) {
        if (n < 0) {
            n = 1;
        }
        if (n == 0) {
            return 0;
        }
        int n2 = n + 1024 >> 1;
        for (int i = 0; i < 8; ++i) {
            n2 = n2 + FP.fpDiv(n, n2) >> 1;
        }
        return n2;
    }

    static final int fpDistance(int n, int n2, int n3) {
        return FP.fpSqrt(FP.fpMul(n, n) + FP.fpMul(n2, n2) + FP.fpMul(n3, n3));
    }

    static final int fpSin(int n) {
        int n2 = 1;
        if (n < 0) {
            n = -n;
            n2 = -1;
        }
        int n3 = 1;
        if (n > 6432) {
            n %= 6432;
        }
        if (n > 1608 && n <= 3216) {
            n = 3216 - n;
        } else if (n > 3216 && n <= 4824) {
            n -= 3216;
            n3 = -1;
        } else if (n > 4824) {
            n = 6432 - n;
            n3 = -1;
        }
        int n4 = FP.fpMul(n, n);
        int n5 = 7;
        n5 = FP.fpMul(n5, n4);
        n5 -= 170;
        n5 = FP.fpMul(n5, n4);
        n5 += 1024;
        n5 = FP.fpMul(n5, n);
        return n2 * n3 * n5;
    }

    static int fpAsin(int n) {
        int n2 = FP.fpSqrt(1024 - n);
        int n3 = -20;
        n3 = FP.fpMul(n3, n);
        n3 += 76;
        n3 = FP.fpMul(n3, n);
        n3 -= 217;
        n3 = FP.fpMul(n3, n);
        n3 += 1608;
        n3 = 1608 - FP.fpMul(n2, n3);
        return n3;
    }

    static int fpCos(int n) {
        return FP.fpSin(1608 - n);
    }

    static int fpAcos(int n) {
        return 1608 - FP.fpAsin(n);
    }

    static int fpTan(int n) {
        return FP.fpDiv(FP.fpSin(n), FP.fpCos(n));
    }

    static int fpCotan(int n) {
        return FP.fpDiv(FP.fpCos(n), FP.fpSin(n));
    }

    static int fpAtan(int n) {
        int n2 = 0;
        if (n > 1024) {
            n = FP.fpDiv(1024, n);
            n2 = 1;
        } else if (n < -1024) {
            n = FP.fpDiv(1024, n);
            n2 = 2;
        }
        int n3 = FP.fpAsin(FP.fpDiv(n, FP.fpSqrt(1024 + FP.fpMul(n, n))));
        if (n2 == 1) {
            n3 = 1608 - n3;
        } else if (n2 == 2) {
            n3 = -1608 - n3;
        }
        return n3;
    }

    static int fpAtan2(int n, int n2) {
        if (n2 == 0) {
            if (n >= 0) {
                return 1608;
            }
            return -1608;
        }
        int n3 = 1;
        if (n < 0) {
            n3 = -1;
            n = -n;
        }
        int n4 = Math.abs(FP.fpAtan(FP.fpDiv(n, n2)));
        if (n2 > 0) {
            return n3 * n4;
        }
        return n3 * (3216 - n4);
    }

    static int fpAcotan(int n) {
        n = 1 / n;
        return FP.fpAtan(n);
    }

    static int getDecimal(int n) {
        if (n >= 0) {
            return n & 0x3FF;
        }
        return -(-n & 0x3FF);
    }
}

