/*
 * Decompiled with CFR 0.152.
 */
public class Challenge
implements Constants,
GameConstants {
    static int[] m_nChallengeModeCurrentStage = new int[13];
    static int m_nChallengeStage;
    static StringBuffer m_sChallengeReq;
    static int m_nSurvivorLevel;
    static int m_nMatchesInARow;
    static boolean m_bFoundColouredMatch;
    static int m_nMatchColour;
    static int m_nMatchBiggestLength;
    static int m_nChallengeFrameCounter;
    static boolean m_bTimed;
    static int m_nCoalsDestroyedThisTurn;
    static int m_nCoalsDestroyedThisLevel;
    static int m_nFlameDestroyedThisTurn;
    static int m_nFlameDestroyedThisLevel;
    static int m_nLightningDestroyedThisTurn;
    static int m_nLightningDestroyedThisLevel;
    static int m_nGemsDestroyedThisTurn;
    static int m_nGemsDestroyedThisLevel;
    static int m_nLightningCreatedThisTurn;
    static int m_nFlameCreatedThisTurn;
    static int m_nCoalSpawningChance;
    static int m_nBadGemSpawningChance;
    static int m_nMovesTotal;

    static final void init() {
        Util.resetArray(m_nChallengeModeCurrentStage, -1);
        Challenge.m_nChallengeModeCurrentStage[0] = 0;
    }

    static void resetVars() {
        m_nMatchesInARow = 0;
        m_nMatchColour = -1;
        m_nChallengeFrameCounter = 0;
        m_bTimed = false;
        m_nCoalsDestroyedThisLevel = 0;
        m_nFlameDestroyedThisLevel = 0;
        m_nLightningDestroyedThisLevel = 0;
        m_nGemsDestroyedThisLevel = 0;
        m_nFlameCreatedThisTurn = 0;
        m_nBadGemSpawningChance = 0;
        m_nCoalSpawningChance = 0;
        m_nSurvivorLevel = 0;
        m_nMovesTotal = 0;
        Challenge.resetTurnVars();
    }

    static void resetTurnVars() {
        m_nCoalsDestroyedThisTurn = 0;
        m_nFlameDestroyedThisTurn = 0;
        m_nLightningDestroyedThisTurn = 0;
        m_nGemsDestroyedThisTurn = 0;
        m_nLightningCreatedThisTurn = 0;
        m_nFlameCreatedThisTurn = 0;
        m_nMatchBiggestLength = 0;
        m_bFoundColouredMatch = false;
    }

    static final int getChallengeStringOffset(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += "\u0002\u0000\u0001\u0003\u0000\u0001\u0002\u0002\u0000\u0001\u0003\u0000\u0001\u0002\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0003\u0000\n\u000b\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0001\f\u0001\f\u0001\f\u0002\f\r\u0002\f\r\u0002\f\r\u0002\f\r\u0001\u000e\u0004\u0000\u0001\u000f\u0002\u0001\u000e\u0004\u0000\u0001\u0002\u000f\u0004\u0000\u0001\u0002\u000f\u0001\u000e\u0004\u0000\u0001\u0002\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0002\u0013\u0011\u0001\u0014\u0002\u0011\u0012\u0003\u0010\u0011\u0012\u0002\u0015\r\u0002\u0015\r\u0003\u0000\u0015\r\u0002\u0015\r\u0003\u0000\u0015\r\u0002\u0015\r\u0002\u0015\r\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0015\u0002\u0000\u0016\u0003\u0000\u0015\u0016\u0002\u0000\u0015\u0002\u0000\u0016\u0003\u0000\u0015\u0016\u0003\u0000\u0015\u0016\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0002\u0016\r\u0002\u0016\r\u0003\u0000\u0016\r\u0002\u0016\r\u0003\u0000\u0016\r\u0002\u0016\r\u0002\u0016\r\u0002\u0000\u001a\u0003\u0000\u001a\u001b\u0002\u0000\u001b\u0002\u0000\u001a\u0003\u0000\u001a\u001b\u0001\u001c\u0001\u001c".charAt(n2) + '\u0001';
        }
        return n2 + 1;
    }

    static final int getNumChallengeConditions(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += "\u0002\u0000\u0001\u0003\u0000\u0001\u0002\u0002\u0000\u0001\u0003\u0000\u0001\u0002\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0003\u0000\n\u000b\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0001\f\u0001\f\u0001\f\u0002\f\r\u0002\f\r\u0002\f\r\u0002\f\r\u0001\u000e\u0004\u0000\u0001\u000f\u0002\u0001\u000e\u0004\u0000\u0001\u0002\u000f\u0004\u0000\u0001\u0002\u000f\u0001\u000e\u0004\u0000\u0001\u0002\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0002\u0013\u0011\u0001\u0014\u0002\u0011\u0012\u0003\u0010\u0011\u0012\u0002\u0015\r\u0002\u0015\r\u0003\u0000\u0015\r\u0002\u0015\r\u0003\u0000\u0015\r\u0002\u0015\r\u0002\u0015\r\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0015\u0002\u0000\u0016\u0003\u0000\u0015\u0016\u0002\u0000\u0015\u0002\u0000\u0016\u0003\u0000\u0015\u0016\u0003\u0000\u0015\u0016\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0002\u0016\r\u0002\u0016\r\u0003\u0000\u0016\r\u0002\u0016\r\u0003\u0000\u0016\r\u0002\u0016\r\u0002\u0016\r\u0002\u0000\u001a\u0003\u0000\u001a\u001b\u0002\u0000\u001b\u0002\u0000\u001a\u0003\u0000\u001a\u001b\u0001\u001c\u0001\u001c".charAt(n2) + '\u0001';
        }
        return "\u0002\u0000\u0001\u0003\u0000\u0001\u0002\u0002\u0000\u0001\u0003\u0000\u0001\u0002\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0003\u0000\n\u000b\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0001\f\u0001\f\u0001\f\u0002\f\r\u0002\f\r\u0002\f\r\u0002\f\r\u0001\u000e\u0004\u0000\u0001\u000f\u0002\u0001\u000e\u0004\u0000\u0001\u0002\u000f\u0004\u0000\u0001\u0002\u000f\u0001\u000e\u0004\u0000\u0001\u0002\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0002\u0013\u0011\u0001\u0014\u0002\u0011\u0012\u0003\u0010\u0011\u0012\u0002\u0015\r\u0002\u0015\r\u0003\u0000\u0015\r\u0002\u0015\r\u0003\u0000\u0015\r\u0002\u0015\r\u0002\u0015\r\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0015\u0002\u0000\u0016\u0003\u0000\u0015\u0016\u0002\u0000\u0015\u0002\u0000\u0016\u0003\u0000\u0015\u0016\u0003\u0000\u0015\u0016\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0002\u0016\r\u0002\u0016\r\u0003\u0000\u0016\r\u0002\u0016\r\u0003\u0000\u0016\r\u0002\u0016\r\u0002\u0016\r\u0002\u0000\u001a\u0003\u0000\u001a\u001b\u0002\u0000\u001b\u0002\u0000\u001a\u0003\u0000\u001a\u001b\u0001\u001c\u0001\u001c".charAt(n2);
    }

    static final int getConditionTypeAtOffset(int n, int n2) {
        return "\u0002\u0000\u0001\u0003\u0000\u0001\u0002\u0002\u0000\u0001\u0003\u0000\u0001\u0002\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0003\u0000\n\u000b\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0003\u0000\n\u000b\u0004\u0000\n\u000b\u0002\u0001\f\u0001\f\u0001\f\u0002\f\r\u0002\f\r\u0002\f\r\u0002\f\r\u0001\u000e\u0004\u0000\u0001\u000f\u0002\u0001\u000e\u0004\u0000\u0001\u0002\u000f\u0004\u0000\u0001\u0002\u000f\u0001\u000e\u0004\u0000\u0001\u0002\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0002\u0013\u0011\u0001\u0014\u0002\u0011\u0012\u0003\u0010\u0011\u0012\u0002\u0015\r\u0002\u0015\r\u0003\u0000\u0015\r\u0002\u0015\r\u0003\u0000\u0015\r\u0002\u0015\r\u0002\u0015\r\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0001\u0002\u0000\u0015\u0002\u0000\u0016\u0003\u0000\u0015\u0016\u0002\u0000\u0015\u0002\u0000\u0016\u0003\u0000\u0015\u0016\u0003\u0000\u0015\u0016\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0002\u0001\r\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0003\u0017\u0018\u0019\u0002\u0016\r\u0002\u0016\r\u0003\u0000\u0016\r\u0002\u0016\r\u0003\u0000\u0016\r\u0002\u0016\r\u0002\u0016\r\u0002\u0000\u001a\u0003\u0000\u001a\u001b\u0002\u0000\u001b\u0002\u0000\u001a\u0003\u0000\u001a\u001b\u0001\u001c\u0001\u001c".charAt(n + n2);
    }

    static final int getConditionValAtOffset(int n, int n2) {
        return "\u0002\u0001\b\u0003\u0001\f\u0000\u0002\u0001\u000f\u0003\u0001\u0012\u0000\u0002\u0001\u0019\u0002\u0001#\u0002\u0001@\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0003\u0001\u00032\u0003\u0001\u00062\u0004\u0001\b2\u0000\u0003\u0001\f2\u0004\u0001\u000f2\u0000\u0003\u0001\u00122\u0004\u0001\u00142\u0000\u0001\u000f\u0001\u0019\u0001(\u00022\u0005\u0002A\u0005\u0002K\u0005\u0002Z\u0005\u0001\u0003\u0004\u0001\u000f\u0000\u0000\u0001\u0004\u0004\u0001\u0014\u0000\u0000\u0004\u0001\u0019\u0000\u0000\u0001\u0005\u0004\u0001\u001e\u0000\u0000\u0001\u000f\u0001\u0014\u0001\u0019\u0002\u000f\u000f\u0001\u001e\u0002\u0014\u0014\u0003\u000f\u000f\u000f\u0002\u0005\u0005\u0002\n\u0005\u0003\u0001\b\u0005\u0002\u000f\u0005\u0003\u0001\n\u0005\u0002\u0014\u0005\u0002\u0019\u0005\u0002\u0014F\u0002\u0014Z\u0002\u0019n\u0002\u001e\u008c\u0002#\u00aa\u0002(\u00c8\u00022\u012c\u0002\u0001\u0005\u0002\u0001\u0005\u0003\u0001\u0004\u0004\u0002\u0001\n\u0002\u0001\n\u0003\u0001\u0007\u0007\u0003\u0001\n\n\u0002\u00c8\u0005\u0002\u00fa\u0005\u0002\u015e\u0005\u0002\u01c2\u0005\u0002\u0226\u0005\u0002\u0258\u0005\u0002\u028a\u0005\u0003\u001ed\u0001\u0003-d\u0002\u0003<d\u0003\u0003Pd\u0004\u0003dd\u0005\u0003}d\u0006\u0003\u0096d\u0007\u0002\u0005\u0005\u0002\b\u0005\u0003\u0001\u0006\u0005\u0002\f\u0005\u0003\u0001\n\u0005\u0002\u000f\u0005\u0002\u0012\u0005\u0002\u0001\u0002\u0003\u0001\u0001\u0001\u0002\u0001\u0002\u0002\u0001\u0003\u0003\u0001\u0002\u0001\u0001\u0006\u0001\b".charAt(n + n2);
    }

    static final boolean isChallengeComplete(int n) {
        int n2 = Challenge.getChallengeStringOffset(n);
        int n3 = Challenge.getNumChallengeConditions(n);
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < n3; ++i) {
            n4 = Challenge.getConditionTypeAtOffset(n2, i);
            n5 = Challenge.getConditionValAtOffset(n2, i);
            if (n4 == 0) {
                if (n5 == 1) {
                    bl2 = true;
                    bl = true;
                } else if (GModel.m_nMovesMadePerLev <= n5) {
                    bl = true;
                    if (GModel.m_nMovesMadePerLev == n5) {
                        bl3 = true;
                    }
                } else {
                    GameController.m_bGameOver = true;
                    bl = false;
                }
            } else if (n4 == 8 || n4 == 6 || n4 == 3 || n4 == 7 || n4 == 5 || n4 == 9 || n4 == 4) {
                bl = m_nMatchesInARow >= n5;
            } else if (n4 == 1) {
                bl = bl2 ? m_nGemsDestroyedThisTurn >= n5 : m_nGemsDestroyedThisLevel >= n5;
            } else if (n4 == 10) {
                bl = bl2 ? m_nCoalsDestroyedThisTurn >= n5 : m_nCoalsDestroyedThisLevel >= n5;
            } else if (n4 == 16) {
                bl = Util.bitsSetLong(GModel.BOARD[1]) >= n5;
            } else {
                if (n4 == 17) {
                    if (Util.bitsSetLong(GModel.BOARD[2]) >= n5) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (n4 == 18) {
                    if (Util.bitsSetLong(GModel.BOARD[3]) >= n5) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (n4 == 20) {
                    bl = Util.bitsSetLong(GModel.BOARD[4]) >= n5;
                } else if (n4 == 19) {
                    bl = Util.bitsSetLong(GModel.BOARD[0]) >= n5;
                } else if (n4 == 21) {
                    bl = bl2 ? m_nFlameDestroyedThisTurn >= n5 : m_nFlameDestroyedThisLevel >= n5;
                } else if (n4 == 22) {
                    bl = bl2 ? m_nLightningDestroyedThisTurn >= n5 : m_nLightningDestroyedThisLevel >= n5;
                } else if (n4 == 13) {
                    bl = true;
                } else if (n4 == 12) {
                    bl = GModel.m_nChainsConsecutive >= n5;
                } else if (n4 == 14) {
                    int n6 = GModel.m_nCascades - 1;
                    if (GModel.m_nMatchesCountSaved > 0) {
                        ++n6;
                    }
                    bl = n6 >= n5;
                } else if (n4 == 23) {
                    bl = GModel.m_nMovesMadePerLev >= n5;
                } else if (n4 == 28) {
                    bl = m_nMatchBiggestLength >= n5;
                } else if (n4 == 26) {
                    if (bl2) {
                        bl = m_nFlameCreatedThisTurn >= n5;
                    }
                } else if (n4 == 27) {
                    if (bl2) {
                        bl = m_nLightningCreatedThisTurn >= n5;
                    }
                } else if (n4 == 2) {
                    bl = m_nLightningDestroyedThisTurn <= 0;
                } else if (n4 == 15) {
                    bl = m_nFlameDestroyedThisTurn <= 0;
                }
            }
            if (!bl) break;
        }
        if (bl3 && !bl) {
            GameController.m_bGameOver = true;
        }
        return bl;
    }

    static final void updateChallengeTimer() {
        if (GameController.m_nCurrentState != 2) {
            if (m_nChallengeFrameCounter > 0) {
                GModel.m_nCurrentGemFill = GModel.m_nStaggerGemFill = (m_nChallengeFrameCounter = Math.max(m_nChallengeFrameCounter - 1, 0));
                if (m_nChallengeFrameCounter % 15 == 0) {
                    GModel.m_nHudTimer = Math.max(m_nChallengeFrameCounter / 15, 0);
                }
                if (m_nChallengeFrameCounter == 0) {
                    GameController.m_bGameOver = true;
                }
            }
            if (GModel.m_nStaggerGemFill < GModel.m_nCurrentGemFill) {
                ++GModel.m_nStaggerGemFill;
            } else if (GModel.m_nStaggerGemFill > GModel.m_nCurrentGemFill) {
                --GModel.m_nStaggerGemFill;
            }
            if (m_bTimed && m_nChallengeFrameCounter == 0 && GameController.m_nCurrentState == 3) {
                if (Challenge.isChallengeComplete(Challenge.getLevel())) {
                    GameController.changeState(12);
                } else if (GameController.m_bGameOver) {
                    Challenge.doChallengeFail();
                }
            }
        }
    }

    static final int getLevel() {
        return m_nChallengeStage * 7 + m_nChallengeModeCurrentStage[m_nChallengeStage];
    }

    static final int setChallengeSpecifics(int n, boolean bl) {
        if (!bl) {
            m_sChallengeReq.setLength(0);
            m_nChallengeFrameCounter = 0;
            m_bTimed = false;
        }
        int n2 = Challenge.getChallengeStringOffset(n);
        int n3 = Challenge.getNumChallengeConditions(n);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n7 = 0;
        for (int i = 0; i < n3; ++i) {
            int n8;
            if (i >= 1 && !bl) {
                m_sChallengeReq.append(' ');
            }
            n4 = Challenge.getConditionTypeAtOffset(n2, i);
            n5 = Challenge.getConditionValAtOffset(n2, i);
            n6 = bl3 ? i : i + 1;
            if (n4 == 0) {
                if (n5 == 1) {
                    bl2 = true;
                }
                n7 = n5;
                if (bl && n5 > 1) {
                    GModel.m_nHudTimer = n5 - GModel.m_nMovesMadePerLev;
                }
                bl3 = true;
                continue;
            }
            if (n4 == 13) {
                if (bl) continue;
                m_nChallengeFrameCounter = 900 * n5;
                m_bTimed = true;
                continue;
            }
            if (n4 == 8) {
                if (bl) {
                    Challenge.updateChallengeVal(m_nMatchesInARow, n6);
                    continue;
                }
                m_nMatchColour = 0;
                Challenge.parseChallengeReqText(300, 2, 0, n5);
                continue;
            }
            if (n4 == 6) {
                if (bl) {
                    Challenge.updateChallengeVal(m_nMatchesInARow, n6);
                    continue;
                }
                m_nMatchColour = 1;
                Challenge.parseChallengeReqText(301, 2, 0, n5);
                continue;
            }
            if (n4 == 3) {
                if (bl) {
                    Challenge.updateChallengeVal(m_nMatchesInARow, n6);
                    continue;
                }
                m_nMatchColour = 2;
                Challenge.parseChallengeReqText(302, 2, 0, n5);
                continue;
            }
            if (n4 == 7) {
                if (bl) {
                    Challenge.updateChallengeVal(m_nMatchesInARow, n6);
                    continue;
                }
                m_nMatchColour = 3;
                Challenge.parseChallengeReqText(303, 2, 0, n5);
                continue;
            }
            if (n4 == 5) {
                if (bl) {
                    Challenge.updateChallengeVal(m_nMatchesInARow, n6);
                    continue;
                }
                m_nMatchColour = 4;
                Challenge.parseChallengeReqText(304, 2, 0, n5);
                continue;
            }
            if (n4 == 9) {
                if (bl) {
                    Challenge.updateChallengeVal(m_nMatchesInARow, n6);
                    continue;
                }
                m_nMatchColour = 5;
                Challenge.parseChallengeReqText(305, 2, 0, n5);
                continue;
            }
            if (n4 == 4) {
                if (bl) {
                    Challenge.updateChallengeVal(m_nMatchesInARow, n6);
                    continue;
                }
                m_nMatchColour = 6;
                Challenge.parseChallengeReqText(306, 2, 0, n5);
                continue;
            }
            if (n4 == 1) {
                if (bl) {
                    if (bl2) {
                        Challenge.updateChallengeVal(m_nGemsDestroyedThisTurn, n6);
                        continue;
                    }
                    Challenge.updateChallengeVal(m_nGemsDestroyedThisLevel, n6);
                    continue;
                }
                Challenge.parseChallengeReqText(307, 2, 0, n5);
                continue;
            }
            if (n4 == 10) {
                if (bl) {
                    if (bl2) {
                        Challenge.updateChallengeVal(m_nCoalsDestroyedThisTurn, n6);
                        continue;
                    }
                    Challenge.updateChallengeVal(m_nCoalsDestroyedThisLevel, n6);
                    continue;
                }
                Challenge.parseChallengeReqText(308, 2, 0, n5);
                continue;
            }
            if (n4 == 16) {
                if (bl) {
                    Challenge.updateChallengeVal(Util.bitsSetLong(GModel.BOARD[1]), n6);
                    continue;
                }
                Challenge.checkPreserverConditions(1, n5);
                Challenge.parseChallengeReqText(310, 2, 0, n5);
                continue;
            }
            if (n4 == 17) {
                if (bl) {
                    Challenge.updateChallengeVal(Util.bitsSetLong(GModel.BOARD[2]), n6);
                    continue;
                }
                Challenge.checkPreserverConditions(2, n5);
                Challenge.parseChallengeReqText(311, 2, 0, n5);
                continue;
            }
            if (n4 == 18) {
                if (bl) {
                    Challenge.updateChallengeVal(Util.bitsSetLong(GModel.BOARD[3]), n6);
                    continue;
                }
                Challenge.checkPreserverConditions(3, n5);
                Challenge.parseChallengeReqText(312, 2, 0, n5);
                continue;
            }
            if (n4 == 20) {
                if (bl) {
                    Challenge.updateChallengeVal(Util.bitsSetLong(GModel.BOARD[4]), n6);
                    continue;
                }
                Challenge.checkPreserverConditions(4, n5);
                Challenge.parseChallengeReqText(313, 2, 0, n5);
                continue;
            }
            if (n4 == 19) {
                if (bl) {
                    Challenge.updateChallengeVal(Util.bitsSetLong(GModel.BOARD[0]), n6);
                    continue;
                }
                Challenge.checkPreserverConditions(0, n5);
                Challenge.parseChallengeReqText(309, 2, 0, n5);
                continue;
            }
            if (n4 == 21) {
                if (bl) {
                    if (bl2) {
                        Challenge.updateChallengeVal(m_nFlameDestroyedThisTurn, n6);
                        continue;
                    }
                    Challenge.updateChallengeVal(m_nFlameDestroyedThisLevel, n6);
                    continue;
                }
                Challenge.parseChallengeReqText(314, 2, 0, n5);
                continue;
            }
            if (n4 == 22) {
                if (bl) {
                    if (bl2) {
                        Challenge.updateChallengeVal(m_nLightningDestroyedThisTurn, n6);
                        continue;
                    }
                    Challenge.updateChallengeVal(m_nLightningDestroyedThisLevel, n6);
                    continue;
                }
                Challenge.parseChallengeReqText(317, 2, 0, n5);
                continue;
            }
            if (n4 == 13) continue;
            if (n4 == 12) {
                if (bl) {
                    Challenge.updateChallengeVal(GModel.m_nChainsConsecutive, n6);
                    continue;
                }
                Challenge.parseChallengeReqText(318, 2, 0, n5);
                continue;
            }
            if (n4 == 14) {
                if (bl) {
                    n8 = GModel.m_nCascades - 1;
                    if (GModel.m_nMatchesCountSaved > 0) {
                        ++n8;
                    }
                    Challenge.updateChallengeVal(n8, n6);
                    continue;
                }
                Challenge.parseChallengeReqText(319, 2, 0, n5);
                continue;
            }
            if (n4 == 23) {
                if (bl) {
                    Challenge.updateChallengeVal(GModel.m_nMovesMadePerLev, n6);
                    continue;
                }
                Challenge.parseChallengeReqText(320, 2, 0, n5);
                m_nMovesTotal = n5;
                bl4 = true;
                bl5 = true;
                continue;
            }
            if (n4 == 28) {
                if (bl) continue;
                n8 = 354;
                if (n5 == 8) {
                    n8 = 355;
                }
                Challenge.parseChallengeReqText(n8, 1, n5, -1);
                continue;
            }
            if (n4 == 26) {
                if (bl) {
                    Challenge.updateChallengeVal(m_nFlameCreatedThisTurn, n6);
                    continue;
                }
                Challenge.parseChallengeReqText(315, 2, 0, n5);
                continue;
            }
            if (n4 == 27) {
                if (bl) {
                    Challenge.updateChallengeVal(m_nLightningCreatedThisTurn, n6);
                    continue;
                }
                Challenge.parseChallengeReqText(316, 2, 0, n5);
                continue;
            }
            if (n4 == 11) {
                m_nCoalSpawningChance = n5;
                if (bl) continue;
                for (n8 = 0; n8 < 10; ++n8) {
                    GModel.addSpecialGem(GModel.BOARD_MASK, 7, -1, false, true);
                }
                continue;
            }
            if (n4 == 24) {
                m_nBadGemSpawningChance = n5;
                continue;
            }
            if (n4 == 2) {
                if (m_nLightningDestroyedThisTurn <= 0) continue;
                m_nGemsDestroyedThisTurn = 0;
                Challenge.updateChallengeVal(m_nGemsDestroyedThisTurn, 1);
                continue;
            }
            if (n4 == 15) {
                if (m_nFlameDestroyedThisTurn <= 0) continue;
                m_nGemsDestroyedThisTurn = 0;
                Challenge.updateChallengeVal(m_nGemsDestroyedThisTurn, 1);
                continue;
            }
            if (n4 != 25 || bl) continue;
            m_nSurvivorLevel = n5;
        }
        if (!bl) {
            if (bl4) {
                GModel.addSpecialGem(GModel.BOARD_MASK, 13, 34, false, true);
            }
            if (bl5) {
                GModel.addSpecialGem(GModel.PRELOCK_VALID_MASK, 15, 56, false, true);
            }
        }
        HUDController.updateChallengeText(bl);
        if (!bl) {
            if (n7 > 1) {
                GModel.m_nHudTimer = n7;
            } else if (m_nChallengeFrameCounter > 0) {
                GModel.m_nStaggerGemFill = GModel.m_nLevelCompleteFill = m_nChallengeFrameCounter;
                GModel.m_nCurrentGemFill = GModel.m_nLevelCompleteFill;
                GModel.m_nHudTimer = GModel.m_nLevelCompleteFill / 15;
            }
        }
        return -1;
    }

    static final void doClearCurrentChallenge() {
        int n = m_nChallengeModeCurrentStage[m_nChallengeStage];
        int n2 = m_nChallengeStage;
        m_nChallengeModeCurrentStage[n2] = m_nChallengeModeCurrentStage[n2] + 1;
        Challenge.m_nChallengeModeCurrentStage[Challenge.m_nChallengeStage] = Math.min(m_nChallengeModeCurrentStage[m_nChallengeStage], 7);
        if (m_nChallengeModeCurrentStage[m_nChallengeStage] == 1 && m_nChallengeStage < 12) {
            Challenge.m_nChallengeModeCurrentStage[Challenge.m_nChallengeStage + 1] = Math.max(0, m_nChallengeModeCurrentStage[m_nChallengeStage + 1]);
        }
        ScoreController.updateRank(n);
        RMS.softSave(GameController.m_nGameMode, true, false);
    }

    static final void doChallengeFail() {
        RMS.softSave(GameController.m_nGameMode, true, false);
        MainUIController.showMenu(54);
    }

    static final boolean isConditionSet(int n, int n2) {
        int n3 = Challenge.getChallengeStringOffset(n);
        int n4 = Challenge.getNumChallengeConditions(n);
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            n5 = Challenge.getConditionTypeAtOffset(n3, i);
            if (n5 != n2) continue;
            return true;
        }
        return false;
    }

    static final int getConditionsValue(int n, int n2) {
        int n3 = Challenge.getChallengeStringOffset(n);
        int n4 = Challenge.getNumChallengeConditions(n);
        for (int i = 0; i < n4; ++i) {
            if (Challenge.getConditionTypeAtOffset(n3, i) != n2) continue;
            return Challenge.getConditionValAtOffset(n3, i);
        }
        return -1;
    }

    static final boolean updateChallngeEndTurn() {
        if (GameController.m_nGameMode == 2) {
            int n = Challenge.getLevel();
            if (!m_bFoundColouredMatch) {
                m_nMatchesInARow = 0;
                Challenge.setChallengeSpecifics(n, true);
            }
            if (Challenge.isChallengeComplete(n)) {
                GameController.changeState(12);
                return true;
            }
            if (GameController.m_bGameOver) {
                Challenge.doChallengeFail();
            }
        }
        return false;
    }

    static final void endChallenge() {
        Hint.flagHint(17);
        int n = 0;
        for (int i = 0; i < m_nChallengeModeCurrentStage.length; ++i) {
            n += m_nChallengeModeCurrentStage[i];
        }
        if (n == "\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ".length() - 1) {
            MainUIController.showMenu(53);
        } else {
            MainUIController.showMenu(52);
        }
        SoundManager.handleSoundEvent(41);
    }

    static final void checkChallengeMatchConditions() {
        int n = Challenge.getLevel();
        int n2 = -1;
        boolean bl = false;
        if (Challenge.isConditionSet(n, 0) && Challenge.getConditionsValue(n, 0) == 1) {
            bl = true;
        }
        for (int i = 0; i < GModel.m_nMatchesCount; ++i) {
            n2 = GModel.MATCH_COLOUR[i];
            if (Challenge.isConditionSet(n, "\b\u0006\u0003\u0007\u0005\t\u0004".charAt(n2))) {
                ++m_nMatchesInARow;
                m_bFoundColouredMatch = true;
                continue;
            }
            if (Challenge.isConditionSet(n, 28)) {
                if (Util.bitsSetLong(GModel.MATCHES[i]) < m_nMatchBiggestLength) continue;
                m_nMatchBiggestLength = Util.bitsSetLong(GModel.MATCHES[i]);
                continue;
            }
            if (Challenge.isConditionSet(n, 10) && !bl) continue;
        }
    }

    static final void parseChallengeReqText(int n, int n2, int n3, int n4) {
        if (n2 >= 1) {
            Text.m_TextWindowIntegers[0] = n3;
        }
        if (n2 >= 2) {
            Text.m_TextWindowIntegers[1] = n4;
        }
        m_sChallengeReq.append(Text.GAME_STRINGS[n]);
        m_sChallengeReq = Text.FormatStringWithInts(m_sChallengeReq, n2, false);
    }

    static final void updateChallengeVal(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            for (int j = n3 = Text.strBufIndexOf(m_sChallengeReq, ':', n3 + 1); j < m_sChallengeReq.length() && m_sChallengeReq.charAt(n3 + 1) == ' '; ++j) {
                ++n3;
            }
            n4 = Text.strBufIndexOf(m_sChallengeReq, '/', n4 + 1);
        }
        Text.strBufReplace(m_sChallengeReq, n3 + 1, n4, n);
    }

    static final void checkPreserverConditions(int n, int n2) {
        while (Util.bitsSetLong(GModel.BOARD[n]) >= n2) {
            GModel.generateBoard(GModel.BOARD, -1L, false);
        }
    }

    static {
        m_sChallengeReq = new StringBuffer(128);
    }
}

