/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class LuckySpinScreen
implements ConstantsTFC,
GameConstants,
Constants,
InputConstants,
SoundManagerConstants {
    static int LUCKYSPIN_ANIM_NONE = 0;
    static int LUCKYSPIN_ANIM_CYCLE = 1;
    static int LUCKYSPIN_ANIM_SLOW_DOWN = 2;
    static int LUCKYSPIN_ANIM_FLASH = 3;
    static int LUCKYSPIN_ANIM_FLASH_FRAME = 4;
    static int LUCKYSPIN_ANIM_WAIT = 5;
    static int LUCKYSPIN_ANIM_MOVE_CLAMPS_IN = 6;
    static int LUCKYSPIN_ANIM_MOVE_PANEL_ON_SCREEN = 7;
    static boolean m_bPanelStartsMoving;
    static boolean m_bBombExplode;
    static boolean m_bBombDiffuse;
    static int m_nLuckySpinFrame;
    static int m_nLuckySpinAnimStage;
    static int m_nLuckySpinTimesPlayed;
    static int m_nLuckySpinOffset;
    static int m_nLuckySpinGem;
    static boolean m_bLuckySpinStopped;
    static final int[] LUCKY_SPIN_ITEM_GEM_COLOR;
    static final int NUM_TIMES_FOR_CHANCE_TO_DECREASE = 4;
    static final int NUM_SKULL_CHANGES_STAGES = 5;
    static final int GAME_OVER_ID = -1;
    static int m_nSpinSpeed;
    static int m_nLuckySpinPanelArmOffsetX;
    static int m_nLuckySpinPanelOffsetY;
    static int m_nSpinYOffset;
    static final int PANEL_MOVE_SPEED = 10;
    static int m_nGemPosX;
    static int m_nGemPosY;
    static int m_nGemStartPosX;
    static int m_nGemStartPosY;
    static int m_nGemColor;
    static int m_nGemFinalPosX;
    static int m_nGemFinalPosY;
    static int m_fpMoveRadius;
    static int m_fpMoveAngle;
    static int m_nSpinScreenXCentre;
    static int m_nPercentChance;
    static int m_nFinalPercentChance;
    static int m_fpMoveSpeed;
    static int m_fpMoveAngularSpeed;
    static final int BOMB_GEM_MOVE_STEPS = 15;

    static void drawLuckySpin(Graphics graphics, int n) {
        int n2 = m_nSpinScreenXCentre;
        int n3 = LuckySpinScreen.getPanelDrawY();
        graphics.setClip(0, 0, Graphic.m_nWidth, Graphic.m_nHeight);
        LuckySpinScreen.drawSpinning(graphics, n2, n3 + 127);
        LuckySpinScreen.drawLuckySpinPanel(graphics, n, n2, n3);
        LuckySpinScreen.drawMiddleGem(graphics, m_nGemPosX, m_nGemPosY, m_nLuckySpinGem);
    }

    static int getPanelDrawY() {
        int n = Graphic.GetImageHeight(349) + Graphic.GetImageHeight(82) + Graphic.GetImageHeight(218);
        return Graphic.m_nYCenter - n / 2 + m_nLuckySpinPanelOffsetY;
    }

    static void drawSpinning(Graphics graphics, int n, int n2) {
        int n3 = Graphic.GetImageWidth(73) / 3;
        int n4 = Graphic.GetImageHeight(73);
        int n5 = 0;
        int n6 = Graphic.GetImageWidth(137) * 2;
        int n7 = 88;
        int n8 = n - n6 / 2;
        int n9 = n2 - 44;
        graphics.setColor(15);
        graphics.fillRect(n8, n9, n6, n7);
        int n10 = LUCKY_SPIN_ITEM_GEM_COLOR.length;
        int n11 = 44 * LUCKY_SPIN_ITEM_GEM_COLOR.length;
        int n12 = m_nSpinYOffset % n11 - n11 / 2;
        if (m_nLuckySpinAnimStage == LUCKYSPIN_ANIM_FLASH && GModel.m_nLives == 0) {
            n5 = MainUIController.getPingPongFrame(3) * n3;
        }
        for (int i = 0; i < n10 * 3; ++i) {
            int n13 = i * 44;
            int n14 = n2 + n13 + n12 - n11 - 22;
            if (n14 <= n2 - 88 || n14 >= n2 + 44) continue;
            int n15 = i % n10;
            int n16 = LUCKY_SPIN_ITEM_GEM_COLOR[n15];
            int n17 = n14 + 22 - n4 / 2;
            int n18 = n - 44;
            graphics.setClip(n8, n9, n6, n7);
            if (n16 >= 0) {
                Graphic.DrawImage(graphics, "\u0109T\u014f\u0088\u00ff\u000f\u00c8\u009f".charAt(n16), n18, n14, 17);
            } else {
                graphics.clipRect(n18 -= n3 / 2, n14, n3, n4);
                Graphic.DrawImage(graphics, 73, n18 - n5, n17, 20);
            }
            n18 = n + 44;
            graphics.setClip(n8, n9, n6, n7);
            if (n16 >= 0) {
                Graphic.DrawImage(graphics, "\u0109T\u014f\u0088\u00ff\u000f\u00c8\u009f".charAt(n16), n18, n14, 17);
                continue;
            }
            graphics.clipRect(n18 -= n3 / 2, n14, n3, n4);
            Graphic.DrawImage(graphics, 73, n18 - n5, n17, 20);
        }
    }

    static void drawMiddleGem(Graphics graphics, int n, int n2, int n3) {
        GCanvasController.updateCountdownFont(13);
        if (GameController.m_nBoardStateFrame % 2 == 0) {
            int n4 = m_nLuckySpinGem;
            GCanvasController.COUNTDOWN_FONT_FRAME[n4] = GCanvasController.COUNTDOWN_FONT_FRAME[n4] + 1;
            if (GCanvasController.COUNTDOWN_FONT_FRAME[n4] > GraphicsUtil.getPingPongMaxFrame("\u0150\u0151\u0153\u0154\u0155".length())) {
                GCanvasController.COUNTDOWN_FONT_FRAME[LuckySpinScreen.m_nLuckySpinGem] = -1;
            }
        }
        graphics.setClip(n -= 22, n2 -= 22, 44, 44);
        GCanvas.drawGemLayer(graphics, m_nLuckySpinGem, n, n2, n, n2, 44, 44, GemAnimation.TILE_SEQUENCES, GemAnimation.TILE_FRAME_WIDTHS, GemAnimation.TILE_FRAME_HEIGHTS, GemAnimation.TILE_NUM_FRAMES, GCanvasController.TILES_CURRENT_FRAME, GemAnimation.TILE_ANIMATION_TYPE, 1);
        graphics.setClip(n, n2, 44, 44);
        GCanvas.drawGemLayer(graphics, m_nLuckySpinGem, n, n2, n, n2, 44, 44, GemAnimation.GEM_SEQUENCES, GemAnimation.GEM_FRAME_WIDTHS, GemAnimation.GEM_FRAME_HEIGHTS, GemAnimation.GEM_NUM_FRAMES, GCanvasController.GEMS_CURRENT_FRAME, GemAnimation.GEM_ANIMATION_TYPES, 0);
        graphics.setClip(n, n2, 44, 44);
        GCanvas.drawGemLayer(graphics, m_nLuckySpinGem, n, n2, n, n2, 44, 44, GemAnimation.OVERLAY_SEQUENCES, GemAnimation.OVERLAY_FRAME_WIDTHS, GemAnimation.OVERLAY_FRAME_HEIGHTS, GemAnimation.OVERLAY_NUM_FRAMES, GCanvasController.OVERLAYS_CURRENT_FRAME, GemAnimation.OVERLAY_ANIMATION_TYPE, 2);
        ParticleCanvas.drawParticles(graphics, false, true);
    }

    static void drawLuckySpinPanel(Graphics graphics, int n, int n2, int n3) {
        graphics.setClip(0, 0, Graphic.m_nDeviceWidth, Graphic.m_nDeviceHeight);
        Graphic.DrawImage(graphics, 349, n2, n3, 24);
        Graphic.DrawImage(graphics, 350, n2, n3, 20);
        Graphic.DrawImage(graphics, 294, n2 - 82 - m_nLuckySpinPanelArmOffsetX, n3 + 78, 24);
        Graphic.DrawImage(graphics, 295, n2 + 82 + m_nLuckySpinPanelArmOffsetX, n3 + 78, 20);
        LuckySpinScreen.drawCriticalPod(graphics, n2, n3);
        Graphic.DrawImage(graphics, 218, n2, n3 += Graphic.GetImageHeight(349), 24);
        Graphic.DrawImage(graphics, 219, n2, n3, 20);
        LuckySpinScreen.drawBaseTextArea(graphics, n, n2, n3);
    }

    static void drawBaseTextArea(Graphics graphics, int n, int n2, int n3) {
        int n4 = MainUIController.getTitleFontID(n);
        GCanvas.m_sDisplayStr.setLength(0);
        if (m_nLuckySpinAnimStage == LUCKYSPIN_ANIM_FLASH && GModel.m_nLives <= 0) {
            GCanvas.m_sDisplayStr.append(Text.GAME_STRINGS[139]);
        } else if (m_nLuckySpinAnimStage == LUCKYSPIN_ANIM_FLASH) {
            GCanvas.m_sDisplayStr.append(Text.GAME_STRINGS[138]);
        } else if (m_nLuckySpinAnimStage == LUCKYSPIN_ANIM_CYCLE) {
            GCanvas.m_sDisplayStr.append(Text.GAME_STRINGS[137]);
        } else {
            GCanvas.m_sDisplayStr.append(Text.GAME_STRINGS[140]);
            Text.m_TextWindowIntegers[0] = m_nPercentChance;
            Text.FormatStringWithInts(GCanvas.m_sDisplayStr, 1, false);
        }
        int n5 = Fonts.stringWidth(GCanvas.m_sDisplayStr, n4);
        Graphic.DrawImage(graphics, 82, n2 - n5 / 2, n3 += Graphic.GetImageHeight(218), 24);
        Graphic.DrawImage(graphics, 83, n2 + n5 / 2, n3, 20);
        for (int i = 0; i < n5; ++i) {
            Graphic.DrawImage(graphics, 166, n2 - n5 / 2 + i, n3, 20);
        }
        Touch.DrawAlignedText(graphics, GCanvas.m_sDisplayStr, 0, GCanvas.m_sDisplayStr.length(), n2, n3 += Graphic.GetImageHeight(83) / 2 - Fonts.getFontHeight(n4) / 2, n4, 2, false, 101);
    }

    static void drawCriticalPod(Graphics graphics, int n, int n2) {
        int n3 = Graphic.GetImageHeight(137) / 5;
        int n4 = Graphic.GetImageWidth(137);
        int n5 = MainUIController.getPingPongFrame(5) * n3;
        int n6 = n2 + 13;
        graphics.setClip(n - n4, n6, n4, n3);
        Graphic.DrawImage(graphics, 137, n - n4, n6 - n5, 20);
        graphics.setClip(n, n6, n4, n3);
        Graphic.DrawImage(graphics, 138, n, n6 - n5, 20);
        graphics.setClip(0, 0, Graphic.m_nDeviceWidth, Graphic.m_nDeviceHeight);
    }

    static void startLuckySpin(int n) {
        int n2;
        m_nLuckySpinGem = n;
        SoundManager.handleSoundEvent(45);
        m_nSpinScreenXCentre = GCanvas.BOARD_POSITION_X + 0 + 176;
        GModel.m_nLives = Math.max(GModel.m_nLives - 1, 0);
        int n3 = Math.min(++m_nLuckySpinTimesPlayed, LUCKY_SPIN_ITEM_GEM_COLOR.length - 1);
        int n4 = 25;
        m_nPercentChance = m_nFinalPercentChance = Math.max(100 - n4 * m_nLuckySpinTimesPlayed, n4);
        m_nSpinYOffset = 88;
        for (n2 = 0; n2 < LUCKY_SPIN_ITEM_GEM_COLOR.length; ++n2) {
            LuckySpinScreen.LUCKY_SPIN_ITEM_GEM_COLOR[n2] = GModel.getGemColour(1L << m_nLuckySpinGem);
        }
        m_nLuckySpinPanelOffsetY = 0;
        GCanvasController.getGemPosition(m_nLuckySpinGem, true, false);
        m_nGemStartPosX = m_nGemPosX = GCanvasController.m_nGetGemPosX + 22;
        m_nGemStartPosY = m_nGemPosY = GCanvasController.m_nGetGemPosY + 22;
        m_nGemColor = GModel.getGemColour(1L << m_nLuckySpinGem);
        LuckySpinScreen.setupGemTwirlMoving(m_nGemStartPosX, m_nGemStartPosY, m_nSpinScreenXCentre, LuckySpinScreen.getPanelDrawY() + 127);
        for (n2 = 0; n2 < n3; ++n2) {
            LuckySpinScreen.LUCKY_SPIN_ITEM_GEM_COLOR[n2 + 1] = -1;
        }
        m_nLuckySpinFrame = 0;
        m_nLuckySpinAnimStage = LUCKYSPIN_ANIM_MOVE_PANEL_ON_SCREEN;
        m_nLuckySpinPanelArmOffsetX = Graphic.m_nDeviceWidth / 3;
        m_nLuckySpinPanelOffsetY = Graphic.m_nDeviceHeight - LuckySpinScreen.getPanelDrawY();
        m_bLuckySpinStopped = false;
        m_nLuckySpinOffset = 1;
        m_nSpinSpeed = 3;
        m_bPanelStartsMoving = false;
        m_bBombExplode = false;
        m_bBombDiffuse = false;
        Hint.flagHint(6);
        MainUIController.showMenu(56);
    }

    static void updateLuckySpin() {
        ++m_nLuckySpinFrame;
        boolean bl = false;
        Particles.handleParticles();
        Particles.recycleParticles(false);
        if (m_nLuckySpinAnimStage == LUCKYSPIN_ANIM_MOVE_PANEL_ON_SCREEN) {
            m_nLuckySpinPanelOffsetY = m_nLuckySpinPanelOffsetY > 0 ? (m_nLuckySpinPanelOffsetY >= 20 ? (m_nLuckySpinPanelOffsetY -= 20) : 0) : 0;
            bl = LuckySpinScreen.updateMiddleGemPos();
            if (bl && m_nLuckySpinPanelOffsetY <= 0) {
                m_nLuckySpinPanelOffsetY = 0;
                m_nLuckySpinFrame = 0;
                m_nLuckySpinAnimStage = LUCKYSPIN_ANIM_MOVE_CLAMPS_IN;
            }
        } else if (m_nLuckySpinAnimStage == LUCKYSPIN_ANIM_MOVE_CLAMPS_IN) {
            if ((m_nLuckySpinPanelArmOffsetX -= 10) <= 0) {
                m_nLuckySpinPanelArmOffsetX = 0;
                m_nLuckySpinFrame = 0;
                m_nLuckySpinAnimStage = LUCKYSPIN_ANIM_CYCLE;
            }
        } else if (m_nLuckySpinAnimStage == LUCKYSPIN_ANIM_CYCLE) {
            ++m_nSpinSpeed;
            m_nSpinSpeed = Math.min(9, m_nSpinSpeed);
            m_nSpinYOffset += m_nSpinSpeed;
        } else if (m_nLuckySpinAnimStage == LUCKYSPIN_ANIM_SLOW_DOWN) {
            m_nSpinYOffset += m_nSpinSpeed;
            if (m_nLuckySpinFrame > 15) {
                int n = LUCKY_SPIN_ITEM_GEM_COLOR.length - 1 - (m_nSpinYOffset / 44 + 2) % LUCKY_SPIN_ITEM_GEM_COLOR.length;
                if (GModel.m_nLives <= 0 && LUCKY_SPIN_ITEM_GEM_COLOR[n] == -1 || GModel.m_nLives > 0 && LUCKY_SPIN_ITEM_GEM_COLOR[n] != -1) {
                    m_nSpinSpeed -= 2;
                } else {
                    --m_nSpinSpeed;
                    m_nSpinSpeed = Math.max(m_nSpinSpeed, 4);
                }
                m_nSpinSpeed = Math.max(3, m_nSpinSpeed);
                if (m_nSpinYOffset % 44 <= 3) {
                    int n2 = LUCKY_SPIN_ITEM_GEM_COLOR.length - 1 - (m_nSpinYOffset / 44 + 1) % LUCKY_SPIN_ITEM_GEM_COLOR.length;
                    if (GModel.m_nLives <= 0 && LUCKY_SPIN_ITEM_GEM_COLOR[n2] == -1 || GModel.m_nLives > 0 && LUCKY_SPIN_ITEM_GEM_COLOR[n2] != -1) {
                        m_nSpinYOffset -= m_nSpinYOffset % 44;
                        m_nLuckySpinFrame = 0;
                        m_nLuckySpinAnimStage = LUCKYSPIN_ANIM_FLASH;
                    }
                }
            }
        } else if (m_nLuckySpinAnimStage == LUCKYSPIN_ANIM_FLASH) {
            if (m_nLuckySpinFrame == 1 && GModel.m_nLives == 0) {
                LuckySpinScreen.setupGemTwirlMoving(m_nGemFinalPosX, m_nGemFinalPosY, m_nGemStartPosX, m_nGemStartPosY);
            }
            if (GModel.m_nLives <= 0) {
                if (!m_bBombExplode) {
                    SoundManager.handleSoundEvent(34);
                    m_bBombExplode = true;
                }
            } else if (!m_bBombDiffuse) {
                SoundManager.handleSoundEvent(54);
                m_bBombDiffuse = true;
            }
            if (m_nLuckySpinFrame > 30) {
                if (!m_bPanelStartsMoving) {
                    SoundManager.handleSoundEvent(44);
                    m_bPanelStartsMoving = true;
                }
                m_nLuckySpinPanelOffsetY += 20;
                if (GModel.m_nLives > 0) {
                    m_nGemPosX = m_nSpinScreenXCentre;
                    m_nGemPosY = LuckySpinScreen.getPanelDrawY() + 127;
                }
            }
            if (m_nLuckySpinFrame > 45 && (bl = GModel.m_nLives == 0 ? LuckySpinScreen.updateMiddleGemPos() : true) && LuckySpinScreen.getPanelDrawY() > Graphic.m_nDeviceHeight) {
                UIController.returnToGameFromLuckySpin();
            }
        }
        if (m_fpMoveRadius <= 0 && Util.GetRandom(2) == 0) {
            Particles.setupParticles(4, 14, m_nLuckySpinGem, m_nGemPosX - 22, m_nGemPosY - 22, -1);
        }
        GCanvasController.updateGem(m_nLuckySpinGem);
    }

    static boolean updateMiddleGemPos() {
        m_nGemPosX = m_nGemFinalPosX - FP.toInt(FP.fpMul(m_fpMoveRadius, FP.fpCos(m_fpMoveAngle)));
        m_nGemPosY = m_nGemFinalPosY - FP.toInt(FP.fpMul(m_fpMoveRadius, FP.fpSin(m_fpMoveAngle)));
        m_fpMoveAngle += m_fpMoveAngularSpeed;
        if ((m_fpMoveRadius -= m_fpMoveSpeed) <= 0) {
            m_nGemPosX = m_nGemFinalPosX;
            m_nGemPosY = m_nGemFinalPosY;
            return true;
        }
        return false;
    }

    static void setupGemTwirlMoving(int n, int n2, int n3, int n4) {
        int n5 = FP.toFP(n3 - n);
        int n6 = FP.toFP(n4 - n2);
        int n7 = FP.fpMul(n5, n5) + FP.fpMul(n6, n6);
        m_fpMoveRadius = FP.fpSqrt(n7);
        m_fpMoveAngle = FP.fpAtan(FP.fpDiv(n6, n5));
        m_fpMoveSpeed = m_fpMoveRadius / 15;
        m_fpMoveAngularSpeed = 214;
        if (n4 < n2 && n3 < n || n4 > n2 && n3 < n) {
            m_fpMoveAngle += 3216;
        }
        m_nGemFinalPosX = n3;
        m_nGemFinalPosY = n4;
    }

    static {
        LUCKY_SPIN_ITEM_GEM_COLOR = new int[4];
    }
}

