/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class GModel
implements GameConstants,
Constants,
SoundManagerConstants {
    public static int GEM_FP_START_SPEED;
    public static int GEM_FP_GRAVITY;
    public static final int NORMAL_GEM_COLOURS;
    public static final int GEM_COLOUR_COUNT;
    public static final int GEM_STATE_COUNT;
    public static final int GEM_BITFIELD_SIZE;
    static final int MAX_MATCHES = 45;
    static int m_nChainsConsecutive;
    static int m_nChains;
    static int m_nChainMultiplier;
    static final int NORMAL_GEM_COLOURS_BITFIELD;
    static final long[] BOARD;
    static final long[] TEMP_BOARD;
    static final long[] MATCHES;
    static final int[] MATCH_COLOUR;
    static final long[] MATCHES_TEMP;
    static long BOARD_MASK;
    static long PRELOCK_VALID_MASK;
    static final long[] MATCH_SPECIAL_SHAPES_MASKS;
    static boolean m_bIncrementChain;
    static int m_nMatchesCount;
    static int m_nMatchesCountSaved;
    static final int[] GEM_COUNTDOWN_MOVES;
    static final int[] STACK;
    static int m_nStackSize;
    static int m_nMoveOffset;
    static int m_nResetGemCountFlame;
    static int m_nResetGemCountFruit;
    static int m_nResetGemCountLightning;
    static int m_nResetGemCountSuper;
    static boolean m_bCreateCountdownAtEndOfMove;
    static long m_lCountdownsCreatedThisTurn;
    static boolean m_bCreateCoalAtEndOfMove;
    static boolean m_bCreatePreLockAtEndOfMove;
    static boolean m_bCreatePreDoomAtEndOfMove;
    static int[] BOARD_RESOLUTION_MOVES;
    static int m_nCascades;
    static int m_nCurrentGemFill;
    static int m_nStaggerGemFill;
    static int m_nLevelCompleteFill;
    static boolean m_bBadMove;
    static int[] FLAME_GEMS;
    static long m_lUnhandledSpecialGems;
    static int m_nBlitzFrameCounter;
    static int m_nHudTimer;
    static boolean m_bAwardFruitGem;
    static int m_nLives;
    static long m_lSpecialGemsNewlyCreated;
    static int m_nMovesMadePerLev;
    static int m_nMatchesMadePerLev;
    static boolean m_bLevelUpNewGame;
    static final int[] GEMS_NEXT_STATE;
    static final int[] GEMS_NEXT_STATE_DELAY;
    static long m_lGemsDelayedState;
    static int m_nReplayPoints;
    static final Random TWIST_LOGIC_RANDOMER;
    static boolean m_bSkipCountdownThisFrame;
    static int m_nCountdownsDestroyed;
    static int m_nFlamesDestroyed;
    static int m_nAwardedFruitGem;
    static boolean m_bShakeFruitGem;
    static int m_nDoomGemsCreatedThisLevel;
    static long m_lCurrentFruitExploding;
    static int[] DIFFICULTY_CURVE;
    static int m_nTutorialSlowRotates;
    static boolean m_StartingNewGameFromOldOne;
    static boolean loadGameSetAfterUITransition;

    static void init() {
        int n;
        GEM_FP_START_SPEED = FP.fpDiv(4096, 2048);
        GEM_FP_GRAVITY = FP.fpDiv(5120, 2048);
        GModel.MATCH_SPECIAL_SHAPES_MASKS[0] = 65799L;
        GModel.MATCH_SPECIAL_SHAPES_MASKS[1] = 263175L;
        GModel.MATCH_SPECIAL_SHAPES_MASKS[2] = 459009L;
        GModel.MATCH_SPECIAL_SHAPES_MASKS[3] = 459780L;
        GModel.MATCH_SPECIAL_SHAPES_MASKS[4] = 67329L;
        GModel.MATCH_SPECIAL_SHAPES_MASKS[5] = 263940L;
        GModel.MATCH_SPECIAL_SHAPES_MASKS[6] = 459266L;
        GModel.MATCH_SPECIAL_SHAPES_MASKS[7] = 131591L;
        GModel.MATCH_SPECIAL_SHAPES_MASKS[8] = 132866L;
        for (n = 0; n < 64; ++n) {
            BOARD_MASK |= 1L << n;
        }
        for (n = 0; n < 4; ++n) {
            PRELOCK_VALID_MASK |= 255L << n * 8;
        }
        GModel.setDifficultyModifier();
    }

    static void resetVars() {
        m_nChains = 0;
        m_nChainsConsecutive = 0;
        m_nChainMultiplier = 0;
        Util.resetArray(BOARD, 0L);
        Util.resetArray(MATCHES, 0L);
        Util.resetArray(MATCH_COLOUR, 0);
        Util.resetArray(MATCHES_TEMP, 0L);
        m_bIncrementChain = true;
        m_nMatchesCount = 0;
        Util.resetArray(GEM_COUNTDOWN_MOVES, -1);
        Util.resetArray(STACK, 0);
        m_nStackSize = 0;
        m_nMoveOffset = 0;
        Util.resetArray(BOARD_RESOLUTION_MOVES, 0);
        m_nCascades = 1;
        m_nCurrentGemFill = 0;
        m_nStaggerGemFill = 0;
        m_nLevelCompleteFill = 0;
        m_bBadMove = false;
        Util.resetArray(FLAME_GEMS, 0);
        m_lUnhandledSpecialGems = 0L;
        GameController.m_nCursorY = 3;
        GameController.m_nCursorX = 3;
        m_nBlitzFrameCounter = 4500;
        m_nHudTimer = -1;
        m_bAwardFruitGem = false;
        m_nLives = 0;
        m_lSpecialGemsNewlyCreated = 0L;
        m_nMovesMadePerLev = 0;
        m_nMatchesMadePerLev = 0;
        m_nResetGemCountFlame = 0;
        m_nResetGemCountFruit = 0;
        m_nResetGemCountSuper = 0;
        m_nResetGemCountLightning = 0;
        m_bLevelUpNewGame = false;
        m_lCountdownsCreatedThisTurn = 0L;
        m_bCreateCountdownAtEndOfMove = false;
        m_bCreateCoalAtEndOfMove = false;
        m_bCreatePreLockAtEndOfMove = false;
        m_bCreatePreDoomAtEndOfMove = false;
        Util.resetArray(GEMS_NEXT_STATE, -1);
        Util.resetArray(GEMS_NEXT_STATE_DELAY, -1);
        m_lGemsDelayedState = 0L;
        m_nReplayPoints = 0;
        m_bSkipCountdownThisFrame = false;
        m_nCountdownsDestroyed = 0;
        m_nFlamesDestroyed = 0;
        m_nAwardedFruitGem = -1;
        m_bShakeFruitGem = false;
        m_nDoomGemsCreatedThisLevel = 0;
        m_lCurrentFruitExploding = -1L;
        m_nTutorialSlowRotates = 3;
    }

    static void calculateGemFallDis(long l) {
        int n;
        int n2;
        for (n2 = 0; n2 < BOARD_RESOLUTION_MOVES.length; ++n2) {
            GModel.BOARD_RESOLUTION_MOVES[n2] = 0;
        }
        for (n2 = 0; n2 < 64; ++n2) {
            long l2 = 1L << n2;
            if ((l & l2) == 0L) continue;
            GModel.BOARD_RESOLUTION_MOVES[n2] = -1;
            if (n2 < 8) continue;
            for (n = n2 - 8; n >= 0; n -= 8) {
                long l3 = 1L << n;
                if ((l & l3) != 0L) continue;
                int n3 = n;
                BOARD_RESOLUTION_MOVES[n3] = BOARD_RESOLUTION_MOVES[n3] + 1;
            }
        }
        n2 = 0;
        for (n = 0; n < 64; ++n) {
            if (BOARD_RESOLUTION_MOVES[n] != 0 && GCanvasController.GEMS_FP_FALL_SPEED[n] == 0) {
                GCanvasController.GEMS_FP_FALL_SPEED[n] = GEM_FP_START_SPEED;
            }
            if (BOARD_RESOLUTION_MOVES[n] >= 0) continue;
            int n4 = 1;
            int n5 = 0;
            for (int i = n2 = n % 8; i < 64; i += 8) {
                if (BOARD_RESOLUTION_MOVES[i] >= 0) continue;
                ++n5;
                if (i <= n) continue;
                ++n4;
            }
            GModel.BOARD_RESOLUTION_MOVES[n] = -(n4 << 16 | n5);
            long l4 = GModel.getAllGemsBelow(n);
            int n6 = Util.findNextSetBit(l4, 0);
            while (n6 != -1) {
                if (GCanvasController.GEMS_FP_FALL_SPEED[n6] != 0 || GCanvasController.GEMS_FP_FALL_OFFSET[n6] != 0) {
                    GCanvasController.GEMS_FP_FALL_SPEED[n] = GCanvasController.GEMS_FP_FALL_SPEED[n6];
                    GCanvasController.GEMS_FP_FALL_OFFSET[n] = GCanvasController.GEMS_FP_FALL_OFFSET[n6];
                }
                n6 = Util.findNextSetBit(l4, n6 + 1);
            }
        }
    }

    static void resolveFlameGems(long l, boolean bl) {
        int n = -1;
        long l2 = 0L;
        n = Util.findNextSetBit(l, 0);
        while (n != -1) {
            l2 = 1L << n;
            if ((m_lSpecialGemsNewlyCreated & l2) == 0L && (l2 & (BOARD[8] | BOARD[16] | BOARD[12])) != 0L) {
                GModel.resolveFlameGem(n, l, bl);
                if (bl) {
                    BOARD[8] = BOARD[8] & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
                    m_lUnhandledSpecialGems &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
                    GameController.updateExplodingFlameStats(1L << n);
                    if (Challenge.m_nFlameDestroyedThisTurn <= 10) {
                        SoundManager.handleSoundEvent(35);
                    }
                }
            }
            n = Util.findNextSetBit(l, n + 1);
        }
    }

    static boolean isUnique(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return false;
        }
        return true;
    }

    static long resolveFlameGem(int n, long l, boolean bl) {
        long l2 = 0L;
        int n2 = 1;
        int n3 = 0;
        int n4 = n / 8;
        int n5 = n % 8;
        int n6 = Math.max(n5 - n2, 0);
        int n7 = Math.min(n5 + n2, 7);
        int n8 = Math.max(n4 - n2, 0);
        n3 = Math.min(n4 + n2, 7);
        int n9 = n8 * 8 + n6;
        int n10 = n3 * 8 + n7;
        long l3 = 0L;
        int n11 = FP.fpMul(GCanvasController.CASCADE_FP_PUSH, 3072);
        for (int i = n9; i <= n10; ++i) {
            if (i % 8 > n7 || i % 8 < n6) continue;
            l3 = 1L << i;
            int n12 = i / 8;
            int n13 = i % 8;
            if ((m_lSpecialGemsNewlyCreated & l3) == 0L) {
                l2 |= l3;
                ScoreController.linkGemToMatchScore(i, ScoreController.SCORED_GEM_LINKED_MATCH[n]);
                if (GCanvasController.m_lAnimatedLightningsExploded != -1L && ((BOARD[16] & l3) != 0L || (BOARD[9] & l3) != 0L)) {
                    GModel.setGemsNextState(i, 21, 1);
                } else if ((l & l3) == 0L && (BOARD[8] & l3) != 0L) {
                    int n14 = (Math.abs(n / 8 - n12) + Math.abs(n % 8 - n13)) * 2;
                    GModel.setGemsNextState(i, 21, n14);
                    GCanvasController.setGemsNextAnimState(i, 50, n14);
                } else if ((l & l3) == 0L && (BOARD[12] & l3) != 0L && (GCanvasController.m_lAnimatedLightningsExploded != -1L || m_lCurrentFruitExploding != -1L)) {
                    GModel.setGemsNextState(i, 21, 1);
                } else if ((l & l3) == 0L && ((BOARD[16] & l3) != 0L || (BOARD[9] & l3) != 0L || (BOARD[12] & l3) != 0L)) {
                    m_lUnhandledSpecialGems |= l3;
                } else {
                    if ((BOARD[21] & l3) == 0L) {
                        if ((BOARD[13] & l3) != 0L) {
                            GModel.startWisps(13, i);
                        } else if ((BOARD[14] & l3) != 0L) {
                            GModel.startWisps(14, i);
                        }
                    }
                    GModel.setGemProperty(l3, 21);
                    GCanvasController.setExplodeGemAnim(i, 0, -1);
                    ScoreController.increaseMatchScore(i);
                }
            }
            if (n12 == n8) {
                GCanvasController.pushGemsUp(GModel.getAllGemsAbove(i));
            }
            if (n13 > 0) {
                GCanvasController.pushGemOut(i - 1, -n11, 0, -n11, 0, 0L, true, 0);
            }
            if (n13 < 7 && i + 1 < 64) {
                GCanvasController.pushGemOut(i + 1, n11, 0, n11, 0, 0L, true, 0);
            }
            if (n12 > 0) {
                GCanvasController.pushGemOut(i - 8, 0, -n11, -n11, 0, 0L, true, 0);
            }
            if (n12 >= 7 || i + 8 >= 64) continue;
            GCanvasController.pushGemOut(i + 8, 0, n11, n11, 0, 0L, true, 0);
        }
        return l2;
    }

    static void stackPush(int n) {
        GModel.STACK[GModel.m_nStackSize++] = n;
    }

    static int stackPop() {
        return STACK[--m_nStackSize];
    }

    static void findMatches(long[] lArray, boolean bl) {
        int n;
        int n2;
        int n3;
        long l;
        int n4;
        int n5;
        int n6;
        long l2;
        int n7;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        m_nMatchesCount = 0;
        l4 = 0L;
        for (n7 = 0; n7 < 64; ++n7) {
            l2 = 1L << n7;
            n6 = n7 % 8;
            n5 = n7 / 8;
            n4 = -1;
            n4 = GModel.getGemColour(l2, lArray);
            if (n4 == -1 || n4 == 7 || (lArray[14] & l2) != 0L) continue;
            l = lArray[n4];
            l3 = l2;
            n3 = 1;
            if (n6 >= 7) continue;
            n2 = n7 + 8 - n6;
            for (n = n7 + 1; n < n2 && (l & (l5 = 1L << n)) != 0L && (lArray[14] & l5) == 0L; ++n) {
                l3 |= l5;
                ++n3;
            }
            if (n3 < 3) continue;
            GModel.MATCH_COLOUR[GModel.m_nMatchesCount] = n4;
            GModel.MATCHES[GModel.m_nMatchesCount++] = l3;
            l4 |= l3;
        }
        l4 = 0L;
        for (n7 = 0; n7 < 64; ++n7) {
            l2 = 1L << n7;
            n6 = n7 % 8;
            n5 = n7 / 8;
            n4 = GModel.getGemColour(l2, lArray);
            if (n4 == -1 || n4 == 7 || (lArray[14] & l2) != 0L) continue;
            l = lArray[n4];
            l3 = l2;
            n3 = 1;
            if (n5 >= 7) continue;
            n2 = n7 + (8 - n5) * 8;
            for (n = n7 + 8; n < n2 && (l & (l5 = 1L << n)) != 0L && (lArray[14] & l5) == 0L; n += 8) {
                l3 |= l5;
                ++n3;
            }
            if (n3 < 3) continue;
            GModel.MATCH_COLOUR[GModel.m_nMatchesCount] = n4;
            GModel.MATCHES[GModel.m_nMatchesCount++] = l3;
            l4 |= l3;
        }
        if (m_nMatchesCount > 0 && bl) {
            GModel.compactMatches(true);
            GModel.compactMatches(false);
            m_nMatchesCountSaved = m_nMatchesCount;
        }
    }

    static void compactMatches(boolean bl) {
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = m_nMatchesCount - 1;
        while (n3 > 0) {
            int n4;
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                boolean bl4 = bl2 = (MATCHES[n3] & MATCHES[n4]) == MATCHES[n3];
                if (bl) {
                    bl3 = MATCH_COLOUR[n3] == MATCH_COLOUR[n4] && (MATCHES[n3] & MATCHES[n4]) != 0L && bl2;
                } else {
                    n = Util.bitsSetLong(MATCHES[n3]);
                    n2 = Util.bitsSetLong(MATCHES[n4]);
                    boolean bl5 = bl3 = MATCH_COLOUR[n3] == MATCH_COLOUR[n4] && (MATCHES[n3] & MATCHES[n4]) != 0L && n <= 3 && n2 <= 3;
                }
                if (!bl3) continue;
                int n5 = n4;
                MATCHES[n5] = MATCHES[n5] | MATCHES[n3];
                --m_nMatchesCount;
                break;
            }
            if (bl3) {
                for (n4 = n3; n4 < MATCHES.length - 1; ++n4) {
                    GModel.MATCHES[n4] = MATCHES[n4 + 1];
                    GModel.MATCH_COLOUR[n4] = MATCH_COLOUR[n4 + 1];
                }
                bl3 = false;
            }
            --n3;
        }
    }

    static boolean createSpecialGemFromMatch(int n, int n2, int n3, int n4) {
        int n5;
        if (n2 == -1) {
            int n6 = Util.bitsSetLong(MATCHES[n]);
            int n7 = n6 / 2;
            if (n6 % 2 != 0) {
                ++n7;
            }
            for (n5 = 0; n5 != n7; ++n5) {
                n2 = Util.findNextSetBit(MATCHES[n], n2 + 1);
            }
            if (GModel.getSpecialState(1L << n2, false, true, false) != -1) {
                n2 = -1;
            }
        }
        if (n2 == -1) {
            n2 = Util.findNextSetBit(MATCHES[n], 0);
            while (n2 != -1 && GModel.getSpecialState(1L << n2, false, false, false) != -1) {
                n2 = Util.findNextSetBit(MATCHES[n], n2 + 1);
            }
        }
        if (n2 == -1) {
            return false;
        }
        long l = 1L << n2;
        m_lSpecialGemsNewlyCreated |= l;
        BOARD[10] = BOARD[10] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        BOARD[11] = BOARD[11] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        BOARD[21] = BOARD[21] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        if (GModel.getGemProperty(l, 13)) {
            GModel.GEM_COUNTDOWN_MOVES[n2] = -1;
            GModel.unsetGemProperty(l, 13);
            ++m_nCountdownsDestroyed;
        }
        GameController.updateExplodingGemStats(l);
        GCanvasController.resetPushedOutGem(n2);
        int n8 = n3;
        BOARD[n8] = BOARD[n8] | l;
        n5 = 0;
        while (n5 < m_nMatchesCount) {
            int n9 = n5++;
            MATCHES[n9] = MATCHES[n9] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        GCanvasController.setGemAnimation(n2, 23, 0);
        GCanvasController.setGemAnimation(n2, n4, -4);
        long l2 = BOARD[12];
        GCanvasController.setGemsAnimMorphToSpecial(MATCHES[n] & (l2 ^ 0xFFFFFFFFFFFFFFFFL), 51, n2, 0);
        if (n3 == 8) {
            m_nReplayPoints += 3;
        } else if (n3 == 9) {
            m_nReplayPoints += 5;
        } else if (n3 == 16) {
            m_nReplayPoints += 30;
        }
        return true;
    }

    static boolean findSpecialShapedMatches(int n, boolean bl) {
        long l = 0L;
        int n2 = Util.findNextSetBit(MATCHES[n], 0);
        int n3 = -1;
        for (int i = 0; i < MATCH_SPECIAL_SHAPES_MASKS.length; ++i) {
            l = MATCHES[n] >> n2 - "\u0000\u0000\u0000\u0002\u0000\u0002\u0001\u0000\u0001".charAt(i);
            if (l != MATCH_SPECIAL_SHAPES_MASKS[i]) continue;
            if (!bl) {
                return true;
            }
            if (l == 132866L) {
                Hint.flagHint(13);
            } else if (i >= 4) {
                Hint.flagHint(14);
            } else {
                Hint.flagHint(12);
            }
            for (int j = 0; j < "\u0001\u0003\u0003\u0005\u0002\u0004\u0004\u0002\u0003".charAt(i); ++j) {
                if (GModel.getSpecialState(1L << (n3 = Util.findNextSetBit(MATCHES[n], n3 + 1)), false, false, false) == -1) continue;
                n3 = -1;
            }
            if (GModel.createSpecialGemFromMatch(n, n3, 8, 31)) {
                ++Challenge.m_nFlameCreatedThisTurn;
            }
            return true;
        }
        return false;
    }

    static void handleChains(boolean bl) {
        if (m_nMatchesCount > 0) {
            if (m_bIncrementChain) {
                GModel.handleChainMeter(true, true);
                GameController.m_nIncreaseChain = true;
            }
            if (bl) {
                m_bBadMove = false;
            }
        } else if (m_bIncrementChain) {
            GModel.handleChainMeter(false, true);
        }
    }

    static int getGemColour(long l) {
        int n = 0;
        do {
            if ((BOARD[n] & l) == 0L) continue;
            return n;
        } while (n++ < GEM_COLOUR_COUNT);
        return -1;
    }

    static int getGemColour(long l, long[] lArray) {
        int n = 0;
        do {
            if ((lArray[n] & l) == 0L) continue;
            return n;
        } while (n++ < GEM_COLOUR_COUNT);
        return -1;
    }

    static int getSpecialState(long l, boolean bl, boolean bl2, boolean bl3) {
        for (int i = 7; i < 17; ++i) {
            if (i == 7 && !bl || (i == 14 || i == 15) && !bl3 || (i == 10 || i == 11) && !bl2 || (BOARD[i] & l) == 0L) continue;
            return i;
        }
        return -1;
    }

    static boolean isSpecialResolveGem(long l) {
        int n = Util.findNextSetBit(70400L, 0);
        while (n != -1) {
            if ((BOARD[n] & l) != 0L) {
                return true;
            }
            n = Util.findNextSetBit(70400L, n + 1);
        }
        return false;
    }

    static boolean getGemSpecialExplodingState(long l) {
        return (BOARD[12] & l) != 0L || (BOARD[16] & l) != 0L || (BOARD[9] & l) != 0L || (BOARD[8] & l) != 0L;
    }

    static long getGemFlag(int n, int n2) {
        return 1L << n2 * 8 + n;
    }

    static void setGemProperty(long l, int n) {
        int n2 = n;
        BOARD[n2] = BOARD[n2] | l;
    }

    static boolean getGemProperty(long l, int n) {
        return (BOARD[n] & l) != 0L;
    }

    static boolean getGemProperty(long l, int n, long[] lArray) {
        return (lArray[n] & l) != 0L;
    }

    static void unsetGemProperty(long l, int n) {
        int n2 = n;
        BOARD[n2] = BOARD[n2] & (l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static void unsetSpecialGem(long l) {
        int n = 7;
        do {
            int n2 = n;
            BOARD[n2] = BOARD[n2] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        } while (n++ < 17);
        int n3 = Util.findNextSetBit(l, 0);
        GModel.GEM_COUNTDOWN_MOVES[n3] = -1;
    }

    static void setGemOnBoard(long[] lArray, int n, long l) {
        int n2 = 0;
        while (n2 < GEM_COLOUR_COUNT) {
            int n3 = n2++;
            lArray[n3] = lArray[n3] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        int n4 = n;
        lArray[n4] = lArray[n4] | l;
        n2 = Util.findNextSetBit(l, 0);
        GCanvasController.setGemAnimation(n2, 23, 0);
        GModel.GEM_COUNTDOWN_MOVES[n2] = -1;
    }

    static boolean rotate(int n, boolean bl, long[] lArray, boolean bl2) {
        boolean bl3;
        int n2 = n + 1;
        int n3 = n + 8;
        int n4 = n + 8 + 1;
        boolean bl4 = GModel.getGemProperty(1L << n, 10, lArray) || GModel.getGemProperty(1L << n, 14, lArray);
        boolean bl5 = GModel.getGemProperty(1L << n2, 10, lArray) || GModel.getGemProperty(1L << n2, 14, lArray);
        boolean bl6 = GModel.getGemProperty(1L << n3, 10, lArray) || GModel.getGemProperty(1L << n3, 14, lArray);
        boolean bl7 = bl3 = GModel.getGemProperty(1L << n4, 10, lArray) || GModel.getGemProperty(1L << n4, 14, lArray);
        if (!(bl4 || bl5 || bl6 || bl3)) {
            if (bl) {
                GModel.setRotateProperty(n, 17, true);
                GModel.setRotateProperty(n2, 20, true);
                GModel.setRotateProperty(n4, 18, true);
                GModel.setRotateProperty(n3, 19, true);
            }
            if (bl2) {
                GModel.switchGems(n, n + 1);
                GModel.switchGems(n, n + 8 + 1);
                GModel.switchGems(n, n + 8);
            } else {
                for (int i = 0; i < 16; ++i) {
                    lArray[i] = GModel.switchGemBitfield(n, n + 1, lArray[i]);
                    lArray[i] = GModel.switchGemBitfield(n, n + 8 + 1, lArray[i]);
                    lArray[i] = GModel.switchGemBitfield(n, n + 8, lArray[i]);
                }
            }
            if (bl2 && Particles.lPlasmaParticleGems != 0L) {
                long l = 0L;
                if ((Particles.lPlasmaParticleGems & 1L << n) != 0L) {
                    Particles.killPlasmaParticles(n);
                    l |= 1L << n + 1;
                }
                if ((Particles.lPlasmaParticleGems & 1L << n + 1) != 0L) {
                    Particles.killPlasmaParticles(n + 1);
                    l |= 1L << n + 8 + 1;
                }
                if ((Particles.lPlasmaParticleGems & 1L << n + 8 + 1) != 0L) {
                    Particles.killPlasmaParticles(n + 8 + 1);
                    l |= 1L << n + 8;
                }
                if ((Particles.lPlasmaParticleGems & 1L << n + 8) != 0L) {
                    Particles.killPlasmaParticles(n + 8);
                    l |= 1L << n;
                }
                Particles.resetPlasmaParticles(l);
            }
            if (bl2) {
                GModel.findMatches(lArray, true);
                if (m_nMatchesCount == 0) {
                    SoundManager.handleSoundEvent(7);
                }
                m_nMatchesCount = 0;
                GCanvasController.setCursorAnim(1, 0, -1);
            }
            return true;
        }
        if (bl2) {
            int n5 = FP.fpMul(GCanvasController.CASCADE_FP_PUSH, 5120);
            if (bl4) {
                GCanvasController.pushGemOut(n, 0, 0, n5, 5, 16L, true, n5);
            }
            if (bl5) {
                GCanvasController.pushGemOut(n2, 0, 0, n5, 5, 16L, true, n5);
            }
            if (bl6) {
                GCanvasController.pushGemOut(n3, 0, 0, n5, 5, 16L, true, n5);
            }
            if (bl3) {
                GCanvasController.pushGemOut(n4, 0, 0, n5, 5, 16L, true, n5);
            }
            SoundManager.handleSoundEvent(31);
            GCanvasController.setCursorAnim(2, 0, -1);
        }
        return false;
    }

    static void setRotateProperty(int n, int n2, boolean bl) {
        long l = 1L << n;
        GModel.unsetGemProperty(l, 17);
        GModel.unsetGemProperty(l, 18);
        GModel.unsetGemProperty(l, 19);
        GModel.unsetGemProperty(l, 20);
        if (bl) {
            GModel.setGemProperty(l, n2);
        }
    }

    static void newGame(int n, int n2, boolean bl) {
        int n3;
        if (bl) {
            for (n3 = 0; n3 < GEM_BITFIELD_SIZE; ++n3) {
                GModel.TEMP_BOARD[n3] = BOARD[n3];
            }
        }
        GameController.resetAllGameVariables();
        if (bl) {
            for (n3 = 0; n3 < GEM_BITFIELD_SIZE; ++n3) {
                GModel.BOARD[n3] = TEMP_BOARD[n3];
            }
        }
        RMS.loadGameData(n, true);
        GameController.m_nGameMode = n;
        ScoreController.m_nCurrentScore = 0;
        GameController.m_nCurrentLevel = 0;
        m_nChains = 0;
        m_nChainMultiplier = 0;
        m_nChainsConsecutive = 0;
        m_bLevelUpNewGame = true;
        GModel.generateLives();
        if (!bl) {
            GModel.generateBoard(BOARD, -1L, false);
            GModel.setLevelVariables(n, n2, true);
        } else {
            Challenge.m_nChallengeStage = n2;
        }
        Hint.flagHint(7);
        Hint.flagHint(8);
        if (n == 1) {
            Hint.flagHint(20);
        } else if (n == 3) {
            Hint.flagHint(22);
        }
        GameController.m_nCurrentState = 2;
        GameController.m_nBoardStateFrame = -1;
        if (!bl || GameController.m_nLevelUpState == 2) {
            UIView.m_bDoStarFieldLoading = true;
            GameController.changeLevelUpState(0);
        } else {
            m_StartingNewGameFromOldOne = true;
            GameController.changeLevelUpState(4);
        }
    }

    static void resumeGame(int n) {
        loadGameSetAfterUITransition = true;
        GModel.resumeGame(n, false);
    }

    static void resumeGame(int n, boolean bl) {
        GameController.resetAllGameVariables();
        GameController.m_nGameMode = n;
        RMS.loadGameData(n, false);
        GModel.setLevelVariables(n, GameController.m_nCurrentLevel, false);
        HUDController.setHudDrawVarsToGameVars();
        Background.resumeBackground(Background.m_nCurrentBackgroundIndex);
        RMS.loadGameData(n, false);
        RMS.loadGameData(n, true);
        GCanvasController.redrawEverything();
        if (bl) {
            GameController.changeState(11);
        } else if (GameController.m_bAnimatingPlayersMove) {
            GameController.twistGems(GameController.m_nCursorY * 8 + GameController.m_nCursorX, true);
        } else {
            GModel.checkIfMoveAvailable(false);
            GameController.changeState(3);
        }
        Particles.resetPlasmaParticles(BOARD[16]);
        HUDController.setHudMultiplierPodAnim(11);
    }

    static void setLevelVariables(int n, int n2, boolean bl) {
        if (n == 3) {
            if (bl) {
                m_nBlitzFrameCounter = 4500;
            }
            m_nCurrentGemFill = m_nStaggerGemFill = m_nBlitzFrameCounter;
            m_nHudTimer = m_nBlitzFrameCounter / 15;
            m_nLevelCompleteFill = 4500;
        } else if (n == 2) {
            Challenge.m_nChallengeStage = n2;
            Challenge.setChallengeSpecifics(Challenge.getLevel(), false);
        } else if (n != 3) {
            m_nStaggerGemFill = 0;
            m_nCurrentGemFill = 0;
            int n3 = Math.max(n2 + 1, 1);
            m_nLevelCompleteFill = n3 * 7 + 50;
            m_nDoomGemsCreatedThisLevel = 0;
            if (n3 >= 2) {
                Hint.m_nHintsShown = 10;
            }
        }
    }

    static final void generateLives() {
        if (GameController.m_nGameMode == 0) {
            if (!GameController.m_bOneGameOfClassicCompleted) {
                m_nLives = 3;
            } else {
                int n = Util.GetRandom(100, TWIST_LOGIC_RANDOMER);
                for (int i = 0; i < "\b<T`d".length(); ++i) {
                    if (n >= "\b<T`d".charAt(i)) continue;
                    m_nLives = i + 2;
                    break;
                }
            }
        }
    }

    static void generateBoard(long[] lArray, long l, boolean bl) {
        for (int i = 0; i < 100; ++i) {
            GModel.generateBoardReal(lArray, l, bl);
            if (GModel.checkIfMoveAvailable(true)) break;
        }
    }

    static boolean generateBoardReal(long[] lArray, long l, boolean bl) {
        block7: {
            int n = NORMAL_GEM_COLOURS_BITFIELD;
            int n2 = -1;
            boolean bl2 = true;
            boolean bl3 = l == -1L;
            boolean bl4 = GameController.m_nCurrentLevel == 0 && bl3 && !m_bLevelUpNewGame;
            boolean bl5 = !bl4 && GameController.m_nCurrentLevel > 0;
            m_nStackSize = 0;
            while (true) {
                long l2 = 1L << m_nStackSize;
                boolean bl6 = false;
                if ((l & l2) != 0L) {
                    while (n != 0) {
                        int n3 = (GameController.m_nGameMode == 1 || GameController.m_nGameMode == 0) && !bl5 && !bl4 ? Util.GetRandom(Util.countSetBits(n) - 0 - 1, TWIST_LOGIC_RANDOMER) : Util.GetRandom(Util.countSetBits(n) - 0, TWIST_LOGIC_RANDOMER);
                        int n4 = -1;
                        for (n2 = 0; n2 < NORMAL_GEM_COLOURS && ((1 << n2 & n) == 0 || ++n4 != n3); ++n2) {
                        }
                        n &= ~(1 << n2);
                        if (!GModel.checkNode(lArray, m_nStackSize, n2, l, bl)) continue;
                        GModel.setGemOnBoard(lArray, n2, l2);
                        GModel.stackPush(n);
                        bl2 = true;
                        n = NORMAL_GEM_COLOURS_BITFIELD;
                        bl6 = true;
                        break;
                    }
                } else if (bl2) {
                    GModel.stackPush(n);
                    bl2 = true;
                    n = NORMAL_GEM_COLOURS_BITFIELD;
                    bl6 = true;
                }
                if (m_nStackSize >= 64) break block7;
                if (bl6) continue;
                if (m_nStackSize <= 0) break;
                n = GModel.stackPop();
                bl2 = false;
            }
            return false;
        }
        return true;
    }

    static boolean checkNode(long[] lArray, int n, int n2, long l, boolean bl) {
        long l2;
        int n3 = n / 8;
        int n4 = n % 8;
        if (n4 > 0 && n4 < 7 && (l & (l2 = 5L << n - 1)) == l2 && (lArray[n2] & l2) == l2) {
            return false;
        }
        if (n3 > 0 && n3 < 7 && (l & (l2 = 65537L << n - 8)) == l2 && (lArray[n2] & l2) == l2) {
            return false;
        }
        if (n4 < 6 && (l & (l2 = 3L << n + 1)) == l2 && (lArray[n2] & l2) == l2) {
            return false;
        }
        if (n4 > 1 && (l & (l2 = 3L << n - 2)) == l2 && (lArray[n2] & l2) == l2) {
            return false;
        }
        if (n3 < 6 && (l & (l2 = 257L << n + 8)) == l2 && (lArray[n2] & l2) == l2) {
            return false;
        }
        if (n3 > 1 && (l & (l2 = 257L << n - 16)) == l2 && (lArray[n2] & l2) == l2) {
            return false;
        }
        if (n3 < 7 && n4 < 7 && (l & (l2 = 771L << n & (1L << n ^ 0xFFFFFFFFFFFFFFFFL))) == l2 && (lArray[n2] & l2) == l2) {
            return false;
        }
        if (n3 < 7 && n4 > 0 && (l & (l2 = 771L << n - 1 & (1L << n ^ 0xFFFFFFFFFFFFFFFFL))) == l2 && (lArray[n2] & l2) == l2) {
            return false;
        }
        if (n4 < 7 && n3 > 0 && (l & (l2 = 771L << n - 8 & (1L << n ^ 0xFFFFFFFFFFFFFFFFL))) == l2 && (lArray[n2] & l2) == l2) {
            return false;
        }
        return n4 <= 0 || n3 <= 0 || (l & (l2 = 771L << n - 8 - 1 & (1L << n ^ 0xFFFFFFFFFFFFFFFFL))) != l2 || (lArray[n2] & l2) != l2;
    }

    static void updateGemPositions() {
    }

    static void moveGemProperties() {
        for (int i = 63; i >= 0; --i) {
            int n = BOARD_RESOLUTION_MOVES[i];
            int n2 = i;
            if (n <= 0) continue;
            int n3 = i + 8 * n;
            for (int j = 0; j < n; ++j) {
                n2 = i + 8 * j;
                long l = 1L << n2;
                long l2 = 1L << n2 + 8;
                int n4 = GModel.getGemColour(l);
                int n5 = GModel.getGemColour(l2);
                int n6 = n4;
                BOARD[n6] = BOARD[n6] & (l ^ 0xFFFFFFFFFFFFFFFFL);
                if (n5 >= 0) {
                    int n7 = n5;
                    BOARD[n7] = BOARD[n7] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
                    int n8 = n5;
                    BOARD[n8] = BOARD[n8] | l;
                }
                int n9 = n4;
                BOARD[n9] = BOARD[n9] | l2;
                if (n2 < 56) {
                    GModel.swapArrayPropertiesUp(GCanvasController.GEMS_CURRENT_FRAME, n2);
                    GModel.swapArrayPropertiesUp(GCanvasController.TILES_CURRENT_FRAME, n2);
                    GModel.swapArrayPropertiesUp(GCanvasController.OVERLAYS_CURRENT_FRAME, n2);
                    GModel.swapArrayPropertiesUp(GEM_COUNTDOWN_MOVES, n2);
                    GModel.swapArrayPropertiesUp(BOARD_RESOLUTION_MOVES, n2);
                    GModel.swapArrayPropertiesUp(GCanvasController.GEMS_FP_FALL_OFFSET, n2);
                    GModel.swapArrayPropertiesUp(GCanvasController.GEMS_FP_FALL_SPEED, n2);
                }
                if ((BOARD[12] & 1L << n2) != 0L) {
                    Particles.killParticleType(12, n2, true);
                }
                if ((BOARD[12] & 1L << n2 + 8) != 0L) {
                    Particles.killParticleType(12, n2 + 8, true);
                }
                for (int k = 0; k < GEM_STATE_COUNT; ++k) {
                    long l3 = 0L;
                    if ((BOARD[GEM_COLOUR_COUNT + k] & l) != 0L) {
                        l3 |= l2;
                    }
                    if ((BOARD[GEM_COLOUR_COUNT + k] & l2) != 0L) {
                        l3 |= l;
                    }
                    int n10 = GEM_COLOUR_COUNT + k;
                    BOARD[n10] = BOARD[n10] & ((l | l2) ^ 0xFFFFFFFFFFFFFFFFL);
                    int n11 = GEM_COLOUR_COUNT + k;
                    BOARD[n11] = BOARD[n11] | l3;
                }
            }
            if (GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[i] > 0 || GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[n3] > 0) {
                GModel.swapArrayProperties(GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES, i, n3);
                GModel.swapArrayProperties(GCanvasController.VECTOR_COUNTDOWN_PULSE_COL, i, n3);
                GModel.swapArrayProperties(GCanvasController.VECTOR_COUNTDOWN_PULSE_TIMES, i, n3);
            }
            if (GCanvasController.COUNTDOWN_PULSE_CHANCE[i] > 0 || GCanvasController.COUNTDOWN_PULSE_CHANCE[n3] > 0) {
                GModel.swapArrayProperties(GCanvasController.COUNTDOWN_PULSE_CHANCE, i, n3);
            }
            if ((GCanvasController.m_lFruitIdleToSparkle & 1L << i) != 0L || (GCanvasController.m_lFruitIdleToSparkle & 1L << n3) != 0L) {
                GCanvasController.m_lFruitIdleToSparkle = GModel.switchGemBitfield(i, n3, GCanvasController.m_lFruitIdleToSparkle);
            }
            Particles.switchPlasmaParticles(i, n3);
        }
        GModel.explodeGemsUp();
    }

    static final void swapArrayPropertiesUp(int[] nArray, int n) {
        int n2 = n + 8;
        nArray[n2] = nArray[n2] + nArray[n];
        nArray[n] = nArray[n + 8] - nArray[n];
        int n3 = n + 8;
        nArray[n3] = nArray[n3] - nArray[n];
    }

    static final void swapArrayProperties(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    static final void explodeGemsUp() {
        long l = 0L;
        int n = 0;
        for (int i = 55; i >= 0; --i) {
            l = GModel.getAllGemsBelow(i);
            n = Util.findNextSetBit(l, 0);
            while (n != -1) {
                if (GCanvasController.GEMS_FP_FALL_SPEED[n] < 0 && GCanvasController.GEMS_FP_FALL_SPEED[n] < GCanvasController.GEMS_FP_FALL_SPEED[i]) {
                    GCanvasController.GEMS_FP_FALL_SPEED[i] = GCanvasController.GEMS_FP_FALL_SPEED[n];
                }
                if (GCanvasController.GEMS_FP_FALL_OFFSET[n] < 0 && GCanvasController.GEMS_FP_FALL_OFFSET[n] < GCanvasController.GEMS_FP_FALL_OFFSET[i]) {
                    GCanvasController.GEMS_FP_FALL_OFFSET[i] = GCanvasController.GEMS_FP_FALL_OFFSET[n];
                }
                n = Util.findNextSetBit(l, n + 1);
            }
        }
    }

    static void addQueuedGem(int n) {
        boolean bl = true;
        if (GameController.m_bLevelUp) {
            if (n == 13) {
                m_bCreateCountdownAtEndOfMove = false;
                bl = false;
            } else if (n == 7) {
                m_bCreateCoalAtEndOfMove = false;
                bl = false;
            }
            return;
        }
        long l = BOARD[22];
        if (bl) {
            if (n == 13) {
                m_bCreateCountdownAtEndOfMove = false;
            } else if (n == 7) {
                m_bCreateCoalAtEndOfMove = false;
            }
            if (GameController.m_bLevelUp) {
                return;
            }
            boolean bl2 = false;
            int n2 = Util.bitsSetLong(l);
            int n3 = 0;
            int n4 = 0;
            while (n2 > 0 && !bl2) {
                int n5;
                if (n4++ > 30) {
                    return;
                }
                int n6 = Util.GetRandom(n2, TWIST_LOGIC_RANDOMER);
                n3 = Util.findNextSetBit(l, 0);
                for (n5 = 1; n5 <= n6; ++n5) {
                    n3 = Util.findNextSetBit(l, n3 + 1);
                }
                long l2 = 1L << n3;
                if (GModel.getSpecialState(l2, true, true, true) == -1) {
                    bl2 = true;
                }
                for (n5 = 0; n5 < m_nMatchesCount; ++n5) {
                    if ((l2 & MATCHES[n5]) == 0L) continue;
                    bl2 = false;
                }
                if (n == 13 && GameController.m_nGameMode == 0 && Util.bitsSetLong(BOARD[GModel.getGemColour(l2)]) < 7) {
                    bl2 = false;
                }
                if (!bl2 || n != 7) continue;
                n5 = GModel.getGemColour(l2);
                GModel.changeGemColour(n3, 7);
                for (int i = 0; i < 16; ++i) {
                    GModel.TEMP_BOARD[i] = BOARD[i];
                }
                if (GModel.checkIfMoveAvailable(true)) {
                    GCanvasController.setGemAnimation(n3, 39, 0);
                    Hint.flagHint(16);
                    continue;
                }
                bl2 = false;
                GModel.changeGemColour(n3, n5);
            }
            if (n == 13) {
                m_lCountdownsCreatedThisTurn |= 1L << n3;
                n3 = Util.findNextSetBit(m_lCountdownsCreatedThisTurn, 0);
                GModel.GEM_COUNTDOWN_MOVES[n3] = GModel.getCountdownGemStartValue(13);
                GModel.setGemProperty(1L << n3, 13);
                GCanvasController.setGemAnimation(n3, 27, 0);
                GCanvasController.COUNTDOWN_FONT_FRAME[n3] = 0;
                Hint.flagHint(0);
            }
        }
    }

    static int addPreLockedGem(long l) {
        int n = 0;
        boolean bl = false;
        int n2 = Util.bitsSetLong(l);
        while (n2 > 0 && !bl && n++ <= 64) {
            int n3 = Util.GetRandom(n2, TWIST_LOGIC_RANDOMER) + 1;
            int n4 = Util.findNextSetBit(l, 0);
            for (int i = 1; i < n3; ++i) {
                n4 = Util.findNextSetBit(l, n4 + 1);
            }
            if (GModel.getSpecialState(1L << n4, true, true, true) != -1) continue;
            bl = true;
            BOARD[11] = BOARD[11] | 1L << n4;
            GCanvasController.setGemAnimation(n4, 33, 0);
            GCanvasController.setCountdownVectorPulse(n4, 3, false, -1);
            SoundManager.handleSoundEvent(33);
            return 0;
        }
        return -1;
    }

    static final void setLockedGems() {
        long l = 0L;
        int n = Util.findNextSetBit(BOARD[11], 0);
        while (n != -1) {
            l = 1L << n;
            if ((BOARD[21] & l) == 0L) {
                GModel.unsetGemProperty(l, 11);
                BOARD[10] = BOARD[10] | l;
                GCanvasController.setCountdownVectorPulse(n, 1, false, -1);
                GCanvasController.setGemAnimation(n, 25, 0);
                Hint.flagHint(5);
                SoundManager.handleSoundEvent(31);
                return;
            }
            n = Util.findNextSetBit(BOARD[11], n + 1);
        }
    }

    static final void setDoomGems() {
        long l = 0L;
        int n = Util.findNextSetBit(BOARD[15], 0);
        while (n != -1) {
            l = 1L << n;
            GModel.unsetGemProperty(l, 15);
            if (GModel.getSpecialState(l, false, false, false) == -1) {
                BOARD[14] = BOARD[14] | l;
                GModel.GEM_COUNTDOWN_MOVES[n] = GModel.getCountdownGemStartValue(14);
                GCanvasController.COUNTDOWN_FONT_FRAME[n] = 0;
                GCanvasController.setGemAnimation(n, 57, 0);
                Hint.flagHint(25);
            }
            n = Util.findNextSetBit(BOARD[15], n + 1);
        }
    }

    static int addSpecialGem(long l, int n, int n2, boolean bl, boolean bl2) {
        int n3 = 0;
        boolean bl3 = false;
        int n4 = Util.bitsSetLong(l);
        int n5 = -1;
        while (!bl3 && n3++ <= n4 && n4 > 0) {
            int n6 = Util.GetRandom(n4, TWIST_LOGIC_RANDOMER) + 1;
            n5 = Util.findNextSetBit(l, 0);
            for (int i = 1; i < n6; ++i) {
                n5 = Util.findNextSetBit(l, n5 + 1);
            }
            if (!bl && GModel.getSpecialState(1L << n5, true, true, true) != -1) continue;
            if (bl && bl2) {
                GModel.unsetSpecialGem(1L << n5);
            }
            bl3 = true;
            if (!bl2) continue;
            int n7 = n;
            BOARD[n7] = BOARD[n7] | 1L << n5;
            if (n2 == -1) continue;
            GCanvasController.setGemAnimation(n5, n2, 0);
        }
        if (!bl3) {
            return -1;
        }
        if (bl3 && bl2) {
            if (n == 7) {
                GModel.changeGemColour(n5, 7);
                GCanvasController.setGemAnimation(n5, 39, 0);
                Hint.flagHint(16);
            } else if (n == 13) {
                GModel.GEM_COUNTDOWN_MOVES[n5] = GModel.getCountdownGemStartValue(13);
                GCanvasController.setCountdownVectorPulse(n5, 1, false, -1);
            } else if (n == 14) {
                GModel.GEM_COUNTDOWN_MOVES[n5] = GModel.getCountdownGemStartValue(14);
            } else if (n == 12) {
                m_lSpecialGemsNewlyCreated |= 1L << n5;
            }
        }
        return n5;
    }

    static void changeGemColour(int n, int n2) {
        for (int i = 0; i < GEM_COLOUR_COUNT; ++i) {
            if ((BOARD[i] & 1L << n) == 0L) continue;
            int n3 = i;
            BOARD[n3] = BOARD[n3] & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
            int n4 = n2;
            BOARD[n4] = BOARD[n4] | 1L << n;
            break;
        }
    }

    static void setupInGameTouch() {
        int n = GCanvas.BOARD_POSITION_X + 22;
        int n2 = GCanvas.BOARD_POSITION_Y + 22;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 7; ++i) {
            n4 = 44;
            if (i == 0) {
                n2 -= 22;
                n4 += 22;
            } else if (i == 6) {
                n4 += 22;
            }
            for (int j = 0; j < 7; ++j) {
                n3 = 44;
                if (j == 0) {
                    n -= 22;
                    n3 += 22;
                } else if (j == 6) {
                    n3 += 22;
                }
                Touch.addZone(n, n2, n3, n4, Touch.zoneNb);
                n += n3;
            }
            n2 += n4;
            n = GCanvas.BOARD_POSITION_X + 22;
        }
    }

    public static void updateCountdownMoves(boolean bl) {
        if (!m_bSkipCountdownThisFrame) {
            int n = Util.findNextSetBit(BOARD[13], 0);
            while (n != -1) {
                if (GEM_COUNTDOWN_MOVES[n] > 0 && (m_lCountdownsCreatedThisTurn & 1L << n) == 0L) {
                    int n2 = n;
                    GEM_COUNTDOWN_MOVES[n2] = GEM_COUNTDOWN_MOVES[n2] - 1;
                    if (GEM_COUNTDOWN_MOVES[n] == 5) {
                        Hint.flagHint(24);
                    }
                    GCanvasController.addDirtyGem(n);
                }
                n = Util.findNextSetBit(BOARD[13], n + 1);
            }
            GCanvasController.pulseCountDownGems();
            if (bl) {
                GModel.updateDoomMoves();
            }
        }
        if (m_lCountdownsCreatedThisTurn != 0L) {
            SoundManager.handleSoundEvent(34);
        }
        m_bSkipCountdownThisFrame = false;
        m_lCountdownsCreatedThisTurn = 0L;
    }

    public static void updateDoomMoves() {
        int n = Util.findNextSetBit(BOARD[14], 0);
        while (n != -1) {
            if (GEM_COUNTDOWN_MOVES[n] > 0 && (m_lCountdownsCreatedThisTurn & 1L << n) == 0L) {
                int n2 = n;
                GEM_COUNTDOWN_MOVES[n2] = GEM_COUNTDOWN_MOVES[n2] - 1;
                GCanvasController.addDirtyGem(n);
            }
            n = Util.findNextSetBit(BOARD[14], n + 1);
        }
    }

    public static int checkForZeroCountGem(int n) {
        int n2 = Util.findNextSetBit(BOARD[n], 0);
        while (n2 != -1) {
            if (GEM_COUNTDOWN_MOVES[n2] == 0) {
                GModel.GEM_COUNTDOWN_MOVES[n2] = -1;
                return n2;
            }
            n2 = Util.findNextSetBit(BOARD[n], n2 + 1);
        }
        return -1;
    }

    static void switchGems(int n, int n2) {
        if ((BOARD[12] & 1L << n) != 0L) {
            Particles.killParticleType(12, n, true);
        }
        if ((BOARD[12] & 1L << n2) != 0L) {
            Particles.killParticleType(12, n2, true);
        }
        for (int i = 0; i < GEM_BITFIELD_SIZE; ++i) {
            GModel.BOARD[i] = GModel.switchGemBitfield(n, n2, BOARD[i]);
        }
        GModel.swapArrayProperties(GEM_COUNTDOWN_MOVES, n, n2);
        GModel.swapArrayProperties(GCanvasController.GEMS_CURRENT_FRAME, n, n2);
        GModel.swapArrayProperties(GCanvasController.TILES_CURRENT_FRAME, n, n2);
        GModel.swapArrayProperties(GCanvasController.OVERLAYS_CURRENT_FRAME, n, n2);
        if (GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[n] >= 0 || GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES[n2] >= 0) {
            GModel.swapArrayProperties(GCanvasController.VECTOR_COUNTDOWN_PULSE_FRAMES, n, n2);
            GModel.swapArrayProperties(GCanvasController.VECTOR_COUNTDOWN_PULSE_COL, n, n2);
            GModel.swapArrayProperties(GCanvasController.VECTOR_COUNTDOWN_PULSE_TIMES, n, n2);
        }
        if (GCanvasController.COUNTDOWN_PULSE_CHANCE[n] > 0 || GCanvasController.COUNTDOWN_PULSE_CHANCE[n2] > 0) {
            GModel.swapArrayProperties(GCanvasController.COUNTDOWN_PULSE_CHANCE, n, n2);
        }
        if (GCanvasController.m_lFruitIdleToSparkle != 0L) {
            GCanvasController.m_lFruitIdleToSparkle = GModel.switchGemBitfield(n, n2, GCanvasController.m_lFruitIdleToSparkle);
        }
    }

    static long switchGemBitfield(int n, int n2, long l) {
        long l2 = 1L << n2;
        long l3 = 1L << n;
        boolean bl = (l & l3) != 0L;
        boolean bl2 = (l & l2) != 0L;
        l &= (l3 | l2) ^ 0xFFFFFFFFFFFFFFFFL;
        if (bl) {
            l |= l2;
        }
        if (bl2) {
            l |= l3;
        }
        return l;
    }

    static void resolveLightningGems(long l, boolean bl) {
        long l2 = 0L;
        int n = 0;
        long l3 = 0L;
        int n2 = 0;
        long l4 = 0L;
        BOARD[21] = BOARD[21] | l & (m_lSpecialGemsNewlyCreated ^ 0xFFFFFFFFFFFFFFFFL);
        int n3 = Util.findNextSetBit(l, 0);
        while (n3 != -1) {
            int n4 = n3 % 8;
            int n5 = n3 / 8;
            l3 |= 255L << n5 * 8;
            l3 |= 0x101010101010101L << n4;
            if ((m_lSpecialGemsNewlyCreated & 1L << n3) == 0L) {
                GCanvasController.setGemAnimation(n3, 42, 0);
            }
            n2 = Util.findNextSetBit(l3, 0);
            while (n2 != -1 && n2 < 64) {
                l4 = 1L << n2;
                if ((m_lSpecialGemsNewlyCreated & l4) == 0L && (BOARD[28] & l4) == 0L) {
                    n = -((Math.abs(n2 / 8 - n5) + Math.abs(n2 % 8 - n4)) * 2);
                    if ((BOARD[40] & l4) != 0L) {
                        GCanvasController.setGemAnimation(n2, 23, 0);
                    }
                    if ((BOARD[7] & l4) != 0L) {
                        GCanvasController.setExplodeGemAnim(n2, 2 * n, -1);
                    } else if ((bl || GCanvasController.GEMS_NEXT_ANIM_STATE[n2] != 42 && (BOARD[42] & l4) != 42L) && n2 != n3 && (BOARD[12] & l4) == 0L) {
                        if ((BOARD[51] & l4) != 0L) {
                            GCanvasController.setGemAnimation(n2, 23, 0);
                        }
                        GCanvasController.setGemAnimation(n2, 42, n);
                    }
                    if ((BOARD[21] & l4) == 0L && GEMS_NEXT_STATE[n2] != 21) {
                        GModel.setGemsNextState(n2, 21, n);
                        ScoreController.linkGemToMatchScore(n2, ScoreController.SCORED_GEM_LINKED_MATCH[n3]);
                        if (n == 0) {
                            ScoreController.increaseMatchScore(n2);
                        }
                    }
                }
                n2 = Util.findNextSetBit(l3, n2 + 1);
            }
            if ((m_lSpecialGemsNewlyCreated & 1L << n3) == 0L) {
                l2 |= 1L << n3;
                GCanvasController.m_lAnimatedLightningsExploded = GCanvasController.m_lAnimatedLightningsExploded == -1L ? 1L << n3 : (GCanvasController.m_lAnimatedLightningsExploded |= 1L << n3);
                GCanvasController.m_nAnimatedLightningFrame = 0;
            }
            n3 = Util.findNextSetBit(l, n3 + 1);
        }
        GameController.updateExplodingLightningStats(l2);
        if (bl) {
            BOARD[9] = BOARD[9] & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
            m_lUnhandledSpecialGems &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            GCanvasController.m_lSuperLightningUp = l2;
            GCanvasController.m_lSuperLightningDown = l2;
            GCanvasController.m_lSuperLightningLeft = l2;
            GCanvasController.m_lSuperLightningRight = l2;
            SoundManager.handleSoundEvent(36);
            Audio.HandleVibration(1000);
        }
    }

    static void resolveSuperGems(long l) {
        int n = Util.findNextSetBit(l, 0);
        while (n != -1) {
            long l2;
            int n2 = ScoreController.SCORED_GEM_LINKED_MATCH[n];
            Particles.killPlasmaParticles(n);
            int n3 = n / 8;
            int n4 = n % 8;
            long l3 = 1L << n;
            if (n4 > 0) {
                l2 = 1L << n - 1;
                l3 |= l2;
                GCanvasController.m_lSuperLightningLeft |= l2;
                ScoreController.linkGemToMatchScore(n - 1, n2);
                ScoreController.increaseMatchScore(n - 1);
            }
            if (n4 < 7 && n + 1 < 64) {
                l2 = 1L << n + 1;
                l3 |= l2;
                GCanvasController.m_lSuperLightningRight |= l2;
                ScoreController.linkGemToMatchScore(n + 1, n2);
                ScoreController.increaseMatchScore(n + 1);
            }
            if (n3 > 0) {
                l2 = 1L << n - 8;
                l3 |= l2;
                GCanvasController.m_lSuperLightningUp |= l2;
                ScoreController.linkGemToMatchScore(n - 8, n2);
                ScoreController.increaseMatchScore(n - 8);
            }
            if (n3 < 7 && n + 8 < 64) {
                l2 = 1L << n + 8;
                l3 |= l2;
                GCanvasController.m_lSuperLightningDown |= l2;
                ScoreController.linkGemToMatchScore(n + 8, n2);
                ScoreController.increaseMatchScore(n + 8);
            }
            if (n4 < 7 && n - 8 + 1 < 64 && n3 > 0) {
                l2 = 1L << n - 8 + 1;
                l3 |= l2;
                GCanvasController.m_lSuperLightningUp |= l2;
                GCanvasController.m_lSuperLightningRight |= l2;
                ScoreController.linkGemToMatchScore(n - 8 + 1, n2);
                ScoreController.increaseMatchScore(n - 8 + 1);
            }
            if (n4 > 0 && n3 > 0) {
                l2 = 1L << n - 8 - 1;
                l3 |= l2;
                GCanvasController.m_lSuperLightningUp |= l2;
                GCanvasController.m_lSuperLightningLeft |= l2;
                ScoreController.linkGemToMatchScore(n - 8 - 1, n2);
                ScoreController.increaseMatchScore(n - 8 - 1);
            }
            if (n3 < 7 && n4 < 7 && n + 8 + 1 < 64) {
                l2 = 1L << n + 8 + 1;
                l3 |= l2;
                GCanvasController.m_lSuperLightningDown |= l2;
                GCanvasController.m_lSuperLightningRight |= l2;
                ScoreController.linkGemToMatchScore(n + 8 + 1, n2);
                ScoreController.increaseMatchScore(n + 8 + 1);
            }
            if (n3 < 7 && n4 > 0 && n + 8 - 1 < 64) {
                l2 = 1L << n + 8 - 1;
                l3 |= l2;
                GCanvasController.m_lSuperLightningDown |= l2;
                GCanvasController.m_lSuperLightningLeft |= l2;
                ScoreController.linkGemToMatchScore(n + 8 - 1, n2);
                ScoreController.increaseMatchScore(n + 8 - 1);
            }
            long l4 = BOARD[12] | BOARD[8] | BOARD[16] | BOARD[9];
            m_lUnhandledSpecialGems |= l3 & (l4 & ((BOARD[21] | m_lSpecialGemsNewlyCreated) ^ 0xFFFFFFFFFFFFFFFFL));
            GModel.resolveLightningGems(l3, false);
            BOARD[21] = BOARD[21] & (l3 & m_lSpecialGemsNewlyCreated ^ 0xFFFFFFFFFFFFFFFFL);
            GCanvasController.m_lAnimatedLightningsExploded |= l3;
            n = Util.findNextSetBit(l, n + 1);
        }
        SoundManager.handleSoundEvent(38);
        Audio.HandleVibration(1000);
        BOARD[16] = BOARD[16] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        m_lUnhandledSpecialGems &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    static final void resolveFruitGems(long l, boolean bl) {
        Hint.flagHint(15);
        int n = -1;
        long l2 = -1L;
        long l3 = -1L;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = FP.fpMul(GCanvasController.CASCADE_FP_PUSH, 3072);
        int n9 = -1;
        boolean bl2 = false;
        int n10 = 0;
        BOARD[21] = BOARD[21] | l;
        int n11 = Util.findNextSetBit(l, 0);
        while (n11 != -1) {
            n = GModel.getGemColour(1L << n11);
            if (n != -1) {
                GCanvasController.setExplodeGemAnim(n11, 0, -1);
                n5 = n11 / 8;
                n6 = n11 % 8;
                l3 = BOARD[n] & ((m_lSpecialGemsNewlyCreated | BOARD[14]) ^ 0xFFFFFFFFFFFFFFFFL);
                int n12 = Util.findNextSetBit(l3, 0);
                while (n12 != -1) {
                    l2 = 1L << n12;
                    if ((m_lSpecialGemsNewlyCreated & l2) == 0L) {
                        n3 = n12 / 8;
                        n4 = n12 % 8;
                        n2 = -((Math.abs(n5 - n3) + Math.abs(n6 - n4)) * 2);
                        if ((BOARD[21] & l2) == 0L && GEMS_NEXT_STATE[n12] == -1) {
                            GModel.setGemsNextState(n12, 21, n2 + n10);
                            if (!GModel.getGemSpecialExplodingState(l2)) {
                                GCanvasController.setExplodeGemAnim(n12, n2 + n10, 60);
                            } else {
                                GCanvasController.setExplodeGemAnim(n12, n2 + n10, -1);
                            }
                        }
                        ScoreController.linkGemToMatchScore(n12, ScoreController.SCORED_GEM_LINKED_MATCH[n11]);
                        if (n2 + n10 == 0) {
                            ScoreController.increaseMatchScore(n12);
                        }
                    }
                    n12 = Util.findNextSetBit(l3, n12 + 1);
                }
                n12 = Util.findNextSetBit(BOARD_MASK & (l3 ^ 0xFFFFFFFFFFFFFFFFL), 0);
                while (n12 != -1) {
                    l2 = 1L << n12;
                    n3 = n12 / 8;
                    n4 = n12 % 8;
                    n2 = -((Math.abs(n5 - n3) + Math.abs(n6 - n4)) * 2);
                    if ((BOARD[11] & l2) != 0L) {
                        GModel.unsetGemProperty(l2, 11);
                        GCanvasController.setGemAnimation(n12, 23, n2 + n10);
                    } else if ((BOARD[10] & l2) != 0L) {
                        GModel.unsetGemProperty(l2, 10);
                        GCanvasController.setGemAnimation(n12, 23, n2 + n10);
                    } else if ((BOARD[40] & l2) == 0L && (BOARD[28] & l2) == 0L && (BOARD[49] & l2) == 0L) {
                        bl2 = false;
                        n9 = Util.findNextSetBit(2035625245133504512L, 0);
                        while (n9 != -1) {
                            if ((BOARD[n9] & l2) != 0L) {
                                bl2 = true;
                            }
                            n9 = Util.findNextSetBit(2035625245133504512L, n9 + 1);
                        }
                        if (!bl2 && GCanvasController.GEMS_NEXT_ANIM_STATE[n12] == -1) {
                            if (Math.abs(n6 - n4) < Math.abs(n5 - n3)) {
                                if (n3 < n5) {
                                    GCanvasController.pushGemOut(n12, 0, -n8, -n8, n2, 0L, false, 0);
                                    n7 = 47;
                                } else {
                                    GCanvasController.pushGemOut(n12, 0, n8, n8, n2, 0L, false, 0);
                                    n7 = 46;
                                }
                            } else if (n4 < n6) {
                                GCanvasController.pushGemOut(n12, -n8, 0, -n8, n2, 0L, false, 0);
                                n7 = 45;
                            } else {
                                GCanvasController.pushGemOut(n12, n8, 0, n8, n2, 0L, false, 0);
                                n7 = 44;
                            }
                            if (GModel.getSpecialState(l2, true, false, true) == -1) {
                                GCanvasController.setGemAnimation(n12, n7, n2);
                            }
                        }
                    }
                    n12 = Util.findNextSetBit(BOARD_MASK & (l3 ^ 0xFFFFFFFFFFFFFFFFL), n12 + 1);
                }
            }
            n11 = Util.findNextSetBit(l, n11 + 1);
        }
        m_lUnhandledSpecialGems &= l ^ 0xFFFFFFFFFFFFFFFFL;
        BOARD[12] = BOARD[12] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        if (bl) {
            m_lCurrentFruitExploding = l;
        }
        m_bSkipCountdownThisFrame = true;
        SoundManager.handleSoundEvent(37);
        BOARD[12] = BOARD[12] & (l ^ 0xFFFFFFFFFFFFFFFFL);
    }

    static long getAllGemsAbove(int n) {
        int n2 = n / 8;
        if (n2 == 0) {
            return 0L;
        }
        int n3 = n % 8;
        long l = 0x101010101010101L << n3;
        return (l >>= 8 * (8 - n2)) & BOARD_MASK;
    }

    static long getAllGemsBelow(int n) {
        long l = 0x101010101010101L << n + 8;
        return l & BOARD_MASK;
    }

    static void checkForSpecialExplodingGems(boolean bl) {
        m_lUnhandledSpecialGems = 0L;
        int n = Util.findNextSetBit(BOARD[21], 0);
        while (n != -1) {
            long l = 1L << n;
            if (GModel.getGemSpecialExplodingState(l) && (m_lSpecialGemsNewlyCreated & l) == 0L) {
                if (bl && m_lCurrentFruitExploding == -1L && (BOARD[12] & l) != 0L) {
                    m_lCurrentFruitExploding = l;
                    GameController.queueNextCascadeSound();
                } else {
                    m_lUnhandledSpecialGems |= l;
                }
            }
            n = Util.findNextSetBit(BOARD[21], n + 1);
        }
    }

    static long getInLineMatches(long l) {
        int n = 0;
        int n2 = 0;
        long l2 = 0L;
        int n3 = Util.findNextSetBit(l, 0);
        while (n3 != -1) {
            long l3 = 255L << n3 & l;
            n2 = Util.bitsSetLong(l3);
            if (n2 > n) {
                n = n2;
                l2 = l3;
            }
            if ((n2 = Util.bitsSetLong(l3 = 0x101010101010101L << n3 & l)) > n) {
                n = n2;
                l2 = l3;
            }
            n3 = Util.findNextSetBit(l, n3 + 1);
        }
        return l2;
    }

    static final void handleChainMeter(boolean bl, boolean bl2) {
        if (bl) {
            ++m_nChainsConsecutive;
            if (GameController.m_nGameMode != 2) {
                HUDController.startAnimatingChainLights(bl, bl2);
                if (!m_bAwardFruitGem && ++m_nChains >= "\u0004\b\f\u0010\u0010\u0010\u0010\u0010\u0010\u0010\u0010".charAt(m_nChainMultiplier)) {
                    if (++m_nChainMultiplier == GameController.MAX_CHAIN_MULT) {
                        m_bAwardFruitGem = true;
                    }
                    if (m_nChainMultiplier >= GameController.MAX_CHAIN_MULT_TEXT - 1) {
                        Hint.flagHint(4);
                    }
                    if (m_nChainMultiplier >= GameController.MAX_CHAIN_MULT_TEXT) {
                        Particles.highlightMultiplerInc();
                    }
                    m_nChains = 1;
                    ++GameController.m_nBadGemAmnestyEvents;
                    if (m_nChainMultiplier == 1) {
                        Hint.flagHint(11);
                    }
                }
                if (bl && bl2 && m_nMatchesCount > 0) {
                    HUDController.incHudChainLight();
                }
            }
        } else {
            if (GameController.m_nGameMode != 2) {
                if (m_nChains == 0) {
                    if (m_nChainMultiplier > 0) {
                        SoundManager.handleSoundEvent(49);
                    }
                    m_nChainMultiplier = m_nChainMultiplier >= GameController.MAX_CHAIN_MULT_TEXT ? Math.min(m_nChainMultiplier - 1, GameController.MAX_CHAIN_MULT_TEXT - 1) : Math.max(m_nChainMultiplier - 1, 0);
                } else if (m_nChainMultiplier >= GameController.MAX_CHAIN_MULT_TEXT) {
                    m_nChainMultiplier = Math.min(m_nChainMultiplier - 1, GameController.MAX_CHAIN_MULT_TEXT - 1);
                }
                HUDController.startAnimatingChainLights(bl, false);
                m_nChains = 0;
            }
            m_nChainsConsecutive = 0;
        }
    }

    static final void resetNewBoardSpecialGems(int n, int n2, int n3) {
        long l = BOARD_MASK;
        for (int i = 0; i < n2; ++i) {
            if (n == 12) {
                l = BOARD[GModel.getLeastFreqFruitCol()];
            }
            GModel.addSpecialGem(l & (BOARD[n] ^ 0xFFFFFFFFFFFFFFFFL), n, n3, false, true);
        }
    }

    static final int getLeastFreqFruitCol() {
        int n = Util.GetRandom(NORMAL_GEM_COLOURS, TWIST_LOGIC_RANDOMER);
        int n2 = 0;
        long l = 0L;
        for (int i = 0; i < NORMAL_GEM_COLOURS; ++i) {
            l = BOARD[12] | BOARD[8] | BOARD[9] | BOARD[16];
            n2 = Util.bitsSetLong(BOARD[i] & (l ^ 0xFFFFFFFFFFFFFFFFL));
            if (n2 <= 0 || Util.bitsSetLong(BOARD[12] & BOARD[i]) >= Util.bitsSetLong(BOARD[12] & BOARD[n])) continue;
            n = i;
        }
        return n;
    }

    static final int getLowestCountdownGem() {
        if (BOARD[13] != 0L) {
            int n = 100;
            int n2 = -1;
            int n3 = -1;
            n3 = Util.findNextSetBit(BOARD[13], 0);
            while (n3 != -1) {
                if (GEM_COUNTDOWN_MOVES[n3] < n) {
                    n = GEM_COUNTDOWN_MOVES[n3];
                    n2 = n3;
                }
                n3 = Util.findNextSetBit(BOARD[13], n3 + 1);
            }
            return n2;
        }
        return -1;
    }

    static final void setGemsNextState(int n, int n2, int n3) {
        if (n3 == 0) {
            int n4 = n2;
            BOARD[n4] = BOARD[n4] | 1L << n;
            return;
        }
        GModel.GEMS_NEXT_STATE[n] = n2;
        GModel.GEMS_NEXT_STATE_DELAY[n] = Math.abs(n3);
        m_lGemsDelayedState |= 1L << n;
    }

    static final void updateGemsNextState() {
        if (m_lGemsDelayedState != 0L) {
            long l = 0L;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < GEMS_NEXT_STATE.length; ++i) {
                if (GEMS_NEXT_STATE_DELAY[i] <= 0) continue;
                int n = i;
                GEMS_NEXT_STATE_DELAY[n] = GEMS_NEXT_STATE_DELAY[n] - 1;
                if (GEMS_NEXT_STATE_DELAY[n] != 0 || GEMS_NEXT_STATE[i] == -1) continue;
                l = 1L << i;
                if (GEMS_NEXT_STATE[i] == 21) {
                    if ((BOARD[9] & l) != 0L || (BOARD[16] & l) != 0L) {
                        if (GCanvasController.m_lAnimatedLightningsExploded != -1L || bl) {
                            GModel.GEMS_NEXT_STATE_DELAY[i] = 1;
                            continue;
                        }
                        m_lUnhandledSpecialGems |= l;
                        bl = true;
                    } else if ((BOARD[12] & l) != 0L) {
                        int n2 = Util.findNextSetBit(m_lCurrentFruitExploding, 0);
                        int n3 = GModel.getGemColour(1L << n2);
                        int n4 = GModel.getGemColour(l);
                        if (GCanvasController.m_lAnimatedLightningsExploded != -1L || bl) {
                            GModel.GEMS_NEXT_STATE_DELAY[i] = 1;
                            continue;
                        }
                        if (GameController.m_nCurrentState == 14 && m_lCurrentFruitExploding != -1L && n4 == n3) {
                            m_lUnhandledSpecialGems |= l;
                        } else {
                            if (GameController.m_nCurrentState == 14 && m_lCurrentFruitExploding != -1L || bl2) {
                                GModel.GEMS_NEXT_STATE_DELAY[i] = 1;
                                continue;
                            }
                            m_lUnhandledSpecialGems |= l;
                            bl2 = true;
                        }
                    } else if ((BOARD[8] & l) != 0L) {
                        m_lUnhandledSpecialGems |= l;
                    } else if ((BOARD[13] & l) != 0L) {
                        GModel.startWisps(13, i);
                        GCanvasController.setExplodeGemAnim(i, 0, -1);
                    } else if ((BOARD[14] & l) != 0L) {
                        GModel.startWisps(14, i);
                        GCanvasController.setExplodeGemAnim(i, 0, -1);
                    }
                    ScoreController.increaseMatchScore(i);
                }
                GModel.setGemProperty(l, GEMS_NEXT_STATE[i]);
                GModel.GEMS_NEXT_STATE[i] = -1;
                GModel.GEMS_NEXT_STATE_DELAY[i] = -1;
                m_lGemsDelayedState &= l ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
    }

    static int getCountdownGemStartValue(int n) {
        int n2 = 0;
        if (n == 13) {
            if (GameController.m_nGameMode == 2 && Challenge.m_nSurvivorLevel > 0) {
                n2 = 19 - Challenge.m_nSurvivorLevel * m_nMovesMadePerLev / Challenge.m_nMovesTotal;
            } else if (GameController.m_nGameMode == 3) {
                n2 = 19;
            } else {
                n2 = 21 - GameController.m_nCurrentLevel;
                n2 = Math.max(n2, 7);
                n2 = Math.min(n2, 19);
            }
        } else if (n == 14) {
            if (GameController.m_nGameMode == 2 && Challenge.m_nSurvivorLevel > 0) {
                n2 = 19;
            } else {
                n2 = Math.min(13, 13 - (GameController.m_nCurrentLevel + 1 - 13));
                n2 = Math.max(8, n2);
            }
        }
        return n2;
    }

    static void awardFruitGem() {
        long l = 0L;
        int n = GModel.getLowestCountdownGem();
        if (n != -1) {
            l = 1L << n;
        } else if (BOARD[10] != 0L) {
            l = BOARD[10];
        } else if (BOARD[11] != 0L) {
            l = BOARD[11];
        } else {
            long l2;
            int n2 = GModel.getLeastFreqFruitCol();
            l = BOARD[n2];
            if ((l & ((l2 = BOARD[12] | BOARD[16] | BOARD[9] | BOARD[8]) ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                l &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (l != 0L) {
            m_nAwardedFruitGem = GModel.addSpecialGem(l, 12, 54, true, false);
            m_nReplayPoints += 10;
            if (!GameController.m_bLevelUp && !GameController.m_bGameOver) {
                HUDController.setHUDText(145, -1, false, false);
            }
        }
    }

    static final boolean bSpawnPreDoomGem() {
        if (GameController.m_nGameMode == 2 && Challenge.m_nSurvivorLevel > 0) {
            return Util.bitsSetLong(BOARD[15]) == 0 && Util.bitsSetLong(BOARD[14]) == 0;
        }
        if (GameController.m_nGameMode != 0 || GameController.m_nCurrentLevel < 12 || m_nDoomGemsCreatedThisLevel > 0) {
            return false;
        }
        if (m_nCurrentGemFill > 0 && m_nLevelCompleteFill > 0) {
            int n = m_nCurrentGemFill * 100 / m_nLevelCompleteFill;
            if (n >= 60) {
                return true;
            }
            if (n >= 40) {
                int n2 = (n - 40) * 100 / 20;
                int n3 = Util.GetRandom(100, TWIST_LOGIC_RANDOMER);
                return n3 > n2;
            }
            return false;
        }
        return false;
    }

    static final void startWisps(int n, int n2) {
        GModel.handleChainMeter(true, false);
        if (GameController.m_nGameMode != 2) {
            int n3 = 0;
            if (n == 13) {
                n3 = 1;
            } else if (n == 14) {
                GCanvasController.m_nRemainingWisps = 10;
                GCanvasController.m_nRemainingWispGem = n2;
                GCanvasController.m_nRemainingWispsFrame = 0;
                n3 = 2;
            }
            if (GameController.m_nGameMode != 2) {
                HUDController.incHudChainLight();
            }
        }
    }

    static final boolean checkIfMoveAvailable(boolean bl) {
        Hint.m_nHintGemPos = -1;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                int n = i * 8 + j;
                for (int k = 0; k < 16; ++k) {
                    GModel.TEMP_BOARD[k] = BOARD[k];
                }
                if (bl) {
                    TEMP_BOARD[10] = TEMP_BOARD[10] | (BOARD[15] | BOARD[11]);
                }
                m_nMatchesCount = 0;
                GModel.rotate(n, false, TEMP_BOARD, false);
                GModel.findMatches(TEMP_BOARD, false);
                if (m_nMatchesCount == 0) continue;
                Hint.m_nHintGemPos = n;
                m_nMatchesCount = 0;
                Hint.setHintTimer(false, true);
                return true;
            }
        }
        return false;
    }

    static void setDifficultyModifier() {
        int n;
        int n2;
        int n3 = FP.fpDiv(102400, 128000);
        int n4 = 1024;
        int n5 = FP.fpDiv(368640, 143360);
        int n6 = 1;
        int n7 = 0;
        for (n2 = 1; n2 <= 50; ++n2) {
            n7 = -FP.fpMul(n5, 1024 * n6);
            n7 = FP.fpMul(n7, 17);
            n7 = FP.fpMul(n7, n4);
            n = FP.fpSin(n7);
            GModel.DIFFICULTY_CURVE[n2 - 1] = n = FP.fpMul(n3, n);
            ++n6;
        }
        n2 = 50;
        n = DIFFICULTY_CURVE[49];
        int n8 = 0;
        for (int i = n2; i < DIFFICULTY_CURVE.length; ++i) {
            n8 = n2 - (i - n2 + 1);
            GModel.DIFFICULTY_CURVE[i] = n - (DIFFICULTY_CURVE[n8] - n);
        }
        int n9 = DIFFICULTY_CURVE.length - 1;
        int n10 = FP.fpDiv(2048, DIFFICULTY_CURVE[n9]);
        for (int i = 0; i < DIFFICULTY_CURVE.length; ++i) {
            int n11 = i;
            DIFFICULTY_CURVE[n11] = DIFFICULTY_CURVE[n11] - DIFFICULTY_CURVE[0];
            GModel.DIFFICULTY_CURVE[i] = FP.fpMul(DIFFICULTY_CURVE[i], n10);
        }
    }

    static int getDifficultyMod(int n) {
        if (n <= 0) {
            return n;
        }
        n *= 1024;
        int n2 = m_nStaggerGemFill * 100 / m_nLevelCompleteFill;
        int n3 = DIFFICULTY_CURVE[Math.min(n2, DIFFICULTY_CURVE.length - 1)];
        n = FP.fpMul(n, n3);
        return FP.toIntRound(n);
    }

    static {
        NORMAL_GEM_COLOURS = "\u0109T\u014f\u0088\u00ff\u000f\u00c8\u009f".length() - 1;
        GEM_COLOUR_COUNT = "\u0109T\u014f\u0088\u00ff\u000f\u00c8\u009f".length();
        GEM_STATE_COUNT = 60 - GEM_COLOUR_COUNT + 1;
        GEM_BITFIELD_SIZE = GEM_COLOUR_COUNT + GEM_STATE_COUNT;
        NORMAL_GEM_COLOURS_BITFIELD = (1 << NORMAL_GEM_COLOURS) - 1;
        BOARD = new long[GEM_BITFIELD_SIZE];
        TEMP_BOARD = new long[GEM_BITFIELD_SIZE];
        MATCHES = new long[45];
        MATCH_COLOUR = new int[45];
        MATCHES_TEMP = new long[45];
        MATCH_SPECIAL_SHAPES_MASKS = new long["\u0000\u0000\u0000\u0002\u0000\u0002\u0001\u0000\u0001".length()];
        GEM_COUNTDOWN_MOVES = new int[64];
        STACK = new int[64];
        BOARD_RESOLUTION_MOVES = new int[64];
        FLAME_GEMS = new int[64];
        GEMS_NEXT_STATE = new int[64];
        GEMS_NEXT_STATE_DELAY = new int[64];
        TWIST_LOGIC_RANDOMER = new Random();
        DIFFICULTY_CURVE = new int[100];
        m_StartingNewGameFromOldOne = false;
        loadGameSetAfterUITransition = false;
    }
}

