/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Background
implements Constants,
GameConstants,
ConstantsTFC {
    static int m_nCurrentBackgroundID;
    static int m_nCurrentBackgroundIndex;
    static int m_nStaticImgBgOffset;
    static final int LINE_H = 1;
    static int COL_UPDATE;
    static int COL_PULSE_UPDATE_POS;
    static int COL_PULSE_UPDATE_NEG;
    static int BRIGHTEN_CHANCE;
    static int DARKEN_CHANCE;
    static int MAX_DARKENS;
    static int MAX_BRIGHTENS;
    static int MODIFIER;
    static int UPDATE_COLOUR_CHANCE;
    static int UPDATE_MOVE_CHANCE;
    static final int PULSE_SIZE_PX = 4;
    static int ARRAY_SIZE;
    static int m_nColourShift;
    static int BG_NORM;
    static int BG_BRIGHT;
    static int BG_DIM;
    static int BG_PULSE;
    static int BG_RAIN_CENTRE;
    static int BG_RAIN_EDGE;
    static int COL_SHIFT_BLUE;
    static int COL_SHIFT_GREEN;
    static int COL_SHIFT_RED;
    static int[] COLS;
    static int[] FLAGS;
    static int[] FLAGS_SET;
    static int FL_BRIGHTEN;
    static int FL_DARKEN;
    static int FL_EVEN;
    static int FL_DONT_UPDATE;
    static int[] BG_FILL_COLOURS_SIDE;

    static void init() {
        ARRAY_SIZE = Graphic.m_nHeight / 1;
        COLS = new int[ARRAY_SIZE];
        FLAGS = new int[ARRAY_SIZE];
        FLAGS_SET = new int[ARRAY_SIZE];
        Background.resetVars();
    }

    static void resetVars() {
        Util.resetArray(COLS, 0);
        Util.resetArray(FLAGS, 0);
        Util.resetArray(FLAGS_SET, 0);
        m_nCurrentBackgroundID = -1;
        m_nCurrentBackgroundIndex = -1;
    }

    static void resumeBackground(int n) {
        m_nCurrentBackgroundID = "\r\u0006\n\u0004\u000f\u0003\t\u0005\u0010\u0001\u000e\u0000\f\b\u0011\u0002\u000b\u0007\u0012".charAt(n);
        if ((7 & 1 << m_nCurrentBackgroundID) != 0) {
            Background.resetVectorBackground(m_nCurrentBackgroundID % 3);
        } else if ((0x38 & 1 << m_nCurrentBackgroundID) != 0) {
            Background.resetVectorBackground(m_nCurrentBackgroundID % 3);
        } else if ((0x1C0 & 1 << m_nCurrentBackgroundID) != 0) {
            Background.resetVectorBackground(m_nCurrentBackgroundID % 3);
        } else {
            for (int i = 0; i < "\n\u000b\r\f\u000e\u000f\u0012\u0011\u0010".length() && m_nCurrentBackgroundID != 9; ++i) {
                if (m_nCurrentBackgroundID != (short)"\n\u000b\r\f\u000e\u000f\u0012\u0011\u0010".charAt(i)) continue;
                m_nStaticImgBgOffset = i;
                break;
            }
        }
    }

    static void resetVectorBackground(int n) {
        m_nColourShift = n * 8 % 24;
        for (int i = 0; i < COLS.length; ++i) {
            Background.COLS[i] = BG_NORM << m_nColourShift;
            Background.FLAGS[i] = 0;
            Background.FLAGS_SET[i] = 0;
        }
    }

    private static void updateVectorWeigthedCol() {
        int n = GCanvas.BOARD_POSITION_Y / 1;
        int n2 = (GCanvas.BOARD_POSITION_Y + 352) / 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < COLS.length; ++i) {
            n3 = (COLS[i] & 255 << m_nColourShift) >> m_nColourShift;
            if (Background.isFlagSet(FL_EVEN, i)) {
                if (n3 > BG_NORM) {
                    n3 = Math.max(n3 - COL_UPDATE, BG_NORM);
                } else if (n3 < BG_NORM) {
                    n3 = Math.min(n3 + COL_UPDATE, BG_NORM);
                } else {
                    Background.unSetFlag(FL_EVEN, i);
                }
            } else if (Background.isFlagSet(FL_BRIGHTEN, i)) {
                if (++n3 >= BG_BRIGHT) {
                    n3 = BG_BRIGHT;
                    Background.unSetFlag(FL_BRIGHTEN, i);
                    Background.setFlag(FL_EVEN, i);
                }
            } else if (Background.isFlagSet(FL_DARKEN, i)) {
                if ((n3 -= COL_UPDATE) <= BG_DIM) {
                    n3 = BG_DIM;
                    Background.unSetFlag(FL_DARKEN, i);
                    Background.setFlag(FL_EVEN, i);
                }
            } else if (FLAGS[i] == 0 && Util.GetRandom(UPDATE_COLOUR_CHANCE) == 0) {
                if (FLAGS_SET[FL_DARKEN] < MAX_DARKENS && (i < n || i > n2) && Util.GetRandom(Math.max(DARKEN_CHANCE + (Graphic.m_nYCenter + 2 * i), 1)) == 0) {
                    Background.setFlag(FL_DARKEN, i);
                } else if (FLAGS_SET[FL_BRIGHTEN] < MAX_BRIGHTENS && (i < n || i > n2) && Util.GetRandom(Math.max(BRIGHTEN_CHANCE + (Graphic.m_nYCenter - 2 * i), 1)) == 0) {
                    Background.setFlag(FL_BRIGHTEN, i);
                } else if (i != 0 && i != ARRAY_SIZE - 1) {
                    n4 = ((COLS[i - 1] & 255 << m_nColourShift) >> m_nColourShift) - n3;
                    n5 = ((COLS[i + 1] & 255 << m_nColourShift) >> m_nColourShift) - n3;
                    n6 = Math.abs(n4);
                    if (n6 > (n7 = Math.abs(n5)) && n6 > MODIFIER) {
                        n3 = n4 > 0 ? (n3 += Util.GetRandom(n6 / MODIFIER) + 1) : (n3 -= Util.GetRandom(n6 / MODIFIER) + 1);
                    } else if (n6 < n7 && n7 > MODIFIER) {
                        n3 = n5 > 0 ? (n3 += Util.GetRandom(n7 / MODIFIER) + 1) : (n3 -= Util.GetRandom(n7 / MODIFIER) + 1);
                    }
                }
            }
            n3 = Math.max(BG_DIM, Math.min(n3, BG_BRIGHT));
            Background.COLS[i] = COLS[i] & ~(255 << m_nColourShift) | n3 << m_nColourShift;
        }
    }

    private static void updateVectorCentrePulse() {
        int n;
        int n2 = 0;
        for (n = 0; n < ARRAY_SIZE; ++n) {
            block11: {
                block12: {
                    block15: {
                        block14: {
                            block13: {
                                block10: {
                                    n2 = (COLS[n] & 255 << m_nColourShift) >> m_nColourShift;
                                    if (!Background.isFlagSet(FL_EVEN, n)) break block10;
                                    if (n2 > BG_NORM) {
                                        n2 = Math.max(n2 - COL_PULSE_UPDATE_NEG, BG_NORM);
                                    } else if (n2 < BG_NORM) {
                                        n2 = Math.min(n2 + COL_PULSE_UPDATE_POS, BG_NORM);
                                    } else {
                                        Background.unSetFlag(FL_EVEN, n);
                                    }
                                    break block11;
                                }
                                if (!Background.isFlagSet(FL_BRIGHTEN, n)) break block12;
                                if (!Background.isFlagSet(FL_DONT_UPDATE, n)) {
                                    n2 += COL_PULSE_UPDATE_POS;
                                }
                                if (n2 < BG_BRIGHT) break block13;
                                n2 = BG_BRIGHT;
                                Background.unSetFlag(FL_BRIGHTEN, n);
                                Background.setFlag(FL_EVEN, n);
                                break block11;
                            }
                            if (n2 < BG_PULSE || n == ARRAY_SIZE - 1 || n == 0) break block11;
                            if (n <= ARRAY_SIZE / 2 || FLAGS[n + 1] != 0) break block14;
                            Background.setFlag(FL_BRIGHTEN, n + 1);
                            Background.setFlag(FL_DONT_UPDATE, n + 1);
                            break block11;
                        }
                        if (n >= ARRAY_SIZE / 2 || FLAGS[n - 1] != 0) break block15;
                        Background.setFlag(FL_BRIGHTEN, n - 1);
                        Background.setFlag(FL_DONT_UPDATE, n - 1);
                        break block11;
                    }
                    if (n != ARRAY_SIZE / 2) break block11;
                    if (FLAGS[n + 1] == 0) {
                        Background.setFlag(FL_BRIGHTEN, n + 1);
                        Background.setFlag(FL_DONT_UPDATE, n + 1);
                    }
                    if (FLAGS[n - 1] != 0) break block11;
                    Background.setFlag(FL_BRIGHTEN, n - 1);
                    Background.setFlag(FL_DONT_UPDATE, n - 1);
                    break block11;
                }
                if (n == (ARRAY_SIZE - 4) / 2 && FLAGS_SET[FL_BRIGHTEN] <= 0) {
                    for (int i = n; i < n + 4; ++i) {
                        Background.setFlag(FL_BRIGHTEN, i);
                    }
                }
            }
            n2 = Math.max(BG_DIM, Math.min(n2, BG_BRIGHT));
            Background.COLS[n] = COLS[n] & ~(255 << m_nColourShift) | n2 << m_nColourShift;
        }
        for (n = 0; n < ARRAY_SIZE; ++n) {
            Background.unSetFlag(FL_DONT_UPDATE, n);
        }
    }

    private static void updateVectorEdgePulse() {
        int n;
        int n2 = 0;
        for (n = 0; n < ARRAY_SIZE; ++n) {
            block11: {
                block12: {
                    block14: {
                        block13: {
                            block10: {
                                n2 = (COLS[n] & 255 << m_nColourShift) >> m_nColourShift;
                                if (!Background.isFlagSet(FL_EVEN, n)) break block10;
                                if (n2 > BG_NORM) {
                                    n2 = Math.max(n2 - COL_PULSE_UPDATE_NEG, BG_NORM);
                                } else if (n2 < BG_NORM) {
                                    n2 = Math.min(n2 + COL_PULSE_UPDATE_POS, BG_NORM);
                                } else {
                                    Background.unSetFlag(FL_EVEN, n);
                                }
                                break block11;
                            }
                            if (!Background.isFlagSet(FL_BRIGHTEN, n)) break block12;
                            if (!Background.isFlagSet(FL_DONT_UPDATE, n)) {
                                n2 += COL_PULSE_UPDATE_POS;
                            }
                            if (n2 < BG_BRIGHT) break block13;
                            n2 = BG_BRIGHT;
                            Background.unSetFlag(FL_BRIGHTEN, n);
                            Background.setFlag(FL_EVEN, n);
                            break block11;
                        }
                        if (n2 < BG_PULSE || n == ARRAY_SIZE / 2) break block11;
                        if (n <= ARRAY_SIZE / 2 || FLAGS[n - 1] != 0) break block14;
                        Background.setFlag(FL_BRIGHTEN, n - 1);
                        Background.setFlag(FL_DONT_UPDATE, n - 1);
                        break block11;
                    }
                    if (n >= ARRAY_SIZE / 2 || FLAGS[n + 1] != 0) break block11;
                    Background.setFlag(FL_BRIGHTEN, n + 1);
                    Background.setFlag(FL_DONT_UPDATE, n + 1);
                    break block11;
                }
                if ((n == 2 || n == ARRAY_SIZE - 1 - 2) && FLAGS_SET[FL_BRIGHTEN] <= 0) {
                    int n3;
                    for (n3 = 0; n3 < 2; ++n3) {
                        Background.setFlag(FL_BRIGHTEN, n3);
                    }
                    for (n3 = ARRAY_SIZE - 1 - 2; n3 < ARRAY_SIZE; ++n3) {
                        Background.setFlag(FL_BRIGHTEN, n3);
                    }
                }
            }
            n2 = Math.max(BG_DIM, Math.min(n2, BG_BRIGHT));
            Background.COLS[n] = COLS[n] & ~(255 << m_nColourShift) | n2 << m_nColourShift;
        }
        for (n = 0; n < ARRAY_SIZE; ++n) {
            Background.unSetFlag(FL_DONT_UPDATE, n);
        }
    }

    static final boolean isFlagSet(int n, int n2) {
        return (FLAGS[n2] & 1 << n) != 0;
    }

    static final void setFlag(int n, int n2) {
        int n3 = n2;
        FLAGS[n3] = FLAGS[n3] | 1 << n;
        int n4 = n;
        FLAGS_SET[n4] = FLAGS_SET[n4] + 1;
    }

    static final void unSetFlag(int n, int n2) {
        int n3 = n2;
        FLAGS[n3] = FLAGS[n3] & ~(1 << n);
        int n4 = n;
        FLAGS_SET[n4] = FLAGS_SET[n4] - 1;
    }

    static final void updateBackground() {
        if (m_nCurrentBackgroundID != -1) {
            if (HUDController.m_nHudFadeAlpha == 2) {
                return;
            }
            if (m_nCurrentBackgroundID == 9) {
                Particles.startRaindrops();
            } else if ((7 & 1 << m_nCurrentBackgroundID) != 0) {
                Background.updateVectorWeigthedCol();
            } else if ((0x38 & 1 << m_nCurrentBackgroundID) != 0) {
                Background.updateVectorCentrePulse();
            } else if ((0x1C0 & 1 << m_nCurrentBackgroundID) != 0) {
                Background.updateVectorEdgePulse();
            }
        }
    }

    static void drawVectorBackground(Graphics graphics, int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = GCanvas.WORLD_WIDTH;
        int n6 = GCanvas.BOARD_POSITION_Y;
        graphics.setClip(n3, n4, n5, n6);
        for (n2 = n4; n2 < n4 + n6; ++n2) {
            graphics.setColor(COLS[n2 / 1]);
            graphics.fillRect(n3, n2, n5, 1);
        }
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, n3, n4, n5, n6);
        }
        n4 = GCanvas.BOARD_POSITION_Y + 352;
        n6 = GCanvas.WORLD_HEIGHT - n4;
        graphics.setClip(n3, n4, n5, n6);
        for (n2 = n4; n2 < n4 + n6; ++n2) {
            graphics.setColor(COLS[n2 / 1]);
            graphics.fillRect(n3, n2, n5, 1);
        }
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, n3, n4, n5, n6);
        }
        n3 = 0;
        n4 = GCanvas.BOARD_POSITION_Y;
        n5 = GCanvas.BOARD_POSITION_X - 0;
        n6 = 352;
        graphics.setClip(n3, n4, n5, n6);
        for (n2 = n4; n2 < n4 + n6; ++n2) {
            graphics.setColor(COLS[n2 / 1]);
            graphics.fillRect(n3, n2, n5, 1);
        }
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, n3, n4, n5, n6);
        }
        n3 = GCanvas.BOARD_POSITION_X + 352 + 0;
        n4 = GCanvas.BOARD_POSITION_Y;
        n5 = GCanvas.WORLD_WIDTH - n3;
        graphics.setClip(n3, n4, n5, n6);
        for (n2 = n4; n2 < n4 + n6; ++n2) {
            graphics.setColor(COLS[n2 / 1]);
            graphics.fillRect(n3, n2, n5, 1);
        }
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, n3, n4, n5, n6);
        }
    }

    static void drawGradientBackground(Graphics graphics, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = 0;
        int n7 = GCanvas.WORLD_HEIGHT / 2;
        int n8 = 0;
        int n9 = 0;
        int n10 = GCanvas.WORLD_WIDTH;
        int n11 = GCanvas.BOARD_POSITION_Y;
        n6 = n11 * 100 / n7;
        n5 = GraphicsUtil.blendColours(n4, n5, n6);
        graphics.setClip(n8, n9, n10, n11);
        GraphicsUtil.drawGradient(graphics, n8, n9, n10, n11, n4, n5, true);
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, n8, n9, n10, n11);
        }
        n8 = 0;
        n9 = GCanvas.BOARD_POSITION_Y;
        n10 = GCanvas.BOARD_POSITION_X - 0;
        n11 = 176;
        int n12 = n5;
        n4 = n5;
        n6 = n11 * 100 / n7;
        n5 = n3;
        graphics.setClip(n8, n9, n10, n11);
        GraphicsUtil.drawGradient(graphics, n8, n9, n10, n11, n4, n5, true);
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, n8, n9, n10, n11);
        }
        n9 = GCanvas.BOARD_POSITION_Y + n11;
        n4 = n3;
        n6 = n11 * 100 / n7;
        n5 = n2;
        graphics.setClip(n8, n9, n10, n11);
        GraphicsUtil.drawGradient(graphics, n8, n9, n10, n11, n4, n5, true);
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, n8, n9, n10, n11);
        }
        n8 = GCanvas.BOARD_POSITION_X + 352 + 0;
        n9 = GCanvas.BOARD_POSITION_Y;
        n10 = GCanvas.WORLD_WIDTH - n8;
        n4 = n12;
        n5 = n3;
        n6 = n11 * 100 / n7;
        graphics.setClip(n8, n9, n10, n11);
        GraphicsUtil.drawGradient(graphics, n8, n9, n10, n11, n4, n5, true);
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, n8, n9, n10, n11);
        }
        n9 = GCanvas.BOARD_POSITION_Y + n11;
        n4 = n3;
        n5 = n2;
        n6 = n11 * 100 / n7;
        graphics.setClip(n8, n9, n10, n11);
        GraphicsUtil.drawGradient(graphics, n8, n9, n10, n11, n4, n5, true);
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, n8, n9, n10, n11);
        }
        n8 = 0;
        n9 = GCanvas.BOARD_POSITION_Y + 352;
        n10 = GCanvas.WORLD_WIDTH;
        n11 = GCanvas.WORLD_HEIGHT - n9;
        n4 = n5;
        n6 = n11 * 100 / n7;
        n5 = n2;
        graphics.setClip(n8, n9, n10, n11);
        GraphicsUtil.drawGradient(graphics, n8, n9, n10, n11, n4, n5, true);
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, n8, n9, n10, n11);
        }
    }

    static void drawStaticImageBackgroundPortrait(Graphics graphics, int n) {
        graphics.setClip(0, 0, GCanvas.WORLD_WIDTH, GCanvas.WORLD_HEIGHT);
        graphics.setColor(BG_FILL_COLOURS_SIDE[m_nStaticImgBgOffset]);
        int n2 = GCanvas.WORLD_HEIGHT + 0 - Graphic.GetImageHeight("\u0015\u0013\u0011\u000e\f\n\b\u0006\u0004".charAt(m_nStaticImgBgOffset)) - Graphic.GetImageHeight("\u00fc\u00f3\u00f1\u00ef\u00ed\u00eb\u00e2\u00e0\u00de".charAt(m_nStaticImgBgOffset));
        int n3 = 0;
        int n4 = 0;
        Graphic.DrawImage(graphics, "\u0014\u0012\u0010\r\u000b\t\u0007\u0005\u0003".charAt(m_nStaticImgBgOffset), n3, n4, 20);
        n3 = GCanvas.WORLD_WIDTH;
        Graphic.DrawImage(graphics, "\u0015\u0013\u0011\u000e\f\n\b\u0006\u0004".charAt(m_nStaticImgBgOffset), n3, n4, 24);
        n3 = 0;
        n4 = Graphic.GetImageHeight("\u0015\u0013\u0011\u000e\f\n\b\u0006\u0004".charAt(m_nStaticImgBgOffset)) - 0;
        graphics.fillRect(n3, n4, 0, n2);
        n3 = GCanvas.WORLD_WIDTH - 0;
        graphics.fillRect(n3, n4, 0, n2);
        n3 = GCanvas.WORLD_WIDTH;
        n4 = GCanvas.WORLD_HEIGHT + 0;
        Graphic.DrawImage(graphics, "\u00fc\u00f3\u00f1\u00ef\u00ed\u00eb\u00e2\u00e0\u00de".charAt(m_nStaticImgBgOffset), n3, n4, 40);
        n3 = 0;
        Graphic.DrawImage(graphics, "\u00fb\u00f2\u00f0\u00ee\u00ec\u00ea\u00e1\u00df\u00dd".charAt(m_nStaticImgBgOffset), n3, n4, 36);
        if (n >= 0) {
            GraphicsUtil.drawAlphaRegion(graphics, n, 0, 0, Graphic.m_nWidth, GCanvas.BOARD_POSITION_Y);
            GraphicsUtil.drawAlphaRegion(graphics, n, 0, GCanvas.BOARD_POSITION_Y + 352, Graphic.m_nWidth, Graphic.m_nHeight);
            GraphicsUtil.drawAlphaRegion(graphics, n, 0, GCanvas.BOARD_POSITION_Y, GCanvas.BOARD_POSITION_X, 352);
            GraphicsUtil.drawAlphaRegion(graphics, n, GCanvas.BOARD_POSITION_X + 352, GCanvas.BOARD_POSITION_Y, Graphic.m_nWidth - GCanvas.BOARD_POSITION_X + 352, 352);
        }
    }

    static void drawHudBackground(Graphics graphics) {
        if (m_nCurrentBackgroundID != -1) {
            if (HUDController.m_nHudFadeAlpha == 2) {
                if (GameController.m_bReplaying) {
                    Background.drawBlackBackground(graphics);
                }
                return;
            }
            int n = 5 * HUDController.m_nHudFadeAlphaFrame;
            if (m_nCurrentBackgroundID == 9) {
                Background.drawGradientBackground(graphics, n, BG_RAIN_EDGE, BG_RAIN_CENTRE);
            } else if ((7 & 1 << m_nCurrentBackgroundID) != 0) {
                Background.drawVectorBackground(graphics, n);
            } else if ((0x38 & 1 << m_nCurrentBackgroundID) != 0) {
                Background.drawVectorBackground(graphics, n);
            } else if ((0x1C0 & 1 << m_nCurrentBackgroundID) != 0) {
                Background.drawVectorBackground(graphics, n);
            } else {
                Background.drawStaticImageBackgroundPortrait(graphics, n);
            }
            graphics.setClip(0, 0, GCanvas.WORLD_WIDTH, GCanvas.WORLD_HEIGHT);
        } else {
            Background.drawBlackBackground(graphics);
        }
    }

    static final void drawBlackBackground(Graphics graphics) {
        graphics.setColor(0);
        graphics.setClip(0, 0, Graphic.m_nWidth, GCanvas.BOARD_POSITION_Y);
        graphics.fillRect(0, 0, Graphic.m_nWidth, GCanvas.BOARD_POSITION_Y);
        graphics.setClip(0, 0, GCanvas.BOARD_POSITION_X, Graphic.m_nHeight);
        graphics.fillRect(0, 0, GCanvas.BOARD_POSITION_X, Graphic.m_nHeight);
        graphics.setClip(GCanvas.BOARD_POSITION_X + 352, 0, Graphic.m_nWidth - GCanvas.BOARD_POSITION_X + 352, Graphic.m_nHeight);
        graphics.fillRect(GCanvas.BOARD_POSITION_X + 352, 0, Graphic.m_nWidth - GCanvas.BOARD_POSITION_X + 352, Graphic.m_nHeight);
        graphics.setClip(0, GCanvas.BOARD_POSITION_Y + 352, Graphic.m_nWidth, Graphic.m_nHeight);
        graphics.fillRect(0, GCanvas.BOARD_POSITION_Y + 352, Graphic.m_nWidth, Graphic.m_nHeight);
    }

    static final void incBackground(int n) {
        m_nCurrentBackgroundIndex = n == 2 || n == 3 ? Util.GetRandom(18) : (m_nCurrentBackgroundIndex + 1) % 18;
        m_nCurrentBackgroundID = "\r\u0006\n\u0004\u000f\u0003\t\u0005\u0010\u0001\u000e\u0000\f\b\u0011\u0002\u000b\u0007\u0012".charAt(m_nCurrentBackgroundIndex);
    }

    static final void nextBackground() {
        if ((7 & 1 << m_nCurrentBackgroundID) != 0) {
            Background.resetVectorBackground(m_nCurrentBackgroundID % 3);
        } else if ((0x38 & 1 << m_nCurrentBackgroundID) != 0) {
            Background.resetVectorBackground(m_nCurrentBackgroundID % 3);
        } else if ((0x1C0 & 1 << m_nCurrentBackgroundID) != 0) {
            Background.resetVectorBackground(m_nCurrentBackgroundID % 3);
        } else {
            for (int i = 0; i < "\n\u000b\r\f\u000e\u000f\u0012\u0011\u0010".length() && m_nCurrentBackgroundID != 9; ++i) {
                if (m_nCurrentBackgroundID != (short)"\n\u000b\r\f\u000e\u000f\u0012\u0011\u0010".charAt(i)) continue;
                m_nStaticImgBgOffset = i;
                break;
            }
        }
        HUDController.m_nHudFadeAlphaFrame = 20;
        HUDController.m_nHudFadeAlpha = 0;
    }

    static void loadBackgroundImageSet() {
        if ((0x1FFL & (long)(1 << m_nCurrentBackgroundID)) == 0L) {
            if (m_nCurrentBackgroundID == 9) {
                ResManager.LoadImageSets(65589L);
            } else {
                for (int i = 0; i < "\n\u000b\r\f\u000e\u000f\u0012\u0011\u0010".length(); ++i) {
                    if (m_nCurrentBackgroundID != (short)"\n\u000b\r\f\u000e\u000f\u0012\u0011\u0010".charAt(i)) continue;
                    ResManager.LoadImageSets(0x35L | (long)"\u0080\u0100\u0200\u0400\u0800\u1000\u2000\u4000\u8000".charAt(i));
                    break;
                }
            }
        }
    }

    static {
        m_nStaticImgBgOffset = 0;
        COL_UPDATE = 2;
        COL_PULSE_UPDATE_POS = 8;
        COL_PULSE_UPDATE_NEG = 2;
        BRIGHTEN_CHANCE = 800;
        DARKEN_CHANCE = 800;
        MAX_DARKENS = 2;
        MAX_BRIGHTENS = 4;
        MODIFIER = 3;
        UPDATE_COLOUR_CHANCE = 1;
        UPDATE_MOVE_CHANCE = 4;
        m_nColourShift = 0;
        BG_NORM = 125;
        BG_BRIGHT = 255;
        BG_DIM = 64;
        BG_PULSE = BG_NORM + 1;
        BG_RAIN_CENTRE = 333855;
        BG_RAIN_EDGE = 933454;
        COL_SHIFT_BLUE = 0;
        COL_SHIFT_GREEN = 1;
        COL_SHIFT_RED = 2;
        FL_BRIGHTEN = 0;
        FL_DARKEN = 1;
        FL_EVEN = 2;
        FL_DONT_UPDATE = 3;
        BG_FILL_COLOURS_SIDE = new int[]{7734191, 16339947, 2215438, 514273, 14028384, 15956227, 1048401, 15317506, 709859};
    }
}

