/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Audio
implements AudioConstants {
    public static final int PLAY = 0;
    public static final int STOP = 1;
    public static final int PAUSE = 2;
    public static final int RESUME = 3;
    public static final int FLAG_LOOP = 1;
    public static final int FLAG_WAIT = 2;
    private static boolean m_bSoundOn = false;
    public static boolean m_bVibrateOn = true;
    public static final boolean VIBRATE_ENABLED = true;
    private static Player m_Player = null;
    private static String[] m_ClipName = new String[11];
    private static Object[] m_AudioData = new Object[11];
    private static String STANDARD_AUDIO_FILE = "/a";
    private static final String[] AUDIO_MIME_FORMATS = new String[]{"audio/midi", "", "", "audio/amr", "audio/x-wav", "audio/amr-wb", "audio/mp3"};
    private static boolean m_bLoopSound;
    private static int m_nSoundPlaying;
    private static int m_nSoundPaused;
    private static VolumeControl m_vc;
    private static int m_nVolumeLevelIndex;
    private static int[] m_nVolumeLevels;
    public static int m_nBBVolumeLevelIndex;
    private static int[] m_nBBVolumeLevels;
    static int restartSoundIDbackup;
    static int restartSoundID;
    static boolean m_bAudioPaused;
    static boolean m_bAudioOnHold;

    public static void InitAudio() {
    }

    public static void EnableAudio(boolean bl) {
        m_bSoundOn = bl;
    }

    public static boolean IsAudioEnabled() {
        return m_bSoundOn;
    }

    public static void DestroyAudio() {
        Audio.HandleAudio(-1, 1);
        if (m_Player != null) {
            m_Player.close();
            m_Player = null;
        }
    }

    public static void LoadAudio(int n) {
    }

    public static void LoadAudio(int n, boolean bl) {
        try {
            DataInputStream dataInputStream = new DataInputStream(STANDARD_AUDIO_FILE.getClass().getResourceAsStream(STANDARD_AUDIO_FILE));
            int n2 = dataInputStream.readUnsignedByte();
            dataInputStream.readUnsignedShort();
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4 = dataInputStream.readInt();
                int n5 = dataInputStream.readUnsignedByte();
                int[] nArray = new int[n5];
                int n6 = dataInputStream.readUnsignedByte();
                int n7 = dataInputStream.readUnsignedByte();
                for (int j = 0; j < n5; ++j) {
                    nArray[j] = dataInputStream.readUnsignedByte();
                    dataInputStream.skip(n7);
                }
                byte[] byArray = null;
                if (n6 == 2) {
                    String string = dataInputStream.readUTF();
                    for (int j = 0; j < nArray.length; ++j) {
                        Audio.m_ClipName[nArray[j]] = string;
                    }
                } else {
                    n3 = dataInputStream.readInt();
                    if (bl || (n4 & 1 << n) != 0) {
                        byArray = new byte[n3];
                        Util.safeRead(dataInputStream, byArray, 0, n3);
                    } else {
                        dataInputStream.skip(n3);
                    }
                }
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    Audio.m_AudioData[nArray[n3]] = byArray;
                }
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void UpdateAudio() {
    }

    public static boolean restartAudio() {
        if (restartSoundIDbackup >= 0) {
            restartSoundIDbackup = -1;
        }
        if (m_bAudioOnHold) {
            return true;
        }
        if (m_bAudioPaused) {
            m_bAudioPaused = false;
            if (restartSoundID != -1) {
                if (MainUIController.m_nUIState != 20) {
                    Audio.HandleAudio(restartSoundID, 0, 1);
                    Audio.setVolumeLevel(m_nVolumeLevelIndex);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static void hideNotifyAudio() {
        if (ResManager.m_nPercentDone < 0 && restartSoundIDbackup < 0) {
            restartSoundIDbackup = restartSoundID;
        }
        m_bAudioPaused = true;
        Audio.HandleAudio(-1, 1);
    }

    public static void showNotifyAudio() {
        if (restartSoundIDbackup >= 0) {
            restartSoundID = restartSoundIDbackup;
        }
    }

    public static boolean holdAudioPlay(boolean bl) {
        if (bl) {
            m_bAudioOnHold = true;
            return true;
        }
        m_bAudioOnHold = false;
        m_bAudioPaused = true;
        return Audio.restartAudio();
    }

    public static void HandleAudio(int n, int n2) {
        Audio.HandleAudio(n, n2, 0);
    }

    public static void HandleAudio(int n, int n2, int n3) {
        Audio.HandleAudio(n, n2, n3, -1);
    }

    public static void HandleAudio(int n, int n2, int n3, int n4) {
        if (n == m_nSoundPlaying && m_bLoopSound && n3 == 1) {
            return;
        }
        switch (n2) {
            case 0: {
                if (!m_bSoundOn || n < 0 || n >= m_AudioData.length) break;
                try {
                    char c = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(n);
                    int n5 = m_nSoundPlaying >= 0 ? "\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(m_nSoundPlaying) - "\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(n) : (m_bAudioOnHold && restartSoundID >= 0 ? "\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(restartSoundID) - "\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".charAt(n) : 0);
                    ByteArrayInputStream byteArrayInputStream = null;
                    if (c != '\uffffffff') {
                        if (n5 > 0 && m_Player.getState() == 400) {
                            return;
                        }
                        Audio.HandleAudio(-1, 1);
                        boolean bl = m_bLoopSound = (n3 & 1) != 0;
                        if (m_bLoopSound) {
                            restartSoundID = n4 == -1 ? n : -1;
                        }
                        if (!m_bAudioPaused && !m_bAudioOnHold) {
                            if (m_AudioData[n] == null) {
                                m_Player = Manager.createPlayer((String)m_ClipName[n]);
                            } else {
                                byteArrayInputStream = new ByteArrayInputStream((byte[])m_AudioData[n]);
                                m_Player = Manager.createPlayer((InputStream)byteArrayInputStream, (String)AUDIO_MIME_FORMATS[c]);
                            }
                            if (m_Player != null) {
                                if (n != m_nSoundPlaying) {
                                    m_Player.realize();
                                }
                                m_Player.prefetch();
                                if (m_nVolumeLevelIndex != -1 && (m_vc = (VolumeControl)m_Player.getControl("VolumeControl")) != null) {
                                    m_vc.setLevel(m_nBBVolumeLevels[m_nBBVolumeLevelIndex]);
                                }
                                if (m_bLoopSound) {
                                    m_Player.setLoopCount(n4);
                                } else {
                                    m_Player.setLoopCount(1);
                                }
                                m_Player.start();
                            }
                            if (byteArrayInputStream != null) {
                                byteArrayInputStream.close();
                            }
                        }
                    }
                    if (!m_bAudioPaused && !m_bAudioOnHold) {
                        m_nSoundPlaying = n;
                        break;
                    }
                    m_nSoundPlaying = -1;
                }
                catch (Exception exception) {}
                break;
            }
            case 1: {
                m_nSoundPlaying = -1;
                restartSoundID = -1;
            }
            case 2: {
                try {
                    if (m_Player != null) {
                        m_Player.stop();
                        m_Player.deallocate();
                        m_Player.close();
                        m_Player = null;
                    }
                    if (m_bLoopSound) {
                        m_nSoundPaused = m_nSoundPlaying;
                    }
                    m_nSoundPlaying = -1;
                }
                catch (Exception exception) {}
                break;
            }
            case 3: {
                if (m_bSoundOn) {
                    if (m_nSoundPaused == -1) break;
                    if (m_bLoopSound) {
                        Audio.HandleAudio(m_nSoundPaused, 0, 1);
                    }
                    m_nSoundPaused = -1;
                    break;
                }
                Audio.HandleAudio(-1, 1);
            }
        }
    }

    public static void setVolumeLevel(int n) {
        m_nVolumeLevelIndex = n;
        if (n == 0) {
            m_bSoundOn = false;
        } else if (n <= 3) {
            m_bSoundOn = true;
            if (m_Player != null && (m_vc = (VolumeControl)m_Player.getControl("VolumeControl")) != null) {
                m_vc.setLevel(m_nBBVolumeLevels[m_nBBVolumeLevelIndex]);
            }
        }
    }

    public static void setVolumeLevel(boolean bl) {
        m_nBBVolumeLevelIndex = bl ? Math.min(10, m_nBBVolumeLevelIndex + 1) : Math.max(0, m_nBBVolumeLevelIndex - 1);
        if (m_Player != null && (m_vc = (VolumeControl)m_Player.getControl("VolumeControl")) != null) {
            m_vc.setLevel(m_nBBVolumeLevels[m_nBBVolumeLevelIndex]);
        }
    }

    public static int getVolumeLevel() {
        return m_nVolumeLevelIndex;
    }

    public static void HandleVibration(int n) {
        if (m_bVibrateOn) {
            Game.m_Display.vibrate(n);
        }
    }

    static {
        m_nSoundPlaying = -1;
        m_nSoundPaused = -1;
        m_nVolumeLevelIndex = 3;
        m_nVolumeLevels = new int[]{0, 100, 100, 100};
        m_nBBVolumeLevelIndex = 8;
        m_nBBVolumeLevels = new int[]{0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100};
        restartSoundIDbackup = -1;
        restartSoundID = -1;
        m_bAudioPaused = false;
        m_bAudioOnHold = false;
    }
}

