/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class GCanvas3D
implements GameConstants,
Constants,
ConstantsTFC {
    static Graphics3D g3d;
    static Camera camera;
    static CompositingMode compMode;
    public static PolygonMode polygonMode;
    static Transform tempTrans;
    public static final int MAX_3D_IMAGES = 1;
    public static Mesh[] IMAGE_MESHES;
    static int m_nImageCount;
    static boolean m_bInitCalled;

    static void init() {
        g3d = Graphics3D.getInstance();
        GCanvas3D.setCompositingMode();
        GCanvas3D.configurePolygonMode();
        camera = new Camera();
        camera.setParallel((float)Graphic.Graphic_m_nHeight, (float)Graphic.Graphic_m_nWidth / (float)Graphic.Graphic_m_nHeight, 0.0f, 20.0f);
        g3d.setViewport(0, 0, Graphic.Graphic_m_nWidth, Graphic.Graphic_m_nHeight);
        tempTrans = new Transform();
        Transform transform = new Transform();
        transform.postTranslate(0.0f, 0.0f, 10.0f);
        g3d.setCamera(camera, transform);
        m_nImageCount = 0;
    }

    static int createImage3D(int n) {
        if (!m_bInitCalled) {
            GCanvas3D.init();
            m_bInitCalled = true;
        }
        Texture2D texture2D = GCanvas3D.createTexture(n);
        short s = 32;
        GCanvas3D.IMAGE_MESHES[GCanvas3D.m_nImageCount] = GCanvas3D.createQuad(s, (byte)Graphic.Graphic_GetImageWidth(n), texture2D);
        Transform transform = new Transform();
        transform.postTranslate(0.0f, 0.0f, 0.5f);
        IMAGE_MESHES[m_nImageCount].setTransform(transform);
        return ++m_nImageCount - 1;
    }

    static void releaseAll3DImages() {
        for (int i = 0; i < m_nImageCount; ++i) {
            GCanvas3D.IMAGE_MESHES[i] = null;
        }
        m_nImageCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void drawImage3D(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(0, 0, Graphic.Graphic_m_nWidth, Graphic.Graphic_m_nHeight);
        GCanvas3D.setImagePosAndRot(n, n2, n3, n4);
        try {
            g3d.bindTarget((Object)graphics, false, 0);
            IMAGE_MESHES[n].getTransform(tempTrans);
            g3d.render((Node)IMAGE_MESHES[n], tempTrans);
        }
        finally {
            g3d.releaseTarget();
        }
    }

    private static void setImagePosAndRot(int n, int n2, int n3, int n4) {
        IMAGE_MESHES[n].getTransform(tempTrans);
        tempTrans.setIdentity();
        tempTrans.postTranslate(1.0f * (float)(n2 - Graphic.Graphic_m_nXCenter), 1.0f * (float)(Graphic.Graphic_m_nYCenter - n3), 0.5f);
        tempTrans.postRotate(1.0f * (float)n4, 0.0f, 0.0f, 1.0f);
        IMAGE_MESHES[n].setTransform(tempTrans);
    }

    private static Texture2D createTexture(int n) {
        Image2D image2D = new Image2D(100, Graphic.Graphic_m_ImgPool[n].imageData);
        Texture2D texture2D = new Texture2D(image2D);
        texture2D.setFiltering(208, 209);
        return texture2D;
    }

    private static Mesh createQuad(short s, byte by, Texture2D texture2D) {
        short[] sArray = new short[]{-s, -s, 0, s, -s, 0, -s, s, 0, s, s, 0};
        int[] nArray = new int[]{0, 1, 2, 3};
        int[] nArray2 = new int[]{4};
        byte[] byArray = new byte[]{0, 0, by, 0, 0, by, by, by};
        VertexArray vertexArray = new VertexArray(sArray.length / 3, 3, 2);
        vertexArray.set(0, sArray.length / 3, sArray);
        VertexArray vertexArray2 = new VertexArray(byArray.length / 2, 2, 1);
        vertexArray2.set(0, byArray.length / 2, byArray);
        TriangleStripArray triangleStripArray = new TriangleStripArray(nArray, nArray2);
        VertexBuffer vertexBuffer = new VertexBuffer();
        vertexBuffer.setPositions(vertexArray, 1.0f, null);
        vertexBuffer.setTexCoords(0, vertexArray2, 1.0f / (float)by, null);
        Mesh mesh = new Mesh(vertexBuffer, (IndexBuffer)triangleStripArray, null);
        Appearance appearance = new Appearance();
        appearance.setTexture(0, texture2D);
        appearance.setCompositingMode(compMode);
        appearance.setPolygonMode(polygonMode);
        mesh.setAppearance(0, appearance);
        return mesh;
    }

    private static void configurePolygonMode() {
        polygonMode = new PolygonMode();
        polygonMode.setPerspectiveCorrectionEnable(true);
        polygonMode.setCulling(162);
        polygonMode.setShading(164);
    }

    private static void setCompositingMode() {
        compMode = new CompositingMode();
        compMode.setBlending(64);
    }

    static {
        IMAGE_MESHES = new Mesh[1];
        m_bInitCalled = false;
    }
}

