/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.rms.RecordStore;

final class Game {
    public static int touchMe = 1;
    private static final int ENTITY_MASK = 65535;
    public static final int DIFFICULTY_NORMAL = 1;
    public static final int DIFFICULTY_HARD = 2;
    public static final int DIFFICULTY_NIGHTMARE = 4;
    public static final int LOAD_NONE = 0;
    public static final int LOAD_USERSAVE = 1;
    public static final int LOAD_BRIEFSAVE = 2;
    public static final int LOAD_CHICKENGAME = 3;
    public static final int SAVE_NONE = 0;
    public static final int SAVE_PLAYER = 1;
    public static final int SAVE_WORLD = 2;
    public static final int SAVE_EXIT = 4;
    public static final int SAVE_LOADMAP = 8;
    public static final int SAVE_ENDLEVEL = 16;
    public static final int SAVE_BRIEF = 32;
    public static final int SAVE_QUIT = 64;
    public static final int SAVE_RETURNTOGAME = 128;
    public static final int SAVE_ENDGAME = 256;
    public static final int ENTITYNUM_WORLD = 0;
    public static final int ENTITYNUM_PLAYER = 1;
    private static final int MAX_LERP_SPRITES = 16;
    private static final int MAX_LEVEL_VARS = 8;
    public static final int MAX_LEVEL_NAMES = 9;
    private static final int MAX_ENTITIES = 275;
    private static final int MAX_TRACE_ENTITIES = 32;
    private static final int MAX_MONSTERS = 80;
    private static final int SAVEGAME_VERSION = 11;
    private static final String SAVEGAME_NAME_FULLWORLD = "SDFWORLD";
    private static final String SAVEGAME_NAME_FULLPLAYER = "SDFPLAYER";
    private static final String SAVEGAME_NAME_BRIEFWORLD = "SDBWORLD";
    private static final String SAVEGAME_NAME_BRIEFPLAYER = "SDBPLAYER";
    private static final String SAVEGAME_NAME_CONFIG = "SDCONFIG";
    public static final int SAVE_FLAG_BINARY = 65536;
    public static final int SAVE_FLAG_NAMED = 131072;
    public static final int SAVE_FLAG_SHOWN = 262144;
    public static final int SAVE_FLAG_CLEAN = 524288;
    public static final int SAVE_FLAG_CORPSE = 0x100000;
    public static final int SAVE_FLAG_CUSTOM = 0x200000;
    public static final int SAVE_FLAG_NOTRACK = 0x400000;
    public static final int SAVE_FLAG_NORESPAWN = 0x800000;
    public static final int SAVE_FLAG_ENTITY_DEATH = 0x1000000;
    public static final int SAVE_FLAG_GHOST = 0x2000000;
    public static final int SAVE_FLAG_NPC_FRIGHT = 0x4000000;
    public static final int SAVE_FLAG_LOOTED = 0x8000000;
    public static final int CTABLE_SIZE = 8;
    public static final int LOOKAHEAD_COUNT = 3;
    public static final int CTABLE_ORIGINX = 4;
    public static final int CTABLE_ORIGINY = 4;
    public static final int TURN_TYPE_NONE = 0;
    private static final int TURN_TYPE_NORMAL = 1;
    private static final int TURN_TYPE_HASTE = 2;
    public static int OFS_MAYAKEY_X = 0;
    public static int OFS_MAYAKEY_Y = 0;
    public static int OFS_MAYAKEY_Z = 0;
    public static int OFS_MAYAKEY_PITCH = 0;
    public static int OFS_MAYAKEY_YAW = 0;
    public static int OFS_MAYAKEY_ROLL = 0;
    public static int OFS_MAYAKEY_MS = 0;
    public static final int NUM_MAYAKEY_FIELDS = 7;
    public static final int OFS_MAYATWEEN_X = 0;
    public static final int OFS_MAYATWEEN_Y = 1;
    public static final int OFS_MAYATWEEN_Z = 2;
    public static final int OFS_MAYATWEEN_PITCH = 3;
    public static final int OFS_MAYATWEEN_YAW = 4;
    public static final int OFS_MAYATWEEN_ROLL = 5;
    public static final int NUM_MAYATWEEN_FIELDS = 6;
    public static short[] ofsMayaTween = new short[6];
    public static int camPlayerX;
    public static int camPlayerY;
    public static int camPlayerZ;
    public static int camPlayerYaw;
    public static int camPlayerPitch;
    public static MayaCamera[] mayaCameras;
    public static int totalMayaCameras;
    public static short[] mayaCameraKeys;
    public static byte[] mayaCameraTweens;
    public static short[] mayaTweenIndices;
    public static int totalMayaCameraKeys;
    public static int totalMayaTweens;
    public static Entity[] entities;
    public static int numEntities;
    public static Entity[] entityDb;
    private static EntityMonster[] entityMonsters;
    private static int numMonsters;
    public static int spawnParam;
    public static boolean disableAI;
    public static boolean skipMinigames;
    public static Entity inactiveMonsters;
    public static Entity activeMonsters;
    public static Entity combatMonsters;
    public static int cinUnpauseTime;
    public static int lastTurnTime;
    public static boolean pauseGameTime;
    public static int firstDropIndex;
    private static int dropIndex;
    private static int lastDropEntIndex;
    public static boolean skippingCinematic;
    public static boolean skipDialog;
    public static boolean skipAdvanceTurn;
    public static boolean queueAdvanceTurn;
    public static char[] keycode;
    public static int monstersTurn;
    private static boolean monstersUpdated;
    public static boolean interpolatingMonsters;
    public static boolean gotoTriggered;
    public static boolean isSaved;
    public static boolean isLoaded;
    public static final int[] eventFlags;
    private static final GameSprite[] gsprites;
    public static int activeSprites;
    public static int activePropogators;
    public static int animatingEffects;
    public static int changeMapParam;
    private static int saveStateMap;
    public static byte difficulty;
    public static int activeLoadType;
    public static boolean updateAutomap;
    public static boolean hasSeenIntro;
    public static final int[] levelVars;
    public static short[] levelNames;
    public static int totalLevelTime;
    public static int curLevelTime;
    public static short lootFound;
    public static short totalLoot;
    public static MayaCamera activeCamera;
    public static int activeCameraTime;
    public static int activeCameraKey;
    public static boolean activeCameraView;
    public static Entity watchLine;
    private static final LerpSprite[] lerpSprites;
    public static int numLerpSprites;
    public static final ScriptThread[] scriptThreads;
    public static int numScriptThreads;
    public static final boolean[] pathVisited;
    public static final short[] pathParents;
    public static final short[] pathSearches;
    public static int numPathSearches;
    public static boolean secretActive;
    public static final int MAXOPENDOORS = 6;
    public static Entity[] openDoors;
    public static int viewX;
    public static int viewY;
    public static int viewAngle;
    public static int destX;
    public static int destY;
    public static int destAngle;
    public static int viewSin;
    public static int viewCos;
    public static int viewStepX;
    public static int viewStepY;
    public static int viewRightStepX;
    public static int viewRightStepY;
    public static final int MAXSTATEVARS = 128;
    public static final int STATEVARMASK = 127;
    public static short[] scriptStateVars;
    public static byte mapSecretsFound;
    public static byte totalSecrets;
    public static int cinematicWeapon;
    public static final int DOORSPEED = 128;
    private static final int MAX_ENTITY_FUNCS = 64;
    private static short[] entityDeathFunctions;
    public static int numDestroyableObj;
    public static int destroyedObj;
    public static final int BOMB_TARGET_SHIFT = 8;
    public static final int BOMB_TARGET_MASK = 0x7FFFFF00;
    public static final int BOMB_TURN_MASK = 255;
    public static final int PLACED_BOMB_Z = 31;
    public static final int MAX_BOMBS = 4;
    public static int[] placedBombs;
    public static final int MAX_GRID_ENTITIES = 9;
    public static final Entity[] gridEntities;
    public static int numMallocsForVIOS;
    public static final int damageModPerMalloc = 8;
    public static boolean angryVIOS;
    public static final int finalTierVIOS = 4;
    public static short[] numLevelLoads;
    public static int totalPlayTime;
    public static int lastSaveTime;
    public static final Entity[] traceEntities;
    public static int[] traceFracs;
    public static int numTraceEntities;
    public static int[] traceBoundingBox;
    public static int[] tracePoints;
    public static int traceCollisionX;
    public static int traceCollisionY;
    public static int traceCollisionZ;
    public static Entity traceEntity;
    public static final int TRACE_SHIFT = 14;
    public static final int TRACE_ONE = 16384;
    public static final int DEFAULT_ENT_RADIUS = 25;
    public static final int MOVEMENT_RADIUS = 16;
    public static final int MIN_RADIUS = 2;
    static final int DOOR_FORCE_SNAP = 0;
    static final int DOOR_FORCE_ANIMATE = 1;
    static final int DOOR_INVIEW_ANIMATE = 2;
    private static int[] dropDirs;
    public static final int LS_UPDATE_NONE = 0;
    public static final int LS_UPDATE_FREED = 1;
    public static final int LS_UPDATE_UPDATEVIEW = 2;
    public static final int LS_UPDATE_REFRESH = 4;
    private static int numCallThreads;
    private static ScriptThread[] callThreads;
    public static final int MEDAL_XP = 10;
    public static final int SECRET_XP = 5;

    Game() {
    }

    public static final boolean startup() {
        levelNames = App.TBL_GAME_LEVELNAMES;
        int n = 0;
        difficulty = 1;
        cinematicWeapon = -1;
        for (n = 0; n < entities.length; ++n) {
            Game.entities[n] = new Entity();
        }
        for (n = 0; n < entityMonsters.length; ++n) {
            Game.entityMonsters[n] = new EntityMonster();
        }
        for (n = 0; n < gsprites.length; ++n) {
            Game.gsprites[n] = new GameSprite();
        }
        for (n = 0; n < lerpSprites.length; ++n) {
            Game.lerpSprites[n] = new LerpSprite();
        }
        for (n = 0; n < scriptThreads.length; ++n) {
            Game.scriptThreads[n] = new ScriptThread();
        }
        for (n = 0; n < 128; ++n) {
            Game.entityDeathFunctions[n] = -1;
        }
        activeMonsters = null;
        combatMonsters = null;
        inactiveMonsters = null;
        Game.keycode[0] = '\u0000';
        gotoTriggered = false;
        disableAI = false;
        skipMinigames = false;
        activeSprites = 0;
        activePropogators = 0;
        mapSecretsFound = 0;
        totalSecrets = 0;
        skipDialog = false;
        for (n = 0; n < 20; ++n) {
            scriptThreads[n].reset();
        }
        return true;
    }

    public static final void unlinkEntity(Entity entity) {
        if (entity == entities[0]) {
            App.Error(4);
            return;
        }
        if (entity == entityDb[entity.linkIndex]) {
            Game.entityDb[entity.linkIndex] = entity.nextOnTile;
        } else if (entity.prevOnTile != null) {
            entity.prevOnTile.nextOnTile = entity.nextOnTile;
        }
        if (entity.nextOnTile != null) {
            entity.nextOnTile.prevOnTile = entity.prevOnTile;
        }
        entity.nextOnTile = null;
        entity.prevOnTile = null;
        entity.info &= 0xFFEFFFFF;
    }

    public static final void linkEntity(Entity entity, int n, int n2) {
        Entity entity2;
        short s = (short)(n2 * 32 + n);
        if (entity == entities[0]) {
            App.Error(3);
            return;
        }
        if (entity.nextOnTile != null || entity.prevOnTile != null || entity == entityDb[s]) {
            App.Error(26);
            return;
        }
        entity.nextOnTile = entity2 = entityDb[s];
        if (entity2 != null) {
            entity2.prevOnTile = entity;
        }
        entity.prevOnTile = null;
        entity.linkIndex = s;
        Game.entityDb[s] = entity;
        entity.info |= 0x100000;
    }

    public static final void unlinkWorldEntity(int n, int n2) {
        short s = (short)(n2 * 32 + n);
        Entity entity = entityDb[s];
        Entity entity2 = entities[0];
        int n3 = n2;
        Entity.baseVisitedTiles[n3] = Entity.baseVisitedTiles[n3] & ~(1 << n);
        if (entity == entity2) {
            Game.entityDb[s] = null;
            short s2 = s;
            Render.mapFlags[s2] = (byte)(Render.mapFlags[s2] & 0xFFFFFFFE);
            return;
        }
        Entity entity3 = null;
        while (entity != null) {
            if (entity == entity2) {
                if (entity3 != null) {
                    entity3.nextOnTile = null;
                }
                short s3 = s;
                Render.mapFlags[s3] = (byte)(Render.mapFlags[s3] & 0xFFFFFFFE);
                return;
            }
            entity3 = entity;
            entity = entity.nextOnTile;
        }
        App.Error(52);
    }

    private static final void linkWorldEntity(int n, int n2) {
        short s = (short)(n2 * 32 + n);
        Entity entity = entityDb[s];
        Entity entity2 = null;
        Entity entity3 = entities[0];
        while (entity != null) {
            if (entity.def.eType == 0) {
                App.Error(27);
                return;
            }
            entity2 = entity;
            entity = entity.nextOnTile;
        }
        if (entity2 == null) {
            Game.entityDb[s] = entity3;
        } else {
            entity2.nextOnTile = entity3;
        }
        entity3.nextOnTile = null;
        entity3.prevOnTile = null;
        entity3.linkIndex = s;
        int n3 = n2;
        Entity.baseVisitedTiles[n3] = Entity.baseVisitedTiles[n3] | 1 << n;
        short s2 = s;
        Render.mapFlags[s2] = (byte)(Render.mapFlags[s2] | 1);
    }

    public static final void remove(Entity entity) {
        if ((entity.info & 0xFFFF) != 0) {
            int n = entity.getSprite();
            Render.mapSpriteInfo[n] = Render.mapSpriteInfo[n] | 0x10000;
        }
        if (0 != (entity.info & 0x100000)) {
            Game.unlinkEntity(entity);
        }
        Player.facingEntity = null;
    }

    public static final void trace(int n, int n2, int n3, int n4, Entity entity, int n5, int n6) {
        Game.trace(n, n2, -1, n3, n4, -1, entity, n5, n6, false);
    }

    public static final void trace(int n, int n2, int n3, int n4, int n5, int n6, Entity entity, int n7, int n8, boolean bl) {
        int n9;
        int n10;
        int[] nArray = tracePoints;
        int[] nArray2 = traceBoundingBox;
        int[] nArray3 = traceFracs;
        Entity[] entityArray = traceEntities;
        traceEntity = null;
        numTraceEntities = 0;
        nArray[0] = n;
        nArray[1] = n2;
        nArray[2] = n4;
        nArray[3] = n5;
        nArray2[0] = Math.max(Math.min(n - n8, n4 - n8), 0);
        nArray2[1] = Math.max(Math.min(n2 - n8, n5 - n8), 0);
        nArray2[2] = Math.min(Math.max(n + n8, n4 + n8), 2047);
        nArray2[3] = Math.min(Math.max(n2 + n8, n5 + n8), 2047);
        int n11 = (nArray2[2] >> 6) + 1;
        for (int i = nArray2[0] >> 6; i < n11; ++i) {
            n10 = (nArray2[3] >> 6) + 1;
            for (n9 = nArray2[1] >> 6; n9 < n10; ++n9) {
                Entity entity2 = entityDb[i + 32 * n9];
                if (entity2 == null) continue;
                while (entity2 != null) {
                    if (entity2 != entity && 0 != (n7 & 1 << entity2.def.eType) && entity2.def.eType != 0) {
                        int n12;
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        int n17;
                        int n18 = entity2.getSprite();
                        if (null != entity2.monster) {
                            if ((entity2.monster.goalFlags & 1) != 0) {
                                n17 = 32 + (entity2.monster.goalX << 6);
                                n16 = 32 + (entity2.monster.goalY << 6);
                                n15 = Render.mapSprites[Render.S_Z + n18];
                            } else {
                                n17 = Render.mapSprites[Render.S_X + n18];
                                n16 = Render.mapSprites[Render.S_Y + n18];
                                n15 = Render.mapSprites[Render.S_Z + n18];
                            }
                        } else if (entity2.def.eType == 1) {
                            n17 = Canvas.destX;
                            n16 = Canvas.destY;
                            n15 = Canvas.destZ;
                        } else {
                            n17 = Render.mapSprites[Render.S_X + n18];
                            n16 = Render.mapSprites[Render.S_Y + n18];
                            n15 = Render.mapSprites[Render.S_Z + n18];
                        }
                        if (n18 != -1 && 0 != (Render.mapSpriteInfo[n18] & 0xF000000)) {
                            n14 = n17;
                            n13 = n16;
                            if (0 != (Render.mapSpriteInfo[n18] & 0x3000000)) {
                                n17 -= 32;
                                n14 += 32;
                            } else {
                                n16 -= 32;
                                n13 += 32;
                            }
                            Render.traceLine[0] = n17;
                            Render.traceLine[1] = n16;
                            Render.traceLine[2] = n14;
                            Render.traceLine[3] = n13;
                            n12 = Render.CapsuleToLineTrace(nArray, n8 * n8, Render.traceLine);
                            if (n12 < 16384) {
                                nArray3[Game.numTraceEntities] = n12;
                                entityArray[Game.numTraceEntities++] = entity2;
                            }
                        } else {
                            n14 = 625;
                            if (entity2.def.eType == 8) {
                                n14 = 256;
                            }
                            if ((n13 = Render.CapsuleToCircleTrace(nArray, n8 * n8, n17, n16, n14)) < 16384) {
                                if (n3 >= 0 && n6 >= 0 && bl) {
                                    n12 = n3 + ((n6 - n3) * n13 >> 14);
                                    if ((n12 -= n15) > -(32 + n8) && n12 < 32 + n8) {
                                        nArray3[Game.numTraceEntities] = n13;
                                        entityArray[Game.numTraceEntities++] = entity2;
                                    }
                                } else {
                                    nArray3[Game.numTraceEntities] = n13;
                                    entityArray[Game.numTraceEntities++] = entity2;
                                }
                            }
                        }
                    }
                    entity2 = entity2.nextOnTile;
                }
            }
        }
        if (0 != (n7 & 1)) {
            n9 = Render.traceWorld(0, nArray, n8, nArray2, n7);
            if (n9 < 16384) {
                nArray3[Game.numTraceEntities] = n9;
                entityArray[Game.numTraceEntities++] = entities[0];
                traceCollisionX = n + (n9 * (n4 - n) >> 14);
                traceCollisionY = n2 + (n9 * (n5 - n2) >> 14);
                traceCollisionZ = n3 + (n9 * (n6 - n3) >> 14);
            } else {
                traceCollisionX = n4;
                traceCollisionY = n5;
                traceCollisionZ = n6;
            }
        }
        if (numTraceEntities > 0) {
            for (n9 = 0; n9 < numTraceEntities - 1; ++n9) {
                for (n10 = 0; n10 < numTraceEntities - 1 - n9; ++n10) {
                    if (nArray3[n10 + 1] >= nArray3[n10]) continue;
                    int n19 = nArray3[n10];
                    nArray3[n10] = nArray3[n10 + 1];
                    nArray3[n10 + 1] = n19;
                    Entity entity3 = entityArray[n10];
                    entityArray[n10] = entityArray[n10 + 1];
                    entityArray[n10 + 1] = entity3;
                }
            }
            traceEntity = entityArray[0];
        }
    }

    public static final void loadMapEntities() {
        int n;
        int n2;
        interpolatingMonsters = false;
        monstersTurn = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            Game.openDoors[n2] = null;
        }
        watchLine = null;
        Player.setPickUpWeapon(15);
        for (n2 = 0; n2 < 4; ++n2) {
            Game.placedBombs[n2] = 0;
        }
        for (n2 = 0; n2 < 275; ++n2) {
            entities[n2].reset();
        }
        for (n2 = 0; n2 < levelVars.length; ++n2) {
            Game.levelVars[n2] = 0;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            Entity.baseVisitedTiles[n2] = 0;
        }
        secretActive = false;
        numMonsters = 0;
        numLerpSprites = 0;
        for (n2 = 0; n2 < 16; ++n2) {
            Game.lerpSprites[n2].hSprite = 0;
        }
        numScriptThreads = 0;
        for (n2 = 0; n2 < 20; ++n2) {
            scriptThreads[n2].reset();
        }
        numEntities = 0;
        Entity entity = entities[numEntities++];
        entity.def = EntityDef.find(0, 0);
        entity.name = (short)(entity.def.name | 0x400);
        entity = entities[numEntities++];
        entity.def = EntityDef.find(1, 0);
        entity.name = (short)(entity.def.name | 0x400);
        entity.info = 131072;
        EntityDef entityDef = EntityDef.find(12, 0);
        EntityDef entityDef2 = EntityDef.find(13, 0);
        int n3 = 0;
        for (n2 = 0; n2 < Render.numMapSprites; ++n2) {
            short s;
            int n4 = Render.mapSpriteInfo[n2] & 0xFF;
            if ((Render.mapSpriteInfo[n2] & 0x400000) != 0) {
                n4 += 257;
            }
            n = Render.mediaMappings[n4 + 1] - Render.mediaMappings[n4];
            if (n4 == 234) {
                n = 4;
            }
            if (n4 == 156) {
                n = 2;
                int n5 = n2;
                Render.mapSpriteInfo[n5] = Render.mapSpriteInfo[n5] & 0xFFFF00FF;
                int n6 = n2;
                Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] | (n << 8 | 0x80000);
            }
            if (n4 == 236) {
                n = 3;
                int n7 = n2;
                Render.mapSpriteInfo[n7] = Render.mapSpriteInfo[n7] & 0xFFFF00FF;
                int n8 = n2;
                Render.mapSpriteInfo[n8] = Render.mapSpriteInfo[n8] | (n << 8 | 0x80000);
                Render.mapSprites[Render.S_RENDERMODE + n2] = 3;
            }
            if (n4 == 136 || n4 == 234 || n4 == 130) {
                int n9 = n2;
                Render.mapSpriteInfo[n9] = Render.mapSpriteInfo[n9] & 0xFFFF00FF;
                int n10 = n2;
                Render.mapSpriteInfo[n10] = Render.mapSpriteInfo[n10] | (n << 8 | 0x80000);
            }
            if ((Render.mapSpriteInfo[n2] & 0x200000) != 0) {
                int n11 = n2;
                Render.mapSpriteInfo[n11] = Render.mapSpriteInfo[n11] & 0xFFDFFFFF;
                continue;
            }
            int n12 = Render.mapSprites[Render.S_X + n2];
            int n13 = Render.mapSprites[Render.S_Y + n2];
            EntityDef entityDef3 = EntityDef.lookup(n4);
            if (n4 >= 1 && n4 < 14) {
                int n14 = n2;
                Render.mapSpriteInfo[n14] = Render.mapSpriteInfo[n14] | 0x200;
            }
            if ((Render.mapSpriteInfo[n2] & 0xF000000) != 0 && ((n12 & 0x3F) == 0 || (n13 & 0x3F) == 0)) {
                if ((Render.mapSpriteInfo[n2] & 0x4000000) != 0) {
                    ++n12;
                } else if ((Render.mapSpriteInfo[n2] & 0x2000000) != 0) {
                    ++n13;
                } else if ((Render.mapSpriteInfo[n2] & 0x1000000) != 0) {
                    --n13;
                } else if ((Render.mapSpriteInfo[n2] & 0x8000000) != 0) {
                    --n12;
                }
            }
            if (entityDef3 != null) {
                if (numEntities == 275) {
                    App.Error(35);
                    return;
                }
                s = (short)numEntities;
                entity = entities[numEntities++];
                entity.info = n2 + 1 & 0xFFFF;
                entity.def = entityDef3;
                if (entity.def.eType == 2) {
                    if (numMonsters == 80) {
                        App.Error(37);
                        return;
                    }
                    entity.monster = entityMonsters[numMonsters++];
                    entity.monster.reset();
                    int n15 = n2;
                    Render.mapSpriteInfo[n15] = Render.mapSpriteInfo[n15] & 0xF0FFFFFF;
                    if ((App.nextByte() & 1) == 0 && !entity.isBoss()) {
                        int n16 = n2;
                        Render.mapSpriteInfo[n16] = Render.mapSpriteInfo[n16] | 0x20000;
                    }
                    entity.info |= 0x40000;
                    Game.deactivate(entity);
                } else if (entity.def.eType == 10 && entity.def.eSubType != 3 && entity.def.eSubType != 2) {
                    ++numDestroyableObj;
                }
                entity.initspawn();
                Render.mapSprites[Render.S_ENT + n2] = s;
                if ((Render.mapSpriteInfo[n2] & 0x10000) == 0) {
                    Game.linkEntity(entity, n12 >> 6, n13 >> 6);
                }
                if (n4 >= 140 && n4 <= 143) {
                    int n17 = n2;
                    Render.mapSpriteInfo[n17] = Render.mapSpriteInfo[n17] | 0x10000;
                }
                ++n3;
            } else if ((Render.mapSpriteInfo[n2] & 0x800000) != 0) {
                if (numEntities == 275) {
                    App.Error(35);
                    return;
                }
                s = (short)numEntities;
                entity = entities[numEntities++];
                entity.info = n2 + 1 & 0xFFFF;
                entity.def = n4 == 166 || n4 == 168 ? entityDef2 : entityDef;
                entity.name = (short)(entity.def.name | 0x400);
                Render.mapSprites[Render.S_ENT + n2] = s;
                if ((Render.mapSpriteInfo[n2] & 0x10000) == 0) {
                    Game.linkEntity(entity, n12 >> 6, n13 >> 6);
                }
                ++n3;
            }
            if ((n2 & 0xF) != 15) continue;
            Canvas.updateLoadingBar(false);
        }
        firstDropIndex = numEntities;
        for (n2 = 0; n2 < 16; ++n2) {
            if (numEntities == 275) {
                App.Error(35);
                return;
            }
            entity = entities[numEntities++];
            entity.info = Render.firstDropSprite + n2 + 1 & 0xFFFF;
            int n18 = Render.dropSprites[n2];
            Render.mapSpriteInfo[n18] = Render.mapSpriteInfo[n18] | 0x10000;
            ++n3;
        }
        for (n2 = 0; n2 < 1024; ++n2) {
            if ((Render.mapFlags[n2] & 1) == 0) continue;
            Entity entity2 = entityDb[n2];
            n = 1;
            while (entity2 != null) {
                entity2 = entity2.nextOnTile;
            }
            if (n == 0) continue;
            Game.linkWorldEntity(n2 % 32, n2 / 32);
        }
    }

    public static final void loadTableCamera(int n, int n2) {
        short s;
        short[] sArray = null;
        byte[] byArray = null;
        sArray = new short[Resource.getNumTableShorts(n)];
        byArray = new byte[Resource.getNumTableBytes(n2)];
        try {
            Resource.beginTableLoading();
            Resource.loadShortTable(sArray, n);
            Resource.loadByteTable(byArray, n2);
            Resource.finishTableLoading();
        }
        catch (Exception exception) {
            App.Error(exception, -1);
        }
        mayaCameras = new MayaCamera[1];
        Game.mayaCameras[0] = new MayaCamera();
        Game.mayaCameras[0].isTableCam = true;
        int n3 = 0;
        totalMayaCameraKeys = sArray[n3++];
        totalMayaCameras = 1;
        Game.mayaCameras[0].sampleRate = sArray[n3++];
        MayaCamera.posShift = 4 - sArray[n3++];
        MayaCamera.angleShift = 10 - sArray[n3++];
        int n4 = totalMayaCameraKeys * 7;
        mayaCameraKeys = new short[n4];
        System.arraycopy(sArray, n3, mayaCameraKeys, 0, n4);
        n3 += n4;
        n4 = totalMayaCameraKeys * 6;
        mayaTweenIndices = new short[n4];
        System.arraycopy(sArray, n3, mayaTweenIndices, 0, n4);
        n3 += n4;
        Game.ofsMayaTween[0] = 0;
        Game.ofsMayaTween[1] = s = sArray[n3++];
        Game.ofsMayaTween[2] = s = (short)(s + sArray[n3++]);
        Game.ofsMayaTween[3] = s = (short)(s + sArray[n3++]);
        Game.ofsMayaTween[4] = s = (short)(s + sArray[n3++]);
        Game.ofsMayaTween[5] = s = (short)(s + sArray[n3++]);
        mayaCameraTweens = new byte[byArray.length];
        System.arraycopy(byArray, 0, mayaCameraTweens, 0, byArray.length);
        Game.mayaCameras[0].keyOffset = 0;
        Game.mayaCameras[0].numKeys = totalMayaCameraKeys;
        Game.mayaCameras[0].complete = false;
        Game.mayaCameras[0].keyThreadResumeCount = totalMayaCameraKeys;
        Game.setKeyOffsets();
        sArray = null;
        byArray = null;
        System.gc();
    }

    public static final void setKeyOffsets() {
        OFS_MAYAKEY_X = 0;
        OFS_MAYAKEY_Y = totalMayaCameraKeys;
        OFS_MAYAKEY_Z = totalMayaCameraKeys * 2;
        OFS_MAYAKEY_PITCH = totalMayaCameraKeys * 3;
        OFS_MAYAKEY_YAW = totalMayaCameraKeys * 4;
        OFS_MAYAKEY_ROLL = totalMayaCameraKeys * 5;
        OFS_MAYAKEY_MS = totalMayaCameraKeys * 6;
    }

    public static final void loadMayaCameras(InputStream inputStream) {
        short[] sArray = mayaCameraKeys;
        byte[] byArray = mayaCameraTweens;
        short[] sArray2 = mayaTweenIndices;
        int n = 0;
        short[] sArray3 = new short[6];
        int n2 = 0;
        int[] nArray = new int[6];
        int n3 = 0;
        int n4 = 0;
        try {
            for (n4 = 0; n4 < totalMayaCameras; ++n4) {
                int n5;
                Resource.read(inputStream, 3);
                Game.mayaCameras[n4].numKeys = Resource.shiftByte();
                Game.mayaCameras[n4].sampleRate = Resource.shiftShort();
                int n6 = Game.mayaCameras[n4].numKeys * 7 * 2;
                Resource.read(inputStream, n6);
                Game.mayaCameras[n4].keyOffset = n;
                for (n3 = 0; n3 < 7; ++n3) {
                    for (n5 = 0; n5 < Game.mayaCameras[n4].numKeys; ++n5) {
                        sArray[Game.totalMayaCameraKeys * n3 + n + n5] = Resource.shiftShort();
                    }
                }
                n += Game.mayaCameras[n4].numKeys;
                n6 = Game.mayaCameras[n4].numKeys * 6 * 2;
                Resource.read(inputStream, n6);
                n5 = 0;
                n3 = 0;
                while (n3 < n6 / 2) {
                    n5 = Resource.shiftShort();
                    if (n5 >= 0) {
                        n5 = (short)(n5 + sArray3[n3 % 6]);
                    }
                    sArray2[n2] = n5;
                    ++n3;
                    ++n2;
                }
                n6 = 0;
                Resource.read(inputStream, 12);
                for (n3 = 0; n3 < 6; ++n3) {
                    nArray[n3] = Resource.shiftShort();
                    n6 += nArray[n3];
                }
                Resource.readMarker(inputStream, -559038737);
                Resource.read(inputStream, n6);
                for (n3 = 0; n3 < 6; ++n3) {
                    for (int i = 0; i < nArray[n3]; ++i) {
                        byArray[Game.ofsMayaTween[n3] + sArray3[n3]] = Resource.shiftByte();
                        int n7 = n3;
                        sArray3[n7] = (short)(sArray3[n7] + 1);
                    }
                }
            }
        }
        catch (IOException iOException) {
            App.Error(new Exception("Error loading Maya Camera " + n4), 103);
        }
    }

    public static final void unloadMapData() {
        activeSprites = 0;
        animatingEffects = 0;
        activePropogators = 0;
        cinematicWeapon = -1;
        activeCameraView = false;
        activeCamera = null;
        Player.facingEntity = null;
        Combat.curTarget = null;
        Combat.curAttacker = null;
        Hud.lastTarget = null;
        int n = 0;
        for (n = 0; n < 48; ++n) {
            if (0 == (Game.gsprites[n].flags & 1)) continue;
            Game.gsprite_destroy(gsprites[n]);
        }
        inactiveMonsters = null;
        activeMonsters = null;
        combatMonsters = null;
        Game.keycode[0] = '\u0000';
        for (n = 0; n < 1024; ++n) {
            Game.entityDb[n] = null;
        }
        for (n = 0; n < numEntities; ++n) {
            entities[n].reset();
        }
        for (n = 0; n < 128; ++n) {
            Game.entityDeathFunctions[n] = -1;
        }
        totalMayaCameraKeys = 0;
        totalMayaCameras = 0;
        mayaCameraKeys = null;
        mayaCameras = null;
        mayaCameraTweens = null;
        mayaTweenIndices = null;
        Combat.weaponDown = false;
        numDestroyableObj = 0;
        destroyedObj = 0;
        lootFound = 0;
        Canvas.showingLoot = false;
        angryVIOS = false;
    }

    public static final boolean touchTile(int n, int n2, boolean bl) {
        boolean bl2 = false;
        Entity entity = Game.findMapEntity(n, n2);
        while (entity != null) {
            Entity entity2 = entity.nextOnTile;
            if (bl || entity.def.eType == 8) {
                entity.touched();
                bl2 = true;
            }
            entity = entity2;
        }
        return bl2;
    }

    private static final void prepareMonsters() {
        int n = Canvas.loadMapID - 1;
        if (!isLoaded && 0 != (Player.completedLevels & 1 << n) && Player.monsterStats[0] == Player.monsterStats[1]) {
            Player.fillMonsterStats();
            int n2 = 0;
            int n3 = Player.monsterStats[1];
            int n4 = n3 - Player.monsterStats[0];
            for (int i = 0; i < numEntities; ++i) {
                Entity entity = entities[i];
                if (entity.monster == null) continue;
                int n5 = entity.getSprite();
                EntityMonster entityMonster = entity.monster;
                if (0 == (entity.info & 0x1010000) || 0 != (entityMonster.flags & 0x90) || n4 >= n3 / 2 || n2 >= 8 || App.nextByte() > 100 || Game.findMapEntity(Render.mapSprites[Render.S_X + n5], Render.mapSprites[Render.S_Y + n5], 15535) != null) continue;
                entity.resurrect(Render.mapSprites[Render.S_X + n5], Render.mapSprites[Render.S_Y + n5], 32);
                entity.info &= 0xFFBFFFFF;
                ++n4;
                ++n2;
            }
        }
    }

    public static final Entity findMapEntity(int n, int n2) {
        if ((n >>= 6) < 0 || n >= 32 || (n2 >>= 6) < 0 || n2 >= 32) {
            return null;
        }
        return entityDb[n2 * 32 + n];
    }

    public static final Entity findMapEntity(int n, int n2, int n3) {
        if ((n3 & 2) != 0 && n >> 6 == Canvas.destX >> 6 && n2 >> 6 == Canvas.destY >> 6) {
            return entities[1];
        }
        Entity entity = Game.findMapEntity(n, n2);
        while (entity != null) {
            if ((n3 & 1 << entity.def.eType) != 0) {
                return entity;
            }
            entity = entity.nextOnTile;
        }
        return null;
    }

    public static final void activate(Entity entity) {
        Game.activate(entity, true, false, true, false);
    }

    public static final void activate(Entity entity, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        EntityMonster entityMonster = entity.monster;
        if (((Render.mapSpriteInfo[entity.getSprite()] & 0xFF00) >> 8 & 0xF0) == 16 && !Render.shotsFired) {
            return;
        }
        if (bl2 && entity.distFrom(Canvas.viewX, Canvas.viewY) > Combat.tileDistances[3]) {
            return;
        }
        entity.info |= 0x400000;
        if (Player.noclip) {
            return;
        }
        if ((entity.info & 0x40000) != 0) {
            return;
        }
        int n = entity.getSprite();
        Render.mapSpriteInfo[n] = Render.mapSpriteInfo[n] & 0xFFFF00FF | 0;
        if (entityMonster.nextOnList != null) {
            if (entity == inactiveMonsters && entityMonster.nextOnList == inactiveMonsters) {
                inactiveMonsters = null;
            } else {
                if (entity == inactiveMonsters) {
                    inactiveMonsters = entityMonster.nextOnList;
                }
                entityMonster.nextOnList.monster.prevOnList = entityMonster.prevOnList;
                entityMonster.prevOnList.monster.nextOnList = entityMonster.nextOnList;
            }
        }
        if (activeMonsters == null) {
            entityMonster.prevOnList = entityMonster.nextOnList = entity;
            activeMonsters = entityMonster.nextOnList;
        } else {
            entityMonster.prevOnList = Game.activeMonsters.monster.prevOnList;
            entityMonster.nextOnList = activeMonsters;
            Game.activeMonsters.monster.prevOnList.monster.nextOnList = entity;
            Game.activeMonsters.monster.prevOnList = entity;
        }
        entity.info |= 0x40000;
        entityMonster.flags = (short)(entityMonster.flags & 0xFFFFFFF7);
        if (bl && 0 != (entityMonster.flags & 2)) {
            Game.executeStaticFunc(9);
            entityMonster.flags = (short)(entityMonster.flags & 0xFFFFFFFD);
        }
    }

    public static final void killAll() {
        for (int i = 0; i < numEntities; ++i) {
            Entity entity = entities[i];
            if (entity.def == null || entity.def.eType != 2 || entity.isBoss() || (entity.info & 0x20000) == 0 || (entity.monster.flags & 0x80) != 0) continue;
            entity.died(false, null);
        }
    }

    public static final void deactivate(Entity entity) {
        EntityMonster entityMonster = entity.monster;
        if ((entity.info & 0x40000) == 0) {
            return;
        }
        if (entityMonster.nextOnList != null) {
            if (entity == activeMonsters && entityMonster.nextOnList == activeMonsters) {
                activeMonsters = null;
            } else {
                if (entity == activeMonsters) {
                    activeMonsters = entityMonster.nextOnList;
                }
                entityMonster.nextOnList.monster.prevOnList = entityMonster.prevOnList;
                entityMonster.prevOnList.monster.nextOnList = entityMonster.nextOnList;
            }
        }
        if (inactiveMonsters == null) {
            entityMonster.prevOnList = entityMonster.nextOnList = entity;
            inactiveMonsters = entityMonster.nextOnList;
        } else {
            entityMonster.prevOnList = Game.inactiveMonsters.monster.prevOnList;
            entityMonster.nextOnList = inactiveMonsters;
            Game.inactiveMonsters.monster.prevOnList.monster.nextOnList = entity;
            Game.inactiveMonsters.monster.prevOnList = entity;
        }
        entity.info &= 0xFFFBFFFF;
    }

    public static final void UpdatePlayerVars() {
        viewX = Canvas.viewX;
        viewY = Canvas.viewY;
        viewAngle = Canvas.viewAngle;
        destX = Canvas.destX;
        destY = Canvas.destY;
        destAngle = Canvas.destAngle;
        viewSin = Canvas.viewSin;
        viewCos = Canvas.viewCos;
        viewStepX = Canvas.viewStepX;
        viewStepY = Canvas.viewStepY;
        viewRightStepX = Canvas.viewRightStepX;
        viewRightStepY = Canvas.viewRightStepY;
    }

    private static final void monsterAI() {
        if (disableAI) {
            return;
        }
        if (monstersUpdated) {
            return;
        }
        monstersUpdated = true;
        combatMonsters = null;
        if (activeMonsters != null) {
            Entity entity;
            boolean bl = false;
            Entity entity2 = activeMonsters;
            do {
                entity = entity2.monster.nextOnList;
                if (0 != (entity2.monster.monsterEffects & 2) || monstersTurn != 1 && (monstersTurn != 2 || !entity2.isHasteResistant())) continue;
                entity2.aiThink(false);
                if ((entity2.monster.goalFlags & 1) == 0) continue;
                bl = true;
            } while ((entity2 = entity) != activeMonsters && activeMonsters != null);
            while (bl) {
                bl = false;
                entity2 = combatMonsters;
                while (entity2 != null) {
                    entity = entity2.monster.nextAttacker;
                    if (!entity2.aiIsAttackValid()) {
                        entity2.undoAttack();
                        entity2.aiThink(false);
                        if ((entity2.monster.goalFlags & 1) != 0) {
                            bl = true;
                        }
                    }
                    entity2 = entity;
                }
            }
        }
    }

    public static final void monsterLerp() {
        boolean bl = false;
        boolean bl2 = false;
        if (!interpolatingMonsters) {
            return;
        }
        if (activeMonsters != null) {
            Entity entity = activeMonsters;
            do {
                if ((entity.monster.goalFlags & 1) == 0) continue;
                bl = true;
                if (bl2 || !Render.checkTileVisibilty(entity.monster.goalX, entity.monster.goalY)) continue;
                bl2 = true;
            } while ((entity = entity.monster.nextOnList) != activeMonsters);
        }
        if (bl && bl2) {
            Canvas.invalidateRect();
        }
        interpolatingMonsters = bl;
    }

    public static final void spawnPlayer() {
        int n;
        int n2;
        int n3;
        if (spawnParam == 0) {
            if (Canvas.loadType == 3) {
                n3 = 3;
                n2 = 15;
                n = 6;
            } else {
                n3 = Render.mapSpawnIndex % 32;
                n2 = Render.mapSpawnIndex / 32;
                n = Render.mapSpawnDir;
            }
        } else {
            n3 = spawnParam & 0x1F;
            n2 = spawnParam >> 5 & 0x1F;
            n = spawnParam >> 10 & 0xFF;
            spawnParam = 0;
        }
        int n4 = n << 7 & 0x3FF;
        Canvas.viewX = Canvas.destX = n3 * 64 + 32;
        Canvas.viewY = Canvas.destY = n2 * 64 + 32;
        Canvas.viewZ = Canvas.destZ = Render.getHeight(Canvas.viewX, Canvas.viewY) + 36;
        Canvas.viewAngle = Canvas.destAngle = n4;
        Player.relink();
        lastTurnTime = App.time;
        Canvas.invalidateRect();
    }

    public static final void eventFlagsForMovement(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        Game.eventFlags[0] = 2;
        Game.eventFlags[1] = 1;
        eventFlags[0] = eventFlags[0] | Game.eventFlagForDirection(n5, n6);
        eventFlags[1] = eventFlags[1] | Game.eventFlagForDirection(-n5, -n6);
    }

    public static final int eventFlagForDirection(int n, int n2) {
        int n3 = n > 0 ? (n2 < 0 ? 32 : (n2 > 0 ? 2048 : 16)) : (n < 0 ? (n2 < 0 ? 128 : (n2 > 0 ? 512 : 256)) : (n2 > 0 ? 1024 : 64));
        return n3;
    }

    public static final void givemap(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        for (n8 = 0; n8 < Render.numLines; ++n8) {
            int n9 = n8 >> 1;
            Render.lineFlags[n9] = (byte)(Render.lineFlags[n9] | 8 << ((n8 & 1) << 2));
        }
        n8 = Render.numMapSprites;
        for (n7 = 0; n7 < n8; ++n7) {
            n6 = Render.mapSprites[Render.S_X + n7] >> 6;
            n5 = Render.mapSprites[Render.S_Y + n7] >> 6;
            if (n6 < n || n6 >= n + n3 || n5 < n2 || n5 >= n2 + n4) continue;
            int n10 = n7;
            Render.mapSpriteInfo[n10] = Render.mapSpriteInfo[n10] | 0x200000;
        }
        for (n7 = n2; n7 < n2 + n4; ++n7) {
            for (n6 = n; n6 < n + n3; ++n6) {
                n5 = Render.mapFlags[n7 * 32 + n6];
                if ((n5 & 1) != 0) continue;
                Render.mapFlags[n7 * 32 + n6] = (byte)(n5 | 0x80);
            }
        }
    }

    public static final boolean performDoorEvent(int n, Entity entity, int n2) {
        return Game.performDoorEvent(n, entity, n2, false);
    }

    public static final boolean performDoorEvent(int n, Entity entity, int n2, boolean bl) {
        return Game.performDoorEvent(n, null, entity, n2, bl);
    }

    public static final boolean performDoorEvent(int n, ScriptThread scriptThread, Entity entity, int n2, boolean bl) {
        Object object;
        boolean bl2;
        boolean bl3;
        int n3 = entity.getSprite();
        int n4 = Render.mapSpriteInfo[n3];
        int n5 = n4 & 0xFF;
        boolean bl4 = bl3 = (entity.info & 0x100000) == 0;
        if ((n4 & 0x400000) != 0) {
            n5 += 257;
        }
        boolean bl5 = bl2 = n5 >= 271 && n5 < 281;
        if (entity.def.eSubType == 1) {
            return false;
        }
        if (n == 0 && bl3 && bl2) {
            Game.updatePlayerDoors(entity, true);
            return false;
        }
        if (n == 1 && !bl3) {
            return false;
        }
        boolean bl6 = bl3 = !bl3;
        if (!bl3 && bl2) {
            object = Game.findMapEntity(entity.linkIndex % 32 << 6, entity.linkIndex / 32 << 6);
            while (object != null) {
                if (((Entity)object).def.eType == 2 && ((Entity)object).def.eSubType != 17) {
                    watchLine = entity;
                    return false;
                }
                object = ((Entity)object).nextOnTile;
            }
            if (watchLine == entity) {
                watchLine = null;
            }
            Game.linkEntity(entity, entity.linkIndex % 32, entity.linkIndex / 32);
        }
        object = Game.allocLerpSprite(scriptThread, n3, true);
        Render.mapSpriteInfo[n3] = n4 & 0xFFFEFFFF;
        if (bl) {
            secretActive = true;
            ((LerpSprite)object).flags |= 0x100;
        } else {
            ((LerpSprite)object).flags |= 0x40;
            int n6 = n3;
            Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] | Integer.MIN_VALUE;
        }
        ((LerpSprite)object).dstX = ((LerpSprite)object).srcX = Render.mapSprites[Render.S_X + n3];
        ((LerpSprite)object).dstY = ((LerpSprite)object).srcY = Render.mapSprites[Render.S_Y + n3];
        ((LerpSprite)object).dstZ = ((LerpSprite)object).srcZ = Render.mapSprites[Render.S_Z + n3];
        ((LerpSprite)object).dstScale = ((LerpSprite)object).srcScale = Render.mapSprites[Render.S_SCALEFACTOR + n3];
        int n7 = 32;
        if (n == 1) {
            n7 = -n7;
        }
        if (0 != (n4 & 0x3000000)) {
            if (bl) {
                ((LerpSprite)object).dstY = (n4 & 0x1000000) != 0 ? (((LerpSprite)object).dstY += n7) : (((LerpSprite)object).dstY -= n7);
            } else if ((entity.def.parm & 1) == 0) {
                ((LerpSprite)object).dstX += n7;
            }
        } else if (0 != (n4 & 0xC000000)) {
            if (bl) {
                ((LerpSprite)object).dstX = (n4 & 0x8000000) != 0 ? (((LerpSprite)object).dstX += n7) : (((LerpSprite)object).dstX -= n7);
            } else if ((entity.def.parm & 1) == 0) {
                ((LerpSprite)object).dstY += n7;
            }
        }
        ((LerpSprite)object).startTime = App.gameTime;
        ((LerpSprite)object).travelTime = 750;
        ((LerpSprite)object).flags |= 0x30;
        if (n == 1) {
            ((LerpSprite)object).flags &= 0xFFFFFFAF;
            ((LerpSprite)object).flags |= 0x80;
            ((LerpSprite)object).dstScale = 64;
            if (!bl && bl2) {
                Game.updatePlayerDoors(entity, false);
            }
        } else if (n == 0 && !bl) {
            if (bl2) {
                Game.updatePlayerDoors(entity, true);
            }
            ((LerpSprite)object).dstScale = 0;
        }
        Render.mapSprites[Render.S_SCALEFACTOR + n3] = (byte)((LerpSprite)object).srcScale;
        Render.mapSprites[Render.S_X + n3] = (short)((LerpSprite)object).srcX;
        Render.mapSprites[Render.S_Y + n3] = (short)((LerpSprite)object).srcY;
        Render.mapSprites[Render.S_Z + n3] = (short)((LerpSprite)object).srcZ;
        Sound.playSound(0);
        if (bl2 && (((LerpSprite)object).flags & 0x80) == 0) {
            Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] & 0xFFFF00FF | 0x100;
        }
        if (n2 == 0 || Canvas.state == 6 || n2 == 2 && Render.cullBoundingBox(((LerpSprite)object).srcX + ((LerpSprite)object).dstX >> 1, ((LerpSprite)object).srcY + ((LerpSprite)object).dstY >> 1, true)) {
            Game.snapLerpSprites(n3);
        }
        return true;
    }

    public static final void lerpSpriteAsDoor(int n, int n2, ScriptThread scriptThread) {
        LerpSprite lerpSprite = Game.allocLerpSprite(scriptThread, n, false);
        int n3 = n;
        Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] & 0xFFFEFFFF;
        int n4 = Render.mapSpriteInfo[n];
        int n5 = 64;
        if (n2 == 1) {
            n5 = -n5;
        }
        lerpSprite.flags |= 0x40;
        int n6 = n;
        Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] | Integer.MIN_VALUE;
        Render.mapSprites[Render.S_SCALEFACTOR + n] = 256;
        lerpSprite.dstX = lerpSprite.srcX = Render.mapSprites[Render.S_X + n];
        lerpSprite.dstY = lerpSprite.srcY = Render.mapSprites[Render.S_Y + n];
        lerpSprite.dstZ = lerpSprite.srcZ = Render.mapSprites[Render.S_Z + n];
        lerpSprite.srcScale = 64;
        lerpSprite.dstScale = 64;
        if (0 != (n4 & 0x3000000)) {
            lerpSprite.dstX += n5;
        } else if (0 != (n4 & 0xC000000)) {
            lerpSprite.dstY += n5;
        }
        lerpSprite.startTime = App.gameTime;
        lerpSprite.travelTime = 750;
        lerpSprite.flags |= 0x30;
        if (n2 == 1) {
            lerpSprite.flags &= 0xFFFFFFAF;
            lerpSprite.flags |= 0x80;
        }
        Render.mapSprites[Render.S_X + n] = (short)lerpSprite.srcX;
        Render.mapSprites[Render.S_Y + n] = (short)lerpSprite.srcY;
        Render.mapSprites[Render.S_Z + n] = (short)lerpSprite.srcZ;
    }

    private static final void updatePlayerDoors(Entity entity, boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < 6; ++i) {
            if ((!bl || openDoors[i] != null) && (bl || openDoors[i] != entity)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            Game.openDoors[i] = bl ? entity : null;
        }
    }

    public static final boolean CanCloseDoor(Entity entity) {
        if (Player.isFamiliar) {
            return false;
        }
        int n = (entity.linkIndex % 32 << 6) + 32;
        int n2 = (entity.linkIndex / 32 << 6) + 32;
        int n3 = entity.getSprite();
        if (null != Game.findMapEntity(n, n2, 6)) {
            return false;
        }
        int n4 = 64;
        int n5 = 64;
        if ((Render.mapSpriteInfo[n3] & 0x3000000) == 0) {
            n5 = 0;
        } else {
            n4 = 0;
        }
        if (null != Game.findMapEntity(n + n4, n2 + n5, 6)) {
            return false;
        }
        return null == Game.findMapEntity(n - n4, n2 - n5, 6);
    }

    public static final void advanceTurn() {
        int n;
        queueAdvanceTurn = false;
        if (interpolatingMonsters) {
            App.Error(95);
        }
        boolean bl = false;
        if (Player.statusEffects[2] > 0) {
            Player.statusEffects[20] = Player.statusEffects[20] + 1;
            if (Player.statusEffects[20] % 2 == 0) {
                bl = true;
            }
        } else {
            bl = true;
        }
        Canvas.pushedWall = false;
        Player.advanceTurn();
        Game.updateBombs();
        monstersTurn = bl ? 1 : 2;
        monstersUpdated = false;
        lastTurnTime = App.time;
        if (bl) {
            for (n = 0; n < numEntities; ++n) {
                entities[n].updateMonsterFX();
            }
            Canvas.updateFacingEntity = true;
        }
        for (n = 0; n < 6; ++n) {
            Entity entity;
            Entity[] entityArray = openDoors;
            if (entityArray[n] == null || !Game.CanCloseDoor(entity = entityArray[n])) continue;
            Game.performDoorEvent(1, entity, 2);
        }
        Game.executeStaticFunc(6);
        Canvas.startRotation(true);
    }

    public static final void gsprite_clear(int n) {
        for (int i = 0; i < 48; ++i) {
            GameSprite gameSprite = gsprites[i];
            if ((gameSprite.flags & 1) == 0 || (gameSprite.flags & n) == 0) continue;
            Game.gsprite_destroy(gameSprite);
        }
    }

    public static final GameSprite gsprite_alloc(int n, int n2, int n3) {
        int n4 = 0;
        for (n4 = 0; n4 < 48 && (Game.gsprites[n4].flags & 1) != 0; ++n4) {
        }
        if (n4 == 48) {
            App.Error(34);
            return null;
        }
        GameSprite gameSprite = gsprites[n4];
        gameSprite.sprite = Render.customSprites[n4];
        for (n4 = 0; n4 < 6; ++n4) {
            gameSprite.pos[n4] = 0;
        }
        gameSprite.vel[2] = 0;
        gameSprite.vel[1] = 0;
        gameSprite.vel[0] = 0;
        gameSprite.duration = 0;
        gameSprite.time = App.time;
        gameSprite.data = null;
        Render.mapSprites[Render.S_ENT + gameSprite.sprite] = -1;
        Render.mapSprites[Render.S_RENDERMODE + gameSprite.sprite] = 0;
        Render.mapSprites[Render.S_SCALEFACTOR + gameSprite.sprite] = 64;
        gameSprite.flags = n3 | 1;
        Render.mapSpriteInfo[gameSprite.sprite] = n | n2 << 8;
        if (0 != (gameSprite.flags & 2)) {
            ++activePropogators;
        }
        ++activeSprites;
        Canvas.invalidateRect();
        return gameSprite;
    }

    public static final GameSprite gsprite_allocAnim(int n, int n2, int n3, int n4) {
        GameSprite gameSprite = Game.gsprite_alloc(n, 0, 66);
        gameSprite.numAnimFrames = (byte)4;
        gameSprite.pos[0] = gameSprite.pos[3] = (short)n2;
        Render.mapSprites[Render.S_X + gameSprite.sprite] = gameSprite.pos[3];
        gameSprite.pos[1] = gameSprite.pos[4] = (short)n3;
        Render.mapSprites[Render.S_Y + gameSprite.sprite] = gameSprite.pos[4];
        gameSprite.pos[2] = gameSprite.pos[5] = (short)n4;
        Render.mapSprites[Render.S_Z + gameSprite.sprite] = gameSprite.pos[5];
        gameSprite.destScale = (byte)64;
        gameSprite.startScale = (byte)64;
        gameSprite.duration = 200 * gameSprite.numAnimFrames;
        switch (n) {
            case 241: {
                Render.mapSprites[Render.S_RENDERMODE + gameSprite.sprite] = 4;
                break;
            }
            case 234: {
                Render.mapSprites[Render.S_RENDERMODE + gameSprite.sprite] = 3;
                Render.mapSprites[Render.S_SCALEFACTOR + gameSprite.sprite] = 48;
                Render.mapSprites[Render.S_Z + gameSprite.sprite] = (short)(Render.getHeight(n2, n3) + 32);
                if ((App.nextInt() & 1) != 0) {
                    int n5 = gameSprite.sprite;
                    Render.mapSpriteInfo[n5] = Render.mapSpriteInfo[n5] | 0x20000;
                    break;
                }
                int n6 = gameSprite.sprite;
                Render.mapSpriteInfo[n6] = Render.mapSpriteInfo[n6] & 0xFFFDFFFF;
                break;
            }
            case 242: {
                Render.mapSprites[Render.S_RENDERMODE + gameSprite.sprite] = 3;
                break;
            }
            case 208: {
                gameSprite.numAnimFrames = 1;
                gameSprite.duration = 400;
                break;
            }
            case 245: 
            case 246: 
            case 247: {
                gameSprite.duration = 200;
                gameSprite.flags |= 0x1002;
                gameSprite.numAnimFrames = 1;
                gameSprite.vel[2] = 0;
                gameSprite.vel[1] = 0;
                gameSprite.vel[0] = 0;
                gameSprite.pos[3] = -6;
                gameSprite.pos[0] = -6;
                gameSprite.pos[4] = 0;
                gameSprite.pos[1] = 0;
                gameSprite.pos[2] = gameSprite.pos[5] = (short)(gameSprite.pos[5] - Canvas.viewZ);
                Render.mapSprites[Render.S_X + gameSprite.sprite] = (short)(Canvas.viewX + Canvas.viewStepX + (viewStepX >> 6) * gameSprite.pos[0] + (viewRightStepX >> 6) * gameSprite.pos[1]);
                Render.mapSprites[Render.S_Y + gameSprite.sprite] = (short)(Canvas.viewY + Canvas.viewStepY + (viewStepY >> 6) * gameSprite.pos[0] + (viewRightStepY >> 6) * gameSprite.pos[1]);
                Render.mapSprites[Render.S_Z + gameSprite.sprite] = (short)(Canvas.viewZ + gameSprite.pos[2]);
                break;
            }
            case 252: {
                gameSprite.numAnimFrames = (byte)2;
                break;
            }
            case 170: {
                gameSprite.numAnimFrames = 1;
                gameSprite.duration = 200;
            }
        }
        Render.relinkSprite(gameSprite.sprite);
        return gameSprite;
    }

    public static final void gsprite_destroy(GameSprite gameSprite) {
        if ((gameSprite.flags & 0x2000) == 0) {
            int n = gameSprite.sprite;
            Render.mapSpriteInfo[n] = Render.mapSpriteInfo[n] | 0x10000;
        } else if ((gameSprite.flags & 0x8000) == 0) {
            int n = gameSprite.sprite;
            Render.mapSpriteInfo[n] = Render.mapSpriteInfo[n] & 0xFFFFFEFF;
            Render.mapSprites[Render.S_X + gameSprite.sprite] = gameSprite.pos[3];
            Render.mapSprites[Render.S_Y + gameSprite.sprite] = gameSprite.pos[4];
            Render.mapSprites[Render.S_Z + gameSprite.sprite] = (gameSprite.flags & 0x4000) == 0 ? gameSprite.pos[5] : gameSprite.pos[2];
            Render.relinkSprite(gameSprite.sprite);
        }
        gameSprite.flags &= 0xFFFFFFFE;
        if ((gameSprite.flags & 0x8000) != 0) {
            if ((gameSprite.flags & 0x4000) != 0) {
                gameSprite.flags &= 0xFFFF3FFF;
                gameSprite.flags |= 1;
                int n = gameSprite.sprite;
                Render.mapSpriteInfo[n] = Render.mapSpriteInfo[n] & 0xFFFEFFFF;
                gameSprite.pos[0] = Render.mapSprites[Render.S_X + gameSprite.sprite];
                gameSprite.pos[1] = Render.mapSprites[Render.S_Y + gameSprite.sprite];
                gameSprite.pos[2] = Render.mapSprites[Render.S_Z + gameSprite.sprite];
                gameSprite.pos[5] = (short)(Render.getHeight(Render.mapSprites[Render.S_X + gameSprite.sprite], Render.mapSprites[Render.S_Y + gameSprite.sprite]) + 32);
                gameSprite.time = App.time;
                gameSprite.duration = 250;
                if (gameSprite.vel[0] > 0) {
                    gameSprite.pos[3] = (short)(gameSprite.pos[3] - 31);
                    gameSprite.vel[0] = -31000 / gameSprite.duration;
                } else if (gameSprite.vel[0] < 0) {
                    gameSprite.pos[3] = (short)(gameSprite.pos[3] + 31);
                    gameSprite.vel[0] = 31000 / gameSprite.duration;
                }
                if (gameSprite.vel[1] > 0) {
                    gameSprite.pos[4] = (short)(gameSprite.pos[4] - 31);
                    gameSprite.vel[1] = -31000 / gameSprite.duration;
                } else if (gameSprite.vel[1] < 0) {
                    gameSprite.pos[4] = (short)(gameSprite.pos[4] + 31);
                    gameSprite.vel[1] = 31000 / gameSprite.duration;
                }
                gameSprite.vel[2] = (gameSprite.pos[5] - gameSprite.pos[2]) * 1000 / gameSprite.duration;
                ++activeSprites;
                return;
            }
        } else if ((gameSprite.flags & 0x800) != 0) {
            Render.unlinkSprite(gameSprite.sprite);
        }
    }

    public static final void snapGameSprites() {
        do {
            Game.gsprite_update(0x40000000);
        } while (activeSprites != 0);
    }

    public static final void gsprite_update(int n) {
        if (0 == activeSprites) {
            return;
        }
        boolean bl = false;
        activeSprites = 0;
        activePropogators = 0;
        for (int i = 0; i < 48; ++i) {
            int n2;
            GameSprite gameSprite = gsprites[i];
            if ((gameSprite.flags & 1) == 0) continue;
            int n3 = n - gameSprite.time;
            if (n3 < 0) {
                if (0 != (gameSprite.flags & 2)) {
                    ++activePropogators;
                }
                ++activeSprites;
                continue;
            }
            if ((gameSprite.flags & 0x200) == 0 && n3 >= gameSprite.duration) {
                if ((gameSprite.flags & 8) == 0) {
                    Canvas.invalidateRect();
                }
                Game.gsprite_destroy(gameSprite);
                continue;
            }
            ++activeSprites;
            bl = true;
            if (0 != (gameSprite.flags & 0x40)) {
                n2 = n3 / 200 % gameSprite.numAnimFrames;
                Render.mapSpriteInfo[gameSprite.sprite] = Render.mapSpriteInfo[gameSprite.sprite] & 0xFFFF00FF | n2 << 8;
            }
            if (0 != (gameSprite.flags & 0x1000)) {
                n2 = Render.mapSprites[Render.S_X + gameSprite.sprite] >> 6;
                int n4 = Render.mapSprites[Render.S_Y + gameSprite.sprite] >> 6;
                short s = (short)(Canvas.viewX + viewStepX);
                short s2 = (short)(Canvas.viewY + viewStepY);
                if (0 != (gameSprite.flags & 2)) {
                    if (n3 > gameSprite.duration) {
                        Render.mapSprites[Render.S_X + gameSprite.sprite] = (short)(s + (viewStepX >> 6) * gameSprite.pos[3] + (viewRightStepX >> 6) * gameSprite.pos[4]);
                        Render.mapSprites[Render.S_Y + gameSprite.sprite] = (short)(s2 + (viewStepY >> 6) * gameSprite.pos[3] + (viewRightStepY >> 6) * gameSprite.pos[4]);
                        Render.mapSprites[Render.S_Z + gameSprite.sprite] = (short)(Canvas.viewZ + gameSprite.pos[5]);
                        gameSprite.flags &= 0xFFFFFFFD;
                    } else {
                        int n5 = gameSprite.pos[0] + gameSprite.vel[0] * n3 / 1000;
                        int n6 = gameSprite.pos[1] + gameSprite.vel[1] * n3 / 1000;
                        Render.mapSprites[Render.S_X + gameSprite.sprite] = (short)(s + (viewStepX >> 6) * n5 + (viewRightStepX >> 6) * n6);
                        Render.mapSprites[Render.S_Y + gameSprite.sprite] = (short)(s2 + (viewStepY >> 6) * n5 + (viewRightStepY >> 6) * n6);
                        Render.mapSprites[Render.S_Z + gameSprite.sprite] = (short)(Canvas.viewZ + gameSprite.pos[2] + gameSprite.vel[2] * n3 / 1000);
                    }
                    ++activePropogators;
                } else {
                    Render.mapSprites[Render.S_X + gameSprite.sprite] = s;
                    Render.mapSprites[Render.S_Y + gameSprite.sprite] = s2;
                    Render.mapSprites[Render.S_Z + gameSprite.sprite] = (short)Canvas.viewZ;
                }
                if (0 == (gameSprite.flags & 4) && (n2 != Render.mapSprites[Render.S_X + gameSprite.sprite] >> 6 || n4 != Render.mapSprites[Render.S_Y + gameSprite.sprite] >> 6)) {
                    if (0 != (gameSprite.flags & 0x1000)) {
                        Render.relinkSprite(gameSprite.sprite, Canvas.destX << 4, Canvas.destY << 4, Canvas.destZ << 4);
                    } else {
                        Render.relinkSprite(gameSprite.sprite);
                    }
                }
            } else if (0 != (gameSprite.flags & 2)) {
                ++activePropogators;
                if (n3 >= gameSprite.duration) {
                    Render.mapSprites[Render.S_X + gameSprite.sprite] = gameSprite.pos[3];
                    Render.mapSprites[Render.S_Y + gameSprite.sprite] = gameSprite.pos[4];
                    if ((gameSprite.flags & 0x4000) == 0) {
                        Render.mapSprites[Render.S_Z + gameSprite.sprite] = gameSprite.pos[5];
                    } else if ((gameSprite.flags & 0x8000) == 0) {
                        Render.mapSprites[Render.S_Z + gameSprite.sprite] = gameSprite.pos[2];
                    }
                    gameSprite.flags &= 0xFFFFFFFD;
                } else {
                    Render.mapSprites[Render.S_X + gameSprite.sprite] = (short)(gameSprite.pos[0] + gameSprite.vel[0] * n3 / 1000);
                    Render.mapSprites[Render.S_Y + gameSprite.sprite] = (short)(gameSprite.pos[1] + gameSprite.vel[1] * n3 / 1000);
                    if ((gameSprite.flags & 0x4000) == 0) {
                        Render.mapSprites[Render.S_Z + gameSprite.sprite] = (short)(gameSprite.pos[2] + gameSprite.vel[2] * n3 / 1000);
                    } else {
                        n2 = Render.sinTable[(n3 << 16) / (gameSprite.duration << 8) << 1 & 0x3FF] >> 8;
                        Render.mapSprites[Render.S_Z + gameSprite.sprite] = (short)(gameSprite.pos[2] + (n2 * (gameSprite.pos[5] - gameSprite.pos[2] << 8) >> 16));
                    }
                    if (0 == (gameSprite.flags & 4)) {
                        Render.relinkSprite(gameSprite.sprite);
                    }
                }
            }
            if (0 == (gameSprite.flags & 0x400)) continue;
            if (n3 > gameSprite.duration) {
                Render.mapSprites[Render.S_SCALEFACTOR + gameSprite.sprite] = gameSprite.destScale;
                gameSprite.flags &= 0xFFFFFBFF;
                continue;
            }
            Render.mapSprites[Render.S_SCALEFACTOR + gameSprite.sprite] = (byte)(gameSprite.startScale + gameSprite.scaleStep * n3 / 1000);
        }
        if (bl) {
            Canvas.staleView = true;
            Canvas.invalidateRect();
        }
    }

    private static final void saveWorldState(DataOutputStream dataOutputStream, boolean bl) {
        try {
            int n;
            int n2;
            short[] sArray = Render.mapSprites;
            int[] nArray = Render.mapSpriteInfo;
            Canvas.updateLoadingBar(false);
            dataOutputStream.writeInt(Render.mapCompileDate);
            int n3 = App.gameTime;
            totalLevelTime += n3 - curLevelTime;
            curLevelTime = n3;
            dataOutputStream.writeInt(totalLevelTime);
            dataOutputStream.writeByte(mapSecretsFound);
            Render.snapFogLerp();
            dataOutputStream.writeInt(TinyGL.fogColor);
            dataOutputStream.writeInt(TinyGL.fogMin);
            dataOutputStream.writeInt(TinyGL.fogRange);
            dataOutputStream.writeInt(Render.playerFogColor);
            dataOutputStream.writeInt(Render.playerFogMin);
            dataOutputStream.writeInt(Render.playerFogRange);
            if (Player.ce.weapon == 14) {
                dataOutputStream.writeByte((byte)Player.activeWeaponDef.tileIndex);
            }
            for (n2 = 0; n2 < 4; ++n2) {
                if (!bl) {
                    dataOutputStream.writeShort(placedBombs[n2]);
                    continue;
                }
                dataOutputStream.writeShort(0);
            }
            Game.saveEntityStates(dataOutputStream, bl);
            Canvas.updateLoadingBar(false);
            int n4 = Render.numLines;
            int n5 = 0;
            int n6 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                if (n6 == 8) {
                    dataOutputStream.writeByte((byte)n5);
                    n6 = 0;
                    n5 = 0;
                }
                if ((Render.lineFlags[n2 >> 1] & 8 << ((n2 & 1) << 2)) != 0) {
                    n5 |= 1 << n6;
                }
                ++n6;
            }
            if (n6 != 0) {
                dataOutputStream.writeByte((byte)n5);
            }
            int n7 = 0;
            for (n2 = 0; n2 < 64; ++n2) {
                if (entityDeathFunctions[n2 * 2] == -1) continue;
                n7 = (byte)(n7 + 1);
            }
            dataOutputStream.write(n7);
            for (n2 = 0; n2 < 64; ++n2) {
                if (entityDeathFunctions[n2 * 2] == -1) continue;
                dataOutputStream.writeShort(entityDeathFunctions[n2 * 2]);
                dataOutputStream.writeShort(entityDeathFunctions[n2 * 2 + 1]);
            }
            n4 = Render.numMapSprites;
            n6 = 0;
            n5 = 0;
            n2 = 0;
            while (n2 < n4) {
                n5 = 0;
                n6 = 0;
                while (n6 < 8) {
                    n = 0;
                    if (bl && sArray[Render.S_ENT + n2] != -1) {
                        Entity entity = entities[sArray[Render.S_ENT + n2]];
                        EntityDef entityDef = entity.def;
                        if (entityDef.eType == 9 && entityDef.eSubType != 17 && (entity.monster.flags & 0x80) == 0) {
                            n = 1;
                        }
                    }
                    if (n == 0 && 0 != (Render.mapSpriteInfo[n2] & 0x10000)) {
                        n = 1;
                    }
                    if (n != 0) {
                        n5 |= 1 << n6;
                    }
                    ++n6;
                    if (0 != (nArray[n2] & 0x200000)) {
                        n5 |= 1 << n6;
                    }
                    ++n6;
                    ++n2;
                }
                dataOutputStream.writeByte(n5);
            }
            n4 = 1024;
            for (n2 = 0; n2 < n4; n2 += 8) {
                n5 = 0;
                for (n = 0; n < 8; ++n) {
                    if (0 == (Render.mapFlags[n2 + n] & 0x80)) continue;
                    n5 |= 1 << n;
                }
                dataOutputStream.writeByte(n5);
            }
            short[] sArray2 = scriptStateVars;
            for (n2 = 0; n2 < 128; ++n2) {
                if (n2 == 15) continue;
                dataOutputStream.writeShort(sArray2[n2]);
            }
            n4 = Render.numTileEvents;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                n10 = n2 % 32;
                n9 = (Render.tileEvents[n2 * 2 + 1] & 0x80000) >> 19;
                n8 |= n9 << n10;
                if (n10 != 31) continue;
                dataOutputStream.writeInt(n8);
                n8 = 0;
            }
            if (n10 != 31) {
                dataOutputStream.writeInt(n8);
            }
            Canvas.updateLoadingBar(false);
            dataOutputStream.writeByte(numLerpSprites);
            int n11 = 0;
            for (n2 = 0; n2 < 16; ++n2) {
                LerpSprite lerpSprite = lerpSprites[n2];
                if (lerpSprite.hSprite == 0) continue;
                lerpSprite.saveState(dataOutputStream);
                ++n11;
            }
            dataOutputStream.writeByte(numScriptThreads);
            for (n2 = 0; n2 < 20; ++n2) {
                scriptThreads[n2].saveState(dataOutputStream);
            }
            dataOutputStream.writeInt(dropIndex);
            dataOutputStream.writeInt(Player.moves);
            dataOutputStream.writeByte((byte)Player.numNotebookIndexes);
            dataOutputStream.writeByte(Player.questComplete);
            dataOutputStream.writeByte(Player.questFailed);
            for (n2 = 0; n2 < 8; ++n2) {
                dataOutputStream.writeShort(Player.notebookIndexes[n2]);
                dataOutputStream.writeShort(Player.notebookPositions[n2]);
            }
            dataOutputStream.writeByte(Render.mapFlagsBitmask);
            byte by = (byte)(Render.useMastermindHack ? 1 : 0);
            dataOutputStream.writeByte(by);
            byte by2 = (byte)(Render.useCaldexHack ? 1 : 0);
            dataOutputStream.writeByte(by2);
            if (watchLine == null) {
                dataOutputStream.writeShort(-1);
            } else {
                dataOutputStream.writeShort(watchLine.getIndex());
            }
            int n12 = numMallocsForVIOS;
            if (angryVIOS) {
                n12 |= Integer.MIN_VALUE;
            }
            dataOutputStream.writeInt(n12);
            dataOutputStream.writeShort(lootFound);
            dataOutputStream.writeShort(destroyedObj);
            Canvas.updateLoadingBar(false);
        }
        catch (IOException iOException) {
            App.Error(iOException, 49);
        }
    }

    public static final void loadWorldState() {
        DataInputStream dataInputStream;
        if (Canvas.loadMapID > 10) {
            return;
        }
        try {
            dataInputStream = activeLoadType == 1 ? Resource.loadRecord(SAVEGAME_NAME_FULLWORLD) : Resource.loadRecord(SAVEGAME_NAME_BRIEFWORLD + (Canvas.loadMapID - 1));
        }
        catch (Exception exception) {
            totalLevelTime = 0;
            return;
        }
        Game.loadWorldState(dataInputStream);
    }

    private static final void loadWorldState(DataInputStream dataInputStream) {
        try {
            Object object;
            int n;
            int n2;
            int n3 = dataInputStream.readInt();
            totalLevelTime = dataInputStream.readInt();
            mapSecretsFound = dataInputStream.readByte();
            TinyGL.fogColor = dataInputStream.readInt();
            TinyGL.fogMin = dataInputStream.readInt();
            TinyGL.fogRange = dataInputStream.readInt();
            Render.playerFogColor = dataInputStream.readInt();
            Render.playerFogMin = dataInputStream.readInt();
            Render.playerFogRange = dataInputStream.readInt();
            Canvas.updateLoadingBar(false);
            Render.buildFogTables(TinyGL.fogColor);
            Canvas.updateLoadingBar(false);
            if (Player.ce.weapon == 14) {
                Player.setPickUpWeapon(dataInputStream.readByte() & 0xFF);
            }
            for (n2 = 0; n2 < 4; ++n2) {
                Game.placedBombs[n2] = dataInputStream.readShort();
            }
            Game.loadEntityStates(dataInputStream);
            Canvas.updateLoadingBar(false);
            int n4 = Render.numLines;
            byte by = 0;
            int n5 = 8;
            for (n2 = 0; n2 < n4; ++n2) {
                if (n5 == 8) {
                    by = dataInputStream.readByte();
                    n5 = 0;
                }
                if ((by & 1 << n5) != 0) {
                    int n6 = n2 >> 1;
                    Render.lineFlags[n6] = (byte)(Render.lineFlags[n6] | 8 << ((n2 & 1) << 2));
                }
                ++n5;
            }
            n2 = dataInputStream.readByte();
            for (n = 0; n < n2; ++n) {
                Game.entityDeathFunctions[n * 2] = dataInputStream.readShort();
                Game.entityDeathFunctions[n * 2 + 1] = dataInputStream.readShort();
            }
            Canvas.updateLoadingBar(false);
            n4 = Render.numMapSprites;
            by = 0;
            n5 = 8;
            n = 0;
            while (n < n4) {
                by = dataInputStream.readByte();
                n5 = 0;
                while (n5 < 8) {
                    if (0 != (by & 1 << n5)) {
                        int n7 = n;
                        Render.mapSpriteInfo[n7] = Render.mapSpriteInfo[n7] | 0x10000;
                    } else {
                        int n8 = n;
                        Render.mapSpriteInfo[n8] = Render.mapSpriteInfo[n8] & 0xFFFEFFFF;
                    }
                    if (0 != (by & 1 << ++n5)) {
                        int n9 = n;
                        Render.mapSpriteInfo[n9] = Render.mapSpriteInfo[n9] | 0x200000;
                    } else {
                        int n10 = n;
                        Render.mapSpriteInfo[n10] = Render.mapSpriteInfo[n10] & 0xFFDFFFFF;
                    }
                    ++n5;
                    ++n;
                }
            }
            Canvas.updateLoadingBar(false);
            n4 = 1024;
            for (n = 0; n < n4; n += 8) {
                by = dataInputStream.readByte();
                for (int i = 0; i < 8; ++i) {
                    if (0 == (by & 1 << i)) continue;
                    int n11 = n + i;
                    Render.mapFlags[n11] = (byte)(Render.mapFlags[n11] | 0x80);
                }
            }
            short[] sArray = scriptStateVars;
            for (n = 0; n < 128; ++n) {
                if (n == 15) continue;
                sArray[n] = dataInputStream.readShort();
            }
            Canvas.updateLoadingBar(false);
            n4 = Render.numTileEvents;
            int n12 = 0;
            int n13 = dataInputStream.readInt();
            int n14 = 0;
            for (n = 0; n < n4; ++n) {
                n12 = n % 32;
                n14 = Render.tileEvents[n * 2 + 1] & 0xFFF7FFFF;
                Render.tileEvents[n * 2 + 1] = n14 | (n13 >> n12 & 1) << 19;
                if (n12 != 31 || n >= n4 - 1) continue;
                n13 = dataInputStream.readInt();
            }
            numLerpSprites = dataInputStream.readByte();
            for (n = 0; n < 16; ++n) {
                object = lerpSprites[n];
                if (n < numLerpSprites) {
                    ((LerpSprite)object).loadState(dataInputStream);
                    continue;
                }
                ((LerpSprite)object).hSprite = 0;
            }
            numScriptThreads = dataInputStream.readByte();
            for (n = 0; n < 20; ++n) {
                object = scriptThreads[n];
                ((ScriptThread)object).loadState(dataInputStream);
                ((ScriptThread)object).inuse = ((ScriptThread)object).stackPtr > 0;
            }
            Game.updateLerpSprites();
            dropIndex = dataInputStream.readInt();
            Player.moves = dataInputStream.readInt();
            Player.numNotebookIndexes = dataInputStream.readByte();
            Player.questComplete = dataInputStream.readByte();
            Player.questFailed = dataInputStream.readByte();
            for (n = 0; n < 8; ++n) {
                Player.notebookIndexes[n] = dataInputStream.readShort();
                Player.notebookPositions[n] = dataInputStream.readShort();
            }
            Render.mapFlagsBitmask = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            Render.useMastermindHack = by2 == 1;
            byte by3 = dataInputStream.readByte();
            Render.useCaldexHack = by3 == 1;
            short s = dataInputStream.readShort();
            if (s != -1) {
                watchLine = entities[s];
            }
            int n15 = dataInputStream.readInt();
            numMallocsForVIOS = n15 & Integer.MAX_VALUE;
            angryVIOS = n15 >>> 31 == 1;
            lootFound = dataInputStream.readShort();
            destroyedObj = dataInputStream.readShort();
            Hud.playerDestHealth = 0;
            Hud.playerStartHealth = 0;
            Hud.playerHealthChangeTime = 0;
            Game.prepareMonsters();
        }
        catch (IOException iOException) {
            App.Error(iOException, 33);
        }
    }

    public static final void saveConfig() {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(11);
            dataOutputStream.writeByte(difficulty);
            dataOutputStream.writeBoolean(Sound.isSoundEnabled());
            dataOutputStream.writeBoolean(Sound.isVibrateEnabled());
            dataOutputStream.writeBoolean(Player.enableHelp);
            dataOutputStream.writeInt(Text.defaultLanguage);
            dataOutputStream.writeInt(Player.currentLevelDeaths);
            dataOutputStream.writeInt(Player.totalDeaths);
            dataOutputStream.writeInt(Canvas.animFrames);
            dataOutputStream.writeInt(Player.helpBitmask);
            dataOutputStream.writeInt(Player.invHelpBitmask);
            dataOutputStream.writeInt(Player.ammoHelpBitmask);
            dataOutputStream.writeInt(Player.weaponHelpBitmask);
            dataOutputStream.writeInt(Player.armorHelpBitmask);
            for (n = 0; n < 5; ++n) {
                dataOutputStream.writeInt(MenuSystem.indexes[n * 2]);
                dataOutputStream.writeInt(MenuSystem.indexes[n * 2 + 1]);
            }
            dataOutputStream.writeBoolean(Canvas.recentBriefSave);
            dataOutputStream.writeBoolean(hasSeenIntro);
            for (n = 0; n < 10; ++n) {
                dataOutputStream.writeShort(numLevelLoads[n]);
            }
            dataOutputStream.writeInt(totalPlayTime += (App.getUpTimeMs() - lastSaveTime) / 1000);
            dataOutputStream.writeInt(Player.currentGrades);
            dataOutputStream.writeInt(Player.bestGrades);
            lastSaveTime = App.getUpTimeMs();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream = null;
            System.gc();
            Resource.saveRecord(SAVEGAME_NAME_CONFIG, byArray);
        }
        catch (Exception exception) {
            App.Error(exception, 43);
        }
    }

    public static final void loadConfig() {
        try {
            int n;
            DataInputStream dataInputStream = Resource.loadRecord(SAVEGAME_NAME_CONFIG);
            if (dataInputStream.readInt() != 11) {
                throw new Exception("Invalid savegame version");
            }
            difficulty = dataInputStream.readByte();
            Sound.setSound(dataInputStream.readBoolean());
            Canvas.areSoundsAllowed = Sound.isSoundEnabled();
            Sound.setVibrate(dataInputStream.readBoolean());
            Player.enableHelp = dataInputStream.readBoolean();
            int n2 = dataInputStream.readInt();
            if (n2 != Text.defaultLanguage) {
                Text.setLanguage(n2);
            }
            Player.currentLevelDeaths = dataInputStream.readInt();
            Player.totalDeaths = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            if (n3 < 2) {
                n3 = 2;
            } else if (n3 > 64) {
                n3 = 64;
            }
            Canvas.setAnimFrames(n3);
            Player.helpBitmask = dataInputStream.readInt();
            Player.invHelpBitmask = dataInputStream.readInt();
            Player.ammoHelpBitmask = dataInputStream.readInt();
            Player.weaponHelpBitmask = dataInputStream.readInt();
            Player.armorHelpBitmask = dataInputStream.readInt();
            for (n = 0; n < 5; ++n) {
                MenuSystem.indexes[n * 2] = dataInputStream.readInt();
                MenuSystem.indexes[n * 2 + 1] = dataInputStream.readInt();
            }
            Canvas.recentBriefSave = dataInputStream.readBoolean();
            hasSeenIntro = dataInputStream.readBoolean();
            for (n = 0; n < 10; ++n) {
                Game.numLevelLoads[n] = dataInputStream.readShort();
            }
            totalPlayTime = dataInputStream.readInt();
            Player.currentGrades = dataInputStream.readInt();
            Player.bestGrades = dataInputStream.readInt();
            lastSaveTime = App.getUpTimeMs();
            dataInputStream.close();
        }
        catch (Exception exception) {
            App.checkPausedState();
            Game.removeState(false);
        }
    }

    public static final void saveState(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        boolean bl;
        Canvas.recentBriefSave = bl = (n14 & 0x20) != 0;
        Canvas.updateLoadingBar(false);
        if ((n14 & 0x10) != 0) {
            Player.levelGrade(true);
        }
        Game.saveConfig();
        if (!Game.hasSavedState()) {
            try {
                Game.touchRecords();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            byte[] byArray;
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            if (0 != (n14 & 1)) {
                Canvas.updateLoadingBar(false);
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                if (!Game.savePlayerState(dataOutputStream, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13)) {
                    dataOutputStream.close();
                    byteArrayOutputStream.close();
                    return;
                }
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                dataOutputStream = null;
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                System.gc();
                if (bl) {
                    Resource.saveRecord(SAVEGAME_NAME_BRIEFPLAYER, byArray);
                } else {
                    Resource.saveRecord(SAVEGAME_NAME_FULLPLAYER, byArray);
                }
            }
            if (0 != (n14 & 2)) {
                Canvas.updateLoadingBar(false);
                byteArrayOutputStream = new ByteArrayOutputStream();
                dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                Game.saveWorldState(dataOutputStream, bl);
                byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.close();
                dataOutputStream = null;
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                System.gc();
                if (bl) {
                    Resource.saveRecord(SAVEGAME_NAME_BRIEFWORLD + (n - 1), byArray);
                } else {
                    Resource.saveRecord(SAVEGAME_NAME_FULLWORLD, byArray);
                }
            }
            System.gc();
            Canvas.loadRuntimeData();
        }
        catch (Exception exception) {
            App.Error(exception, 48);
        }
    }

    public static final void saveLevelSnapshot() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            Canvas.updateLoadingBar(false);
            if (!Game.savePlayerState(dataOutputStream, Canvas.loadMapID, Canvas.viewX, Canvas.viewY, Canvas.viewAngle, Canvas.viewPitch, Canvas.viewX, Canvas.viewY, Canvas.viewX, Canvas.viewY, Canvas.viewZ, Canvas.saveAngle, Canvas.savePitch)) {
                return;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            System.gc();
            Resource.saveRecord(SAVEGAME_NAME_BRIEFPLAYER, byArray);
            Canvas.updateLoadingBar(false);
            byteArrayOutputStream = new ByteArrayOutputStream();
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            Game.saveWorldState(dataOutputStream, true);
            byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            System.gc();
            Canvas.updateLoadingBar(false);
            Resource.saveRecord(SAVEGAME_NAME_BRIEFWORLD + (Canvas.loadMapID - 1), byArray);
            Canvas.updateLoadingBar(false);
        }
        catch (Exception exception) {
            App.Error(exception, 47);
        }
    }

    private static final boolean savePlayerState(DataOutputStream dataOutputStream, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        try {
            dataOutputStream.writeShort(n);
            dataOutputStream.writeShort(n2);
            dataOutputStream.writeShort(n3);
            dataOutputStream.writeShort(n4);
            dataOutputStream.writeShort(n5);
            dataOutputStream.writeInt(n6);
            dataOutputStream.writeInt(n7);
            dataOutputStream.writeInt(n8);
            dataOutputStream.writeInt(n9);
            dataOutputStream.writeInt(n10);
            dataOutputStream.writeShort(n11);
            dataOutputStream.writeShort(n12);
            return Player.saveState(dataOutputStream);
        }
        catch (IOException iOException) {
            App.Error(iOException, 46);
            return false;
        }
    }

    private static final boolean loadPlayerState(DataInputStream dataInputStream) {
        try {
            saveStateMap = dataInputStream.readShort();
            short s = dataInputStream.readShort();
            Canvas.destX = s;
            Canvas.viewX = s;
            short s2 = dataInputStream.readShort();
            Canvas.destY = s2;
            Canvas.viewY = s2;
            short s3 = dataInputStream.readShort();
            Canvas.destAngle = s3;
            Canvas.viewAngle = s3;
            short s4 = dataInputStream.readShort();
            Canvas.destPitch = s4;
            Canvas.viewPitch = s4;
            Canvas.destZ = 36;
            Canvas.viewZ = 36;
            Canvas.prevX = dataInputStream.readInt();
            Canvas.prevY = dataInputStream.readInt();
            Canvas.saveX = dataInputStream.readInt();
            Canvas.saveY = dataInputStream.readInt();
            Canvas.saveZ = dataInputStream.readInt();
            Canvas.saveAngle = dataInputStream.readShort();
            Canvas.savePitch = dataInputStream.readShort();
            spawnParam = 0;
            return Player.loadState(dataInputStream);
        }
        catch (IOException iOException) {
            App.Error(iOException, 31);
            return false;
        }
    }

    public static final boolean loadState(int n) {
        try {
            DataInputStream dataInputStream;
            if (n == 1) {
                dataInputStream = Resource.loadRecord(SAVEGAME_NAME_FULLPLAYER);
                if (!Game.loadPlayerState(dataInputStream)) {
                    return false;
                }
            } else if (n == 2) {
                Player.currentLevelDeaths = 0;
                dataInputStream = Resource.loadRecord(SAVEGAME_NAME_BRIEFPLAYER);
                if (!Game.loadPlayerState(dataInputStream)) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            App.Error(exception, 32);
        }
        activeLoadType = n;
        if (Canvas.viewX != 0 && Canvas.viewY != 0) {
            int n2 = (Canvas.viewAngle & 0x3FF) >> 7;
            spawnParam = Canvas.viewX >> 6 & 0x1F | (Canvas.viewY >> 6 & 0x1F) << 5 | n2 << 10;
        }
        Canvas.loadMap(saveStateMap, false, false);
        isSaved = false;
        isLoaded = true;
        return true;
    }

    private static final boolean hasConfig() {
        boolean bl = false;
        if (Resource.recordExists(SAVEGAME_NAME_CONFIG)) {
            try {
                DataInputStream dataInputStream = Resource.loadRecord(SAVEGAME_NAME_CONFIG);
                if (dataInputStream.readInt() == 11) {
                    bl = true;
                }
                dataInputStream.close();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public static final void touchRecords() throws Exception {
        Resource.touchRecord(SAVEGAME_NAME_FULLWORLD);
        Resource.touchRecord(SAVEGAME_NAME_FULLPLAYER);
        Resource.touchRecord(SAVEGAME_NAME_BRIEFPLAYER);
        for (int i = 1; i <= 10; ++i) {
            Resource.touchRecord(SAVEGAME_NAME_BRIEFWORLD + (i - 1));
        }
    }

    private static final boolean hasElement(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].compareTo(string) != 0) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasSavedState() {
        if (!Game.hasConfig()) {
            return false;
        }
        try {
            String[] stringArray = RecordStore.listRecordStores();
            if (stringArray == null) {
                return false;
            }
            if (!(Game.hasElement(stringArray, SAVEGAME_NAME_FULLWORLD) && Game.hasElement(stringArray, SAVEGAME_NAME_FULLPLAYER) && Game.hasElement(stringArray, SAVEGAME_NAME_BRIEFPLAYER))) {
                return false;
            }
            for (int i = 1; i <= 10; ++i) {
                if (Game.hasElement(stringArray, SAVEGAME_NAME_BRIEFWORLD + (i - 1))) continue;
                return false;
            }
        }
        catch (Exception exception) {
            App.Error(exception, 83);
            return false;
        }
        return true;
    }

    public static final void removeState(boolean bl) {
        if (bl) {
            Canvas.updateLoadingBar(false);
        }
        Game.saveEmptyConfig();
        if (bl) {
            Canvas.updateLoadingBar(false);
        }
        Resource.deleteRecord(SAVEGAME_NAME_FULLWORLD);
        if (bl) {
            Canvas.updateLoadingBar(false);
        }
        Resource.deleteRecord(SAVEGAME_NAME_FULLPLAYER);
        if (bl) {
            Canvas.updateLoadingBar(false);
        }
        Resource.deleteRecord(SAVEGAME_NAME_BRIEFPLAYER);
        if (bl) {
            Canvas.updateLoadingBar(false);
        }
        for (int i = 1; i <= 10; ++i) {
            Resource.deleteRecord(SAVEGAME_NAME_BRIEFWORLD + (i - 1));
            if (!bl) continue;
            Canvas.updateLoadingBar(false);
        }
    }

    public static final void saveEmptyConfig() {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(11);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeBoolean(Sound.isSoundEnabled());
            dataOutputStream.writeBoolean(Sound.isVibrateEnabled());
            dataOutputStream.writeBoolean(Player.enableHelp);
            dataOutputStream.writeInt(Text.defaultLanguage);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(Canvas.animFrames);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            for (n = 0; n < 5; ++n) {
                dataOutputStream.writeInt(0);
                dataOutputStream.writeInt(0);
            }
            dataOutputStream.writeBoolean(false);
            dataOutputStream.writeBoolean(hasSeenIntro);
            for (n = 0; n < 10; ++n) {
                dataOutputStream.writeShort(numLevelLoads[n]);
            }
            dataOutputStream.writeInt(totalPlayTime += (App.getUpTimeMs() - lastSaveTime) / 1000);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            lastSaveTime = App.getUpTimeMs();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            dataOutputStream = null;
            byteArrayOutputStream = null;
            System.gc();
            Resource.saveRecord(SAVEGAME_NAME_CONFIG, byArray);
        }
        catch (Exception exception) {
            App.Error(exception, 43);
        }
    }

    public static final boolean canSnapMonsters() {
        if (disableAI) {
            return true;
        }
        if (activeMonsters != null) {
            Entity entity = activeMonsters;
            do {
                if (0 == (entity.info & 0x10000000)) continue;
                return false;
            } while ((entity = entity.monster.nextOnList) != activeMonsters);
        }
        return true;
    }

    public static final boolean snapMonsters(boolean bl) {
        Object object;
        boolean bl2;
        if (animatingEffects != 0) {
            for (bl2 = false; bl2 < 16 != 0; bl2 += 1) {
                object = lerpSprites[bl2];
                if (((LerpSprite)object).hSprite == 0 || (((LerpSprite)object).flags & 2) == 0) continue;
                int n = ((LerpSprite)object).hSprite - 1;
                short s = Render.mapSprites[Render.S_ENT + n];
                if (s == -1) {
                    return false;
                }
                Entity entity = entities[s];
                if (entity.def.eType == 2) continue;
                return false;
            }
        }
        bl2 = bl;
        if (monstersTurn != 0) {
            Game.monsterAI();
            if (!bl) {
                bl2 = Game.canSnapMonsters();
            }
            if (bl2 && activeMonsters != null) {
                object = activeMonsters;
                do {
                    Game.snapLerpSprites(((Entity)object).getSprite());
                } while ((object = ((Entity)object).monster.nextOnList) != activeMonsters);
                Canvas.updateFacingEntity = true;
                Canvas.invalidateRect();
            }
            Game.monsterLerp();
            if (combatMonsters != null && !interpolatingMonsters) {
                Combat.performAttack(combatMonsters, Game.combatMonsters.monster.target, 0, 0, false);
                return false;
            }
            return bl2;
        }
        if (!bl) {
            bl2 = Game.canSnapMonsters();
        }
        object = activeMonsters;
        if (bl2 && object != null) {
            Entity entity;
            do {
                entity = ((Entity)object).monster.nextOnList;
                Game.snapLerpSprites(((Entity)object).getSprite());
            } while ((object = entity) != activeMonsters);
            interpolatingMonsters = false;
        } else if (object == null) {
            interpolatingMonsters = false;
        }
        Canvas.updateFacingEntity = true;
        Canvas.invalidateRect();
        return bl2;
    }

    public static final void endMonstersTurn() {
        Canvas.startRotation(true);
        monstersTurn = 0;
    }

    public static final void updateMonsters() {
        Game.monsterAI();
        Game.monsterLerp();
        if (!interpolatingMonsters) {
            Canvas.updateFacingEntity = true;
            if (combatMonsters != null) {
                Combat.performAttack(combatMonsters, Game.combatMonsters.monster.target, 0, 0, false);
            } else {
                Game.endMonstersTurn();
                if (!Game.isCameraActive() && Canvas.blockInputTime == 0) {
                    Canvas.drawPlayingSoftKeys();
                }
            }
        }
    }

    public static final void setLineLocked(Entity entity, boolean bl) {
        int n = entity.getSprite();
        int n2 = Render.mapSpriteInfo[n] & 0xFF;
        n2 = bl ? (n2 &= 0xFFFFFFFE) : (n2 |= 1);
        Render.mapSpriteInfo[n] = Render.mapSpriteInfo[n] & 0xFFFFFF00 | n2;
        n2 += 257;
        if (entity.def.name == (entity.name & 0x3FF)) {
            entity.def = EntityDef.lookup(n2);
            entity.name = (short)(entity.def.name | 0x400);
        } else {
            entity.def = EntityDef.lookup(n2);
        }
    }

    public static final void snapAllMovers() {
        while (numLerpSprites > 0) {
            Game.snapGameSprites();
            Game.snapLerpSprites(-1);
        }
    }

    public static final void skipCinematic() {
        Sound.setSound(false);
        Sound.soundStop();
        skippingCinematic = true;
        while (skippingCinematic) {
            Game.snapGameSprites();
            Game.snapLerpSprites(-1);
            if (activeCameraKey != -1) {
                activeCamera.Snap(activeCameraKey);
            }
            if (!skippingCinematic || null != Game.activeCamera.keyThread) continue;
            Game.activeCamera.cameraThread.attemptResume(App.gameTime + 0x40000000);
        }
        Hud.subTitleID = -1;
        Hud.cinTitleID = -1;
        Game.snapGameSprites();
        Game.snapLerpSprites(-1);
        cinematicWeapon = -1;
        Canvas.shakeTime = 0;
        if (!Render.isFading() || (Render.getFadeFlags() & 0xC) == 0) {
            Render.startFade(500, 2);
        }
        Canvas.updateFacingEntity = true;
        Sound.setSound(Canvas.areSoundsAllowed);
        Canvas.shakeTime = 0;
        Canvas.blockInputTime = 0;
        ParticleSystem.freeAllParticles();
        if (Canvas.state == 8 && Game.isCameraActive()) {
            activeCameraTime = 65536;
        }
        if (Canvas.state == 3) {
            Canvas.drawPlayingSoftKeys();
        }
    }

    public static int getNextBombIndex() {
        for (int i = 0; i < 4; ++i) {
            if (placedBombs[i] != 0) continue;
            return i;
        }
        return -1;
    }

    public static void updateBombs() {
        Entity entity = null;
        int[] nArray = placedBombs;
        for (int i = 0; i < 4; ++i) {
            if (nArray[i] == 0) continue;
            entity = entities[nArray[i]];
            int n = entity.param & 0xFF;
            if (--n < 0) {
                if ((entity.info & 0x100000) != 0) {
                    entity.pain(1, null);
                }
                nArray[i] = 0;
                continue;
            }
            entity.param = entity.param & 0xFFFFFF00 | n;
        }
    }

    public static final int setDynamite(int n, int n2, boolean bl) {
        int n3;
        int n4 = Game.getNextBombIndex();
        if (n4 == -1) {
            App.Error(new Exception("Too many bombs placed"), 111);
        }
        int n5 = 0;
        if (!bl) {
            n3 = destAngle & 0x3FF;
            switch (n3) {
                case 0: {
                    n5 |= 0x8000000;
                    --n;
                    break;
                }
                case 256: {
                    n5 |= 0x2000000;
                    ++n2;
                    break;
                }
                case 512: {
                    n5 |= 0x4000000;
                    ++n;
                    break;
                }
                case 768: {
                    n5 |= 0x1000000;
                    --n2;
                }
            }
        } else {
            n5 |= 0x110000;
        }
        n3 = Render.getHeight(n, n2);
        Game.allocDynamite((short)n, (short)n2, (short)(n3 + (bl ? 31 : 32)), n5, n4, 0);
        return n4;
    }

    public static final Entity getFreeDropEnt() {
        int n = dropIndex;
        int n2 = firstDropIndex + n;
        if ((Game.entities[n2].info & 0x100000) != 0) {
            n = (n + 1) % 16;
            while (n != dropIndex && (Game.entities[n2].info & 0x100000) != 0) {
                n = (n + 1) % 16;
                n2 = firstDropIndex + n;
            }
            if (dropIndex == n) {
                // empty if block
            }
        }
        dropIndex = (n + 1) % 16;
        lastDropEntIndex = n2;
        return entities[n2];
    }

    public static void allocDynamite(int n, int n2, int n3, int n4, int n5, int n6) {
        Entity entity = Game.getFreeDropEnt();
        entity.def = EntityDef.find(14, 6);
        entity.name = (short)(entity.def.name | 0x400);
        entity.param = n6 << 8 | 3;
        if (0 != (entity.info & 0x100000)) {
            Game.unlinkEntity(entity);
        }
        Game.linkEntity(entity, n >> 6, n2 >> 6);
        entity.info |= 0x420000;
        int n7 = entity.getSprite();
        Render.mapSprites[Render.S_X + n7] = (short)n;
        Render.mapSprites[Render.S_Y + n7] = (short)n2;
        Render.mapSprites[Render.S_Z + n7] = (short)n3;
        Render.mapSprites[Render.S_SCALEFACTOR + n7] = 32;
        Render.mapSprites[Render.S_RENDERMODE + n7] = 0;
        Render.mapSpriteInfo[n7] = n4 | entity.def.tileIndex;
        Render.relinkSprite(n7);
        Game.placedBombs[n5] = lastDropEntIndex;
    }

    public static final Entity spawnDropItem(int n, int n2, int n3, EntityDef entityDef, int n4, boolean bl) {
        Entity entity = Game.getFreeDropEnt();
        entity.def = entityDef;
        entity.name = (short)(entity.def.name | 0x400);
        if (n3 >= 1 && n3 < 14) {
            n3 |= 0x200;
        }
        if (0 != (entity.info & 0x100000)) {
            Game.unlinkEntity(entity);
        }
        entity.info &= 0xFFFF;
        entity.info |= 0x400000;
        if (entity.def.eType == 10) {
            entity.info |= 0x20000;
        }
        int n5 = entity.getSprite();
        int n6 = Render.getHeight(n, n2);
        Render.mapSpriteInfo[n5] = n3;
        Render.mapSprites[Render.S_X + n5] = (short)n;
        Render.mapSprites[Render.S_Y + n5] = (short)n2;
        Render.mapSprites[Render.S_Z + n5] = (short)(32 + n6);
        Render.mapSprites[Render.S_ENT + n5] = (short)lastDropEntIndex;
        Render.mapSprites[Render.S_SCALEFACTOR + n5] = 64;
        entity.param = n4;
        Render.relinkSprite(n5);
        Game.linkEntity(entity, n >> 6, n2 >> 6);
        if (bl) {
            Game.throwDropItem(n, n2, n6, entity);
        }
        return entity;
    }

    public static final Entity spawnDropItem(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        EntityDef entityDef = EntityDef.find(n4, n5, n6);
        if (entityDef != null) {
            return Game.spawnDropItem(n, n2, n3, entityDef, n7, bl);
        }
        App.Error(new Exception("Cannot find a def for the spawnDropItem."), -1);
        return null;
    }

    public static final void spawnDropItem(Entity entity) {
        int n;
        int n2;
        boolean bl;
        boolean bl2 = bl = entity.lootSet != null;
        bl = entity.monster == null ? (bl &= entity.param == 0) : (bl &= (entity.monster.flags & 0x800) == 0);
        if (bl && (n2 = (n = entity.lootSet[0]) >> 12 & 0xF) != 6) {
            int n3 = (n & 0xFC0) >> 6;
            int n4 = n & 0x3F;
            if (n4 > 0) {
                EntityDef entityDef = EntityDef.find(6, n2, n3);
                if (entityDef != null) {
                    if (entityDef.tileIndex != 0) {
                        int n5 = entity.getSprite();
                        Game.spawnDropItem(Render.mapSprites[Render.S_X + n5], Render.mapSprites[Render.S_Y + n5], entityDef.tileIndex, entityDef, n4, false);
                    }
                } else {
                    App.Error(new Exception("Cannot find a def for the dropItem."), 117);
                }
            }
        }
    }

    public static final Entity spawnPlayerEntityCopy(int n, int n2) {
        int n3 = 72;
        int n4 = 224;
        switch (Player.characterChoice) {
            case 1: {
                n3 = 68;
                n4 = 224;
                break;
            }
            case 3: {
                n3 = 66;
                n4 = 225;
                break;
            }
            case 2: {
                n3 = 72;
                n4 = 226;
            }
        }
        Entity entity = Game.getFreeDropEnt();
        entity.def = EntityDef.lookup(n3);
        entity.name = (short)(n4 | 0);
        if (0 != (entity.info & 0x100000)) {
            Game.unlinkEntity(entity);
        }
        entity.info &= 0xFFFF;
        entity.info |= 0x400000;
        int n5 = entity.getSprite();
        int n6 = Render.getHeight(n, n2);
        Render.mapSpriteInfo[n5] = n3;
        Render.mapSprites[Render.S_X + n5] = (short)n;
        Render.mapSprites[Render.S_Y + n5] = (short)n2;
        Render.mapSprites[Render.S_Z + n5] = (short)(32 + n6);
        Render.mapSprites[Render.S_ENT + n5] = (short)lastDropEntIndex;
        Render.mapSprites[Render.S_RENDERMODE + n5] = 0;
        Render.mapSprites[Render.S_SCALEFACTOR + n5] = 64;
        entity.param = 0;
        Render.relinkSprite(n5);
        Game.linkEntity(entity, n >> 6, n2 >> 6);
        return entity;
    }

    public static final Entity spawnSentryBotCorpse(int n, int n2, int n3, int n4, int n5) {
        int n6 = 19;
        int n7 = 0;
        switch (n3) {
            case 3: 
            case 4: {
                n6 = 19;
                n7 = 0;
                break;
            }
            case 5: 
            case 6: {
                n6 = 18;
                n7 = 1;
            }
        }
        Entity entity = Game.getFreeDropEnt();
        entity.def = EntityDef.find(9, 11, n7);
        entity.name = (short)(entity.def.name | 0x400);
        entity.populateDefaultLootSet();
        entity.param = 0;
        if (n3 == 3 || n3 == 5) {
            entity.addToLootSet(2, 1, 10);
        } else {
            entity.addToLootSet(0, 12, 1);
        }
        entity.addToLootSet(0, 16, n4);
        entity.addToLootSet(0, 13, n5);
        if (0 != (entity.info & 0x100000)) {
            Game.unlinkEntity(entity);
        }
        entity.info &= 0xFFFF;
        entity.info |= 0x1420000;
        int n8 = entity.getSprite();
        int n9 = Render.getHeight(n, n2);
        Render.mapSpriteInfo[n8] = n6;
        int n10 = n8;
        Render.mapSpriteInfo[n10] = Render.mapSpriteInfo[n10] | 0xD00;
        Render.mapSprites[Render.S_X + n8] = (short)n;
        Render.mapSprites[Render.S_Y + n8] = (short)n2;
        Render.mapSprites[Render.S_Z + n8] = (short)(32 + n9);
        Render.mapSprites[Render.S_ENT + n8] = (short)lastDropEntIndex;
        Render.mapSprites[Render.S_RENDERMODE + n8] = 0;
        Render.mapSprites[Render.S_SCALEFACTOR + n8] = 64;
        Render.relinkSprite(n8);
        Game.linkEntity(entity, n >> 6, n2 >> 6);
        return entity;
    }

    public static final void throwDropItem(int n, int n2, int n3, Entity entity) {
        LerpSprite lerpSprite = Game.allocLerpSprite(null, entity.getSprite(), entity.def.eType != 6);
        if (lerpSprite != null) {
            lerpSprite.srcX = n;
            lerpSprite.srcY = n2;
            lerpSprite.srcZ = (short)(32 + n3);
            lerpSprite.dstX = n;
            lerpSprite.dstY = n2;
            lerpSprite.dstZ = lerpSprite.srcZ;
            lerpSprite.height = 48;
            lerpSprite.flags |= 5;
            lerpSprite.srcScale = lerpSprite.dstScale = Render.mapSprites[Render.S_SCALEFACTOR + entity.getSprite()];
            lerpSprite.startTime = App.gameTime;
            lerpSprite.travelTime = 850;
            int n4 = App.nextByte() & 7;
            int n5 = 8;
            while (--n5 >= 0) {
                n = lerpSprite.srcX + dropDirs[n4 << 1];
                n2 = lerpSprite.srcY + dropDirs[(n4 << 1) + 1];
                Game.trace(lerpSprite.srcX, lerpSprite.srcY, n, n2, entity, 15855, 25);
                if (traceEntity == null && (Entity.baseVisitedTiles[n2 >> 6] & 1 << (n >> 6)) == 0) {
                    lerpSprite.dstX = n;
                    lerpSprite.dstY = n2;
                    lerpSprite.dstZ = (short)(Render.getHeight(lerpSprite.dstX, lerpSprite.dstY) + 32);
                    break;
                }
                n4 = n4 + 1 & 7;
            }
        }
    }

    public static final int updateLerpSprite(LerpSprite lerpSprite) {
        int n;
        int n2 = 0;
        int n3 = lerpSprite.hSprite - 1;
        int n4 = Canvas.viewX >> 6;
        int n5 = Canvas.viewY >> 6;
        int n6 = App.gameTime - lerpSprite.startTime;
        int n7 = Render.mapSpriteInfo[n3];
        int n8 = n7 & 0xFF;
        if ((n7 & 0x400000) != 0) {
            n8 += 257;
        }
        if (n6 >= lerpSprite.travelTime) {
            Game.freeLerpSprite(lerpSprite);
            return 3;
        }
        if (n6 < 0) {
            return 4;
        }
        int n9 = 0;
        if (lerpSprite.travelTime != 0) {
            n9 = (n6 << 16) / (lerpSprite.travelTime << 8);
        }
        Render.mapSprites[Render.S_X + n3] = (short)(lerpSprite.srcX + (n9 * (lerpSprite.dstX - lerpSprite.srcX << 8) >> 16));
        Render.mapSprites[Render.S_Y + n3] = (short)(lerpSprite.srcY + (n9 * (lerpSprite.dstY - lerpSprite.srcY << 8) >> 16));
        Render.mapSprites[Render.S_SCALEFACTOR + n3] = (byte)(lerpSprite.srcScale + (n9 * (lerpSprite.dstScale - lerpSprite.srcScale << 8) >> 16));
        Render.mapSprites[Render.S_Z + n3] = (short)(lerpSprite.srcZ + (n9 * (lerpSprite.dstZ - lerpSprite.srcZ << 8) >> 16));
        if ((lerpSprite.flags & 4) != 0) {
            int n10 = n9 << 1;
            if ((lerpSprite.flags & 8) != 0) {
                n10 = n10 * 6 / 8;
            }
            n = Render.sinTable[n10 & 0x3FF] >> 8;
            if ((lerpSprite.flags & 0x20) == 0) {
                Render.relinkSprite(n3, Render.mapSprites[Render.S_X + n3] << 4, Render.mapSprites[Render.S_Y + n3] << 4, Render.mapSprites[Render.S_Z + n3] << 4);
            }
            int n11 = Render.S_Z + n3;
            Render.mapSprites[n11] = (short)(Render.mapSprites[n11] + (short)(n * (lerpSprite.height << 8) >> 16));
        } else if ((lerpSprite.flags & 0x20) == 0) {
            Render.relinkSprite(n3);
        }
        int n12 = Render.mapSprites[Render.S_X + n3] >> 6;
        int n13 = Render.mapSprites[Render.S_Y + n3] >> 6;
        if (-1 != Render.mapSprites[Render.S_ENT + n3] && 0 == (Render.mapSpriteInfo[n3] & 0x10000)) {
            Entity entity = entities[Render.mapSprites[Render.S_ENT + n3]];
            n = entity.linkIndex % 32;
            int n14 = entity.linkIndex / 32;
            if (entity.def.eType == 3 || null != entity.monster) {
                int n15;
                int n16 = (Render.mapSpriteInfo[n3] & 0xFF00) >> 8;
                int n17 = n16 & 0xF0;
                int n18 = lerpSprite.dstX - lerpSprite.srcX;
                int n19 = lerpSprite.dstY - lerpSprite.srcY;
                if ((n17 == 0 || n17 == 32 || n17 == 48 && (lerpSprite.flags & 0x800) != 0) && (n18 | n19) != 0) {
                    n15 = Game.VecToDir(n18, n19, true);
                    int n20 = Math.abs((Render.viewAngle & 0x3FF) - n15);
                    int n21 = Math.max((lerpSprite.dstX - lerpSprite.srcX) * (lerpSprite.dstX - lerpSprite.srcX), (lerpSprite.dstY - lerpSprite.srcY) * (lerpSprite.dstY - lerpSprite.srcY));
                    if (Combat.WorldDistToTileDist(n21) > 1 && n20 < 256) {
                        n17 = 48;
                        lerpSprite.flags |= 0x800;
                    } else {
                        n17 = 32;
                    }
                } else if (n17 == 16) {
                    n17 = 48;
                }
                if (n17 == 32 || n17 == 48) {
                    n15 = 1 + (n9 * lerpSprite.dist >> 12) & 3;
                    Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] & 0xFFFF00FF | (n15 | n17) << 8;
                }
            }
            if (0 == (lerpSprite.flags & 0x10) && (n12 != n || n13 != n14)) {
                Game.unlinkEntity(entity);
                Game.linkEntity(entity, Render.mapSprites[Render.S_X + n3] >> 6, Render.mapSprites[Render.S_Y + n3] >> 6);
                n2 |= 2;
            }
        }
        if (!Canvas.staleView && (n4 == n12 && n5 == n13 || Render.checkTileVisibilty(n12, n13))) {
            n2 |= 4;
        }
        return n2;
    }

    public static final void snapLerpSprites(int n) {
        int n2;
        if (numLerpSprites == 0) {
            return;
        }
        numCallThreads = 0;
        for (n2 = 0; n2 < 16; ++n2) {
            int n3;
            LerpSprite lerpSprite = lerpSprites[n2];
            if (lerpSprite.hSprite == 0 || n != -1 && lerpSprite.hSprite != n + 1) continue;
            if (lerpSprite.thread != null && (lerpSprite.flags & 1) == 0) {
                n3 = 0;
                for (n3 = 0; n3 < numCallThreads && callThreads[n3] != lerpSprite.thread; ++n3) {
                }
                if (n3 == numCallThreads) {
                    Game.callThreads[Game.numCallThreads++] = lerpSprite.thread;
                }
            }
            lerpSprite.startTime = 0;
            lerpSprite.travelTime = 0;
            n3 = Game.updateLerpSprite(lerpSprite);
        }
        for (n2 = 0; n2 < numCallThreads; ++n2) {
            callThreads[n2].run();
        }
    }

    public static final void updateLerpSprites() {
        boolean bl = false;
        boolean bl2 = false;
        numCallThreads = 0;
        if (numLerpSprites > 0) {
            int n;
            for (n = 0; n < 16; ++n) {
                LerpSprite lerpSprite = lerpSprites[n];
                if (lerpSprite.hSprite == 0) continue;
                ScriptThread scriptThread = lerpSprite.thread;
                int n2 = lerpSprite.flags;
                int n3 = Game.updateLerpSprite(lerpSprite);
                if (0 != (n3 & 1) && (n2 & 1) == 0 && null != scriptThread) {
                    int n4 = 0;
                    for (n4 = 0; n4 < numCallThreads && callThreads[n4] != scriptThread; ++n4) {
                    }
                    if (n4 == numCallThreads) {
                        Game.callThreads[Game.numCallThreads++] = scriptThread;
                    }
                }
                bl2 = bl2 || (n3 & 2) != 0;
                bl = bl || (n3 & 4) != 0;
            }
            for (n = 0; n < numCallThreads; ++n) {
                if (!Game.callThreads[n].inuse) continue;
                callThreads[n].run();
            }
            if (bl2) {
                Canvas.updateFacingEntity = true;
            }
            if (bl) {
                Canvas.invalidateRect();
            }
        }
    }

    public static final LerpSprite allocLerpSprite(ScriptThread scriptThread, int n, boolean bl) {
        LerpSprite lerpSprite = null;
        LerpSprite lerpSprite2 = null;
        for (int i = 0; i < 16; ++i) {
            LerpSprite lerpSprite3 = lerpSprites[i];
            if (lerpSprite3.hSprite == n + 1) {
                lerpSprite = lerpSprite3;
                break;
            }
            if (lerpSprite2 != null || lerpSprite3.hSprite != 0) continue;
            lerpSprite2 = lerpSprite3;
        }
        if (lerpSprite2 != null && lerpSprite == null) {
            lerpSprite = lerpSprite2;
            lerpSprite.flags = 0;
            lerpSprite.hSprite = n + 1;
            lerpSprite.thread = scriptThread;
            ++numLerpSprites;
        } else {
            if ((lerpSprite.flags & 2) != 0) {
                --animatingEffects;
            }
            int n2 = lerpSprite.hSprite - 1;
            Entity entity = null;
            if (-1 != Render.mapSprites[Render.S_ENT + n2]) {
                entity = entities[Render.mapSprites[Render.S_ENT + n2]];
            }
            if (entity != null && entity.monster != null) {
                int n3 = (Render.mapSpriteInfo[n2] & 0xFF00) >> 8;
                int n4 = n3 & 0xF0;
                if (n4 == 32 || (lerpSprite.flags & 0x800) != 0) {
                    n4 = 0;
                } else if (n4 == 48) {
                    n4 = 16;
                }
                Render.mapSpriteInfo[n2] = Render.mapSpriteInfo[n2] & 0xFFFF00FF | n4 << 8;
            }
        }
        if (lerpSprite == null) {
            App.Error(36);
        }
        if (scriptThread == null) {
            lerpSprite.flags |= 1;
        }
        if (bl) {
            lerpSprite.flags |= 2;
            ++animatingEffects;
        }
        return lerpSprite;
    }

    private static final void freeLerpSprite(LerpSprite lerpSprite) {
        int n;
        int n2;
        Entity entity = null;
        int n3 = lerpSprite.hSprite - 1;
        int n4 = Render.mapSpriteInfo[n3] & 0xFF;
        if ((Render.mapSpriteInfo[n3] & 0x400000) != 0) {
            n4 += 257;
        }
        Render.mapSprites[Render.S_X + n3] = (short)lerpSprite.dstX;
        Render.mapSprites[Render.S_Y + n3] = (short)lerpSprite.dstY;
        if ((lerpSprite.flags & 8) == 0) {
            Render.mapSprites[Render.S_Z + n3] = (short)lerpSprite.dstZ;
        }
        Render.mapSprites[Render.S_SCALEFACTOR + n3] = (short)lerpSprite.dstScale;
        if ((lerpSprite.flags & 0x20) == 0) {
            Render.relinkSprite(n3);
        }
        if (-1 != Render.mapSprites[Render.S_ENT + n3]) {
            entity = entities[Render.mapSprites[Render.S_ENT + n3]];
        }
        int n5 = lerpSprite.dstX >> 6;
        int n6 = lerpSprite.dstY >> 6;
        if (null != entity && 0 == (Render.mapSpriteInfo[n3] & 0x10000)) {
            if (entity.def.eType == 3 || entity.def.eType == 2) {
                if (entity.monster != null) {
                    entity.monster.frameTime = 0;
                }
                Render.mapSpriteInfo[n3] = ((n2 = (n = (Render.mapSpriteInfo[n3] & 0xFF00) >> 8) & 0xF0) == 16 || n2 == 48) && (lerpSprite.flags & 0x800) == 0 ? Render.mapSpriteInfo[n3] & 0xFFFF00FF | 0x1000 : Render.mapSpriteInfo[n3] & 0xFFFF00FF | 0;
            }
            n = entity.linkIndex % 32;
            n2 = entity.linkIndex / 32;
            if (0 == (lerpSprite.flags & 0x10) && ((entity.info & 0x100000) == 0 || n5 != n || n6 != n2)) {
                Game.unlinkEntity(entity);
                Game.linkEntity(entity, Render.mapSprites[Render.S_X + n3] >> 6, Render.mapSprites[Render.S_Y + n3] >> 6);
            }
        }
        if ((lerpSprite.flags & 0x80) != 0) {
            Render.mapSprites[Render.S_SCALEFACTOR + n3] = 64;
            Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] & 0xFFFF00FF;
            Canvas.updateFacingEntity = true;
            Canvas.automapDrawn = false;
            int n7 = n3;
            Render.mapSpriteInfo[n7] = Render.mapSpriteInfo[n7] & Integer.MAX_VALUE;
        } else if ((lerpSprite.flags & 0x40) != 0 || (lerpSprite.flags & 0x200) != 0) {
            Canvas.updateFacingEntity = true;
            secretActive = false;
            Canvas.automapDrawn = false;
            Game.unlinkEntity(entity);
            if (entity.def.eType != 5) {
                int n8 = n3;
                Render.mapSpriteInfo[n8] = Render.mapSpriteInfo[n8] | 0x10000;
            }
        } else {
            if ((lerpSprite.flags & 0x408) == 1032) {
                n = lerpSprite.srcX - lerpSprite.dstX;
                n2 = lerpSprite.srcY - lerpSprite.dstY;
                lerpSprite.dstX = lerpSprite.srcX = Render.mapSprites[Render.S_X + n3];
                lerpSprite.dstY = lerpSprite.srcY = Render.mapSprites[Render.S_Y + n3];
                lerpSprite.srcZ = Render.mapSprites[Render.S_Z + n3];
                lerpSprite.flags &= 0xFFFFFFF7;
                if (n != 0) {
                    n /= Math.abs(n);
                }
                if (n2 != 0) {
                    n2 /= Math.abs(n2);
                }
                if ((lerpSprite.dstX & 0x3F) == 32 && (lerpSprite.dstY & 0x3F) == 32) {
                    n *= 64;
                    n2 *= 64;
                } else {
                    n *= 31;
                    n2 *= 31;
                }
                lerpSprite.dstX = (lerpSprite.dstX + n & 0xFFFFFFC0) + 32;
                lerpSprite.dstY = (lerpSprite.dstY + n2 & 0xFFFFFFC0) + 32;
                lerpSprite.dstZ = Render.getHeight(lerpSprite.dstX, lerpSprite.dstY) + 32;
                lerpSprite.height >>= 1;
                lerpSprite.startTime = App.gameTime - 100;
                lerpSprite.travelTime = 300;
                Game.updateLerpSprite(lerpSprite);
                return;
            }
            if ((lerpSprite.flags & 0x100) != 0) {
                lerpSprite.flags &= 0xFFFFFEFF;
                lerpSprite.flags |= 0x200;
                lerpSprite.srcX = lerpSprite.dstX;
                lerpSprite.srcY = lerpSprite.dstY;
                int n9 = n3;
                Render.mapSpriteInfo[n9] = Render.mapSpriteInfo[n9] | Integer.MIN_VALUE;
                Render.mapSprites[Render.S_SCALEFACTOR + n3] = (byte)lerpSprite.dstScale;
                lerpSprite.dstScale = 0;
                lerpSprite.startTime = App.gameTime;
                switch (Render.mapSpriteInfo[n3] & 0xF000000) {
                    case 0x4000000: {
                        lerpSprite.dstY += 32;
                        break;
                    }
                    case 0x1000000: {
                        lerpSprite.dstX += 32;
                        break;
                    }
                    case 0x8000000: {
                        lerpSprite.dstY -= 32;
                        break;
                    }
                    case 0x2000000: {
                        lerpSprite.dstX -= 32;
                    }
                }
                lerpSprite.travelTime = 750;
                Canvas.automapDrawn = false;
                return;
            }
        }
        if ((lerpSprite.flags & 0x400) != 0) {
            Render.mapSpriteInfo[n3] = Render.mapSpriteInfo[n3] & 0xFFFF00FF;
        }
        if ((lerpSprite.flags & 2) != 0) {
            lerpSprite.flags &= 0xFFFFFFFD;
            --animatingEffects;
        }
        lerpSprite.hSprite = 0;
        --numLerpSprites;
        if (entity != null) {
            Entity entity2;
            int n10;
            n = entity.def.eSubType;
            if (entity.monster != null) {
                int n11;
                int[] nArray;
                boolean bl;
                if ((entity.monster.goalFlags & 1) != 0) {
                    entity.aiFinishLerp();
                }
                if (Player.isFamiliar && entity.distFrom(Canvas.saveX, Canvas.saveY) <= Combat.tileDistances[0] && (bl = (n10 = (nArray = entity.calcPosition())[0] - Canvas.saveX) == 0 ^ (n11 = nArray[1] - Canvas.saveY) == 0)) {
                    if (Canvas.state == 18) {
                        Player.unsetFamiliarOnceOutOfCinematic = true;
                    } else {
                        Player.forceFamiliarReturnDueToMonster();
                    }
                }
            }
            if (entity.def.eType == 2 && (entity2 = Game.findMapEntity(lerpSprite.dstX, lerpSprite.dstY, 256)) != null) {
                if (entity2.def.eSubType == 1 && entity.def.eType == 2) {
                    int n12 = n10 = n == 2 ? 1 : 0;
                    if (n10 == 0) {
                        entity.monster.monsterEffects |= 0x60008;
                        entity.monster.monsterEffects &= 0xFFFFE1FD;
                    }
                } else {
                    entity.pain(5, entity2);
                }
            }
        }
    }

    public static final void runScriptThreads(int n) {
        if (numScriptThreads == 0) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            ScriptThread scriptThread = scriptThreads[i];
            if (!scriptThread.inuse) continue;
            if (scriptThread.state == 2) {
                if (Game.isInputBlockedByScript() && Canvas.state == 6) {
                    Canvas.setState(3);
                }
                if (Canvas.state == 3 || Canvas.state == 18) {
                    scriptThread.attemptResume(n);
                }
            }
            if (scriptThread.state == 2 && scriptThread.stackPtr != 0) continue;
            Game.freeScriptThread(scriptThread);
        }
    }

    public static final ScriptThread allocScriptThread() {
        for (int i = 0; i < 20; ++i) {
            ScriptThread scriptThread = scriptThreads[i];
            if (scriptThread.inuse) continue;
            scriptThread.init();
            scriptThread.inuse = true;
            ++numScriptThreads;
            return scriptThread;
        }
        App.Error(40);
        return null;
    }

    public static final void freeScriptThread(ScriptThread scriptThread) {
        if (!scriptThread.inuse) {
            App.Error(102);
            return;
        }
        scriptThread.reset();
        --numScriptThreads;
    }

    public static final boolean isCameraActive() {
        return activeCameraView && activeCamera != null;
    }

    public static final int executeTile(int n, int n2, int n3) {
        return Game.executeTile(n, n2, n3, false);
    }

    public static boolean doesScriptExist(int n, int n2, int n3) {
        if (n < 0 || n >= 32 || n2 < 0 || n2 >= 32) {
            return false;
        }
        int n4 = n2 * 32 + n;
        if ((Render.mapFlags[n4] & 0x40) != 0) {
            int n5 = Render.findEventIndex(n4);
            while (n5 != -1) {
                int n6 = Render.tileEvents[n5 + 1];
                int n7 = n6 & n3;
                if ((n6 & 0x80000) == 0 && (n7 & 0xF) != 0 && (n7 & 0xFF0) != 0 && ((n6 & 0x7000) == 0 && (n3 & 0x7000) == 0 || (n7 & 0x7000) != 0)) {
                    return true;
                }
                n5 = Render.getNextEventIndex();
            }
        }
        return false;
    }

    public static final int executeTile(int n, int n2, int n3, boolean bl) {
        int n4;
        ScriptThread scriptThread = Game.allocScriptThread();
        if (Canvas.state == 8) {
            n4 = scriptThread.queueTile(n, n2, n3, bl);
            scriptThread.unpauseTime = 0;
        } else {
            n4 = scriptThread.executeTile(n, n2, n3, bl);
        }
        if (n4 != 2) {
            Game.freeScriptThread(scriptThread);
        }
        return n4;
    }

    public static final int executeStaticFunc(int n) {
        if (n >= 12 || Render.staticFuncs[n] == 65535) {
            return 0;
        }
        ScriptThread scriptThread = Game.allocScriptThread();
        scriptThread.alloc(Render.staticFuncs[n]);
        return scriptThread.run();
    }

    public static final int queueStaticFunc(int n) {
        if (n >= 12 || Render.staticFuncs[n] == 65535) {
            return 0;
        }
        ScriptThread scriptThread = Game.allocScriptThread();
        scriptThread.alloc(Render.staticFuncs[n]);
        scriptThread.flags |= 2;
        scriptThread.unpauseTime = 0;
        Canvas.blockInputTime = App.gameTime + 1;
        return 2;
    }

    public static final int getSaveVersion() {
        return 11;
    }

    private static final void loadEntityStates(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readShort();
            for (int i = 0; i < n; ++i) {
                Resource.readMarker(dataInputStream);
                int n2 = dataInputStream.readInt();
                Entity entity = entities[n2 & 0xFFFF];
                entity.loadState(dataInputStream, n2);
            }
        }
        catch (IOException iOException) {
            App.Error(iOException, 19);
        }
    }

    private static final void saveEntityStates(DataOutputStream dataOutputStream, boolean bl) {
        try {
            int n;
            int[] nArray = new int[275];
            int n2 = 0;
            for (n = 0; n < numEntities; ++n) {
                Entity entity = entities[n];
                int n3 = entity.getSaveHandle(bl);
                if (n3 == -1) continue;
                int n4 = n2;
                n2 = (short)(n2 + 1);
                nArray[n4] = n3;
            }
            dataOutputStream.writeShort(n2);
            for (n = 0; n < n2; ++n) {
                int n5 = nArray[n];
                Entity entity = entities[n5 & 0xFFFF];
                Resource.writeMarker(dataOutputStream);
                dataOutputStream.writeInt(n5);
                entity.saveState(dataOutputStream, n5);
            }
        }
        catch (IOException iOException) {
            App.Error(iOException, 44);
        }
    }

    public static final boolean tileObstructsAttack(int n, int n2) {
        int n3 = Canvas.destX >> 6;
        int n4 = Canvas.destY >> 6;
        if (n != n3 && n2 != n4) {
            return false;
        }
        Entity entity = combatMonsters;
        while (entity != null) {
            int[] nArray = entity.calcPosition();
            int n5 = nArray[0] >> 6;
            int n6 = nArray[1] >> 6;
            if (n5 == n || n6 == n2) {
                int n7;
                int n8;
                if (n5 != n3) {
                    n8 = 0;
                    n7 = 0;
                    if (n5 < n3) {
                        n8 = n5;
                        n7 = n3;
                    } else if (n5 > n3) {
                        n8 = n3;
                        n7 = n5;
                    }
                    if (n > n8 && n < n7) {
                        return true;
                    }
                }
                if (n6 != n4) {
                    n8 = 0;
                    n7 = 0;
                    if (n6 < n4) {
                        n8 = n6;
                        n7 = n4;
                    } else if (n6 > n4) {
                        n8 = n4;
                        n7 = n6;
                    }
                    if (n2 > n8 && n2 < n7) {
                        return true;
                    }
                }
            }
            entity = entity.monster.nextAttacker;
        }
        return false;
    }

    public static final boolean isInputBlockedByScript() {
        if (numScriptThreads > 0) {
            for (int i = 0; i < 20; ++i) {
                ScriptThread scriptThread = scriptThreads[i];
                if (!scriptThread.inuse || (scriptThread.type & 0x10000) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static final void updateScriptVars() {
        Game.scriptStateVars[0] = (short)Player.statusEffects[33];
        Game.scriptStateVars[1] = (short)Player.ce.getStat(0);
        Game.scriptStateVars[2] = (short)(Canvas.viewX >> 6);
        Game.scriptStateVars[3] = (short)(Canvas.viewY >> 6);
        Game.scriptStateVars[14] = Player.characterChoice;
        Game.scriptStateVars[16] = Player.isFamiliar ? (short)1 : 0;
        Game.scriptStateVars[8] = Player.inventory[24];
    }

    public static final void awardSecret(boolean bl) {
        Hud.addMessage((short)119);
        mapSecretsFound = (byte)(mapSecretsFound + 1);
        if (mapSecretsFound == totalSecrets && (Player.foundSecretsLevels & 1 << Canvas.loadMapID - 1) == 0) {
            Player.showAchievementMessage(1);
            Player.foundSecretsLevels |= 1 << Canvas.loadMapID - 1;
        } else {
            Player.addXP(5);
        }
    }

    public static final void addEntityDeathFunc(Entity entity, int n) {
        int n2;
        for (n2 = 0; n2 < 64; ++n2) {
            if (entityDeathFunctions[n2 * 2] != -1) continue;
            Game.entityDeathFunctions[n2 * 2 + 0] = (short)entity.getSprite();
            Game.entityDeathFunctions[n2 * 2 + 1] = (short)n;
            break;
        }
        if (n2 == 64) {
            App.Error(new Exception("Too many entity death functions set"), -1);
        }
        entity.info |= 0x2000000;
    }

    public static final void removeEntityFunc(Entity entity) {
        int n;
        int n2 = entity.getSprite();
        for (n = 0; n < 64 && entityDeathFunctions[n * 2] != n2; ++n) {
        }
        if (n != 64) {
            Game.entityDeathFunctions[n * 2 + 0] = -1;
            Game.entityDeathFunctions[n * 2 + 1] = -1;
        }
        entity.info &= 0xFDFFFFFF;
    }

    public static final void executeEntityFunc(Entity entity, boolean bl) {
        int n;
        int n2 = entity.getSprite();
        short[] sArray = entityDeathFunctions;
        for (n = 0; n < 64 && sArray[n * 2] != n2; ++n) {
        }
        if (n != 64) {
            ScriptThread scriptThread = Game.allocScriptThread();
            scriptThread.throwAwayLoot = bl;
            scriptThread.alloc(sArray[n * 2 + 1]);
            scriptThread.run();
            sArray[n * 2 + 0] = -1;
            sArray[n * 2 + 1] = -1;
        }
    }

    public static final void foundLoot(int n, int n2) {
        Game.foundLoot(Render.mapSprites[Render.S_X + n], Render.mapSprites[Render.S_Y + n], Render.mapSprites[Render.S_Z + n], n2);
    }

    public static final void foundLoot(int n, int n2, int n3, int n4) {
        lootFound = (short)(lootFound + n4);
    }

    public static final void destroyedObject(int n) {
        ++destroyedObj;
    }

    public static final void raiseCorpses() {
        Entity entity = inactiveMonsters;
        int n = 0;
        if (entity != null) {
            int n2;
            Entity entity2;
            do {
                entity2 = entity.monster.nextOnList;
                n2 = entity.getSprite();
                if ((entity.info & 0x10000) != 0 || (entity.info & 0x8000000) != 0 || (entity.info & 0x1000000) == 0 || entity.isBoss() || (entity.monster.flags & 0x40) != 0 || Game.findMapEntity(Render.mapSprites[Render.S_X + n2], Render.mapSprites[Render.S_Y + n2], 15535) != null || difficulty == 4 && 0 != (entity.monster.monsterEffects & 4)) continue;
                Game.gridEntities[n++] = entity;
                if (n == 9) break;
            } while ((entity = entity2) != inactiveMonsters && n != 4);
            for (int i = 0; i < n; ++i) {
                entity = gridEntities[i];
                entity.info |= 0x8000000;
                n2 = entity.getSprite();
                entity.resurrect(Render.mapSprites[Render.S_X + n2], Render.mapSprites[Render.S_Y + n2], Render.mapSprites[Render.S_Z + n2]);
                Game.activate(entity, false, false, true, true);
                GameSprite gameSprite = Game.gsprite_allocAnim(241, Render.mapSprites[Render.S_X + n2], Render.mapSprites[Render.S_Y + n2], Render.mapSprites[Render.S_Z + n2] - 20);
                gameSprite.flags |= 0x400;
                gameSprite.startScale = (byte)64;
                gameSprite.destScale = (byte)96;
                gameSprite.scaleStep = 40;
                int[] nArray = entity.calcPosition();
                ParticleSystem.spawnParticles(1, -3355444, nArray[0], nArray[1], Render.getHeight(nArray[0], nArray[1]) + 48);
            }
        }
    }

    public static final boolean isInFront(int n, int n2) {
        int n3 = 256 - (Canvas.viewAngle & 0x3FF);
        int n4 = (n << 6) + 32 - Canvas.viewX;
        int n5 = (n2 << 6) + 32 - Canvas.viewY;
        if (n4 == 0 && n5 == 0) {
            return true;
        }
        int n6 = Game.VecToDir(n4, n5, true) + n3 & 0x3FF;
        return n6 >= 128 && n6 <= 384;
    }

    public static int VecToDir(int n, int n2, boolean bl) {
        int n3;
        int n4 = -1;
        int n5 = n3 = bl ? 7 : 0;
        if (n <= -32) {
            n4 = 4;
        } else if (n >= 32) {
            n4 = 0;
        }
        if (n2 >= 32) {
            n4 = n4 == 4 ? 5 : (n4 == 0 ? 7 : 6);
        } else if (n2 <= -32) {
            n4 = n4 == 4 ? 3 : (n4 == 0 ? 1 : 2);
        }
        return n4 << n3;
    }

    public static void NormalizeVec(int n, int n2, int[] nArray) {
        int n3 = (int)Game.FixedSqrt(n * n + n2 * n2);
        nArray[0] = (n << 12) / n3;
        nArray[1] = (n2 << 12) / n3;
    }

    public static long FixedSqrt(long l) {
        long l2;
        if (l == 0L) {
            return 0L;
        }
        long l3 = 256L;
        l3 = l3 + (l <<= 8) / l3 >> 1;
        l3 = l3 + l / l3 >> 1;
        l3 = l3 + l / l3 >> 1;
        l3 = l3 + l / l3 >> 1;
        for (int i = 0; i < 12 && (l2 = l3 + l / l3 >> 1) != l3; ++i) {
            l3 = l2;
        }
        return l3;
    }

    static {
        entities = new Entity[275];
        entityDb = new Entity[1024];
        entityMonsters = new EntityMonster[80];
        dropIndex = 0;
        skippingCinematic = false;
        queueAdvanceTurn = false;
        keycode = new char[7];
        eventFlags = new int[2];
        gsprites = new GameSprite[48];
        hasSeenIntro = false;
        levelVars = new int[8];
        levelNames = null;
        lootFound = 0;
        totalLoot = 0;
        lerpSprites = new LerpSprite[16];
        scriptThreads = new ScriptThread[20];
        pathVisited = new boolean[64];
        pathParents = new short[64];
        pathSearches = new short[64];
        openDoors = new Entity[6];
        scriptStateVars = new short[128];
        entityDeathFunctions = new short[128];
        numDestroyableObj = 0;
        destroyedObj = 0;
        placedBombs = new int[]{0, 0, 0, 0};
        gridEntities = new Entity[9];
        numMallocsForVIOS = 0;
        angryVIOS = false;
        numLevelLoads = new short[10];
        totalPlayTime = 0;
        lastSaveTime = 0;
        traceEntities = new Entity[32];
        traceFracs = new int[32];
        traceBoundingBox = new int[4];
        tracePoints = new int[4];
        dropDirs = new int[]{64, 0, 64, 64, 0, 64, -64, 64, -64, 0, -64, -64, 0, -64, 64, -64};
        numCallThreads = 0;
        callThreads = new ScriptThread[16];
    }
}

