/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class ParticleSystem {
    public static int touchMe = 1;
    private static final int MAX_SYSTEMS = 4;
    private static final int MAX_PARTICLES = 64;
    private static final int FREE_PARTICLE = 63;
    private static final int INVALID_PARTICLE = 255;
    private static final int GIB_FLAG = 8;
    private static final int SIZE_MASK = 7;
    private static final int SYSTEM_SIZE = 64;
    public static final int GIBTYPE_NONE = -1;
    public static final int GIBTYPE_WOOD = 0;
    public static final int GIBTYPE_STONE = 1;
    public static final int GIBTYPE_SKELETON = 2;
    public static final int GIBTYPE_MAX = 3;
    private static int systemIdx = 0;
    private static ParticleSystem[] systems;
    private static final int NUM_GIBS = 4;
    private static final int GIBSIZE = 24;
    public static Image[] imgGibs;
    public static final int COLOR_WOOD = -8421505;
    public static final int COLOR_SPARKS = -3027183;
    public static final int COLOR_CHICKEN = -1;
    public static final int COLOR_TOILET = -1;
    public static final int COLOR_FLAG = -7267291;
    public static final int COLOR_EXPLOSION = -161512;
    private short[] pos = new short[3];
    private int gravity;
    private byte gibType;
    private int color;
    private int startTime;
    private static final byte[] particleNext;
    private static final byte[] particleStartX;
    private static final byte[] particleStartY;
    private static final short[] particleVelX;
    private static final short[] particleVelY;
    private static final byte[] particleSize;
    public static final int[] levelColors;
    private static int[] rotationSequence;
    public static final int INTERPOLATION_SHIFT = 10;
    static int[] clipRect;
    public static final int SYSTEM_DEBUG = 0;
    public static final int SYSTEM_MONSTER_BLOOD = 1;
    public static final int SYSTEM_WOOD_GIBS = 2;
    public static final int SYSTEM_STONE_GIBS = 3;
    public static final int SYSTEM_BONE_GIBS = 4;
    public static final int SYSTEM_SPARKS = 5;
    public static final int SYSTEM_FALLING_DEBRIS = 6;
    public static final int SYSTEM_EXPLOSION = 7;
    public static final int SYSTEM_IMPLODE = 8;
    public static final int MONSTER_BLOOD_COLOR = -14634995;
    public static final int BOSS_VIOS_BLOOD_COLOR = -1;
    public static final int GIB_BONE_MASK = 1561;

    public static final void startup() {
        systems = new ParticleSystem[4];
        for (int i = 0; i < systems.length; ++i) {
            ParticleSystem.systems[i] = new ParticleSystem();
        }
        ParticleSystem.freeAllParticles();
    }

    public static final int unlinkParticle(int n) {
        int n2 = particleNext[n] & 0xFF;
        if (n2 != 255) {
            ParticleSystem.particleNext[n] = particleNext[n2];
            ParticleSystem.particleNext[n2] = -1;
        }
        return n2;
    }

    public static final void linkParticle(int n, int n2) {
        ParticleSystem.particleNext[n2] = particleNext[n];
        ParticleSystem.particleNext[n] = (byte)n2;
    }

    public static final void freeAllParticles() {
        ParticleSystem.particleNext[63] = -1;
        for (int i = 0; i < 63; ++i) {
            if (i < 4) {
                ParticleSystem.particleNext[i] = -1;
                continue;
            }
            ParticleSystem.linkParticle(63, i);
        }
    }

    public static final void freeSystem(int n) {
        int n2 = ParticleSystem.unlinkParticle(n);
        while (n2 != 255) {
            ParticleSystem.linkParticle(63, n2);
            n2 = ParticleSystem.unlinkParticle(n);
        }
    }

    public final void render(Graphics graphics, int n) {
        int n2 = n;
        int n3 = particleNext[n] & 0xFF;
        if (n3 != 255) {
            int n4 = (App.gameTime - this.startTime << 10) / 1000;
            int n5 = n4 * n4 >> 10;
            int n6 = 64 * Render.sinTable[Render.viewAngle & 0x3FF] >> 12;
            int n7 = 64 * Render.sinTable[Render.viewAngle + 256 & 0x3FF] >> 12;
            TGLVert tGLVert = TinyGL.mv[0];
            tGLVert.x = this.pos[0] + n6;
            tGLVert.y = this.pos[1] + n7;
            tGLVert.z = this.pos[2] + 1024;
            TGLVert tGLVert2 = TinyGL.mv[1];
            tGLVert2.x = tGLVert.x;
            tGLVert2.y = tGLVert.y;
            tGLVert2.z = tGLVert.z - 2048;
            tGLVert2 = TinyGL.mv[2];
            tGLVert2.x = tGLVert.x - (n6 << 1);
            tGLVert2.y = tGLVert.y - (n7 << 1);
            tGLVert2.z = tGLVert.z;
            TGLVert[] tGLVertArray = TinyGL.transform3DVerts(TinyGL.mv, 3);
            if (tGLVertArray[0].w + tGLVertArray[0].z < 0 || tGLVertArray[1].w + tGLVertArray[1].z < 0 || tGLVertArray[2].w + tGLVertArray[2].z < 0) {
                return;
            }
            TinyGL.projectVerts(tGLVertArray, 3);
            int n8 = tGLVertArray[0].x;
            int n9 = tGLVertArray[2].x;
            int n10 = 0x7FFFFF / tGLVertArray[0].z;
            int n11 = (n8 >>= 3) + (n9 >>= 3) >> 1;
            if (n11 < 0 || n11 >= TinyGL.screenWidth || n10 > TinyGL.columnScale[n11]) {
                return;
            }
            int n12 = tGLVertArray[1].x - tGLVertArray[2].x;
            int n13 = tGLVertArray[1].y - tGLVertArray[0].y;
            int n14 = 0;
            int n15 = 0;
            int n16 = (n12 << 7) / 128;
            int n17 = (n13 << 7) / 128;
            n12 >>= 3;
            n13 >>= 3;
            int n18 = n14 + (tGLVertArray[2].x >> 3);
            int n19 = n15 + (tGLVertArray[0].y >> 3);
            int[] nArray = Canvas.viewRect;
            if (n18 < 0) {
                n12 -= -n18;
                n18 = 0;
            }
            if (n19 < 0) {
                n13 -= -n19;
                n19 = 0;
            }
            if (n12 + n18 > nArray[2]) {
                n12 -= n18 + n12 - nArray[2];
            }
            if (n13 + n19 > nArray[3]) {
                n13 -= n19 + n13 - nArray[3];
            }
            if (n12 < 0 || n13 < 0) {
                return;
            }
            graphics.clipRect(n18, n19, n12, n13);
            n14 += tGLVertArray[1].x + tGLVertArray[2].x >> 4;
            n15 += tGLVertArray[0].y + tGLVertArray[1].y >> 4;
            if (Render.postProcessMode != 0) {
                this.color = Render.convertToGrayscale(this.color);
            }
            graphics.setColor(this.color);
            while (n3 != 255) {
                int n20 = particleSize[n3 >> 1] >> ((n3 & 1) << 2);
                boolean bl = (n20 & 8) != 0;
                n20 &= 7;
                int n21 = (particleStartX[n3] << 10) + particleVelX[n3] * n4;
                int n22 = (particleStartY[n3] << 10) - (particleVelY[n3] * n4 + n5 * this.gravity);
                if (n21 < -65536 || n21 > 65536 || n22 > 65536 || n22 < -65536) {
                    ParticleSystem.linkParticle(63, ParticleSystem.unlinkParticle(n2));
                    n3 = n2;
                } else {
                    n21 = n14 + (n21 * n16 >> 20);
                    n22 = n15 + (n22 * n17 >> 20);
                    if (!bl) {
                        n20 = n20 * Math.min(n16, 1024) >> 10;
                        graphics.fillCircle(n21, n22, n20);
                    } else {
                        int n23 = Math.min(n16 * 3 >> 10, 3) - 1;
                        if (n23 >= 0) {
                            int n24 = (n3 << 6) + n4 >> 8 & 3;
                            if (particleVelX[n3] < 0) {
                                n24 = 3 - n24;
                            }
                            graphics.drawRegion(imgGibs[this.gibType], (2 - n23) * 24, n20 * 24, 24, 24, n21, n22, 3, rotationSequence[n24]);
                        }
                    }
                }
                n2 = n3;
                n3 = particleNext[n2] & 0xFF;
            }
        }
    }

    public static final void renderSystems(Graphics graphics) {
        System.arraycopy(Canvas.viewRect, 0, clipRect, 0, 4);
        if (Canvas.state == 18) {
            clipRect[0] = clipRect[0] + Canvas.cinRect[0];
            clipRect[1] = clipRect[1] + Canvas.cinRect[1];
            ParticleSystem.clipRect[2] = Canvas.cinRect[2];
            ParticleSystem.clipRect[3] = Canvas.cinRect[3];
        }
        clipRect[0] = clipRect[0] + 1;
        clipRect[1] = clipRect[1] + 1;
        clipRect[2] = clipRect[2] - 2;
        clipRect[3] = clipRect[3] - 2;
        for (int i = 0; i < 4; ++i) {
            graphics.setScreenSpace(clipRect);
            systems[i].render(graphics, i);
            graphics.resetScreenSpace();
        }
    }

    public static final void spawnMonsterBlood(Entity entity, boolean bl) {
        if (entity == null) {
            return;
        }
        int n = entity.getSprite();
        int n2 = 0;
        if (entity.def.eType == 9) {
            n2 -= 26;
        }
        int n3 = -14634995;
        if (entity.def.eSubType == 15 || entity.def.eSubType == 16) {
            n3 = -1;
        }
        if (bl && (0x619 & 1 << entity.def.eSubType) != 0) {
            ParticleSystem.spawnParticles(4, n3, Render.mapSprites[Render.S_X + n], Render.mapSprites[Render.S_Y + n], Render.mapSprites[Render.S_Z + n] + n2);
        } else {
            ParticleSystem.spawnParticles(1, n3, Render.mapSprites[Render.S_X + n], Render.mapSprites[Render.S_Y + n], Render.mapSprites[Render.S_Z + n] + n2);
        }
    }

    public static final void spawnParticles(int n, int n2, int n3) {
        ParticleSystem.spawnParticles(n, n2, Render.mapSprites[Render.S_X + n3], Render.mapSprites[Render.S_Y + n3], Render.mapSprites[Render.S_Z + n3]);
    }

    public static final void spawnParticles(int n, int n2, int n3, int n4, int n5) {
        int n6 = -64;
        int n7 = 64;
        int n8 = -64;
        int n9 = 64;
        int n10 = -128;
        int n11 = 128;
        int n12 = -32;
        int n13 = 32;
        int n14 = 4;
        int n15 = 7;
        int n16 = -196;
        int n17 = 15;
        int n18 = 0;
        int n19 = -1;
        switch (n) {
            case 0: {
                n10 = 0;
                n11 = 0;
                n12 = 0;
                n13 = 0;
                n16 = 0;
                n19 = 0;
                n18 = 5;
                break;
            }
            case 1: {
                n6 >>= 2;
                n7 >>= 2;
                n8 >>= 2;
                n9 >>= 2;
                n12 = 96;
                n13 = 110;
                break;
            }
            case 7: {
                n6 >>= 3;
                n7 >>= 3;
                n8 >>= 3;
                n9 >>= 3;
                n10 = -128;
                n11 = 128;
                n12 = -128;
                n13 = 128;
                break;
            }
            case 5: {
                n6 >>= 3;
                n7 >>= 3;
                n8 >>= 3;
                n9 >>= 3;
                n17 = 8;
                n10 = -128;
                n11 = 128;
                n12 = -128;
                n13 = 128;
                break;
            }
            case 3: {
                n6 >>= 2;
                n7 >>= 2;
                n8 >>= 2;
                n9 >>= 2;
                n10 = -32;
                n11 = 32;
                n12 = 118;
                n13 = 128;
                n18 = 5;
                n19 = 1;
                break;
            }
            case 2: {
                n6 >>= 2;
                n7 >>= 2;
                n8 >>= 2;
                n9 >>= 2;
                n10 = -32;
                n11 = 32;
                n12 = 64;
                n13 = 78;
                n18 = 0;
                n19 = -1;
                break;
            }
            case 4: {
                n6 >>= 2;
                n7 >>= 2;
                n8 >>= 2;
                n9 >>= 2;
                n18 = 0;
                n10 = -32;
                n11 = 32;
                n12 = 64;
                n13 = 78;
                n18 = 5;
                n19 = 2;
                break;
            }
            case 6: {
                n6 >>= 1;
                n7 >>= 1;
                n8 = -64;
                n9 = -40;
                n18 = 0;
                n10 = 0;
                n11 = 0;
                n12 = 0;
                n13 = -128;
                break;
            }
            case 8: {
                n6 >>= 2;
                n7 >>= 2;
                n8 = -15;
                n9 = 15;
                n17 = 8;
                n18 = 0;
                n10 = 0;
                n11 = -128;
                n12 = 0;
                n13 = -128;
            }
        }
        int n20 = systemIdx;
        systemIdx = (systemIdx + 1) % 4;
        ParticleSystem particleSystem = systems[n20];
        ParticleSystem.freeSystem(n20);
        particleSystem.color = n2;
        particleSystem.gravity = n16;
        particleSystem.gibType = (byte)n19;
        particleSystem.startTime = App.gameTime;
        particleSystem.pos[0] = (short)(n3 << 4);
        particleSystem.pos[1] = (short)(n4 << 4);
        particleSystem.pos[2] = (short)(n5 << 4);
        while (n18 > 0 || n17 > 0) {
            int n21 = ParticleSystem.unlinkParticle(63);
            if (n21 == 255) {
                return;
            }
            int n22 = 0;
            if (n17 > 0) {
                n22 = n14 + ((n15 - n14) * App.nextByte() >> 8) & 7;
                --n17;
            } else if (n18 > 0) {
                n22 = App.nextByte() % 4 | 8;
                --n18;
            }
            ParticleSystem.particleStartX[n21] = (byte)(n6 + ((n7 - n6) * App.nextByte() >> 8));
            ParticleSystem.particleStartY[n21] = (byte)(n8 + ((n9 - n8) * App.nextByte() >> 8));
            ParticleSystem.particleVelX[n21] = (short)(n10 + ((n11 - n10) * App.nextByte() >> 8));
            ParticleSystem.particleVelY[n21] = (short)(n12 + ((n13 - n12) * App.nextByte() >> 8));
            int n23 = n21 >> 1;
            particleSize[n23] = (byte)(particleSize[n23] & ~(15 << ((n21 & 1) << 2)));
            int n24 = n21 >> 1;
            particleSize[n24] = (byte)(particleSize[n24] | n22 << ((n21 & 1) << 2));
            ParticleSystem.linkParticle(n20, n21);
        }
    }

    static {
        imgGibs = new Image[3];
        particleNext = new byte[64];
        particleStartX = new byte[64];
        particleStartY = new byte[64];
        particleVelX = new short[64];
        particleVelY = new short[64];
        particleSize = new byte[32];
        levelColors = new int[]{-1, -12963026, -10329502, -8421505, -3027183, -161512, -14634995};
        rotationSequence = new int[]{0, 5, 3, 6};
        clipRect = new int[4];
    }
}

