/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

final class Hud {
    public static int touchMe = 1;
    private static final int MSG_DISPLAY_TIME = 700;
    private static final int MSG_FLASH_TIME = 100;
    private static final int SCROLL_START_DELAY = 750;
    private static final int MS_PER_CHAR = 50;
    private static final int MAX_MESSAGES = 5;
    public static final int REPAINT_EFFECTS = 1;
    public static final int REPAINT_TOP_BAR = 2;
    public static final int REPAINT_BOTTOM_BAR = 4;
    public static final int REPAINT_BUBBLE_TEXT = 8;
    public static final int REPAINT_SUBTITLES = 16;
    public static final int REPAINT_HUD_OVERDRAW = 32;
    public static final int REPAINT_DPAD = 64;
    public static final int REPAINT_PLAYING_FLAGS = 107;
    public static final int REPAINT_CAMERA_FLAGS = 24;
    public static int repaintFlags = 0;
    public static final int MSG_FLAG_NONE = 0;
    public static final int MSG_FLAG_FORCE = 1;
    public static final int MSG_FLAG_CENTER = 2;
    public static final int MSG_FLAG_IMPORTANT = 4;
    private static final int STATUSBAR_ICON_PICKUP = 0;
    private static final int STATUSBAR_ICON_ATTACK = 1;
    private static final int STATUSBAR_ICON_CHAT = 2;
    private static final int STATUSBAR_ICON_USE = 3;
    public static final int HUDARROWS_SIZE = 12;
    private static final int BUBBLE_TEXT_TIME = 1500;
    private static final int SENTRY_BOT_ICONS_PADDING = 15;
    public static final int DAMAGE_OVERLAY_TIME = 1000;
    public static Image imgScope;
    public static Image imgActions;
    public static Image imgAttArrow;
    public static Image imgDamageVignette;
    public static Image imgDamageVignetteBot;
    public static Image imgBottomBarIcons;
    public static Image imgAmmoIcons;
    public static Image imgSoftKeyFill;
    public static Image imgCockpitOverlay;
    public static int[] cockpitOverlayRaw;
    public static final int ACTION_ICON_SIZE = 18;
    public static Image imgPortraitsSM;
    public static Image imgPlayerFaces;
    public static Image imgHudFill;
    public static Image imgIce;
    public static Image imgSentryBotFace;
    public static Image imgHudTest;
    private static Text[] messages;
    static int[] messageFlags;
    public static int msgCount;
    static int msgTime;
    private static int msgDuration;
    public static int subTitleID;
    public static int subTitleTime;
    public static int cinTitleID;
    public static int cinTitleTime;
    private static Text bubbleText;
    private static int bubbleTextTime;
    private static int bubbleColor;
    public static int damageTime;
    public static int damageCount;
    public static int damageDir;
    public static Entity lastTarget;
    private static int monsterStartHealth;
    private static int monsterDestHealth;
    public static int playerStartHealth;
    public static int playerDestHealth;
    private static int monsterHealthChangeTime;
    public static int playerHealthChangeTime;
    public static boolean showCinPlayer;
    public static int drawTime;
    private static final int DEF_MESSAGE_TIME = 1500;
    public static final int FILLER_BEVEL_COLOR1 = -6645369;
    public static final int FILLER_BEVEL_COLOR2 = -14868980;
    public static final int SHOOTING_PRACTICE_Y_TEXT_OFFSET = 30;
    static final int IMG_FACE_WIDTH = 32;
    static final int IMG_FACE_HEIGHT = 32;
    static final int IMG_FACE_HALF_WIDTH = 16;
    static final int ARROW_WIDTH = 20;
    private static final int BTM_ICON_W = 16;
    private static final int BTM_ICON_H = 12;
    private static final int BTM_KEY_W = 13;
    private static final int BTM_KEY_H = 20;
    public static final int HUD_OVERDRAW_H = 13;
    public static final int CHAT_HOOK_HEIGHT = 6;
    public static final int CHAT_HOOK_WIDTH = 10;
    static int[] dragRet;
    public static Image imgSoftKeyButton;
    public static Image imgSoftKeySwitch;
    public static Image imgSniperControls;
    public static Image dpad;
    public static Image dpadDown;
    public static Image dpadLeft;
    public static Image dpadRight;
    public static Image dpadUp;
    public static final int DPAD_NEUTRAL = 0;
    public static final int DPAD_UP = 1;
    public static final int DPAD_RIGHT = 2;
    public static final int DPAD_DOWN = 3;
    public static final int DPAD_LEFT = 4;
    public static final int DPAD_IGNORED = 5;
    public static final int HUD_ACTION_NONE = 0;
    public static final int HUD_ACTION_ARMOR = 1;
    public static final int HUD_ACTION_WEAPON = 2;
    public static final int HUD_ACTION_PASS = 3;
    public static final int HUD_ACTION_KEYS = 4;
    public static final int HUD_ACTION_HEALTH = 5;
    public static final int HUD_ACTION_IGNORED = 6;
    public static int dpadState;
    public static int[] dpadCenter;
    public static int dpadExtent;
    private static final int STRAFE_TOLERANCE = 50;
    private static final int SNIPER_TOLERANCE = 10;
    private static int zoomSliderOfs;
    private static boolean zoomOkayToPop;
    public static boolean zoomBlockInput;
    public static int zoomPendingNotches;
    private static int zoomCachedNotch;
    public static int scopeState;
    public static final int SCOPE_STATE_GOOD = 0;
    public static final int SCOPE_STATE_WARNING = 1;
    public static final int SCOPE_STATE_DANGER = 2;
    public static final int SCOPE_STATE_FLASHING = 3;
    private static int sniperState;
    public static final int SNIPER_STATE_NONE = 0;
    public static final int SNIPER_STATE_FIRE = 1;
    public static final int SNIPER_STATE_MOVE = 2;
    public static final int SNIPER_STATE_ZOOM = 4;
    public static final int SNIPER_STATE_ZBUTTON = 5;
    public static final int SNIPER_STATE_EXIT = 6;
    public static boolean isLSKDown;
    public static boolean isRSKDown;
    public static boolean inDpadMoveState;
    private static final int DPAD_BOTTOM_BUFFER = 10;
    public static int weaponPressTime;
    private static final int WEAPON_WAIT_TIME = 1000;
    public static final int WEAPONS_PER_ROW = 3;
    public static boolean isInWeaponSelect;
    private static boolean releaseShouldCauseClose;
    public static boolean hudEventsAvailable;

    Hud() {
    }

    public static final boolean startup() {
        for (int i = 0; i < messages.length; ++i) {
            Hud.messages[i] = new Text(128);
        }
        msgCount = 0;
        try {
            dpad = Image.createImage((String)"/dpad.png");
            dpadDown = Image.createImage((String)"/dpad_d.png");
            dpadLeft = Image.createImage((String)"/dpad_l.png");
            dpadRight = Image.createImage((String)"/dpad_r.png");
            dpadUp = Image.createImage((String)"/dpad_u.png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        dpadState = 0;
        dpadExtent = (dpad.getWidth() >> 1) + 5;
        Hud.dpadCenter[0] = Canvas.viewRect[0] + dpadExtent;
        Hud.dpadCenter[1] = Canvas.viewRect[1] + Canvas.viewRect[3] - dpadExtent - 10;
        inDpadMoveState = false;
        weaponPressTime = 0;
        isInWeaponSelect = false;
        releaseShouldCauseClose = false;
        zoomSliderOfs = -1;
        zoomOkayToPop = false;
        zoomPendingNotches = 0;
        zoomCachedNotch = 0;
        hudEventsAvailable = false;
        Hud.resetSoftkeys();
        return true;
    }

    private static final void shiftMsgs() {
        if ((messageFlags[0] & 2) != 0) {
            Canvas.invalidateRect();
        }
        for (int i = 0; i < msgCount - 1; ++i) {
            messages[i].setLength(0);
            messages[i].append(messages[i + 1]);
            Hud.messageFlags[i] = messageFlags[i + 1];
        }
        messages[--msgCount].setLength(0);
        Hud.messageFlags[Hud.msgCount] = 0;
        if (msgCount > 0) {
            Hud.calcMsgTime();
        }
    }

    private static final void calcMsgTime() {
        msgTime = App.time;
        int n = messages[0].length();
        if (n <= Canvas.menuHelpMaxChars) {
            msgDuration = 700;
        } else {
            msgDuration = n * 50;
            if ((messageFlags[0] & 2) != 0 && msgDuration > 1500) {
                msgDuration = 1500;
            }
        }
    }

    public static final void addMessage(short s) {
        Hud.addMessage((short)0, s, 0);
    }

    public static final void addMessage(short s, short s2) {
        Hud.addMessage(s, s2, 0);
    }

    public static final void addMessage(short s, int n) {
        Hud.addMessage((short)0, s, n);
    }

    public static final void addMessage(short s, short s2, int n) {
        Text text = Text.getSmallBuffer();
        Text.composeText(s, s2, text);
        Hud.addMessage(text, n);
        text.dispose();
    }

    public static final void addMessage(Text text) {
        Hud.addMessage(text, 0);
    }

    public static final void addMessage(Text text, int n) {
        if (text == null) {
            return;
        }
        if ((n & 1) != 0) {
            msgCount = 0;
        }
        if (msgCount > 0 && text.equals(messages[msgCount - 1])) {
            return;
        }
        if (msgCount == 5) {
            Hud.shiftMsgs();
        }
        messages[msgCount].setLength(0);
        messages[msgCount].append(text);
        if ((n & 2) != 0) {
            messages[msgCount].wrapText((Canvas.viewRect[2] - 9) / 9);
        } else {
            messages[msgCount].dehyphenate();
        }
        Hud.messageFlags[Hud.msgCount] = n;
        if (++msgCount == 1) {
            Hud.calcMsgTime();
            if ((n & 1) != 0) {
                msgDuration *= 2;
            }
        }
    }

    public static final Text getMessageBuffer() {
        return Hud.getMessageBuffer(0);
    }

    public static final Text getMessageBuffer(int n) {
        if ((n & 1) != 0) {
            msgCount = 0;
        }
        if (msgCount == 5) {
            Hud.shiftMsgs();
        }
        messages[msgCount].setLength(0);
        Hud.messageFlags[Hud.msgCount] = n;
        return messages[msgCount];
    }

    public static final void finishMessageBuffer() {
        messages[msgCount].dehyphenate();
        if (++msgCount == 1) {
            Hud.calcMsgTime();
        }
    }

    public static boolean isShiftingCenterMsg() {
        return msgCount > 0 && App.time - msgTime > msgDuration && (messageFlags[0] & 2) != 0;
    }

    private static final void drawTopBar(Graphics graphics) {
        int n;
        Text text = Text.getSmallBuffer();
        int n2 = 2;
        Entity entity = Player.facingEntity;
        if (Player.isFamiliar) {
            graphics.fillRect(-Canvas.screenRect[0], 0, Canvas.hudRect[2], 37, -16777216);
        } else {
            graphics.fillRegion(imgHudFill, -Canvas.screenRect[0], 0, Canvas.hudRect[2], 37);
            graphics.drawBevel(-6645369, -14868980, -Canvas.screenRect[0], 0, Canvas.hudRect[2], 37);
        }
        if (Canvas.state != 13) {
            Hud.drawMonsterHealth(graphics);
        }
        if (msgCount > 0 && App.time - msgTime > msgDuration + 100) {
            Hud.shiftMsgs();
        }
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        if (msgCount > 0) {
            if ((messageFlags[0] & 4) != 0) {
                Hud.drawImportantMessage(graphics, messages[0], -8454144);
            } else {
                text.setLength(0);
                text.append(messages[0]);
                boolean bl3 = bl2 = (messageFlags[0] & 2) != 0;
                if (App.time - msgTime > msgDuration) {
                    bl = true;
                } else {
                    int n5;
                    n = text.length() - Canvas.menuHelpMaxChars;
                    if (n > 0 && (n5 = App.time - msgTime) > 750 && (n4 = (n5 - 750) / 50) > n) {
                        n4 = n;
                    }
                }
            }
        } else if (Player.inTargetPractice) {
            bl = true;
        } else if (Canvas.state != 1 && entity != null && entity.def.eType != 0 && (entity.def.eType != 12 || (entity.info & 0x40000) != 0)) {
            text.setLength(0);
            n = (entity.info & 0xFFFF) - 1;
            int n6 = Render.mapSpriteInfo[n] & 0xFF;
            byte by = entity.def.eType;
            if ((entity.name & 0x3FF) != entity.def.name || entity.def.longName == 159) {
                Text.composeTextField(entity.name, text);
            } else {
                Text.composeTextField(0x400 | entity.def.longName, text);
            }
            text.dehyphenate();
            if (by == 3) {
                n3 = 2;
            } else if (by == 2) {
                text.setLength(0);
                if ((entity.name & 0x3FF) != entity.def.name) {
                    Text.composeTextField(entity.name, text);
                } else {
                    Text.composeTextField(entity.def.longName | 0x400, text);
                }
                n3 = 1;
                text.dehyphenate();
            } else if (by == 6) {
                n3 = 0;
            } else if (by == 5) {
                if ((entity.name & 0x3FF) == entity.def.name || !Text.isEmptyString(entity.name)) {
                    n3 = 3;
                }
                if (by == 5 && (entity.def.parm & 2) != 0) {
                    bl2 = true;
                }
            } else if (by == 12) {
                bl2 = true;
            } else if (by == 7 && entity.def.eSubType == 1) {
                bl2 = true;
            } else if (by == 7) {
                int n7;
                byte by2 = entity.def.eSubType;
                if (by2 == 3) {
                    n3 = 1;
                } else if (entity.def.parm == 1) {
                    n3 = 3;
                } else if (entity.def.parm == 2 && (Render.mapSpriteInfo[n] & 0xFF00) >> 8 == (n7 = 0)) {
                    n3 = 3;
                }
            } else if (by == 14) {
                if (n6 == 142) {
                    bl2 = true;
                } else if (n6 == 143) {
                    n3 = 3;
                } else if (n6 == 141) {
                    n3 = 1;
                } else if (n6 == 134) {
                    n3 = 0;
                } else if (entity.def.eSubType == 8) {
                    n3 = 3;
                }
            } else if (by == 10) {
                n3 = entity.def.eSubType == 3 || entity.def.eSubType == 2 ? 0 : 1;
            }
        } else if (entity != null && entity.def.eType == 12) {
            n = (entity.info & 0xFFFF) - 1;
            if ((Render.mapSpriteInfo[n] & 0xFF) == 153 && (Render.mapSpriteInfo[n] & 0xFF00) >> 8 == 0) {
                n3 = 3;
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            if (bl2 && text.length() > 0) {
                Hud.drawCenterMessage(graphics, text, -16777216);
            } else {
                if (n3 != -1) {
                    graphics.drawRegion(imgActions, 0, n3 * 18, 18, 18, n2 - Canvas.screenRect[0], Canvas.screenRect[1] + 9, 20, 0);
                    n2 += 20;
                }
                if (n2 + 12 * ((n = text.length()) + 1) > Canvas.hudRect[2]) {
                    n = (Canvas.hudRect[2] - n2) / 9 - 1;
                }
                graphics.drawString(text, n2 - Canvas.screenRect[0], 11, 0, n4, n);
            }
        }
        text.dispose();
    }

    public static final void drawImportantMessage(Graphics graphics, Text text, int n) {
        int[] nArray = Canvas.dialogRect;
        nArray[0] = Canvas.viewRect[0];
        nArray[1] = Canvas.viewRect[1];
        nArray[2] = Canvas.viewRect[2] - nArray[0] - 1;
        nArray[3] = 18;
        graphics.setColor(n);
        graphics.fillRect(nArray[0], nArray[1] - 30, nArray[2], nArray[3]);
        graphics.setColor(-1);
        graphics.drawRect(nArray[0], nArray[1] - 30, nArray[2], nArray[3]);
        text.dehyphenate();
        graphics.drawString(text, nArray[0] + 2, nArray[1] + 2 - 30, 4);
    }

    private static final void drawCenterMessage(Graphics graphics, Text text, int n) {
        int n2;
        int n3 = text.getStringWidth() + 8;
        if (n3 > Canvas.hudRect[2]) {
            n3 = Canvas.hudRect[2];
        }
        int n4 = -Canvas.screenRect[1] + 74;
        int n5 = -Canvas.screenRect[0] + Canvas.hudRect[2] / 2;
        int n6 = text.getNumLines();
        graphics.setColor(n);
        graphics.fillRect(n5 - n3 / 2, n4, n3 - 1, 16 * n6 + 3);
        graphics.setColor(-5592406);
        graphics.drawRect(n5 - n3 / 2, n4, n3 - 1, 16 * n6 + 3);
        int n7 = n4 + 3;
        int n8 = 0;
        Text text2 = Text.getSmallBuffer();
        while ((n2 = text.findFirstOf('|', n8)) >= 0) {
            text2.setLength(0);
            text.substring(text2, n8, n2);
            graphics.drawString(text2, n5, n7, 17, 0, n2 - n8);
            n7 += 16;
            n8 = n2 + 1;
        }
        text2.setLength(0);
        text.substring(text2, n8);
        graphics.drawString(text2, n5, n7, 17, 0, text.length() - n8);
        text2.dispose();
    }

    public static final void drawCinematicText(Graphics graphics) {
        int n = Canvas.SCR_CX;
        int n2 = 1;
        int n3 = imgPlayerFaces.getWidth();
        int[] nArray = Canvas.displayRect;
        int[] nArray2 = Canvas.cinRect;
        int[] nArray3 = Canvas.viewRect;
        graphics.eraseRgn(0, 0, nArray[2], nArray2[1] + nArray3[1]);
        graphics.eraseRgn(0, nArray2[1] + nArray2[3] + nArray3[1], nArray[2], Canvas.softKeyY - (nArray3[1] + nArray2[1] + nArray2[3]));
        int n4 = showCinPlayer ? Canvas.subtitleMaxChars - 5 : Canvas.subtitleMaxChars;
        n4 -= 2;
        Text text = Text.getLargeBuffer();
        if (cinTitleID != -1 && cinTitleTime > App.gameTime) {
            text.setLength(0);
            Text.composeText(cinTitleID, text);
            text.wrapText(n4, 1, '\n');
            graphics.drawString(text, n, 1, 1);
        }
        if (subTitleID != -1 && subTitleTime > App.gameTime) {
            int n5 = Canvas.viewRect[1] + Canvas.cinRect[1] + Canvas.cinRect[3];
            n5 += Canvas.screenRect[3] - n5 - 32 >> 1;
            text.setLength(0);
            Text.composeText(subTitleID, text);
            if (showCinPlayer) {
                n = n3 + 5;
                n2 = 4;
                graphics.drawRegion(imgPlayerFaces, 0, 0, 32, 32, n - n3, n5);
                n += 5;
            }
            text.wrapText(n4, 2, '\n');
            graphics.drawString(text, n, n5, n2);
        }
        text.dispose();
        Hud.drawBubbleText(graphics);
    }

    private static final void drawEffects(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (Canvas.loadMapID >= 8 && TinyGL.fogRange < -1) {
            n3 = TinyGL.fogRange >> 4;
            n2 = (1024 + n3 << 8) / 1024;
            n = imgIce.getHeight();
            int n4 = 0;
            int n5 = -(n2 * n >> 8);
            graphics.setScreenSpace(Canvas.viewRect);
            graphics.drawImage(imgIce, n4, n5, 0, 0);
            graphics.drawImage(imgIce, n4 + Canvas.viewRect[2], n5, 24, 2);
            graphics.resetScreenSpace();
        }
        if (Canvas.state != 13) {
            Player.drawBuffs(graphics);
        }
        if (App.time < damageTime && damageCount > 0 && Combat.totalDamage > 0) {
            if ((1 << damageDir & 0xC1) != 0) {
                n3 = 0;
                n2 = Canvas.screenRect[3] - 37 - 25;
                n = 0;
                if (damageDir == 0) {
                    n3 = Canvas.screenRect[2] - 20;
                    n = 24;
                } else if (damageDir == 6) {
                    n3 = 20;
                    n = 12;
                } else {
                    n3 = Canvas.screenRect[2] >> 1;
                }
                graphics.drawRegion(imgAttArrow, 0, n, 12, 12, n3, n2, 3, 0);
            }
        } else if (damageTime != 0) {
            damageTime = 0;
            Hud.stopBrightenScreen();
            Hud.stopScreenSmack();
        }
        Hud.drawDamageVignette(graphics);
    }

    public static final void drawDamageVignette(Graphics graphics) {
        if (App.time < damageTime && damageCount >= 0 && Combat.totalDamage > 0) {
            int n = 0;
            switch (damageDir) {
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 15;
                    break;
                }
                case 4: {
                    n = 5;
                    break;
                }
                case 5: {
                    n = 4;
                    break;
                }
                case 0: 
                case 6: 
                case 7: {
                    n = 8;
                }
            }
            Image image = Player.isFamiliar ? imgDamageVignetteBot : imgDamageVignette;
            int n2 = image.getWidth();
            int[] nArray = Canvas.viewRect;
            if ((n & 1) != 0) {
                graphics.fillRegion(image, nArray[0], nArray[1], nArray[2], n2, 5);
            }
            if ((n & 2) != 0) {
                graphics.fillRegion(image, nArray[0] + (nArray[2] - n2), nArray[1], n2, nArray[3], 2);
            }
            if ((n & 4) != 0) {
                graphics.fillRegion(image, nArray[0], nArray[1], n2, nArray[3], 0);
            }
            if ((n & 8) != 0) {
                graphics.fillRegion(image, nArray[0], nArray[1] + (nArray[3] - n2), nArray[2], n2, 6);
            }
        }
    }

    public static void smackScreen(int n) {
        Render.vScrollVelocity = n * 90 / 100 + 0;
        Render.lastScrollChangeTime = App.time;
    }

    public static void stopScreenSmack() {
        Render.vScrollVelocity = 0;
        Render.screenVScrollOffset = 0;
        Render.lastScrollChangeTime = 0;
    }

    public static void brightenScreen(int n, int n2) {
        Render.maxLocalBrightness = n;
        Render.brightenPPMaxReachedTime = 0;
        Render.brightenPostProcessBeginTime = App.time;
        Render.brightenPostProcess = true;
        Render.brightnessInitialBoost = n2;
    }

    public static void stopBrightenScreen() {
        Render.maxLocalBrightness = 0;
        Render.brightenPPMaxReachedTime = 0;
        Render.brightenPostProcessBeginTime = 0;
        Render.brightenPostProcess = false;
        Render.brightnessInitialBoost = 0;
    }

    public static final void drawOverlay() {
        Image image = imgCockpitOverlay;
        int n = image.getWidth();
        int n2 = image.getHeight();
        int[] nArray = TinyGL.pixels;
        image.getRGB(cockpitOverlayRaw, 0, n, 0, 0, n, n2);
        int n3 = (TinyGL.screenWidth - n * 2) / 2;
        int n4 = (TinyGL.screenHeight - n2) / 2;
        if (n3 < 0 || n4 < 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = cockpitOverlayRaw[i * n + j];
                int n6 = (n5 & 0xFF000000) >> 24;
                if (n6 == 0) continue;
                nArray[(i + n4) * TinyGL.screenWidth + j + n3] = n5 |= 0xFF000000;
                nArray[(i + n4 + 1) * TinyGL.screenWidth - (j + n3 + 1)] = n5;
            }
        }
    }

    private static final void drawHudOverdraw(Graphics graphics) {
        if (Player.isFamiliar) {
            return;
        }
        int n = Canvas.hudRect[2];
        int n2 = Canvas.hudRect[0];
        int n3 = Canvas.hudRect[3] - 49;
        graphics.drawRegion(imgHudTest, 0, 0, n, 13, n2, n3, 20, 0);
    }

    private static final void drawBottomBar(Graphics graphics) {
        Text text;
        boolean bl = Player.noclip;
        if (Player.isFamiliar) {
            int n = 118;
            short s = Player.ammo[7];
            int n2 = s > 80 ? -10901241 : (s > 60 ? -6890994 : (s > 40 ? -1190141 : (s > 20 ? -29952 : -62464)));
            int n3 = Canvas.hudRect[3] - 37;
            graphics.fillRect(Canvas.hudRect[0], n3, Canvas.hudRect[2] - Canvas.hudRect[0], 37, -16777216);
            int n4 = Canvas.hudRect[3] - 18;
            int n5 = Canvas.SCR_CX - (15 + n) / 2;
            boolean bl2 = Player.familiarType == 3 || Player.familiarType == 4;
            int n6 = bl2 ? 17 : 0;
            graphics.drawRegion(imgSentryBotFace, 0, n6, 29, 17, n5, n4, 3, bl ? 3 : 0);
            int n7 = Canvas.SCR_CX + (imgSentryBotFace.getWidth() + 15 + n) / 2;
            int n8 = n4 - 7;
            int n9 = s * 20 / 100;
            if (n9 < 20 && s != 0) {
                ++n9;
            }
            int n10 = n7 - 4;
            for (int i = 0; i < n9; ++i) {
                graphics.fillRect(n10, n8, 4, 14, n2);
                n10 -= 6;
            }
            return;
        }
        if (Player.tookBotsInventory && !Player.botReturnedDueToMonster) {
            Hud.addMessage((short)0, (short)191, 3);
            Player.tookBotsInventory = false;
        } else if (Player.botReturnedDueToMonster) {
            text = Text.getSmallBuffer();
            text.setLength(0);
            Text.composeText((short)0, (short)218, text);
            Player.tookBotsInventory = false;
            Hud.addMessage(text, 3);
            text.dispose();
            Player.botReturnedDueToMonster = false;
        }
        text = Text.getSmallBuffer();
        int n = Canvas.hudRect[2];
        int n11 = 49;
        int n12 = Canvas.hudRect[0];
        int n13 = Canvas.hudRect[3] - n11;
        int n14 = 3 - Player.ce.getStat(0) * 3 / Player.ce.getStat(1);
        graphics.drawRegion(imgPlayerFaces, 0, n14 * 32, 32, 32, n12 + 118, n13 + 30, 3, bl ? 3 : 0);
        graphics.drawRegion(imgHudTest, 0, 13, n, n11 - 13, n12, n13 + 13, 20, 0);
        text.setLength(0);
        text.append(Player.ce.getStat(2));
        graphics.drawString(text, n12 + 21, n13 + 28, 17);
        text.setLength(0);
        byte by = Combat.weapons[Player.ce.weapon * 9 + 4];
        if (by == 0) {
            text.append("--");
        } else {
            text.append(Player.ammo[by]);
            if (by == 3 || by == 7) {
                text.append("%");
            } else if (by == 6) {
                text.append("/");
                text.append(5);
            }
        }
        Graphics.currentCharColor = by == 6 && Player.ammo[6] == 5 ? (short)7 : (short)3;
        graphics.drawString(text, n12 + 69, n13 + 27, 3);
        if (by > 5) {
            graphics.drawRegion(imgAmmoIcons, 0, 0, 16, 12, n12 + 71, n13 + 32, 17, 0);
        } else {
            graphics.drawRegion(imgAmmoIcons, 0, 12 * by, 16, 12, n12 + 71, n13 + 32, 17, 0);
        }
        if (Player.inventory[20] > 0) {
            graphics.drawRegion(imgBottomBarIcons, 0, 0, 13, 20, n12 + 151, n13 + 33, 3, 0);
        }
        if (Player.inventory[19] > 0) {
            graphics.drawRegion(imgBottomBarIcons, 0, 20, 13, 20, n12 + 175, n13 + 33, 3, 0);
        }
        text.setLength(0);
        text.append(Player.ce.getStat(0));
        graphics.drawString(text, n - 26, n13 + 28, 17);
        graphics.drawRegion(imgHudTest, 0, 0, n, 13, n12, n13, 20, 0);
        text.dispose();
    }

    public static final void draw(Graphics graphics) {
        drawTime = App.getUpTimeMs();
        if ((repaintFlags & 1) != 0) {
            repaintFlags &= 0xFFFFFFFE;
            if (Canvas.isZoomedIn) {
                int n;
                int n2;
                int[] nArray = Canvas.viewRect;
                int n3 = imgScope.getWidth();
                int n4 = imgScope.getHeight();
                int n5 = nArray[0] + (nArray[2] - 2 * n3) / 2;
                int n6 = nArray[1] + (nArray[3] - 2 * n4) / 2;
                graphics.drawRegion(imgScope, 0, 0, n3, n4, n5, n6, 0, 0);
                graphics.drawRegion(imgScope, 0, 0, n3, n4, n5 + (n3 - 1), n6, 0, 2);
                graphics.drawRegion(imgScope, 0, 0, n3, n4, n5 + (n3 - 1), n6 + (n4 - 1), 0, 3);
                graphics.drawRegion(imgScope, 0, 0, n3, n4, n5, n6 + (n4 - 1), 0, 6);
                graphics.setColor(0);
                int n7 = n5 - nArray[0];
                int n8 = nArray[0] + nArray[2] - (n5 + (2 * n3 - 1));
                graphics.fillRect(nArray[0], nArray[1], n7, nArray[3]);
                graphics.fillRect(n5 + (2 * n3 - 1), nArray[1], n8, nArray[3]);
                int n9 = n6 - nArray[1];
                int n10 = nArray[1] + nArray[3] - (n6 + (2 * n4 - 1));
                graphics.fillRect(nArray[0] + n7, nArray[1], nArray[2] - (n7 + n8), n9);
                graphics.fillRect(nArray[0] + n7, n6 + (2 * n4 - 1), nArray[2] - (n7 + n8), n10);
                int n11 = 16 - (Canvas.zoomTurn & 0xF);
                boolean bl = true;
                if (n11 == 1) {
                    if ((App.time & 0x100) == 0) {
                        graphics.setColor(0xFF0000);
                    } else {
                        graphics.setColor(0);
                    }
                    if (scopeState != 3) {
                        scopeState = 3;
                        sniperState = 0;
                    }
                } else if (n11 < 5) {
                    graphics.setColor(0xFF0000);
                    if (scopeState != 2) {
                        scopeState = 2;
                        sniperState = 0;
                    }
                } else if (n11 < 10) {
                    graphics.setColor(0xFFFF00);
                    if (scopeState != 1) {
                        scopeState = 1;
                    }
                } else {
                    bl = false;
                    if (scopeState != 0) {
                        scopeState = 0;
                    }
                }
                if (bl) {
                    int n12 = n5 + n3 - 1;
                    int n13 = n6 + 2;
                    graphics.fillRect(n12, n13, 1, 1);
                    n13 = n6 + 7;
                    graphics.fillRect(n12, n13, 1, 18);
                    n13 = n6 + 66;
                    graphics.fillRect(n12, n13, 1, 11);
                    n13 = n6 + 2 * n4 - 7 - 18 - 1;
                    graphics.fillRect(n12, n13, 1, 18);
                    n13 = n6 + 2 * n4 - 2 - 1 - 1;
                    graphics.fillRect(n12, n13, 1, 1);
                    n12 = n5 + 2;
                    n13 = n6 + n4 - 1;
                    graphics.fillRect(n12, n13, 1, 1);
                    n12 = n5 + 7;
                    graphics.fillRect(n12, n13, 18, 1);
                    n12 = n5 + 66;
                    graphics.fillRect(n12, n13, 11, 1);
                    n12 = n5 + 2 * n3 - 7 - 18 - 1;
                    graphics.fillRect(n12, n13, 18, 1);
                    n12 = n5 + 2 * n3 - 2 - 1 - 1;
                    graphics.fillRect(n12, n13, 1, 1);
                    int n14 = n5 + 60;
                    int n15 = n6 + 57;
                    int n16 = n5 + 57;
                    n2 = n6 + 60;
                    n12 = n14;
                    n13 = n15;
                    graphics.fillRect(n12, n13, 6, 1);
                    n12 = n16;
                    n13 = n2;
                    graphics.fillRect(n12, n13, 1, 6);
                    graphics.drawLine(n14, n15, n16, n2);
                    graphics.drawLine(n14, n15 + 1, n16 + 1, n2);
                    n14 = n5 + 2 * n3 - 60 - 1 - 1;
                    n15 = n6 + 57;
                    n16 = n5 + 2 * n3 - 57 - 1 - 1;
                    n2 = n6 + 60;
                    n12 = n14 - 6;
                    n13 = n15;
                    graphics.fillRect(n12, n13, 6, 1);
                    n12 = n16;
                    n13 = n2;
                    graphics.fillRect(n12, n13, 1, 6);
                    graphics.drawLine(n14, n15, n16, n2);
                    graphics.drawLine(n14, n15 + 1, n16 - 1, n2);
                    n14 = n5 + 60;
                    n15 = n6 + 2 * n4 - 57 - 1 - 1;
                    n16 = n5 + 57;
                    n2 = n6 + 2 * n4 - 60 - 1 - 1;
                    n12 = n14;
                    n13 = n15;
                    graphics.fillRect(n12, n13, 6, 1);
                    n12 = n16;
                    n13 = n2 - 6;
                    graphics.fillRect(n12, n13, 1, 6);
                    graphics.drawLine(n14, n15, n16, n2);
                    graphics.drawLine(n14, n15 - 1, n16 + 1, n2);
                    n14 = n5 + 2 * n3 - 60 - 1 - 1;
                    n15 = n6 + 2 * n4 - 57 - 1 - 1;
                    n16 = n5 + 2 * n3 - 57 - 1 - 1;
                    n2 = n6 + 2 * n4 - 60 - 1 - 1;
                    n12 = n14 - 6;
                    n13 = n15;
                    graphics.fillRect(n12, n13, 6, 1);
                    n12 = n16;
                    n13 = n2 - 6;
                    graphics.fillRect(n12, n13, 1, 6);
                    graphics.drawLine(n14, n15, n16, n2);
                    graphics.drawLine(n14, n15 - 1, n16 - 1, n2);
                }
                int[] nArray2 = Canvas.displayRect;
                int n17 = imgSniperControls.getWidth();
                n2 = Player.inTargetPractice ? 20 : 0;
                int n18 = Canvas.SCR_CX - (n17 >> 1);
                int n19 = nArray2[1] + 37 + 6 + n2;
                int n20 = 0;
                int n21 = 0;
                graphics.fillRegion(imgSniperControls, n20, n21, n17, 10, n18, n19, n17, 10);
                n19 = nArray2[1] + 37 + 4 + n2;
                n20 = 88;
                n21 = 10;
                graphics.fillRegion(imgSniperControls, n20, n21, 23, 19, n18 -= 27, n19, 23, 19);
                n18 = Canvas.SCR_CX + (n17 >> 1) + 4;
                graphics.fillRegion(imgSniperControls, n20 += 23, n21, 23, 19, n18, n19, 23, 19);
                n20 = n17 - 9;
                n18 = Canvas.SCR_CX - (n17 >> 1) + 6 - 4;
                int n22 = Canvas.zoomDestFOV;
                int n23 = Canvas.zoomFOV;
                if (zoomOkayToPop && n23 == n22) {
                    zoomSliderOfs = -1;
                }
                if ((n = zoomSliderOfs) == -1) {
                    int n24 = Canvas.zoomTime;
                    int n25 = n22 + (n23 - n22) * (n24 - App.time) / 360;
                    n = 120 - n25 << 8;
                    n = n * 36 * 4 / 40 >> 8;
                }
                n19 = nArray2[1] + 37 + 6 + n2;
                graphics.fillRegion(imgSniperControls, n20, n21, 9, 16, n18 += n, n19 -= 3, 9, 16);
                n20 = 0;
                n18 = Canvas.SCR_CX - 11 + 1;
                n19 = n6 - 22 - 2 + 1;
                graphics.fillRegion(imgSniperControls, n20, n21, 22, 22, n18, n19, 22, 22);
                n18 = n5 - 22 - 2;
                n19 = n6 + n4 - 11;
                graphics.fillRegion(imgSniperControls, n20 += 22, n21, 22, 22, n18, n19, 22, 22);
                n18 = n5 + (n3 << 1) - 1 + 2;
                graphics.fillRegion(imgSniperControls, n20 += 22, n21, 22, 22, n18, n19, 22, 22);
                n18 = Canvas.SCR_CX - 11;
                n19 = n6 + (n4 << 1) - 1 + 2;
                graphics.fillRegion(imgSniperControls, n20 += 22, n21, 22, 22, n18, n19, 22, 22);
            }
            Hud.drawEffects(graphics);
        }
        if ((repaintFlags & 2) != 0) {
            repaintFlags &= 0xFFFFFFFD;
            Canvas.checkFacingEntity();
            Hud.drawTopBar(graphics);
        }
        if ((repaintFlags & 0x20) != 0) {
            repaintFlags &= 0xFFFFFFDF;
            Hud.drawHudOverdraw(graphics);
        }
        if ((repaintFlags & 4) != 0) {
            repaintFlags &= 0xFFFFFFFB;
            Hud.drawBottomBar(graphics);
        }
        if (!isInWeaponSelect && weaponPressTime != 0 && App.time > weaponPressTime + 1000) {
            weaponPressTime = 0;
            isInWeaponSelect = true;
            releaseShouldCauseClose = false;
        }
        if (Canvas.isZoomedIn) {
            repaintFlags &= 0xFFFFFFBF;
        }
        if ((repaintFlags & 0x40) != 0) {
            repaintFlags &= 0xFFFFFFBF;
            Hud.drawDpad(graphics);
        }
        if ((repaintFlags & 8) != 0) {
            Hud.drawBubbleText(graphics);
        }
        if (cinTitleID != -1 && cinTitleTime < App.gameTime) {
            cinTitleID = -1;
            if (Canvas.state == 18) {
                repaintFlags |= 0x10;
            }
        }
        if (subTitleID != -1 && subTitleTime < App.gameTime) {
            subTitleID = -1;
            if (Canvas.state == 18) {
                repaintFlags |= 0x10;
            }
        }
        if ((repaintFlags & 0x10) != 0) {
            repaintFlags &= 0xFFFFFFEF;
            Hud.drawCinematicText(graphics);
        }
        drawTime = App.getUpTimeMs() - drawTime;
    }

    private static final void drawMonsterHealth(Graphics graphics) {
        Entity entity = Player.facingEntity;
        if (entity == null || entity.monster == null) {
            if (lastTarget != null) {
                Canvas.invalidateRect();
            }
            lastTarget = null;
            return;
        }
        if (entity.def.eType == 3 || entity.def.eType == 2 && (entity.info & 0x20000) == 0) {
            return;
        }
        int n = entity.monster.ce.getStat(1);
        int n2 = entity.monster.ce.getStat(0);
        if (entity != lastTarget) {
            if (lastTarget != null) {
                Canvas.invalidateRect();
            }
            lastTarget = entity;
            monsterDestHealth = monsterStartHealth = n2;
            monsterHealthChangeTime = 0;
        } else if (n2 != monsterDestHealth) {
            monsterStartHealth = monsterDestHealth;
            monsterDestHealth = n2;
            monsterHealthChangeTime = App.time;
        }
        if (monsterStartHealth > n) {
            monsterStartHealth = n;
        }
        if (App.time - monsterHealthChangeTime > 250) {
            monsterStartHealth = n2;
        } else {
            n2 = monsterStartHealth - (monsterStartHealth - monsterDestHealth) * (App.time - monsterHealthChangeTime) / 250;
        }
        int n3 = 25;
        int n4 = (n3 << 8) * ((n2 << 16) / (n << 8)) >> 8;
        n4 = n4 + 256 - 1 >> 8;
        if (n4 == 0 && n2 > 0) {
            n4 = 1;
        }
        int n5 = 6;
        if (entity.def.eSubType == 5 && entity.def.parm == 0) {
            n5 = 50;
        } else if (Canvas.isZoomedIn) {
            n5 += 20;
        }
        int n6 = 2 * (Canvas.screenRect[2] << 8) / 128 >> 8;
        if (entity.isBoss()) {
            ++n6;
        } else if ((n6 & 1) != 0) {
            ++n6;
        }
        int n7 = 2 + n6 * n3;
        int n8 = Canvas.SCR_CX - (n7 >> 1);
        graphics.setColor(-16777216);
        graphics.fillRect(n8, Canvas.viewRect[1] + n5, n7, n6 * 2 + 1);
        graphics.setColor(-5592406);
        graphics.drawRect(n8, Canvas.viewRect[1] + n5, n7, n6 * 2 + 1);
        if (n4 <= n3 / 3) {
            graphics.setColor(-65536);
        } else if (n3 - n4 <= n3 / 3) {
            graphics.setColor(-16711936);
        } else {
            graphics.setColor(-30720);
        }
        n8 += 2;
        for (int i = 0; i < n4; ++i) {
            graphics.fillRect(n8, Canvas.viewRect[1] + n5 + 2, n6 - 1, n6 * 2 - 2);
            n8 += n6;
        }
    }

    public static final void showSpeechBubble(int n, int n2) {
        if (bubbleText == null) {
            bubbleText = Text.getSmallBuffer();
        }
        Text.composeText(Canvas.loadMapStringID, (short)n, bubbleText);
        bubbleText.dehyphenate();
        bubbleTextTime = App.time + 1500;
        switch (n2) {
            case 0: {
                bubbleColor = -8388608;
                break;
            }
            case 1: {
                bubbleColor = -16766876;
                break;
            }
            case 2: {
                bubbleColor = -11577833;
                break;
            }
            case 3: {
                bubbleColor = -13760428;
                break;
            }
            case 4: {
                bubbleColor = -27136;
                break;
            }
            default: {
                bubbleColor = -8388608;
            }
        }
    }

    public static final void drawBubbleText(Graphics graphics) {
        int n;
        if (bubbleText == null) {
            repaintFlags &= 0xFFFFFFF7;
            return;
        }
        if (App.time >= bubbleTextTime) {
            bubbleTextTime = 0;
            bubbleText.dispose();
            bubbleText = null;
            repaintFlags &= 0xFFFFFFF7;
            return;
        }
        int n2 = Canvas.viewRect[1] + 1;
        int n3 = Canvas.SCR_CX + 5;
        int n4 = 0;
        int n5 = 6;
        switch (bubbleColor) {
            case -8388608: {
                n4 = 0;
                break;
            }
            case -16766876: {
                n4 = 10;
                break;
            }
            case -13760428: {
                n4 = 20;
                break;
            }
            case -11577833: {
                n4 = 30;
                n5 = 12;
                break;
            }
            case -27136: {
                n4 = 45;
                n5 = 12;
            }
        }
        if (Canvas.state == 18) {
            n2 = Canvas.cinRect[1] + 1;
        }
        if (Player.facingEntity != null && bubbleColor != -11577833) {
            n = Player.facingEntity.distFrom(Canvas.destX, Canvas.destY);
            n2 = n <= Combat.tileDistances[0] ? (n2 += 10) : (n2 += 20);
        }
        n = bubbleText.length() * 9 + 6;
        int n6 = 20;
        int n7 = Math.max(0, n + 2 - (Canvas.viewRect[2] - n3));
        n3 -= n7;
        if (bubbleColor == -11577833) {
            n2 = Canvas.screenRect[3] - (49 + n6 + 1);
        } else if (n3 + 15 < Canvas.SCR_CX) {
            n5 = 12;
        }
        graphics.setColor(bubbleColor);
        graphics.fillRect(n3, n2, n, n6);
        graphics.setColor(-1);
        graphics.drawLine(n3, n2, n3 + n, n2);
        graphics.drawLine(n3, n2, n3, n2 + n6);
        graphics.drawLine(n3 + n, n2, n3 + n, n2 + n6);
        graphics.drawLine(n3, n2 + n6, n3 + n, n2 + n6);
        graphics.drawString(bubbleText, n3 + 2, n2 + 3, 4);
        graphics.drawRegion(Canvas.imgUIImages, n4, n5, 10, 6, n3 + 5, n2 + n6);
    }

    public static void resetSoftkeys() {
        isLSKDown = false;
        isRSKDown = false;
        if (Canvas.softKeysAreAllowed()) {
            Canvas.repaintFlags |= 2;
        }
    }

    public static void drawDpad(Graphics graphics) {
        Image image = dpad;
        switch (dpadState) {
            case 1: {
                image = dpadUp;
                break;
            }
            case 2: {
                image = dpadRight;
                break;
            }
            case 3: {
                image = dpadDown;
                break;
            }
            case 4: {
                image = dpadLeft;
            }
        }
        int[] nArray = Canvas.displayRect;
        int n = image.getWidth();
        int n2 = image.getHeight();
        graphics.drawRegion(image, 0, 0, n, n2, dpadCenter[0] - (n >> 1), dpadCenter[1] - (n2 >> 1), 0, 0);
    }

    public static int checkDpadTouch(int n, int n2) {
        int n3 = dpadState;
        if (n < dpadCenter[0] - dpadExtent || n > dpadCenter[0] + dpadExtent || n2 < dpadCenter[1] - dpadExtent || n2 > dpadCenter[1] + dpadExtent) {
            dpadState = 0;
        } else if (Game.interpolatingMonsters || Canvas.blockInputTime != 0) {
            dpadState = 5;
        } else {
            int n4 = n - dpadCenter[0];
            int n5 = n2 - dpadCenter[1];
            dpadState = n5 < 0 ? (Canvas.isZoomedIn ? 1 : (n4 > 0 && n4 > -n5 ? 2 : (n4 < 0 && n4 < n5 ? 4 : 1))) : (Canvas.isZoomedIn ? 3 : (n4 > 0 && n4 > n5 ? 2 : (n4 < 0 && n4 < -n5 ? 4 : 3)));
        }
        if (dpadState != n3) {
            repaintFlags |= 0x40;
            Canvas.repaintFlags |= 0x10;
        }
        return dpadState;
    }

    public static void dpadMoveTouch(int n, int n2) {
        int[] nArray = Canvas.viewRect;
        int n3 = nArray[0] + dpadExtent;
        int n4 = nArray[0] + nArray[2] - dpadExtent;
        int n5 = nArray[1] + dpadExtent;
        int n6 = nArray[1] + nArray[3] - dpadExtent - 10;
        n = MenuSystem.clamp(n, n3, n4);
        n2 = MenuSystem.clamp(n2, n5, n6);
        Hud.dpadCenter[0] = n;
        Hud.dpadCenter[1] = n2;
    }

    public static int checkStrafeTouch(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        int n7 = 0;
        if (n5 > 0 && n5 > 50) {
            n7 = 2;
        } else if (n5 < 0 && n5 < -50) {
            n7 = 4;
        }
        if (n7 == 0) {
            if (n6 > 0 && n6 > 50) {
                n7 = 3;
            } else if (n6 < 0 && n6 < -50) {
                n7 = 1;
            }
        }
        return n7;
    }

    public static int checkSniperTouch(int n, int n2) {
        sniperState = Hud.findSniperState(n, n2, false);
        zoomOkayToPop = false;
        zoomBlockInput = sniperState == 5;
        int n3 = 0;
        if (zoomPendingNotches > 0) {
            n3 = 1;
        } else if (zoomPendingNotches < 0) {
            n3 = 3;
        }
        return n3;
    }

    public static int[] checkSniperDrag(int n, int n2, int n3, int n4) {
        Hud.dragRet[0] = 0;
        Hud.dragRet[1] = n;
        Hud.dragRet[2] = n2;
        int n5 = Hud.findSniperState(n3, n4, false);
        if (n == n3 && n2 == n4) {
            return dragRet;
        }
        if (sniperState == n5) {
            switch (sniperState) {
                case 0: 
                case 1: 
                case 5: 
                case 6: {
                    return dragRet;
                }
                case 2: {
                    int n6 = n3 - n;
                    int n7 = n4 - n2;
                    if (n6 > 0 && n6 > 10) {
                        Hud.dragRet[0] = 2;
                        Hud.dragRet[1] = n3;
                    } else if (n6 < 0 && n6 < -10) {
                        Hud.dragRet[0] = 4;
                        Hud.dragRet[0] = n3;
                    }
                    if (dragRet[0] != 0) {
                        return dragRet;
                    }
                    if (n7 > 0 && n7 > 10) {
                        Hud.dragRet[0] = 3;
                        Hud.dragRet[2] = n4;
                    } else if (n7 < 0 && n7 < -10) {
                        Hud.dragRet[0] = 1;
                        Hud.dragRet[2] = n4;
                    }
                    return dragRet;
                }
                case 4: {
                    int n8 = n3 - n;
                    if (zoomPendingNotches > 0) {
                        Hud.dragRet[0] = 1;
                    } else if (zoomPendingNotches < 0) {
                        Hud.dragRet[0] = 3;
                    }
                    return dragRet;
                }
            }
        } else {
            sniperState = 0;
        }
        return dragRet;
    }

    public static int checkSniperRelease(int n, int n2) {
        int n3 = Hud.findSniperState(n, n2, true);
        zoomOkayToPop = true;
        int n4 = 0;
        if (sniperState == n3) {
            switch (sniperState) {
                case 1: {
                    n4 = 1;
                    break;
                }
                case 5: {
                    if (n > Canvas.SCR_CX) {
                        n4 = 1;
                        break;
                    }
                    n4 = 3;
                    break;
                }
                case 2: {
                    if (Canvas.dragCausedStrafe) break;
                    int[] nArray = Canvas.viewRect;
                    int n5 = n - (nArray[0] + (nArray[2] >> 1));
                    int n6 = n2 - (nArray[1] + (nArray[3] >> 1));
                    if (n6 < 0) {
                        if (n5 > 0 && n5 > -n6) {
                            n4 = 2;
                            break;
                        }
                        if (n5 < 0 && n5 < n6) {
                            n4 = 4;
                            break;
                        }
                        n4 = 1;
                        break;
                    }
                    n4 = n5 > 0 && n5 > n6 ? 2 : (n5 < 0 && n5 < -n6 ? 4 : 3);
                }
            }
        }
        return n4;
    }

    public static int findSniperState(int n, int n2, boolean bl) {
        int n3;
        int[] nArray = Canvas.displayRect;
        int[] nArray2 = Canvas.viewRect;
        int n4 = imgSniperControls.getWidth();
        int n5 = imgScope.getWidth();
        int n6 = imgScope.getHeight();
        int n7 = nArray2[0] + (nArray2[2] >> 1);
        int n8 = nArray2[1] + (nArray2[3] >> 1);
        int n9 = Math.abs(n7 - n);
        int n10 = Math.abs(n8 - n2);
        int n11 = n3 = Player.inTargetPractice ? 20 : 0;
        if (n2 < nArray[1] + 37 + n3) {
            return 0;
        }
        if (n2 > nArray2[1] + nArray2[3]) {
            return 0;
        }
        if (n2 < nArray[1] + 37 + 6 + 19 + n3) {
            if (n9 < n4 >> 1) {
                int n12;
                if (bl) {
                    return 0;
                }
                int n13 = Canvas.SCR_CX - (n4 >> 1) + 6 - 4;
                int n14 = zoomCachedNotch;
                if (n14 == -1) {
                    n14 = 4 * (120 - Canvas.zoomDestFOV) / 40;
                }
                if (n14 != (n12 = ((zoomSliderOfs = MenuSystem.clamp(n - n13, 0, 144)) + 18) / 36)) {
                    zoomPendingNotches = n12 - n14;
                    zoomCachedNotch = MenuSystem.clamp(zoomCachedNotch + zoomPendingNotches, 0, 4);
                }
                return 4;
            }
            if (n9 < (n4 >> 1) + 4 + 23) {
                zoomCachedNotch = -1;
                return 5;
            }
            return 2;
        }
        int n15 = (n7 - n) * (n7 - n);
        int n16 = (n8 - n2) * (n8 - n2);
        if (n15 + n16 <= n5 * n5) {
            return 1;
        }
        return 2;
    }

    public static boolean sniperShouldZoom() {
        return sniperState == 4 || sniperState == 5;
    }

    public static boolean sniperShouldFire() {
        return sniperState == 1;
    }

    public static int checkHudTouch(int n, int n2) {
        int n3 = 0;
        int n4 = Canvas.hudRect[1] + Canvas.hudRect[3];
        if (Game.interpolatingMonsters) {
            return 6;
        }
        if (n2 < n4 - 49 || n2 > n4) {
            return n3;
        }
        if (Player.isFamiliar) {
            n3 = 3;
            return n3;
        }
        int n5 = (Canvas.hudRect[0] + Canvas.hudRect[2]) / 5;
        if (n > 4 * n5) {
            n3 = 5;
        } else if (n > 3 * n5) {
            n3 = 4;
        } else if (n > 2 * n5) {
            n3 = 3;
        } else if (n > n5) {
            if (!isInWeaponSelect) {
                n3 = 2;
            }
        } else {
            n3 = 1;
        }
        if (!(hudEventsAvailable || n3 != 5 && n3 != 4 && n3 != 1)) {
            n3 = 6;
        }
        return n3;
    }

    public static int checkSoftKeyTouch(int n, int n2) {
        int n3 = 0;
        if (n2 < Canvas.softKeyY) {
            return n3;
        }
        if (n > Canvas.displayRect[0] + Canvas.displayRect[2] >> 1) {
            if (Canvas.softKeyRightID != -1) {
                n3 = 2;
            }
        } else if (Canvas.softKeyLeftID != -1) {
            n3 = 4;
        }
        return n3;
    }

    public static void checkWeaponSelect(int n, int n2) {
        int[] nArray = Canvas.viewRect;
        if (n < nArray[0] || n > nArray[0] + nArray[2] || n2 < nArray[1] || n2 > nArray[1] + nArray[3]) {
            if (releaseShouldCauseClose) {
                isInWeaponSelect = false;
            }
            releaseShouldCauseClose = true;
            return;
        }
        int n3 = Render.screenWidth - 222 + 10 >> 1;
        int n4 = Render.screenHeight - 50;
        int n5 = Player.weapons & ~Player.disabledWeapons;
        int n6 = 0;
        for (int i = 0; i < 14; ++i) {
            if ((n5 & 1 << i) == 0) continue;
            int n7 = n3 + n6 % 3 * 74;
            int n8 = n4 - n6 / 3 * 60;
            if (n > n7 && n < n7 + 64 && n2 > n8 && n2 < n8 + 50) {
                Player.selectWeapon(i);
                isInWeaponSelect = false;
                return;
            }
            ++n6;
        }
    }

    static {
        cockpitOverlayRaw = null;
        messages = new Text[5];
        messageFlags = new int[5];
        subTitleID = -1;
        subTitleTime = 0;
        cinTitleID = -1;
        cinTitleTime = 0;
        bubbleText = null;
        bubbleTextTime = 0;
        bubbleColor = 0;
        showCinPlayer = false;
        dragRet = new int[3];
        dpadCenter = new int[2];
    }
}

