/*
 * Decompiled with CFR 0.152.
 */
public class CheckersList {
    private CheckersListNode head;
    private CheckersListNode tail;
    private int count = 0;

    public void push_front(Object object) {
        CheckersListNode checkersListNode = new CheckersListNode(object, null, this.head);
        if (this.head != null) {
            this.head.prev = checkersListNode;
        } else {
            this.tail = checkersListNode;
        }
        this.head = checkersListNode;
        ++this.count;
    }

    public void push_back(Object object) {
        CheckersListNode checkersListNode = new CheckersListNode(object, this.tail, null);
        if (this.tail != null) {
            this.tail.next = checkersListNode;
        } else {
            this.head = checkersListNode;
        }
        this.tail = checkersListNode;
        ++this.count;
    }

    public Object pop_front() {
        if (this.head == null) {
            return null;
        }
        CheckersListNode checkersListNode = this.head;
        this.head = this.head.next;
        if (this.head != null) {
            this.head.prev = null;
        } else {
            this.tail = null;
        }
        --this.count;
        return checkersListNode.value;
    }

    public Object pop_back() {
        if (this.tail == null) {
            return null;
        }
        CheckersListNode checkersListNode = this.tail;
        this.tail = this.tail.prev;
        if (this.tail != null) {
            this.tail.next = null;
        } else {
            this.head = null;
        }
        --this.count;
        return checkersListNode.value;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public int length() {
        return this.count;
    }

    public void append(CheckersList checkersList) {
        CheckersListNode checkersListNode = checkersList.head;
        while (checkersListNode != null) {
            this.push_back(checkersListNode.value);
            checkersListNode = checkersListNode.next;
        }
    }

    public void clear() {
        this.tail = null;
        this.head = null;
    }

    public Object peek_head() {
        if (this.head != null) {
            return this.head.value;
        }
        return null;
    }

    public Object peek_tail() {
        if (this.tail != null) {
            return this.tail.value;
        }
        return null;
    }

    public boolean has(Object object) {
        CheckersListNode checkersListNode = this.head;
        while (checkersListNode != null && !checkersListNode.value.equals(object)) {
            checkersListNode = checkersListNode.next;
        }
        return checkersListNode != null;
    }

    public Object clone() {
        CheckersList checkersList = new CheckersList();
        CheckersListNode checkersListNode = this.head;
        while (checkersListNode != null) {
            checkersList.push_back(checkersListNode.value);
            checkersListNode = checkersListNode.next;
        }
        return checkersList;
    }

    public String toString() {
        String string = "[";
        CheckersListNode checkersListNode = this.head;
        while (checkersListNode != null) {
            string = string + checkersListNode.value.toString();
            checkersListNode = checkersListNode.next;
            if (checkersListNode == null) continue;
            string = string + ", ";
        }
        string = string + "]";
        return string;
    }

    public Object goToNext() {
        if (this.head != null) {
            if (this.head.next != null) {
                CheckersListNode checkersListNode = this.head;
                this.head = this.head.next;
                this.head.prev = null;
                checkersListNode.next = null;
                checkersListNode.prev = this.tail;
                this.tail.next = checkersListNode;
                this.tail = checkersListNode;
            }
            return this.head.value;
        }
        return null;
    }

    public Object goToPrew() {
        if (this.head != null) {
            if (this.head.next != null) {
                CheckersListNode checkersListNode = this.tail;
                this.tail = this.tail.prev;
                this.tail.next = null;
                checkersListNode.prev = null;
                checkersListNode.next = this.head;
                this.head.prev = checkersListNode;
                this.head = checkersListNode;
            }
            return this.head.value;
        }
        return null;
    }

    public CheckersEnum elements() {
        return new CheckersEnum(this.head);
    }
}

