/*
 * Decompiled with CFR 0.152.
 */
public class CheckersComputer {
    public static final boolean DBG_AI1 = false;
    public static final boolean DBG_AI2 = false;
    private CheckersBoard currentBoard;
    private int color;
    private static int maxDepth = 2;
    public static final int DIF_EASY = 1;
    public static final int DIF_MEDIUM = 2;
    public static final int DIF_HARD = 3;
    private static final int[] tableWeight = new int[]{4, 4, 4, 4, 4, 3, 3, 3, 3, 2, 2, 4, 4, 2, 1, 3, 3, 1, 2, 4, 4, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4};
    private static final int[] tableWeightKing = new int[]{3, 3, 3, 2, 3, 4, 4, 4, 3, 3, 3, 3, 3, 5, 5, 4, 4, 5, 5, 3, 3, 3, 3, 3, 4, 4, 4, 3, 2, 3, 3, 3};

    public static final void println(String string) {
    }

    public CheckersComputer(CheckersBoard checkersBoard, byte by) {
        this.currentBoard = checkersBoard;
        this.color = by;
    }

    public void setDifficulty(int n) {
        maxDepth = n;
    }

    public CheckersList play() {
        CheckersList checkersList = this.minimax(this.currentBoard);
        if (!checkersList.isEmpty()) {
            this.currentBoard.move(checkersList);
            return checkersList;
        }
        return null;
    }

    public void setBoard(CheckersBoard checkersBoard) {
        this.currentBoard = checkersBoard;
    }

    private boolean mayPlay(CheckersList checkersList) {
        return !checkersList.isEmpty() && !((CheckersList)checkersList.peek_head()).isEmpty();
    }

    private CheckersList minimax(CheckersBoard checkersBoard) {
        CheckersList checkersList = null;
        int n = Integer.MIN_VALUE;
        CheckersList checkersList2 = checkersBoard.legalMoves();
        while (this.mayPlay(checkersList2)) {
            CheckersList checkersList3 = (CheckersList)checkersList2.pop_front();
            CheckersBoard checkersBoard2 = (CheckersBoard)checkersBoard.clone();
            checkersBoard2.move(checkersList3);
            int n2 = this.minMove(checkersBoard2, 1, n, Integer.MAX_VALUE);
            if (n2 <= n) continue;
            n = n2;
            checkersList = checkersList3;
        }
        return checkersList;
    }

    private int maxMove(CheckersBoard checkersBoard, int n, int n2, int n3) {
        if (this.cutOffTest(checkersBoard, n)) {
            return this.eval(checkersBoard);
        }
        CheckersList checkersList = checkersBoard.legalMoves();
        while (this.mayPlay(checkersList)) {
            CheckersList checkersList2 = (CheckersList)checkersList.pop_front();
            CheckersBoard checkersBoard2 = (CheckersBoard)checkersBoard.clone();
            checkersBoard2.move(checkersList2);
            int n4 = this.minMove(checkersBoard2, n + 1, n2, n3);
            if (n4 > n2) {
                n2 = n4;
            }
            if (n2 <= n3) continue;
            return n3;
        }
        return n2;
    }

    private int minMove(CheckersBoard checkersBoard, int n, int n2, int n3) {
        if (this.cutOffTest(checkersBoard, n)) {
            return this.eval(checkersBoard);
        }
        CheckersList checkersList = checkersBoard.legalMoves();
        while (this.mayPlay(checkersList)) {
            CheckersList checkersList2 = (CheckersList)checkersList.pop_front();
            CheckersBoard checkersBoard2 = (CheckersBoard)checkersBoard.clone();
            checkersBoard2.move(checkersList2);
            int n4 = this.maxMove(checkersBoard2, n + 1, n2, n3);
            if (n4 < n3) {
                n3 = n4;
            }
            if (n3 >= n2) continue;
            return n2;
        }
        return n3;
    }

    private int eval(CheckersBoard checkersBoard) {
        int n;
        int n2;
        byte by;
        if (this.color == 2) {
            by = 3;
            n2 = 4;
            n = 5;
        } else {
            by = 5;
            n2 = 2;
            n = 3;
        }
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 32; ++i) {
            byte by2 = checkersBoard.getPiece(i);
            if (by2 == 0) continue;
            if (by2 == this.color || by2 == by) {
                n3 += this.calculateValue(by2, i);
                continue;
            }
            n4 += this.calculateValue(by2, i);
        }
        return n3 - n4;
    }

    private int calculateValue(int n, int n2) {
        int n3;
        if (n == 2) {
            n3 = n2 >= 4 && n2 <= 7 ? 7 : 5;
        } else if (n != 4) {
            n3 = n2 >= 24 && n2 <= 27 ? 7 : 5;
        } else {
            int n4 = 6;
            return n4 * tableWeightKing[n2];
        }
        return n3 * tableWeight[n2];
    }

    private boolean cutOffTest(CheckersBoard checkersBoard, int n) {
        return n > maxDepth || checkersBoard.hasEnded();
    }
}

