/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class Sound_MM_API
extends PlatformSound
implements PlayerListener {
    private static final String[] CONTENT_TYPES = new String[]{"midi", "x-wav", "amr", "x-ogg", "mpeg", "aac"};
    private static final int DELAY_TIME = 150;
    private static final int STATE_STOP = 0;
    private static final int STATE_PLAY = 1;
    private int format;
    private byte[] soundData;
    private String resourceName;
    private int state;
    private int volume;
    private int loopCount;
    private Player player;

    public Sound_MM_API(int n, byte[] byArray) {
        this.format = n;
        this.soundData = byArray;
        PlatformSound.registerSound(this);
    }

    public Sound_MM_API(int n, String string) {
        this.format = n;
        this.resourceName = string;
        PlatformSound.registerSound(this);
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
    }

    public void setVolume(int n) {
        if (this.volume != n) {
            this.volume = n;
            if (this.player != null) {
                this.applyVolume();
            }
        }
    }

    public void play() {
        boolean bl;
        int n = 0;
        do {
            this.realize();
            if (this.player == null) {
                return;
            }
            bl = false;
            try {
                this.player.start();
            }
            catch (Exception exception) {
                bl = true;
            }
            if (!bl) continue;
            ++n;
            this.stop();
            Platform.sleep(2000);
        } while (bl && n < 3);
        if (bl) {
            return;
        }
        this.state = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realize() {
        block16: {
            if (this.player != null) {
                try {
                    this.player.prefetch();
                    this.applyVolume();
                }
                catch (Exception exception) {
                    this.player = null;
                }
                return;
            }
            InputStream inputStream = this.soundData != null ? new ByteArrayInputStream(this.soundData, 0, this.soundData.length) : this.getClass().getResourceAsStream(this.resourceName);
            try {
                String string = "audio/" + CONTENT_TYPES[this.format];
                this.player = Manager.createPlayer((InputStream)inputStream, (String)string);
                this.player.realize();
                this.player.prefetch();
                this.player.setLoopCount(this.loopCount);
                this.applyVolume();
            }
            catch (Exception exception) {
                if (this.player == null) break block16;
                try {
                    this.player.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this.player = null;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void stop() {
        this.state = 0;
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.player.deallocate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.player.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.player = null;
    }

    private void applyVolume() {
        VolumeControl volumeControl = (VolumeControl)this.player.getControl("VolumeControl");
        if (volumeControl != null) {
            volumeControl.setLevel(this.volume);
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
    }
}

