/*
 * Decompiled with CFR 0.152.
 */
public class Sound {
    private static final int[] FORMATS = new int[]{0, 1, 4, -1, -1, -1, -1, 2, -1};
    private static int volumeValue = 100;
    static boolean enableSound = true;
    static int eventBase;
    private static int[] eventMap;
    private static PlatformSound[] soundPlayer;
    private static int lastSound;
    public static boolean IS_Z750I;
    public static byte[] VOLUME_LEVELS;

    public Sound() {
        String string = System.getProperty("microedition.platform");
        if (string == null) {
            return;
        }
        IS_Z750I = string.toUpperCase().startsWith("SONYERICSSONZ750I");
        if (IS_Z750I) {
            VOLUME_LEVELS = new byte[]{55, 75, 99};
        }
    }

    public static void setVolume(int n, int n2) {
    }

    public static void setVolume(int n) {
        PlatformSound platformSound;
        if (n == 0) {
            if (enableSound) {
                enableSound = false;
                Sound.stopSound();
            }
            return;
        }
        enableSound = true;
        volumeValue = VOLUME_LEVELS[n - 1];
        if (lastSound >= 0 && (platformSound = soundPlayer[lastSound]) != null) {
            platformSound.setVolume(volumeValue);
        }
    }

    public static boolean hasSound(int n) {
        int n2 = eventMap[n += eventBase];
        return soundPlayer[n2] != null;
    }

    public static void playSound(int n) {
        if (volumeValue == 0) {
            return;
        }
        if (GMain.getOption(1) == 0) {
            return;
        }
        int n2 = eventMap[n += eventBase];
        PlatformSound platformSound = soundPlayer[n2];
        if (platformSound == null) {
            return;
        }
        if (lastSound >= 0 && n2 != lastSound) {
            Sound.stopSound();
        }
        platformSound.setVolume(volumeValue);
        platformSound.play();
        lastSound = n2;
    }

    public static void stopSound() {
        if (lastSound >= 0) {
            PlatformSound platformSound = soundPlayer[lastSound];
            if (platformSound != null) {
                platformSound.stop();
            }
            lastSound = -1;
        }
    }

    public static void readSnd(PlatformResource platformResource) {
        eventMap = new int[2];
        int n = platformResource.readShort();
        soundPlayer = new PlatformSound[n + 1];
        for (int i = 1; i <= n; ++i) {
            PlatformSound platformSound;
            byte by = platformResource.readByte();
            short s = 0;
            int n2 = 0;
            byte[] byArray = null;
            switch (by) {
                case 1: {
                    n2 = 1;
                    s = platformResource.readShort();
                    byArray = new byte[s];
                    platformResource.readFully(byArray);
                    break;
                }
                case 2: {
                    n2 = 0;
                    s = platformResource.readShort();
                    byArray = new byte[s];
                    platformResource.readFully(byArray);
                    break;
                }
                case 4: {
                    s = platformResource.readShort();
                    byArray = new byte[s];
                    platformResource.readFully(byArray);
                    n2 = FORMATS[platformResource.readUnsignedByte()];
                }
            }
            Sound.soundPlayer[i] = platformSound = Platform.createSound(n2, byArray);
            int n3 = platformResource.readShort();
            while (n3-- > 0) {
                byte by2 = platformResource.readByte();
                Sound.eventMap[by2] = i;
                int n4 = by2 <= 1 ? -1 : 1;
                platformSound.setLoopCount(n4);
            }
            platformResource.readShort();
        }
    }

    static {
        lastSound = -1;
        IS_Z750I = false;
        VOLUME_LEVELS = new byte[]{33, 66, 100};
    }
}

