/*
 * Decompiled with CFR 0.152.
 */
public class Reversi
extends BoardGame {
    public static final int BOX_N_PILLAR = 8;
    public static final int BOX_N_LINE = 8;
    public static final int PLAYER_C_NOT = 0;
    public static final int PLAYER_C_ONE = 1;
    public static final int PLAYER_C_AI1 = 3;
    private byte[] player_color;
    public static final int UI_MAX_RATE = 99999;
    public static final int BOX_ONE_W = 24;
    public static final int BOX_ONE_H = 24;
    public static final int STONE_WH = 16;
    private boolean bStonesFromXML = false;
    private byte[] stonesXml;
    private boolean bFirstPlayerXML = false;
    private byte firstPlayerXml;
    public static final int ST_ANIM_MOVE = 6;
    public static final int ST_ANIM_TURN_P1_1 = 7;
    public static final int ST_ANIM_TURN_P1_2 = 8;
    public static final int ST_ANIM_TURN_P2_1 = 9;
    public static final int ST_ANIM_TURN_P2_2 = 10;
    public static final int ST_ANIM_PUTDOWN = 16;
    public static final int ST_DEADLOCK = 17;
    public static final int ST_DELUX_PUTBOMB = 20;
    public static final int ST_BOMBPUTEFEKT = 21;
    private final int box_top;
    private final int box_left;
    private int box_cursor = -1;
    private byte[] stones;
    private byte[] turnOffEfketsIndex;
    public static final int[] DIRECTION = new int[]{-1, -1, 0, -1, 1, -1, -1, 0, 1, 0, -1, 1, 0, 1, 1, 1};
    private Entity playedStone;
    public static final int STONE_MOVEFRAME_P_ONE_BOX = 4;
    private int stoneAnimFrame;
    public static final int STONE_PUTDOWN_FRAMES = 3;
    public static final int STONE_KILL_FRAMES = 9;
    public static final int STONE_TURNFRAME_P_HALFANIM = 3;
    private int efektsBufOff;
    private Entity[] efekts;
    private int playedStoneX;
    private int playedStoneY;
    private int p1_stones_ob;
    private int p2_stones_ob;
    private OthelloBoard board;
    private OthelloAI_New othello;
    private byte[][] POWERUP_DEFAREA;
    public static final byte[] DEFAREA_LO = new byte[]{2, 5, 10, 11, 12, 13, 16, 17, 18, 19, 20, 21, 22, 23, 25, 26, 29, 30, 33, 34, 37, 38, 40, 41, 42, 43, 44, 45, 46, 47, 50, 51, 52, 53, 58, 61};
    public static final byte[] aiBombPlace = new byte[]{0, 2, 3, 4, 5, 7, 16, 23, 24, 31, 32, 39, 40, 47, 56, 58, 59, 60, 61, 63};
    public static final byte[] aiBombPrice = new byte[]{10, 4, 6, 6, 4, 10, 4, 4, 6, 6, 6, 6, 4, 4, 10, 4, 6, 6, 4, 10};

    public Reversi(int n, int n2, Game game) {
        super(n, n2, game, 0);
        this.instance = this;
        int n3 = Main.SOFT_LIST_H;
        this.box_top = (this.height - 192 >> 1) + 12 - (n3 >> 1);
        this.box_left = (this.width - 192 >> 1) + 12;
        this.createPowerupDefarea();
    }

    public void createPowerupDefarea() {
        this.POWERUP_DEFAREA = new byte[8][];
        this.POWERUP_DEFAREA[0] = new byte[]{1, 8, 9};
        this.POWERUP_DEFAREA[1] = new byte[]{3, 4};
        this.POWERUP_DEFAREA[2] = new byte[]{6, 14, 15};
        this.POWERUP_DEFAREA[3] = new byte[]{24, 32};
        this.POWERUP_DEFAREA[4] = new byte[]{31, 39};
        this.POWERUP_DEFAREA[5] = new byte[]{48, 49, 57};
        this.POWERUP_DEFAREA[6] = new byte[]{59, 60};
        this.POWERUP_DEFAREA[7] = new byte[]{54, 55, 62};
    }

    public void load(PlatformResource platformResource) {
        this.bLoading = true;
        this.board_x_off = 0;
        this.board_y_off = 0;
        this.gameStates = new byte[2];
        this.gameStates[0] = platformResource.readByte();
        this.gameStates[1] = platformResource.readByte();
        if (this.gameStates[0] == 0 || this.gameStates[1] == 0) {
            this.gameStates = Game.PLAYERS;
        } else {
            Game.setPlayers(this.gameStates[0], this.gameStates[1]);
        }
        int n = platformResource.readShort();
        this.setDiff(Main.getCurrentProfileDifficulty());
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        this.scriptMoves = null;
        this.initMovesLeft = (byte)-1;
        this.tutorialPointer = (byte)-1;
        this.tmpSprite1ID = -1;
        this.tmpSprite2ID = -1;
        this.gameEndMsg = null;
        this.puzzleWinScore = -1;
        block18: for (int i = 0; i < n; ++i) {
            byte by = platformResource.readByte();
            switch (by) {
                case 1: {
                    byte by2 = platformResource.readByte();
                    if (by2 == 3) {
                        by2 = (byte)Main.getCampaignLevelDifficulty();
                    }
                    this.setDiff(by2);
                    continue block18;
                }
                case 2: {
                    int n4;
                    short s = platformResource.readShort();
                    this.stonesXml = new byte[s];
                    for (n4 = 0; n4 < s; ++n4) {
                        this.stonesXml[n4] = platformResource.readByte();
                    }
                    this.bStonesFromXML = true;
                    continue block18;
                }
                case 3: {
                    this.firstPlayerXml = platformResource.readByte();
                    this.bFirstPlayerXML = true;
                    continue block18;
                }
                case 4: {
                    this.board_x_off = platformResource.readByte();
                    continue block18;
                }
                case 5: {
                    this.board_y_off = platformResource.readByte();
                    continue block18;
                }
                case 6: {
                    n2 = platformResource.readByte();
                    continue block18;
                }
                case 7: {
                    n3 = platformResource.readByte();
                    continue block18;
                }
                case 8: {
                    bl = platformResource.readByte() == 1;
                    continue block18;
                }
                case 9: {
                    bl2 = platformResource.readByte() == 1;
                    continue block18;
                }
                case 10: {
                    int n5;
                    int n4 = platformResource.readShort();
                    this.gameMsg = new byte[n4];
                    for (n5 = 0; n5 < n4; ++n5) {
                        this.gameMsg[n5] = platformResource.readByte();
                    }
                    continue block18;
                }
                case 11: {
                    this.initMovesLeft = platformResource.readByte();
                    continue block18;
                }
                case 12: {
                    int n6;
                    int n5 = platformResource.readShort();
                    this.scriptMoves = new byte[n5];
                    for (n6 = 0; n6 < this.scriptMoves.length; ++n6) {
                        this.scriptMoves[n6] = platformResource.readByte();
                    }
                    if (n5 <= 0) continue block18;
                    this.scriptMovesPointer = 0;
                    continue block18;
                }
                case 13: {
                    this.tmpSprite1ID = platformResource.readByte();
                    continue block18;
                }
                case 14: {
                    this.tmpSprite2ID = platformResource.readByte();
                    continue block18;
                }
                case 15: {
                    int n6 = platformResource.readShort();
                    this.gameEndMsg = new byte[n6];
                    for (int j = 0; j < n6; ++j) {
                        this.gameEndMsg[j] = platformResource.readByte();
                    }
                    continue block18;
                }
                case 16: {
                    this.puzzleWinScore = platformResource.readShort();
                }
            }
        }
        this.player_one = n2 >= 0 ? new Entity(n2) : new Entity(Main.getCurrentProfileStone(0));
        this.player_two = n3 >= 0 ? new Entity(n3) : new Entity(Main.getCurrentProfileStone(1));
        this.player_two.setColorVariant(1);
        this.loadEfekts(platformResource);
        this.loadDeluxeElements(platformResource);
        this.loadTutorial(platformResource);
        platformResource.close();
        this.loadDeafults(bl, bl2);
        this.initGame();
        this.bLoading = false;
    }

    public void setDiff(int n) {
        super.setDiff(n);
        if (this.othello != null) {
            this.othello.setDifficulty(this.ai_difficulty);
        }
    }

    public void initGame() {
        int n;
        this.player_color = new byte[2];
        String string = "p one";
        String string2 = "p two";
        int n2 = -1;
        int n3 = -1;
        switch (this.gameStates[0]) {
            case 1: {
                this.player_color[0] = 1;
                string = Main.getCurrentProfileName();
                if (string != null) break;
                string = "p one";
                break;
            }
            case 2: {
                this.player_color[0] = 3;
                break;
            }
            case 3: {
                this.player_color[0] = 3;
                string = null;
                break;
            }
            case 4: {
                this.player_color[0] = 3;
            }
        }
        switch (this.gameStates[1]) {
            case 1: {
                this.player_color[1] = 1;
                string2 = Main.getCurrentProfileName();
                if (string2 != null) break;
                string2 = "p two";
                break;
            }
            case 2: {
                this.player_color[1] = 3;
                break;
            }
            case 3: {
                this.player_color[1] = 3;
                string2 = null;
                break;
            }
            case 4: {
                this.player_color[1] = 3;
            }
        }
        this.initInternal(n2, n3);
        this.setName(string, string2, n2, n3);
        this.player_one_table = new Entity(this.player_one, 0);
        this.player_two_table = new Entity(this.player_two, 0);
        this.efekts = new Entity[64];
        for (n = 0; n < this.efekts.length >> 1; ++n) {
            this.efekts[n] = new Entity(this.player_one, 3);
            this.efekts[n].setVisible(false);
        }
        for (n = this.efekts.length >> 1; n < this.efekts.length; ++n) {
            this.efekts[n] = new Entity(this.player_two, 4);
            this.efekts[n].setVisible(false);
        }
        this.efektsBufOff = 0;
        this.stones = new byte[64];
        this.backup = new int[3][64];
        this.backupLast = 0;
        this.turnOffEfketsIndex = new byte[this.stones.length];
        this.board = new OthelloBoard(2, this.player_color[0], this.player_color[1]);
        if (this.player_color[0] == 1) {
            this.othello = new OthelloAI_New(this.player_color[0], this.player_color[1]);
            this.othello.setDifficulty(0);
        } else {
            this.othello = new OthelloAI_New(this.player_color[1], this.player_color[0]);
            this.othello.setDifficulty(0);
        }
        n = GMain.getImageWidth(6);
        int n4 = GMain.getImageHeight(6);
        this.board_x = this.box_left - 12 - (n - 192 >> 1) + this.board_x_off;
        this.board_y = this.box_top - 12 - (n4 - 192 >> 1) + this.board_y_off;
        int n5 = GMain.getImageWidth(9);
        int n6 = GMain.getImageHeight(9);
        int n7 = Main.SOFT_LIST_H;
        this.ui_bignum_xoff = GMain.getImageWidth(14) / 10;
        this.ui_bignum_yoff = GMain.getImageHeight(14);
        this.ui_top_c = (this.height >> 1) - (n6 >> 1);
        this.ui_down_c = (this.height >> 1) + (n6 >> 1);
        this.ui_lft = this.board_x >> 1;
        this.ui_rght = this.width - this.ui_lft;
        this.initCheatList();
        this.reset();
        this.gameStateCurrent = (byte)101;
    }

    public void reset() {
        int n;
        int n2;
        super.reset();
        if (this.bStonesFromXML) {
            this.p1_stones_ob = 0;
            this.p2_stones_ob = 0;
            n2 = this.player_color[0];
            for (n = 0; n < this.stones.length; ++n) {
                this.stones[n] = this.stonesXml[n];
                if (this.stones[n] == 0) continue;
                if (this.stones[n] == n2) {
                    ++this.p1_stones_ob;
                    continue;
                }
                ++this.p2_stones_ob;
            }
        } else {
            for (n2 = 0; n2 < this.stones.length; ++n2) {
                this.stones[n2] = 0;
            }
            n2 = 3;
            n = 3;
            int n3 = n * 8 + n2;
            this.stones[n3] = this.player_color[0];
            this.stones[++n3] = this.player_color[1];
            this.stones[n3 += 8] = this.player_color[0];
            this.stones[--n3] = this.player_color[1];
            this.p1_stones_ob = 2;
            this.p2_stones_ob = 2;
        }
        for (n2 = 0; n2 < this.turnOffEfketsIndex.length; ++n2) {
            this.turnOffEfketsIndex[n2] = 0;
        }
        this.gameStateIndex = this.bFirstPlayerXML ? (this.firstPlayerXml == this.gameStates[0] ? (byte)0 : 1) : (byte)0;
        this.playedStone = this.player_one;
        this.playedStone.setVisible(true);
        this.playedStone.startPath(6);
        this.playedStone.update();
        this.playedStoneX = 3;
        this.playedStoneY = 3;
        this.setStonePos(this.playedStoneX, this.playedStoneY);
        this.board.copyFrom(this.stones);
        this.arangeDeluxeElements();
        this.changeSides(this.gameStateIndex);
        this.stoneAnimFrame = 0;
        this.gameStateCurrent = (byte)102;
    }

    private void arangeDeluxeElements() {
    }

    public boolean keyPress(int n) {
        if (super.keyPress(n)) {
            return true;
        }
        switch (this.gameStateCurrent) {
            case 101: {
                if ((n & 2) == 0) break;
                this.stoneAnimFrame = 0;
                this.stopBgEfekts();
                this.gameStateCurrent = (byte)102;
                break;
            }
            case 17: {
                if ((n & 2) == 0) break;
                this.goNext(this.playedStoneX, this.playedStoneY);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 105: {
                if (this.bShowTutMsg) break;
                if ((n & 2) != 0) {
                    byte by = this.player_color[this.gameStateIndex];
                    if (!this.canOccupateThis(this.playedStoneX, this.playedStoneY, by, true)) break;
                    this.animPutDown();
                    this.bTutMsgShutDown = true;
                    break;
                }
                if (n == 0) break;
                int n2 = 0;
                int n3 = 0;
                boolean bl = false;
                if (n == 32) {
                    if (--this.playedStoneY < 0) {
                        this.playedStoneY = 7;
                    }
                    bl = true;
                }
                if (n == 64) {
                    if (++this.playedStoneY > 7) {
                        this.playedStoneY = 0;
                    }
                    bl = true;
                }
                if (n == 16) {
                    if (++this.playedStoneX > 7) {
                        this.playedStoneX = 0;
                    }
                    bl = true;
                }
                if (n == 8) {
                    if (--this.playedStoneX < 0) {
                        this.playedStoneX = 7;
                    }
                    bl = true;
                }
                if (!bl) break;
                this.initMoveAnim(n2, n3);
            }
        }
        return false;
    }

    public void doLogic() {
        switch (this.gameStateCurrent) {
            case 1: 
            case 2: {
                if (!this.bShowTutMsg) break;
                this.bShowTutMsg = false;
                if (!this.showTutMsg()) {
                    this.tutStateInit();
                    this.tutEventExe();
                    break;
                }
                this.tutStateInit();
                break;
            }
            case 102: {
                if (this.stoneAnimFrame == 0) {
                    if (this.gameMsg != null) {
                        this.showMsg(this.gameMsg[0], this.gameMsg[1], 10, this.board_y - 0, this.width - 20, 192);
                    }
                    ++this.stoneAnimFrame;
                    break;
                }
                if (++this.stoneAnimFrame <= 12) break;
                this.gameStateCurrent = this.gameStates[this.gameStateIndex];
                break;
            }
            case 3: {
                byte[] byArray;
                byte by;
                if (this.bShowTutMsg) {
                    this.bShowTutMsg = false;
                    if (!this.showTutMsg()) {
                        this.tutStateInit();
                        this.tutEventExe();
                    } else {
                        this.tutStateInit();
                    }
                }
                if (++this.stoneAnimFrame <= 2) break;
                if (this.scriptMovesPointer >= 0) {
                    by = this.scriptMoves[this.scriptMovesPointer];
                    byArray = new byte[]{(byte)(by / 8), (byte)(by - byArray[0] * 8)};
                    byArray[1] = (byte)(byArray[1] + 1);
                    byArray[0] = (byte)(byArray[0] + 1);
                } else if (this.tutorialPointer > -1) {
                    by = this.tutEventArr[this.tutorialPointer][1];
                    byArray = new byte[]{(byte)(by / 8), (byte)(by - byArray[0] * 8)};
                    byArray[1] = (byte)(byArray[1] + 1);
                    byArray[0] = (byte)(byArray[0] + 1);
                } else {
                    byArray = this.othello.computerMove(this.stones);
                }
                this.playedStoneX = byArray[1] - 1;
                this.playedStoneY = byArray[0] - 1;
                this.setStonePos(this.playedStoneX, this.playedStoneY);
                this.playedStone.setVisible(true);
                by = this.player_color[this.gameStateIndex];
                if (this.canOccupateThis(this.playedStoneX, this.playedStoneY, by, true)) {
                    this.animPutDown();
                    break;
                }
                this.goNext(this.playedStoneX, this.playedStoneY);
                break;
            }
            case 16: {
                if (++this.stoneAnimFrame <= 3) break;
                this.animRevers(this.player_color[this.gameStateIndex]);
                break;
            }
            case 6: {
                if (++this.stoneAnimFrame < 4) break;
                this.setStonePos(this.playedStoneX, this.playedStoneY);
                this.gameStateCurrent = this.gameStates[this.gameStateIndex];
                byte by = this.player_color[this.gameStateIndex];
                byte by2 = this.player_color[1 - this.gameStateIndex];
                if (this.tutorialPointer > -1) {
                    if (this.tutFromToIsHere(this.playedStoneY * 8 + this.playedStoneX)) {
                        this.playedStone.startPath(5);
                        break;
                    }
                    this.playedStone.startPath(6);
                    break;
                }
                if (this.board.canMove(this.playedStoneX, this.playedStoneY, by, by2)) {
                    this.playedStone.startPath(5);
                    break;
                }
                this.playedStone.startPath(6);
                break;
            }
            case 9: {
                if (++this.stoneAnimFrame >= 3) {
                    for (int i = 0; i < this.efektsBufOff; ++i) {
                        this.efekts[i].setVisible(false);
                    }
                    this.stoneAnimFrame = 0;
                    this.gameStateCurrent = (byte)10;
                    break;
                }
                for (int i = 0; i < this.efektsBufOff; ++i) {
                    this.efekts[i].update();
                }
                break;
            }
            case 10: {
                if (++this.stoneAnimFrame >= 3) {
                    for (int i = this.efekts.length >> 1; i < (this.efekts.length >> 1) + this.efektsBufOff; ++i) {
                        this.efekts[i].setVisible(false);
                    }
                    this.efektsBufOff = 0;
                    this.okAndGoNext(this.playedStoneX, this.playedStoneY);
                    break;
                }
                for (int i = this.efekts.length >> 1; i < (this.efekts.length >> 1) + this.efektsBufOff; ++i) {
                    this.efekts[i].update();
                }
                break;
            }
            case 7: {
                if (++this.stoneAnimFrame >= 3) {
                    for (int i = this.efekts.length >> 1; i < (this.efekts.length >> 1) + this.efektsBufOff; ++i) {
                        this.efekts[i].setVisible(false);
                    }
                    this.stoneAnimFrame = 0;
                    this.gameStateCurrent = (byte)8;
                    break;
                }
                for (int i = this.efekts.length >> 1; i < (this.efekts.length >> 1) + this.efektsBufOff; ++i) {
                    this.efekts[i].update();
                }
                break;
            }
            case 8: {
                if (++this.stoneAnimFrame >= 3) {
                    for (int i = 0; i < this.efektsBufOff; ++i) {
                        this.efekts[i].setVisible(false);
                    }
                    this.efektsBufOff = 0;
                    this.okAndGoNext(this.playedStoneX, this.playedStoneY);
                    break;
                }
                for (int i = 0; i < this.efektsBufOff; ++i) {
                    this.efekts[i].update();
                }
                break;
            }
            case 126: {
                if (++this.stoneAnimFrame <= 18) break;
                this.gameStateCurrent = (byte)127;
                this.gameWin();
            }
        }
        this.playedStone.update();
    }

    private boolean canOccupateThis(int n, int n2, byte by, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        if (this.tutorialPointer > -1) {
            bl2 = this.tutFromToIsHere(n2 * 8 + n);
            if (!bl) {
                return bl2;
            }
            if (bl && !bl2) {
                return bl2;
            }
        }
        if (this.stones[bl2 = n2 * 8 + n] != 0) {
            return false;
        }
        for (int i = 0; i < DIRECTION.length; i += 2) {
            int n3;
            int n4 = DIRECTION[i];
            int n5 = DIRECTION[i + 1];
            int n6 = n + n4;
            int n7 = n2 + n5;
            boolean bl4 = true;
            if (n6 < 0 || n6 >= 8 || n7 < 0 || n7 >= 8 || this.stones[n3 = n7 * 8 + n6] == by || this.stones[n3] == 0) continue;
            do {
                if ((n6 += n4) >= 0 && n6 < 8 && (n7 += n5) >= 0 && n7 < 8) {
                    n3 = n7 * 8 + n6;
                    if (this.stones[n3] == by) {
                        bl4 = false;
                        if (bl) {
                            this.revers(n, n2, n6, n7, n4, n5, by);
                            bl3 |= true;
                            continue;
                        }
                        return true;
                    }
                    if (this.stones[n3] != 0) continue;
                    bl4 = false;
                    continue;
                }
                bl4 = false;
            } while (bl4);
        }
        return bl3;
    }

    private void revers(int n, int n2, int n3, int n4, int n5, int n6, byte by) {
        int n7 = n + n5;
        int n8 = n2 + n6;
        byte by2 = this.player_color[0];
        do {
            int n9 = n8 * 8 + n7;
            this.turnOffEfketsIndex[n9] = by;
            int n10 = this.efektsBufOff;
            int n11 = this.efektsBufOff + (this.efekts.length >> 1);
            Entity entity = this.efekts[n10];
            entity.setPosX(this.box_left + n7 * 24);
            entity.setPosY(this.box_top + n8 * 24);
            entity.setVisible(true);
            if (by != by2) {
                entity.startPath(3);
            } else {
                entity.startPath(4);
            }
            entity.update();
            this.efekts[n10] = entity;
            entity = this.efekts[n11];
            entity.setPosX(this.box_left + n7 * 24);
            entity.setPosY(this.box_top + n8 * 24);
            entity.setVisible(true);
            if (by != by2) {
                entity.startPath(4);
            } else {
                entity.startPath(3);
            }
            entity.update();
            this.efekts[n11] = entity;
            ++this.efektsBufOff;
        } while ((n7 += n5) != n3 || (n8 += n6) != n4);
    }

    private void animPutDown() {
        this.playedStone.startPath(0);
        this.stoneAnimFrame = 0;
        this.gameStateCurrent = (byte)16;
        int n = this.playedStoneX + this.playedStoneY * 8;
        if (!this.deluxeFeatureSound(n)) {
            if (this.gameStateIndex == 0) {
                Game.playEffekt(-1);
            } else {
                Game.playEffekt(-1);
            }
        }
    }

    private void animRevers(int n) {
        this.gameStateCurrent = n != this.player_color[0] ? (byte)9 : (byte)7;
        for (int i = 0; i < this.stones.length; ++i) {
            if (this.turnOffEfketsIndex[i] == 0) continue;
            this.stones[i] = (byte)(-1 * this.turnOffEfketsIndex[i]);
            this.turnOffEfketsIndex[i] = 0;
        }
        this.stoneAnimFrame = 0;
        this.playedStone.startPath(0);
    }

    private void okAndGoNext(int n, int n2) {
        int n3 = n2 * 8 + n;
        this.stones[n3] = this.player_color[this.gameStateIndex];
        for (int i = 0; i < this.stones.length; ++i) {
            this.stones[i] = (byte)Math.abs(this.stones[i]);
        }
        if (this.scriptMovesPointer >= 0) {
            if (n3 == this.scriptMoves[this.scriptMovesPointer]) {
                if (++this.scriptMovesPointer > this.scriptMoves.length - 1) {
                    this.scriptMovesPointer = -1;
                }
            } else {
                this.scriptMovesPointer = -1;
            }
        }
        this.board.doMove(n, n2, this.player_color[this.gameStateIndex], this.player_color[1 - this.gameStateIndex]);
        this.goNext(n, n2);
    }

    private void goNext(int n, int n2) {
        int n3;
        int n4;
        if (this.movesLeftb >= 0) {
            if (this.gameStateIndex == 0) {
                this.movesLeftw = (byte)(this.movesLeftw - 1);
            } else {
                this.movesLeftb = (byte)(this.movesLeftb - 1);
            }
        }
        if ((this.gameStateIndex = (byte)(this.gameStateIndex + 1)) >= this.gameStates.length) {
            this.gameStateIndex = 0;
        }
        switch (this.gameStateIndex) {
            case 0: {
                this.playedStone = this.player_one;
                break;
            }
            case 1: {
                this.playedStone = this.player_two;
            }
        }
        boolean bl = false;
        byte by = this.player_color[0];
        byte by2 = this.player_color[1];
        byte by3 = this.player_color[this.gameStateIndex];
        byte by4 = this.player_color[1 - this.gameStateIndex];
        this.p2_stones_ob = 0;
        this.p1_stones_ob = 0;
        for (n4 = 0; n4 < this.stones.length; ++n4) {
            byte by5 = this.stones[n4];
            if (by5 == by) {
                ++this.p1_stones_ob;
                continue;
            }
            if (by5 == by2) {
                ++this.p2_stones_ob;
                continue;
            }
            if (bl) continue;
            int n5 = n4 / 8;
            int n6 = n4 - n5 * 8;
            bl |= this.board.canMove(n6, n5, by3, by4);
        }
        n4 = Math.abs(this.p2_stones_ob - this.p1_stones_ob) * Main.gameStatisticMultiper[0][0];
        if (this.p1_stones_ob > this.p2_stones_ob) {
            this.scoreOne = n4 + this.gems[0] * Main.gameStatisticMultiper[0][1] + this.gems[1] * Main.gameStatisticMultiper[0][2];
            this.scoreTwo = this.gems[2] * Main.gameStatisticMultiper[0][1] + this.gems[3] * Main.gameStatisticMultiper[0][2];
        } else {
            this.scoreOne = this.gems[0] * Main.gameStatisticMultiper[0][1] + this.gems[1] * Main.gameStatisticMultiper[0][2];
            this.scoreTwo = n4 + this.gems[2] * Main.gameStatisticMultiper[0][1] + this.gems[3] * Main.gameStatisticMultiper[0][2];
        }
        if (this.p1_stones_ob + this.p2_stones_ob == 64) {
            this.gameStateCurrent = (byte)127;
            this.whoWin = this.p1_stones_ob == this.p2_stones_ob ? (byte)0 : (this.p1_stones_ob > this.p2_stones_ob ? this.gameStates[0] : this.gameStates[1]);
            boolean bl2 = Game.winerScoreS = this.whoWin == 1;
            Game.winerName = this.p1_stones_ob == this.p2_stones_ob ? null : (this.p1_stones_ob > this.p2_stones_ob ? this.pOneName : this.pTwoName);
        } else if (!bl) {
            if (this.gameStateCurrent != 17) {
                this.gameStateCurrent = (byte)17;
            } else {
                this.gameStateCurrent = (byte)127;
                this.whoWin = this.p1_stones_ob == this.p2_stones_ob ? (byte)0 : (this.p1_stones_ob > this.p2_stones_ob ? this.gameStates[0] : this.gameStates[1]);
                boolean bl3 = Game.winerScoreS = this.whoWin == 1;
                Game.winerName = this.p1_stones_ob == this.p2_stones_ob ? null : (this.p1_stones_ob > this.p2_stones_ob ? this.pOneName : this.pTwoName);
            }
        } else {
            this.gameStateCurrent = this.gameStates[this.gameStateIndex];
            if (this.puzzleWinScore > -1) {
                int n7 = n3 = this.gameStates[0] == 1 ? this.scoreOne : this.scoreTwo;
                if (n3 >= this.puzzleWinScore) {
                    this.playedStone.setVisible(false);
                    Game.winerScoreS = false;
                    Game.winerName = this.gameStates[0] == 1 ? this.pOneName : this.pTwoName;
                    this.stoneAnimFrame = 0;
                    this.gameStateCurrent = (byte)126;
                    Game.playEffekt(-1);
                    return;
                }
            }
            if (this.movesLeftb == 0 || this.movesLeftw == 0) {
                this.whoWin = this.p1_stones_ob == this.p2_stones_ob ? (byte)0 : (this.p1_stones_ob > this.p2_stones_ob ? this.gameStates[0] : this.gameStates[1]);
                this.playedStone.setVisible(false);
                this.gameStateCurrent = (byte)127;
                if (this.whoWin == 1) {
                    Game.playEffekt(-1);
                } else {
                    Game.playEffekt(-1);
                }
                Game.winerScoreS = false;
                this.gameStateCurrent = (byte)126;
                this.stoneAnimFrame = 0;
                return;
            }
        }
        this.tutGoNext();
        switch (this.gameStateCurrent) {
            case 1: 
            case 2: {
                this.playedStone.setVisible(true);
                this.playedStoneX = n;
                this.playedStoneY = n2;
                if (this.canOccupateThis(n, n2, this.player_color[this.gameStateIndex], false)) {
                    this.playedStone.startPath(5);
                } else {
                    this.playedStone.startPath(6);
                }
                this.setStonePos(n, n2);
                break;
            }
            case 3: {
                this.playedStone.setVisible(false);
                this.stoneAnimFrame = 0;
                break;
            }
            case 127: {
                if (this.whoWin == 1) {
                    Game.playEffekt(-1);
                } else {
                    Game.playEffekt(-1);
                }
                this.playedStone.setVisible(false);
                this.gameStateCurrent = (byte)126;
                this.stoneAnimFrame = 0;
                return;
            }
            case 17: {
                this.playedStone.setVisible(false);
            }
        }
        if (this.gameStateCurrent == 1) {
            if (++this.backupLast > 2) {
                this.backupLast = 0;
            }
            for (n3 = 0; n3 < this.stones.length; ++n3) {
                this.backup[this.backupLast][n3] = this.stones[n3];
            }
        }
        this.changeSides(this.gameStateIndex);
        if (this.bShowTutMsg) {
            this.bShowTutMsg = false;
            if (this.tutorialPointer > -1) {
                if (!this.showTutMsg()) {
                    this.tutStateInit();
                    this.tutEventExe();
                } else {
                    this.tutStateInit();
                }
            } else {
                this.gameStateCurrent = (byte)107;
            }
        }
    }

    protected void gameWin() {
        int n = 0;
        int n2 = 0;
        if (this.gameStates[0] == 1) {
            n = this.p1_stones_ob;
            n2 = this.p2_stones_ob;
        } else {
            n = this.p2_stones_ob;
            n2 = this.p1_stones_ob;
        }
        int n3 = (n - n2) * Main.gameStatisticMultiper[0][0];
        Game.gameStats[0] = n3 > 0 ? n3 : 0;
        Game.gameSTxt[0] = "" + this.p1_stones_ob + " : " + this.p2_stones_ob;
        Game.gameStats[1] = 0;
        Game.gameSTxt[1] = "";
        Game.gameStats[2] = 0;
        Game.gameSTxt[2] = "";
        if (this.p1_stones_ob == 0 || this.p2_stones_ob == 0) {
            Game.gameStats[3] = Main.gameStatisticMultiper[0][3];
            Game.gameSTxt[3] = Main.getTxt(0, 8);
        } else {
            Game.gameStats[3] = 0;
            Game.gameSTxt[3] = "";
        }
        switch (this.ai_difficulty) {
            case 0: {
                Game.gameStats[4] = Main.gameStatisticMultiper[0][4];
                Game.gameSTxt[4] = Main.getStr(58);
                break;
            }
            case 1: {
                Game.gameStats[4] = Main.gameStatisticMultiper[0][5];
                Game.gameSTxt[4] = Main.getStr(59);
                break;
            }
            case 2: {
                Game.gameStats[4] = Main.gameStatisticMultiper[0][6];
                Game.gameSTxt[4] = Main.getStr(60);
                break;
            }
            default: {
                Game.gameStats[4] = 0;
                Game.gameSTxt[4] = "";
            }
        }
        Game.gameSTxt[Game.gameSTxt.length - 1] = Main.getStr(31);
        super.gameWin();
    }

    private void setStonePos(int n, int n2) {
        this.playedStone.setPosX(this.box_left + 24 * n);
        this.playedStone.setPosY(this.box_top + 24 * n2);
    }

    private void initMoveAnim(int n, int n2) {
        this.gameStateCurrent = (byte)6;
        this.stoneAnimFrame = 0;
        this.setStonePos(this.playedStoneX, this.playedStoneY);
        byte by = this.player_color[this.gameStateIndex];
        byte by2 = this.player_color[1 - this.gameStateIndex];
        if (this.tutorialPointer > -1) {
            if (this.tutFromToIsHere(this.playedStoneY * 8 + this.playedStoneX)) {
                this.playedStone.startPath(5);
            } else {
                this.playedStone.startPath(6);
            }
        } else if (this.board.canMove(this.playedStoneX, this.playedStoneY, by, by2)) {
            this.playedStone.startPath(5);
        } else {
            this.playedStone.startPath(6);
        }
    }

    public boolean tutEventExe() {
        if (!super.tutEventExe()) {
            return false;
        }
        byte by = this.tutorialScript[this.tutorialPointer][2];
        switch (by) {
            case 105: {
                this.playedStone.setVisible(true);
            }
        }
        return true;
    }

    public void tutStateInit() {
        super.tutStateInit();
        byte by = this.tutorialScript[this.tutorialPointer][2];
        switch (by) {
            case 104: {
                this.playedStone.setVisible(false);
                break;
            }
            case 106: {
                this.playedStone.setVisible(false);
                break;
            }
            case 109: {
                this.playedStone.setVisible(false);
                byte by2 = this.player_color[0];
                byte by3 = this.player_color[1];
                this.p2_stones_ob = 0;
                this.p1_stones_ob = 0;
                for (int i = 0; i < this.stones.length; ++i) {
                    this.stones[i] = this.tutEventArr[this.tutorialPointer][i];
                    byte by4 = this.stones[i];
                    if (by4 == by2) {
                        ++this.p1_stones_ob;
                        continue;
                    }
                    if (by4 != by3) continue;
                    ++this.p2_stones_ob;
                }
                this.board.copyFrom(this.stones);
                break;
            }
            case 105: 
            case 108: {
                this.tutSprite1.setVisible(true);
                this.tutSprite1.startPath(7);
                this.tutSprite1.update();
                this.tutSprite1.setPosXY(0, 0);
                this.playedStone.setVisible(false);
                byte by5 = this.tutEventArr[this.tutorialPointer][0];
                int n = by5 / 8;
                int n2 = by5 - n * 8;
                this.playedStone.setPosXY(this.box_left + n2 * 24, this.box_top + n * 24);
                this.playedStone.startPath(6);
                this.playedStone.update();
                this.playedStoneX = n2;
                this.playedStoneY = n;
                break;
            }
            case 111: {
                byte by6 = this.tutEventArr[this.tutorialPointer][0];
                byte by7 = this.tutEventArr[this.tutorialPointer][1];
                break;
            }
            case 107: {
                this.playedStone.setVisible(false);
            }
        }
    }

    public void paint() {
        BoardGame.g.setClip(0, 0, this.width, this.height);
        BoardGame.g.setColor(0);
        BoardGame.g.fillRect(0, 0, this.width, this.height);
        this.paintBG();
        switch (this.gameStateCurrent) {
            case 101: {
                this.paintSoftListText(55);
                return;
            }
            case 102: {
                Game.paintRolledImg(6, this.board_x, this.board_y, this.stoneAnimFrame >> 0, 8, 4);
                this.paintUI();
                return;
            }
            case 92: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                this.paintDeluxElements();
                this.paintBoxNums();
                this.paintCheatMenu();
                return;
            }
            case 94: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                this.paintDeluxElements();
                this.paintBoxNums();
                int n = this.box_left - 12 + this.pu_pos_x * 24 + 4;
                int n2 = this.box_top - 12 + this.pu_pos_y * 24 + 4;
                BoardGame.g.setColor(0xFFFF00);
                BoardGame.g.drawRect(n, n2, 15, 15);
                return;
            }
            case 16: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                this.playedStone.paint(0, 0);
                break;
            }
            case 21: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                this.paintDeluxElements();
                this.paintBoxNums();
                this.playedStone.paint(0, 0);
                return;
            }
            case 1: 
            case 2: 
            case 20: 
            case 66: 
            case 105: 
            case 108: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                this.paintDeluxElements();
                this.paintBoxNums();
                this.playedStone.paint(0, 0);
                return;
            }
            case 6: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                this.paintDeluxElements();
                this.paintBoxNums();
                this.playedStone.paint(0, 0);
                return;
            }
            case 8: 
            case 9: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                for (int i = 0; i < this.efektsBufOff; ++i) {
                    this.efekts[i].paint(0, 0);
                }
                this.playedStone.paint(0, 0);
                break;
            }
            case 7: 
            case 10: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                for (int i = this.efekts.length >> 1; i < (this.efekts.length >> 1) + this.efektsBufOff; ++i) {
                    this.efekts[i].paint(0, 0);
                }
                this.playedStone.paint(0, 0);
                break;
            }
            case 126: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                break;
            }
            case 127: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                this.paintDeluxElements();
                this.paintBoxNums();
                this.paintSoftListText(55);
                return;
            }
            case 17: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                this.paintDeluxElements();
                this.paintBoxNums();
                BoardGame.g.setClip(0, 0, this.width, this.height);
                BoardGame.g.setColor(0);
                BoardGame.g.fillRect((this.width >> 1) - 114, (this.height >> 1) - 25, 228, 50);
                Fonts.drawGraphicString(0, (this.gameStateIndex == 0 ? this.pOneName : this.pTwoName) + " " + Main.getTxt(1, 5), this.width >> 1, this.height >> 1, 33);
                this.paintSoftListText(55);
                return;
            }
            case 106: 
            case 109: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                this.paintDeluxElements();
                this.paintBoxNums();
                this.paintSoftListText(55);
                return;
            }
            case 103: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
                this.paintDeluxElements();
                this.paintBoxNums();
                this.playedStone.paint(0, 0);
                this.paintTutMsg();
                return;
            }
            default: {
                this.paintPlayfield();
                this.paintUI();
                this.paintStones();
            }
        }
        this.paintDeluxElements();
        this.paintBoxNums();
    }

    public void paintBoxNums() {
    }

    public void paintPlayfield() {
        BoardGame.g.setClip(0, 0, GMain.canvasWidth, GMain.canvasHeight);
        BoardGame.g.drawImage(GMain.imageCache[6], this.board_x, this.board_y, 20);
        int n = GMain.getImageWidth(6);
        int n2 = GMain.getImageHeight(6);
        BoardGame.g.drawImage(GMain.imageCache[17], this.board_x + n, this.board_y, 20);
        BoardGame.g.drawImage(GMain.imageCache[16], this.board_x, this.board_y + n2, 20);
    }

    private void paintStones() {
        if (this.tutEventArr != null) {
            this.paintTutUnderLight(this.box_left, this.box_top, 8, 8, 24, 24);
        }
        byte by = this.player_color[0];
        byte by2 = this.player_color[1];
        for (int i = 0; i < this.stones.length; ++i) {
            byte by3 = this.stones[i];
            if (by3 == 0) continue;
            int n = i / 8;
            int n2 = i - n * 8;
            n2 = this.box_left + n2 * 24;
            n = this.box_top + n * 24;
            if (by3 == by) {
                this.player_one_table.paint(n2, n);
                continue;
            }
            if (by3 != by2) continue;
            this.player_two_table.paint(n2, n);
        }
    }

    public void paintUI() {
        this.paintUIb(this.gameStateIndex);
        if (this.movesLeftb < 0) {
            int n = this.ui_down_c - 4 - 16 - 4 - 16 - this.ui_bignum_yoff;
            Utils.drawNums10(GMain.imageCache[14], this.p1_stones_ob, 2, this.ui_lft + this.ui_bignum_xoff, n, 1, true);
            Utils.drawNums10(GMain.imageCache[14], this.p2_stones_ob, 2, this.ui_rght + this.ui_bignum_xoff, n, 1, true);
            BoardGame.g.setClip(0, 0, this.width, this.height);
        }
    }

    public void clean() {
        super.clean();
        this.player_one_table.clean();
        this.player_two_table.clean();
        this.player_one_table = null;
        this.player_two_table = null;
        this.playedStone = null;
        this.player_one.clean();
        this.player_two.clean();
        this.player_one = null;
        this.player_two = null;
        this.othello = null;
        this.board = null;
    }
}

