/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

class PlatformCanvas
extends GameCanvas
implements Runnable {
    public static PlatformCanvas instance = null;
    public static final int CANVAS_RESIZE_X = 0;
    public static final int CANVAS_RESIZE_Y = 0;
    private static final int STATE_RUN = 0;
    private static final int STATE_QUIT = 1;
    public static final int RESUME_SOUND_DELAY = 1500;
    private static int state;
    private static Thread thread;
    public static int canvasWidth;
    public static int canvasHeight;
    private boolean isShown;
    private volatile boolean showNotifySeen;
    private volatile boolean hideNotifySeen;
    public static Application application;
    private static final int device_keyLeftSoft = 113;
    private static final int device_keyRightSoft = 112;
    private static final int device_keyCenterSoft = -8;
    private static final int device_keyUpArrow = 1;
    private static final int device_keyDownArrow = 6;
    private static final int device_keyLeftArrow = 2;
    private static final int device_keyRightArrow = 5;
    private static final int device_keySelect = 113;
    private static final int device_keyBack = 112;
    private static final int device_keyClear = 8;
    private static final int device_keyPlus = 0;
    private static final int[] remapKeys;
    private static volatile boolean paintRequest;

    public PlatformCanvas() {
        super(false);
        Platform.g = this.getGraphics();
        instance = this;
    }

    public void start() {
        state = 0;
        thread = new Thread(this);
        thread.start();
    }

    public void exit() {
        state = 1;
        PlatformSound.stopAllSounds();
    }

    public void showNotify() {
        this.isShown = true;
        this.showNotifySeen = true;
    }

    public void hideNotify() {
        this.isShown = false;
        this.hideNotifySeen = true;
        this.showNotifySeen = false;
        PlatformSound.stopAllSounds();
    }

    public void run() {
        try {
            this.runSafe();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlatformMIDlet.instance.notifyDestroyed();
    }

    private void runSafe() {
        if (PlatformMIDlet.display.getCurrent() != this) {
            PlatformMIDlet.display.setCurrent((Displayable)this);
        }
        canvasWidth = this.getWidth();
        canvasHeight = this.getHeight();
        Platform.init();
        application = new Main();
        application.start();
        while (state != 1) {
            this.checkPause();
            application.update();
        }
        application.destroy();
    }

    private void checkPause() {
        if (this.hideNotifySeen) {
            application.pause();
            while (this.hideNotifySeen) {
                this.hideNotifySeen = false;
                do {
                    Platform.sleep(100);
                } while (!this.showNotifySeen);
            }
            application.resume();
        }
    }

    public void keyPressed(int n) {
        int n2 = PlatformCanvas.mapKeySymbol(n);
        application.keyPressed(n2);
    }

    public void keyReleased(int n) {
        int n2 = PlatformCanvas.mapKeySymbol(n);
        application.keyReleased(n2);
    }

    private static int remapKey(int n) {
        for (int i = 0; i < remapKeys.length; i += 2) {
            if (n != remapKeys[i]) continue;
            return remapKeys[i + 1];
        }
        return n;
    }

    public static int mapKeySymbol(int n) {
        n = PlatformCanvas.remapKey(n);
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return 1 + (n - 48);
            }
            case 42: {
                return 11;
            }
            case 35: {
                return 12;
            }
            case 8: {
                return 13;
            }
            case 113: {
                return 14;
            }
            case 112: {
                return 15;
            }
            case -8: {
                return 16;
            }
            case 1: {
                return 17;
            }
            case 6: {
                return 18;
            }
            case 2: {
                return 19;
            }
            case 5: {
                return 20;
            }
        }
        return -1;
    }

    public final void draw() {
        Graphics graphics = this.getGraphics();
        if (!paintRequest) {
            return;
        }
        Platform.g = graphics;
        Platform.displayGraphics.g = graphics;
        canvasWidth = this.getWidth();
        canvasHeight = this.getHeight();
        try {
            Graphics graphics2 = Platform.g;
            graphics2.translate(-graphics2.getTranslateX(), -graphics2.getTranslateY());
            application.paint();
        }
        catch (Exception exception) {
            // empty catch block
        }
        paintRequest = false;
    }

    public static void redraw() {
        paintRequest = true;
        PlatformCanvas platformCanvas = instance;
        platformCanvas.draw();
        platformCanvas.flushGraphics();
        while (paintRequest) {
            Platform.sleep(10);
        }
    }

    protected void sizeChanged(int n, int n2) {
        if (application != null) {
            application.sizeChanged(n, n2);
        }
    }

    static {
        remapKeys = new int[]{48, 48, 119, 49, 101, 50, 114, 51, 115, 52, 100, 53, 102, 54, 121, 55, 120, 56, 99, 57, 48, 48, 103, 35, 97, 42};
    }
}

