/*
 * Decompiled with CFR 0.152.
 */
public class HighscoreAlgorithm {
    public static String communityURL;
    public static long guidFirstLaunch;
    public static int guidFirstPressedKey;
    public static int guidRandomValue;
    private static final int RANDOM_MAGIC_VALUE = 19760418;
    private static final String digits = "0123456789abcdef";

    public static String createCommunityLinkURL(int n, String string) {
        String string2 = HighscoreAlgorithm.computeGameUID();
        String string3 = HighscoreAlgorithm.encodeValue(n, HighscoreAlgorithm.getMagicNumber(string2));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(communityURL);
        stringBuffer.append("=");
        stringBuffer.append(string2);
        stringBuffer.append("&l=");
        stringBuffer.append(string);
        stringBuffer.append("&s=");
        stringBuffer.append(string3);
        String string4 = stringBuffer.toString();
        return string4;
    }

    private static int getMagicNumber(String string) {
        int n;
        long l = 0L;
        for (n = 0; n < string.length() && n < 16; ++n) {
            l |= (long)(0xF & digits.indexOf(string.charAt(n)));
            l <<= 4;
        }
        n = 0;
        int n2 = 0;
        int n3 = 0;
        n = (int)l + 19760418;
        if (0 == n) {
            n = 19760418;
        }
        n3 = n * n * 3 + n;
        n2 = n * n * 7 + n;
        int n4 = HighscoreAlgorithm.parseGIDFromURL(communityURL);
        for (int i = 0; i < n4; ++i) {
            n *= n3;
            n += n2;
            n >>= 4;
        }
        return n;
    }

    private static int parseGIDFromURL(String string) {
        int n = 0;
        int n2 = string.indexOf("GID=");
        if (n2 < 0) {
            return 0;
        }
        int n3 = string.indexOf("&", n2 += 4);
        if (n3 < 0) {
            n3 = string.length();
        }
        return n;
    }

    private static String encodeValue(int n, int n2) {
        int n3 = (n ^= n2) & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n >> 16 & 0xFF;
        int n6 = n >> 24 & 0xFF;
        int n7 = 256 - (n3 + n4 + n5 + n6 & 0xFF) & 0xFF;
        StringBuffer stringBuffer = new StringBuffer();
        String string = Utils.itoa(n7, 16);
        if (string.length() != 2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        stringBuffer.append(Utils.itoa(n, 16));
        return stringBuffer.toString();
    }

    private static String computeGameUID() {
        char[] cArray = new char[32];
        HighscoreAlgorithm.toHex(cArray, 0, 16, guidFirstLaunch);
        HighscoreAlgorithm.toHex(cArray, 16, 8, guidFirstPressedKey);
        HighscoreAlgorithm.toHex(cArray, 24, 8, guidRandomValue);
        return new String(cArray);
    }

    private static void toHex(char[] cArray, int n, int n2, long l) {
        for (int i = n2 - 1; i >= 0; --i) {
            int n3 = (int)(l >>> 4 * i) & 0xF;
            cArray[n++] = digits.charAt(n3);
        }
    }
}

