/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public abstract class GMain
extends Application {
    public static final String NAME = "BoardGames";
    public static final String VERSION = "1.0.26";
    public static GMain instance = null;
    static final int[] STRINGS_OFF_ON = new int[]{8, 7};
    protected static final int RUN_INITIAL = 0;
    protected static final int RUN_LOAD = 1;
    protected static final int RUN_MENU = 2;
    protected static final int RUN_GAME = 3;
    protected static final int RUN_QUIT = 4;
    protected static final int RUN_BLOCK = 5;
    private static final int SC_INITIAL = 0;
    private static final int SC_LOAD = 1;
    protected static final int SC_MENU = 2;
    protected static final int SC_GAME = 3;
    private static final int SC_BUSY = 4;
    private static final int SC_BLOCK = 5;
    public static final int RESUME_SOUND_DELAY = 1500;
    private static final int CHEAT_BEGIN = 12;
    private static final int CHEAT_END = 11;
    private static final int USER_CHEAT_BEGIN = 11;
    private static final int USER_CHEAT_END = 12;
    protected int runCmd = 0;
    protected static int actScreen = 0;
    public static final int MENU_FPS = 14;
    public static GameCommon game;
    public static int canvasWidth;
    public static int canvasHeight;
    public static int pressedKeyCode;
    public static boolean bLoadState;
    public static int lastPointerX;
    public static int lastPointerY;
    public static boolean firstStart;
    public static int numbersLang;
    public static int langIndex;
    public static String[] langCodes;
    public static String[] strings;
    public static String bonusURL;
    public static String portalURL;
    public static String communityURL;
    public static boolean demoMode;
    public static String[] demoMessage;
    public static String[] demoURL;
    private int cheatCode;
    private int cheatCodeSize;
    boolean cheatEnable = false;
    private boolean cheatWriting;
    private boolean cheatProcess;
    private boolean cheatsOn = false;
    private final int[] CHEAT_ON_CHEAT = new int[]{12, 3, 5, 7, 11};
    private int cheatOnPointer = 0;
    private boolean userCheatWriting;
    private byte userCheatCodeSize;
    private int userCheatCode;
    protected GForm activeForm;
    protected GForm mainMenu;
    protected GForm gameMenu;
    private boolean resumed;
    private boolean bSuspend;
    static int introProgress;
    public static PlatformImage[] imageCache;
    public static byte[] imageColorVariantsCnt;
    public static PlatformImage[] imageCacheL18N;
    public static byte[] imageColorVariantsCntL18N;
    protected static byte prevSndOpt;
    private static final int BLOCK_HEIGHT = 0;
    private static final int BLOCK_FONT = 2;
    public static final int OPT_VIBRATION = 0;
    public static final int OPT_VOLUME = 1;
    public static final int OPT_SOUND = 2;
    public static final int OPT_SHOW_TEXTS_AND_ANIMATIONS = 3;
    public static final int OPT_DIFFICULTY_HARD = 4;
    public static final int OPT_SHOW_HINTS = 5;
    public static final int OPT_SHOW_TUTORIAL = 6;
    protected static byte[] options;

    public GMain() {
        instance = this;
        GMain.setOption(5, 1);
        GMain.setOption(6, 1);
        imageCache = new PlatformImage[30];
        imageColorVariantsCnt = new byte[30];
    }

    public void pause() {
    }

    public void resume() {
        this.resumed = true;
    }

    public void keyPressed(int n) {
        if (bLoadState) {
            pressedKeyCode = 0;
            return;
        }
        if (this.activeForm != null && (this.activeForm.formId & 0x40000) != 0) {
            if (this.CHEAT_ON_CHEAT[this.cheatOnPointer] == n) {
                if (++this.cheatOnPointer > this.CHEAT_ON_CHEAT.length - 1) {
                    this.cheatsOn = !this.cheatsOn;
                    this.cheatOnPointer = 0;
                }
            } else {
                this.cheatOnPointer = 0;
            }
        }
        if (this.cheatWriting) {
            if (n == 11) {
                if (this.cheatCode == 0 && this.cheatCodeSize == 3) {
                    this.cheatEnable = !this.cheatEnable;
                } else {
                    this.cheatProcess = this.cheatEnable;
                }
                this.cheatWriting = false;
                return;
            }
            if (this.cheatCodeSize == 4 || n < 1 || n > 10) {
                this.cheatWriting = false;
                return;
            }
            int n2 = n - 1;
            this.cheatCode = this.cheatCode << 4 | n2;
            ++this.cheatCodeSize;
            return;
        }
        if (n == 12 && !this.userCheatWriting && this.cheatsOn) {
            if (this.cheatEnable || game == null) {
                this.cheatCode = 0;
                this.cheatCodeSize = 0;
                this.cheatWriting = true;
            }
            return;
        }
        if (this.userCheatWriting) {
            if (n == 12) {
                this.processUserCheat(this.userCheatCode, this.userCheatCodeSize);
                this.userCheatWriting = false;
                return;
            }
            if (this.userCheatCodeSize == 8 || n < 1 || n > 10) {
                this.userCheatWriting = false;
                return;
            }
            int n3 = n - 1;
            this.userCheatCode = this.userCheatCode << 4 | n3;
            this.userCheatCodeSize = (byte)(this.userCheatCodeSize + 1);
            return;
        }
        if (n == 11 && this.cheatsOn) {
            this.userCheatCode = 0;
            this.userCheatCodeSize = 0;
            this.userCheatWriting = true;
            return;
        }
        if (actScreen == 3) {
            game.keyPressed(n);
        } else {
            pressedKeyCode = n;
        }
    }

    public void keyReleased(int n) {
        if (bLoadState) {
            return;
        }
        if (actScreen == 3) {
            game.keyReleased(n);
        }
    }

    public static int mapLogicalKey(int n) {
        return n;
    }

    public static int mapYesNoKey(int n) {
        switch (n) {
            case 14: {
                return 1;
            }
            case 15: {
                return -1;
            }
        }
        return 0;
    }

    public void update() {
        switch (this.runCmd) {
            case 0: {
                bLoadState = true;
                firstStart = Platform.readRecord(0) == null;
                this.runCmd = 1;
                actScreen = 1;
                bLoadState = false;
                break;
            }
            case 1: {
                bLoadState = true;
                if (!firstStart) {
                    this.loadRms(0);
                }
                boolean bl = this.loadLang();
                this.updateLoad();
                this.loadTitle();
                this.updateLoad();
                this.loadSprites();
                this.loadFonts();
                this.updateLoad();
                this.updateLanguage();
                this.updateLoad();
                this.loadCommon();
                while (!this.updateLoad()) {
                    Platform.sleep(200);
                }
                this.releaseLoad();
                this.mainMenu = this.createMainMenu();
                if (firstStart) {
                    if (bl) {
                        this.setActiveForm(this.createLangForm());
                    } else {
                        this.setActiveForm(this.getInitialForm());
                    }
                } else {
                    this.setActiveForm(this.getInitialForm());
                }
                this.initMenu();
                if (firstStart) {
                    this.saveRms(0);
                }
                this.runCmd = 2;
                actScreen = 2;
                pressedKeyCode = 0;
                bLoadState = false;
                break;
            }
            case 2: {
                if (this.resumed) {
                    this.resumed = false;
                    pressedKeyCode = 0;
                    if (game == null && !this.resumed) {
                        Sound.playSound(0);
                    }
                }
                if (this.cheatProcess) {
                    this.cheatProcess = false;
                }
                int n = pressedKeyCode;
                pressedKeyCode = 0;
                if (n != 0) {
                    this.controlActiveForm(this.activeForm, n);
                    if (this.runCmd != 2) break;
                }
                this.updateMenu();
                break;
            }
            case 3: {
                boolean bl = GameCommon.paused;
                if (this.resumed || bl) {
                    this.resumed = false;
                    game.hideNotify();
                    if (bl) {
                        Sound.stopSound();
                    }
                    this.runCmd = 2;
                    this.gameMenu.reset();
                    this.setActiveForm(this.gameMenu);
                    break;
                }
                if (this.cheatProcess) {
                    this.cheatProcess = false;
                }
                if (!game.evolve()) break;
                this.leaveGame();
                break;
            }
        }
    }

    public void showGameMenu() {
    }

    protected void initMenu() {
    }

    protected void updateMenu() {
        int n = (int)Platform.clock();
        Platform.redraw();
        int n2 = (int)Platform.clock() - n;
        int n3 = 71 - n2;
        if (n3 > 10) {
            n3 = Math.min(100, n3);
            Platform.sleep(n3);
        }
    }

    protected void drawLoad() {
    }

    protected void releaseLoad() {
    }

    protected boolean updateLoad() {
        ++introProgress;
        return true;
    }

    public static void updateProgress() {
        if (instance != null && GMain.instance.runCmd == 1) {
            instance.updateLoad();
        }
    }

    protected void loadFonts() {
        if (!Fonts.initFont()) {
            return;
        }
        PlatformResource platformResource = Platform.getResource(Fonts.fontName);
        Fonts.readFontGraphics(platformResource);
        platformResource.close();
    }

    private boolean loadLang() {
        Object object;
        PlatformResource platformResource = Platform.getResource("/lang");
        if (platformResource == null) {
            numbersLang = 0;
            langCodes = null;
            return false;
        }
        langCodes = Utils.readStrings(platformResource);
        numbersLang = 0;
        for (int i = 0; i < langCodes.length; ++i) {
            Platform.assertTrue(langCodes[i] != null, "invalid langCodes");
            String string = "/l18n__".concat(langCodes[i]);
            object = Platform.getResource(string);
            if (object == null) {
                GMain.langCodes[i] = null;
                continue;
            }
            GMain.langCodes[GMain.numbersLang] = langCodes[i];
            ((PlatformResource)object).close();
            ++numbersLang;
        }
        demoURL = new String[numbersLang];
        demoMessage = new String[numbersLang];
        while (!platformResource.isEOF()) {
            String string = platformResource.readUTF();
            int n = string.length();
            if ("demo".equals(string)) {
                demoMode = true;
                object = Platform.getManifestProperty("Demo");
                if (object == null || ((String)object).length() <= 0) continue;
                demoMode = ((String)object).equals("ON");
                continue;
            }
            object = platformResource.readUTF();
            if (!string.startsWith("demoMsg__") || n != "demoMsg__".length() + 2) continue;
            for (int i = 0; i < numbersLang; ++i) {
                if (!string.startsWith(langCodes[i], n - 2)) continue;
                GMain.demoMessage[i] = object;
            }
        }
        platformResource.close();
        if (langIndex >= 0 && langIndex < numbersLang) {
            return false;
        }
        String string = null;
        if (string == null) {
            langIndex = 0;
        } else {
            for (langIndex = 0; langIndex < numbersLang && !string.startsWith(langCodes[langIndex]); ++langIndex) {
            }
            if (langIndex >= numbersLang) {
                langIndex = 0;
            }
        }
        return numbersLang > 1;
    }

    protected void loadTitle() {
        PlatformResource platformResource = Platform.getResource("/l");
        int n = platformResource.readByte() & 0xFF;
        int n2 = 0;
        while (n2 < n) {
            Utils.readDiffImage(platformResource, imageCache, imageColorVariantsCnt, n2, -1);
            int n3 = imageColorVariantsCnt[n2];
            n2 += Math.max(1, n3);
            while (n3 > 1) {
                Utils.readDiffImage(platformResource, imageCache, imageColorVariantsCnt, 0, -1);
                --n3;
            }
            this.updateLoad();
        }
        Sound.readSnd(platformResource);
        this.loadTitle(platformResource);
        platformResource.close();
    }

    protected void loadTitle(PlatformResource platformResource) {
    }

    protected void loadCommon() {
    }

    protected void loadSprites() {
        PlatformResource platformResource = Platform.getResource("/spr");
        short s = platformResource.readShort();
        Sprite.initImageCache(s);
        Sprite.readFragments(platformResource);
        int n = platformResource.readShort();
        Sprite.initDefCache(n);
        Sprite sprite = null;
        for (int i = 0; i < n; ++i) {
            Sprite sprite2 = new Sprite();
            sprite2.cacheIndex = i;
            sprite2.readDef(platformResource);
            if (sprite2.getPathsCount() == 0) {
                if (sprite == null) {
                    sprite = sprite2;
                } else {
                    sprite2 = sprite;
                }
            }
            Sprite.sprites[i] = sprite2;
        }
        platformResource.close();
    }

    protected void enterGame() {
        this.setActiveForm(null);
        bLoadState = true;
        GMain.showBusy();
        Sound.stopSound();
        game = this.createGame();
        game.enterNotify();
        game.showNotify();
        this.runCmd = 3;
        actScreen = 3;
        bLoadState = false;
    }

    protected GameCommon createGame() {
        return null;
    }

    protected void leaveGame() {
        Sound.stopSound();
        this.runCmd = 2;
        actScreen = 2;
        if (game != null) {
            game.leaveNotify();
            game = null;
        }
        Sound.playSound(0);
    }

    protected void resumeGame() {
        this.setActiveForm(null);
        game.showNotify();
        this.runCmd = 3;
        actScreen = 3;
    }

    public void paint() {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        platformGraphics.translate(-platformGraphics.getTranslateX(), -platformGraphics.getTranslateY());
        switch (actScreen) {
            case 1: {
                canvasWidth = Platform.getDisplayWidth();
                canvasHeight = Platform.getDisplayHeight();
                this.drawLoad();
                break;
            }
            case 3: {
                game.paint();
                break;
            }
            case 2: {
                this.drawActiveForm(this.activeForm);
                if (!demoMode) break;
                platformGraphics.drawImage(imageCache[29], 0, 0, 20);
                break;
            }
            case 4: {
                this.drawBusy();
            }
        }
    }

    public void setActiveForm(GForm gForm) {
        if (this.activeForm == gForm) {
            return;
        }
        GForm gForm2 = this.activeForm;
        this.activeForm = null;
        if (gForm2 != null) {
            this.leaveForm(gForm2);
        }
        if (gForm != null) {
            this.enterForm(gForm);
            this.activeForm = gForm;
            if (actScreen == 3) {
                actScreen = 2;
            }
            this.activeForm.setLabels();
        }
    }

    protected void leaveForm(GForm gForm) {
    }

    protected void enterForm(GForm gForm) {
    }

    public static GForm createMenuForm() {
        int n = Utils.getFormHeight(120, 40);
        GForm gForm = new GForm(canvasWidth - 50, n);
        gForm.dx0 = 15;
        gForm.dy0 = 120;
        gForm.contentHeight = gForm.height;
        gForm.anchor = 20;
        gForm.formId = 32;
        gForm.itemListener = instance;
        return gForm;
    }

    public static Item createMenuItem(int n, String[] stringArray) {
        Item item = new Item(0, n);
        item.fontNormal = (byte)3;
        item.fontSelected = (byte)2;
        item.messageTable = stringArray;
        return item;
    }

    public static Item createMenuItem(String string) {
        Item item = new Item(0, string);
        item.fontNormal = (byte)3;
        item.fontSelected = (byte)2;
        return item;
    }

    public static Item createBackItem(int n, GForm gForm) {
        Item item = new Item(3, n);
        item.data = gForm;
        return item;
    }

    protected GForm createSoundEnableForm(GForm gForm) {
        prevSndOpt = GMain.getOption(1);
        GMain.setOption(1, 0);
        Item item = GMain.createBackItem(9, gForm);
        item.inputConstrain = 1;
        GForm gForm2 = this.createYesNoForm(item, gForm, strings[33]);
        gForm2.formId |= 0x1000;
        return gForm2;
    }

    protected GForm createInfoForm(String string, Item item, Item item2) {
        int n = Utils.getFormHeight(30, 60);
        GForm gForm = new GForm(canvasWidth - 50, n);
        gForm.formId |= 0x10;
        gForm.dx0 = canvasWidth >> 1;
        gForm.dy0 = 30;
        gForm.anchor = 17;
        gForm.addMultiText(string);
        gForm.selectSoftCmd = item;
        gForm.backSoftCmd = item2;
        gForm.reset();
        gForm.itemListener = this;
        return gForm;
    }

    protected GForm createYesNoForm(Item item, GForm gForm, String string) {
        Item item2 = null;
        if (gForm != null) {
            item2 = GMain.createBackItem(10, gForm);
        }
        GForm gForm2 = this.createInfoForm(string, item, item2);
        return gForm2;
    }

    protected GForm createBrowserForm(Item item, GForm gForm, String string) {
        Item item2 = null;
        if (gForm != null) {
            item2 = GMain.createBackItem(5, gForm);
        }
        GForm gForm2 = this.createInfoForm(string, item, item2);
        return gForm2;
    }

    public static final int getImageWidth(int n) {
        return imageCache[n].getWidth();
    }

    public static final int getImageHeight(int n) {
        return imageCache[n].getHeight();
    }

    protected GForm createTextForm() {
        int n = Utils.getFormHeight(45, 40);
        GForm gForm = new GForm(canvasWidth - 20, n);
        gForm.formId = 264;
        gForm.anchor = 20;
        gForm.dx0 = 10;
        gForm.dy0 = 45;
        return gForm;
    }

    protected GForm createHelpForm(PlatformResource platformResource, Item item) {
        GForm gForm = this.createTextForm();
        gForm.backSoftCmd = item;
        if (platformResource != null) {
            this.fillTextForm(gForm, platformResource, 1);
        } else {
            this.fillTextForm(gForm, 0, 1);
        }
        return gForm;
    }

    protected GForm createAboutForm(PlatformResource platformResource, Item item) {
        GForm gForm = this.createTextForm();
        gForm.backSoftCmd = item;
        if (demoMode) {
            gForm.addMultiText("DEMO");
        }
        if (platformResource != null) {
            this.fillTextForm(gForm, platformResource, 1);
        } else {
            this.fillTextForm(gForm, 1, 1);
        }
        gForm.addMultiText("");
        gForm.addMultiText(strings[15].concat(": ").concat(VERSION));
        return gForm;
    }

    protected GForm fillTextForm(GForm gForm, int n, int n2) {
        String string = "/l18n";
        if (langCodes != null) {
            string = "/l18n__".concat(langCodes[langIndex]);
        }
        PlatformResource platformResource = Platform.getResource(string);
        platformResource.skipBytes(platformResource.readUnsignedShort());
        platformResource.skipBytes(platformResource.readUnsignedShort());
        platformResource.skipBytes(platformResource.readUnsignedShort());
        for (int i = 0; i < n; ++i) {
            platformResource.skipBytes(platformResource.readUnsignedShort());
        }
        platformResource.readUnsignedShort();
        this.fillTextForm(gForm, platformResource, n2);
        platformResource.close();
        return gForm;
    }

    protected GForm fillTextForm(GForm gForm, PlatformResource platformResource, int n) {
        if (n == 1) {
            int n2 = platformResource.readShort();
            while (n2-- > 0) {
                String string = platformResource.readUTF();
                this.fillTextForm(gForm, string);
            }
        } else {
            Vector[] vectorArray = new Vector[n];
            for (int i = 0; i < n; ++i) {
                int n3 = platformResource.readShort();
                while (n3-- > 0) {
                    String string = platformResource.readUTF();
                    this.fillTextForm(gForm, string);
                }
                vectorArray[i] = gForm.items;
                if (i + 1 >= n) continue;
                gForm.items = new Vector();
            }
            gForm.sections = vectorArray;
            gForm.actualSection = 0;
            gForm.scrollableLeft = false;
            gForm.scrollableRight = true;
            gForm.items = vectorArray[0];
        }
        gForm.reset();
        return gForm;
    }

    protected void fillTextForm(GForm gForm, String string) {
        gForm.addMultiText(string);
    }

    protected Item createImageItem(GForm gForm, int n) {
        return null;
    }

    protected GForm createLangForm() {
        Object object;
        int n = Utils.getFormHeight(120, 40);
        GForm gForm = new GForm(canvasWidth - 50, n);
        gForm.formId |= 0xA20;
        gForm.anchor = 20;
        gForm.dx0 = canvasWidth / 8;
        gForm.dy0 = 120;
        int n2 = 0;
        for (int i = 0; i < langCodes.length; ++i) {
            Item item;
            object = Platform.createImage(0, "/lp__".concat(langCodes[i]));
            Platform.assertTrue(object != null, "GMain.createLangForm");
            if (object != null) {
                int n3 = ((PlatformImage)object).getHeight();
                n2 = Math.max(n2, n3);
                item = gForm.addItem(new Item(0, (PlatformImage)object));
            } else {
                item = gForm.addItem(new Item(0, langCodes[i]));
            }
            item.inputConstrain = (byte)i;
        }
        PlatformImage platformImage = Platform.createImage(0, "/lpok");
        gForm.selectSoftCmd = object = new Item(4, platformImage);
        gForm.itemListener = this;
        gForm.reset();
        gForm.label = -1;
        return gForm;
    }

    protected GForm createInitialProfileForm() {
        return this.getInitialForm();
    }

    protected void showAbout(Item item) {
        this.setActiveForm(this.createAboutForm(null, item));
    }

    protected GForm showHelp(Item item) {
        GForm gForm = this.createHelpForm(null, item);
        this.setActiveForm(gForm);
        return gForm;
    }

    protected void drawActiveForm(GForm gForm) {
        if (gForm == null) {
            return;
        }
        if (gForm.contentHeight < 0) {
            this.initFormContent(gForm);
        }
        this.drawFormBackground(gForm, false);
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        platformGraphics.setClip(0, 0, canvasWidth, canvasHeight);
        gForm.paint(platformGraphics);
        platformGraphics.translate(-platformGraphics.getTranslateX(), -platformGraphics.getTranslateY());
    }

    protected void initFormContent(GForm gForm) {
        gForm.contentHeight = gForm.height;
        gForm.reset();
    }

    protected void drawFormBackground(GForm gForm, boolean bl) {
    }

    public void drawArrows(GForm gForm, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
    }

    public void loadRms(int n) {
        byte[] byArray = Platform.readRecord(n);
        ByteArrayBuffer byteArrayBuffer = null;
        if (byArray != null) {
            byteArrayBuffer = new ByteArrayBuffer();
            byteArrayBuffer.set(byArray, 0, byArray.length);
        }
        this.readRms(n, byteArrayBuffer);
    }

    public void saveRms(int n) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
        byte[] byArray = new byte[1024];
        byteArrayBuffer.set(byArray, 0, byArray.length);
        this.writeRms(n, byteArrayBuffer);
        Platform.writeRecord(n, byArray, byteArrayBuffer.getPosition());
    }

    protected void readRms(int n, ByteArrayBuffer byteArrayBuffer) {
    }

    protected void writeRms(int n, ByteArrayBuffer byteArrayBuffer) {
    }

    protected void updateLanguage() {
        String string = "/l18n";
        if (langCodes != null) {
            string = "/l18n__".concat(langCodes[langIndex]);
        }
        PlatformResource platformResource = Platform.getResource(string);
        this.updateLanguage(platformResource);
        platformResource.close();
        GForm gForm = this.activeForm;
        if (gForm != null) {
            gForm.setLabels();
        }
    }

    protected void updateLanguage(PlatformResource platformResource) {
        platformResource.readShort();
        int n = platformResource.readUnsignedShort();
        if (imageCacheL18N == null) {
            imageCacheL18N = new PlatformImage[n];
            imageColorVariantsCntL18N = new byte[n];
        }
        for (int i = 0; i < n; ++i) {
            GMain.imageCacheL18N[i] = null;
            GMain.imageColorVariantsCntL18N[i] = 0;
        }
        Utils.readImages(platformResource, imageCacheL18N, imageColorVariantsCntL18N, n);
        platformResource.readShort();
        strings = GMain.updateLanguage(strings, platformResource);
        GMain.strings[50] = strings[47] + " / " + strings[48];
        GMain.strings[51] = "//";
        GMain.strings[52] = "////";
        GMain.strings[53] = "//////";
        platformResource.readShort();
        this.readMessages(platformResource);
    }

    protected void readMessages(PlatformResource platformResource) {
    }

    public static String[] updateLanguage(String[] stringArray, PlatformResource platformResource) {
        String[] stringArray2 = Utils.readStrings(platformResource);
        if (stringArray == null) {
            stringArray = stringArray2;
        } else {
            Platform.assertTrue(stringArray.length == stringArray2.length, "illegal messages: old=" + stringArray.length + " new=" + stringArray2.length);
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray[i] = stringArray2[i];
            }
        }
        return stringArray;
    }

    protected void controlActiveForm(GForm gForm, int n) {
        if (gForm == null) {
            return;
        }
        if (gForm.sections != null) {
            if (n == 20 || n == 19 || n == 5 || n == 7) {
                if (n == 20 || n == 7) {
                    if (gForm.scrollableRight) {
                        gForm.scrollableLeft = true;
                        gForm.scrollableRight = ++gForm.actualSection != gForm.sections.length - 1;
                    }
                } else if (gForm.scrollableLeft) {
                    gForm.scrollableRight = true;
                    gForm.scrollableLeft = --gForm.actualSection != 0;
                }
                gForm.items = gForm.sections[gForm.actualSection];
                gForm.reset();
            } else {
                gForm.keyPressed(n);
            }
        } else {
            gForm.keyPressed(n);
        }
    }

    protected static void showBusy() {
        int n = actScreen;
        actScreen = 4;
        Platform.redraw();
        actScreen = n;
    }

    protected void drawBusy() {
    }

    protected boolean processCheat(int n, int n2) {
        return true;
    }

    protected boolean processUserCheat(int n, int n2) {
        return true;
    }

    protected GForm getInitialForm() {
        return this.createSoundEnableForm(this.mainMenu);
    }

    protected abstract GForm createMainMenu();

    protected abstract void actionPerformed(Item var1, GForm var2);

    protected void drawItem(GForm gForm, Item item, int n) {
    }

    protected abstract void selectionChanged(GForm var1, Item var2, Item var3);

    private static String getPropertyURL(String string) {
        if (!string.startsWith("jad:")) {
            return string;
        }
        int n = (string = string.substring("jad:".length())).lastIndexOf(124);
        if (n == -1 || string.substring(n + 1).trim().length() == 0) {
            String string2 = n == -1 ? string : string.substring(0, n);
            String string3 = Platform.getManifestProperty(string2);
            return string3;
        }
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + 1);
        String string6 = Platform.getManifestProperty(string4);
        if (string6 == null) {
            return null;
        }
        String string7 = string5 + "&url=" + GMain.encodeURL(string6);
        if (string7.length() > 128) {
            return string6;
        }
        return string7;
    }

    private static String encodeURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                stringBuffer.append("+");
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                stringBuffer.append(c);
                continue;
            }
            if (c == '-' || c == '_' || c == '.') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("%");
            stringBuffer.append(Utils.itoa(c, 16));
        }
        return stringBuffer.toString();
    }

    public static void setOption(int n, int n2) {
        byte by = options[n];
        GMain.options[n] = (byte)n2;
        if (n == 1) {
            if (n2 == 0) {
                Sound.stopSound();
            } else {
                Sound.setVolume(n2);
                if (game == null && by == 0) {
                    Sound.playSound(0);
                }
            }
        }
        if (n == 2 && options[1] > 0) {
            if (by == 1 && (n2 == 0 || n2 == 2) && game == null) {
                Sound.playSound(0);
            }
            if (n2 == 1 && (by == 0 || by == 2)) {
                Sound.stopSound();
            }
        }
    }

    public static final byte getOption(int n) {
        return options[n];
    }

    static {
        bLoadState = false;
        lastPointerX = -1;
        lastPointerY = -1;
        numbersLang = -1;
        langIndex = -1;
        prevSndOpt = (byte)-1;
        options = new byte[]{0, 0, 0, 0, 0, 1, 0};
    }
}

