/*
 * Decompiled with CFR 0.152.
 */
public class OthelloBoard {
    private static final int CNT_PILLAR = 8;
    private static final int CNT_LINES = 8;
    private int FORFEIT_WEIGHT = 40;
    private int FRONTIER_WEIGHT = 5;
    private int MOBILITY_WEIGHT = 20;
    private int STABILITY_WEIGHT = 30;
    private int COVERING_WEIGHT = 5;
    private int[][] myGrid = new int[8][8];
    private boolean[][] isStable = new boolean[8][8];
    private int player;
    private int computer;
    private int level;
    public int stoneCount;

    public OthelloBoard(int n, int n2, int n3) {
        this.level = n;
        this.player = n2;
        this.computer = n3;
    }

    public void copyFrom(byte[] byArray) {
        this.stoneCount = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n;
                this.myGrid[j][i] = n = byArray[i * 8 + j];
                if (n == 0) continue;
                ++this.stoneCount;
            }
        }
    }

    public void copyFrom(OthelloBoard othelloBoard) {
        for (int i = 0; i < 8; ++i) {
            this.myGrid[i] = OthelloBoard.arrayCopyInt(othelloBoard.myGrid[i], 0, this.myGrid[i], 0, 8);
            this.isStable[i] = OthelloBoard.arrayCopyBoolean(othelloBoard.isStable[i], 0, this.isStable[i], 0, 8);
        }
    }

    private void updateStats() {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    if (this.myGrid[i][j] == 0 || this.isStable[i][j] || this.isOutflankable(i, j)) continue;
                    bl = true;
                    this.isStable[i][j] = true;
                }
            }
        }
    }

    private boolean canFlip(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 == 0 && n4 == 0) {
            return false;
        }
        int n7 = 0;
        do {
            ++n7;
            if ((n += n3) >= 0 && n < 8 && (n2 += n4) >= 0 && n2 < 8) continue;
            return false;
        } while (this.myGrid[n][n2] == n6);
        return n7 > 1 && this.myGrid[n][n2] == n5;
    }

    public boolean canMove(int n, int n2, int n3, int n4) {
        if (this.myGrid[n][n2] == 0) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (!this.canFlip(n, n2, i, j, n3, n4)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void doMove(int n, int n2, int n3, int n4) {
        if (this.myGrid[n][n2] == 0) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    if (!this.canFlip(n, n2, i, j, n3, n4)) continue;
                    int n5 = n;
                    int n6 = n2;
                    do {
                        this.myGrid[n5][n6] = n3;
                    } while (this.myGrid[n5 += i][n6 += j] != n3);
                }
            }
        }
        this.updateStats();
    }

    private boolean isFrontier(int n, int n2) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (i == 0 && j == 0) continue;
                int n3 = n + i;
                int n4 = n2 + j;
                if (n3 < 0 || n4 < 0 || n3 >= 8 || n4 >= 8 || this.myGrid[n3][n4] != 0) continue;
                return true;
            }
        }
        return false;
    }

    public int evaluate2() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (n = 0; n < 8; ++n) {
            boolean bl = n == 0 || n == 7;
            for (int i = 0; i < 8; ++i) {
                boolean bl2;
                int n12 = this.myGrid[n][i];
                if (n12 == 0) {
                    if (this.canMove(n, i, this.computer, this.player)) {
                        n10 = 1;
                        ++n5;
                    }
                    if (!this.canMove(n, i, this.player, this.computer)) continue;
                    n11 = 1;
                    ++n4;
                    continue;
                }
                boolean bl3 = bl2 = bl && (i == 0 || i == 7);
                if (n12 == this.player) {
                    ++n2;
                    if (this.isFrontier(n, i)) {
                        ++n7;
                    }
                    if (!this.isStable[n][i]) continue;
                    ++n9;
                    if (!bl2) continue;
                    ++n9;
                    continue;
                }
                if (n12 != this.computer) continue;
                ++n3;
                if (this.isFrontier(n, i)) {
                    ++n6;
                }
                if (!this.isStable[n][i]) continue;
                ++n8;
                if (!bl2) continue;
                ++n8;
            }
        }
        n = this.MOBILITY_WEIGHT * (n5 - n4) + this.COVERING_WEIGHT * (n3 - n2) + this.FRONTIER_WEIGHT * (n7 - n6) + this.STABILITY_WEIGHT * (n8 - n9) + this.FORFEIT_WEIGHT * (n10 - n11);
        return this.level % 2 == 0 ? n : -n;
    }

    private boolean isOutflankable(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.myGrid[n][n2];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (n4 = 0; n4 < n2 && !bl; ++n4) {
            if (this.myGrid[n][n4] == 0) {
                bl = true;
                continue;
            }
            if (this.myGrid[n][n4] == n5 && this.isStable[n][n4]) continue;
            bl2 = true;
        }
        for (n4 = n2 + 1; n4 < 8 && !bl3; ++n4) {
            if (this.myGrid[n][n4] == 0) {
                bl3 = true;
                continue;
            }
            if (this.myGrid[n][n4] == n5 && this.isStable[n][n4]) continue;
            bl4 = true;
        }
        if (bl && bl3 || bl && bl4 || bl2 && bl3) {
            return true;
        }
        bl = false;
        bl3 = false;
        bl2 = false;
        bl4 = false;
        for (n3 = 0; n3 < n && !bl; ++n3) {
            if (this.myGrid[n3][n2] == 0) {
                bl = true;
                continue;
            }
            if (this.myGrid[n3][n2] == n5 && this.isStable[n3][n2]) continue;
            bl2 = true;
        }
        for (n3 = n + 1; n3 < 8 && !bl3; ++n3) {
            if (this.myGrid[n3][n2] == 0) {
                bl3 = true;
                continue;
            }
            if (this.myGrid[n3][n2] == n5 && this.isStable[n3][n2]) continue;
            bl4 = true;
        }
        if (bl && bl3 || bl && bl4 || bl2 && bl3) {
            return true;
        }
        bl = false;
        bl3 = false;
        bl2 = false;
        bl4 = false;
        n3 = n - 1;
        for (n4 = n2 - 1; n3 >= 0 && n4 >= 0 && !bl; --n3, --n4) {
            if (this.myGrid[n3][n4] == 0) {
                bl = true;
                continue;
            }
            if (this.myGrid[n3][n4] == n5 && this.isStable[n3][n4]) continue;
            bl2 = true;
        }
        n3 = n + 1;
        for (n4 = n2 + 1; n3 < 8 && n4 < 8 && !bl3; ++n3, ++n4) {
            if (this.myGrid[n3][n4] == 0) {
                bl3 = true;
                continue;
            }
            if (this.myGrid[n3][n4] == n5 && this.isStable[n3][n4]) continue;
            bl4 = true;
        }
        if (bl && bl3 || bl && bl4 || bl2 && bl3) {
            return true;
        }
        bl = false;
        bl3 = false;
        bl2 = false;
        bl4 = false;
        n3 = n - 1;
        for (n4 = n2 + 1; n3 >= 0 && n4 < 8 && !bl; --n3, ++n4) {
            if (this.myGrid[n3][n4] == 0) {
                bl = true;
                continue;
            }
            if (this.myGrid[n3][n4] == n5 && this.isStable[n3][n4]) continue;
            bl2 = true;
        }
        n3 = n + 1;
        for (n4 = n2 - 1; n3 < 8 && n4 >= 0 && !bl3; ++n3, --n4) {
            if (this.myGrid[n3][n4] == 0) {
                bl3 = true;
                continue;
            }
            if (this.myGrid[n3][n4] == n5 && this.isStable[n3][n4]) continue;
            bl4 = true;
        }
        return bl && bl3 || bl && bl4 || bl2 && bl3;
    }

    public static boolean[] arrayCopyBoolean(boolean[] blArray, int n, boolean[] blArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            blArray2[n2 + i] = blArray[n + i];
        }
        return blArray2;
    }

    public static int[] arrayCopyInt(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray2[n2 + i] = nArray[n + i];
        }
        return nArray2;
    }
}

