/*
 * Decompiled with CFR 0.152.
 */
public abstract class GameCommon {
    public static final int MIN_SLEEP = 0;
    public static final int MIN_ELAPSED_TIME = 71;
    public static final int MAX_ELAPSED_TIME = 125;
    public static final int MASK_UNDEF = 0;
    public static final int MASK_FIRE = 1;
    public static final int MASK_LEFT = 3;
    public static final int MASK_RIGHT = 4;
    public static final int MASK_UP = 5;
    public static final int MASK_DOWN = 6;
    public static final int MASK_LSK = 7;
    public static final int MASK_NULL = 8;
    public static final int KEY_NONE = 0;
    public static final int KEY_FIRE = 2;
    public static final int KEY_LEFT = 8;
    public static final int KEY_RIGHT = 16;
    public static final int KEY_UP = 32;
    public static final int KEY_DOWN = 64;
    public static final int KEY_LSK = 128;
    public static final int KEY_NULL = 256;
    public static final int G_STATE_NULL = 0;
    public static final int G_STATE_LOAD = 1;
    public static final int G_STATE_PLAY = 10;
    public static final int G_STATE_SCORESCREEN = 90;
    public static final int G_STATE_ENDSCREEN = 95;
    public static final int G_STATE_END = 99;
    public static final int PRECISION = 16;
    public static int level;
    public static int levelCount;
    public static int keyCode;
    public static int keyLast;
    public static int keyStates;
    public static boolean keyBlock;
    public static int quitStatus;
    public static boolean paused;
    public static int gameState;
    public static int soundEvent;
    public static int deskX;
    public static int deskY;
    public static int deskW;
    public static int deskW_2;
    public static int deskH;
    public static int deskH_2;
    public static final int MENU_FRAME_LEFT_TOP = 0;
    public static final int MENU_FRAME_TOP = 1;
    public static final int MENU_FRAME_RIGHT_TOP = 2;
    public static final int MENU_FRAME_LEFT = 3;
    public static final int MENU_FRAME_FILL = 4;
    public static final int MENU_FRAME_RIGHT = 5;
    public static final int MENU_FRAME_LEFT_BOTTOM = 6;
    public static final int MENU_FRAME_BOTTOM = 7;
    public static final int MENU_FRAME_RIGHT_BOTTOM = 8;
    public static final int MENU_FRAME_X_COUNT = 3;
    public static final int MENU_FRAME_Y_COUNT = 3;
    public static final int SPRITE_EA_RESPAWN = 1;
    public static final int SPRITE_EA_HIDE = 2;
    public static final int SPRITE_EA_PLAYNEXT = 4;
    public static final int SPRITE_EA_PLAYFIRST = 8;
    public static final int SPRITE_EA_ROTATE = 16;

    public void keyPressed(int n) {
        if (keyBlock) {
            return;
        }
        if (n == 13) {
            n = 15;
        }
        keyCode = n;
        if (n == 15) {
            if (this.canPause()) {
                paused = true;
                keyStates = 0;
                keyLast = 0;
                n = 0;
                return;
            }
            keyLast = 2;
            keyStates |= 1;
            return;
        }
        if (n == 14) {
            keyLast = 128;
            keyStates |= 7;
            return;
        }
        keyLast = this.mapKeyAction(n);
        int n2 = this.mapKeyMask(n);
        keyStates |= n2;
    }

    protected boolean canPause() {
        return true;
    }

    public void restartThis() {
    }

    public void keyReleased(int n) {
        if (keyBlock) {
            return;
        }
        int n2 = this.mapKeyMask(n);
        keyStates &= ~n2;
    }

    private int mapKeyAction(int n) {
        switch (n) {
            case 6: 
            case 16: {
                return 2;
            }
            case 5: 
            case 19: {
                return 8;
            }
            case 7: 
            case 20: {
                return 16;
            }
            case 3: 
            case 17: {
                return 32;
            }
            case 9: 
            case 18: {
                return 64;
            }
            case 2: {
                return 40;
            }
            case 8: {
                return 72;
            }
            case 4: {
                return 48;
            }
            case 10: {
                return 80;
            }
            case 1: {
                return 256;
            }
        }
        return 0;
    }

    private int mapKeyMask(int n) {
        switch (n) {
            case 6: 
            case 16: {
                return 2;
            }
            case 5: 
            case 19: {
                return 8;
            }
            case 7: 
            case 20: {
                return 16;
            }
            case 3: 
            case 17: {
                return 32;
            }
            case 9: 
            case 18: {
                return 64;
            }
            case 2: {
                return 40;
            }
            case 8: {
                return 72;
            }
            case 4: {
                return 48;
            }
            case 10: {
                return 80;
            }
            case 1: {
                return 256;
            }
        }
        return 0;
    }

    public static int clock() {
        return (int)Platform.clock();
    }

    protected void hideNotify() {
        paused = true;
        keyLast = 0;
        keyCode = 0;
        keyStates = 0;
    }

    protected void showNotify() {
        keyLast = 0;
        keyCode = 0;
        keyStates = 0;
        paused = false;
        this.initSound();
    }

    public void processCheat(int n) {
    }

    public boolean evolve() {
        int n = GameCommon.clock();
        this.update();
        if (!paused) {
            this.updateSound();
            Platform.redraw();
            int n2 = GameCommon.clock() - n;
            int n3 = 71 - n2;
            if (n3 > 0) {
                n3 = Math.min(71, n3);
                Platform.sleep(n3);
            } else {
                Platform.sleep(0);
            }
        }
        return quitStatus != 0;
    }

    public void paint() {
        this.draw();
    }

    protected void draw() {
    }

    public void quit(int n) {
        quitStatus = n;
    }

    public void enterNotify() {
        quitStatus = 0;
    }

    public void leaveNotify() {
    }

    public abstract void update();

    protected void initSound() {
        soundEvent = 1;
    }

    private void updateSound() {
        if (soundEvent != -1) {
            Sound.playSound(soundEvent);
            soundEvent = -1;
        }
    }

    public void loadLevel(int n) {
        long l = Platform.clock();
        PlatformResource platformResource = Platform.getResource("/l" + n);
        this.loadLevel(platformResource);
        platformResource.close();
        while (Platform.clock() - l < 1999L) {
            Platform.sleep(300);
        }
        keyCode = 0;
        keyLast = 0;
        keyStates = 0;
    }

    protected void loadLevel(PlatformResource platformResource) {
    }

    public static void markResource(int n, boolean bl) {
        if (bl) {
            Sprite.acquire(n);
        } else {
            Sprite.release(n);
        }
    }

    public static void markResources(int[] nArray, boolean bl) {
        if (bl) {
            for (int i = 0; i < nArray.length; ++i) {
                Sprite.acquire(nArray[i]);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                Sprite.release(nArray[i]);
            }
        }
    }

    public static void drawMenuFrameImage(PlatformImage platformImage, int n, int n2, int n3, int n4, boolean bl) {
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        int n5 = GMain.canvasWidth;
        int n6 = GMain.canvasHeight;
        platformGraphics.setClip(0, 0, n5, n6);
        int n7 = platformImage.getWidth() / 3;
        int n8 = platformImage.getHeight() / 3;
        int n9 = n7;
        int n10 = n8;
        int n11 = n7;
        int n12 = n8;
        if (bl) {
            Utils.drawPattern(n, n2, n3, n4, platformImage, 1 * n7, 1 * n8, n7, n8);
        }
        Utils.drawPattern(n, n2 - n10, n3, n10, platformImage, 1 * n7, 0 * n8, n7, n8);
        Utils.drawPattern(n, n2 + n4, n3, n10, platformImage, 1 * n7, 2 * n8, n7, n8);
        Utils.drawPattern(n - n9, n2, n9, n4, platformImage, 0 * n7, 1 * n8, n7, n8);
        Utils.drawPattern(n + n3, n2, n9, n4, platformImage, 2 * n7, 1 * n8, n7, n8);
        Utils.drawRegion(platformImage, 0 * n7, 0 * n8, n7, n8, n - n11, n2 - n12, 0);
        Utils.drawRegion(platformImage, 2 * n7, 0 * n8, n7, n8, n + n3, n2 - n12, 0);
        Utils.drawRegion(platformImage, 0 * n7, 2 * n8, n7, n8, n - n11, n2 + n4, 0);
        Utils.drawRegion(platformImage, 2 * n7, 2 * n8, n7, n8, n + n3, n2 + n4, 0);
    }

    public void pathEnded(Sprite sprite, int n, int n2) {
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                sprite.visible = false;
                break;
            }
            case 8: {
                sprite.startPath(0);
                break;
            }
            case 4: {
                sprite.startPath(n + 1);
                break;
            }
        }
    }

    static {
        keyBlock = false;
    }
}

